package com.ejie.aa20b.service;

import com.ejie.aa20b.dao.DepartamentosDao;
import com.ejie.x38.dto.Pagination;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.Departamentos;

/**
 * DepartamentosServiceImpl generated by UDA, 28-nov-2014 11:32:16.
 * 
 * @author UDA
 */

@Service(value = "departamentosService")
public class DepartamentosServiceImpl implements DepartamentosService {

	@Autowired
	private DepartamentosDao departamentosDao;

	/**
	 * Inserts a single row in the Departamentos table.
	 * 
	 * @param departamentos
	 *            Departamentos
	 * @return Departamentos
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Departamentos add(Departamentos departamentos) {
		return this.departamentosDao.add(departamentos);
	}

	/**
	 * Updates a single row in the Departamentos table.
	 * 
	 * @param departamentos
	 *            Departamentos
	 * @return Departamentos
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Departamentos update(Departamentos departamentos) {
		return this.departamentosDao.update(departamentos);
	}

	/**
	 * Dar de baja el dpto.
	 * 
	 * @param departamentos
	 *            Departamentos
	 * @return Departamentos
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Departamentos darBajaDpto(Departamentos departamentos) {
		return this.departamentosDao.darBajaDpto(departamentos);
	}

	/**
	 * Finds a single row in the Departamentos table.
	 * 
	 * @param departamentos
	 *            Departamentos
	 * @return Departamentos
	 */
	public Departamentos find(Departamentos departamentos) {
		return (Departamentos) this.departamentosDao.find(departamentos);
	}

	/**
	 * Finds a List of rows in the Departamentos table.
	 * 
	 * @param departamentos
	 *            Departamentos
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Departamentos> findAll(Departamentos departamentos,
			Pagination pagination) {
		return (List<Departamentos>) this.departamentosDao.findAll(
				departamentos, pagination);
	}

	/**
	 * Counts rows in the Departamentos table.
	 * 
	 * @param departamentos
	 *            Departamentos
	 * @return Long
	 */
	public Long findAllCount(Departamentos departamentos) {
		return this.departamentosDao.findAllCount(departamentos);
	}

	/**
	 * Finds rows in the Departamentos table using like.
	 * 
	 * @param departamentos
	 *            Departamentos
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Departamentos> findAllLike(Departamentos departamentos,
			Pagination pagination, Boolean startsWith) {
		return (List<Departamentos>) this.departamentosDao.findAllLike(
				departamentos, pagination, startsWith);
	}

	/**
	 * Counts rows in the Departamentos table using like.
	 * 
	 * @param departamentos
	 *            Departamentos
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Departamentos departamentos, Boolean startsWith) {
		return this.departamentosDao
				.findAllLikeCount(departamentos, startsWith);
	}

	/**
	 * Deletes a single row in the Departamentos table.
	 * 
	 * @param departamentos
	 *            Departamentos
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Departamentos departamentos) {
		this.departamentosDao.remove(departamentos);
	}

	/**
	 * Deletes multiple rows in the Departamentos table.
	 * 
	 * @param departamentosList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Departamentos> departamentosList) {
		for (Departamentos departamentosAux : departamentosList) {
			this.departamentosDao.remove(departamentosAux);
		}
	}

	/**
	 * Si no existe el departamento lo da de alta.
	 * 
	 * @param codDpto
	 *            String
	 * @return Long
	 */
	public Long altaExisteDepartamento(Departamentos depto) {
		return this.departamentosDao.altaExisteDepartamento(depto);
	}

	/**
	 * obtener el iddepar asociado a un cidepar.
	 * 
	 * @param cidepar
	 *            String
	 * @return Long
	 */
	public Long obtenerIddepar(String cidepar) {

		return this.departamentosDao.obtenerIddepar(cidepar);

	}

}
