package com.ejie.aa20b.service;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.aa20b.model.Departamentos;

/**
 * DepartamentosService generated by UDA, 28-nov-2014 11:32:16.
 * 
 * @author UDA
 */

public interface DepartamentosService {

	/**
	 * Inserts a single row in the Departamentos table.
	 * 
	 * @param departamentos
	 *            Departamentos
	 * @return Departamentos
	 */
	Departamentos add(Departamentos departamentos);

	/**
	 * Updates a single row in the Departamentos table.
	 * 
	 * @param departamentos
	 *            Departamentos
	 * @return Departamentos
	 */
	Departamentos update(Departamentos departamentos);

	/**
	 * Dar de baja el dpto.
	 * 
	 * @param departamentos
	 *            Departamentos
	 * @return Departamentos
	 */
	Departamentos darBajaDpto(Departamentos departamentos);

	/**
	 * Finds a single row in the Departamentos table.
	 * 
	 * @param departamentos
	 *            Departamentos
	 * @return Departamentos
	 */
	Departamentos find(Departamentos departamentos);

	/**
	 * Finds a List of rows in the Departamentos table.
	 * 
	 * @param departamentos
	 *            Departamentos
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Departamentos> findAll(Departamentos departamentos,
			Pagination pagination);

	/**
	 * Counts rows in the Departamentos table.
	 * 
	 * @param departamentos
	 *            Departamentos
	 * @return Long
	 */
	Long findAllCount(Departamentos departamentos);

	/**
	 * Finds rows in the Departamentos table using like.
	 * 
	 * @param departamentos
	 *            Departamentos
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Departamentos> findAllLike(Departamentos departamentos,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Departamentos table using like.
	 * 
	 * @param departamentos
	 *            Departamentos
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Departamentos departamentos, Boolean startsWith);

	/**
	 * Deletes a single row in the Departamentos table.
	 * 
	 * @param departamentos
	 *            Departamentos
	 * @return
	 */
	void remove(Departamentos departamentos);

	/**
	 * Deletes multiple rows in the Departamentos table.
	 * 
	 * @param departamentosList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Departamentos> departamentosList);

	/**
	 * Si no existe el departamento lo da de alta.
	 * 
	 * @param depto
	 *            Departamentos
	 * @return Long
	 */
	public Long altaExisteDepartamento(Departamentos depto);

	/**
	 * obtener el iddepar asociado a un cidepar.
	 * 
	 * @param cidepar
	 *            String
	 * @return Long
	 */
	Long obtenerIddepar(String cidepar);
}
