package com.ejie.aa20b.service;

import com.ejie.aa20b.dao.ActuacionDao;
import com.ejie.aa20b.dao.CuestionarioDao;
import com.ejie.x38.dto.Pagination;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.Cuestionario;

/**
 * CuestionarioServiceImpl generated by UDA, 02-mar-2015 11:32:36.
 * 
 * @author UDA
 */

@Service(value = "cuestionarioService")
public class CuestionarioServiceImpl implements CuestionarioService {

	@Autowired
	private CuestionarioDao cuestionarioDao;

	@Autowired
	private ActuacionDao actuacionDao;

	/**
	 * Inserts a single row in the Cuestionario table.
	 * 
	 * @param cuestionario
	 *            Cuestionario
	 * @return Cuestionario
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Cuestionario add(Cuestionario cuestionario) {
		return this.cuestionarioDao.add(cuestionario);
	}

	/**
	 * Updates a single row in the Cuestionario table.
	 * 
	 * @param cuestionario
	 *            Cuestionario
	 * @return Cuestionario
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Cuestionario update(Cuestionario cuestionario) {
		return this.cuestionarioDao.update(cuestionario);
	}

	/**
	 * Finds a single row in the Cuestionario table.
	 * 
	 * @param cuestionario
	 *            Cuestionario
	 * @return Cuestionario
	 */
	public Cuestionario find(Cuestionario cuestionario) {
		return (Cuestionario) this.cuestionarioDao.find(cuestionario);
	}

	/**
	 * Finds a List of rows in the Cuestionario table.
	 * 
	 * @param cuestionario
	 *            Cuestionario
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Cuestionario> findAll(Cuestionario cuestionario,
			Pagination pagination) {
		return (List<Cuestionario>) this.cuestionarioDao.findAll(cuestionario,
				pagination);
	}

	/**
	 * Counts rows in the Cuestionario table.
	 * 
	 * @param cuestionario
	 *            Cuestionario
	 * @return Long
	 */
	public Long findAllCount(Cuestionario cuestionario) {
		return this.cuestionarioDao.findAllCount(cuestionario);
	}

	/**
	 * Finds rows in the Cuestionario table using like.
	 * 
	 * @param cuestionario
	 *            Cuestionario
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Cuestionario> findAllLike(Cuestionario cuestionario,
			Pagination pagination, Boolean startsWith) {
		return (List<Cuestionario>) this.cuestionarioDao.findAllLike(
				cuestionario, pagination, startsWith);
	}

	/**
	 * Counts rows in the Cuestionario table using like.
	 * 
	 * @param cuestionario
	 *            Cuestionario
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Cuestionario cuestionario, Boolean startsWith) {
		return this.cuestionarioDao.findAllLikeCount(cuestionario, startsWith);
	}

	/**
	 * Deletes a single row in the Cuestionario table.
	 * 
	 * @param cuestionario
	 *            Cuestionario
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Cuestionario cuestionario) {
		this.cuestionarioDao.remove(cuestionario);
	}

	/**
	 * Deletes a single row in the Cuestionario table.
	 * 
	 * @param cuestionario
	 *            Cuestionario
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public String eliminarCuestionario(Cuestionario cuestionario) {
		// Antes de eliminar comprobar que no existe un registro en la tabla
		// ACTUACION para este idcuestionario

		if (this.actuacionDao.cuestionarioTieneActuaciones(cuestionario
				.getIdcuestionario())) {
			return "tieneActuaciones";
		} else {
			this.cuestionarioDao.remove(cuestionario);
			return "ok";
		}

	}

	/**
	 * Deletes multiple rows in the Cuestionario table.
	 * 
	 * @param cuestionarioList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Cuestionario> cuestionarioList) {
		for (Cuestionario cuestionarioAux : cuestionarioList) {
			this.cuestionarioDao.remove(cuestionarioAux);
		}
	}

	/**
	 * obtener el número de orden máximo para una gama dada.
	 * 
	 * @param idGama
	 *            Long
	 * @return Long
	 */
	public Long obtenerMaxOrdenGama(Long idGama) {
		return this.cuestionarioDao.obtenerMaxOrdenGama(idGama);
	}
}
