package com.ejie.aa20b.service;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.aa20b.model.Cuestionario;

/**
 * CuestionarioService generated by UDA, 02-mar-2015 11:32:36.
 * 
 * @author UDA
 */

public interface CuestionarioService {

	/**
	 * Inserts a single row in the Cuestionario table.
	 * 
	 * @param cuestionario
	 *            Cuestionario
	 * @return Cuestionario
	 */
	Cuestionario add(Cuestionario cuestionario);

	/**
	 * Updates a single row in the Cuestionario table.
	 * 
	 * @param cuestionario
	 *            Cuestionario
	 * @return Cuestionario
	 */
	Cuestionario update(Cuestionario cuestionario);

	/**
	 * Finds a single row in the Cuestionario table.
	 * 
	 * @param cuestionario
	 *            Cuestionario
	 * @return Cuestionario
	 */
	Cuestionario find(Cuestionario cuestionario);

	/**
	 * Finds a List of rows in the Cuestionario table.
	 * 
	 * @param cuestionario
	 *            Cuestionario
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Cuestionario> findAll(Cuestionario cuestionario, Pagination pagination);

	/**
	 * Counts rows in the Cuestionario table.
	 * 
	 * @param cuestionario
	 *            Cuestionario
	 * @return Long
	 */
	Long findAllCount(Cuestionario cuestionario);

	/**
	 * Finds rows in the Cuestionario table using like.
	 * 
	 * @param cuestionario
	 *            Cuestionario
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Cuestionario> findAllLike(Cuestionario cuestionario,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Cuestionario table using like.
	 * 
	 * @param cuestionario
	 *            Cuestionario
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Cuestionario cuestionario, Boolean startsWith);

	/**
	 * Deletes a single row in the Cuestionario table.
	 * 
	 * @param cuestionario
	 *            Cuestionario
	 * @return
	 */
	void remove(Cuestionario cuestionario);

	/**
	 * Deletes multiple rows in the Cuestionario table.
	 * 
	 * @param cuestionarioList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Cuestionario> cuestionarioList);

	/**
	 * obtener el número de orden máximo para una gama dada.
	 * 
	 * @param idGama
	 *            Long
	 * @return Long
	 */
	Long obtenerMaxOrdenGama(Long idGama);

	/**
	 * Deletes a single row in the Cuestionario table.
	 * 
	 * @param cuestionario
	 *            Cuestionario
	 * @return
	 */
	String eliminarCuestionario(Cuestionario cuestionario);

}
