package com.ejie.aa20b.service;

import com.ejie.aa20b.dao.CodigoDao;
import com.ejie.x38.dto.Pagination;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.Codigo;

/**
 * CodigoServiceImpl generated by UDA, 28-nov-2014 12:22:02.
 * 
 * @author UDA
 */

@Service(value = "codigoService")
public class CodigoServiceImpl implements CodigoService {

	@Autowired
	private CodigoDao codigoDao;

	/**
	 * Inserts a single row in the Codigo table.
	 * 
	 * @param codigo
	 *            Codigo
	 * @return Codigo
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Codigo add(Codigo codigo) {
		return this.codigoDao.add(codigo);
	}

	/**
	 * Updates a single row in the Codigo table.
	 * 
	 * @param codigo
	 *            Codigo
	 * @return Codigo
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Codigo update(Codigo codigo) {
		return this.codigoDao.update(codigo);
	}

	/**
	 * Finds a single row in the Codigo table.
	 * 
	 * @param codigo
	 *            Codigo
	 * @return Codigo
	 */
	public Codigo find(Codigo codigo) {
		return (Codigo) this.codigoDao.find(codigo);
	}

	/**
	 * Finds a List of rows in the Codigo table.
	 * 
	 * @param codigo
	 *            Codigo
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Codigo> findAll(Codigo codigo, Pagination pagination) {
		return (List<Codigo>) this.codigoDao.findAll(codigo, pagination);
	}

	/**
	 * obtener los activos que esten en situación de Alta.
	 * 
	 * @param codigo
	 *            Codigo
	 * @return List
	 */
	public List<Codigo> obtenerCodigosAlta(Codigo codigo) {
		return (List<Codigo>) this.codigoDao.obtenerCodigosAlta(codigo);
	}

	/**
	 * Counts rows in the Codigo table.
	 * 
	 * @param codigo
	 *            Codigo
	 * @return Long
	 */
	public Long findAllCount(Codigo codigo) {
		return this.codigoDao.findAllCount(codigo);
	}

	/**
	 * Finds rows in the Codigo table using like.
	 * 
	 * @param codigo
	 *            Codigo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Codigo> findAllLike(Codigo codigo, Pagination pagination,
			Boolean startsWith) {
		return (List<Codigo>) this.codigoDao.findAllLike(codigo, pagination,
				startsWith);
	}

	/**
	 * Counts rows in the Codigo table using like.
	 * 
	 * @param codigo
	 *            Codigo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Codigo codigo, Boolean startsWith) {
		return this.codigoDao.findAllLikeCount(codigo, startsWith);
	}

	/**
	 * Deletes a single row in the Codigo table.
	 * 
	 * @param codigo
	 *            Codigo
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Codigo codigo) {
		this.codigoDao.remove(codigo);
	}

	/**
	 * Deletes multiple rows in the Codigo table.
	 * 
	 * @param codigoList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Codigo> codigoList) {
		for (Codigo codigoAux : codigoList) {
			this.codigoDao.remove(codigoAux);
		}
	}

	/**
	 * Finds rows in the Codigo table using like.
	 * 
	 * @param idClase
	 *            String
	 * @param language
	 *            String
	 * 
	 * @return List
	 */
	public List<Codigo> obtenerActivosClase(String idClase, String language) {
		return this.codigoDao.obtenerActivosClase(idClase, language);
	}
}
