package com.ejie.aa20b.service;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.aa20b.model.Codigo;

/**
 * CodigoService generated by UDA, 28-nov-2014 12:22:02.
 * 
 * @author UDA
 */

public interface CodigoService {

	/**
	 * Inserts a single row in the Codigo table.
	 * 
	 * @param codigo
	 *            Codigo
	 * @return Codigo
	 */
	Codigo add(Codigo codigo);

	/**
	 * Updates a single row in the Codigo table.
	 * 
	 * @param codigo
	 *            Codigo
	 * @return Codigo
	 */
	Codigo update(Codigo codigo);

	/**
	 * Finds a single row in the Codigo table.
	 * 
	 * @param codigo
	 *            Codigo
	 * @return Codigo
	 */
	Codigo find(Codigo codigo);

	/**
	 * Finds a List of rows in the Codigo table.
	 * 
	 * @param codigo
	 *            Codigo
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Codigo> findAll(Codigo codigo, Pagination pagination);

	/**
	 * obtener los activos que esten en situación de Alta.
	 * 
	 * @param codigo
	 *            Codigo
	 * @return List
	 */
	List<Codigo> obtenerCodigosAlta(Codigo codigo);

	/**
	 * Counts rows in the Codigo table.
	 * 
	 * @param codigo
	 *            Codigo
	 * @return Long
	 */
	Long findAllCount(Codigo codigo);

	/**
	 * Finds rows in the Codigo table using like.
	 * 
	 * @param codigo
	 *            Codigo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Codigo> findAllLike(Codigo codigo, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Codigo table using like.
	 * 
	 * @param codigo
	 *            Codigo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Codigo codigo, Boolean startsWith);

	/**
	 * Deletes a single row in the Codigo table.
	 * 
	 * @param codigo
	 *            Codigo
	 * @return
	 */
	void remove(Codigo codigo);

	/**
	 * Deletes multiple rows in the Codigo table.
	 * 
	 * @param codigoList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Codigo> codigoList);

	/**
	 * Finds a List of rows in the Codigo table.
	 * 
	 * @param idClase
	 *            String
	 * @param language
	 *            String
	 * @return List
	 */
	List<Codigo> obtenerActivosClase(String idClase, String language);
}
