package com.ejie.aa20b.service;

import com.ejie.aa20b.dao.ClasecontrataDao;
import com.ejie.aa20b.dao.GamasDao;
import com.ejie.x38.dto.Pagination;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.Clasecontrata;
import com.ejie.aa20b.model.Gamas;

/**
 * ClasecontrataServiceImpl generated by UDA, 17-abr-2015 11:56:30.
 * 
 * @author UDA
 */

@Service(value = "clasecontrataService")
public class ClasecontrataServiceImpl implements ClasecontrataService {

	@Autowired
	private ClasecontrataDao clasecontrataDao;

	@Autowired
	private GamasDao gamasDao;

	/**
	 * Inserts a single row in the Clasecontrata table.
	 * 
	 * @param clasecontrata
	 *            Clasecontrata
	 * @return Clasecontrata
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Clasecontrata add(Clasecontrata clasecontrata) {
		return this.clasecontrataDao.add(clasecontrata);
	}

	/**
	 * Updates a single row in the Clasecontrata table.
	 * 
	 * @param clasecontrata
	 *            Clasecontrata
	 * @return Clasecontrata
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Clasecontrata update(Clasecontrata clasecontrata) {
		return this.clasecontrataDao.update(clasecontrata);
	}

	/**
	 * Updates a single row in the Clasecontrata table.
	 * 
	 * @param clasecontrata
	 *            Clasecontrata
	 * @return Clasecontrata
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Clasecontrata cambiarCodigo(Clasecontrata clasecontrata) {
		return this.clasecontrataDao.cambiarCodigo(clasecontrata);
	}

	/**
	 * actualizar el codigo a cero.
	 * 
	 * @param clasecontrata
	 *            Clasecontrata
	 * @return Clasecontrata
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Clasecontrata ponerCodigoCero(Clasecontrata clasecontrata) {
		return this.clasecontrataDao.ponerCodigoCero(clasecontrata);
	};

	/**
	 * poner el codigo de baja.
	 * 
	 * @param clasecontrata
	 *            Clasecontrata
	 * @return Clasecontrata
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Clasecontrata ponerCodigoBaja(Clasecontrata clasecontrata) {
		return this.clasecontrataDao.ponerCodigoBaja(clasecontrata);
	};

	/**
	 * Finds a single row in the Clasecontrata table.
	 * 
	 * @param clasecontrata
	 *            Clasecontrata
	 * @return Clasecontrata
	 */
	public Clasecontrata find(Clasecontrata clasecontrata) {
		return (Clasecontrata) this.clasecontrataDao.find(clasecontrata);
	}

	/**
	 * Finds a List of rows in the Clasecontrata table.
	 * 
	 * @param clasecontrata
	 *            Clasecontrata
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Clasecontrata> findAll(Clasecontrata clasecontrata,
			Pagination pagination) {
		return (List<Clasecontrata>) this.clasecontrataDao.findAll(
				clasecontrata, pagination);
	}

	/**
	 * Counts rows in the Clasecontrata table.
	 * 
	 * @param clasecontrata
	 *            Clasecontrata
	 * @return Long
	 */
	public Long findAllCount(Clasecontrata clasecontrata) {
		return this.clasecontrataDao.findAllCount(clasecontrata);
	}

	/**
	 * Finds rows in the Clasecontrata table using like.
	 * 
	 * @param clasecontrata
	 *            Clasecontrata
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Clasecontrata> findAllLike(Clasecontrata clasecontrata,
			Pagination pagination, Boolean startsWith) {
		return (List<Clasecontrata>) this.clasecontrataDao.findAllLike(
				clasecontrata, pagination, startsWith);
	}

	/**
	 * Counts rows in the Clasecontrata table using like.
	 * 
	 * @param clasecontrata
	 *            Clasecontrata
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Clasecontrata clasecontrata, Boolean startsWith) {
		return this.clasecontrataDao
				.findAllLikeCount(clasecontrata, startsWith);
	}

	/**
	 * Deletes a single row in the Clasecontrata table.
	 * 
	 * @param clasecontrata
	 *            Clasecontrata
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Clasecontrata clasecontrata) {
		this.clasecontrataDao.remove(clasecontrata);
	}

	/**
	 * Deletes multiple rows in the Clasecontrata table.
	 * 
	 * @param clasecontrataList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Clasecontrata> clasecontrataList) {
		for (Clasecontrata clasecontrataAux : clasecontrataList) {
			this.clasecontrataDao.remove(clasecontrataAux);
		}
	}

	/**
	 * Inserts a single row in the Clasecontrata table.
	 * 
	 * @param clasecontrata
	 *            Clasecontrata
	 * @return Clasecontrata
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Clasecontrata sumaTecnico(Clasecontrata clasecontrata) {
		// añadir tecnico a la clase contrata
		Clasecontrata claseContrata = this.clasecontrataDao.add(clasecontrata);

		// Marcar "Para contrata" las gamas asociadas a dicha clase
		Gamas gamasAux = new Gamas();
		gamasAux.setIdclase(clasecontrata.getIdclase());
		gamasAux.setContrata("1");
		this.gamasDao.marcarParaContra(gamasAux);

		return claseContrata;
	}

	/**
	 * Elimina a single row in the Clasecontrata table.
	 * 
	 * @param clasecontrata
	 *            Clasecontrata
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void eliminaTecnico(Clasecontrata clasecontrata) {
		// Eliminar tecnico a la clase contrata
		this.clasecontrataDao.eliminarClaseContrata(clasecontrata);

		// Comprobar si ya no quedan tecnicos contrata para esa clase y en ese
		// caso desmarcar "Para contrata" las gamas asociadas a dicha clase
		Clasecontrata claseContrataAux = new Clasecontrata();
		claseContrataAux.setIdclase(clasecontrata.getIdclase());

		if (this.clasecontrataDao.tecnicosAsociadosAClase(claseContrataAux) > 0) {

		} else {
			// No quedan tecnicos contrata para esa clase. Se desmarcan todas
			// las gamas asociadas a esa clase
			Gamas gamasAux = new Gamas();
			gamasAux.setIdclase(clasecontrata.getIdclase());
			gamasAux.setContrata("0");
			this.gamasDao.marcarParaContra(gamasAux);
		}
	}
}
