package com.ejie.aa20b.service;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.Clasecontrata;

/**
 * ClasecontrataService generated by UDA, 17-abr-2015 11:56:30.
 * 
 * @author UDA
 */

public interface ClasecontrataService {

	/**
	 * Inserts a single row in the Clasecontrata table.
	 * 
	 * @param clasecontrata
	 *            Clasecontrata
	 * @return Clasecontrata
	 */
	Clasecontrata add(Clasecontrata clasecontrata);

	/**
	 * Updates a single row in the Clasecontrata table.
	 * 
	 * @param clasecontrata
	 *            Clasecontrata
	 * @return Clasecontrata
	 */
	Clasecontrata update(Clasecontrata clasecontrata);

	/**
	 * Updates a single row in the Clasecontrata table.
	 * 
	 * @param clasecontrata
	 *            Clasecontrata
	 * @return Clasecontrata
	 */
	Clasecontrata cambiarCodigo(Clasecontrata clasecontrata);

	/**
	 * actualizar el codigo a cero.
	 * 
	 * @param clasecontrata
	 *            Clasecontrata
	 * @return Clasecontrata
	 */
	Clasecontrata ponerCodigoCero(Clasecontrata clasecontrata);

	/**
	 * Poner el codigo de baja.
	 * 
	 * @param clasecontrata
	 *            Clasecontrata
	 * @return Clasecontrata
	 */
	Clasecontrata ponerCodigoBaja(Clasecontrata clasecontrata);

	/**
	 * Finds a single row in the Clasecontrata table.
	 * 
	 * @param clasecontrata
	 *            Clasecontrata
	 * @return Clasecontrata
	 */
	Clasecontrata find(Clasecontrata clasecontrata);

	/**
	 * Finds a List of rows in the Clasecontrata table.
	 * 
	 * @param clasecontrata
	 *            Clasecontrata
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Clasecontrata> findAll(Clasecontrata clasecontrata,
			Pagination pagination);

	/**
	 * Counts rows in the Clasecontrata table.
	 * 
	 * @param clasecontrata
	 *            Clasecontrata
	 * @return Long
	 */
	Long findAllCount(Clasecontrata clasecontrata);

	/**
	 * Finds rows in the Clasecontrata table using like.
	 * 
	 * @param clasecontrata
	 *            Clasecontrata
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Clasecontrata> findAllLike(Clasecontrata clasecontrata,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Clasecontrata table using like.
	 * 
	 * @param clasecontrata
	 *            Clasecontrata
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Clasecontrata clasecontrata, Boolean startsWith);

	/**
	 * Deletes a single row in the Clasecontrata table.
	 * 
	 * @param clasecontrata
	 *            Clasecontrata
	 * @return
	 */
	void remove(Clasecontrata clasecontrata);

	/**
	 * Deletes multiple rows in the Clasecontrata table.
	 * 
	 * @param clasecontrataList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Clasecontrata> clasecontrataList);

	/**
	 * Inserts a single row in the Clasecontrata table.
	 * 
	 * @param clasecontrata
	 *            Clasecontrata
	 * @return Clasecontrata
	 */
	Clasecontrata sumaTecnico(Clasecontrata clasecontrata);

	/**
	 * Elimina a single row in the Clasecontrata table.
	 * 
	 * @param clasecontrata
	 *            Clasecontrata
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	void eliminaTecnico(Clasecontrata clasecontrata);

}
