package com.ejie.aa20b.service;

import com.ejie.aa20b.dao.ClaseDao;
import com.ejie.aa20b.dao.CodigoDao;
import com.ejie.x38.dto.Pagination;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.Clase;
import com.ejie.aa20b.model.Codigo;

/**
 * ClaseServiceImpl generated by UDA, 28-nov-2014 11:32:16.
 * 
 * @author UDA
 */

@Service(value = "claseService")
public class ClaseServiceImpl implements ClaseService {

	@Autowired
	private ClaseDao claseDao;

	@Autowired
	private CodigoDao codigoDao;

	/**
	 * Inserts a single row in the Clase table.
	 * 
	 * @param clase
	 *            Clase
	 * @return Clase
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Clase add(Clase clase) {
		return this.claseDao.add(clase);
	}

	/**
	 * Updates a single row in the Clase table.
	 * 
	 * @param clase
	 *            Clase
	 * @return Clase
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Clase update(Clase clase) {
		return this.claseDao.update(clase);
	}

	/**
	 * Finds a single row in the Clase table.
	 * 
	 * @param clase
	 *            Clase
	 * @return Clase
	 */
	public Clase find(Clase clase) {
		return (Clase) this.claseDao.find(clase);
	}

	/**
	 * Finds a List of rows in the Clase table.
	 * 
	 * @param clase
	 *            Clase
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Clase> findAll(Clase clase, Pagination pagination) {
		return (List<Clase>) this.claseDao.findAll(clase, pagination);
	}

	/**
	 * obtener las clases que esten en situación de Alta.
	 * 
	 * @param clase
	 *            Clase
	 * @return List
	 */
	public List<Clase> obtenerClasesAlta(Clase clase) {
		return (List<Clase>) this.claseDao.obtenerClasesAlta(clase);
	}

	/**
	 * obtener las clases que esten en situación de Alta asociadas a un
	 * servicio.
	 * 
	 * @param clase
	 *            Clase
	 * @param idServicio
	 *            Integer
	 * @return List
	 */
	public List<Clase> obtenerClasesAltaServicio(Clase clase, Integer idServicio) {
		return (List<Clase>) this.claseDao.obtenerClasesAltaServicio(clase,
				idServicio);
	}

	/**
	 * Counts rows in the Clase table.
	 * 
	 * @param clase
	 *            Clase
	 * @return Long
	 */
	public Long findAllCount(Clase clase) {
		return this.claseDao.findAllCount(clase);
	}

	/**
	 * Finds rows in the Clase table using like.
	 * 
	 * @param clase
	 *            Clase
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Clase> findAllLike(Clase clase, Pagination pagination,
			Boolean startsWith) {
		return (List<Clase>) this.claseDao.findAllLike(clase, pagination,
				startsWith);
	}

	/**
	 * Counts rows in the Clase table using like.
	 * 
	 * @param clase
	 *            Clase
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Clase clase, Boolean startsWith) {
		return this.claseDao.findAllLikeCount(clase, startsWith);
	}

	/**
	 * Deletes a single row in the Clase table.
	 * 
	 * @param clase
	 *            Clase
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Clase clase) {
		this.claseDao.remove(clase);
	}

	/**
	 * Deletes multiple rows in the Clase table.
	 * 
	 * @param claseList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Clase> claseList) {
		for (Clase claseAux : claseList) {
			this.claseDao.remove(claseAux);
		}
	}

	/**
	 * Updates a single row in the Clase table.
	 * 
	 * @param clase
	 *            Clase
	 * @return Clase
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Clase modificarClaseYDescheq(Clase clase) {
		// Modificar el registro de la clase
		Clase claseAux = this.claseDao.update(clase);

		// Actualizar UsuPubli=0 en los codigos de parte asociados a la clase
		Codigo codigo = new Codigo();
		codigo.setIdclase(clase.getIdclase());
		this.codigoDao.deschequearUsuPubli(codigo);

		return claseAux;

	}

	/**
	 * Updates a single row in the Clase table.
	 * 
	 * @param clase
	 *            Clase
	 * @return Clase
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Clase modificarClaseYCheqCodigos(Clase clase) {
		// Modificar el registro de la clase
		Clase claseAux = this.claseDao.update(clase);

		// Actualizar UsuPubli=0 en los codigos de parte asociados a la clase
		Codigo codigo = new Codigo();
		codigo.setIdclase(clase.getIdclase());
		this.codigoDao.chequearUsuPubli(codigo);

		return claseAux;
	}

	/**
	 * Devuelve true si la clase tiene la marca de Mostrar a usuario publico.
	 * 
	 * @param idClase
	 *            Integer
	 * @return Boolean
	 */
	public Boolean claseEsUsuPubli(Integer idClase) {
		return this.claseDao.claseEsUsuPubli(idClase);
	}

	/**
	 * Clases asociadas y un servicio.
	 * 
	 * @param clase
	 *            Clase
	 * @param idServicio
	 *            Integer
	 * @return List
	 */
	public List<Clase> obtenerClasesServicio(Clase clase, Integer idServicio) {
		return (List<Clase>) this.claseDao.obtenerClasesServicio(clase,
				idServicio);
	}
}
