package com.ejie.aa20b.service;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.aa20b.model.Clase;

/**
 * ClaseService generated by UDA, 28-nov-2014 11:32:16.
 * 
 * @author UDA
 */

public interface ClaseService {

	/**
	 * Inserts a single row in the Clase table.
	 * 
	 * @param clase
	 *            Clase
	 * @return Clase
	 */
	Clase add(Clase clase);

	/**
	 * Updates a single row in the Clase table.
	 * 
	 * @param clase
	 *            Clase
	 * @return Clase
	 */
	Clase update(Clase clase);

	/**
	 * Finds a single row in the Clase table.
	 * 
	 * @param clase
	 *            Clase
	 * @return Clase
	 */
	Clase find(Clase clase);

	/**
	 * Finds a List of rows in the Clase table.
	 * 
	 * @param clase
	 *            Clase
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Clase> findAll(Clase clase, Pagination pagination);

	/**
	 * obtener las clases que esten en situación de Alta.
	 * 
	 * @param clase
	 *            Clase
	 * @return List
	 */
	List<Clase> obtenerClasesAlta(Clase clase);

	/**
	 * obtener las clases que esten en situación de Alta asociadas a un
	 * servicio.
	 * 
	 * @param clase
	 *            Clase
	 * @param idServicio
	 *            Integer
	 * @return List
	 */
	List<Clase> obtenerClasesAltaServicio(Clase clase, Integer idServicio);

	/**
	 * Counts rows in the Clase table.
	 * 
	 * @param clase
	 *            Clase
	 * @return Long
	 */
	Long findAllCount(Clase clase);

	/**
	 * Finds rows in the Clase table using like.
	 * 
	 * @param clase
	 *            Clase
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Clase> findAllLike(Clase clase, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Clase table using like.
	 * 
	 * @param clase
	 *            Clase
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Clase clase, Boolean startsWith);

	/**
	 * Deletes a single row in the Clase table.
	 * 
	 * @param clase
	 *            Clase
	 * @return
	 */
	void remove(Clase clase);

	/**
	 * Deletes multiple rows in the Clase table.
	 * 
	 * @param claseList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Clase> claseList);

	/**
	 * Updates a single row in the Clase table.
	 * 
	 * @param clase
	 *            Clase
	 * @return Clase
	 */
	Clase modificarClaseYDescheq(Clase clase);

	/**
	 * Updates a single row in the Clase table.
	 * 
	 * @param clase
	 *            Clase
	 * @return Clase
	 */
	Clase modificarClaseYCheqCodigos(Clase clase);

	/**
	 * Devuelve true si la clase tiene la marca de Mostrar a usuario publico.
	 * 
	 * @param idClase
	 *            Integer
	 * @return Boolean
	 */
	Boolean claseEsUsuPubli(Integer idClase);

	/**
	 * Clases asociadas y un servicio.
	 * 
	 * @param clase
	 *            Clase
	 * @param idServicio
	 *            Integer
	 * @return List
	 */
	List<Clase> obtenerClasesServicio(Clase clase, Integer idServicio);
}
