package com.ejie.aa20b.service;

import com.ejie.aa20b.dao.ActuacionDao;
import com.ejie.aa20b.dao.PartesDao;
import com.ejie.x38.dto.Pagination;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.Actuacion;
import com.ejie.aa20b.model.Partes;

/**
 * ActuacionServiceImpl generated by UDA, 05-mar-2015 10:57:47.
 * 
 * @author UDA
 */

@Service(value = "actuacionService")
public class ActuacionServiceImpl implements ActuacionService {

	@Autowired
	private ActuacionDao actuacionDao;

	@Autowired
	private PartesDao partesDao;

	/**
	 * Inserts a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Actuacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Actuacion add(Actuacion actuacion) {
		return this.actuacionDao.add(actuacion);
	}

	/**
	 * Updates a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Actuacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Actuacion update(Actuacion actuacion) {
		return this.actuacionDao.update(actuacion);
	}

	/**
	 * Finds a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Actuacion
	 */
	public Actuacion find(Actuacion actuacion) {
		return (Actuacion) this.actuacionDao.find(actuacion);
	}

	/**
	 * Finds a List of rows in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Actuacion> findAll(Actuacion actuacion, Pagination pagination) {
		return (List<Actuacion>) this.actuacionDao.findAll(actuacion,
				pagination);
	}

	/**
	 * Counts rows in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Long
	 */
	public Long findAllCount(Actuacion actuacion) {
		return this.actuacionDao.findAllCount(actuacion);
	}

	/**
	 * Finds rows in the Actuacion table using like.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Actuacion> findAllLike(Actuacion actuacion,
			Pagination pagination, Boolean startsWith) {
		return (List<Actuacion>) this.actuacionDao.findAllLike(actuacion,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the Actuacion table using like.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Actuacion actuacion, Boolean startsWith) {
		return this.actuacionDao.findAllLikeCount(actuacion, startsWith);
	}

	/**
	 * Deletes a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Actuacion actuacion) {
		this.actuacionDao.remove(actuacion);
	}

	/**
	 * Deletes multiple rows in the Actuacion table.
	 * 
	 * @param actuacionList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Actuacion> actuacionList) {
		for (Actuacion actuacionAux : actuacionList) {
			this.actuacionDao.remove(actuacionAux);
		}
	}

	/**
	 * Finds a List of rows in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Actuacion> obtenerActuaciones(Actuacion actuacion,
			Pagination pagination) {
		return (List<Actuacion>) this.actuacionDao.obtenerActuaciones(
				actuacion, pagination);
	}

	/**
	 * Counts rows in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Long
	 */
	public Long obtenerActuacionesCount(Actuacion actuacion) {
		return this.actuacionDao.obtenerActuacionesCount(actuacion);
	}

	/**
	 * Finds a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Actuacion
	 */
	public Actuacion obtenerActuacion(Actuacion actuacion) {
		return (Actuacion) this.actuacionDao.obtenerActuacion(actuacion);
	}

	/**
	 * Updates a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Actuacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Actuacion modificaActuacion(Actuacion actuacion) {
		return this.actuacionDao.modificaActuacion(actuacion);
	}

	/**
	 * Updates a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Actuacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Actuacion actualizarIdparte(Actuacion actuacion) {
		return this.actuacionDao.actualizarIdparte(actuacion);
	}

	/**
	 * Elimina la actuacion y si tiene parte correctivo tambien.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param idParte
	 *            Integer
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void eliminarActuacion(Actuacion actuacion, Integer idParte) {
		if (idParte > 0) {
			Partes parte = new Partes();
			parte.setIdparte(idParte);
			this.partesDao.remove(parte);
		}
		this.actuacionDao.remove(actuacion);
	}

}
