package com.ejie.aa20b.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.aa20b.jms.Aa20bProcesosJMS;
import com.ejie.aa20b.model.Actuacion;
import com.ejie.aa20b.model.Clase;
import com.ejie.aa20b.model.Codigo;
import com.ejie.aa20b.model.Departamentos;
import com.ejie.aa20b.model.Direcciones;
import com.ejie.aa20b.model.Edificios;
import com.ejie.aa20b.model.Espacio;
import com.ejie.aa20b.model.Ficha;
import com.ejie.aa20b.model.Fichatecnicosgmao;
import com.ejie.aa20b.model.Gamas;
import com.ejie.aa20b.model.Maquinas;
import com.ejie.aa20b.model.Partes;
import com.ejie.aa20b.model.Partetecnicos;
import com.ejie.aa20b.model.Partetecnicosgmao;
import com.ejie.aa20b.model.Plantas;
import com.ejie.aa20b.model.Servicios;
import com.ejie.aa20b.model.Zonas;
import com.ejie.x38.json.JSONObject;

@Service(value = "procesosJMSService")
public class Aa20bProcesosJMSServiceImpl implements Aa20bProcesosJMSService {

	@Autowired
	private Aa20bProcesosJMS procesosJMSclase;

	public Aa20bProcesosJMSServiceImpl() {

	}

	public void notificarCambioDatosJMS(int operacion, String tipoModelo,
			Object objetoModelo) {
		this.procesosJMSclase.sendMessageObjeto(operacion, tipoModelo,
				objetoModelo);
	}

	@Override
	public String generarEntidadesEdifEstruc(String urlConfig) {
		return this.procesosJMSclase.generarEntidadesEdifEstruc(urlConfig);
	}

	@Override
	public void sincronizarEdifEstruc(List<Edificios> edificios,
			int tipoLlamada, String url) {
		this.procesosJMSclase
				.sincronizarEdifEstruc(edificios, tipoLlamada, url);
	}

	@Override
	public void sincronizarZonaEdifGmao(Edificios edificio, Zonas zona) {
		this.procesosJMSclase.sincronizarZonaEdifGmao(edificio, zona);
	}

	@Override
	public void sincronizarPlantaEdifGmao(Edificios edificio, Zonas zona,
			Plantas planta) {
		this.procesosJMSclase.sincronizarPlantaEdifGmao(edificio, zona, planta);
	}

	@Override
	public String sincronizarTodasEstanciasGmao(List<Espacio> espacios,
			int tipoLlamada, String urlConfig) {
		return this.procesosJMSclase.sincronizarTodasEstanciasGmao(espacios,
				tipoLlamada, urlConfig);
	}

	@Override
	public void sincronizarEstanciaGmao(Espacio espacio) {
		this.procesosJMSclase.sincronizarEstanciaGmao(espacio);
	}

	@Override
	public String sincronizarGmao(JSONObject datosJson, String url) {
		// TODO Auto-generated method stub
		return this.procesosJMSclase.sincronizarGmao(datosJson, url);
	}

	@Override
	public String sincronizarTodasClasesGmao(List<Clase> clases,
			int tipoLlamada, String urlConfig) {
		// TODO Auto-generated method stub
		return this.procesosJMSclase.sincronizarTodasClasesGmao(clases,
				tipoLlamada, urlConfig);
	}

	@Override
	public void sincronizarClaseGmao(Clase clase) {
		this.procesosJMSclase.sincronizarClaseGmao(clase);
	}

	@Override
	public String sincronizarTodosCodigosGmao(List<Codigo> codigos,
			int tipoLlamada, String urlConfig) {
		// TODO Auto-generated method stub
		return this.procesosJMSclase.sincronizarTodosCodigosGmao(codigos,
				tipoLlamada, urlConfig);
	}

	@Override
	public void sincronizarCodigoGmao(Codigo codigo) {
		this.procesosJMSclase.sincronizarCodigoGmao(codigo);
	}

	@Override
	public String sincronizarTodosGamasGmao(List<Gamas> gamas, int tipoLlamada,
			String urlConfig) {
		// TODO Auto-generated method stub
		return this.procesosJMSclase.sincronizarTodosGamasGmao(gamas,
				tipoLlamada, urlConfig);
	}

	@Override
	public void sincronizarGamaGmao(Gamas gama) {
		this.procesosJMSclase.sincronizarGamaGmao(gama);
	}

	@Override
	public String sincronizarTodosServiciosGmao(List<Servicios> servicios,
			int tipoLlamada, String urlConfig) {
		// TODO Auto-generated method stub
		return this.procesosJMSclase.sincronizarTodosServiciosGmao(servicios,
				tipoLlamada, urlConfig);
	}

	@Override
	public void sincronizarServicioGmao(Servicios servicio) {
		this.procesosJMSclase.sincronizarServicioGmao(servicio);
	}

	@Override
	public String sincronizarParteCorrectivoGmao(Partes parte,
			List<Partetecnicosgmao> tecnicosParteGmao, String UUIdActivo,
			byte[] plano, byte[] pdf, String urlConfig) {
		// TODO Auto-generated method stub
		return this.procesosJMSclase.sincronizarParteCorrectivoGmao(parte,
				tecnicosParteGmao, UUIdActivo, plano, pdf, urlConfig);

	}

	@Override
	public String sincronizarPartePreventivoGmao(Ficha ficha, Maquinas maquina,
			List<Fichatecnicosgmao> tecnicosFichaGmao,
			List<Actuacion> listaActuaciones, String UUIdActivo,
			String urlConfig) {
		// TODO Auto-generated method stub
		return this.procesosJMSclase.sincronizarPartePreventivoGmao(ficha,
				maquina, tecnicosFichaGmao, listaActuaciones, UUIdActivo,
				urlConfig);

	}

	@Override
	public String sincronizarGmaoGET(String url) {
		return this.procesosJMSclase.sincronizarGmaoGET(url);
	}

	@Override
	public String bajarOtByGUID(JSONObject datosJson, String url) {
		return this.procesosJMSclase.bajarOtByGUID(datosJson, url);
	}

	@Override
	public String sincronizarTodosMaquinasGmao(List<Maquinas> maquinas,
			int tipoLlamada, String urlConfig, int numSinc) {
		// TODO Auto-generated method stub
		return this.procesosJMSclase.sincronizarTodosMaquinasGmao(maquinas,
				tipoLlamada, urlConfig, numSinc);
	}

	@Override
	public void sincronizarMaquinaGmao(Maquinas maquina) {
		// TODO Auto-generated method stub
		this.procesosJMSclase.sincronizarMaquinaGmao(maquina);

	}

	@Override
	public String sincronizarTodosDepartamentosGmao(List<Departamentos> dptos,
			int tipoLlamada, String urlConfig) {
		return this.procesosJMSclase.sincronizarTodosDepartamentos(dptos,
				tipoLlamada, urlConfig);
	}

	@Override
	public String sincronizarTodasDireccionesGmao(List<Direcciones> dirs,
			int tipoLlamada, String urlConfig) {
		return this.procesosJMSclase.sincronizarTodasDirecciones(dirs,
				tipoLlamada, urlConfig);
	}

	@Override
	public String eliminarOTpadre(String guidPartePadre, String urlConfig) {
		// TODO Auto-generated method stub
		return this.procesosJMSclase.eliminarOTpadre(guidPartePadre, urlConfig);
	}

	@Override
	public String subirOTcambioEstado(String guidOT, String nuevoEstado,
			String urlConfig) {
		return this.procesosJMSclase.subirOTcambioEstado(guidOT, nuevoEstado,
				urlConfig);
	}

	@Override
	public String subirOTcambioTecnico(String guidOT, String nuevoTecnico,
			String urlConfig) {
		return this.procesosJMSclase.subirOTcambioTecnico(guidOT, nuevoTecnico,
				urlConfig);
	}

	@Override
	public String subirOTcambioFechaPlanif(String guidOT, Date fechaPlanif,
			String urlConfig) {
		return this.procesosJMSclase.subirOTcambioFechaPlanif(guidOT,
				fechaPlanif, urlConfig);
	}

	@Override
	public String marcarOTaceptada(String guidOT, String aceptada,
			String urlConfig) {
		return this.procesosJMSclase.marcarOTaceptada(guidOT, aceptada,
				urlConfig);
	}

	@Override
	public String enviarObservacionResponsable(String guidOT, String notasResp,
			String urlConfig) {
		return this.procesosJMSclase.enviarObservacionResponsable(guidOT,
				notasResp, urlConfig);
	}

	@Override
	public String enviarObservacionesFicha(String guidOT, String observaciones,
			String urlConfig) {
		return this.procesosJMSclase.enviarObservacionesFicha(guidOT,
				observaciones, urlConfig);
	}

}
