package com.ejie.aa20b.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ejie.aa20b.model.Actuacion;
import com.ejie.aa20b.model.Clase;
import com.ejie.aa20b.model.Codigo;
import com.ejie.aa20b.model.Departamentos;
import com.ejie.aa20b.model.Direcciones;
import com.ejie.aa20b.model.Edificios;
import com.ejie.aa20b.model.Espacio;
import com.ejie.aa20b.model.Ficha;
import com.ejie.aa20b.model.Fichatecnicosgmao;
import com.ejie.aa20b.model.Gamas;
import com.ejie.aa20b.model.Maquinas;
import com.ejie.aa20b.model.Partes;
import com.ejie.aa20b.model.Partetecnicos;
import com.ejie.aa20b.model.Partetecnicosgmao;
import com.ejie.aa20b.model.Plantas;
import com.ejie.aa20b.model.Servicios;
import com.ejie.aa20b.model.Zonas;
import com.ejie.x38.json.JSONObject;

public interface Aa20bProcesosJMSService {

	void notificarCambioDatosJMS(int operacion, String tipoModelo,
			Object objetoModelo);

	String generarEntidadesEdifEstruc(String urlConfig);

	void sincronizarZonaEdifGmao(Edificios edificio, Zonas zona);

	void sincronizarPlantaEdifGmao(Edificios edificio, Zonas zona,
			Plantas planta);

	String sincronizarGmao(JSONObject datosJson, String url);

	void sincronizarEdifEstruc(List<Edificios> edificios, int tipoLlamada,
			String url);

	String sincronizarTodasEstanciasGmao(List<Espacio> espacios,
			int tipoLlamada, String urlConfig);

	void sincronizarEstanciaGmao(Espacio espacio);

	String sincronizarTodasClasesGmao(List<Clase> clases, int tipoLlamada,
			String urlConfig);

	void sincronizarClaseGmao(Clase clase);

	String sincronizarTodosCodigosGmao(List<Codigo> codigos, int tipoLlamada,
			String urlConfig);

	void sincronizarCodigoGmao(Codigo codigo);

	String sincronizarTodosGamasGmao(List<Gamas> gamas, int tipoLlamada,
			String urlConfig);

	void sincronizarGamaGmao(Gamas gama);

	String sincronizarTodosMaquinasGmao(List<Maquinas> maquinas,
			int tipoLlamada, String urlConfig, int numSinc);

	void sincronizarMaquinaGmao(Maquinas maquina);

	String sincronizarTodosDepartamentosGmao(List<Departamentos> dptos,
			int tipoLlamada, String urlConfig);

	String sincronizarTodasDireccionesGmao(List<Direcciones> dirs,
			int tipoLlamada, String urlConfig);

	String sincronizarTodosServiciosGmao(List<Servicios> servicios,
			int tipoLlamada, String urlConfig);

	void sincronizarServicioGmao(Servicios servicio);

	String sincronizarParteCorrectivoGmao(Partes parte,
			List<Partetecnicosgmao> tecnicosParteGmao, String UUIdActivo,
			byte[] plano, byte[] pdf, String urlConfig);

	String sincronizarGmaoGET(String url);

	String bajarOtByGUID(JSONObject datosJson, String url);

	String sincronizarPartePreventivoGmao(Ficha ficha, Maquinas maquina,
			List<Fichatecnicosgmao> tecnicosFichaGmao,
			List<Actuacion> listaActuaciones, String UUIdActivo,
			String urlConfig);

	String eliminarOTpadre(String guidPartePadre, String urlConfig);

	String subirOTcambioEstado(String guidOT, String nuevoEstado,
			String urlConfig);

	String marcarOTaceptada(String guidOT, String aceptada, String urlConfig);

	String enviarObservacionResponsable(String guidOT, String notasResp,
			String urlConfig);

	String subirOTcambioTecnico(String guidOT, String nuevoTecnico,
			String urlConfig);

	String subirOTcambioFechaPlanif(String guidOT, Date fechaPlanif,
			String urlConfig);

	String enviarObservacionesFicha(String guidOT, String observaciones,
			String urlConfig);
}
