package com.ejie.aa20b.model;

import java.util.Date;

import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;

/**
 * Edificios generated by UDA, 28-nov-2014 11:32:15.
 * 
 * @author UDA
 */

public class Edificios implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	// Clave compuesta
	private String idedificio;
	private String cedificio;
	private String eedificio;
	private String redificio;
	private Integer idterri;
	private String baja;
	private Date feini;
	private String gestCentra;
	private String guidedificio;

	private String strFeini; // para recoger los filtros y mantener al Volver.

	/**
	 * Method 'Edificios'.
	 */
	public Edificios() {
	}

	/**
	 * Method 'Edificios'.
	 * 
	 * @param idedificio
	 *            String
	 * @param cedificio
	 *            String
	 * @param eedificio
	 *            String
	 * @param redificio
	 *            String
	 * @param idterri
	 *            Integer
	 * @param baja
	 *            String
	 * @param gestCentra
	 *            String
	 * @param feini
	 *            Date Date
	 */
	public Edificios(String idedificio, String cedificio, String eedificio,
			String redificio, Integer idterri, String baja, Date feini,
			String gestCentra, String guidedificio) {

		this.idedificio = idedificio;
		if (cedificio != null) {
			this.cedificio = cedificio.replaceAll("/", " ");
		} else {
			this.cedificio = null;
		}
		if (eedificio != null) {
			this.eedificio = eedificio.replaceAll("/", " ");
		} else {
			this.eedificio = null;
		}

		this.cedificio = cedificio;
		this.eedificio = eedificio;
		this.redificio = redificio;
		this.idterri = idterri;
		this.baja = baja;
		this.feini = feini;
		this.gestCentra = gestCentra;
		this.guidedificio = guidedificio;
	}

	/**
	 * Method 'getIdedificio'.
	 * 
	 * @return String
	 */

	public String getIdedificio() {
		return this.idedificio;
	}

	/**
	 * Method 'setIdedificio'.
	 * 
	 * @param idedificio
	 *            String
	 * @return
	 */

	public void setIdedificio(String idedificio) {
		this.idedificio = idedificio;
	}

	/**
	 * Method 'getCedificio'.
	 * 
	 * @return String
	 */

	public String getCedificio() {
		return this.cedificio;
	}

	/**
	 * Method 'setCedificio'.
	 * 
	 * @param cedificio
	 *            String
	 * @return
	 */

	public void setCedificio(String cedificio) {
		if (cedificio != null) {
			this.cedificio = cedificio.replaceAll("/", " ");
		} else {
			this.cedificio = null;
		}

	}

	/**
	 * Method 'getEedificio'.
	 * 
	 * @return String
	 */

	public String getEedificio() {
		return this.eedificio;
	}

	/**
	 * Method 'setEedificio'.
	 * 
	 * @param eedificio
	 *            String
	 * @return
	 */

	public void setEedificio(String eedificio) {
		if (eedificio != null) {
			this.eedificio = eedificio.replaceAll("/", " ");
		} else {
			this.eedificio = null;
		}
	}

	/**
	 * Method 'getRedificio'.
	 * 
	 * @return String
	 */

	public String getRedificio() {
		return this.redificio;
	}

	/**
	 * Method 'setRedificio'.
	 * 
	 * @param redificio
	 *            String
	 * @return
	 */

	public void setRedificio(String redificio) {
		this.redificio = redificio;
	}

	/**
	 * Method 'getBaja'.
	 * 
	 * @return String
	 */

	/**
	 * Method 'getIdterri'.
	 * 
	 * @return Integer
	 */

	public Integer getIdterri() {
		return this.idterri;
	}

	/**
	 * Method 'setIdterri'.
	 * 
	 * @param idterri
	 *            Integer
	 * @return
	 */

	public void setIdterri(Integer idterri) {
		this.idterri = idterri;
	}

	public String getBaja() {
		return this.baja;
	}

	/**
	 * Method 'setBaja'.
	 * 
	 * @param baja
	 *            String
	 * @return
	 */

	public void setBaja(String baja) {
		this.baja = baja;
	}

	/**
	 * Method 'getFeini'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFeini() {
		return this.feini;
	}

	/**
	 * Method 'setFeini'.
	 * 
	 * @param feini
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFeini(Date feini) {
		this.feini = feini;
	}

	/**
	 * Method 'getGestCentra'.
	 * 
	 * @return String
	 */

	public String getGestCentra() {
		return this.gestCentra;
	}

	/**
	 * Method 'setGestCentra'.
	 * 
	 * @param gestCentra
	 *            String
	 * @return
	 */

	public void setGestCentra(String gestCentra) {
		this.gestCentra = gestCentra;
	}

	public String getGuidedificio() {
		return guidedificio;
	}

	public void setGuidedificio(String guidedificio) {
		this.guidedificio = guidedificio;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		// Clave compuesta

		result.append("[ idedificio: ").append(this.idedificio).append(" ]");

		if (cedificio != null) {
			result.append(", [ cedificio: ")
					.append(this.cedificio.replaceAll("/", " ")).append(" ]");
		} else {
			result.append(", [ cedificio: ").append(this.cedificio)
					.append(" ]");

		}
		if (eedificio != null) {
			result.append(", [ eedificio: ")
					.append(this.eedificio.replaceAll("/", " ")).append(" ]");
		} else {
			result.append(", [ eedificio: ").append(this.eedificio)
					.append(" ]");
		}

		result.append(", [ redificio: ").append(this.redificio).append(" ]");

		result.append(", [ idterri: ").append(this.idterri).append(" ]");

		result.append(", [ baja: ").append(this.baja).append(" ]");

		result.append(", [ feini: ").append(this.feini).append(" ]");

		result.append(", [ gestCentra: ").append(this.gestCentra).append(" ]");
		result.append(", [ guidedificio: ").append(this.guidedificio)
				.append(" ]");
		result.append("}");
		return result.toString();
	}

	public void setStrFeini(String strFeini) {
		this.strFeini = strFeini;
	}

	public String getStrFeini() {
		return strFeini;
	}

}
