package com.ejie.aa20b.ldap;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import n38a.exe.N38APISesion;
import n38c.exe.N38API;
import n38c.exe.N38Estructura;

import org.apache.xpath.XPathAPI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

import com.ejie.aa20b.dao.EdificiosXlnetDao;
import com.ejie.aa20b.dao.PlantasDao;
import com.ejie.aa20b.dao.ZonasDao;
import com.ejie.aa20b.model.Aa20bUsuarioXLNET;
import com.ejie.aa20b.model.EdificiosXlnet;
import com.ejie.aa20b.model.Plantas;
import com.ejie.aa20b.model.Zonas;
import com.ejie.aa20b.util.Aa20bConstantes;
import com.ejie.aa20b.util.Aa20bLog;
import com.ejie.x38.security.UserCredentials;

/**
 * Clase auxiliar para tratar con LDAP
 */
public class SecurityHelpperXLNets implements ISecurityInfo {

	private HttpServletRequest request;
	private N38API n38API;
	private JdbcTemplate jdbcTemplate;

	@Autowired
	private PlantasDao plantasService;

	@Autowired
	private ZonasDao zonasService;

	// private Locale clocLocale = Locale.getDefault();
	public SecurityHelpperXLNets() {

		HttpServletRequest currentRequest = ((ServletRequestAttributes) RequestContextHolder
				.currentRequestAttributes()).getRequest();
		try {
			this.setHttpRequest(currentRequest);

			this.getSecurityObject(Aa20bConstantes.XLNET_OBJETO_SEGURIDAD);
		} catch (SecurityHelpperException e) {
			Aa20bLog.addTraza("ERROR: " + e.getMessage());
			throw new SecurityException(
					"SecurityHelpperException:SecurityHelpperXLNets: " + e);
		}
	}

	/* Asociar la request de la sesi�n N38 */
	public void setHttpRequest(HttpServletRequest request)
			throws SecurityHelpperException {
		try {
			this.request = request;
			n38API = new N38API(request);
		} catch (Exception e) {
			throw new SecurityHelpperException(
					"Error al obtener instancia del api N38");
		}
	}

	/* Obtener los perfiles asociados al Usuario que realiza Login. */
	public String[] getPerfiles() throws SecurityHelpperException {
		try {
			return this.n38API.n38ItemSesion("n38perfiles");
		} catch (Throwable e) {
			throw new SecurityHelpperException("SecurityHelpper:getPerfiles");
		}
	}

	/* Obtener el idioma asociado al Usuario que realiza Login. */
	public String getIdioma() throws SecurityHelpperException {
		try {
			return this.n38API.n38ItemSesion("n38idioma")[0];
		} catch (Exception e) {
			throw new SecurityHelpperException("SecurityHelpper:getIdioma");
		}
	}

	/* Obtener la Persona asociada al Usuario que realiza Login. */
	public String getPersonaNombre() throws SecurityHelpperException {
		try {
			String uidPersona = this.getPersonaUID();
			Document personaDocument = this.n38API
					.n38ItemObtenerPersonas("n38PuestoUID=" + uidPersona);

			// String filtro =
			// "//elemento[@subtipo=\"n38persona\"]/parametro[@id=\"cn\"]/valor/text()";
			String filtro = "//elemento[@subtipo=\"n38persona\"]/parametro[@id=\"givenname\"]/valor/text()";
			// El cn contiene el nombre y apellidos de la persona.
			String nombre = XPathAPI.selectNodeList(personaDocument, filtro)
					.item(0).getNodeValue();
			return nombre;
		} catch (Exception e) {
			throw new SecurityHelpperException(
					"SecurityHelpper:getPersonaNombre");
		}
	}

	/* Obtener la Persona asociada al Usuario que realiza Login. */
	public String getPersonaNombreYApellidos() throws SecurityHelpperException {
		try {
			Document personaDocument = this.n38API
					.n38ItemObtenerPersonas("uid=" + this.getUsuario());
			String filtro = "//elemento[@subtipo=\"n38persona\"]/parametro[@id=\"givenname\"]/valor/text()";
			String nombre = XPathAPI.selectNodeList(personaDocument, filtro)
					.item(0).getNodeValue();
			filtro = "//elemento[@subtipo=\"n38persona\"]/parametro[@id=\"sn\"]/valor/text()";
			String apellidos = XPathAPI.selectNodeList(personaDocument, filtro)
					.item(0).getNodeValue();
			return nombre + " " + apellidos;
		} catch (Exception e) {
			throw new SecurityHelpperException(
					"SecurityHelpper:getPersonaNombreYApellidos");
		}
	}

	/* Obtener la Persona asociada al Usuario que realiza Login. */
	public String getPersonaApellido() throws SecurityHelpperException {
		try {
			Document personaDocument = this.n38API
					.n38ItemObtenerPersonas("uid=" + this.getUsuario());

			String filtro = "//elemento[@subtipo=\"n38persona\"]/parametro[@id=\"sn\"]/valor/text()";
			String apellidos = XPathAPI.selectNodeList(personaDocument, filtro)
					.item(0).getNodeValue();
			return apellidos;
		} catch (Exception e) {
			throw new SecurityHelpperException(
					"SecurityHelpper:getPersonaApellidos");
		}
	}

	/* Obtener el c�digo del usuario al Usuario que realiza Login. */
	public String getUsuario() throws SecurityHelpperException {
		try {
			UserCredentials userCredentials = (UserCredentials) SecurityContextHolder
					.getContext().getAuthentication().getCredentials();

			return userCredentials.getUserName();

			// return this.n38API.n38ItemSesion("n38personauid")[0];
		} catch (Exception e) {
			throw new SecurityHelpperException("SecurityHelpper:getUsuario"
					+ e.getMessage());
		}
	}

	/* Obtener el dni del usuario al Usuario que realiza Login. */
	public String getDni() throws SecurityHelpperException {
		try {
			return this.n38API.n38ItemSesion("dni")[0];
		} catch (Exception e) {
			throw new SecurityHelpperException("SecurityHelpper:getDni"
					+ e.getMessage());
		}
	}

	/* Obtener el uid del usuario que realiza Login. */
	public String getPersonaUID() throws SecurityHelpperException {
		try {
			String puestoUID = this.n38API.n38ItemSesion("n38puestouid")[0];
			return puestoUID;
			// return this.n38API.n38ItemSesion("n38puestouid")[0];
		} catch (Exception e) {
			throw new SecurityHelpperException("SecurityHelpper:getPersonaUID");
		}
	}

	/* Obtener el grupo orgánico del usuario que realiza Login. */
	public String getPersonaGrupoOrganicoUID() throws SecurityHelpperException {
		try {
			return this.n38API.n38ItemSesion("n38grupoorganicouid")[0];
		} catch (Exception e) {
			throw new SecurityHelpperException(
					"SecurityHelpper:getPersonaGrupoOrganicoUID");
		}
	}

	/* Comprobar si el usuario tiene permiso para la funci�n dada */
	public boolean hasPermission(String uidFuncion)
			throws SecurityHelpperException {
		NodeList lista;
		try {
			Document itemSeguridad = this.n38API.n38ItemSeguridad(uidFuncion);
			lista = XPathAPI.selectNodeList(itemSeguridad, "//elementos");
		} catch (Exception e) {
			throw new SecurityHelpperException(
					"SecurityHelpperXLNets:hasPermision");
		}
		return (lista.getLength() != 0);
	}

	/*
	 * public void cambioIdioma() { if (getIdIdioma().equals("eu"))
	 * setIdIdioma("es"); else setIdIdioma("eu"); clocLocale = new
	 * Locale(cstrIdIdioma, cstrIdIdioma); }
	 */
	/**
	 * Crea un objecto de seguridad para una funcion dada. Si devuelve Null es
	 * que no se tiene permiso para esa Funci�n o recurso de LDAP.
	 */
	public SecurityObject getSecurityObject(String uidFuncion)
			throws SecurityHelpperException {

		StringBuffer strLog = new StringBuffer();
		SecurityObject objetoSeguridad = null;
		String clocLocale = "ES";
		String XLNetsIdioma = "";

		try {
			objetoSeguridad = new SecurityObject(this.getPersonaUID());

			strLog.append(" - objetoSeguridad.getPuesto(): ").append(
					objetoSeguridad.getPuesto());

			objetoSeguridad.setUsuario(this.getUsuario());
			strLog.append(" - objetoSeguridad.getUsuario(): ").append(
					objetoSeguridad.getUsuario());

			objetoSeguridad.setPerfiles(this.getPerfiles());
			XLNetsIdioma = this.getIdioma();
			strLog.append(" - this.getIdioma(): ").append(this.getIdioma());

			if (XLNetsIdioma != null) {
				objetoSeguridad.setIdioma(XLNetsIdioma);
				if ("1".equals(XLNetsIdioma)) {
					clocLocale = "ES";
				} else {
					clocLocale = "EU";
				}
				objetoSeguridad.setPersona(this.getPersonaNombre());
				strLog.append(" - objetoSeguridad.getPersona(): ").append(
						objetoSeguridad.getPersona());
				Locale idioma = new Locale(clocLocale, "");

				HttpSession session = this.request.getSession(true);
				session.setAttribute("IdiomaActual", idioma);
			}
		} catch (Exception e) {
			Aa20bLog.addTraza("Error al obtener el uidFuncion: " + uidFuncion
					+ " - ERROR: " + e.getMessage());
			throw new SecurityException(
					"SecurityHelpperException:getSecurityObject: " + e);
		} finally {
			Aa20bLog.addTraza(strLog.toString());
		}
		return objetoSeguridad;
	}

	public ArrayList<Aa20bDepartamentoXLNET> getDepartamentosGrupoOrganicoXLNETs(
			String grupoOrganico) throws SecurityHelpperException {

		ArrayList<Aa20bDepartamentoXLNET> listaDepartamentos = new ArrayList<Aa20bDepartamentoXLNET>();
		try {
			N38Estructura estructura = new N38Estructura();
			estructura.setTipoEntrada("GO");
			estructura.setUidEntrada(grupoOrganico);
			Document document = this.n38API.n38ItemOrganizacion(estructura);

			NodeList lista;
			try {
				lista = XPathAPI.selectNodeList(document,
						"//elemento[@subtipo=\"n38gruposorganicos\"]");
			} catch (TransformerException e) {
				Aa20bLog.addTraza("ERROR con grupoOrganico: " + grupoOrganico
						+ " - ERROR: " + e.getMessage());
				throw new SecurityHelpperException(
						"SecurityHelpperXLNets:getDepartamentosXLNETs");
			}

			Aa20bDepartamentoXLNET departamento;

			if (lista != null) {
				int nNodos = lista.getLength();
				if (nNodos > 0) {
					for (int i = 0; i < nNodos; i++) {
						if (lista.item(i).getChildNodes().getLength() > 0) {

							String v1 = XPathAPI
									.selectNodeList(lista.item(i),
											"parametro[@id=\"n38uidgrupoorganico\"]/valor/text()")
									.item(0).getNodeValue();
							String v2 = XPathAPI
									.selectNodeList(lista.item(i),
											"parametro[@id=\"n38cadescripcion\"]/valor/text()")
									.item(0).getNodeValue();
							String v3 = XPathAPI
									.selectNodeList(lista.item(i),
											"parametro[@id=\"n38eudescripcion\"]/valor/text()")
									.item(0).getNodeValue();

							departamento = new Aa20bDepartamentoXLNET();
							departamento.setCodigo(v1);
							departamento.setDescC(v2);
							departamento.setDescE(v3);

							listaDepartamentos.add(departamento);
						}
					}
				}
			}
		} catch (Exception e) {
			Aa20bLog.addTraza("ERROR con grupoOrganico: " + grupoOrganico
					+ " - ERROR: " + e.getMessage());
		}

		return listaDepartamentos;
	}

	public ArrayList<Aa20bServicioXLNET> getServiciosXLNETs(String ou)
			throws SecurityHelpperException {

		ArrayList<Aa20bServicioXLNET> listaServicios = new ArrayList<Aa20bServicioXLNET>();
		try {
			N38Estructura estructura = new N38Estructura();
			estructura.setTipoEntrada("GO*");
			estructura.setUidEntrada(ou);
			Document document = this.n38API.n38ItemOrganizacion(estructura);

			String v5 = XPathAPI
					.selectNodeList(document,
							"//parametro[@id=\"n38cadescripcion\"]/valor/text()")
					.item(0).getNodeValue();
			String v6 = XPathAPI
					.selectNodeList(document,
							"//parametro[@id=\"n38eudescripcion\"]/valor/text()")
					.item(0).getNodeValue();

			NodeList lista;
			try {
				// lista = XPathAPI.selectNodeList(document,
				// "/n38/elementos/elemento/elemento[@subtipo=\"n38gruposorganicos\"]");
				lista = XPathAPI.selectNodeList(document,
						"//elemento[@subtipo=\"n38organizationalunit\"]");
			} catch (TransformerException e) {
				Aa20bLog.addTraza("Error1 con ou: " + ou + " - ERROR: "
						+ e.getMessage());
				throw new SecurityHelpperException(
						"SecurityHelpperXLNets:getServiciosXLNETs");
			}

			Aa20bServicioXLNET servicio;

			if (lista != null) {
				int nNodos = lista.getLength();
				if (nNodos > 0) {
					for (int i = 0; i < nNodos; i++) {
						if (lista.item(i).getChildNodes().getLength() > 0) {

							String v1 = XPathAPI
									.selectNodeList(lista.item(i),
											"parametro[@id=\"n38uidorgunit\"]/valor/text()")
									.item(0).getNodeValue();
							String v2 = XPathAPI
									.selectNodeList(lista.item(i),
											"parametro[@id=\"n38cadescripcion\"]/valor/text()")
									.item(0).getNodeValue();
							String v3 = XPathAPI
									.selectNodeList(lista.item(i),
											"parametro[@id=\"n38eudescripcion\"]/valor/text()")
									.item(0).getNodeValue();
							String v4 = XPathAPI
									.selectNodeList(lista.item(i),
											"parametro[@id=\"n38codestrus\"]/valor/text()")
									.item(0).getNodeValue();

							servicio = new Aa20bServicioXLNET();
							servicio.setCodigo(v1);
							servicio.setDescC(v2);
							servicio.setDescE(v3);
							servicio.setCodCog(v4);
							servicio.setDpto(ou);
							servicio.setDescDptoC(v5);
							servicio.setDescDptoE(v6);
							listaServicios.add(servicio);
						}
					}
				}
			}
		} catch (Exception e) {
			Aa20bLog.addTraza("Error2 con ou: " + ou + " - ERROR: "
					+ e.getMessage());
		}

		return listaServicios;
	}

	public Aa20bEdificioXLNET getEdificioPuestoXLNETs(String codEdificio)
			throws SecurityHelpperException {

		try {

			StringBuffer filtro = new StringBuffer();
			filtro.append("n38uidedificio=").append(codEdificio);

			Document document = this.n38API.n38ItemObtenerEdificios(filtro
					.toString());

			NodeList lista;
			try {
				lista = XPathAPI.selectNodeList(document,
						"//elemento[@subtipo=\"n38edificios\"]");
			} catch (TransformerException e) {
				Aa20bLog.addTraza("Error con código: " + codEdificio
						+ " - ERROR: " + e.getMessage());
				throw new SecurityHelpperException(
						"SecurityHelpperXLNets:getEdificioPuestoXLNETs");
			}

			Aa20bEdificioXLNET edificioXLNET;

			if (lista != null) {
				int nNodos = lista.getLength();
				if (nNodos > 0) {
					for (int i = 0; i < nNodos; i++) {
						if (lista.item(i).getChildNodes().getLength() > 0) {

							String v1 = XPathAPI
									.selectNodeList(lista.item(i),
											"parametro[@id=\"n38uidedificio\"]/valor/text()")
									.item(0).getNodeValue();
							String v2 = XPathAPI
									.selectNodeList(lista.item(i),
											"parametro[@id=\"n38caedificio\"]/valor/text()")
									.item(0).getNodeValue();
							String v3 = XPathAPI
									.selectNodeList(lista.item(i),
											"parametro[@id=\"n38euedificio\"]/valor/text()")
									.item(0).getNodeValue();

							edificioXLNET = new Aa20bEdificioXLNET();
							edificioXLNET.setCodigo(v1);
							edificioXLNET.setDescC(v2);
							edificioXLNET.setDescE(v3);

							return edificioXLNET;

						}
					}
				}
			}
		} catch (Exception e) {
			Aa20bLog.addTraza("Error con ou: " + codEdificio + " - ERROR: "
					+ e.getMessage());
		}
		return null;

	}

	public Boolean getListaEdificiosXLNETs(EdificiosXlnetDao edificiosXlnetDao,
			String filtroEdif) throws SecurityHelpperException {

		// ArrayList<Aa20bEdificioXLNET> listaEdificios = new
		// ArrayList<Aa20bEdificioXLNET>();
		try {

			StringBuffer filtro = new StringBuffer();
			/*
			 * filtro.append("postalcode=") .append(codPostal) .append(
			 * "#ATRIB#n38uidedificio#n38provincia#n38caedificio#n38euedificio"
			 * ); if (desCas != null && desCas != "") {
			 * filtro.append("n38caedificio=*") .append(desCas) .append(
			 * "*#ATRIB#n38uidedificio#n38provincia#n38caedificio#n38euedificio"
			 * ); } else if (codPostal != null && codPostal != "") {
			 * filtro.append("postalcode=") .append(codPostal) .append(
			 * "#ATRIB#n38uidedificio#n38provincia#n38caedificio#n38euedificio"
			 * ); } else if (provincia != null && provincia != "") {
			 * filtro.append("n38provincia=*") .append(provincia) .append(
			 * "*#ATRIB#n38uidedificio#n38provincia#n38caedificio#n38euedificio"
			 * ); } else { filtro.append(
			 * "n38uidedificio=99999#ATRIB#n38uidedificio#n38provincia#n38caedificio#n38euedificio"
			 * ); }
			 */

			filtro.append(filtroEdif);
			// .append("#ATRIB#n38uidedificio#n38provincia#n38caedificio#n38euedificio");

			Document document = this.n38API.n38ItemObtenerEdificios(filtro
					.toString());

			NodeList lista;
			try {
				lista = XPathAPI.selectNodeList(document,
						"//elemento[@subtipo=\"n38edificios\"]");
			} catch (TransformerException e) {
				Aa20bLog.addTraza("Error con filtroEdif: " + filtroEdif
						+ " - ERROR: " + e.getMessage());
				throw new SecurityHelpperException(
						"SecurityHelpperXLNets:getEdificioPuestoXLNETs");
			}

			EdificiosXlnet edificioXLNET;

			if (lista != null) {
				int nNodos = lista.getLength();
				if (nNodos > 0) {
					for (int i = 0; i < nNodos; i++) {
						if (lista.item(i).getChildNodes().getLength() > 0) {
							// Solo se cargan los edificios de las provincias
							// que empiezen por 1, 20 o 48
							if (XPathAPI
									.selectNodeList(lista.item(i),
											"parametro[@id=\"n38provincia\"]/valor/text()")
									.getLength() > 0) {
								String codProvincia = XPathAPI
										.selectNodeList(lista.item(i),
												"parametro[@id=\"n38provincia\"]/valor/text()")
										.item(0).getNodeValue();
								if (codProvincia.length() > 1) {
									codProvincia = codProvincia.substring(0, 2);
								}

								if ("1 ".equals(codProvincia)
										|| "20".equals(codProvincia)
										|| "48".equals(codProvincia)) {

									String v1 = XPathAPI
											.selectNodeList(lista.item(i),
													"parametro[@id=\"n38uidedificio\"]/valor/text()")
											.item(0).getNodeValue();
									String v2 = "-";
									if (XPathAPI
											.selectNodeList(lista.item(i),
													"parametro[@id=\"n38caedificio\"]/valor/text()")
											.getLength() > 0) {
										v2 = XPathAPI
												.selectNodeList(lista.item(i),
														"parametro[@id=\"n38caedificio\"]/valor/text()")
												.item(0).getNodeValue();
									}
									String v3 = "-";
									if (XPathAPI
											.selectNodeList(lista.item(i),
													"parametro[@id=\"n38euedificio\"]/valor/text()")
											.getLength() > 0) {
										v3 = XPathAPI
												.selectNodeList(lista.item(i),
														"parametro[@id=\"n38euedificio\"]/valor/text()")
												.item(0).getNodeValue();
									}
									String v4 = XPathAPI
											.selectNodeList(lista.item(i),
													"parametro[@id=\"n38provincia\"]/valor/text()")
											.item(0).getNodeValue();
									String v5 = "";
									if (XPathAPI
											.selectNodeList(lista.item(i),
													"parametro[@id=\"l\"]/valor/text()")
											.getLength() > 0) {
										v5 = XPathAPI
												.selectNodeList(lista.item(i),
														"parametro[@id=\"l\"]/valor/text()")
												.item(0).getNodeValue();
									}
									String v6 = "";
									if (XPathAPI
											.selectNodeList(lista.item(i),
													"parametro[@id=\"street\"]/valor/text()")
											.getLength() > 0) {
										v6 = XPathAPI
												.selectNodeList(lista.item(i),
														"parametro[@id=\"street\"]/valor/text()")
												.item(0).getNodeValue();
									}
									String v7 = "";
									if (XPathAPI
											.selectNodeList(lista.item(i),
													"parametro[@id=\"postalcode\"]/valor/text()")
											.getLength() > 0) {
										v7 = XPathAPI
												.selectNodeList(lista.item(i),
														"parametro[@id=\"postalcode\"]/valor/text()")
												.item(0).getNodeValue();
									}

									edificioXLNET = new EdificiosXlnet();
									edificioXLNET.setN38uidedificio(v1);
									edificioXLNET.setN38caedificio(v2);
									edificioXLNET.setN38euedificio(v3);
									edificioXLNET.setN38provincia(v4);
									edificioXLNET.setLocalidad(v5);
									edificioXLNET.setStreet(v6);
									edificioXLNET.setPostalcode(v7);
									// Añadir el edificio a la tabla de
									// edificiosXLNET
									Aa20bLog.addTraza("Error con EdificiosXLNE: "
											+ i
											+ " --- "
											+ edificioXLNET.toString());
									edificiosXlnetDao.add(edificioXLNET);
									// listaEdificios.add(edificioXLNET);
								}

							}

						}
					}
				}
			}
		} catch (Exception e) {
			Aa20bLog.addTraza("Error con filtroEdif: " + filtroEdif
					+ " - ERROR: " + e.getMessage());
			return false;
		}
		return true;

	}

	/**
	 * Agregar un edificio a la tabla Edificios_XLNET.
	 * 
	 * @param edificioXLNET2
	 *            Aa20bEdificioXLNET
	 * @return
	 */
	public void addEdificioXLNET(Aa20bEdificioXLNET edificioXLNET2) {
		String query = "INSERT INTO EDIFICIOS_XLNET (N38UIDEDIFICIO, N38CAEDIFICIO, N38EUEDIFICIO, POSTALCODE, N38PROVINCIA, LOCALIDAD, STREET) VALUES (?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, edificioXLNET2.getCodigo(),
				edificioXLNET2.getDescC(), edificioXLNET2.getDescC(),
				edificioXLNET2.getCodigoPostal(),
				edificioXLNET2.getProvincia(), edificioXLNET2.getLocalidad(),
				edificioXLNET2.getStreet());

	}

	public Aa20bDireccionXLNET getDireccionPuestoXLNETs(String puesto)
			throws SecurityHelpperException {

		try {
			Document documentPuesto = this.n38API
					.n38ItemObtenerPuestos("n38uidpuesto=" + puesto);
			NodeList lista = XPathAPI.selectNodeList(documentPuesto,
					"//elemento[@subtipo=\"n38puesto\"]");
			String codEstrus = XPathAPI
					.selectNodeList(lista.item(0),
							"parametro[@id=\"n38codestrus\"]/valor/text()")
					.item(0).getNodeValue();
			String grupoOrganico = XPathAPI
					.selectNodeList(lista.item(0),
							"parametro[@id=\"n38grupoorganicouid\"]/valor/text()")
					.item(0).getNodeValue();

			// Con el código cogemos ahora las descripciones en castellano y en
			// euskera
			N38Estructura estructura = new N38Estructura();
			estructura.setTipoEntrada("GO*");
			estructura.setUidEntrada(grupoOrganico);
			Document documentDireccion = this.n38API
					.n38ItemOrganizacion(estructura);

			try {
				lista = XPathAPI.selectNodeList(documentDireccion,
						"//elemento[@subtipo=\"n38organizationalunit\"]");

				if (lista != null) {
					String codigo = "";
					String descc = "";
					String desce = "";
					String codDireccion = "";
					for (int i = 0; i < lista.getLength(); i++) {
						codigo = XPathAPI
								.selectNodeList(lista.item(i),
										"parametro[@id=\"n38codestrus\"]/valor/text()")
								.item(0).getNodeValue();
						if (codigo.equals(codEstrus)) {
							descc = XPathAPI
									.selectNodeList(lista.item(i),
											"parametro[@id=\"n38cadescripcion\"]/valor/text()")
									.item(0).getNodeValue();
							desce = XPathAPI
									.selectNodeList(lista.item(i),
											"parametro[@id=\"n38eudescripcion\"]/valor/text()")
									.item(0).getNodeValue();
							codDireccion = XPathAPI
									.selectNodeList(lista.item(i),
											"parametro[@id=\"n38uidorgunit\"]/valor/text()")
									.item(0).getNodeValue();

							Aa20bDireccionXLNET direccion = new Aa20bDireccionXLNET();
							direccion.setCodigo(codDireccion);
							direccion.setDescC(descc);
							direccion.setDescE(desce);
							direccion.setCodestrus(codEstrus);

							return direccion;
						}
					}
				}

			} catch (TransformerException e) {
				Aa20bLog.addTraza("Error con puesto: " + puesto + " - ERROR: "
						+ e.getMessage());
				throw new SecurityHelpperException(
						"SecurityHelpperXLNets:getServiciosXLNETs");
			}
		} catch (Exception e) {
			Aa20bLog.addTraza("Error con puesto: " + puesto + " - ERROR: "
					+ e.getMessage());
		}

		return null;
	}

	public ArrayList<Aa20bDepartamentoXLNET> getDepartamentosXLNETs(
			String uidEntrada) throws SecurityHelpperException {

		ArrayList<Aa20bDepartamentoXLNET> listaDepartamentos = new ArrayList<Aa20bDepartamentoXLNET>();
		try {
			N38Estructura estructura = new N38Estructura();
			estructura.setTipoEntrada("ALL");
			estructura.setUidEntrada(uidEntrada);
			Document document = this.n38API.n38ItemOrganizacion(estructura); // "ALL",
			// "1"

			NodeList lista;
			try {
				// lista = XPathAPI.selectNodeList(document,
				// "/n38/elementos/elemento/elemento[@subtipo=\"n38gruposorganicos\"]");
				lista = XPathAPI.selectNodeList(document,
						"//elemento[@subtipo=\"n38gruposorganicos\"]");
			} catch (TransformerException e) {
				Aa20bLog.addTraza("Error: " + e.getMessage());
				throw new SecurityHelpperException(
						"SecurityHelpperXLNets:getDepartamentosXLNETs");
			}

			Aa20bDepartamentoXLNET departamento;

			if (lista != null) {
				int nNodos = lista.getLength();
				if (nNodos > 0) {
					for (int i = 0; i < nNodos; i++) {
						if (lista.item(i).getChildNodes().getLength() > 0) {

							String v1 = XPathAPI
									.selectNodeList(lista.item(i),
											"parametro[@id=\"n38uidgrupoorganico\"]/valor/text()")
									.item(0).getNodeValue();
							String v2 = XPathAPI
									.selectNodeList(lista.item(i),
											"parametro[@id=\"n38cadescripcion\"]/valor/text()")
									.item(0).getNodeValue();
							String v3 = XPathAPI
									.selectNodeList(lista.item(i),
											"parametro[@id=\"n38eudescripcion\"]/valor/text()")
									.item(0).getNodeValue();
							String v4 = XPathAPI
									.selectNodeList(lista.item(i),
											"parametro[@id=\"n38dptorgus\"]/valor/text()")
									.item(0).getNodeValue();

							departamento = new Aa20bDepartamentoXLNET();
							departamento.setCodigo(v1);
							departamento.setDescC(v4 + '-' + v2);
							departamento.setDescE(v4 + '-' + v3);

							listaDepartamentos.add(departamento);
							Aa20bLog.addTraza("Departamentos: "
									+ departamento.getDescC());
						}
					}
				}
			}
		} catch (Exception e) {
			Aa20bLog.addTraza("ERROR: " + e.getMessage());
		}

		return listaDepartamentos;
	}

	public ArrayList<String> getCodDepartamentosXLNETs()
			throws SecurityHelpperException {

		ArrayList<String> listaDepartamentos = new ArrayList<String>();
		try {
			N38Estructura estructura = new N38Estructura();
			estructura.setTipoEntrada("ALL");
			estructura.setUidEntrada("1");
			Document document = this.n38API.n38ItemOrganizacion(estructura); // "ALL","1"

			NodeList lista;
			try {
				lista = XPathAPI.selectNodeList(document,
						"//elemento[@subtipo=\"n38gruposorganicos\"]");
			} catch (TransformerException e) {
				Aa20bLog.addTraza("ERROR: " + e.getMessage());
				throw new SecurityHelpperException(
						"SecurityHelpperXLNets:getDepartamentosXLNETs");
			}

			if (lista != null) {
				int nNodos = lista.getLength();
				if (nNodos > 0) {
					for (int i = 0; i < nNodos; i++) {
						if (lista.item(i).getChildNodes().getLength() > 0) {
							listaDepartamentos
									.add(XPathAPI
											.selectNodeList(lista.item(i),
													"parametro[@id=\"n38uidgrupoorganico\"]/valor/text()")
											.item(0).getNodeValue());
						}
					}
				}
			}
		} catch (Exception e) {
			Aa20bLog.addTraza("ERROR: " + e.getMessage());
		}

		return listaDepartamentos;
	}

	public ArrayList<Aa20bDepartamentoXLNET> getDepartamentosYOrganismosXLNETs()
			throws SecurityHelpperException {

		ArrayList<Aa20bDepartamentoXLNET> listaDepartamentos = new ArrayList<Aa20bDepartamentoXLNET>();
		try {
			N38Estructura estructura = new N38Estructura();
			estructura.setTipoEntrada("ALL");
			estructura.setUidEntrada("ALL");
			Document document = this.n38API.n38ItemOrganizacion(estructura); // "ALL","ALL"

			NodeList lista;
			try {
				lista = XPathAPI.selectNodeList(document,
						"//elemento[@subtipo=\"n38organization\"]");
			} catch (TransformerException e) {
				Aa20bLog.addTraza("Error: " + e.getMessage());
				throw new SecurityHelpperException(
						"SecurityHelpperXLNets:getDepartamentosYOrganismosXLNETs");
			}

			if (lista != null) {
				int nNodos = lista.getLength();
				if (nNodos > 0) {
					for (int i = 0; i < nNodos; i++) {
						if (lista.item(i).getChildNodes().getLength() > 0) {

							String v1 = XPathAPI
									.selectNodeList(lista.item(i),
											"parametro[@id=\"n38uidorg\"]/valor/text()")
									.item(0).getNodeValue();

							listaDepartamentos.addAll(this
									.getDepartamentosXLNETs(v1));

							/*
							 * if ("1".equals(v1)) // GV { // El grupo �rganico
							 * del GV no lo tratamos // porque para el cogemos
							 * todos sus // departamentos // con la funci�n
							 * getDepartamentosXLNETs
							 * ArrayList<Aa20bDepartamentoXLNET> departamentosGV
							 * = this .getDepartamentosXLNETs();
							 * listaDepartamentos.addAll(departamentosGV); }
							 * else { String v2 = XPathAPI
							 * .selectNodeList(lista.item(i),
							 * "parametro[@id=\"n38cadescripcion\"]/valor/text()"
							 * ) .item(0).getNodeValue(); String v3 = XPathAPI
							 * .selectNodeList(lista.item(i),
							 * "parametro[@id=\"n38eudescripcion\"]/valor/text()"
							 * ) .item(0).getNodeValue(); String v4 = XPathAPI
							 * .selectNodeList(lista.item(i),
							 * "parametro[@id=\"n38dptorgus\"]/valor/text()")
							 * .item(0).getNodeValue();
							 * 
							 * departamento = new Aa20bDepartamentoXLNET();
							 * departamento.setCodigo(v1);
							 * departamento.setDescC(v4 + '-' + v2);
							 * departamento.setDescE(v4 + '-' + v3);
							 * 
							 * listaDepartamentos.add(departamento); }
							 */
						}
					}
				}
			}
		} catch (Exception e) {
			Aa20bLog.addTraza("Error: " + e.getMessage());
		}

		return listaDepartamentos;
	}

	public ArrayList<String> getCodDepartamentosYOrganismosGXLNETs()
			throws SecurityHelpperException {

		ArrayList<String> listaDepartamentos = new ArrayList<String>();
		try {
			N38Estructura estructura = new N38Estructura();
			estructura.setTipoEntrada("ALL");
			estructura.setUidEntrada("ALL");
			Document document = this.n38API.n38ItemOrganizacion(estructura); // "ALL","ALL"

			NodeList lista;
			try {
				lista = XPathAPI.selectNodeList(document,
						"//elemento[@subtipo=\"n38organization\"]");
			} catch (TransformerException e) {
				Aa20bLog.addTraza("Error: " + e.getMessage());
				throw new SecurityHelpperException(
						"SecurityHelpperXLNets:getCodDepartamentosYOrganismosXLNETs");
			}

			if (lista != null) {
				int nNodos = lista.getLength();
				if (nNodos > 0) {
					String v1 = "";
					String v2 = "";
					for (int i = 0; i < nNodos; i++) {
						if (lista.item(i).getChildNodes().getLength() > 0) {
							v1 = XPathAPI
									.selectNodeList(lista.item(i),
											"parametro[@id=\"n38uidorg\"]/valor/text()")
									.item(0).getNodeValue();
							if ("1".equals(v1)) // GV
							{
								// El grupo Órganico del GV no lo tratamos
								// porque para él cogemos todos sus
								// departamentos
								// con la función getDepartamentosXLNETs
								ArrayList<String> departamentosGV = this
										.getCodDepartamentosXLNETs();
								listaDepartamentos.addAll(departamentosGV);
							} else {
								v2 = XPathAPI
										.selectNodeList(lista.item(i),
												"parametro[@id=\"n38idtipoorganizacion\"]/valor/text()")
										.item(0).getNodeValue();
								if ("G".equals(v2)) {
									listaDepartamentos.add(v1);
								}
							}
						}
					}
				}
			}
		} catch (Exception e) {
			Aa20bLog.addTraza("Error: " + e.getMessage());
		}

		return listaDepartamentos;
	}

	public ArrayList<Aa20bPersonaXLNET> getPersonasXLNETs(String codigo,
			String dni, String nombre, String apellidos,
			String grupoOrganicoUID, String puesto)
			throws SecurityHelpperException {

		ArrayList<Aa20bPersonaXLNET> listaPersonas = new ArrayList<Aa20bPersonaXLNET>();
		ArrayList<Aa20bDepartamentoXLNET> listaDepartamentos;
		// ArrayList<Aa20bServicioXLNET> listaServicios;
		Aa20bDireccionXLNET direccion;
		Aa20bEdificioXLNET edificio;
		try {
			StringBuffer filtro = new StringBuffer();
			if (codigo != null && !codigo.equals("")) {
				filtro.append("uid=").append(codigo);
			}
			if (dni != null && !dni.equals("")) {
				filtro.append("dni=").append(dni);
			}
			if (nombre != null && !nombre.equals("")) {
				filtro.append("givenname=").append(nombre);
			}
			if (apellidos != null && !apellidos.equals("")) {
				filtro.append("sn=").append(apellidos);
			}
			if (puesto != null && !puesto.equals("")) {
				filtro.append("n38puestouid=").append(puesto);
			}
			// if (filtro.length() > 0) {
			// if (grupoOrganicoUID != null && !grupoOrganicoUID.equals("")) {
			// filtro.append("n38grupoorganicouid=").append(grupoOrganicoUID);
			// }
			// }

			Document document = this.n38API.n38ItemObtenerPersonas(filtro
					.toString());
			Document documentPuesto;

			NodeList lista;
			NodeList listaDepto;
			try {
				lista = XPathAPI.selectNodeList(document,
						"//elemento[@subtipo=\"n38persona\"]");
			} catch (TransformerException e) {
				Aa20bLog.addTraza("Error con código: " + codigo + " - ERROR: "
						+ e.getMessage());
				throw new SecurityHelpperException(
						"SecurityHelpperXLNets:getPersonasXLNETs");
			}

			Aa20bPersonaXLNET persona;

			if (lista != null) {
				int nNodos = lista.getLength();
				if (nNodos > 0) {
					for (int i = 0; i < nNodos; i++) {
						if (lista.item(i).getChildNodes().getLength() > 0) {
							String v1 = XPathAPI
									.selectNodeList(lista.item(i),
											"parametro[@id=\"uid\"]/valor/text()")
									.item(0).getNodeValue();
							String v2 = XPathAPI
									.selectNodeList(lista.item(i),
											"parametro[@id=\"dni\"]/valor/text()")
									.item(0).getNodeValue();
							String v3 = XPathAPI
									.selectNodeList(lista.item(i),
											"parametro[@id=\"givenname\"]/valor/text()")
									.item(0).getNodeValue();
							String v4 = XPathAPI
									.selectNodeList(lista.item(i),
											"parametro[@id=\"sn\"]/valor/text()")
									.item(0).getNodeValue();
							String v5 = XPathAPI
									.selectNodeList(lista.item(i),
											"parametro[@id=\"n38puestouid\"]/valor/text()")
									.item(0).getNodeValue();
							String v6 = "";
							String v7 = "";
							String v8 = "";
							String v9 = "";
							String v10 = "";
							String v11 = "";
							String v11tmp = "";
							String v12 = "";
							String v13 = "";
							String v14 = "";
							String v15 = "";
							String v16 = "";
							String v17 = "";
							String v18 = "";
							String v19 = "";
							String v20 = "";

							/*
							 * NodeList nlE = XPathAPI
							 * .selectNodeList(lista.item(i),
							 * "parametro[@id=\"n38coedificio\"]/valor/text()");
							 * if (nlE.getLength() > 0) { v15 =
							 * nlE.item(0).getNodeValue(); }
							 * 
							 * NodeList nlP = XPathAPI
							 * .selectNodeList(lista.item(i),
							 * "parametro[@id=\"n38coplanta\"]/valor/text()");
							 * if (nlP.getLength() > 0) { v16 =
							 * nlP.item(0).getNodeValue(); }
							 * 
							 * NodeList nlZ = XPathAPI
							 * .selectNodeList(lista.item(i),
							 * "parametro[@id=\"n38cozona\"]/valor/text()"); if
							 * (nlZ.getLength() > 0) { v17 =
							 * nlZ.item(0).getNodeValue(); }
							 */

							NodeList nlt = XPathAPI
									.selectNodeList(lista.item(i),
											"parametro[@id=\"telephonenumber\"]/valor/text()");
							if (nlt.getLength() > 0) {
								v10 = nlt.item(0).getNodeValue();
							}
							NodeList nlm = XPathAPI.selectNodeList(
									lista.item(i),
									"parametro[@id=\"mail\"]/valor/text()");
							if (nlm.getLength() > 0) {
								v9 = nlm.item(0).getNodeValue();
							}

							persona = new Aa20bPersonaXLNET();
							persona.setCodigo(v1);
							persona.setDni(v2);
							persona.setNombre(v3);
							persona.setApellidos(v4);
							persona.setEMail(v9);
							persona.setTelefono(v10);

							/* CON EL PUESTO OBTENEMOS EL DEPARTAMENTO */
							try {
								documentPuesto = this.n38API
										.n38ItemObtenerPuestos("n38uidpuesto="
												+ v5);
								listaDepto = XPathAPI.selectNodeList(
										documentPuesto,
										"//elemento[@subtipo=\"n38puesto\"]");

								NodeList nlp = XPathAPI
										.selectNodeList(listaDepto.item(0),
												"parametro[@id=\"n38decam\"]/valor/text()");
								persona.setVip("0");

								for (int a = 0; a < nlp.getLength(); a++) {
									v11tmp = nlp.item(0).getNodeValue();
									if ("LEHE".equalsIgnoreCase(v11tmp)
											|| "CONS".equalsIgnoreCase(v11tmp)
											|| "VI.C".equalsIgnoreCase(v11tmp)
											|| "DIR.".equalsIgnoreCase(v11tmp)
											|| "DI/G".equalsIgnoreCase(v11tmp)
											|| "SE/G".equalsIgnoreCase(v11tmp)
											|| "SEC.".equalsIgnoreCase(v11tmp)) {
										persona.setVip("1");
										break;
									}
								}
								// ---------------------
								nlp = XPathAPI
										.selectNodeList(listaDepto.item(0),
												"parametro[@id=\"n38cadescripcion\"]/valor/text()");
								if (nlp.getLength() > 0) {
									v11 = nlp.item(0).getNodeValue();
								}
								for (int a = 0; a < nlp.getLength(); a++) {
									v11tmp = nlp.item(0).getNodeValue();
									if (v11tmp.toUpperCase().indexOf("DELEG") != -1) {
										persona.setVip("1");
										break;
									}
									if (v11tmp.toUpperCase().indexOf("ASESOR") != -1) {
										if ((v11tmp.toUpperCase().indexOf(
												"JURID") == -1)
												&& (v11tmp.toUpperCase()
														.indexOf("COMIS") == -1)) {
											persona.setVip("1");
											break;
										}
									}
								}

								// -----------------

								v6 = XPathAPI
										.selectNodeList(listaDepto.item(0),
												"parametro[@id=\"n38grupoorganicouid\"]/valor/text()")
										.item(0).getNodeValue();

								listaDepartamentos = this
										.getDepartamentosGrupoOrganicoXLNETs(v6);
								if (listaDepartamentos != null
										&& listaDepartamentos.size() > 0) {
									v6 = listaDepartamentos.get(0).getCodigo();
									v7 = listaDepartamentos.get(0).getDescC();
									v8 = listaDepartamentos.get(0).getDescE();
								}

								v12 = XPathAPI
										.selectNodeList(listaDepto.item(0),
												"parametro[@id=\"ou\"]/valor/text()")
										.item(0).getNodeValue();

								// NUEVO
								direccion = this.getDireccionPuestoXLNETs(v5);
								v12 = direccion.getCodigo();
								v13 = direccion.getDescC();
								v14 = direccion.getDescE();
								v20 = direccion.getCodestrus();

								//

								// Obtenemos el Edificio, zona y planta del
								// Puesto
								v15 = XPathAPI
										.selectNodeList(listaDepto.item(0),
												"parametro[@id=\"n38coedificio\"]/valor/text()")
										.item(0).getNodeValue();

								edificio = this.getEdificioPuestoXLNETs(v15);
								v18 = edificio.getDescC();
								v19 = edificio.getDescE();

								v17 = XPathAPI
										.selectNodeList(listaDepto.item(0),
												"parametro[@id=\"n38cozona\"]/valor/text()")
										.item(0).getNodeValue();
								v16 = XPathAPI
										.selectNodeList(listaDepto.item(0),
												"parametro[@id=\"n38coplanta\"]/valor/text()")
										.item(0).getNodeValue();

								persona.setCodPlanta(v16);
								persona.setCodZona(v17);

								/*
								 * listaServicios =
								 * this.getServiciosXLNETs(v12); if
								 * (listaServicios != null &&
								 * listaServicios.size() > 0) { v12 =
								 * listaServicios.get(0).getCodigo(); v13 =
								 * listaServicios.get(0).getDescC(); v14 =
								 * listaServicios.get(0).getDescE(); }
								 */

							} catch (Exception e) {
								Aa20bLog.addTraza("Error con código: " + codigo
										+ " - ERROR: " + e.getMessage());
							}
							/**/

							persona.setCodDepto(v6);
							persona.setDescDeptoC(v7);
							persona.setDescDeptoE(v8);
							persona.setCodDireccion(v12);
							persona.setDescDireccionC(v13);
							persona.setDescDireccionE(v14);
							persona.setCodestrus(v20);

							persona.setCodEdificio(v15);
							persona.setDescEdificioC(v18);
							persona.setDescEdificioE(v19);

							persona.setCargo("");
							persona.setPuesto(v11);

							if (grupoOrganicoUID != null
									&& grupoOrganicoUID.length() > 0) {
								if (persona.getCodDepto().equals(
										grupoOrganicoUID)) {
									listaPersonas.add(persona);
								}
							} else {
								listaPersonas.add(persona);
							}
						}
					}
				}
			}
		} catch (Exception e) {
			Aa20bLog.addTraza("Error con código: " + codigo + " - ERROR: "
					+ e.getMessage());
		}

		return listaPersonas;
	}

	/*
	 * public ArrayList<String> getMailsValidadoresCorreoDepartamentoXLNETs(
	 * String codigoDepartamento) throws SecurityHelpperException {
	 * 
	 * ArrayList<String> listaMailsValidadores = new ArrayList<String>(); try {
	 * String filtro = Aa20bConstantes.XLNET_GRUPO_VALIDADOR_CON_MAIL; Document
	 * document = this.n38API.n38ItemGrupoPuestos(filtro); Document
	 * documentPersona;
	 * 
	 * NodeList lista; NodeList listaPersona; try { lista =
	 * XPathAPI.selectNodeList(document, "//elemento[@subtipo=\"n38puesto\"]");
	 * } catch (TransformerException e) {
	 * Aa20bLog.addTraza("Error al obtener los usuarios del grupo=" + filtro +
	 * " - Código de departamento: " + codigoDepartamento + " - ERROR: " +
	 * e.getMessage()); throw new SecurityHelpperException(
	 * "SecurityHelpperXLNets:MailsValidadoresDepartamentoXLNETs"); }
	 * 
	 * if (lista != null) { int nNodos = lista.getLength(); if (nNodos > 0) {
	 * String vDepto = ""; String vDni = ""; String vMail = ""; for (int i = 0;
	 * i < nNodos; i++) { if (lista.item(i).getChildNodes().getLength() > 0) {
	 * vDepto = XPathAPI .selectNodeList(lista.item(i),
	 * "parametro[@id=\"n38grupoorganicouid\"]/valor/text()")
	 * .item(0).getNodeValue(); if (vDepto.equals(codigoDepartamento)) { vDni =
	 * XPathAPI .selectNodeList(lista.item(i),
	 * "parametro[@id=\"roleoccupant\"]/valor/text()") .item(0).getNodeValue();
	 * 
	 * //CON EL DNI OBTENEMOS LA PERSONA try { documentPersona = this.n38API
	 * .n38ItemObtenerPersonas("dni=" + vDni); listaPersona = XPathAPI
	 * .selectNodeList(documentPersona, "//elemento[@subtipo=\"n38persona\"]");
	 * if (listaPersona != null && listaPersona.getLength() > 0) { NodeList nlm
	 * = XPathAPI .selectNodeList( listaPersona.item(0),
	 * "parametro[@id=\"mail\"]/valor/text()"); if (nlm.getLength() > 0) { vMail
	 * = nlm.item(0).getNodeValue(); } } } catch (Exception e) {
	 * Aa20bLog.addTraza("Error al obtener los usuarios del grupo=" + filtro +
	 * " - Código de departamento: " + codigoDepartamento + " - ERROR: " +
	 * e.getMessage()); } //
	 * 
	 * if (vMail != null && !"".equals(vMail)) {
	 * listaMailsValidadores.add(vMail); } } } } } } } catch (Exception e) {
	 * Aa20bLog.addTraza("Error con Código de departamento: " +
	 * codigoDepartamento + " - ERROR: " + e.getMessage()); }
	 * 
	 * return listaMailsValidadores; }
	 */

	/*
	 * public ArrayList<String> getMailsValidadoresCorreoDepartamentoXLNETs2(
	 * String codigoDepartamento) throws SecurityHelpperException {
	 * 
	 * ArrayList<String> listaMailsValidadores = new ArrayList<String>(); try {
	 * String filtro = Aa20bConstantes.XLNET_GRUPO_VALIDADOR_CON_MAIL;
	 * StringBuffer filtroPuestos = new StringBuffer(); StringBuffer
	 * filtroPersonas = new StringBuffer(); Document document =
	 * this.n38API.n38ItemGrupoPuestos(filtro); Document documentPuestos;
	 * Document documentPersonas;
	 * 
	 * NodeList lista; NodeList listaMembers; NodeList listaPuestos; NodeList
	 * listaPersonas; try { lista = XPathAPI.selectNodeList(document,
	 * "//elemento[@subtipo=\"n38grupoUsuarios\"]"); } catch
	 * (TransformerException e) {
	 * Aa20bLog.addTraza("Error al obtener los usuarios del grupo=" + filtro +
	 * " - Código de departamento: " + codigoDepartamento + " - ERROR: " +
	 * e.getMessage()); throw new SecurityHelpperException(
	 * "SecurityHelpperXLNets:MailsValidadoresDepartamentoXLNETs2"); }
	 * 
	 * if (lista != null) { if (lista.getLength() > 0) { listaMembers =
	 * XPathAPI.selectNodeList(lista.item(0),
	 * "parametro[@id=\"member\"]/valor/text()");
	 * 
	 * if (listaMembers != null) { if (listaMembers.getLength() > 0) {
	 * filtroPuestos.append("(&(|"); for (int i = 0; i <
	 * listaMembers.getLength(); i++) { filtroPuestos .append(" (n38uidpuesto=")
	 * .append(listaMembers.item(i) .getNodeValue()).append(")"); }
	 * filtroPuestos.append(")") .append("(n38grupoorganicouid=")
	 * .append(codigoDepartamento).append("))");
	 * 
	 * documentPuestos = this.n38API .n38ItemObtenerPuestos(filtroPuestos
	 * .toString()); listaPuestos = XPathAPI.selectNodeList( documentPuestos,
	 * "//elemento[@subtipo=\"n38puesto\"]");
	 * 
	 * if (listaPuestos != null) { if (listaPuestos.getLength() > 0) {
	 * filtroPersonas.append("(|"); String dni = ""; for (int i = 0; i <
	 * listaPuestos .getLength(); i++) { dni = XPathAPI .selectNodeList(
	 * listaPuestos.item(i), "parametro[@id=\"roleoccupant\"]/valor/text()")
	 * .item(0).getNodeValue(); filtroPersonas.append(" (dni=")
	 * .append(dni).append(")"); } filtroPersonas.append(")"); } }
	 * 
	 * documentPersonas = this.n38API .n38ItemObtenerPersonas(filtroPersonas
	 * .toString()); listaPersonas = XPathAPI.selectNodeList( documentPersonas,
	 * "//elemento[@subtipo=\"n38persona\"]");
	 * 
	 * if (listaPersonas != null) { if (listaPersonas.getLength() > 0) { String
	 * mail = ""; NodeList nlm = null; for (int i = 0; i < listaPersonas
	 * .getLength(); i++) { nlm = XPathAPI .selectNodeList(
	 * listaPersonas.item(i), "parametro[@id=\"mail\"]/valor/text()"); if
	 * (nlm.getLength() > 0) { mail = nlm.item(0).getNodeValue();
	 * listaMailsValidadores.add(mail); } } } } } } } } } catch (Exception e) {
	 * Aa20bLog.addTraza("Error con Código de departamento: " +
	 * codigoDepartamento + " - ERROR: " + e.getMessage()); }
	 * 
	 * return listaMailsValidadores; }
	 */

	/*
	 * public ArrayList<String> getMailsValidadoresServiciosDepartamentoXLNETs2(
	 * String codigoDepartamento) throws SecurityHelpperException {
	 * 
	 * ArrayList<String> listaMailsValidadores = new ArrayList<String>(); try {
	 * String filtro = Aa20bConstantes.XLNET_GRUPO_VALIDADOR_SERVICIOS;
	 * StringBuffer filtroPuestos = new StringBuffer(); StringBuffer
	 * filtroPersonas = new StringBuffer(); Document document =
	 * this.n38API.n38ItemGrupoPuestos(filtro); Document documentPuestos;
	 * Document documentPersonas;
	 * 
	 * NodeList lista; NodeList listaMembers; NodeList listaPuestos; NodeList
	 * listaPersonas; try { lista = XPathAPI.selectNodeList(document,
	 * "//elemento[@subtipo=\"n38grupoUsuarios\"]"); } catch
	 * (TransformerException e) {
	 * Aa20bLog.addTraza("Error al obtener los usuarios del grupo=" + filtro +
	 * " - Código de departamento: " + codigoDepartamento + " - ERROR: " +
	 * e.getMessage()); throw new SecurityHelpperException(
	 * "SecurityHelpperXLNets:getMailsValidadoresServiciosDepartamentoXLNETs2");
	 * }
	 * 
	 * if (lista != null) { if (lista.getLength() > 0) { listaMembers =
	 * XPathAPI.selectNodeList(lista.item(0),
	 * "parametro[@id=\"member\"]/valor/text()");
	 * 
	 * if (listaMembers != null) { if (listaMembers.getLength() > 0) {
	 * filtroPuestos.append("(&(|"); for (int i = 0; i <
	 * listaMembers.getLength(); i++) { filtroPuestos .append(" (n38uidpuesto=")
	 * .append(listaMembers.item(i) .getNodeValue()).append(")"); }
	 * filtroPuestos.append(")") .append("(n38grupoorganicouid=")
	 * .append(codigoDepartamento).append("))");
	 * 
	 * documentPuestos = this.n38API .n38ItemObtenerPuestos(filtroPuestos
	 * .toString()); listaPuestos = XPathAPI.selectNodeList( documentPuestos,
	 * "//elemento[@subtipo=\"n38puesto\"]");
	 * 
	 * if (listaPuestos != null) { if (listaPuestos.getLength() > 0) {
	 * filtroPersonas.append("(|"); String dni = ""; NodeList nlm = null; for
	 * (int i = 0; i < listaPuestos .getLength(); i++) { nlm = XPathAPI
	 * .selectNodeList( listaPuestos.item(i),
	 * "parametro[@id=\"roleoccupant\"]/valor/text()"); if (nlm.getLength() > 0)
	 * { dni = nlm.item(0).getNodeValue(); filtroPersonas.append(" (dni=")
	 * .append(dni).append(")"); } else {
	 * Aa20bLog.addTraza("No se ha econtrado dni (roleoccupant) para el puesto."
	 * ); } } filtroPersonas.append(")"); } }
	 * 
	 * documentPersonas = this.n38API .n38ItemObtenerPersonas(filtroPersonas
	 * .toString()); listaPersonas = XPathAPI.selectNodeList( documentPersonas,
	 * "//elemento[@subtipo=\"n38persona\"]");
	 * 
	 * if (listaPersonas != null) { if (listaPersonas.getLength() > 0) { String
	 * mail = ""; NodeList nlm = null; for (int i = 0; i < listaPersonas
	 * .getLength(); i++) { nlm = XPathAPI .selectNodeList(
	 * listaPersonas.item(i), "parametro[@id=\"mail\"]/valor/text()"); if
	 * (nlm.getLength() > 0) { mail = nlm.item(0).getNodeValue();
	 * listaMailsValidadores.add(mail); } } } } } } } } } catch (Exception e) {
	 * Aa20bLog.addTraza("Error con Código de departamento: " +
	 * codigoDepartamento + " - ERROR: " + e.getMessage()); }
	 * 
	 * return listaMailsValidadores; }
	 */
	/*
	 * public ArrayList<String> getMailsValidadoresDireccionXLNETs2( String
	 * codigoDireccion) throws SecurityHelpperException {
	 * 
	 * ArrayList<String> listaMailsValidadores = new ArrayList<String>(); try {
	 * String filtro = Aa20bConstantes.XLNET_GRUPO_VALIDADOR; StringBuffer
	 * filtroPuestos = new StringBuffer(); StringBuffer filtroPersonas = new
	 * StringBuffer(); Document document =
	 * this.n38API.n38ItemGrupoPuestos(filtro); Document documentPuestos;
	 * Document documentPersonas;
	 * 
	 * NodeList lista; NodeList listaMembers; NodeList listaPuestos; NodeList
	 * listaPersonas; try { lista = XPathAPI.selectNodeList(document,
	 * "//elemento[@subtipo=\"n38grupoUsuarios\"]"); } catch
	 * (TransformerException e) {
	 * Aa20bLog.addTraza("Error al obtener los usuarios del grupo=" + filtro +
	 * " - Código de dirección: " + codigoDireccion + " - ERROR: " +
	 * e.getMessage()); throw new SecurityHelpperException(
	 * "SecurityHelpperXLNets:getMailsValidadoresDireccionXLNETs2"); }
	 * 
	 * if (lista != null) { if (lista.getLength() > 0) { listaMembers =
	 * XPathAPI.selectNodeList(lista.item(0),
	 * "parametro[@id=\"member\"]/valor/text()");
	 * 
	 * if (listaMembers != null) { if (listaMembers.getLength() > 0) {
	 * filtroPuestos.append("(&(|"); for (int i = 0; i <
	 * listaMembers.getLength(); i++) { filtroPuestos .append(" (n38uidpuesto=")
	 * .append(listaMembers.item(i) .getNodeValue()).append(")"); }
	 * filtroPuestos.append(")").append("(n38codestrus=")
	 * .append(codigoDireccion).append("*))");
	 * 
	 * documentPuestos = this.n38API .n38ItemObtenerPuestos(filtroPuestos
	 * .toString()); listaPuestos = XPathAPI.selectNodeList( documentPuestos,
	 * "//elemento[@subtipo=\"n38puesto\"]");
	 * 
	 * if (listaPuestos != null) { if (listaPuestos.getLength() > 0) {
	 * filtroPersonas.append("(|"); String dni = ""; NodeList nlm = null; for
	 * (int i = 0; i < listaPuestos .getLength(); i++) { nlm = XPathAPI
	 * .selectNodeList( listaPuestos.item(i),
	 * "parametro[@id=\"roleoccupant\"]/valor/text()"); if (nlm.getLength() > 0)
	 * { dni = nlm.item(0).getNodeValue(); filtroPersonas.append(" (dni=")
	 * .append(dni).append(")"); } else {
	 * Aa20bLog.addTraza("No se ha econtrado dni (roleoccupant) para el puesto."
	 * ); } } filtroPersonas.append(")"); } }
	 * 
	 * documentPersonas = this.n38API .n38ItemObtenerPersonas(filtroPersonas
	 * .toString()); listaPersonas = XPathAPI.selectNodeList( documentPersonas,
	 * "//elemento[@subtipo=\"n38persona\"]");
	 * 
	 * if (listaPersonas != null) { if (listaPersonas.getLength() > 0) { String
	 * mail = ""; NodeList nlm = null; for (int i = 0; i < listaPersonas
	 * .getLength(); i++) { nlm = XPathAPI .selectNodeList(
	 * listaPersonas.item(i), "parametro[@id=\"mail\"]/valor/text()"); if
	 * (nlm.getLength() > 0) { mail = nlm.item(0).getNodeValue();
	 * listaMailsValidadores.add(mail); } } } } } } } } } catch (Exception e) {
	 * Aa20bLog.addTraza("Error con Código de dirección: " + codigoDireccion +
	 * " - ERROR: " + e.getMessage()); }
	 * 
	 * return listaMailsValidadores; }
	 */
	/*
	 * public boolean existeValidador(String dniUsuario1, String dniUsuario2)
	 * throws SecurityHelpperException {
	 * 
	 * try { Aa20bLog.addTraza("INI existeValidador");
	 * 
	 * // SIN MAIL String filtro = Aa20bConstantes.XLNET_GRUPO_VALIDADOR;
	 * Document document = this.n38API.n38ItemGrupoPuestos(filtro); NodeList
	 * lista;
	 * 
	 * Aa20bLog.addTraza("dniUsuario1= " + dniUsuario1 + " - dniUsuario2= " +
	 * dniUsuario1 + " - FILTRO: " + filtro);
	 * 
	 * try { lista = XPathAPI.selectNodeList(document,
	 * "//elemento[@subtipo=\"n38puesto\"]"); } catch (TransformerException e) {
	 * Aa20bLog.addTraza("dniUsuario1= " + dniUsuario1 + " - dniUsuario2= " +
	 * dniUsuario1 + " - FILTRO: " + filtro + " - ERROR: " + e.getMessage());
	 * throw new SecurityHelpperException(
	 * "SecurityHelpperXLNets:existeValidador"); }
	 * 
	 * if (lista != null) { int nNodos = lista.getLength(); if (nNodos > 0) {
	 * String vDni = ""; for (int i = 0; i < nNodos; i++) { if
	 * (lista.item(i).getChildNodes().getLength() > 0) { vDni = XPathAPI
	 * .selectNodeList(lista.item(i),
	 * "parametro[@id=\"roleoccupant\"]/valor/text()") .item(0).getNodeValue();
	 * 
	 * Aa20bLog.addTraza("vDni= " + vDni);
	 * 
	 * if (vDni.equals(dniUsuario1) || vDni.equals(dniUsuario2)) {
	 * Aa20bLog.addTraza("SI-1 existeValidador"); return true; } } } } }
	 * 
	 * // CON MAIL filtro = Aa20bConstantes.XLNET_GRUPO_VALIDADOR_SERVICIOS;
	 * document = this.n38API.n38ItemGrupoPuestos(filtro); lista = null;
	 * 
	 * Aa20bLog.addTraza("dniUsuario1= " + dniUsuario1 + " - dniUsuario2= " +
	 * dniUsuario1 + " - FILTRO: " + filtro);
	 * 
	 * try { lista = XPathAPI.selectNodeList(document,
	 * "//elemento[@subtipo=\"n38puesto\"]"); } catch (TransformerException e) {
	 * Aa20bLog.addTraza("dniUsuario1= " + dniUsuario1 + " - dniUsuario2= " +
	 * dniUsuario1 + " - FILTRO: " + filtro + " - ERROR: " + e.getMessage());
	 * throw new SecurityHelpperException(
	 * "SecurityHelpperXLNets:existeValidador"); }
	 * 
	 * if (lista != null) { int nNodos = lista.getLength(); if (nNodos > 0) {
	 * String vDni = ""; for (int i = 0; i < nNodos; i++) { if
	 * (lista.item(i).getChildNodes().getLength() > 0) { vDni = XPathAPI
	 * .selectNodeList(lista.item(i),
	 * "parametro[@id=\"roleoccupant\"]/valor/text()") .item(0).getNodeValue();
	 * 
	 * Aa20bLog.addTraza("vDni= " + vDni);
	 * 
	 * if (vDni.equals(dniUsuario1) || vDni.equals(dniUsuario2)) {
	 * Aa20bLog.addTraza("SI-2 existeValidador"); return true; } } } } } } catch
	 * (Exception e) { Aa20bLog.addTraza("dniUsuario1= " + dniUsuario1 +
	 * " - dniUsuario2= " + dniUsuario1 + " - ERROR: " + e.getMessage()); }
	 * finally { Aa20bLog.addTraza("FIN existeValidador"); }
	 * 
	 * return false; }
	 */

	/**
	 * Obtiene el token XLNets de aplicacion
	 * 
	 * @param idAplic
	 *            la ID de aplicacion
	 * @return el token de aplicacion
	 */
	public static String getTokenXLNets(String idAplic) {
		String token = null;

		try {
			N38APISesion miAPISesion = new N38APISesion();
			Document miSesion;
			miSesion = miAPISesion.n38APISesionCrearApp(idAplic);
			token = SecurityHelpperXLNets.DOM2String(miSesion);
			Aa20bLog.addTraza("getTokenXLNets - " + token);
		} catch (Exception e) {
			Aa20bLog.addTraza("Excepcion creando el token de aplicacion");
			e.printStackTrace();
		}
		return token;
	}

	/**
	 * Convierte en String un documento org.w3c.dom.Document
	 * 
	 * @param doc
	 *            Documento de tipo org.w3c.dom.Document
	 * @return String en el que se ha convertido el Document
	 */
	public static String DOM2String(Document doc) {

		TransformerFactory transformerFactory = TransformerFactory
				.newInstance();
		Transformer transformer = null;

		try {
			transformer = transformerFactory.newTransformer();
		} catch (javax.xml.transform.TransformerConfigurationException error) {
			Aa20bLog.addTraza("DOM2String - Error al crear la instancia de Transformer");
		}

		Source source = new DOMSource(doc);
		StringWriter writer = new StringWriter();
		Result result = new StreamResult(writer);

		try {
			transformer.transform(source, result);
		} catch (javax.xml.transform.TransformerException error) {
			Aa20bLog.addTraza("DOM2String - Error al transformar el Document");
		}

		return writer.toString();
	}

	public boolean usuarioLogueadoEsAdministrador() {

		try {
			String perfiles[] = this.getPerfiles();
			if (perfiles != null && perfiles.length > 0) {
				for (int i = 0; i < perfiles.length; i++) {
					// Aa20bLog.addTraza("Perfil : " + perfiles[i]);
					if (perfiles[i]
							.equals(Aa20bConstantes.XLNETS_ADMINISTRADOR)) {
						return true;
					}
				}
			}
		} catch (Exception e) {
			Aa20bLog.addTraza("ERROR: " + e.getMessage());
		}

		return false;
	}

	public boolean usuarioLogueadoEsRespServicio() {

		try {
			String perfiles[] = this.getPerfiles();
			if (perfiles != null && perfiles.length > 0) {
				for (int i = 0; i < perfiles.length; i++) {
					if (perfiles[i].equals(Aa20bConstantes.XLNETS_RESPSERVICIO)) {
						return true;
					}
				}
			}
		} catch (Exception e) {
			Aa20bLog.addTraza("ERROR: " + e.getMessage());
		}

		return false;
	}

	public boolean usuarioLogueadoEsRespCorrectivos() {

		try {
			String perfiles[] = this.getPerfiles();
			if (perfiles != null && perfiles.length > 0) {
				for (int i = 0; i < perfiles.length; i++) {
					if (perfiles[i]
							.equals(Aa20bConstantes.XLNETS_RESPCORRECTIVOS)) {
						return true;
					}
				}
			}
		} catch (Exception e) {
			Aa20bLog.addTraza("ERROR: " + e.getMessage());
		}

		return false;
	}

	public boolean usuarioLogueadoEsRespTaller() {

		try {
			String perfiles[] = this.getPerfiles();
			if (perfiles != null && perfiles.length > 0) {
				for (int i = 0; i < perfiles.length; i++) {
					if (perfiles[i].equals(Aa20bConstantes.XLNETS_RESPTALLER)) {
						return true;
					}
				}
			}
		} catch (Exception e) {
			Aa20bLog.addTraza("ERROR: " + e.getMessage());
		}

		return false;
	}

	public boolean usuarioLogueadoEsTecnico() {

		try {
			String perfiles[] = this.getPerfiles();
			if (perfiles != null && perfiles.length > 0) {
				for (int i = 0; i < perfiles.length; i++) {
					if (perfiles[i].equals(Aa20bConstantes.XLNETS_TECNICO)) {
						return true;
					}
				}
			}
		} catch (Exception e) {
			Aa20bLog.addTraza("ERROR: " + e.getMessage());
		}

		return false;
	}

	public boolean usuarioLogueadoEsAplicacion() {
		// Para comprobar si el usuario logueado tiene acceso al menú aplicación
		// en caso contrario solo se permite poner un parte
		try {
			String perfiles[] = this.getPerfiles();
			if (perfiles != null && perfiles.length > 0) {
				for (int i = 0; i < perfiles.length; i++) {
					// Aa20bLog.addTraza("Perfil : " + perfiles[i]);
					if (perfiles[i]
							.equals(Aa20bConstantes.XLNETS_ADMINISTRADOR)
							|| perfiles[i]
									.equals(Aa20bConstantes.XLNETS_RESPCORRECTIVOS)
							// De momento los usuarios técnicos entran como
							// usuarios públicos
							// || perfiles[i]
							// .equals(Aa20bConstantes.XLNETS_TECNICO)
							|| perfiles[i]
									.equals(Aa20bConstantes.XLNETS_RESPSERVICIO)
							|| perfiles[i]
									.equals(Aa20bConstantes.XLNETS_TECNICO)
							|| perfiles[i]
									.equals(Aa20bConstantes.XLNETS_RESPTALLER)) {

						return true;
					}
				}
			}
		} catch (Exception e) {
			Aa20bLog.addTraza("ERROR: " + e.getMessage());
		}

		return false;
	}

	// Eliminar cuando se abra a todos
	public boolean usuarioLogueadoEsPublico() {
		// Para comprobar si el usuario logueado tiene perfil publico
		try {
			String perfiles[] = this.getPerfiles();
			if (perfiles != null && perfiles.length > 0) {
				for (int i = 0; i < perfiles.length; i++) {
					if (perfiles[i].equals(Aa20bConstantes.XLNETS_USUPUBLICO)) {
						return true;
					}
				}
			}
		} catch (Exception e) {
			Aa20bLog.addTraza("ERROR: " + e.getMessage());
		}

		return false;
	}

	// FIN Eliminar cuando se abra a todos

	public Aa20bUsuarioXLNET obtenerDatosUsuarioXLNET()
			throws SecurityHelpperException {

		Aa20bUsuarioXLNET usuarioXLNET = new Aa20bUsuarioXLNET();
		try {
			usuarioXLNET.setNomApel(this.getPersonaNombreYApellidos());

			String miDni = this.getDni();
			ArrayList<Aa20bPersonaXLNET> persona = this.getPersonasXLNETs(null,
					miDni, null, null, null, null);
			usuarioXLNET.setCodDpto(persona.get(0).getCodDepto());
			usuarioXLNET.setDptoCas(persona.get(0).getDescDeptoC());
			usuarioXLNET.setDptoEus(persona.get(0).getDescDeptoE());
			usuarioXLNET.setCodDireccion(persona.get(0).getCodDireccion());
			usuarioXLNET.setDireccionCas(persona.get(0).getDescDireccionC());
			usuarioXLNET.setDireccionEus(persona.get(0).getDescDireccionE());
			usuarioXLNET.setCodEstrUs(persona.get(0).getCodestrus());
			usuarioXLNET.setCodEdificio(persona.get(0).getCodEdificio());
			usuarioXLNET.setEdificioCas(persona.get(0).getDescEdificioC());
			usuarioXLNET.setEdificioEus(persona.get(0).getDescEdificioE());
			usuarioXLNET.setEmail(persona.get(0).getEMail());
			usuarioXLNET.setCodPlanta(persona.get(0).getCodPlanta());
			usuarioXLNET.setCodZona(persona.get(0).getCodZona());

			// usuarioXLNET.setCodPlanta("108");
			// usuarioXLNET.setCodZona("101");

			usuarioXLNET.setTelefono(persona.get(0).getTelefono());
			usuarioXLNET.setUidPersona(this.getPersonaUID());
			usuarioXLNET.setVip(persona.get(0).getVip());
			/*
			 * try { if (usuarioXLNET.getCodPlanta() == null) {
			 * usuarioXLNET.setCodPlanta(Integer
			 * .toString(Aa20bConstantes.SIN_PLANTAS)); } else { Plantas planta
			 * = new Plantas();
			 * planta.setCodPlanta(Integer.parseInt(usuarioXLNET
			 * .getCodPlanta())); Plantas plantaAux = this.plantasService
			 * .obtenerPlantaDesdeXlnets(planta); if (plantaAux != null &&
			 * plantaAux.getIdplanta() != null) {
			 * usuarioXLNET.setCodPlanta(Integer.toString(plantaAux
			 * .getIdplanta())); } else { usuarioXLNET.setCodPlanta(Integer
			 * .toString(Aa20bConstantes.SIN_PLANTAS)); } }
			 * usuarioXLNET.setCodZona(persona.get(0).getCodZona()); if
			 * (usuarioXLNET.getCodZona() == null) {
			 * usuarioXLNET.setCodZona(Integer
			 * .toString(Aa20bConstantes.SIN_ZONAS)); } else { Zonas zona = new
			 * Zonas();
			 * zona.setCodZona(Integer.parseInt(usuarioXLNET.getCodZona()));
			 * Zonas zonaAux = this.zonasService .obtenerZonaDesdeXlnets(zona);
			 * if (zonaAux != null && zonaAux.getIdzona() != null) {
			 * usuarioXLNET.setCodZona(Integer.toString(zonaAux .getIdzona()));
			 * } else { usuarioXLNET.setCodZona(Integer
			 * .toString(Aa20bConstantes.SIN_ZONAS)); } } } catch (Exception e)
			 * { throw new SecurityException(
			 * "SecurityHelpperException:SecurityHelpperXLNets: " + e); }
			 */

			// ArrayList<Aa20bDepartamentoXLNET> dptos =
			// getDepartamentosYOrganismosXLNETs();
			// usuarioXLNET.setDptoCas(dptos.toString());

		} catch (Exception e) {
			Aa20bLog.addTraza("ERROR: " + e.getMessage());
		}

		return usuarioXLNET;
	}

	public Boolean existePuestoXLNET(String uidPuesto)
			throws SecurityHelpperException {

		try {

			Document documentPuesto = this.n38API
					.n38ItemObtenerPuestos("n38uidpuesto=" + uidPuesto);

			NodeList listaDepto = XPathAPI.selectNodeList(documentPuesto,
					"//elemento[@subtipo=\"n38puesto\"]");
			if (listaDepto != null && listaDepto.getLength() > 0) {
				return true;
			} else {
				return false;
			}

		} catch (Exception e) {
			Aa20bLog.addTraza("ERROR: " + e.getMessage());
			return false;
		}

	}

	public Aa20bUsuarioXLNET obtenerUsuarioIntroducido(
			String usuarioIntroducido, String puesto)
			throws SecurityHelpperException {

		Aa20bUsuarioXLNET usuarioXLNET = new Aa20bUsuarioXLNET();
		try {

			ArrayList<Aa20bPersonaXLNET> persona = this.getPersonasXLNETs(
					usuarioIntroducido, null, null, null, null, puesto);

			usuarioXLNET.setCodDpto(persona.get(0).getCodDepto());
			usuarioXLNET.setDptoCas(persona.get(0).getDescDeptoC());
			usuarioXLNET.setDptoEus(persona.get(0).getDescDeptoE());
			usuarioXLNET.setCodDireccion(persona.get(0).getCodDireccion());
			usuarioXLNET.setDireccionCas(persona.get(0).getDescDireccionC());
			usuarioXLNET.setDireccionEus(persona.get(0).getDescDireccionE());
			usuarioXLNET.setCodEstrUs(persona.get(0).getCodestrus());
			usuarioXLNET.setCodEdificio(persona.get(0).getCodEdificio());
			usuarioXLNET.setEdificioCas(persona.get(0).getDescEdificioC());
			usuarioXLNET.setEdificioEus(persona.get(0).getDescEdificioE());

			usuarioXLNET.setCodZona(persona.get(0).getCodZona());
			usuarioXLNET.setCodPlanta(persona.get(0).getCodPlanta());
			usuarioXLNET.setTelefono(persona.get(0).getTelefono());
			usuarioXLNET.setEmail(persona.get(0).getEMail());

			usuarioXLNET.setNomApel(persona.get(0).getNombre() + " "
					+ persona.get(0).getApellidos());

			usuarioXLNET.setUidPersona(this.getPersonaUID());
			usuarioXLNET.setVip(persona.get(0).getVip());

			// ArrayList<Aa20bDepartamentoXLNET> dptos =
			// getDepartamentosYOrganismosXLNETs();
			// usuarioXLNET.setDptoCas(dptos.toString());

		} catch (Exception e) {
			Aa20bLog.addTraza("ERROR: " + e.getMessage());
		}

		return usuarioXLNET;
	}

}