package com.ejie.aa20b.jms;

import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Repository;

import com.ejie.aa20b.dao.ClaseDao;
import com.ejie.aa20b.dao.CuestionarioDao;
import com.ejie.aa20b.dao.EdifEstrucDao;
import com.ejie.aa20b.dao.EdificiosDao;
import com.ejie.aa20b.dao.FichaejecucionDao;
import com.ejie.aa20b.dao.GamasDao;
import com.ejie.aa20b.dao.ParteejecucionDao;
import com.ejie.aa20b.dao.PartesDao;
import com.ejie.aa20b.dao.PartetecnicosDao;
import com.ejie.aa20b.dao.PartetecnicosgmaoDao;
import com.ejie.aa20b.dao.PlantasDao;
import com.ejie.aa20b.dao.ZonasDao;
import com.ejie.aa20b.model.Actuacion;
import com.ejie.aa20b.model.Clase;
import com.ejie.aa20b.model.Codigo;
import com.ejie.aa20b.model.Cuestionario;
import com.ejie.aa20b.model.Departamentos;
import com.ejie.aa20b.model.Direcciones;
import com.ejie.aa20b.model.EdifEstruc;
import com.ejie.aa20b.model.Edificios;
import com.ejie.aa20b.model.Espacio;
import com.ejie.aa20b.model.Ficha;
import com.ejie.aa20b.model.Fichaejecucion;
import com.ejie.aa20b.model.Fichatecnicosgmao;
import com.ejie.aa20b.model.Gamas;
import com.ejie.aa20b.model.Maquinas;
import com.ejie.aa20b.model.Parteejecucion;
import com.ejie.aa20b.model.Partes;
import com.ejie.aa20b.model.Partetecnicosgmao;
import com.ejie.aa20b.model.Plantas;
import com.ejie.aa20b.model.Servicios;
import com.ejie.aa20b.model.Zonas;
import com.ejie.aa20b.util.Aa20bConstantes;
import com.ejie.x38.json.JSONArray;
import com.ejie.x38.json.JSONObject;

@Repository
public class Aa20bProcesosJMSImpl implements Aa20bProcesosJMS {

	public ReloadableResourceBundleMessageSource appMessageSource;
	public Locale locale;
	private static InitialContext ctx = null;
	private static QueueConnectionFactory qcf = null;
	private static QueueConnection qc = null;
	private static QueueSession qsess = null;
	private static Queue q = null;
	private static QueueSender qsndr = null;
	private static TextMessage message = null;
	private static ObjectMessage messageObject = null;
	// NOTE: The next two lines set the name of the Queue Connection Factory
	// and the Queue that we want to use.
	private static final String QCF_NAME = "aa20b.aa20bJMSConnectionFactory";
	private static final String QUEUE_NAME = "aa20b.aa20bJMSQueue";

	@Autowired
	private EdifEstrucDao edifEstrucDao;

	@Autowired
	private ZonasDao zonasDao;

	@Autowired
	private PlantasDao plantasDao;

	@Autowired
	private FichaejecucionDao fichaejecucionDao;

	@Autowired
	private EdificiosDao edificiosDao;

	@Autowired
	private GamasDao gamasDao;

	@Autowired
	private ClaseDao claseDao;

	@Autowired
	private PartetecnicosgmaoDao partetecnicosgmaoDao;

	@Autowired
	private CuestionarioDao cuestionarioDao;

	@Autowired
	private PropertiesFactoryBean appConfiguration;

	private void inicializar() {

		String providerUrl = "";
		String providerUsr = "";
		String providerPass = "";
		try {
			providerUrl = this.appConfiguration.getObject().getProperty(
					"providerurl.path");
			providerUsr = this.appConfiguration.getObject().getProperty(
					"providerusr.path");
			providerPass = this.appConfiguration.getObject().getProperty(
					"providerpass.path");

		} catch (Exception e) {

		}

		// create InitialContext
		Hashtable properties = new Hashtable();
		properties.put(Context.INITIAL_CONTEXT_FACTORY,
				"weblogic.jndi.WLInitialContextFactory");
		// NOTE: The port number of the server is provided in the next line,
		// followed by the userid and password on the next two lines.

		properties.put(Context.PROVIDER_URL, providerUrl);
		properties.put(Context.SECURITY_PRINCIPAL, providerUsr);
		properties.put(Context.SECURITY_CREDENTIALS, providerPass);

		// DESARROLLO
		/*
		 * properties.put(Context.PROVIDER_URL,
		 * "t3://wl11mngd21.ejiedes.net:7029");
		 * properties.put(Context.SECURITY_PRINCIPAL, "weblogic11");
		 * properties.put(Context.SECURITY_CREDENTIALS, "DESAweblogic11");
		 */

		try {
			ctx = new InitialContext(properties);
		} catch (NamingException ne) {
			ne.printStackTrace(System.err);
			System.exit(0);
		}

		// create QueueConnectionFactory
		try {
			qcf = (QueueConnectionFactory) ctx.lookup(QCF_NAME);
		} catch (NamingException ne) {
			ne.printStackTrace(System.err);
			System.exit(0);
		}

		// create QueueConnection
		try {
			qc = qcf.createQueueConnection();
		} catch (JMSException jmse) {
			jmse.printStackTrace(System.err);
			System.exit(0);
		}

		// create QueueSession
		try {
			qsess = qc.createQueueSession(false, 0);
		} catch (JMSException jmse) {
			jmse.printStackTrace(System.err);
			System.exit(0);
		}

		// lookup Queue
		try {
			q = (Queue) ctx.lookup(QUEUE_NAME);
		} catch (NamingException ne) {
			ne.printStackTrace(System.err);
			System.exit(0);
		}

		// create QueueSender
		try {
			qsndr = qsess.createSender(q);
		} catch (JMSException jmse) {
			jmse.printStackTrace(System.err);
			System.exit(0);
		}

	}

	private void limpiar() {
		// clean up
		try {
			message = null;
			messageObject = null;
			qsndr.close();
			qsndr = null;
			q = null;
			qsess.close();
			qsess = null;
			qc.close();
			qc = null;
			qcf = null;
			ctx = null;
		} catch (JMSException jmse) {
			jmse.printStackTrace(System.err);
		}
	}

	public void sendMessageText(String messageText, int operacion) {
		this.inicializar();

		// create TextMessage
		try {
			message = qsess.createTextMessage();
		} catch (JMSException jmse) {
			jmse.printStackTrace(System.err);
			System.exit(0);
		}
		// set message text in TextMessage
		try {
			message.setText(messageText);
			message.setIntProperty("operacion", operacion);
		} catch (JMSException jmse) {
			jmse.printStackTrace(System.err);
			System.exit(0);
		}

		// send message
		try {
			qsndr.send(message);
		} catch (JMSException jmse) {
			jmse.printStackTrace(System.err);
			System.exit(0);
		}
		this.limpiar();
	}

	public void sendMessageObjeto(int operacion, String tipoObjeto, Object datos) {
		this.inicializar();

		try {
			messageObject = qsess.createObjectMessage();
		} catch (JMSException jmse) {
			jmse.printStackTrace(System.err);
			System.exit(0);
		}
		Object objectoMant = new Object();
		try {
			objectoMant = Class.forName(tipoObjeto).newInstance();
			Class cl = Class.forName(tipoObjeto);
			objectoMant = cl.cast(datos);

		} catch (InstantiationException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ClassNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		//
		try {

			messageObject.setObject((Serializable) objectoMant);
			messageObject.setIntProperty("operacion", operacion);
		} catch (JMSException jmse) {
			jmse.printStackTrace(System.err);
			System.exit(0);
		}

		try {
			qsndr.send(messageObject);
		} catch (JMSException jmse) {
			jmse.printStackTrace(System.err);
			System.exit(0);
		}

		this.limpiar();
	}

	@Override
	public String generarEntidadesEdifEstruc(String urlConfig) {
		// TODO Auto-generated method stub

		JSONObject entidadesGeneral = new JSONObject();
		JSONArray listaEntidades = new JSONArray();
		JSONObject entidad = new JSONObject();
		JSONArray listaEntidadesColumnas = new JSONArray();
		JSONObject columna = new JSONObject();

		// Entidad zonas
		entidad.put("IdEntidad", "Zonas");
		entidad.put("DescEntidad", "Zonaldeak / Zonas");
		listaEntidades.put(entidad);
		// Entidad plantas
		entidad = new JSONObject();
		entidad.put("IdEntidad", "Plantas");
		entidad.put("DescEntidad", "Solairuak / Plantas");
		listaEntidades.put(entidad);

		// Columnas zonas
		columna.put("IdEntidad", "Zonas");
		columna.put("IdColumna", "IdZona");
		columna.put("Secuencia", "10");
		columna.put("Identifica", "0");
		columna.put("DescColumna", "Zonaldea Id / Id Zona");
		columna.put("Tipo", "3");
		listaEntidadesColumnas.put(columna);
		columna = new JSONObject();
		columna.put("IdEntidad", "Zonas");
		columna.put("IdColumna", "DescZona");
		columna.put("Secuencia", "20");
		columna.put("Identifica", "1");
		columna.put("DescColumna", "Azalpena / Descripción Zona");
		columna.put("Tipo", "3");
		listaEntidadesColumnas.put(columna);
		columna = new JSONObject();
		columna.put("IdEntidad", "Zonas");
		columna.put("IdColumna", "IdEdificio");
		columna.put("Secuencia", "30");
		columna.put("Identifica", "0");
		columna.put("DescColumna", "Eraikina / Edificio");
		columna.put("Tipo", "3");
		listaEntidadesColumnas.put(columna);
		columna = new JSONObject();
		columna.put("IdEntidad", "Zonas");
		columna.put("IdColumna", "Clave");
		columna.put("Secuencia", "40");
		columna.put("Identifica", "0");
		columna.put("DescColumna", "Clave");
		columna.put("Tipo", "3");
		listaEntidadesColumnas.put(columna);

		// Columnas plantas
		columna = new JSONObject();
		columna.put("IdEntidad", "Plantas");
		columna.put("IdColumna", "IdPlanta");
		columna.put("Secuencia", "10");
		columna.put("Identifica", "0");
		columna.put("DescColumna", "Solairua Id / Id Planta");
		columna.put("Tipo", "3");
		listaEntidadesColumnas.put(columna);
		columna = new JSONObject();
		columna.put("IdEntidad", "Plantas");
		columna.put("IdColumna", "DescPlanta");
		columna.put("Secuencia", "20");
		columna.put("Identifica", "1");
		columna.put("DescColumna", "Azalpena / Descripción Planta");
		columna.put("Tipo", "3");
		listaEntidadesColumnas.put(columna);
		columna = new JSONObject();
		columna.put("IdEntidad", "Plantas");
		columna.put("IdColumna", "ZonaRel");
		columna.put("Secuencia", "30");
		columna.put("Identifica", "0");
		columna.put("DescColumna", "Zonaldea / Zona");
		columna.put("Tipo", "3");
		listaEntidadesColumnas.put(columna);

		entidadesGeneral.put("entidades", listaEntidades);
		entidadesGeneral.put("entidadescolumnas", listaEntidadesColumnas);
		entidadesGeneral.put("entidadeslineas", JSONObject.NULL);
		entidadesGeneral.put("entidadesvalores", JSONObject.NULL);

		return this.sincronizarGmao(entidadesGeneral, urlConfig
				+ Aa20bConstantes.URL_ESTRUC_ENTIDAD);

	}

	@Override
	public String generarEntidadEstancias(String urlConfig) {
		// TODO Auto-generated method stub

		JSONObject entidadesGeneral = new JSONObject();
		JSONArray listaEntidades = new JSONArray();
		JSONObject entidad = new JSONObject();
		JSONArray listaEntidadesColumnas = new JSONArray();
		JSONObject columna = new JSONObject();

		// Entidad estancias
		entidad.put("IdEntidad", "Estancias");
		entidad.put("DescEntidad", "Egonlekuak / Estancias");
		listaEntidades.put(entidad);

		// Columnas estancias
		columna.put("IdEntidad", "Estancias");
		columna.put("IdColumna", "IdEstancia");
		columna.put("Secuencia", "10");
		columna.put("Identifica", "0");
		columna.put("DescColumna", "Egonlekua Id / Id Estancia");
		columna.put("Tipo", "3");
		listaEntidadesColumnas.put(columna);
		columna = new JSONObject();
		columna.put("IdEntidad", "Estancias");
		columna.put("IdColumna", "DescEstancia");
		columna.put("Secuencia", "20");
		columna.put("Identifica", "1");
		columna.put("DescColumna", "Azalpena / Descripción Estancia");
		columna.put("Tipo", "3");
		listaEntidadesColumnas.put(columna);
		columna = new JSONObject();
		columna.put("IdEntidad", "Estancias");
		columna.put("IdColumna", "IntExt");
		columna.put("Secuencia", "30");
		columna.put("Identifica", "0");
		columna.put("DescColumna", "Int. / Ext.");
		columna.put("Tipo", "3");
		listaEntidadesColumnas.put(columna);

		entidadesGeneral.put("entidades", listaEntidades);
		entidadesGeneral.put("entidadescolumnas", listaEntidadesColumnas);
		entidadesGeneral.put("entidadeslineas", JSONObject.NULL);
		entidadesGeneral.put("entidadesvalores", JSONObject.NULL);

		return this.sincronizarGmao(entidadesGeneral, urlConfig
				+ Aa20bConstantes.URL_ESTRUC_ENTIDAD);

	}

	@Override
	public String generarEntidadClases(String urlConfig) {
		// TODO Auto-generated method stub
		JSONObject entidadesGeneral = new JSONObject();
		JSONArray listaEntidades = new JSONArray();
		JSONObject entidad = new JSONObject();
		JSONArray listaEntidadesColumnas = new JSONArray();
		JSONObject columna = new JSONObject();

		// Entidad estancias
		entidad.put("IdEntidad", "Clases");
		entidad.put("DescEntidad", "Klaseak / Clases");
		listaEntidades.put(entidad);

		// Columnas estancias
		columna.put("IdEntidad", "Clases");
		columna.put("IdColumna", "IdClase");
		columna.put("Secuencia", "10");
		columna.put("Identifica", "0");
		columna.put("DescColumna", "Klasea Id / Id Clase");
		columna.put("Tipo", "3");
		listaEntidadesColumnas.put(columna);
		columna = new JSONObject();
		columna.put("IdEntidad", "Clases");
		columna.put("IdColumna", "DescClase");
		columna.put("Secuencia", "20");
		columna.put("Identifica", "1");
		columna.put("DescColumna", "Azalpena / Descripción Clase");
		columna.put("Tipo", "3");
		listaEntidadesColumnas.put(columna);
		/*
		 * columna = new JSONObject(); columna.put("IdEntidad", "Clases");
		 * columna.put("IdColumna", "Clave"); columna.put("Secuencia", "30");
		 * columna.put("Identifica", "0"); columna.put("DescColumna", "Clave");
		 * columna.put("Tipo", "3"); listaEntidadesColumnas.put(columna);
		 */

		entidadesGeneral.put("entidades", listaEntidades);
		entidadesGeneral.put("entidadescolumnas", listaEntidadesColumnas);
		entidadesGeneral.put("entidadeslineas", JSONObject.NULL);
		entidadesGeneral.put("entidadesvalores", JSONObject.NULL);

		return this.sincronizarGmao(entidadesGeneral, urlConfig
				+ Aa20bConstantes.URL_ESTRUC_ENTIDAD);

	}

	@Override
	public String generarEntidadDepartamentos(String urlConfig) {
		JSONObject entidadesGeneral = new JSONObject();
		JSONArray listaEntidades = new JSONArray();
		JSONObject entidad = new JSONObject();
		JSONArray listaEntidadesColumnas = new JSONArray();
		JSONObject columna = new JSONObject();

		// Entidad estancias
		entidad.put("IdEntidad", "Departamentos");
		entidad.put("DescEntidad", "Sailak / Departamentos");
		listaEntidades.put(entidad);

		// Columnas estancias
		columna.put("IdEntidad", "Departamentos");
		columna.put("IdColumna", "IdDepar");
		columna.put("Secuencia", "10");
		columna.put("Identifica", "0");
		columna.put("DescColumna", "Saila Id / Id Departamento");
		columna.put("Tipo", "3");
		listaEntidadesColumnas.put(columna);
		columna = new JSONObject();
		columna.put("IdEntidad", "Departamentos");
		columna.put("IdColumna", "DescDepar");
		columna.put("Secuencia", "20");
		columna.put("Identifica", "1");
		columna.put("DescColumna", "Azalpena / Descripción departamento");
		columna.put("Tipo", "3");
		listaEntidadesColumnas.put(columna);
		columna = new JSONObject();
		columna.put("IdEntidad", "Departamentos");
		columna.put("IdColumna", "Baja");
		columna.put("Secuencia", "30");
		columna.put("Identifica", "0");
		columna.put("DescColumna", "Baja / Baja");
		columna.put("Tipo", "3");
		listaEntidadesColumnas.put(columna);

		entidadesGeneral.put("entidades", listaEntidades);
		entidadesGeneral.put("entidadescolumnas", listaEntidadesColumnas);
		entidadesGeneral.put("entidadeslineas", JSONObject.NULL);
		entidadesGeneral.put("entidadesvalores", JSONObject.NULL);

		return this.sincronizarGmao(entidadesGeneral, urlConfig
				+ Aa20bConstantes.URL_ESTRUC_ENTIDAD);
	}

	@Override
	public String generarEntidadDirecciones(String urlConfig) {
		JSONObject entidadesGeneral = new JSONObject();
		JSONArray listaEntidades = new JSONArray();
		JSONObject entidad = new JSONObject();
		JSONArray listaEntidadesColumnas = new JSONArray();
		JSONObject columna = new JSONObject();

		// Entidad estancias
		entidad.put("IdEntidad", "Direcciones");
		entidad.put("DescEntidad", "Zuzendaritzak / Direcciones");
		listaEntidades.put(entidad);

		// Columnas estancias
		columna.put("IdEntidad", "Direcciones");
		columna.put("IdColumna", "IdDir");
		columna.put("Secuencia", "10");
		columna.put("Identifica", "0");
		columna.put("DescColumna", "Zuzendaritza Id / Id Dirección");
		columna.put("Tipo", "3");
		listaEntidadesColumnas.put(columna);
		columna = new JSONObject();
		columna.put("IdEntidad", "Direcciones");
		columna.put("IdColumna", "DescDir");
		columna.put("Secuencia", "20");
		columna.put("Identifica", "1");
		columna.put("DescColumna", "Azalpena / Descripción Dirección");
		columna.put("Tipo", "3");
		listaEntidadesColumnas.put(columna);
		columna = new JSONObject();
		columna.put("IdEntidad", "Direcciones");
		columna.put("IdColumna", "DeparRel");
		columna.put("Secuencia", "30");
		columna.put("Identifica", "0");
		columna.put("DescColumna", "DeparRel");
		columna.put("Tipo", "3");
		listaEntidadesColumnas.put(columna);
		columna = new JSONObject();
		columna.put("IdEntidad", "Direcciones");
		columna.put("IdColumna", "Baja");
		columna.put("Secuencia", "40");
		columna.put("Identifica", "0");
		columna.put("DescColumna", "Baja / Baja");
		columna.put("Tipo", "3");
		listaEntidadesColumnas.put(columna);

		entidadesGeneral.put("entidades", listaEntidades);
		entidadesGeneral.put("entidadescolumnas", listaEntidadesColumnas);
		entidadesGeneral.put("entidadeslineas", JSONObject.NULL);
		entidadesGeneral.put("entidadesvalores", JSONObject.NULL);

		return this.sincronizarGmao(entidadesGeneral, urlConfig
				+ Aa20bConstantes.URL_ESTRUC_ENTIDAD);
	}

	@Override
	public String generarEntidadCodigos(String urlConfig) {
		// TODO Auto-generated method stub
		JSONObject entidadesGeneral = new JSONObject();
		JSONArray listaEntidades = new JSONArray();
		JSONObject entidad = new JSONObject();
		JSONArray listaEntidadesColumnas = new JSONArray();
		JSONObject columna = new JSONObject();

		// Entidad estancias
		entidad.put("IdEntidad", "Codigos");
		entidad.put("DescEntidad", "Parte-kodeak / Codigos de parte");
		listaEntidades.put(entidad);

		// Columnas estancias
		columna.put("IdEntidad", "Codigos");
		columna.put("IdColumna", "IdCodigo");
		columna.put("Secuencia", "10");
		columna.put("Identifica", "0");
		columna.put("DescColumna", "Kodea Id / Id Codigo");
		columna.put("Tipo", "3");
		listaEntidadesColumnas.put(columna);
		columna = new JSONObject();
		columna.put("IdEntidad", "Codigos");
		columna.put("IdColumna", "DescCodigo");
		columna.put("Secuencia", "20");
		columna.put("Identifica", "1");
		columna.put("DescColumna", "Azalpena / Descripción Código");
		columna.put("Tipo", "3");
		listaEntidadesColumnas.put(columna);
		columna = new JSONObject();
		columna.put("IdEntidad", "Codigos");
		columna.put("IdColumna", "ClaseRel");
		columna.put("Secuencia", "30");
		columna.put("Identifica", "0");
		columna.put("DescColumna", "ClaseRel");
		columna.put("Tipo", "3");
		listaEntidadesColumnas.put(columna);

		entidadesGeneral.put("entidades", listaEntidades);
		entidadesGeneral.put("entidadescolumnas", listaEntidadesColumnas);
		entidadesGeneral.put("entidadeslineas", JSONObject.NULL);
		entidadesGeneral.put("entidadesvalores", JSONObject.NULL);

		return this.sincronizarGmao(entidadesGeneral, urlConfig
				+ Aa20bConstantes.URL_ESTRUC_ENTIDAD);

	}

	@Override
	public String generarEntidadGamas(String urlConfig) {
		// TODO Auto-generated method stub
		JSONObject entidadesGeneral = new JSONObject();
		JSONArray listaEntidades = new JSONArray();
		JSONObject entidad = new JSONObject();
		JSONArray listaEntidadesColumnas = new JSONArray();
		JSONObject columna = new JSONObject();

		// Entidad estancias
		entidad.put("IdEntidad", "Gamas");
		entidad.put("DescEntidad", "Gamak / Gamas");
		listaEntidades.put(entidad);

		// Columnas estancias
		columna.put("IdEntidad", "Gamas");
		columna.put("IdColumna", "IdGama");
		columna.put("Secuencia", "10");
		columna.put("Identifica", "0");
		columna.put("DescColumna", "Gama Id / Id Gama");
		columna.put("Tipo", "3");
		listaEntidadesColumnas.put(columna);
		columna = new JSONObject();
		columna.put("IdEntidad", "Gamas");
		columna.put("IdColumna", "DescGama");
		columna.put("Secuencia", "20");
		columna.put("Identifica", "1");
		columna.put("DescColumna", "Azalpena / Descripción Gama");
		columna.put("Tipo", "3");
		listaEntidadesColumnas.put(columna);
		columna = new JSONObject();
		columna.put("IdEntidad", "Gamas");
		columna.put("IdColumna", "ClaseRel");
		columna.put("Secuencia", "30");
		columna.put("Identifica", "0");
		columna.put("DescColumna", "Klase / Clase");
		columna.put("Tipo", "3");
		listaEntidadesColumnas.put(columna);
		columna = new JSONObject();
		columna.put("IdEntidad", "Gamas");
		columna.put("IdColumna", "ServicioRel");
		columna.put("Secuencia", "40");
		columna.put("Identifica", "0");
		columna.put("DescColumna", "Zerbitzua / Servicio");
		columna.put("Tipo", "3");
		listaEntidadesColumnas.put(columna);

		entidadesGeneral.put("entidades", listaEntidades);
		entidadesGeneral.put("entidadescolumnas", listaEntidadesColumnas);
		entidadesGeneral.put("entidadeslineas", JSONObject.NULL);
		entidadesGeneral.put("entidadesvalores", JSONObject.NULL);

		return this.sincronizarGmao(entidadesGeneral, urlConfig
				+ Aa20bConstantes.URL_ESTRUC_ENTIDAD);

	}

	@Override
	public String generarEntidadMaquinas(String urlConfig) {
		// TODO Auto-generated method stub
		JSONObject entidadesGeneral = new JSONObject();
		JSONArray listaEntidades = new JSONArray();
		JSONObject entidad = new JSONObject();
		JSONArray listaEntidadesColumnas = new JSONArray();
		JSONObject columna = new JSONObject();

		// Entidad estancias
		entidad.put("IdEntidad", "Maquinas");
		entidad.put("DescEntidad", "Makinak / Maquinas");
		listaEntidades.put(entidad);

		// Columnas estancias
		columna.put("IdEntidad", "Maquinas");
		columna.put("IdColumna", "IdMaquina");
		columna.put("Secuencia", "10");
		columna.put("Identifica", "0");
		columna.put("DescColumna", "Makina Id / Id Maquina");
		columna.put("Tipo", "3");
		listaEntidadesColumnas.put(columna);
		columna = new JSONObject();
		columna.put("IdEntidad", "Maquinas");
		columna.put("IdColumna", "Mcodigo");
		columna.put("Secuencia", "20");
		columna.put("Identifica", "1");
		columna.put("DescColumna", "Kodea / Código");
		columna.put("Tipo", "3");
		listaEntidadesColumnas.put(columna);
		columna = new JSONObject();
		columna.put("IdEntidad", "Maquinas");
		columna.put("IdColumna", "DescMaquina");
		columna.put("Secuencia", "30");
		columna.put("Identifica", "1");
		columna.put("DescColumna", "Makina Azalpena / Descripción maquina");
		columna.put("Tipo", "3");
		listaEntidadesColumnas.put(columna);
		columna = new JSONObject();
		columna.put("IdEntidad", "Maquinas");
		columna.put("IdColumna", "Edificio");
		columna.put("Secuencia", "40");
		columna.put("Identifica", "0");
		columna.put("DescColumna", "Eraikina / Edificio");
		columna.put("Tipo", "3");
		listaEntidadesColumnas.put(columna);
		columna = new JSONObject();
		columna.put("IdEntidad", "Maquinas");
		columna.put("IdColumna", "Gama");
		columna.put("Secuencia", "50");
		columna.put("Identifica", "0");
		columna.put("DescColumna", "Gama / Gama");
		columna.put("Tipo", "3");
		listaEntidadesColumnas.put(columna);

		entidadesGeneral.put("entidades", listaEntidades);
		entidadesGeneral.put("entidadescolumnas", listaEntidadesColumnas);
		entidadesGeneral.put("entidadeslineas", JSONObject.NULL);
		entidadesGeneral.put("entidadesvalores", JSONObject.NULL);

		return this.sincronizarGmao(entidadesGeneral, urlConfig
				+ Aa20bConstantes.URL_ESTRUC_ENTIDAD);

	}

	@Override
	public String generarEntidadServicios(String urlConfig) {
		JSONObject entidadesGeneral = new JSONObject();
		JSONArray listaEntidades = new JSONArray();
		JSONObject entidad = new JSONObject();
		JSONArray listaEntidadesColumnas = new JSONArray();
		JSONObject columna = new JSONObject();

		// Entidad estancias
		entidad.put("IdEntidad", "Servicios");
		entidad.put("DescEntidad", "Zerbitzuak / Servicios");
		listaEntidades.put(entidad);

		// Columnas estancias
		columna.put("IdEntidad", "Servicios");
		columna.put("IdColumna", "IdServicio");
		columna.put("Secuencia", "10");
		columna.put("Identifica", "0");
		columna.put("DescColumna", "Zerbitzua Id / Id Servicio");
		columna.put("Tipo", "3");
		listaEntidadesColumnas.put(columna);
		columna = new JSONObject();
		columna.put("IdEntidad", "Servicios");
		columna.put("IdColumna", "DescServicio");
		columna.put("Secuencia", "20");
		columna.put("Identifica", "1");
		columna.put("DescColumna", "Azalpena / Descripción Servicio");
		columna.put("Tipo", "3");
		listaEntidadesColumnas.put(columna);

		entidadesGeneral.put("entidades", listaEntidades);
		entidadesGeneral.put("entidadescolumnas", listaEntidadesColumnas);
		entidadesGeneral.put("entidadeslineas", JSONObject.NULL);
		entidadesGeneral.put("entidadesvalores", JSONObject.NULL);

		return this.sincronizarGmao(entidadesGeneral, urlConfig
				+ Aa20bConstantes.URL_ESTRUC_ENTIDAD);
	}

	@Override
	public void sincronizarEdifEstruc(List<Edificios> edificios,
			int tipoLlamada, String urlConfig) {

		String respuesta = "";
		String entidadesStr = "";
		if (edificios.size() != 0) {
			JSONObject entidades = new JSONObject();

			/**
			 * Gmao Generación estructura entidades Zona y edificio
			 */
			respuesta = this.generarEntidadesEdifEstruc(urlConfig);

			if (respuesta.equals("OK")) {
				for (Edificios edificio : edificios) {

					/**
					 * Zonas asignadas al edificio
					 */
					EdifEstruc edifEstrucGmao = new EdifEstruc();
					edifEstrucGmao.setIdedificio(edificio.getIdedificio());
					List<EdifEstruc> listaZonasPlantasEdif = this.edifEstrucDao
							.findAll(edifEstrucGmao, null);

					// Recorremos la tabla 28 para ir sincronizando zonas y
					// plantas
					// por zona asignadas
					JSONArray listaEntidadesLineas = new JSONArray();
					JSONArray listaEntidadesValores = new JSONArray();
					String uuidEdif = "{" + edificio.getGuidedificio() + "}";

					for (EdifEstruc edifEstruc : listaZonasPlantasEdif) {

						JSONObject entidadLinea = new JSONObject();
						JSONObject entidadValor = new JSONObject();
						// Zonas
						Zonas zonaAux = new Zonas();
						zonaAux.setIdzona(edifEstruc.getIdzona());
						Zonas zona = this.zonasDao.obtenerZona(zonaAux);

						if (zona != null) {

							entidadLinea.put("IdEntidad", "Zonas");
							entidadLinea.put("Codigo",
									uuidEdif + "_" + zona.getIdzona());
							listaEntidadesLineas.put(entidadLinea);

							entidadValor.put("IdEntidad", "Zonas");
							entidadValor.put("IdColumna", "IdZona");
							entidadValor.put("Codigo",
									uuidEdif + "_" + zona.getIdzona());
							entidadValor.put("Valor", zona.getIdzona());
							listaEntidadesValores.put(entidadValor);
							entidadValor = new JSONObject();
							entidadValor.put("IdEntidad", "Zonas");
							entidadValor.put("IdColumna", "DescZona");
							entidadValor.put("Codigo",
									uuidEdif + "_" + zona.getIdzona());
							entidadValor.put("Valor", zona.getEzona() + " / "
									+ zona.getCzona());
							listaEntidadesValores.put(entidadValor);
							entidadValor = new JSONObject();
							entidadValor.put("IdEntidad", "Zonas");
							entidadValor.put("IdColumna", "IdEdificio");
							entidadValor.put("Codigo",
									uuidEdif + "_" + zona.getIdzona());
							entidadValor.put("Valor", uuidEdif);
							listaEntidadesValores.put(entidadValor);
							entidadValor = new JSONObject();
							entidadValor.put("IdEntidad", "Zonas");
							entidadValor.put("IdColumna", "Clave");
							entidadValor.put("Codigo",
									uuidEdif + "_" + zona.getIdzona());
							entidadValor.put("Valor",
									uuidEdif + "_" + zona.getIdzona());
							listaEntidadesValores.put(entidadValor);

							// Plantas
							Plantas plantaAux = new Plantas();
							plantaAux.setIdplanta(Integer.valueOf(edifEstruc
									.getIdplanta()));

							Plantas planta = this.plantasDao.find(plantaAux);
							if (planta != null) {
								entidadLinea = new JSONObject();
								entidadValor = new JSONObject();

								entidadLinea.put("IdEntidad", "Plantas");
								entidadLinea.put("Codigo",
										uuidEdif + "_" + zona.getIdzona() + "_"
												+ planta.getIdplanta());
								listaEntidadesLineas.put(entidadLinea);

								entidadValor.put("IdEntidad", "Plantas");
								entidadValor.put("IdColumna", "IdPlanta");
								entidadValor.put("Codigo",
										uuidEdif + "_" + zona.getIdzona() + "_"
												+ planta.getIdplanta());
								entidadValor.put("Valor", planta.getIdplanta());
								listaEntidadesValores.put(entidadValor);
								entidadValor = new JSONObject();
								entidadValor.put("IdEntidad", "Plantas");
								entidadValor.put("IdColumna", "DescPlanta");
								entidadValor.put("Codigo",
										uuidEdif + "_" + zona.getIdzona() + "_"
												+ planta.getIdplanta());
								entidadValor.put("Valor", planta.getEplanta()
										+ " / " + planta.getCplanta());
								listaEntidadesValores.put(entidadValor);
								entidadValor = new JSONObject();
								entidadValor.put("IdEntidad", "Plantas");
								entidadValor.put("IdColumna", "ZonaRel");
								entidadValor.put("Codigo",
										uuidEdif + "_" + zona.getIdzona() + "_"
												+ planta.getIdplanta());
								entidadValor.put("Valor",
										uuidEdif + "_" + zona.getIdzona());
								listaEntidadesValores.put(entidadValor);
							}
						}

					}

					// Objeto JSON con lineas de entidades
					entidades.put("entidadeslineas", listaEntidadesLineas);
					entidades.put("entidadesvalores", listaEntidadesValores);
					entidadesStr = entidades.toString();

					if (!entidadesStr.equals("")) {

						if (tipoLlamada == Aa20bConstantes.DIRECTA) {
							this.sincronizarGmao(
									entidades,
									urlConfig
											+ "Expertis_Sync_Movil_JS/index.php/sync/masters/InsertarLineasEntidades/");
						} else if (tipoLlamada == Aa20bConstantes.COLA) {
							this.sendMessageText(entidadesStr,
									Aa20bConstantes.OPER_MANT_LINEAS_ENTIDADES);
						}
					}
				}
			} else {

			}
		}
	}

	@Override
	public void sincronizarZonaEdifGmao(Edificios edificio, Zonas zona) {

		String respuesta = "";
		Integer idZona = 0;
		if (zona.getIdzona() != null && zona.getIdzona() != 0) {
			idZona = zona.getIdzona();
		}

		if (edificio != null) {

			String uuidEdif = "{" + edificio.getGuidedificio() + "}";

			JSONArray listaEntidadesLineas = new JSONArray();
			JSONObject entidadLinea = new JSONObject();
			JSONObject entidad = new JSONObject();
			JSONArray listaEntidadesValores = new JSONArray();
			JSONObject entidadValor = new JSONObject();

			entidadLinea.put("IdEntidad", "Zonas");
			entidadLinea.put("Codigo", uuidEdif + "_" + idZona);
			listaEntidadesLineas.put(entidadLinea);
			entidad.put("entidadeslineas", listaEntidadesLineas);

			entidadValor.put("IdEntidad", "Zonas");
			entidadValor.put("IdColumna", "IdZona");
			entidadValor.put("Codigo", uuidEdif + "_" + idZona);
			entidadValor.put("Valor", zona.getIdzona());
			listaEntidadesValores.put(entidadValor);
			entidadValor = new JSONObject();
			entidadValor.put("IdEntidad", "Zonas");
			entidadValor.put("IdColumna", "DescZona");
			entidadValor.put("Codigo", uuidEdif + "_" + idZona);
			entidadValor
					.put("Valor", zona.getEzona() + " / " + zona.getCzona());
			listaEntidadesValores.put(entidadValor);
			entidadValor = new JSONObject();
			entidadValor.put("IdEntidad", "Zonas");
			entidadValor.put("IdColumna", "IdEdificio");
			entidadValor.put("Codigo", uuidEdif + "_" + idZona);
			entidadValor.put("Valor", uuidEdif);
			listaEntidadesValores.put(entidadValor);
			entidadValor = new JSONObject();
			entidadValor.put("IdEntidad", "Zonas");
			entidadValor.put("IdColumna", "Clave");
			entidadValor.put("Codigo", uuidEdif + "_" + idZona);
			entidadValor.put("Valor", uuidEdif + "_" + idZona);
			listaEntidadesValores.put(entidadValor);
			entidad.put("entidadesvalores", listaEntidadesValores);

			respuesta = entidad.toString();

		}

		if (!respuesta.equals("")) {
			this.sendMessageText(respuesta,
					Aa20bConstantes.OPER_MANT_LINEAS_ENTIDADES);
		}
	}

	@Override
	public void sincronizarPlantaEdifGmao(Edificios edificio, Zonas zona,
			Plantas planta) {

		String respuesta = "";
		Integer idZona = 0;
		Integer idPlanta = 0;
		if (zona.getIdzona() != null && zona.getIdzona() != 0) {
			idZona = zona.getIdzona();
		}
		if (planta.getIdplanta() != null && planta.getIdplanta().equals("0")) {
			idPlanta = planta.getIdplanta();
		}

		if (edificio != null) {

			String uuidEdif = "{" + edificio.getGuidedificio() + "}";

			JSONArray listaEntidadesLineas = new JSONArray();
			JSONObject entidadLinea = new JSONObject();
			JSONObject entidad = new JSONObject();
			JSONArray listaEntidadesValores = new JSONArray();
			JSONObject entidadValor = new JSONObject();

			entidadLinea.put("IdEntidad", "Plantas");
			entidadLinea
					.put("Codigo", uuidEdif + "_" + idZona + "_" + idPlanta);
			listaEntidadesLineas.put(entidadLinea);
			entidad.put("entidadeslineas", listaEntidadesLineas);

			entidadValor.put("IdEntidad", "Plantas");
			entidadValor.put("IdColumna", "IdPlanta");
			entidadValor
					.put("Codigo", uuidEdif + "_" + idZona + "_" + idPlanta);
			entidadValor.put("Valor", planta.getIdplanta());
			listaEntidadesValores.put(entidadValor);
			entidadValor = new JSONObject();
			entidadValor.put("IdEntidad", "Plantas");
			entidadValor.put("IdColumna", "DescPlanta");
			entidadValor
					.put("Codigo", uuidEdif + "_" + idZona + "_" + idPlanta);
			entidadValor.put("Valor",
					planta.getEplanta() + " / " + planta.getCplanta());
			listaEntidadesValores.put(entidadValor);
			entidadValor = new JSONObject();
			entidadValor.put("IdEntidad", "Plantas");
			entidadValor.put("IdColumna", "ZonaRel");
			entidadValor
					.put("Codigo", uuidEdif + "_" + idZona + "_" + idPlanta);
			entidadValor.put("Valor", uuidEdif + "_" + idZona);
			listaEntidadesValores.put(entidadValor);

			entidad.put("entidadesvalores", listaEntidadesValores);

			respuesta = entidad.toString();

		}

		if (!respuesta.equals("")) {
			this.sendMessageText(respuesta,
					Aa20bConstantes.OPER_MANT_LINEAS_ENTIDADES);
		}
	}

	@Override
	public String sincronizarTodasEstanciasGmao(List<Espacio> espacios,
			int tipoLlamada, String urlConfig) {

		String respuesta = "";
		String entidadesStr = "";
		if (espacios.size() != 0) {
			JSONObject entidades = new JSONObject();
			respuesta = this.generarEntidadEstancias(urlConfig);

			if (respuesta.equals("OK")) {
				// Recorremos la lista para ir sincronizando estancias
				JSONArray listaEntidadesLineas = new JSONArray();
				JSONArray listaEntidadesValores = new JSONArray();
				for (Espacio espacio : espacios) {

					JSONObject entidadLinea = new JSONObject();
					JSONObject entidadValor = new JSONObject();
					JSONObject entidad = new JSONObject();
					if (espacio != null) {

						int idEspacio = 0;
						if (espacio.getIdespacio() != null
								&& espacio.getIdespacio() != 0) {
							idEspacio = Integer.valueOf(espacio.getIdespacio()
									.toString());
						}
						entidadLinea.put("IdEntidad", "Estancias");
						entidadLinea.put("Codigo", idEspacio);
						listaEntidadesLineas.put(entidadLinea);
						entidad.put("entidadeslineas", listaEntidadesLineas);

						entidadValor.put("IdEntidad", "Estancias");
						entidadValor.put("IdColumna", "IdEstancia");
						entidadValor.put("Codigo", idEspacio);
						entidadValor.put("Valor", idEspacio);
						listaEntidadesValores.put(entidadValor);
						entidadValor = new JSONObject();
						entidadValor.put("IdEntidad", "Estancias");
						entidadValor.put("IdColumna", "DescEstancia");
						entidadValor.put("Codigo", idEspacio);
						entidadValor.put("Valor", espacio.getEespacio() + " / "
								+ espacio.getCespacio());
						listaEntidadesValores.put(entidadValor);
						entidadValor = new JSONObject();
						entidadValor.put("IdEntidad", "Estancias");
						entidadValor.put("IdColumna", "IntExt");
						entidadValor.put("Codigo", idEspacio);
						entidadValor.put("Valor", espacio.getIntExt());
						listaEntidadesValores.put(entidadValor);
					}

					// Objeto JSON con lineas de entidades
					entidades.put("entidadeslineas", listaEntidadesLineas);
					entidades.put("entidadesvalores", listaEntidadesValores);
					entidadesStr = entidades.toString();

					if (!entidadesStr.equals("")) {
						if (tipoLlamada == Aa20bConstantes.DIRECTA) {
							respuesta = this
									.sincronizarGmao(
											entidades,
											urlConfig
													+ Aa20bConstantes.URL_LINEAS_ENTIDAD);
						} else if (tipoLlamada == Aa20bConstantes.COLA) {
							this.sendMessageText(entidadesStr,
									Aa20bConstantes.OPER_MANT_LINEAS_ENTIDADES);
							respuesta = "";
						}
					}
				}
			}
		}
		return respuesta;
	}

	@Override
	public void sincronizarEstanciaGmao(Espacio espacio) {

		String respuesta = "";
		int idEspacio = 0;
		if (espacio.getIdespacio() != null && espacio.getIdespacio() != 0) {
			idEspacio = Integer.valueOf(espacio.getIdespacio().toString());
		}

		if (espacio != null) {

			JSONArray listaEntidadesLineas = new JSONArray();
			JSONObject entidadLinea = new JSONObject();
			JSONObject entidad = new JSONObject();
			JSONArray listaEntidadesValores = new JSONArray();
			JSONObject entidadValor = new JSONObject();

			entidadLinea.put("IdEntidad", "Estancias");
			entidadLinea.put("Codigo", idEspacio);
			listaEntidadesLineas.put(entidadLinea);
			entidad.put("entidadeslineas", listaEntidadesLineas);

			entidadValor.put("IdEntidad", "Estancias");
			entidadValor.put("IdColumna", "IdEstancia");
			entidadValor.put("Codigo", idEspacio);
			entidadValor.put("Valor", idEspacio);
			listaEntidadesValores.put(entidadValor);
			entidadValor = new JSONObject();
			entidadValor.put("IdEntidad", "Estancias");
			entidadValor.put("IdColumna", "DescEstancia");
			entidadValor.put("Codigo", idEspacio);
			entidadValor.put("Valor",
					espacio.getEespacio() + " / " + espacio.getCespacio());
			listaEntidadesValores.put(entidadValor);
			entidadValor = new JSONObject();
			entidadValor.put("IdEntidad", "Estancias");
			entidadValor.put("IdColumna", "IntExt");
			entidadValor.put("Codigo", idEspacio);
			entidadValor.put("Valor", espacio.getIntExt());
			listaEntidadesValores.put(entidadValor);

			entidad.put("entidadesvalores", listaEntidadesValores);

			respuesta = entidad.toString();

		}

		if (!respuesta.equals("")) {
			this.sendMessageText(respuesta,
					Aa20bConstantes.OPER_MANT_LINEAS_ENTIDADES);
		}
	}

	@Override
	public void sincronizarClaseGmao(Clase clase) {
		// TODO Auto-generated method stub
		String respuesta = "";
		int idClase = 0;
		if (clase.getIdclase() != null && clase.getIdclase() != 0) {
			idClase = Integer.valueOf(clase.getIdclase().toString());
		}

		if (clase != null) {

			JSONArray listaEntidadesLineas = new JSONArray();
			JSONObject entidadLinea = new JSONObject();
			JSONObject entidad = new JSONObject();
			JSONArray listaEntidadesValores = new JSONArray();
			JSONObject entidadValor = new JSONObject();

			entidadLinea.put("IdEntidad", "Clases");
			entidadLinea.put("Codigo", idClase);
			listaEntidadesLineas.put(entidadLinea);
			entidad.put("entidadeslineas", listaEntidadesLineas);

			entidadValor.put("IdEntidad", "Clases");
			entidadValor.put("IdColumna", "IdClase");
			entidadValor.put("Codigo", idClase);
			entidadValor.put("Valor", idClase);
			listaEntidadesValores.put(entidadValor);
			entidadValor = new JSONObject();
			entidadValor.put("IdEntidad", "Clases");
			entidadValor.put("IdColumna", "DescClase");
			entidadValor.put("Codigo", idClase);
			entidadValor.put("Valor",
					clase.getEclase() + " / " + clase.getCclase());
			listaEntidadesValores.put(entidadValor);

			entidad.put("entidadesvalores", listaEntidadesValores);

			respuesta = entidad.toString();

		}

		if (!respuesta.equals("")) {
			this.sendMessageText(respuesta,
					Aa20bConstantes.OPER_MANT_LINEAS_ENTIDADES);
		}
	}

	@Override
	public String sincronizarTodasClasesGmao(List<Clase> clases,
			int tipoLlamada, String urlConfig) {
		// TODO Auto-generated method stub
		String respuesta = "";
		String entidadesStr = "";
		if (clases.size() != 0) {
			JSONObject entidades = new JSONObject();
			respuesta = this.generarEntidadClases(urlConfig);

			if (respuesta.equals("OK")) {
				// Recorremos la lista para ir sincronizando estancias
				JSONArray listaEntidadesLineas = new JSONArray();
				JSONArray listaEntidadesValores = new JSONArray();
				for (Clase clase : clases) {

					JSONObject entidadLinea = new JSONObject();
					JSONObject entidadValor = new JSONObject();
					JSONObject entidad = new JSONObject();
					if (clase != null) {

						int idClase = 0;
						if (clase.getIdclase() != null
								&& clase.getIdclase() != 0) {
							idClase = Integer.valueOf(clase.getIdclase()
									.toString());
						}
						entidadLinea.put("IdEntidad", "Clases");
						entidadLinea.put("Codigo", idClase);
						listaEntidadesLineas.put(entidadLinea);
						entidad.put("entidadeslineas", listaEntidadesLineas);

						entidadValor.put("IdEntidad", "Clases");
						entidadValor.put("IdColumna", "IdClase");
						entidadValor.put("Codigo", idClase);
						entidadValor.put("Valor", idClase);
						listaEntidadesValores.put(entidadValor);
						entidadValor = new JSONObject();
						entidadValor.put("IdEntidad", "Clases");
						entidadValor.put("IdColumna", "DescClase");
						entidadValor.put("Codigo", idClase);
						entidadValor.put("Valor", clase.getEclase() + " / "
								+ clase.getCclase());
						listaEntidadesValores.put(entidadValor);
						/*
						 * entidadValor = new JSONObject();
						 * entidadValor.put("IdEntidad", "Clases");
						 * entidadValor.put("IdColumna", "Clave");
						 * entidadValor.put("Codigo", idClase);
						 * entidadValor.put("Valor", clase.getIdclase());
						 * listaEntidadesValores.put(entidadValor);
						 */
					}

					// Objeto JSON con lineas de entidades
					entidades.put("entidadeslineas", listaEntidadesLineas);
					entidades.put("entidadesvalores", listaEntidadesValores);
					entidadesStr = entidades.toString();

					if (!entidadesStr.equals("")) {
						if (tipoLlamada == Aa20bConstantes.DIRECTA) {
							respuesta = this
									.sincronizarGmao(
											entidades,
											urlConfig
													+ Aa20bConstantes.URL_LINEAS_ENTIDAD);
						} else if (tipoLlamada == Aa20bConstantes.COLA) {
							this.sendMessageText(entidadesStr,
									Aa20bConstantes.OPER_MANT_LINEAS_ENTIDADES);
							respuesta = "";
						}
					}
				}
			}
		}
		return respuesta;
	}

	@Override
	public void sincronizarCodigoGmao(Codigo codigo) {
		// TODO Auto-generated method stub
		String respuesta = "";

		if (codigo != null) {

			int idCodigo = 0;
			if (codigo.getIdcodigo() != null && codigo.getIdcodigo() != 0) {
				idCodigo = Integer.valueOf(codigo.getIdcodigo().toString());
			}

			int idClase = 0;
			if (codigo.getIdclase() != null && codigo.getIdclase() != 0) {
				idClase = Integer.valueOf(codigo.getIdclase().toString());
			}

			JSONArray listaEntidadesLineas = new JSONArray();
			JSONObject entidadLinea = new JSONObject();
			JSONObject entidad = new JSONObject();
			JSONArray listaEntidadesValores = new JSONArray();
			JSONObject entidadValor = new JSONObject();

			entidadLinea.put("IdEntidad", "Codigos");
			entidadLinea.put("Codigo", idCodigo);
			listaEntidadesLineas.put(entidadLinea);
			entidad.put("entidadeslineas", listaEntidadesLineas);

			entidadValor.put("IdEntidad", "Codigos");
			entidadValor.put("IdColumna", "IdCodigo");
			entidadValor.put("Codigo", idCodigo);
			entidadValor.put("Valor", idCodigo);
			listaEntidadesValores.put(entidadValor);
			entidadValor = new JSONObject();
			entidadValor.put("IdEntidad", "Codigos");
			entidadValor.put("IdColumna", "DescCodigo");
			entidadValor.put("Codigo", idCodigo);
			entidadValor.put("Valor",
					codigo.getEcodigo() + " / " + codigo.getCcodigo());
			listaEntidadesValores.put(entidadValor);
			entidadValor = new JSONObject();
			entidadValor.put("IdEntidad", "Codigos");
			entidadValor.put("IdColumna", "ClaseRel");
			entidadValor.put("Codigo", idCodigo);
			entidadValor.put("Valor", idClase);
			listaEntidadesValores.put(entidadValor);

			entidad.put("entidadesvalores", listaEntidadesValores);

			respuesta = entidad.toString();

		}

		if (!respuesta.equals("")) {
			this.sendMessageText(respuesta,
					Aa20bConstantes.OPER_MANT_LINEAS_ENTIDADES);
		}
	}

	@Override
	public String sincronizarTodosCodigosGmao(List<Codigo> codigos,
			int tipoLlamada, String urlConfig) {
		// TODO Auto-generated method stub
		String respuesta = "";
		String entidadesStr = "";
		if (codigos.size() != 0) {
			JSONObject entidades = new JSONObject();
			respuesta = this.generarEntidadCodigos(urlConfig);

			if (respuesta.equals("OK")) {
				// Recorremos la lista para ir sincronizando estancias
				JSONArray listaEntidadesLineas = new JSONArray();
				JSONArray listaEntidadesValores = new JSONArray();
				JSONArray enumerados = new JSONArray();
				JSONObject enumerado = new JSONObject();
				JSONArray enumeradosIdioma = new JSONArray();
				JSONObject enumeradoIdioma = new JSONObject();
				JSONObject enumeradoSend = new JSONObject();

				// Ordeno la lista por idClase
				Collections.sort(codigos, new Comparator<Codigo>() {
					public int compare(Codigo codigo1, Codigo codigo2) {
						int c;
						c = codigo1.getIdclase()
								.compareTo(codigo2.getIdclase());
						return c;
					}
				});
				Integer idClaseAnt = 0;
				for (Codigo codigo : codigos) {

					JSONObject entidadLinea = new JSONObject();
					JSONObject entidadValor = new JSONObject();
					JSONObject entidad = new JSONObject();
					if (codigo != null) {

						int idCodigo = 0;
						if (codigo.getIdcodigo() != null
								&& codigo.getIdcodigo() != 0) {
							idCodigo = Integer.valueOf(codigo.getIdcodigo()
									.toString());
						}

						int idClase = 0;
						if (codigo.getIdclase() != null
								&& codigo.getIdclase() != 0) {
							idClase = Integer.valueOf(codigo.getIdclase()
									.toString());
						}
						entidadLinea.put("IdEntidad", "Codigos");
						entidadLinea.put("Codigo", idCodigo);
						listaEntidadesLineas.put(entidadLinea);
						entidad.put("entidadeslineas", listaEntidadesLineas);

						entidadValor.put("IdEntidad", "Codigos");
						entidadValor.put("IdColumna", "IdCodigo");
						entidadValor.put("Codigo", idCodigo);
						entidadValor.put("Valor", idCodigo);
						listaEntidadesValores.put(entidadValor);
						entidadValor = new JSONObject();
						entidadValor.put("IdEntidad", "Codigos");
						entidadValor.put("IdColumna", "DescCodigo");
						entidadValor.put("Codigo", idCodigo);
						entidadValor.put("Valor", codigo.getEcodigo() + " / "
								+ codigo.getCcodigo());
						listaEntidadesValores.put(entidadValor);
						entidadValor = new JSONObject();
						entidadValor.put("IdEntidad", "Codigos");
						entidadValor.put("IdColumna", "ClaseRel");
						entidadValor.put("Codigo", idCodigo);
						entidadValor.put("Valor", idClase);
						listaEntidadesValores.put(entidadValor);

						if (idClaseAnt != idClase) {
							enumerado = new JSONObject();
							enumerado.put("IdEnumerado", "E" + idClase);
							enumerado.put("Valor", "0_CORRECTO");
							enumerados.put(enumerado);
							enumeradoIdioma = new JSONObject();
							enumeradoIdioma.put("IdEnumerado", "E" + idClase);
							enumeradoIdioma.put("IdIdioma", "gv");
							enumeradoIdioma.put("Valor", "0_CORRECTO");
							enumeradoIdioma.put("ValorIdioma", "CORRECTO");
							enumeradosIdioma.put(enumeradoIdioma);
							enumeradoIdioma = new JSONObject();
							enumeradoIdioma.put("IdEnumerado", "E" + idClase);
							enumeradoIdioma.put("IdIdioma", "eu");
							enumeradoIdioma.put("Valor", "0_CORRECTO");
							enumeradoIdioma.put("ValorIdioma", "ZUZENA");
							enumeradosIdioma.put(enumeradoIdioma);
						}
						enumerado = new JSONObject();
						enumerado.put("IdEnumerado", "E" + idClase);
						enumerado.put("Valor", codigo.getIdcodigo() + "_"
								+ codigo.getCcodigo() + "_CORRECTIVO");
						enumerados.put(enumerado);
						enumeradoIdioma = new JSONObject();
						enumeradoIdioma.put("IdEnumerado", "E" + idClase);
						enumeradoIdioma.put("IdIdioma", "gv");
						enumeradoIdioma.put("Valor", codigo.getIdcodigo() + "_"
								+ codigo.getCcodigo() + "_CORRECTIVO");
						enumeradoIdioma.put("ValorIdioma", codigo.getCcodigo()
								+ "_CORRECTIVO");
						enumeradosIdioma.put(enumeradoIdioma);
						enumeradoIdioma = new JSONObject();
						enumeradoIdioma.put("IdEnumerado", "E" + idClase);
						enumeradoIdioma.put("IdIdioma", "eu");
						enumeradoIdioma.put("Valor", codigo.getIdcodigo() + "_"
								+ codigo.getCcodigo() + "_CORRECTIVO");
						enumeradoIdioma.put("ValorIdioma", codigo.getEcodigo()
								+ "_ZUZENKETA");
						enumeradosIdioma.put(enumeradoIdioma);

						idClaseAnt = idClase;
					}

					// Objeto JSON con lineas de entidades
					entidades.put("entidadeslineas", listaEntidadesLineas);
					entidades.put("entidadesvalores", listaEntidadesValores);
					entidadesStr = entidades.toString();

					if (!entidadesStr.equals("")) {
						if (tipoLlamada == Aa20bConstantes.DIRECTA) {
							respuesta = this
									.sincronizarGmao(
											entidades,
											urlConfig
													+ Aa20bConstantes.URL_LINEAS_ENTIDAD);
						} else if (tipoLlamada == Aa20bConstantes.COLA) {
							this.sendMessageText(entidadesStr,
									Aa20bConstantes.OPER_MANT_LINEAS_ENTIDADES);
							respuesta = "";
						}
					}
				}

				if (respuesta.equals("OK")) {
					if (enumerados.length() > 0) {

						enumeradoSend.put("enumerados", enumerados);
						enumeradoSend.put("enumeradoidioma", enumeradosIdioma);

						if (tipoLlamada == Aa20bConstantes.DIRECTA) {
							respuesta = this
									.sincronizarGmao(
											enumeradoSend,
											urlConfig
													+ "Expertis_Sync_Movil_JS/index.php/sync/masters/SubirEnumerados/");
						} else if (tipoLlamada == Aa20bConstantes.COLA) {
							String enumeradosStr = enumeradoSend.toString();
							this.sendMessageText(enumeradosStr,
									Aa20bConstantes.OPER_MANT_ENUMERADOS);
							respuesta = "";
						}
					}
				}
			}
		}

		return respuesta;
	}

	@Override
	public void sincronizarGamaGmao(Gamas gama) {
		// TODO Auto-generated method stub
		String respuesta = "";

		if (gama != null) {

			int idGama = 0;
			if (gama.getIdgama() != null && gama.getIdgama() != 0) {
				idGama = Integer.valueOf(gama.getIdgama().toString());
			}

			int idClase = 0;
			if (gama.getIdclase() != null && gama.getIdclase() != 0) {
				idClase = Integer.valueOf(gama.getIdclase().toString());
			}
			int idServicio = 0;
			if (gama.getIdservicio() != null && gama.getIdservicio() != 0) {
				idServicio = Integer.valueOf(gama.getIdservicio().toString());
			}

			JSONArray listaEntidadesLineas = new JSONArray();
			JSONObject entidadLinea = new JSONObject();
			JSONObject entidad = new JSONObject();
			JSONArray listaEntidadesValores = new JSONArray();
			JSONObject entidadValor = new JSONObject();

			entidadLinea.put("IdEntidad", "Gamas");
			entidadLinea.put("Codigo", idGama);
			listaEntidadesLineas.put(entidadLinea);
			entidad.put("entidadeslineas", listaEntidadesLineas);

			entidadValor.put("IdEntidad", "Gamas");
			entidadValor.put("IdColumna", "IdGama");
			entidadValor.put("Codigo", idGama);
			entidadValor.put("Valor", idGama);
			listaEntidadesValores.put(entidadValor);
			entidadValor = new JSONObject();
			entidadValor.put("IdEntidad", "Gamas");
			entidadValor.put("IdColumna", "DescGama");
			entidadValor.put("Codigo", idGama);
			entidadValor
					.put("Valor", gama.getEgama() + " / " + gama.getCgama());
			listaEntidadesValores.put(entidadValor);
			entidadValor = new JSONObject();
			entidadValor.put("IdEntidad", "Gamas");
			entidadValor.put("IdColumna", "ClaseRel");
			entidadValor.put("Codigo", idGama);
			entidadValor.put("Valor", idClase);
			listaEntidadesValores.put(entidadValor);
			entidadValor = new JSONObject();
			entidadValor.put("IdEntidad", "Gamas");
			entidadValor.put("IdColumna", "ServicioRel");
			entidadValor.put("Codigo", idGama);
			entidadValor.put("Valor", idServicio);
			listaEntidadesValores.put(entidadValor);

			entidad.put("entidadesvalores", listaEntidadesValores);

			respuesta = entidad.toString();

		}

		if (!respuesta.equals("")) {
			this.sendMessageText(respuesta,
					Aa20bConstantes.OPER_MANT_LINEAS_ENTIDADES);
		}
	}

	@Override
	public String sincronizarTodosGamasGmao(List<Gamas> gamas, int tipoLlamada,
			String urlConfig) {
		// TODO Auto-generated method stub
		String respuesta = "";
		String entidadesStr = "";
		if (gamas.size() != 0) {
			JSONObject entidades = new JSONObject();
			respuesta = this.generarEntidadGamas(urlConfig);

			if (respuesta.equals("OK")) {
				// Recorremos la lista para ir sincronizando estancias
				JSONArray listaEntidadesLineas = new JSONArray();
				JSONArray listaEntidadesValores = new JSONArray();
				for (Gamas gama : gamas) {

					JSONObject entidadLinea = new JSONObject();
					JSONObject entidadValor = new JSONObject();
					JSONObject entidad = new JSONObject();
					if (gama != null) {

						int idGama = 0;
						if (gama.getIdgama() != null && gama.getIdgama() != 0) {
							idGama = Integer.valueOf(gama.getIdgama()
									.toString());
						}

						int idClase = 0;
						if (gama.getIdclase() != null && gama.getIdclase() != 0) {
							idClase = Integer.valueOf(gama.getIdclase()
									.toString());
						}
						int idServicio = 0;
						if (gama.getIdservicio() != null
								&& gama.getIdservicio() != 0) {
							idServicio = Integer.valueOf(gama.getIdservicio()
									.toString());
						}
						entidadLinea.put("IdEntidad", "Gamas");
						entidadLinea.put("Codigo", idGama);
						listaEntidadesLineas.put(entidadLinea);
						entidad.put("entidadeslineas", listaEntidadesLineas);

						entidadValor.put("IdEntidad", "Gamas");
						entidadValor.put("IdColumna", "IdGama");
						entidadValor.put("Codigo", idGama);
						entidadValor.put("Valor", idGama);
						listaEntidadesValores.put(entidadValor);
						entidadValor = new JSONObject();
						entidadValor.put("IdEntidad", "Gamas");
						entidadValor.put("IdColumna", "DescGama");
						entidadValor.put("Codigo", idGama);
						entidadValor.put("Valor", gama.getEgama() + " / "
								+ gama.getCgama());
						listaEntidadesValores.put(entidadValor);
						entidadValor = new JSONObject();
						entidadValor.put("IdEntidad", "Gamas");
						entidadValor.put("IdColumna", "ClaseRel");
						entidadValor.put("Codigo", idGama);
						entidadValor.put("Valor", idClase);
						listaEntidadesValores.put(entidadValor);
						entidadValor = new JSONObject();
						entidadValor.put("IdEntidad", "Gamas");
						entidadValor.put("IdColumna", "ServicioRel");
						entidadValor.put("Codigo", idGama);
						entidadValor.put("Valor", idServicio);
						listaEntidadesValores.put(entidadValor);

					}

					// Objeto JSON con lineas de entidades
					entidades.put("entidadeslineas", listaEntidadesLineas);
					entidades.put("entidadesvalores", listaEntidadesValores);
					entidadesStr = entidades.toString();

					if (!entidadesStr.equals("")) {
						if (tipoLlamada == Aa20bConstantes.DIRECTA) {
							respuesta = this
									.sincronizarGmao(
											entidades,
											urlConfig
													+ Aa20bConstantes.URL_LINEAS_ENTIDAD);
						} else if (tipoLlamada == Aa20bConstantes.COLA) {
							this.sendMessageText(entidadesStr,
									Aa20bConstantes.OPER_MANT_LINEAS_ENTIDADES);
							respuesta = "";
						}
					}
				}
			}
		}

		return respuesta;
	}

	@Override
	public String sincronizarTodosMaquinasGmao(List<Maquinas> maquinas,
			int tipoLlamada, String urlConfig, int numSinc) {
		// TODO Auto-generated method stub
		String respuesta = "";
		String entidadesStr = "";
		if (maquinas.size() != 0) {
			JSONObject entidades = new JSONObject();
			if (numSinc == 1) {
				respuesta = this.generarEntidadMaquinas(urlConfig);
			} else {
				respuesta = "OK";
			}

			if (respuesta.equals("OK")) {
				// Recorremos la lista para ir sincronizando estancias

				int tamanioBusq = maquinas.size();
				/*
				 * if (numSinc == 1) { if (maquinas.size() > 500) { tamanioBusq
				 * = 500; } } else if (numSinc == 2) { if (maquinas.size() <
				 * 500) { tamanioBusq = 0; } else if (maquinas.size() > 1000) {
				 * tamanioBusq = 1000; } } else if (numSinc == 3) { if
				 * (maquinas.size() < 1000) { tamanioBusq = 0; } }
				 */
				Maquinas maquina = new Maquinas();
				for (int i = 0; i <= tamanioBusq; i++) {
					JSONArray listaEntidadesLineas = new JSONArray();
					JSONArray listaEntidadesValores = new JSONArray();
					maquina = new Maquinas();
					/*
					 * if (numSinc == 2) { if (maquinas.size() > 500 && i < 501)
					 * { i = 501; } } if (numSinc == 3) { if (maquinas.size() >
					 * 1000 && i < 1001) { i = 1001; } }
					 */
					maquina = maquinas.get(i);
					JSONObject entidadLinea = new JSONObject();
					JSONObject entidadValor = new JSONObject();
					JSONObject entidad = new JSONObject();
					if (maquina != null) {

						int idMaquina = 0;
						if (maquina.getIdmaquina() != null
								&& maquina.getIdmaquina() != 0) {
							idMaquina = Integer.valueOf(maquina.getIdmaquina()
									.toString());
						}
						String guidEdificio = null;
						if (maquina.getIdedificio() != null
								&& !maquina.getIdedificio().trim().equals("")) {
							Edificios edificioMaq = this.edificiosDao
									.obtenerEdificio(maquina.getIdedificio());
							if (edificioMaq != null
									&& edificioMaq.getGuidedificio() != null) {
								guidEdificio = edificioMaq.getGuidedificio();
							}
						}

						int idGama = 0;
						if (maquina.getIdgama() != null
								&& maquina.getIdgama() != 0) {
							idGama = Integer.valueOf(maquina.getIdgama()
									.toString());
						}

						entidadLinea.put("IdEntidad", "Maquinas");
						entidadLinea.put("Codigo", idMaquina);
						listaEntidadesLineas.put(entidadLinea);
						entidad.put("entidadeslineas", listaEntidadesLineas);

						entidadValor.put("IdEntidad", "Maquinas");
						entidadValor.put("IdColumna", "IdMaquina");
						entidadValor.put("Codigo", idMaquina);
						entidadValor.put("Valor", idMaquina);
						listaEntidadesValores.put(entidadValor);

						entidadValor = new JSONObject();
						entidadValor.put("IdEntidad", "Maquinas");
						entidadValor.put("IdColumna", "Mcodigo");
						entidadValor.put("Codigo", idMaquina);
						entidadValor.put("Valor", maquina.getMcodigo());
						listaEntidadesValores.put(entidadValor);

						entidadValor = new JSONObject();
						entidadValor.put("IdEntidad", "Maquinas");
						entidadValor.put("IdColumna", "DescMaquina");
						entidadValor.put("Codigo", idMaquina);
						entidadValor.put("Valor", maquina.getEmaquina() + " / "
								+ maquina.getCmaquina());
						listaEntidadesValores.put(entidadValor);

						entidadValor = new JSONObject();
						entidadValor.put("IdEntidad", "Maquinas");
						entidadValor.put("IdColumna", "Edificio");
						entidadValor.put("Codigo", idMaquina);
						if (guidEdificio != null) {
							entidadValor.put("Valor", "{" + guidEdificio + "}");
						} else {
							entidadValor.put("Valor", JSONObject.NULL);
						}
						listaEntidadesValores.put(entidadValor);

						entidadValor = new JSONObject();
						entidadValor.put("IdEntidad", "Maquinas");
						entidadValor.put("IdColumna", "Gama");
						entidadValor.put("Codigo", idMaquina);
						entidadValor.put("Valor", idGama);
						listaEntidadesValores.put(entidadValor);

					}

					// Objeto JSON con lineas de entidades
					entidades.put("entidadeslineas", listaEntidadesLineas);
					entidades.put("entidadesvalores", listaEntidadesValores);
					entidadesStr = entidades.toString();

					if (!entidadesStr.equals("")) {
						if (tipoLlamada == Aa20bConstantes.DIRECTA) {
							respuesta = this
									.sincronizarGmao(
											entidades,
											urlConfig
													+ Aa20bConstantes.URL_LINEAS_ENTIDAD);
						} else if (tipoLlamada == Aa20bConstantes.COLA) {
							this.sendMessageText(entidadesStr,
									Aa20bConstantes.OPER_MANT_LINEAS_ENTIDADES);
							respuesta = "";
						}
					}
				}
			}
		}

		return respuesta;
	}

	@Override
	public void sincronizarMaquinaGmao(Maquinas maquina) {
		// TODO Auto-generated method stub
		String respuesta = "";

		if (maquina != null) {

			int idMaquina = 0;
			if (maquina.getIdmaquina() != null && maquina.getIdmaquina() != 0) {
				idMaquina = Integer.valueOf(maquina.getIdmaquina().toString());
			}

			int idGama = 0;
			if (maquina.getIdgama() != null && maquina.getIdgama() != 0) {
				idGama = Integer.valueOf(maquina.getIdgama().toString());
			}

			String guidEdificio = null;
			if (maquina.getIdedificio() != null
					&& !maquina.getIdedificio().trim().equals("")) {
				Edificios edificioMaq = this.edificiosDao
						.obtenerEdificio(maquina.getIdedificio());
				if (edificioMaq != null
						&& edificioMaq.getGuidedificio() != null) {
					guidEdificio = edificioMaq.getGuidedificio();
				}
			}

			JSONArray listaEntidadesLineas = new JSONArray();
			JSONObject entidadLinea = new JSONObject();
			JSONObject entidad = new JSONObject();
			JSONArray listaEntidadesValores = new JSONArray();
			JSONObject entidadValor = new JSONObject();

			entidadLinea.put("IdEntidad", "Maquinas");
			entidadLinea.put("Codigo", idMaquina);
			listaEntidadesLineas.put(entidadLinea);
			entidad.put("entidadeslineas", listaEntidadesLineas);

			entidadValor.put("IdEntidad", "Maquinas");
			entidadValor.put("IdColumna", "IdMaquina");
			entidadValor.put("Codigo", idMaquina);
			entidadValor.put("Valor", idMaquina);
			listaEntidadesValores.put(entidadValor);

			entidadValor = new JSONObject();
			entidadValor.put("IdEntidad", "Maquinas");
			entidadValor.put("IdColumna", "Mcodigo");
			entidadValor.put("Codigo", idMaquina);
			entidadValor.put("Valor", maquina.getMcodigo());
			listaEntidadesValores.put(entidadValor);

			entidadValor = new JSONObject();
			entidadValor.put("IdEntidad", "Maquinas");
			entidadValor.put("IdColumna", "DescMaquina");
			entidadValor.put("Codigo", idMaquina);
			entidadValor.put("Valor",
					maquina.getEmaquina() + " / " + maquina.getCmaquina());
			listaEntidadesValores.put(entidadValor);

			entidadValor = new JSONObject();
			entidadValor.put("IdEntidad", "Maquinas");
			entidadValor.put("IdColumna", "Edificio");
			entidadValor.put("Codigo", idMaquina);
			if (guidEdificio != null) {
				entidadValor.put("Valor", guidEdificio);
			} else {
				entidadValor.put("Valor", JSONObject.NULL);
			}
			listaEntidadesValores.put(entidadValor);

			entidadValor = new JSONObject();
			entidadValor.put("IdEntidad", "Maquinas");
			entidadValor.put("IdColumna", "GamaRel");
			entidadValor.put("Codigo", idMaquina);
			entidadValor.put("Valor", idGama);
			listaEntidadesValores.put(entidadValor);

			entidad.put("entidadesvalores", listaEntidadesValores);

			respuesta = entidad.toString();

		}

		if (!respuesta.equals("")) {
			this.sendMessageText(respuesta,
					Aa20bConstantes.OPER_MANT_LINEAS_ENTIDADES);
		}
	}

	@Override
	public void sincronizarServicioGmao(Servicios servicio) {
		// TODO Auto-generated method stub
		String respuesta = "";

		if (servicio != null) {

			int idServicio = 0;
			if (servicio.getIdservicio() != null
					&& servicio.getIdservicio() != 0) {
				idServicio = Integer.valueOf(servicio.getIdservicio()
						.toString());
			}

			JSONArray listaEntidadesLineas = new JSONArray();
			JSONObject entidadLinea = new JSONObject();
			JSONObject entidad = new JSONObject();
			JSONArray listaEntidadesValores = new JSONArray();
			JSONObject entidadValor = new JSONObject();

			entidadLinea.put("IdEntidad", "Servicios");
			entidadLinea.put("Codigo", idServicio);
			listaEntidadesLineas.put(entidadLinea);
			entidad.put("entidadeslineas", listaEntidadesLineas);

			entidadValor.put("IdEntidad", "Servicios");
			entidadValor.put("IdColumna", "IdServicio");
			entidadValor.put("Codigo", idServicio);
			entidadValor.put("Valor", idServicio);
			listaEntidadesValores.put(entidadValor);
			entidadValor = new JSONObject();
			entidadValor.put("IdEntidad", "Servicios");
			entidadValor.put("IdColumna", "DescServicio");
			entidadValor.put("Codigo", idServicio);
			entidadValor.put("Valor", servicio.getEservicio() + " / "
					+ servicio.getCservicio());
			listaEntidadesValores.put(entidadValor);

			entidad.put("entidadesvalores", listaEntidadesValores);

			respuesta = entidad.toString();

		}

		if (!respuesta.equals("")) {
			this.sendMessageText(respuesta,
					Aa20bConstantes.OPER_MANT_LINEAS_ENTIDADES);
		}
	}

	@Override
	public String sincronizarTodosServiciosGmao(List<Servicios> servicios,
			int tipoLlamada, String urlConfig) {
		// TODO Auto-generated method stub
		String respuesta = "";
		String entidadesStr = "";
		if (servicios.size() != 0) {
			JSONObject entidades = new JSONObject();
			respuesta = this.generarEntidadServicios(urlConfig);

			if (respuesta.equals("OK")) {
				// Recorremos la lista para ir sincronizando estancias
				JSONArray listaEntidadesLineas = new JSONArray();
				JSONArray listaEntidadesValores = new JSONArray();
				for (Servicios servicio : servicios) {

					JSONObject entidadLinea = new JSONObject();
					JSONObject entidadValor = new JSONObject();
					JSONObject entidad = new JSONObject();
					if (servicio != null) {

						int idServicio = 0;
						if (servicio.getIdservicio() != null
								&& servicio.getIdservicio() != 0) {
							idServicio = Integer.valueOf(servicio
									.getIdservicio().toString());
						}
						entidadLinea.put("IdEntidad", "Servicios");
						entidadLinea.put("Codigo", idServicio);
						listaEntidadesLineas.put(entidadLinea);
						entidad.put("entidadeslineas", listaEntidadesLineas);

						entidadValor.put("IdEntidad", "Servicios");
						entidadValor.put("IdColumna", "IdServicio");
						entidadValor.put("Codigo", idServicio);
						entidadValor.put("Valor", idServicio);
						listaEntidadesValores.put(entidadValor);
						entidadValor = new JSONObject();
						entidadValor.put("IdEntidad", "Servicios");
						entidadValor.put("IdColumna", "DescServicio");
						entidadValor.put("Codigo", idServicio);
						entidadValor.put("Valor", servicio.getEservicio()
								+ " / " + servicio.getCservicio());
						listaEntidadesValores.put(entidadValor);
					}

					// Objeto JSON con lineas de entidades
					entidades.put("entidadeslineas", listaEntidadesLineas);
					entidades.put("entidadesvalores", listaEntidadesValores);
					entidadesStr = entidades.toString();

					if (!entidadesStr.equals("")) {
						if (tipoLlamada == Aa20bConstantes.DIRECTA) {
							respuesta = this
									.sincronizarGmao(
											entidades,
											urlConfig
													+ Aa20bConstantes.URL_LINEAS_ENTIDAD);
						} else if (tipoLlamada == Aa20bConstantes.COLA) {
							this.sendMessageText(entidadesStr,
									Aa20bConstantes.OPER_MANT_LINEAS_ENTIDADES);
							respuesta = "";
						}
					}
				}
			}
		}
		return respuesta;
	}

	@Override
	public String sincronizarTodosDepartamentos(List<Departamentos> dptos,
			int tipoLlamada, String urlConfig) {
		// TODO Auto-generated method stub
		String respuesta = "";
		String entidadesStr = "";
		if (dptos.size() != 0) {
			JSONObject entidades = new JSONObject();
			respuesta = this.generarEntidadDepartamentos(urlConfig);

			if (respuesta.equals("OK")) {
				// Recorremos la lista para ir sincronizando estancias
				JSONArray listaEntidadesLineas = new JSONArray();
				JSONArray listaEntidadesValores = new JSONArray();
				for (Departamentos departamento : dptos) {

					JSONObject entidadLinea = new JSONObject();
					JSONObject entidadValor = new JSONObject();
					JSONObject entidad = new JSONObject();
					if (departamento != null) {

						int idDepar = 0;
						if (departamento.getIddepar() != null
								&& departamento.getIddepar() != 0) {
							idDepar = Integer.valueOf(departamento.getIddepar()
									.toString());
						}
						entidadLinea.put("IdEntidad", "Departamentos");
						entidadLinea.put("Codigo", idDepar);
						listaEntidadesLineas.put(entidadLinea);
						entidad.put("entidadeslineas", listaEntidadesLineas);

						entidadValor.put("IdEntidad", "Departamentos");
						entidadValor.put("IdColumna", "IdDepar");
						entidadValor.put("Codigo", idDepar);
						entidadValor.put("Valor", idDepar);
						listaEntidadesValores.put(entidadValor);
						entidadValor = new JSONObject();
						entidadValor.put("IdEntidad", "Departamentos");
						entidadValor.put("IdColumna", "DescDepar");
						entidadValor.put("Codigo", idDepar);
						entidadValor.put("Valor", departamento.getEdepar()
								+ " / " + departamento.getCdepar());
						listaEntidadesValores.put(entidadValor);
						entidadValor = new JSONObject();
						entidadValor.put("IdEntidad", "Departamentos");
						entidadValor.put("IdColumna", "Baja");
						entidadValor.put("Codigo", idDepar);
						if (departamento.getBaja() != null
								&& departamento.getBaja().equals("1")) {
							entidadValor.put("Valor", departamento.getBaja());
						} else {
							entidadValor.put("Valor", "0");
						}
						listaEntidadesValores.put(entidadValor);

					}

					// Objeto JSON con lineas de entidades
					entidades.put("entidadeslineas", listaEntidadesLineas);
					entidades.put("entidadesvalores", listaEntidadesValores);
					entidadesStr = entidades.toString();

					if (!entidadesStr.equals("")) {
						if (tipoLlamada == Aa20bConstantes.DIRECTA) {
							respuesta = this
									.sincronizarGmao(
											entidades,
											urlConfig
													+ Aa20bConstantes.URL_LINEAS_ENTIDAD);
						} else if (tipoLlamada == Aa20bConstantes.COLA) {
							this.sendMessageText(entidadesStr,
									Aa20bConstantes.OPER_MANT_LINEAS_ENTIDADES);
							respuesta = "";
						}
					}
				}
			}
		}
		return respuesta;
	}

	@Override
	public String sincronizarTodasDirecciones(List<Direcciones> dirs,
			int tipoLlamada, String urlConfig) {
		// TODO Auto-generated method stub
		String respuesta = "";
		String entidadesStr = "";
		if (dirs.size() != 0) {
			JSONObject entidades = new JSONObject();
			respuesta = this.generarEntidadDirecciones(urlConfig);

			if (respuesta.equals("OK")) {
				// Recorremos la lista para ir sincronizando estancias
				JSONArray listaEntidadesLineas = new JSONArray();
				JSONArray listaEntidadesValores = new JSONArray();
				for (Direcciones direccion : dirs) {

					JSONObject entidadLinea = new JSONObject();
					JSONObject entidadValor = new JSONObject();
					JSONObject entidad = new JSONObject();
					if (direccion != null) {

						int idDir = 0;
						if (direccion.getIddir() != null
								&& direccion.getIddir() != 0) {
							idDir = Integer.valueOf(direccion.getIddir()
									.toString());
						}
						entidadLinea.put("IdEntidad", "Direcciones");
						entidadLinea.put("Codigo", idDir);
						listaEntidadesLineas.put(entidadLinea);
						entidad.put("entidadeslineas", listaEntidadesLineas);

						entidadValor.put("IdEntidad", "Direcciones");
						entidadValor.put("IdColumna", "IdDir");
						entidadValor.put("Codigo", idDir);
						entidadValor.put("Valor", idDir);
						listaEntidadesValores.put(entidadValor);
						entidadValor = new JSONObject();
						entidadValor.put("IdEntidad", "Direcciones");
						entidadValor.put("IdColumna", "DescDir");
						entidadValor.put("Codigo", idDir);
						entidadValor.put("Valor", direccion.getEdir() + " / "
								+ direccion.getCdir());
						listaEntidadesValores.put(entidadValor);
						entidadValor = new JSONObject();
						entidadValor.put("IdEntidad", "Direcciones");
						entidadValor.put("IdColumna", "DeparRel");
						entidadValor.put("Codigo", idDir);
						entidadValor.put("Valor", direccion.getIddepar());
						listaEntidadesValores.put(entidadValor);
						entidadValor = new JSONObject();
						entidadValor.put("IdEntidad", "Direcciones");
						entidadValor.put("IdColumna", "Baja");
						entidadValor.put("Codigo", idDir);
						if (direccion.getBaja() != null
								&& direccion.getBaja().equals("1")) {
							entidadValor.put("Valor", direccion.getBaja());
						} else {
							entidadValor.put("Valor", "0");
						}
						listaEntidadesValores.put(entidadValor);
					}

					// Objeto JSON con lineas de entidades
					entidades.put("entidadeslineas", listaEntidadesLineas);
					entidades.put("entidadesvalores", listaEntidadesValores);
					entidadesStr = entidades.toString();

					if (!entidadesStr.equals("")) {
						if (tipoLlamada == Aa20bConstantes.DIRECTA) {
							respuesta = this
									.sincronizarGmao(
											entidades,
											urlConfig
													+ Aa20bConstantes.URL_LINEAS_ENTIDAD);
						} else if (tipoLlamada == Aa20bConstantes.COLA) {
							this.sendMessageText(entidadesStr,
									Aa20bConstantes.OPER_MANT_LINEAS_ENTIDADES);
							respuesta = "";
						}
					}
				}
			}
		}
		return respuesta;
	}

	@Override
	public String subirOTcambioEstado(String guidOT, String nuevoEstado,
			String urlConfig) {
		String respuesta = "";

		JSONObject datosJson = new JSONObject();
		JSONArray camposModificables = new JSONArray();
		JSONObject campoModif = new JSONObject();

		campoModif.put("UUIdOt", "{" + guidOT.toUpperCase() + "}");
		campoModif.put("NombreColumna", "IdEstado");
		campoModif.put("ValorNuevo", nuevoEstado);
		camposModificables.put(campoModif);

		campoModif = new JSONObject();
		campoModif.put("UUIdOt", "{" + guidOT.toUpperCase() + "}");
		campoModif.put("NombreColumna", "PdteSinc");
		campoModif.put("ValorNuevo", "1");
		camposModificables.put(campoModif);

		datosJson.put("camposModificables", camposModificables);

		respuesta = this
				.sincronizarGmao(
						datosJson,
						urlConfig
								+ "Expertis_Sync_Movil_JS/index.php/sync/masters/SetCamposActualizables/");

		return respuesta;
	}

	@Override
	public String subirOTcambioFechaPlanif(String guidOT, Date fechaPlanif,
			String urlConfig) {
		String respuesta = "OK";

		JSONObject datosJson = new JSONObject();
		JSONArray camposModificables = new JSONArray();
		JSONObject campoModif = new JSONObject();

		if (fechaPlanif != null) {
			DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			String fechaPlanifStr = df.format(fechaPlanif);

			campoModif.put("UUIdOt", "{" + guidOT.toUpperCase() + "}");
			campoModif.put("NombreColumna", "FechaPlanificacion");
			campoModif.put("ValorNuevo", fechaPlanifStr);
			camposModificables.put(campoModif);

			campoModif = new JSONObject();
			campoModif.put("UUIdOt", "{" + guidOT.toUpperCase() + "}");
			campoModif.put("NombreColumna", "PdteSinc");
			campoModif.put("ValorNuevo", "1");
			camposModificables.put(campoModif);

			datosJson.put("camposModificables", camposModificables);

			respuesta = this
					.sincronizarGmao(
							datosJson,
							urlConfig
									+ "Expertis_Sync_Movil_JS/index.php/sync/masters/SetCamposActualizables/");
		}

		return respuesta;
	}

	@Override
	public String subirOTcambioTecnico(String guidOT, String nuevoOperario,
			String urlConfig) {
		String respuesta = "";

		JSONObject datosJson = new JSONObject();
		JSONArray camposModificables = new JSONArray();
		JSONObject campoModif = new JSONObject();

		campoModif.put("UUIdOt", "{" + guidOT.toUpperCase() + "}");
		campoModif.put("NombreColumna", "IdOperarioResponsable");
		if (nuevoOperario != null && !nuevoOperario.equals("")) {
			campoModif.put("ValorNuevo", nuevoOperario);
		} else {
			campoModif.put("ValorNuevo", JSONObject.NULL);
		}
		camposModificables.put(campoModif);

		campoModif = new JSONObject();
		campoModif.put("UUIdOt", "{" + guidOT.toUpperCase() + "}");
		campoModif.put("NombreColumna", "PdteSinc");
		campoModif.put("ValorNuevo", "1");
		camposModificables.put(campoModif);

		datosJson.put("camposModificables", camposModificables);

		respuesta = this
				.sincronizarGmao(
						datosJson,
						urlConfig
								+ "Expertis_Sync_Movil_JS/index.php/sync/masters/SetCamposActualizables/");

		return respuesta;
	}

	@Override
	public String enviarObservacionResponsable(String guidOT,
			String observacion, String urlConfig) {
		String respuesta = "";

		JSONObject datosJson = new JSONObject();
		JSONArray camposModificables = new JSONArray();
		JSONObject campoModif = new JSONObject();
		campoModif.put("UUIdOt", "{" + guidOT.toUpperCase() + "}");
		campoModif.put("NombreColumna", "ObsInternas");
		campoModif.put("ValorNuevo", observacion);
		camposModificables.put(campoModif);

		datosJson.put("camposModificables", camposModificables);

		respuesta = this
				.sincronizarGmao(
						datosJson,
						urlConfig
								+ "Expertis_Sync_Movil_JS/index.php/sync/masters/SetCamposActualizables/");

		return respuesta;
	}

	@Override
	public String enviarObservacionesFicha(String guidOT, String observaciones,
			String urlConfig) {
		String respuesta = "";

		JSONObject datosJson = new JSONObject();
		JSONArray camposModificables = new JSONArray();
		JSONObject campoModif = new JSONObject();
		campoModif.put("UUIdOt", "{" + guidOT.toUpperCase() + "}");
		campoModif.put("NombreColumna", "DescLarga");
		campoModif.put("ValorNuevo", observaciones);
		camposModificables.put(campoModif);

		campoModif = new JSONObject();
		campoModif.put("UUIdOt", "{" + guidOT.toUpperCase() + "}");
		campoModif.put("NombreColumna", "DescCorta");
		campoModif.put("ValorNuevo", observaciones);
		camposModificables.put(campoModif);

		datosJson.put("camposModificables", camposModificables);

		respuesta = this
				.sincronizarGmao(
						datosJson,
						urlConfig
								+ "Expertis_Sync_Movil_JS/index.php/sync/masters/SetCamposActualizables/");

		return respuesta;
	}

	@Override
	public String marcarOTaceptada(String guidOT, String aceptada,
			String urlConfig) {
		String respuesta = "";

		JSONObject datosJson = new JSONObject();
		JSONArray camposModificables = new JSONArray();
		JSONObject campoModif = new JSONObject();

		campoModif.put("UUIdOt", "{" + guidOT.toUpperCase() + "}");
		campoModif.put("NombreColumna", "Aceptada");
		campoModif.put("ValorNuevo", aceptada);
		camposModificables.put(campoModif);

		/*
		 * campoModif = new JSONObject(); campoModif.put("UUIdOt", "{" +
		 * guidOT.toUpperCase() + "}"); campoModif.put("NombreColumna",
		 * "PdteSinc"); campoModif.put("ValorNuevo", "1");
		 * camposModificables.put(campoModif);
		 */

		datosJson.put("camposModificables", camposModificables);

		respuesta = this
				.sincronizarGmao(
						datosJson,
						urlConfig
								+ "Expertis_Sync_Movil_JS/index.php/sync/masters/SetCamposActualizables/");

		return respuesta;
	}

	@Override
	public String sincronizarParteCorrectivoGmao(Partes parte,
			List<Partetecnicosgmao> tecnicosParteGmao, String UUIdActivo,
			byte[] plano, byte[] pdf, String urlConfig) {
		// TODO Auto-generated method stub
		String respuesta = "";
		String respuestaFichero = "";
		String respuestaPDF = "";

		JSONObject datosJson = new JSONObject();
		JSONArray ots = new JSONArray();
		JSONObject ot = new JSONObject();
		JSONArray operarios = new JSONArray();
		JSONObject operario = new JSONObject();
		JSONArray documentos = new JSONArray();
		JSONObject documento = new JSONObject();
		JSONArray campos = new JSONArray();
		JSONObject campo = new JSONObject();
		JSONArray otmods = new JSONArray();
		JSONObject otmod = new JSONObject();

		java.util.Date fechaActual = new Date();
		DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		String fechaActualJson = df.format(fechaActual);

		// Creacion OT padre o ppal
		/*
		 * ot.put("NROT", Aa20bConstantes.COD_PARTE_GMAO_CORRECTIVO + "_" +
		 * parte.getIdparte()); if (parte.getObserv() != null) {
		 * ot.put("DescCorta", parte.getObserv()); } else { ot.put("DescCorta",
		 * JSONObject.NULL); } // Se comprueba si el parte está finalizado if
		 * (parte.getEjecutado() != null && parte.getEjecutado() != null &&
		 * parte.getEjecutado().equals("1")) { ot.put("IdEstado",
		 * Aa20bConstantes.COD_ESTADO_GMAO_TERMINADO); } else {
		 * ot.put("IdEstado", Aa20bConstantes.COD_ESTADO_GMAO_ASIGNADO); } if
		 * (parte.getUrgente() != null) { ot.put("IdPrioridad",
		 * parte.getUrgente()); } else { ot.put("IdPrioridad", "0"); }
		 * ot.put("IdTipo", "1"); ot.put("IdOperarioCoordinador",
		 * JSONObject.NULL); ot.put("IdOperarioResponsable", JSONObject.NULL);
		 * ot.put("Aceptada", JSONObject.NULL); if (parte.getObserv() != null) {
		 * ot.put("DescLarga", parte.getObserv()); } else { ot.put("DescLarga",
		 * JSONObject.NULL); } if (parte.getFechare() != null) {
		 * ot.put("FechaSolicitud", parte.getFechare());
		 * 
		 * } else { ot.put("FechaSolicitud", JSONObject.NULL);
		 * 
		 * }
		 * 
		 * ot.put("FechaPlanificacion", JSONObject.NULL); ot.put("FechaCierre",
		 * JSONObject.NULL); ot.put("Direccion", JSONObject.NULL);
		 * ot.put("CodigoPostal", JSONObject.NULL); ot.put("Poblacion",
		 * JSONObject.NULL); ot.put("Provincia", JSONObject.NULL);
		 * ot.put("UUIdOt", parte.getGuidparte()); ot.put("UUIdActivo",
		 * UUIdActivo); ots.put(ot); if (tecnicosParteGmao != null) { for
		 * (Partetecnicosgmao parteTecnicoGmao : tecnicosParteGmao) { if
		 * (parteTecnicoGmao.getIdpartec() != null &&
		 * parteTecnicoGmao.getIdpartec() != 0) { operario = new JSONObject();
		 * operario.put("IdOperario", parteTecnicoGmao.getIdtecnico());
		 * operario.put("UUIdOt", parte.getGuidparte());
		 * operarios.put(operario); } } }
		 */

		/*
		 * if (respuestaFichero != null && !respuestaFichero.equals("")) {
		 * documento.put("DescDocumento", "plano" + parte.getIdparte() +
		 * ".jpeg"); documento.put("RutaRelativa", JSONObject.NULL);
		 * documento.put("UUIdOtDocumento", guidparteplano);
		 * documento.put("UUIdOt", parte.getGuidparte());
		 * documento.put("RutaServidor", respuestaFichero);
		 * documento.put("FechaServidor", JSONObject.NULL);
		 * documentos.put(documento); }
		 */

		/*
		 * campo.put("IdCampo", "NOMBRE"); campo.put("UUIdOt",
		 * parte.getGuidparte()); if (parte.getNombre() != null) {
		 * campo.put("Valor", parte.getNombre()); } else { campo.put("Valor",
		 * JSONObject.NULL); } campos.put(campo);
		 * 
		 * campo = new JSONObject(); campo.put("IdCampo", "TELEFONO");
		 * campo.put("UUIdOt", parte.getGuidparte()); if (parte.getTelefo() !=
		 * null) { campo.put("Valor", parte.getTelefo()); } else {
		 * campo.put("Valor", JSONObject.NULL); } campos.put(campo);
		 * 
		 * campo = new JSONObject(); campo.put("IdCampo", "MAIL");
		 * campo.put("UUIdOt", parte.getGuidparte()); if (parte.getMail() !=
		 * null) { campo.put("Valor", parte.getMail()); } else {
		 * campo.put("Valor", JSONObject.NULL); } campos.put(campo);
		 * 
		 * campo = new JSONObject(); campo.put("IdCampo", "DEPAR");
		 * campo.put("UUIdOt", parte.getGuidparte()); if
		 * (parte.getDepartamento() != null) { campo.put("Valor",
		 * parte.getDepartamento().getEdepar() + " / " +
		 * parte.getDepartamento().getCdepar()); } else { campo.put("Valor",
		 * JSONObject.NULL); } campos.put(campo);
		 * 
		 * campo = new JSONObject(); campo.put("IdCampo", "DIR");
		 * campo.put("UUIdOt", parte.getGuidparte()); if (parte.getDireccion()
		 * != null) { campo.put("Valor", parte.getDireccion().getEdir() + " / "
		 * + parte.getDireccion().getCdir()); } else { campo.put("Valor",
		 * JSONObject.NULL); } campos.put(campo);
		 * 
		 * campo = new JSONObject(); campo.put("IdCampo", "IDZONA");
		 * campo.put("UUIdOt", parte.getGuidparte()); if (parte.getZona() !=
		 * null) { campo.put("Valor", parte.getIdzona() + " - " +
		 * parte.getZona().getEzona() + " / " + parte.getZona().getCzona()); }
		 * else { campo.put("Valor", JSONObject.NULL); } campos.put(campo);
		 * 
		 * campo = new JSONObject(); campo.put("IdCampo", "IDPLANTA");
		 * campo.put("UUIdOt", parte.getGuidparte()); if (parte.getPlanta() !=
		 * null) { campo.put("Valor", parte.getIdplanta() + " - " +
		 * parte.getPlanta().getEplanta() + " / " +
		 * parte.getPlanta().getCplanta()); } else { campo.put("Valor",
		 * JSONObject.NULL); } campos.put(campo);
		 * 
		 * campo = new JSONObject(); campo.put("IdCampo", "IDESTANCIA");
		 * campo.put("UUIdOt", parte.getGuidparte()); if (parte.getEspacio() !=
		 * null) { campo.put("Valor", parte.getEspacio().getEespacio() + " / " +
		 * parte.getEspacio().getCespacio()); } else { campo.put("Valor",
		 * JSONObject.NULL); } campos.put(campo);
		 * 
		 * campo = new JSONObject(); campo.put("IdCampo", "IDCLASE");
		 * campo.put("UUIdOt", parte.getGuidparte()); if (parte.getIdclase() !=
		 * null) { campo.put("Valor", parte.getIdclase()); } else {
		 * campo.put("Valor", JSONObject.NULL); } campos.put(campo);
		 * 
		 * campo = new JSONObject(); campo.put("IdCampo", "IDCODIGO");
		 * campo.put("UUIdOt", parte.getGuidparte()); if (parte.getIdcodigo() !=
		 * null) { campo.put("Valor", parte.getIdcodigo()); } else {
		 * campo.put("Valor", JSONObject.NULL); } campos.put(campo);
		 */

		boolean eliminarOtHija = false;
		JSONArray otsLimpiar = new JSONArray();
		// Por cada tecnico asignado creamos una OT hija
		if (tecnicosParteGmao != null) {
			for (Partetecnicosgmao parteTecnicoGmao : tecnicosParteGmao) {
				String UUIdOtHija = "";
				if (parteTecnicoGmao.getGuidpartetecgmao() != null) {
					UUIdOtHija = parteTecnicoGmao.getGuidpartetecgmao();
				}

				// Si el idParteTecnico no es nulo ni 0, significa que
				// ha añadido el técnico
				if (parteTecnicoGmao.getIdpartec() != null
						&& parteTecnicoGmao.getIdpartec() != 0) {

					respuestaFichero = "";
					respuestaPDF = "";

					if (plano != null && plano.length != 0) {
						respuestaFichero = subirFicheroMovilGmao(
								UUIdOtHija,
								"plano"
										+ parteTecnicoGmao.getIdpartec()
												.toString() + ".jpeg",
								plano,
								urlConfig
										+ "SincronizacionFicheros/index.php/sync/sincronizarFicheros/SubirFichero/",
								"image/jpeg");
					}

					if (pdf != null && pdf.length != 0) {
						respuestaPDF = subirFicheroMovilGmao(
								UUIdOtHija,
								"pdf"
										+ parteTecnicoGmao.getIdpartec()
												.toString() + ".pdf",
								pdf,
								urlConfig
										+ "SincronizacionFicheros/index.php/sync/sincronizarFicheros/SubirFichero/",
								"application/pdf");
					}

					ot = new JSONObject();
					ot.put("NROT",
							Aa20bConstantes.COD_PARTE_GMAO_CORRECTIVO + "_"
									+ parte.getIdparte() + "_"
									+ parteTecnicoGmao.getIdtecnico());
					if (parte.getObserv() != null) {
						ot.put("DescCorta", parte.getObserv());
					} else {
						ot.put("DescCorta", JSONObject.NULL);
					}
					// Si el parte no es urgente, la marcamos por defecto como
					// aceptada
					ot.put("IdEstado", Aa20bConstantes.COD_ESTADO_GMAO_ASIGNADO);
					if (parte.getUrgente() != null
							&& parte.getUrgente().equals("1")) {
						ot.put("IdPrioridad", parte.getUrgente());
						ot.put("Aceptada", JSONObject.NULL);
					} else {
						ot.put("IdPrioridad", "0");
						ot.put("Aceptada", "1");
					}
					ot.put("IdTipo", "1");
					ot.put("IdOperarioCoordinador", JSONObject.NULL);
					ot.put("IdOperarioResponsable",
							parteTecnicoGmao.getIdtecnico());

					if (parte.getObserv() != null) {
						ot.put("DescLarga", parte.getObserv());
					} else {
						ot.put("DescLarga", JSONObject.NULL);
					}
					if (parte.getFechare() != null) {
						ot.put("FechaSolicitud", parte.getFechare());
					} else {
						ot.put("FechaSolicitud", JSONObject.NULL);
					}
					if (parte.getFechaplanif() != null) {
						ot.put("FechaPlanificacion", parte.getFechaplanif());
					} else {
						ot.put("FechaPlanificacion", fechaActualJson);
					}

					ot.put("FechaCierre", JSONObject.NULL);
					ot.put("Direccion", JSONObject.NULL);
					ot.put("CodigoPostal", JSONObject.NULL);
					ot.put("Poblacion", JSONObject.NULL);
					ot.put("Provincia", JSONObject.NULL);
					ot.put("UUIdOt", UUIdOtHija);
					ot.put("UUIdActivo", UUIdActivo);
					/*
					 * if (parte.getAveriaRepe() != null &&
					 * parte.getAveriaRepe() != 0) { String guidPartePadre =
					 * obtenerGuidPartePadreAveriaRepe(parte .getAveriaRepe());
					 * if (!guidPartePadre.equals("")) { ot.put("UUIdOtPadre",
					 * guidPartePadre); } else { ot.put("UUIdOtPadre",
					 * JSONObject.NULL); } } else { ot.put("UUIdOtPadre",
					 * JSONObject.NULL); }
					 */
					if (parteTecnicoGmao.getGuidpartepadreayuda() != null
							&& !parteTecnicoGmao.getGuidpartepadreayuda()
									.equals("")) {
						ot.put("UUIdOtPadre",
								"{" + parteTecnicoGmao.getGuidpartepadreayuda()
										+ "}");
					} else {
						ot.put("UUIdOtPadre", JSONObject.NULL);
					}
					if (parteTecnicoGmao.getGuidparteseguido() != null
							&& !parteTecnicoGmao.getGuidparteseguido().equals(
									"")) {
						ot.put("UUIdOtSeguida",
								"{" + parteTecnicoGmao.getGuidparteseguido()
										+ "}");
					} else {
						ot.put("UUIdOtSeguida", JSONObject.NULL);
					}
					ots.put(ot);

					operario = new JSONObject();
					operario.put("IdOperario", parteTecnicoGmao.getIdtecnico());
					operario.put("UUIdOt", UUIdOtHija);
					operarios.put(operario);

				} else {

					/**
					 * Creación del parte en movilgmao sin técnico asignado
					 */
					respuestaFichero = "";
					respuestaPDF = "";

					if (plano != null && plano.length != 0) {
						respuestaFichero = subirFicheroMovilGmao(
								UUIdOtHija,
								"plano" + parte.getIdparte().toString()
										+ ".jpeg",
								plano,
								urlConfig
										+ "SincronizacionFicheros/index.php/sync/sincronizarFicheros/SubirFichero/",
								"image/jpeg");
					}

					if (pdf != null && pdf.length != 0) {
						respuestaPDF = subirFicheroMovilGmao(
								UUIdOtHija,
								"pdf"
										+ parteTecnicoGmao.getIdpartec()
												.toString() + ".pdf",
								pdf,
								urlConfig
										+ "SincronizacionFicheros/index.php/sync/sincronizarFicheros/SubirFichero/",
								"application/pdf");
					}

					ot = new JSONObject();
					ot.put("NROT", Aa20bConstantes.COD_PARTE_GMAO_CORRECTIVO
							+ "_" + parte.getIdparte() + "_0");
					if (parte.getObserv() != null) {
						ot.put("DescCorta", parte.getObserv());
					} else {
						ot.put("DescCorta", JSONObject.NULL);
					}
					// Si el parte no es urgente, la marcamos por defecto como
					// aceptada
					ot.put("IdEstado", Aa20bConstantes.COD_ESTADO_GMAO_ASIGNADO);
					if (parte.getUrgente() != null
							&& parte.getUrgente().equals("1")) {
						ot.put("IdPrioridad", parte.getUrgente());
						ot.put("Aceptada", JSONObject.NULL);
					} else {
						ot.put("IdPrioridad", "0");
						ot.put("Aceptada", "1");
					}
					ot.put("IdTipo", "1");
					ot.put("IdOperarioCoordinador", JSONObject.NULL);
					ot.put("IdOperarioResponsable", JSONObject.NULL);

					if (parte.getObserv() != null) {
						ot.put("DescLarga", parte.getObserv());
					} else {
						ot.put("DescLarga", JSONObject.NULL);
					}
					if (parte.getFechare() != null) {
						ot.put("FechaSolicitud", parte.getFechare());

					} else {
						ot.put("FechaSolicitud", JSONObject.NULL);
					}
					if (parte.getFechaplanif() != null) {
						ot.put("FechaPlanificacion", parte.getFechaplanif());
					} else {
						ot.put("FechaPlanificacion", fechaActualJson);
					}

					ot.put("FechaCierre", JSONObject.NULL);
					ot.put("Direccion", JSONObject.NULL);
					ot.put("CodigoPostal", JSONObject.NULL);
					ot.put("Poblacion", JSONObject.NULL);
					ot.put("Provincia", JSONObject.NULL);
					ot.put("UUIdOt", UUIdOtHija);
					ot.put("UUIdActivo", UUIdActivo);
					/*
					 * if (parte.getAveriaRepe() != null &&
					 * parte.getAveriaRepe() != 0) { String guidPartePadre =
					 * obtenerGuidPartePadreAveriaRepe(parte .getAveriaRepe());
					 * if (!guidPartePadre.equals("")) { ot.put("UUIdOtPadre",
					 * guidPartePadre); } else { ot.put("UUIdOtPadre",
					 * JSONObject.NULL); } } else { ot.put("UUIdOtPadre",
					 * JSONObject.NULL); }
					 */
					if (parteTecnicoGmao.getGuidpartepadreayuda() != null
							&& !parteTecnicoGmao.getGuidpartepadreayuda()
									.equals("")) {
						ot.put("UUIdOtPadre",
								"{" + parteTecnicoGmao.getGuidpartepadreayuda()
										+ "}");
					} else {
						ot.put("UUIdOtPadre", JSONObject.NULL);
					}
					if (parteTecnicoGmao.getGuidparteseguido() != null
							&& !parteTecnicoGmao.getGuidparteseguido().equals(
									"")) {
						ot.put("UUIdOtSeguida",
								"{" + parteTecnicoGmao.getGuidparteseguido()
										+ "}");
					} else {
						ot.put("UUIdOtSeguida", JSONObject.NULL);
					}
					ots.put(ot);

					operario = new JSONObject();
					operario.put("IdOperario", JSONObject.NULL);
					operario.put("UUIdOt", UUIdOtHija);
					operarios.put(operario);

					/**
					 * MIRAR SI ES MEJOR BORRAR LA OT EN ESTE MOMENTO
					 */

					// Si el idParteTecnico es nulo o 0, significa que
					// ha quitado al técnico del parte
					// ot = new JSONObject();
					// ot.put("NROT", Aa20bConstantes.COD_PARTE_GMAO_CORRECTIVO
					// + "_" + parte.getIdparte() + "_");
					// if (parte.getObserv() != null) {
					// ot.put("DescCorta", parte.getObserv());
					// } else {
					// ot.put("DescCorta", JSONObject.NULL);
					// }
					// ot.put("IdEstado",
					// Aa20bConstantes.COD_ESTADO_GMAO_ASIGNADO);
					// ot.put("IdPrioridad", parte.getUrgente());
					// ot.put("IdTipo", "1");
					// ot.put("IdOperarioCoordinador", JSONObject.NULL);
					// ot.put("IdOperarioResponsable", JSONObject.NULL);
					//
					// ot.put("Aceptada", JSONObject.NULL);
					// if (parte.getObserv() != null) {
					// ot.put("DescLarga", parte.getObserv());
					// } else {
					// ot.put("DescLarga", JSONObject.NULL);
					// }
					// if (parte.getFechare() != null) {
					// ot.put("FechaSolicitud", parte.getFechare());
					// } else {
					// ot.put("FechaSolicitud", JSONObject.NULL);
					// }
					// ot.put("FechaPlanificacion", fechaActualJson);
					// ot.put("FechaCierre", JSONObject.NULL);
					// ot.put("Direccion", JSONObject.NULL);
					// ot.put("CodigoPostal", JSONObject.NULL);
					// ot.put("Poblacion", JSONObject.NULL);
					// ot.put("Provincia", JSONObject.NULL);
					// ot.put("UUIdOt", UUIdOtHija);
					// ot.put("UUIdActivo", UUIdActivo);
					// ot.put("UUIdOtPadre", JSONObject.NULL);
					// ots.put(ot);
					//
					// JSONObject otLimpiar = new JSONObject();
					// otLimpiar.put("UUIdOt", UUIdOtHija);
					// otsLimpiar.put(otLimpiar);
					//
					// eliminarOtHija = true;
				}

				/*
				 * for (Partetecnicosgmao parteTecnicoSubGmao :
				 * tecnicosParteGmao) { if (parteTecnicoSubGmao.getIdpartec() !=
				 * null && parteTecnicoSubGmao.getIdpartec() != 0) { operario =
				 * new JSONObject(); if (parteTecnicoSubGmao.getIdtecnico() ==
				 * 137) { operario.put("IdOperario", "Victor"); } else {
				 * operario.put("IdOperario",
				 * parteTecnicoSubGmao.getIdtecnico()); } operario.put("UUIdOt",
				 * UUIdOtHija); operarios.put(operario); } }
				 */

				if (respuestaFichero != null && !respuestaFichero.equals("")) {
					documento = new JSONObject();
					documento.put("DescDocumento", "Plano");
					documento.put("RutaRelativa", JSONObject.NULL);
					documento.put("UUIdOtDocumento",
							parteTecnicoGmao.getGuidplanopartegmao());
					documento.put("UUIdOt", UUIdOtHija);
					documento.put("RutaServidor", respuestaFichero);
					documento.put("FechaServidor", JSONObject.NULL);
					documentos.put(documento);
				}
				if (respuestaPDF != null && !respuestaPDF.equals("")) {
					documento = new JSONObject();
					documento.put("DescDocumento", "PDF");
					documento.put("RutaRelativa", JSONObject.NULL);
					documento.put("UUIdOtDocumento",
							parteTecnicoGmao.getGuidpdfpartegmao());
					documento.put("UUIdOt", UUIdOtHija);
					documento.put("RutaServidor", respuestaPDF);
					documento.put("FechaServidor", JSONObject.NULL);
					documentos.put(documento);
				}

				campo = new JSONObject();
				campo.put("IdCampo", "NOMBRE");
				campo.put("UUIdOt", UUIdOtHija);
				if (parte.getNombre() != null) {
					campo.put("Valor", parte.getNombre());
				} else {
					campo.put("Valor", JSONObject.NULL);
				}
				campos.put(campo);

				campo = new JSONObject();
				campo.put("IdCampo", "TELEFONO");
				campo.put("UUIdOt", UUIdOtHija);
				if (parte.getTelefo() != null) {
					campo.put("Valor", parte.getTelefo());
				} else {
					campo.put("Valor", JSONObject.NULL);
				}
				campos.put(campo);

				campo = new JSONObject();
				campo.put("IdCampo", "MAIL");
				campo.put("UUIdOt", UUIdOtHija);
				if (parte.getMail() != null) {
					campo.put("Valor", parte.getMail());
				} else {
					campo.put("Valor", JSONObject.NULL);
				}
				campos.put(campo);

				campo = new JSONObject();
				campo.put("IdCampo", "DEPARAUX");
				campo.put("UUIdOt", UUIdOtHija);
				campo.put("Valor", "0");
				campos.put(campo);

				campo = new JSONObject();
				campo.put("IdCampo", "DEPAR");
				campo.put("UUIdOt", UUIdOtHija);
				if (parte.getDepartamento() != null
						&& parte.getDepartamento().getIddepar() != null) {
					campo.put("Valor", parte.getDepartamento().getIddepar());
				} else {
					campo.put("Valor", JSONObject.NULL);
				}
				campos.put(campo);

				campo = new JSONObject();
				campo.put("IdCampo", "DIR");
				campo.put("UUIdOt", UUIdOtHija);
				if (parte.getDireccion() != null
						&& parte.getDireccion().getIddir() != null) {
					campo.put("Valor", parte.getDireccion().getIddir());
				} else {
					campo.put("Valor", JSONObject.NULL);
				}
				campos.put(campo);

				campo = new JSONObject();
				campo.put("IdCampo", "IDZONAEDIF");
				campo.put("UUIdOt", UUIdOtHija);
				if (parte.getZona() != null
						&& parte.getZona().getIdzona() != null) {
					/*
					 * campo.put("Valor", parte.getIdzona() + " - " +
					 * parte.getZona().getEzona() + " / " +
					 * parte.getZona().getCzona());
					 */
					campo.put("Valor",
							"{" + UUIdActivo + "}" + "_" + parte.getIdzona());
				} else {
					campo.put("Valor", JSONObject.NULL);
				}
				campos.put(campo);

				campo = new JSONObject();
				campo.put("IdCampo", "IDPLANTA");
				campo.put("UUIdOt", UUIdOtHija);
				if (parte.getPlanta() != null
						&& parte.getPlanta().getIdplanta() != null) {
					/*
					 * campo.put("Valor", parte.getIdplanta() + " - " +
					 * parte.getPlanta().getEplanta() + " / " +
					 * parte.getPlanta().getCplanta());
					 */
					campo.put("Valor",
							"{" + UUIdActivo + "}" + "_" + parte.getIdzona()
									+ "_" + parte.getIdplanta());
				} else {
					campo.put("Valor", JSONObject.NULL);
				}
				campos.put(campo);

				campo = new JSONObject();
				campo.put("IdCampo", "IDESTANCIA");
				campo.put("UUIdOt", UUIdOtHija);
				if (parte.getEspacio() != null
						&& parte.getEspacio().getIdespacio() != null) {
					campo.put("Valor", parte.getEspacio().getIdespacio());
				} else {
					campo.put("Valor", JSONObject.NULL);
				}
				campos.put(campo);

				campo = new JSONObject();
				campo.put("IdCampo", "IDCLASE");
				campo.put("UUIdOt", UUIdOtHija);
				if (parte.getIdclase() != null) {
					campo.put("Valor", parte.getIdclase());
				} else {
					campo.put("Valor", JSONObject.NULL);
				}
				campos.put(campo);

				campo = new JSONObject();
				campo.put("IdCampo", "IDCODIGO");
				campo.put("UUIdOt", UUIdOtHija);
				if (parte.getIdcodigo() != null) {
					campo.put("Valor", parte.getIdcodigo());
				} else {
					campo.put("Valor", JSONObject.NULL);
				}
				campos.put(campo);

				campo = new JSONObject();
				campo.put("IdCampo", "NOTASTEC");
				campo.put("UUIdOt", UUIdOtHija);
				campo.put("Valor", JSONObject.NULL);
				campos.put(campo);

			}
		}
		datosJson.put("ots", ots);
		if (operarios.length() > 0) {
			datosJson.put("operarios", operarios);
		} else {
			datosJson.put("operarios", JSONObject.NULL);
		}
		if (documentos.length() > 0) {
			datosJson.put("documentos", documentos);
		} else {
			datosJson.put("documentos", JSONObject.NULL);
		}
		datosJson.put("campos", campos);
		if (otmods.length() > 0) {
			datosJson.put("otmod", otmods);
		}

		respuesta = this.sincronizarGmao(datosJson, urlConfig
				+ "Expertis_Sync_Movil_JS/index.php/sync/masters/SubirOTs/");

		/**
		 * MIRAR SI ES MEJOR BORRAR LA OT EN ESTE MOMENTO
		 */
		String respuestaLimpiar = "";
		if (eliminarOtHija) {
			JSONObject datosJsonLimpiarOt = new JSONObject();
			datosJsonLimpiarOt.put("ots", otsLimpiar);
			respuestaLimpiar = this
					.sincronizarGmao(
							datosJsonLimpiarOt,
							urlConfig
									+ "Expertis_Sync_Movil_JS/index.php/sync/masters/EliminarOTs/");
			System.out.println("Borrada OT " + respuestaLimpiar);
		}

		return respuesta;
	}

	@Override
	public String sincronizarPartePreventivoGmao(Ficha ficha, Maquinas maquina,
			List<Fichatecnicosgmao> tecnicosFichaGmao,
			List<Actuacion> listaActuaciones, String UUIdActivo,
			String urlConfig) {
		// TODO Auto-generated method stub
		String respuesta = "";
		// String respuestaFichero = "";

		DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

		JSONObject datosJson = new JSONObject();
		JSONArray ots = new JSONArray();
		JSONObject ot = new JSONObject();
		JSONArray operarios = new JSONArray();
		JSONObject operario = new JSONObject();
		JSONArray documentos = new JSONArray();
		// JSONObject documento = new JSONObject();
		JSONArray revisiones = new JSONArray();
		JSONObject revision = new JSONObject();
		JSONArray campos = new JSONArray();
		JSONObject campo = new JSONObject();
		JSONArray otmods = new JSONArray();
		JSONObject otmod = new JSONObject();

		java.util.Date fechaActual = new Date();
		String fechaActualJson = df.format(fechaActual);

		// Creacion OT padre o ppal
		/*
		 * ot.put("NROT", Aa20bConstantes.COD_PARTE_GMAO_PREVENTIVO + "_" +
		 * ficha.getIdficha()); if (ficha.getDescripcion() != null) {
		 * ot.put("DescCorta", ficha.getDescripcion()); } else {
		 * ot.put("DescCorta", JSONObject.NULL); } // Se comprueba si el parte
		 * está finalizado if (ficha.getEjecutado() != null &&
		 * ficha.getEjecutado() != null && ficha.getEjecutado().equals("1")) {
		 * ot.put("IdEstado", Aa20bConstantes.COD_ESTADO_GMAO_TERMINADO); } else
		 * { ot.put("IdEstado", Aa20bConstantes.COD_ESTADO_GMAO_ASIGNADO); }
		 * ot.put("IdPrioridad", Aa20bConstantes.PRIORIDAD_GMAO_NORMAL);
		 * ot.put("IdTipo", Aa20bConstantes.TIPO_OT_GMAO_PREVENTIVA);
		 * ot.put("IdOperarioCoordinador", JSONObject.NULL);
		 * ot.put("IdOperarioResponsable", JSONObject.NULL); ot.put("Aceptada",
		 * JSONObject.NULL); if (ficha.getObservaciones() != null) {
		 * ot.put("DescLarga", ficha.getObservaciones()); } else {
		 * ot.put("DescLarga", JSONObject.NULL); } if (ficha.getFeejec() !=
		 * null) { ot.put("FechaSolicitud", ficha.getFeejec());
		 * ot.put("FechaPlanificacion", ficha.getFeejec()); } else {
		 * ot.put("FechaSolicitud", JSONObject.NULL);
		 * ot.put("FechaPlanificacion", JSONObject.NULL); }
		 * 
		 * ot.put("FechaCierre", JSONObject.NULL); ot.put("Direccion",
		 * JSONObject.NULL); ot.put("CodigoPostal", JSONObject.NULL);
		 * ot.put("Poblacion", JSONObject.NULL); ot.put("Provincia",
		 * JSONObject.NULL); ot.put("UUIdOt", ficha.getGuidficha());
		 * ot.put("UUIdActivo", UUIdActivo); ots.put(ot); if (tecnicosFichaGmao
		 * != null) { for (Fichatecnicosgmao fichaTecnicoGmao :
		 * tecnicosFichaGmao) { if (fichaTecnicoGmao.getIdfichac() != null &&
		 * fichaTecnicoGmao.getIdfichac() != 0) { operario = new JSONObject();
		 * operario.put("IdOperario", fichaTecnicoGmao.getIdtecnico());
		 * operario.put("UUIdOt", ficha.getGuidficha());
		 * operarios.put(operario); } } }
		 */

		Integer idClase = null;
		Gamas gamaAux = new Gamas();
		Clase claseAux = new Clase();
		if (maquina.getIdgama() != null) {

			gamaAux = this.gamasDao.obtenerGama(maquina.getIdgama().toString());
			idClase = gamaAux.getIdclase();
			if (idClase != null) {
				claseAux.setIdclase(idClase);
				claseAux = this.claseDao.find(claseAux);
			}
		}

		/*
		 * if (listaActuaciones != null && listaActuaciones.size() > 0) {
		 * 
		 * for (Actuacion actuacion : listaActuaciones) { if (actuacion != null)
		 * { if (actuacion.getIdcuestionario() != null) {
		 * 
		 * Cuestionario cuestionarioAux = new Cuestionario();
		 * cuestionarioAux.setIdcuestionario(actuacion .getIdcuestionario());
		 * cuestionarioAux = this.cuestionarioDao .find(cuestionarioAux);
		 * 
		 * revision = new JSONObject(); revision.put("IdPunto",
		 * cuestionarioAux.getIdcuestionario()); if (maquina.getCmaquina() !=
		 * null) { revision.put("DescPunto", cuestionarioAux.getOperacion()); }
		 * else { revision.put("DescPunto", "-"); } revision.put("Tipo", "6");
		 * revision.put("Valor", JSONObject.NULL); revision.put("UUIdOt",
		 * ficha.getGuidficha()); revision.put("UUIdActivoRevisable",
		 * UUIdActivo); if (claseAux.getCclase() != null) {
		 * revision.put("Agrupador", claseAux.getCclase()); } else {
		 * revision.put("Agrupador", "General"); } revision.put("IdEnumerado",
		 * "E" + gamaAux.getIdclase()); revisiones.put(revision);
		 * 
		 * revision = new JSONObject(); revision.put("IdPunto",
		 * cuestionarioAux.getIdcuestionario() + "txt");
		 * revision.put("DescPunto", "Oharrak / Observaciones:");
		 * revision.put("Tipo", "3"); revision.put("Valor", JSONObject.NULL);
		 * revision.put("UUIdOt", ficha.getGuidficha());
		 * revision.put("UUIdActivoRevisable", UUIdActivo); if
		 * (claseAux.getCclase() != null) { revision.put("Agrupador",
		 * claseAux.getCclase()); } else { revision.put("Agrupador", "General");
		 * } revisiones.put(revision); }
		 * 
		 * } }
		 * 
		 * }
		 */

		/*
		 * campo = new JSONObject(); campo.put("IdCampo", "IDZONA");
		 * campo.put("UUIdOt", ficha.getGuidficha());
		 * 
		 * if (maquina.getZona() != null) { campo.put("Valor",
		 * maquina.getIdzona() + " - " + maquina.getZona().getEzona() + " / " +
		 * maquina.getZona().getCzona()); } else { campo.put("Valor",
		 * JSONObject.NULL); }
		 */

		/*
		 * if (maquina.getZona() != null) { campo.put("Valor",
		 * maquina.getZona().getIdzona()); } else { campo.put("Valor",
		 * JSONObject.NULL); }
		 */
		/*
		 * campos.put(campo);
		 * 
		 * campo = new JSONObject();
		 * 
		 * campo.put("IdCampo", "IDPLANTA"); campo.put("UUIdOt",
		 * ficha.getGuidficha()); if (maquina.getPlanta() != null) {
		 * campo.put("Valor", maquina.getIdplanta() + " - " +
		 * maquina.getPlanta().getEplanta() + " / " +
		 * maquina.getPlanta().getCplanta()); } else { campo.put("Valor",
		 * JSONObject.NULL); }
		 */

		/*
		 * campo.put("IdCampo", "IDPLANTA"); campo.put("UUIdOt",
		 * ficha.getGuidficha()); if (maquina.getPlanta() != null) {
		 * campo.put("Valor", maquina.getPlanta().getIdplanta()); } else {
		 * campo.put("Valor", JSONObject.NULL); }
		 */
		/*
		 * campos.put(campo);
		 * 
		 * campo = new JSONObject(); campo.put("IdCampo", "IDCLASE");
		 * campo.put("UUIdOt", ficha.getGuidficha()); if (idClase != null) {
		 * campo.put("Valor", idClase); } else { campo.put("Valor",
		 * JSONObject.NULL); } campos.put(campo);
		 * 
		 * campo = new JSONObject(); campo.put("IdCampo", "IDGAMA");
		 * campo.put("UUIdOt", ficha.getGuidficha()); if (maquina.getIdgama() !=
		 * null) { campo.put("Valor", maquina.getIdgama()); } else {
		 * campo.put("Valor", JSONObject.NULL); } campos.put(campo);
		 * 
		 * campo = new JSONObject(); campo.put("IdCampo", "IDMAQUINA");
		 * campo.put("UUIdOt", ficha.getGuidficha()); if (maquina.getIdmaquina()
		 * != null) { campo.put("Valor", maquina.getIdmaquina() + " - " +
		 * maquina.getEmaquina() + " / " + maquina.getCmaquina()); } else {
		 * campo.put("Valor", JSONObject.NULL); } campos.put(campo);
		 */

		boolean eliminarOtHija = false;
		JSONArray otsLimpiar = new JSONArray();
		// Por cada tecnico asignado creamos una OT hija
		if (tecnicosFichaGmao != null) {
			for (Fichatecnicosgmao fichaTecnicoGmao : tecnicosFichaGmao) {
				String UUIdOtHija = "";
				if (fichaTecnicoGmao.getGuidfichatecgmao() != null) {
					UUIdOtHija = fichaTecnicoGmao.getGuidfichatecgmao();
				}

				// Si el idParteTecnico no es nulo ni 0, significa que
				// ha añadido el técnico
				if (fichaTecnicoGmao.getIdfichac() != null
						&& fichaTecnicoGmao.getIdfichac() != 0) {

					ot = new JSONObject();
					ot.put("NROT",
							Aa20bConstantes.COD_PARTE_GMAO_PREVENTIVO + "_"
									+ ficha.getIdficha() + "_"
									+ fichaTecnicoGmao.getIdtecnico());
					if (ficha.getObservaciones() != null) {
						ot.put("DescCorta", ficha.getObservaciones());
						ot.put("DescLarga", ficha.getObservaciones());
					} else {
						ot.put("DescCorta", JSONObject.NULL);
						ot.put("DescLarga", JSONObject.NULL);
					}
					ot.put("IdEstado", Aa20bConstantes.COD_ESTADO_GMAO_ASIGNADO);
					ot.put("IdPrioridad", Aa20bConstantes.PRIORIDAD_GMAO_NORMAL);
					ot.put("IdTipo", Aa20bConstantes.TIPO_OT_GMAO_PREVENTIVA);
					ot.put("IdOperarioCoordinador", JSONObject.NULL);
					ot.put("IdOperarioResponsable",
							fichaTecnicoGmao.getIdtecnico());
					// Los partes preventivos por defecto se mandan aceptados
					ot.put("Aceptada", "1");
					if (ficha.getFeejec() != null) {
						ot.put("FechaSolicitud", ficha.getFeejec());
						ot.put("FechaPlanificacion", ficha.getFeejec());
					} else {
						ot.put("FechaSolicitud", JSONObject.NULL);
						if (ficha.getFechaplanif() != null) {
							ot.put("FechaPlanificacion", ficha.getFechaplanif());
						} else {
							ot.put("FechaPlanificacion", fechaActualJson);
						}
					}

					ot.put("FechaCierre", JSONObject.NULL);
					ot.put("Direccion", JSONObject.NULL);
					ot.put("CodigoPostal", JSONObject.NULL);
					ot.put("Poblacion", JSONObject.NULL);
					ot.put("Provincia", JSONObject.NULL);
					ot.put("UUIdOt", UUIdOtHija);
					ot.put("UUIdActivo", UUIdActivo);
					if (fichaTecnicoGmao.getGuidpartepadreayuda() != null
							&& !fichaTecnicoGmao.getGuidpartepadreayuda()
									.equals("")) {
						ot.put("UUIdOtPadre",
								"{" + fichaTecnicoGmao.getGuidpartepadreayuda()
										+ "}");
					} else {
						ot.put("UUIdOtPadre", JSONObject.NULL);
					}
					if (fichaTecnicoGmao.getGuidparteseguido() != null
							&& !fichaTecnicoGmao.getGuidparteseguido().equals(
									"")) {
						ot.put("UUIdOtSeguida",
								"{" + fichaTecnicoGmao.getGuidparteseguido()
										+ "}");
					} else {
						ot.put("UUIdOtSeguida", JSONObject.NULL);
					}
					ots.put(ot);

					operario = new JSONObject();
					operario.put("IdOperario", fichaTecnicoGmao.getIdtecnico());
					operario.put("UUIdOt", UUIdOtHija);
					operarios.put(operario);

					/**
					 * Comprobamos si tiene ejecuciones para subirlas a
					 * movilgmao
					 */
					Fichaejecucion parteEjecucionAux = new Fichaejecucion();
					parteEjecucionAux.setIdficeje(fichaTecnicoGmao
							.getIdfichac());
					List<Fichaejecucion> fichasEjecucionTecnico = this.fichaejecucionDao
							.findAll(parteEjecucionAux, null);

					for (Fichaejecucion fichaejec : fichasEjecucionTecnico) {
						if (fichaejec != null && fichaejec.getFeini() != null
								&& fichaejec.getFefin() != null) {
							otmod = new JSONObject();
							otmod.put("IdOperario",
									fichaTecnicoGmao.getIdtecnico());
							otmod.put("IdHora", "HN");
							otmod.put("Fecha", JSONObject.NULL);
							otmod.put("QReal", JSONObject.NULL);
							otmod.put("QVenta", JSONObject.NULL);
							String randomUUIDString = "";
							UUID uuid = UUID.randomUUID();
							randomUUIDString = uuid.toString();
							otmod.put("UUIdOtMod", randomUUIDString);
							String fechaInicioModJson = df.format(fichaejec
									.getFeini());
							String fechaFinModJson = df.format(fichaejec
									.getFefin());
							otmod.put("HoraInicio", fechaInicioModJson);
							otmod.put("HoraFin", fechaFinModJson);
							otmods.put(otmod);
						}
					}

				} else {

					/**
					 * Parte preventivo creado sin técnico
					 */
					ot = new JSONObject();
					ot.put("NROT", Aa20bConstantes.COD_PARTE_GMAO_PREVENTIVO
							+ "_" + ficha.getIdficha() + "_0");
					if (ficha.getObservaciones() != null) {
						ot.put("DescCorta", ficha.getObservaciones());
						ot.put("DescLarga", ficha.getObservaciones());
					} else {
						ot.put("DescCorta", JSONObject.NULL);
						ot.put("DescLarga", JSONObject.NULL);
					}
					ot.put("IdEstado", Aa20bConstantes.COD_ESTADO_GMAO_ASIGNADO);
					ot.put("IdPrioridad", Aa20bConstantes.PRIORIDAD_GMAO_NORMAL);
					ot.put("IdTipo", Aa20bConstantes.TIPO_OT_GMAO_PREVENTIVA);
					ot.put("IdOperarioCoordinador", JSONObject.NULL);
					ot.put("IdOperarioResponsable", JSONObject.NULL);
					// Los partes preventivos por defecto se mandan aceptados
					ot.put("Aceptada", "1");
					if (ficha.getFeejec() != null) {
						ot.put("FechaSolicitud", ficha.getFeejec());
						ot.put("FechaPlanificacion", ficha.getFeejec());
					} else {
						ot.put("FechaSolicitud", JSONObject.NULL);
						if (ficha.getFechaplanif() != null) {
							ot.put("FechaPlanificacion", ficha.getFechaplanif());
						} else {
							ot.put("FechaPlanificacion", fechaActualJson);
						}
					}
					ot.put("FechaCierre", JSONObject.NULL);
					ot.put("Direccion", JSONObject.NULL);
					ot.put("CodigoPostal", JSONObject.NULL);
					ot.put("Poblacion", JSONObject.NULL);
					ot.put("Provincia", JSONObject.NULL);
					ot.put("UUIdOt", UUIdOtHija);
					ot.put("UUIdActivo", UUIdActivo);
					if (fichaTecnicoGmao.getGuidpartepadreayuda() != null
							&& !fichaTecnicoGmao.getGuidpartepadreayuda()
									.equals("")) {
						ot.put("UUIdOtPadre",
								"{" + fichaTecnicoGmao.getGuidpartepadreayuda()
										+ "}");
					} else {
						ot.put("UUIdOtPadre", JSONObject.NULL);
					}
					if (fichaTecnicoGmao.getGuidparteseguido() != null
							&& !fichaTecnicoGmao.getGuidparteseguido().equals(
									"")) {
						ot.put("UUIdOtSeguida",
								"{" + fichaTecnicoGmao.getGuidparteseguido()
										+ "}");
					} else {
						ot.put("UUIdOtSeguida", JSONObject.NULL);
					}
					ots.put(ot);

					operario = new JSONObject();
					operario.put("IdOperario", JSONObject.NULL);
					operario.put("UUIdOt", UUIdOtHija);
					operarios.put(operario);

					/**
					 * MIRAR SI ES MEJOR BORRAR LA OT EN ESTE MOMENTO
					 */

					// Si el idParteTecnico es nulo o 0, significa que
					// ha quitado al técnico del parte
					// ot = new JSONObject();
					// ot.put("NROT", Aa20bConstantes.COD_PARTE_GMAO_PREVENTIVO
					// + "_" + ficha.getIdficha() + "_");
					// if (ficha.getObservaciones() != null) {
					// ot.put("DescCorta", ficha.getObservaciones());
					// ot.put("DescLarga", ficha.getObservaciones());
					// } else {
					// ot.put("DescCorta", ficha.getObservaciones());
					// ot.put("DescLarga", JSONObject.NULL);
					// }
					// ot.put("IdEstado",
					// Aa20bConstantes.COD_ESTADO_GMAO_ASIGNADO);
					// ot.put("IdPrioridad",
					// Aa20bConstantes.PRIORIDAD_GMAO_NORMAL);
					// ot.put("IdTipo",
					// Aa20bConstantes.TIPO_OT_GMAO_PREVENTIVA);
					// ot.put("IdOperarioCoordinador", JSONObject.NULL);
					// ot.put("IdOperarioResponsable", JSONObject.NULL);
					// ot.put("Aceptada", JSONObject.NULL);
					// if (ficha.getFeejec() != null) {
					// ot.put("FechaSolicitud", ficha.getFeejec());
					// ot.put("FechaPlanificacion", ficha.getFeejec());
					// } else {
					// ot.put("FechaSolicitud", JSONObject.NULL);
					// ot.put("FechaPlanificacion", JSONObject.NULL);
					// }
					// ot.put("FechaCierre", JSONObject.NULL);
					// ot.put("Direccion", JSONObject.NULL);
					// ot.put("CodigoPostal", JSONObject.NULL);
					// ot.put("Poblacion", JSONObject.NULL);
					// ot.put("Provincia", JSONObject.NULL);
					// ot.put("UUIdOt", UUIdOtHija);
					// ot.put("UUIdActivo", UUIdActivo);
					// ot.put("UUIdOtPadre", JSONObject.NULL);
					// ots.put(ot);
					//
					// JSONObject otLimpiar = new JSONObject();
					// otLimpiar.put("UUIdOt", UUIdOtHija);
					// otsLimpiar.put(otLimpiar);
					//
					// eliminarOtHija = true;
				}

				if (listaActuaciones != null && listaActuaciones.size() > 0) {
					for (Actuacion actuacion : listaActuaciones) {
						if (actuacion != null) {
							if (actuacion.getIdcuestionario() != null) {

								Cuestionario cuestionarioAux = new Cuestionario();
								cuestionarioAux.setIdcuestionario(actuacion
										.getIdcuestionario());
								cuestionarioAux = this.cuestionarioDao
										.find(cuestionarioAux);

								revision = new JSONObject();
								revision.put("IdPunto",
										cuestionarioAux.getIdcuestionario());
								if (cuestionarioAux.getOperacion() != null) {
									revision.put("DescPunto",
											cuestionarioAux.getOperacion());
								} else {
									revision.put("DescPunto", "-");
								}
								revision.put("Tipo", "6");
								revision.put("Valor", JSONObject.NULL);
								revision.put("UUIdOt", UUIdOtHija);
								revision.put("UUIdActivoRevisable", UUIdActivo);
								if (claseAux.getCclase() != null) {
									revision.put("Agrupador",
											claseAux.getCclase());
								} else {
									revision.put("Agrupador", "General");
								}
								revision.put("IdEnumerado",
										"E" + gamaAux.getIdclase());
								revisiones.put(revision);

								revision = new JSONObject();
								revision.put("IdPunto",
										cuestionarioAux.getIdcuestionario()
												+ "txt");
								revision.put("DescPunto",
										"Oharrak / Observaciones:");
								revision.put("Tipo", "3");
								revision.put("Valor", JSONObject.NULL);
								revision.put("UUIdOt", UUIdOtHija);
								revision.put("UUIdActivoRevisable", UUIdActivo);
								if (claseAux.getCclase() != null) {
									revision.put("Agrupador",
											claseAux.getCclase());
								} else {
									revision.put("Agrupador", "General");
								}
								revisiones.put(revision);
							}
						}
					}
				}

				campo = new JSONObject();

				campo.put("IdCampo", "IDZONAEDIF");
				campo.put("UUIdOt", UUIdOtHija);
				if (maquina.getZona() != null
						&& maquina.getZona().getIdzona() != null) {
					/*
					 * campo.put("Valor", maquina.getIdzona() + " - " +
					 * maquina.getZona().getEzona() + " / " +
					 * maquina.getZona().getCzona());
					 */
					campo.put("Valor",
							"{" + UUIdActivo + "}" + "_" + maquina.getIdzona());
				} else {
					campo.put("Valor", JSONObject.NULL);
				}

				/*
				 * campo.put("IdCampo", "IDZONA"); campo.put("UUIdOt",
				 * UUIdOtHija); if (maquina.getZona() != null) {
				 * campo.put("Valor", maquina.getZona().getIdzona()); } else {
				 * campo.put("Valor", JSONObject.NULL); }
				 */
				campos.put(campo);

				campo = new JSONObject();

				campo.put("IdCampo", "IDPLANTA");
				campo.put("UUIdOt", UUIdOtHija);
				if (maquina.getPlanta() != null
						&& maquina.getPlanta().getIdplanta() != null) {
					/*
					 * campo.put("Valor", maquina.getIdplanta() + " - " +
					 * maquina.getPlanta().getEplanta() + " / " +
					 * maquina.getPlanta().getCplanta());
					 */
					campo.put("Valor",
							"{" + UUIdActivo + "}" + "_" + maquina.getIdzona()
									+ "_" + maquina.getIdplanta());
				} else {
					campo.put("Valor", JSONObject.NULL);
				}

				/*
				 * campo.put("IdCampo", "IDPLANTA"); campo.put("UUIdOt",
				 * UUIdOtHija); if (maquina.getPlanta() != null) {
				 * campo.put("Valor", maquina.getPlanta().getIdplanta()); } else
				 * { campo.put("Valor", JSONObject.NULL); }
				 */
				campos.put(campo);

				campo = new JSONObject();
				campo.put("IdCampo", "IDCLASE");
				campo.put("UUIdOt", UUIdOtHija);
				if (idClase != null) {
					campo.put("Valor", idClase);
				} else {
					campo.put("Valor", JSONObject.NULL);
				}
				campos.put(campo);

				campo = new JSONObject();
				campo.put("IdCampo", "IDGAMA");
				campo.put("UUIdOt", UUIdOtHija);
				if (maquina.getIdgama() != null) {
					campo.put("Valor", maquina.getIdgama());
				} else {
					campo.put("Valor", JSONObject.NULL);
				}
				campos.put(campo);

				campo = new JSONObject();
				campo.put("IdCampo", "IDMAQUINA");
				campo.put("UUIdOt", UUIdOtHija);
				if (maquina.getIdmaquina() != null) {
					/*
					 * campo.put( "Valor", maquina.getIdmaquina() + " - " +
					 * maquina.getEmaquina() + " / " + maquina.getCmaquina());
					 */
					campo.put("Valor", maquina.getIdmaquina());
				} else {
					campo.put("Valor", JSONObject.NULL);
				}
				campos.put(campo);

				campo = new JSONObject();
				campo.put("IdCampo", "NOTASTEC");
				campo.put("UUIdOt", UUIdOtHija);
				campo.put("Valor", JSONObject.NULL);
				campos.put(campo);

			}
		}
		datosJson.put("ots", ots);
		if (operarios.length() > 0) {
			datosJson.put("operarios", operarios);
		} else {
			datosJson.put("operarios", JSONObject.NULL);
		}
		if (revisiones.length() > 0) {
			datosJson.put("revisiones", revisiones);
		} else {
			datosJson.put("revisiones", JSONObject.NULL);
		}
		if (documentos.length() > 0) {
			datosJson.put("documentos", documentos);
		} else {
			datosJson.put("documentos", JSONObject.NULL);
		}
		datosJson.put("campos", campos);
		if (otmods.length() > 0) {
			datosJson.put("otmod", otmods);
		}

		respuesta = this.sincronizarGmao(datosJson, urlConfig
				+ "Expertis_Sync_Movil_JS/index.php/sync/masters/SubirOTs/");

		/**
		 * MIRAR SI ES MEJOR BORRAR LA OT EN ESTE MOMENTO
		 */
		String respuestaLimpiar = "";
		if (eliminarOtHija) {
			JSONObject datosJsonLimpiarOt = new JSONObject();
			datosJsonLimpiarOt.put("ots", otsLimpiar);
			respuestaLimpiar = this
					.sincronizarGmao(
							datosJsonLimpiarOt,
							urlConfig
									+ "Expertis_Sync_Movil_JS/index.php/sync/masters/EliminarOTs/");
			System.out.println("Borrada OT " + respuestaLimpiar);
		}

		return respuesta;
	}

	@Override
	public String eliminarOTpadre(String guidPartePadre, String urlConfig) {
		// TODO Auto-generated method stub
		String respuesta = "";

		JSONObject datosJson = new JSONObject();
		JSONArray ots = new JSONArray();
		JSONObject ot = new JSONObject();

		ot.put("UUIdOt", guidPartePadre);
		ots.put(ot);

		datosJson.put("ots", ots);

		respuesta = this.sincronizarGmao(datosJson, urlConfig
				+ Aa20bConstantes.URL_ELIMINAR_OT);

		return respuesta;
	}

	@Override
	public String sincronizarGmao(JSONObject datosJson, String url) {
		// TODO Auto-generated method stub
		String respuesta = "";
		try {
			org.apache.http.client.methods.CloseableHttpResponse response = null;
			SSLContextBuilder builderList = new SSLContextBuilder();

			String usuarioGmao = "";

			try {
				if (url != null
						&& !url.equals("")
						&& (url.indexOf("ejiedes") != -1 || url
								.indexOf("ejiepru") != -1)) {
					usuarioGmao = this.appConfiguration.getObject()
							.getProperty("movilgmaodesa.user");
				} else {
					usuarioGmao = this.appConfiguration.getObject()
							.getProperty("movilgmaopro.user");
				}

			} catch (Exception e) {

			}

			try {
				builderList.loadTrustMaterial(null,
						new TrustSelfSignedStrategy());
				SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(
						builderList.build());

				org.apache.http.client.methods.HttpPost httpPost = null;

				HttpClientBuilder clientBuilder = HttpClientBuilder.create();

				clientBuilder.setSSLSocketFactory(sslsf);
				CloseableHttpClient httpClient = clientBuilder.build();

				httpPost = new HttpPost(url);
				/*
				 * httpPost.addHeader("Authorization", "Basic " + new
				 * String(Base64.encodeBase64(("ERPGOBVAS" + ":" +
				 * "EINigR444").getBytes())));
				 */
				httpPost.addHeader(
						"Authorization",
						"Basic "
								+ new String(Base64.encodeBase64((usuarioGmao)
										.getBytes())));
				httpPost.addHeader("content-type",
						"application/json;charset=UTF-8");

				String jsonRequestData = datosJson.toString();

				StringEntity se = new StringEntity(jsonRequestData,
						ContentType.create("text/plain", "UTF-8"));
				httpPost.setEntity(se);
				httpPost.setHeader("Content-Type",
						"application/json;charset=UTF-8");
				httpPost.setHeader("Accept-Encoding", "application/json");
				response = httpClient.execute(httpPost);

				HttpEntity entityList = response.getEntity();

				if (response.getStatusLine().getStatusCode() != 200) {
					throw new Exception("Failed : HTTP error code : "
							+ response.getStatusLine().getStatusCode());
				}

				respuesta = EntityUtils.toString(entityList);

				if (respuesta == null) {
					respuesta = "Error conexion";
				} else {
					respuesta = tratamientoRespuestaGmaoWS(respuesta);
				}

				// do something useful with the response body
				// and ensure it is fully consumed
				EntityUtils.consume(entityList);

			} catch (Exception e) {
				respuesta = "Excepcion";
				e.printStackTrace();
			} finally {
				response.close();
			}
		} catch (java.io.IOException e) {
			e.printStackTrace();
		}
		return respuesta;
	}

	@Override
	public String bajarOtByGUID(JSONObject datosJson, String url) {
		String respuesta = "";
		try {
			org.apache.http.client.methods.CloseableHttpResponse response = null;
			SSLContextBuilder builderList = new SSLContextBuilder();

			String usuarioGmao = "";

			try {
				if (url != null
						&& !url.equals("")
						&& (url.indexOf("ejiedes") != -1 || url
								.indexOf("ejiepru") != -1)) {
					usuarioGmao = this.appConfiguration.getObject()
							.getProperty("movilgmaodesa.user");
				} else {
					usuarioGmao = this.appConfiguration.getObject()
							.getProperty("movilgmaopro.user");
				}

			} catch (Exception e) {

			}
			try {
				builderList.loadTrustMaterial(null,
						new TrustSelfSignedStrategy());
				SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(
						builderList.build());

				org.apache.http.client.methods.HttpPost httpPost = null;

				HttpClientBuilder clientBuilder = HttpClientBuilder.create();

				clientBuilder.setSSLSocketFactory(sslsf);
				CloseableHttpClient httpClient = clientBuilder.build();

				httpPost = new HttpPost(url);
				httpPost.addHeader(
						"Authorization",
						"Basic "
								+ new String(Base64.encodeBase64((usuarioGmao)
										.getBytes())));
				httpPost.addHeader("content-type",
						"application/json;charset=UTF-8");

				String jsonRequestData = datosJson.toString();

				StringEntity se = new StringEntity(jsonRequestData,
						ContentType.create("text/plain", "UTF-8"));
				httpPost.setEntity(se);
				httpPost.setHeader("Content-Type",
						"application/json;charset=UTF-8");
				httpPost.setHeader("Accept-Encoding", "application/json");
				response = httpClient.execute(httpPost);

				HttpEntity entityList = response.getEntity();

				if (response.getStatusLine().getStatusCode() != 200) {
					throw new Exception("Failed : HTTP error code : "
							+ response.getStatusLine().getStatusCode());
				}

				respuesta = EntityUtils.toString(entityList);

				if (respuesta == null) {
					respuesta = "500";
				}

				// do something useful with the response body
				// and ensure it is fully consumed
				EntityUtils.consume(entityList);

			} catch (Exception e) {
				respuesta = "Excepcion";
				e.printStackTrace();
			} finally {
				response.close();
			}
		} catch (java.io.IOException e) {
			e.printStackTrace();
		}

		return respuesta;
	}

	@Override
	public String sincronizarGmaoGET(String url) {
		// TODO Auto-generated method stub
		String respuesta = "";
		try {
			org.apache.http.client.methods.CloseableHttpResponse response = null;
			SSLContextBuilder builderList = new SSLContextBuilder();
			String usuarioGmao = "";

			try {
				if (url != null
						&& !url.equals("")
						&& (url.indexOf("ejiedes") != -1 || url
								.indexOf("ejiepru") != -1)) {
					usuarioGmao = this.appConfiguration.getObject()
							.getProperty("movilgmaodesa.user");
				} else {
					usuarioGmao = this.appConfiguration.getObject()
							.getProperty("movilgmaopro.user");
				}

			} catch (Exception e) {

			}

			try {
				builderList.loadTrustMaterial(null,
						new TrustSelfSignedStrategy());
				SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(
						builderList.build());

				org.apache.http.client.methods.HttpGet httpGet = null;

				HttpClientBuilder clientBuilder = HttpClientBuilder.create();

				clientBuilder.setSSLSocketFactory(sslsf);
				CloseableHttpClient httpClient = clientBuilder.build();

				httpGet = new HttpGet(url);
				httpGet.addHeader(
						"Authorization",
						"Basic "
								+ new String(Base64.encodeBase64((usuarioGmao)
										.getBytes())));
				httpGet.addHeader("content-type",
						"application/json;charset=UTF-8");

				httpGet.setHeader("Content-Type", "application/json");
				httpGet.setHeader("Accept-Encoding", "application/json");
				response = httpClient.execute(httpGet);

				HttpEntity entityList = response.getEntity();

				if (response.getStatusLine().getStatusCode() != 200) {
					throw new Exception("Failed : HTTP error code : "
							+ response.getStatusLine().getStatusCode());
				}

				respuesta = EntityUtils.toString(entityList);

				if (respuesta == null) {
					respuesta = "";
				}

				// do something useful with the response body
				// and ensure it is fully consumed
				EntityUtils.consume(entityList);

			} catch (Exception e) {
				respuesta = "";
				e.printStackTrace();
			} finally {
				response.close();
			}
		} catch (java.io.IOException e) {
			e.printStackTrace();
		}
		return respuesta;
	}

	private String subirFicheroMovilGmao(String guidParte,
			String nombreFichero, byte[] plano, String url, String tipoFichero) {
		// TODO Auto-generated method stub
		String respuesta = "";
		try {
			org.apache.http.client.methods.CloseableHttpResponse response = null;
			SSLContextBuilder builderList = new SSLContextBuilder();

			String usuarioGmao = "";

			try {
				if (url != null
						&& !url.equals("")
						&& (url.indexOf("ejiedes") != -1 || url
								.indexOf("ejiepru") != -1)) {
					usuarioGmao = this.appConfiguration.getObject()
							.getProperty("movilgmaodesa.user");
				} else {
					usuarioGmao = this.appConfiguration.getObject()
							.getProperty("movilgmaopro.user");
				}

			} catch (Exception e) {

			}
			try {
				builderList.loadTrustMaterial(null,
						new TrustSelfSignedStrategy());
				SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(
						builderList.build());

				org.apache.http.client.methods.HttpPost httpPost = null;

				HttpClientBuilder clientBuilder = HttpClientBuilder.create();

				clientBuilder.setSSLSocketFactory(sslsf);
				CloseableHttpClient httpClient = clientBuilder.build();

				httpPost = new HttpPost(url);
				httpPost.addHeader(
						"Authorization",
						"Basic "
								+ new String(Base64.encodeBase64((usuarioGmao)
										.getBytes())));

				httpPost.addHeader("content-type", "multipart/form-data");
				httpPost.addHeader("cache-control", "no-cache");
				/*
				 * httpPost.addHeader("content-type",
				 * "application/json;charset=UTF-8");
				 */

				/*
				 * List<NameValuePair> postParams = new
				 * ArrayList<NameValuePair>(); postParams.add(new
				 * BasicNameValuePair("param-1", "12345")); postParams.add(new
				 * BasicNameValuePair("param-2", "Hello!"));
				 */
				MultipartEntity entity = new MultipartEntity(
						HttpMultipartMode.BROWSER_COMPATIBLE);

				entity.addPart("UUId", new StringBody(guidParte, "text/plain",
						Charset.forName("UTF-8")));
				entity.addPart("NombreFichero", new StringBody(nombreFichero,
						"text/plain", Charset.forName("UTF-8")));
				entity.addPart("Nuevo", new StringBody("1", "text/plain",
						Charset.forName("UTF-8")));

				File file = new File(nombreFichero);
				file.createNewFile();
				FileOutputStream fos = new FileOutputStream(file);
				fos.write(plano);
				fos.close();

				entity.addPart("sendfile", new FileBody(((File) file),
						tipoFichero));

				/*
				 * entity.addBinaryBody("upfile", file,
				 * ContentType.DEFAULT_BINARY, textFileName);
				 */

				httpPost.setEntity(entity);

				response = httpClient.execute(httpPost);

				HttpEntity entityList = response.getEntity();

				if (response.getStatusLine().getStatusCode() != 200) {
					throw new Exception("Failed : HTTP error code : "
							+ response.getStatusLine().getStatusCode());
				}

				respuesta = EntityUtils.toString(entityList);

				if (respuesta != null && !respuesta.equals("")) {
					JSONObject respFichero = new JSONObject(respuesta);
					respuesta = respFichero.get("success").toString();
				}

				// do something useful with the response body
				// and ensure it is fully consumed
				EntityUtils.consume(entityList);

			} catch (Exception e) {
				respuesta = "";
				e.printStackTrace();
			} finally {
				response.close();
			}
		} catch (java.io.IOException e) {
			e.printStackTrace();
		}
		return respuesta;
	}

	private String tratamientoRespuestaGmaoWS(String respuestaJSON) {
		String respuesta = "";
		try {
			if (!respuestaJSON.equals("")) {
				JSONObject resp = new JSONObject(respuestaJSON);

				String res = resp.get("respuesta").toString();
				if (res != null && res.equals("OK")) {
					respuesta = res;
				} else if (res != null && res.equals("ERROR")) {
					String codigo = resp.get("codigo").toString();
					String mensaje = resp.get("mensaje").toString();
					respuesta = "Error en la sincronización con Gmao: "
							+ codigo + ": " + mensaje;
				} else if (res != null && res.equals("INFO")) {
					String mensaje = resp.get("mensaje").toString();
					respuesta = mensaje;

				}
			}
		} catch (Exception e) {
			respuesta = "Error en el tratamiento respuesta";
		}

		return respuesta;
	}

	private String obtenerGuidPartePadreAveriaRepe(Integer averiaRepe) {
		String guidPartePadre = "";
		Partetecnicosgmao partetecnicosgmaoAux = new Partetecnicosgmao();
		partetecnicosgmaoAux.setGuidpartetecgmao(averiaRepe.toString());
		partetecnicosgmaoAux = this.partetecnicosgmaoDao
				.findByIdParte(partetecnicosgmaoAux);

		if (partetecnicosgmaoAux != null
				&& partetecnicosgmaoAux.getGuidpartetecgmao() != null) {
			guidPartePadre = partetecnicosgmaoAux.getGuidpartetecgmao();
		}

		return guidPartePadre;

	}

}
