package com.ejie.aa20b.jms;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ejie.aa20b.model.Clase;
import com.ejie.aa20b.model.Codigo;

import com.ejie.aa20b.model.Actuacion;
import com.ejie.aa20b.model.Departamentos;
import com.ejie.aa20b.model.Direcciones;
import com.ejie.aa20b.model.Edificios;
import com.ejie.aa20b.model.Espacio;
import com.ejie.aa20b.model.Ficha;
import com.ejie.aa20b.model.Fichatecnicosgmao;
import com.ejie.aa20b.model.Gamas;
import com.ejie.aa20b.model.Maquinas;
import com.ejie.aa20b.model.Partes;
import com.ejie.aa20b.model.Partetecnicos;
import com.ejie.aa20b.model.Partetecnicosgmao;
import com.ejie.aa20b.model.Plantas;
import com.ejie.aa20b.model.Servicios;
import com.ejie.aa20b.model.Zonas;
import com.ejie.x38.json.JSONObject;

public interface Aa20bProcesosJMS {

	void sendMessageText(String message, int operacion);

	void sendMessageObjeto(int operacion, String tipo, Object objeto);

	/**
	 * Sincronizaciones mant generales
	 */
	// Edificios
	String sincronizarGmao(JSONObject datosJson, String url);

	String generarEntidadesEdifEstruc(String urlConfig);

	String generarEntidadEstancias(String urlConfig);

	String generarEntidadClases(String urlConfig);

	String generarEntidadCodigos(String urlConfig);

	String generarEntidadServicios(String urlConfig);

	void sincronizarZonaEdifGmao(Edificios edificio, Zonas zona);

	void sincronizarEdifEstruc(List<Edificios> edificios, int tipoLlamada,
			String url);

	void sincronizarPlantaEdifGmao(Edificios edificio, Zonas zona,
			Plantas planta);

	String sincronizarTodasEstanciasGmao(List<Espacio> espacios,
			int tipoLlamada, String urlConfig);

	void sincronizarEstanciaGmao(Espacio espacio);

	String sincronizarTodasClasesGmao(List<Clase> clases, int tipoLlamada,
			String urlConfig);

	String sincronizarTodosCodigosGmao(List<Codigo> codigos, int tipoLlamada,
			String urlConfig);

	String sincronizarTodosServiciosGmao(List<Servicios> servicios,
			int tipoLlamada, String urlConfig);

	void sincronizarClaseGmao(Clase clase);

	void sincronizarCodigoGmao(Codigo codigo);

	void sincronizarServicioGmao(Servicios servicio);

	String sincronizarParteCorrectivoGmao(Partes parte,
			List<Partetecnicosgmao> tecnicosParteGmao, String UUIdActivo,
			byte[] plano, byte[] pdf, String urlConfig);

	String sincronizarPartePreventivoGmao(Ficha ficha, Maquinas maquina,
			List<Fichatecnicosgmao> tecnicosFichaGmao,
			List<Actuacion> listaActuaciones, String UUIdActivo,
			String urlConfig);

	String sincronizarGmaoGET(String url);

	String bajarOtByGUID(JSONObject datosJson, String url);

	String sincronizarTodosGamasGmao(List<Gamas> gamas, int tipoLlamada,
			String urlConfig);

	void sincronizarGamaGmao(Gamas gama);

	String generarEntidadGamas(String urlConfig);

	String sincronizarTodosMaquinasGmao(List<Maquinas> maquinas,
			int tipoLlamada, String urlConfig, int numSinc);

	void sincronizarMaquinaGmao(Maquinas maquina);

	String generarEntidadMaquinas(String urlConfig);

	String eliminarOTpadre(String guidPartePadre, String urlConfig);

	String sincronizarTodosDepartamentos(List<Departamentos> dptos,
			int tipoLlamada, String urlConfig);

	String sincronizarTodasDirecciones(List<Direcciones> dirs, int tipoLlamada,
			String urlConfig);

	String generarEntidadDepartamentos(String urlConfig);

	String generarEntidadDirecciones(String urlConfig);

	String subirOTcambioEstado(String guidOT, String nuevoEstado,
			String urlConfig);

	String marcarOTaceptada(String guidOT, String aceptada, String urlConfig);

	String enviarObservacionResponsable(String guidOT, String observacion,
			String urlConfig);

	String subirOTcambioTecnico(String guidOT, String nuevoOperario,
			String urlConfig);

	String subirOTcambioFechaPlanif(String guidOT, Date fechaPlanif,
			String urlConfig);

	String enviarObservacionesFicha(String guidOT, String observaciones,
			String urlConfig);

}
