package com.ejie.aa20b.informes.listados;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.apache.fop.afp.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import com.ejie.aa20b.classes.Aa20bFecha;
import com.ejie.aa20b.classes.Aa20bFormatoFecha;
import com.ejie.aa20b.model.Ficha;
import com.ejie.aa20b.model.TablaInformes;
import com.ejie.aa20b.util.Aa20bConstantes;

public class Preventivos {
	private static final Logger logger = LoggerFactory
			.getLogger(Preventivos.class);

	/* Imprimir */
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public Document getFoPreventivosXml(HttpServletRequest request,
			Locale locale, ArrayList listaFichas, Ficha filtro) {
		Preventivos.logger.info("getFoPreventivosXml");

		String idioma = locale.getLanguage();

		Document doc = null;
		Element rootElement = null;
		try {
			DocumentBuilderFactory docFactory = DocumentBuilderFactory
					.newInstance();

			DocumentBuilder docBuilder = docFactory.newDocumentBuilder();

			// root elements

			doc = docBuilder.newDocument();
			rootElement = doc.createElement("report");
			doc.appendChild(rootElement);

			/* INSERTAMOS EL FILTRO Num ficha */
			Element fNFicha = doc.createElement("filtroNFicha");
			rootElement.appendChild(fNFicha);
			if (filtro.getIdficha() != null) {
				fNFicha.appendChild(doc.createTextNode(filtro.getIdficha()
						.equals("") ? " " : filtro.getIdficha().toString()));
			} else {
				fNFicha.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO Num Ficha */

			/* INSERTAMOS EL FILTRO FECHA DESDE */
			Element fFdesde = doc.createElement("filtroFDesde");
			String fechaDesdeString = " ";
			rootElement.appendChild(fFdesde);
			if (filtro.getFechaD() != null) {
				fechaDesdeString = Aa20bFormatoFecha.date2String(
						filtro.getFechaD(), locale);
				fFdesde.appendChild(doc.createTextNode(fechaDesdeString));
			} else {
				fFdesde.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO FECHA DESDE */

			/* INSERTAMOS EL FILTRO FECHA HASTA */
			Element fFhasta = doc.createElement("filtroFHasta");
			String fechaHastaString = " ";
			rootElement.appendChild(fFhasta);
			if (filtro.getFechaH() != null) {
				fechaHastaString = Aa20bFormatoFecha.date2String(
						filtro.getFechaH(), locale);
				fFhasta.appendChild(doc.createTextNode(fechaHastaString));
			} else {
				fFhasta.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO FECHA HASTA */

			/* INSERTAMOS EL FILTRO FECHA PLANIF DESDE */
			Element fFplanifdesde = doc.createElement("filtroFplanifDesde");
			String fechaplanifDesdeString = " ";
			rootElement.appendChild(fFplanifdesde);
			if (filtro.getFechaplanifD() != null) {
				fechaplanifDesdeString = Aa20bFormatoFecha.date2String(
						filtro.getFechaplanifD(), locale);
				fFplanifdesde.appendChild(doc
						.createTextNode(fechaplanifDesdeString));
			} else {
				fFplanifdesde.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO FECHA PLANIF DESDE */

			/* INSERTAMOS EL FILTRO FECHA PLANIF HASTA */
			Element fFplanifhasta = doc.createElement("filtroFplanifHasta");
			String fechaplanifHastaString = " ";
			rootElement.appendChild(fFplanifhasta);
			if (filtro.getFechaplanifH() != null) {
				fechaplanifHastaString = Aa20bFormatoFecha.date2String(
						filtro.getFechaplanifH(), locale);
				fFplanifhasta.appendChild(doc
						.createTextNode(fechaplanifHastaString));
			} else {
				fFplanifhasta.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO FECHA PLANIF HASTA */

			/* INSERTAMOS EL FILTRO DE EDIFICIO */
			Element fEdificio = doc.createElement("filtroEdificio");
			String strFEdificio = "";
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				if (filtro.getMaquina() != null
						&& filtro.getMaquina().getEdificio() != null) {
					strFEdificio = filtro.getMaquina().getEdificio()
							.getEedificio() == null ? "" : filtro.getMaquina()
							.getEdificio().getEedificio();
				}
			} else {
				if (filtro.getMaquina() != null
						&& filtro.getMaquina().getEdificio() != null) {
					strFEdificio = filtro.getMaquina().getEdificio()
							.getCedificio() == null ? "" : filtro.getMaquina()
							.getEdificio().getCedificio();
				}
			}
			rootElement.appendChild(fEdificio);
			fEdificio.appendChild(doc.createTextNode(strFEdificio));
			/* FIN EL FILTRO DE EDIFICIO */

			/* INSERTAMOS EL FILTRO ZONA */
			Element fZona = doc.createElement("filtroZona");
			rootElement.appendChild(fZona);
			if (filtro.getMaquina() != null
					&& filtro.getMaquina().getZona() != null
					&& filtro.getMaquina().getZona().getCzona() != null) {
				fZona.appendChild(doc.createTextNode(filtro.getMaquina()
						.getZona().getCzona().equals("") ? " " : filtro
						.getMaquina().getZona().getCzona()));
			} else {
				fZona.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO ZONA */

			/* INSERTAMOS EL FILTRO PLANTA */
			Element fPlanta = doc.createElement("filtroPlanta");
			rootElement.appendChild(fPlanta);
			if (filtro.getMaquina() != null
					&& filtro.getMaquina().getPlanta() != null
					&& filtro.getMaquina().getPlanta().getCplanta() != null) {
				fPlanta.appendChild(doc.createTextNode(filtro.getMaquina()
						.getPlanta().getCplanta().equals("") ? " " : filtro
						.getMaquina().getPlanta().getCplanta()));
			} else {
				fPlanta.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO PLANTA */

			/* INSERTAMOS EL FILTRO MCODIGO */
			Element fMCodigo = doc.createElement("filtroMCodigo");
			rootElement.appendChild(fMCodigo);
			if (filtro.getMaquina() != null && filtro.getMaquina() != null
					&& filtro.getMaquina().getMcodigo() != null) {
				fMCodigo.appendChild(doc.createTextNode(filtro.getMaquina()
						.getMcodigo().equals("") ? " " : filtro.getMaquina()
						.getMcodigo()));
			} else {
				fMCodigo.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO MCODIGO */

			/* INSERTAMOS EL FILTRO EQUIPO */
			Element fEquipo = doc.createElement("filtroEquipo");
			rootElement.appendChild(fEquipo);
			if (filtro.getMaquina() != null && filtro.getMaquina() != null
					&& filtro.getMaquina().getCmaquina() != null) {
				fEquipo.appendChild(doc.createTextNode(filtro.getMaquina()
						.getCmaquina().equals("") ? " " : filtro.getMaquina()
						.getCmaquina()));
			} else {
				fEquipo.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO EQUIPO */

			/* INSERTAMOS EL FILTRO TECNICOS */
			Element fTecnico = doc.createElement("filtroTecnico");
			rootElement.appendChild(fTecnico);
			if (filtro.getTecnicos() != null) {
				fTecnico.appendChild(doc.createTextNode(filtro.getTecnicos()
						.equals("") ? " " : filtro.getTecnicos()));
			} else {
				fTecnico.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO EQUIPO */

			/* INSERTAMOS EL FILTRO GAMA */
			Element fgama = doc.createElement("filtroGama");
			rootElement.appendChild(fgama);
			if (filtro.getMaquina() != null
					&& filtro.getMaquina().getGama() != null
					&& filtro.getMaquina().getGama().getCgama() != null) {
				fgama.appendChild(doc.createTextNode(filtro.getMaquina()
						.getGama().getCgama().equals("") ? " " : filtro
						.getMaquina().getGama().getCgama()));
			} else {
				fgama.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO GAMA */

			/* INSERTAMOS EL FILTRO EJECUTADOS */
			Element fEjecutado = doc.createElement("filtroEjecutados");
			rootElement.appendChild(fEjecutado);
			if (filtro.getEjecutado() != null) {
				fEjecutado.appendChild(doc.createTextNode(filtro.getEjecutado()
						.equals("1") ? "Si" : " "));
			} else {
				fEjecutado.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO EJECUTADOS */

			/* INSERTAMOS EL FILTRO PARADOS */
			Element fParado = doc.createElement("filtroParados");
			rootElement.appendChild(fParado);
			if (filtro.getParado() != null) {
				fParado.appendChild(doc.createTextNode(filtro.getParado()
						.equals("1") ? "Si" : " "));
			} else {
				fParado.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO PARADOS */

			/* INSERTAMOS EL FILTRO PENDIENTES DE EJECUTAR */
			Element fPendEjec = doc.createElement("filtroPendEjecutar");
			rootElement.appendChild(fPendEjec);
			if (filtro.getPendEjec() != null) {
				fPendEjec.appendChild(doc.createTextNode(filtro.getPendEjec()
						.equals("1") ? "Si" : " "));
			} else {
				fPendEjec.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO PENDIENTES DE EJECUTAR */

			/* INSERTAMOS EL FILTRO con/sin TECNICOS */
			Element fTecAsig = doc.createElement("filtroConSinTecnicos");
			rootElement.appendChild(fTecAsig);
			if (filtro.getConTecnicos() != null
					&& !filtro.getConTecnicos().equals("")) {
				fTecAsig.appendChild(doc.createTextNode(filtro.getConTecnicos()
						.equals("1") ? "Si" : "No"));
			} else {
				fTecAsig.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO con/sin TECNICOS */

			/* INSERTAMOS LA FECHA DE HOY A LA RAIZ */
			Element fechaHoyEl = doc.createElement("fechaHoy");

			java.util.Date fechaHoy = new Date();

			String fechaString = Aa20bFecha.getFecha(fechaHoy);
			Integer diaSemana = fechaHoy.getDay() + 1;
			String fechaHoyString = "";
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				fechaHoyString = Aa20bFecha.convertirFechaCompletaEu(
						fechaString, diaSemana);

			} else {
				fechaHoyString = Aa20bFecha.convertirFechaCompleta(fechaString,
						diaSemana);
			}

			rootElement.appendChild(fechaHoyEl);
			fechaHoyEl.appendChild(doc
					.createTextNode(fechaHoyString == null ? " "
							: fechaHoyString));
			/* FIN INSERTAR FECHA DE HOY */

			// Element listadoEl = doc.createElement("listado");
			// Rellenamos una registro a vacios en caso de que no haya
			// resultados para poder montar el xml y así no nos dé error el pdf
			if (listaFichas.size() == 0) {
				TablaInformes tablaVacia = new TablaInformes();
				tablaVacia.setIdficha(0);
				tablaVacia.setIdmaquina((long) 0);
				listaFichas.add(tablaVacia);
			}

			/*
			 * NUMFILAS - INSERTAMOS contador de filas para que no se pinte la
			 * tabla si no hay datos
			 */
			Element numFilasEl = doc.createElement("numFilas");
			rootElement.appendChild(numFilasEl);
			numFilasEl.appendChild(doc.createTextNode(Integer
					.toString(listaFichas.size())));
			/* FIN NUMFILAS */

			if (listaFichas.size() > 0) {

			} else {

				return null;
			}

			Element listadoEl = doc.createElement("listado");

			for (int i = 0; i < listaFichas.size(); i++) {
				// Añadimos los de Operaciones

				TablaInformes laFila = new TablaInformes();
				Element filaEl = doc.createElement("row");

				laFila = (TablaInformes) listaFichas.get(i);
				Element operacionEl = doc.createElement("FICHA");
				operacionEl
						.appendChild(doc
								.createTextNode(laFila.getIdficha() == null ? ""
										: laFila.getIdficha().toString()));
				filaEl.appendChild(operacionEl);

				Element fechaReEl = doc.createElement("FECHAPREVISTA");
				String fechaReString = "";
				if (laFila.getFecha() != null) {
					fechaString = Aa20bFecha.getFecha(laFila.getFecha());
					diaSemana = laFila.getFecha().getDay() + 1;
					if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
						fechaReString = Aa20bFecha.convertirFechaCompletaEu(
								fechaString, diaSemana);
					} else {
						fechaReString = Aa20bFecha.convertirFechaCompleta(
								fechaString, diaSemana);
					}
				}
				fechaReEl.appendChild(doc
						.createTextNode(fechaReString == null ? " "
								: fechaReString));
				filaEl.appendChild(fechaReEl);

				Element edifEl = doc.createElement("EDIFICIO");
				String strEdificio = "";
				if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
					strEdificio = laFila.getEedificio() == null ? "" : laFila
							.getEedificio();
				} else {
					strEdificio = laFila.getCedificio() == null ? "" : laFila
							.getCedificio();
				}
				edifEl.appendChild(doc.createTextNode(strEdificio));
				filaEl.appendChild(edifEl);

				Element zonaPlantaEl = doc.createElement("ZONAPLANTA");
				String strZonaPlanta = "";
				if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
					strZonaPlanta = (laFila.getEzona() == null ? "" : laFila
							.getEzona())
							+ "/"
							+ (laFila.getEplanta() == null ? "" : laFila
									.getEplanta());
				} else {
					strZonaPlanta = (laFila.getCzona() == null ? "" : laFila
							.getCzona())
							+ "/"
							+ (laFila.getCplanta() == null ? "" : laFila
									.getCplanta());
				}
				zonaPlantaEl.appendChild(doc.createTextNode(strZonaPlanta));
				filaEl.appendChild(zonaPlantaEl);

				Element equipoEl = doc.createElement("EQUIPO");
				String strEquipo = "";
				if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
					strEquipo = laFila.getEmaquina() == null ? "" : laFila
							.getEmaquina();
				} else {
					strEquipo = laFila.getCmaquina() == null ? "" : laFila
							.getCmaquina();
				}
				equipoEl.appendChild(doc.createTextNode(strEquipo));
				filaEl.appendChild(equipoEl);

				Element gamaEl = doc.createElement("GAMA");
				String strGama = "";
				if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
					strGama = laFila.getEgama() == null ? "" : laFila
							.getEgama();
				} else {
					strGama = laFila.getCgama() == null ? "" : laFila
							.getCgama();
				}
				gamaEl.appendChild(doc.createTextNode(strGama));
				filaEl.appendChild(gamaEl);

				listadoEl.appendChild(filaEl);
				// Preventivos.logger.info("1xml Preventivos: "
				// + nodeToString(listadoEl));

			}
			rootElement.appendChild(listadoEl);

			// return doc;
			// del for de listaGrupos

		} catch (Exception e) {
			Preventivos.logger.info("eror xml Preventivos: ");
		}
		// Preventivos.logger
		// .info("xml Preventivos: " + nodeToString(rootElement));

		return doc;

	}

	/* Imprimir Diario de Fichas */
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public Document getFoDiarioFichasXml(HttpServletRequest request,
			Locale locale, ArrayList listaFichas, Ficha filtro) {
		Preventivos.logger.info("getFoDiarioFichasXml");

		String idioma = locale.getLanguage();
		Integer numeroDeFilas = 0;

		Document doc = null;
		Element rootElement = null;
		try {
			DocumentBuilderFactory docFactory = DocumentBuilderFactory
					.newInstance();

			DocumentBuilder docBuilder = docFactory.newDocumentBuilder();

			// root elements

			doc = docBuilder.newDocument();
			rootElement = doc.createElement("report");
			doc.appendChild(rootElement);

			/* INSERTAMOS EL FILTRO Num ficha */
			Element fNFicha = doc.createElement("filtroNFicha");
			rootElement.appendChild(fNFicha);
			if (filtro.getIdficha() != null) {
				fNFicha.appendChild(doc.createTextNode(filtro.getIdficha()
						.equals("") ? " " : filtro.getIdficha().toString()));
			} else {
				fNFicha.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO Num Ficha */

			/* INSERTAMOS EL FILTRO FECHA DESDE */
			Element fFdesde = doc.createElement("filtroFDesde");
			String fechaDesdeString = " ";
			rootElement.appendChild(fFdesde);
			if (filtro.getFechaD() != null) {
				fechaDesdeString = Aa20bFormatoFecha.date2String(
						filtro.getFechaD(), locale);
				fFdesde.appendChild(doc.createTextNode(fechaDesdeString));
			} else {
				fFdesde.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO FECHA DESDE */

			/* INSERTAMOS EL FILTRO FECHA HASTA */
			Element fFhasta = doc.createElement("filtroFHasta");
			String fechaHastaString = " ";
			rootElement.appendChild(fFhasta);
			if (filtro.getFechaH() != null) {
				fechaHastaString = Aa20bFormatoFecha.date2String(
						filtro.getFechaH(), locale);
				fFhasta.appendChild(doc.createTextNode(fechaHastaString));
			} else {
				fFhasta.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO FECHA HASTA */

			/* INSERTAMOS EL FILTRO FECHA PLANIF DESDE */
			Element fFplanifdesde = doc.createElement("filtroFplanifDesde");
			String fechaplanifDesdeString = " ";
			rootElement.appendChild(fFplanifdesde);
			if (filtro.getFechaplanifD() != null) {
				fechaplanifDesdeString = Aa20bFormatoFecha.date2String(
						filtro.getFechaplanifD(), locale);
				fFplanifdesde.appendChild(doc
						.createTextNode(fechaplanifDesdeString));
			} else {
				fFplanifdesde.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO FECHA PLANIF DESDE */

			/* INSERTAMOS EL FILTRO FECHA PLANIF HASTA */
			Element fFplanifhasta = doc.createElement("filtroFplanifHasta");
			String fechaplanifHastaString = " ";
			rootElement.appendChild(fFplanifhasta);
			if (filtro.getFechaplanifH() != null) {
				fechaplanifHastaString = Aa20bFormatoFecha.date2String(
						filtro.getFechaplanifH(), locale);
				fFplanifhasta.appendChild(doc
						.createTextNode(fechaplanifHastaString));
			} else {
				fFplanifhasta.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO FECHA PLANIF HASTA */

			/* INSERTAMOS EL FILTRO DE EDIFICIO */
			Element fEdificio = doc.createElement("filtroEdificio");
			String strFEdificio = "";
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				if (filtro.getMaquina() != null
						&& filtro.getMaquina().getEdificio() != null) {
					strFEdificio = filtro.getMaquina().getEdificio()
							.getEedificio() == null ? "" : filtro.getMaquina()
							.getEdificio().getEedificio();
				}
			} else {
				if (filtro.getMaquina() != null
						&& filtro.getMaquina().getEdificio() != null) {
					strFEdificio = filtro.getMaquina().getEdificio()
							.getCedificio() == null ? "" : filtro.getMaquina()
							.getEdificio().getCedificio();
				}
			}
			rootElement.appendChild(fEdificio);
			fEdificio.appendChild(doc.createTextNode(strFEdificio));
			/* FIN EL FILTRO DE EDIFICIO */

			/* INSERTAMOS EL FILTRO ZONA */
			Element fZona = doc.createElement("filtroZona");
			rootElement.appendChild(fZona);
			if (filtro.getMaquina() != null
					&& filtro.getMaquina().getZona() != null
					&& filtro.getMaquina().getZona().getCzona() != null) {
				fZona.appendChild(doc.createTextNode(filtro.getMaquina()
						.getZona().getCzona().equals("") ? " " : filtro
						.getMaquina().getZona().getCzona()));
			} else {
				fZona.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO ZONA */

			/* INSERTAMOS EL FILTRO PLANTA */
			Element fPlanta = doc.createElement("filtroPlanta");
			rootElement.appendChild(fPlanta);
			if (filtro.getMaquina() != null
					&& filtro.getMaquina().getPlanta() != null
					&& filtro.getMaquina().getPlanta().getCplanta() != null) {
				fPlanta.appendChild(doc.createTextNode(filtro.getMaquina()
						.getPlanta().getCplanta().equals("") ? " " : filtro
						.getMaquina().getPlanta().getCplanta()));
			} else {
				fPlanta.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO PLANTA */

			/* INSERTAMOS EL FILTRO MCODIGO */
			Element fMCodigo = doc.createElement("filtroMCodigo");
			rootElement.appendChild(fMCodigo);
			if (filtro.getMaquina() != null && filtro.getMaquina() != null
					&& filtro.getMaquina().getMcodigo() != null) {
				fMCodigo.appendChild(doc.createTextNode(filtro.getMaquina()
						.getMcodigo().equals("") ? " " : filtro.getMaquina()
						.getMcodigo()));
			} else {
				fMCodigo.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO MCODIGO */

			/* INSERTAMOS EL FILTRO EQUIPO */
			Element fEquipo = doc.createElement("filtroEquipo");
			rootElement.appendChild(fEquipo);
			if (filtro.getMaquina() != null && filtro.getMaquina() != null
					&& filtro.getMaquina().getCmaquina() != null) {
				fEquipo.appendChild(doc.createTextNode(filtro.getMaquina()
						.getCmaquina().equals("") ? " " : filtro.getMaquina()
						.getCmaquina()));
			} else {
				fEquipo.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO EQUIPO */

			/* INSERTAMOS EL FILTRO TECNICOS */
			Element fTecnico = doc.createElement("filtroTecnico");
			rootElement.appendChild(fTecnico);
			if (filtro.getTecnicos() != null) {
				fTecnico.appendChild(doc.createTextNode(filtro.getTecnicos()
						.equals("") ? " " : filtro.getTecnicos()));
			} else {
				fTecnico.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO EQUIPO */

			/* INSERTAMOS EL FILTRO GAMA */
			Element fgama = doc.createElement("filtroGama");
			rootElement.appendChild(fgama);
			if (filtro.getMaquina() != null
					&& filtro.getMaquina().getGama() != null
					&& filtro.getMaquina().getGama().getCgama() != null) {
				fgama.appendChild(doc.createTextNode(filtro.getMaquina()
						.getGama().getCgama().equals("") ? " " : filtro
						.getMaquina().getGama().getCgama()));
			} else {
				fgama.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO GAMA */

			/* INSERTAMOS EL FILTRO EJECUTADOS */
			Element fEjecutado = doc.createElement("filtroEjecutados");
			rootElement.appendChild(fEjecutado);
			if (filtro.getEjecutado() != null) {
				fEjecutado.appendChild(doc.createTextNode(filtro.getEjecutado()
						.equals("1") ? "Si" : " "));
			} else {
				fEjecutado.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO EJECUTADOS */

			/* INSERTAMOS EL FILTRO PARADOS */
			Element fParado = doc.createElement("filtroParados");
			rootElement.appendChild(fParado);
			if (filtro.getParado() != null) {
				fParado.appendChild(doc.createTextNode(filtro.getParado()
						.equals("1") ? "Si" : " "));
			} else {
				fParado.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO PARADOS */

			/* INSERTAMOS EL FILTRO PENDIENTES DE EJECUTAR */
			Element fPendEjec = doc.createElement("filtroPendEjecutar");
			rootElement.appendChild(fPendEjec);
			if (filtro.getPendEjec() != null) {
				fPendEjec.appendChild(doc.createTextNode(filtro.getPendEjec()
						.equals("1") ? "Si" : " "));
			} else {
				fPendEjec.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO PENDIENTES DE EJECUTAR */

			/* INSERTAMOS EL FILTRO con/sin TECNICOS */
			Element fTecAsig = doc.createElement("filtroConSinTecnicos");
			rootElement.appendChild(fTecAsig);
			if (filtro.getConTecnicos() != null
					&& !filtro.getConTecnicos().equals("")) {
				fTecAsig.appendChild(doc.createTextNode(filtro.getConTecnicos()
						.equals("1") ? "Si" : "No"));
			} else {
				fTecAsig.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO con/sin TECNICOS */

			/* INSERTAMOS LA FECHA DE HOY A LA RAIZ */
			Element fechaHoyEl = doc.createElement("fechaHoy");

			java.util.Date fechaHoy = new Date();

			String fechaString = Aa20bFecha.getFecha(fechaHoy);
			Integer diaSemana = fechaHoy.getDay() + 1;
			String fechaHoyString = "";
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				fechaHoyString = Aa20bFecha.convertirFechaCompletaEu(
						fechaString, diaSemana);

			} else {
				fechaHoyString = Aa20bFecha.convertirFechaCompleta(fechaString,
						diaSemana);
			}

			rootElement.appendChild(fechaHoyEl);
			fechaHoyEl.appendChild(doc
					.createTextNode(fechaHoyString == null ? " "
							: fechaHoyString));
			/* FIN INSERTAR FECHA DE HOY */

			// Element listadoEl = doc.createElement("listado");
			// Rellenamos una registro a vacios en caso de que no haya
			// resultados para poder montar el xml y así no nos dé error el pdf
			if (listaFichas.size() == 0) {
				TablaInformes tablaVacia = new TablaInformes();
				tablaVacia.setIdficha(0);
				tablaVacia.setIdmaquina((long) 0);
				listaFichas.add(tablaVacia);
			} else {
				numeroDeFilas = listaFichas.size();
			}

			/*
			 * NUMFILAS - INSERTAMOS contador de filas para que no se pinte la
			 * tabla si no hay datos
			 */
			Element numFilasEl = doc.createElement("numFilas");
			rootElement.appendChild(numFilasEl);
			numFilasEl.appendChild(doc.createTextNode(Integer
					.toString(numeroDeFilas)));
			/* FIN NUMFILAS */

			if (listaFichas.size() > 0) {

			} else {

				return null;
			}

			Element listadoEl = doc.createElement("listado");
			Boolean esPrimero = true;
			Element tecnicoEl = null;
			Element fichaEl = null;
			String tecnico = "";

			for (int i = 0; i < listaFichas.size(); i++) {
				TablaInformes laFila = new TablaInformes();
				laFila = (TablaInformes) listaFichas.get(i);
				if (esPrimero) {
					tecnicoEl = doc.createElement("TECNICO");
					tecnicoEl.setAttribute("dTecnico",
							laFila.getTecnico() == null ? "" : laFila
									.getTecnico().toString());
				}

				// Si es un nuevo Tecnico

				if (!tecnico.equals(laFila.getTecnico() != null ? laFila
						.getTecnico().toString() : "") && !esPrimero) {
					// es un nuevo tecnico. Cerramos los tag
					listadoEl.appendChild(tecnicoEl);

					tecnicoEl = doc.createElement("TECNICO");
					tecnicoEl.setAttribute("dTecnico",
							laFila.getTecnico() == null ? "" : laFila
									.getTecnico().toString());
				}

				fichaEl = doc.createElement("FICHA");
				fichaEl.setAttribute("dFicha", laFila.getIdficha() == null ? ""
						: laFila.getIdficha().toString());

				Element fechaReEl = doc.createElement("FECHAPREVISTA");
				String fechaReString = "";
				if (laFila.getFecha() != null) {
					fechaString = Aa20bFecha.getFecha(laFila.getFecha());
					diaSemana = laFila.getFecha().getDay() + 1;
					if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
						fechaReString = Aa20bFecha.convertirFechaCompletaEu(
								fechaString, diaSemana);
					} else {
						fechaReString = Aa20bFecha.convertirFechaCompleta(
								fechaString, diaSemana);
					}
				}
				fechaReEl.appendChild(doc
						.createTextNode(fechaReString == null ? " "
								: fechaReString));
				fichaEl.appendChild(fechaReEl);

				Element descFichaEl = doc.createElement("DESCRIPCIONFICHA");
				descFichaEl.appendChild(doc.createTextNode(laFila
						.getDescripcion() == null ? "" : laFila
						.getDescripcion()));
				fichaEl.appendChild(descFichaEl);

				Element edifEl = doc.createElement("EDIFICIO");
				String strEdificio = "";
				if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
					strEdificio = laFila.getEedificio() == null ? "" : laFila
							.getEedificio();
				} else {
					strEdificio = laFila.getCedificio() == null ? "" : laFila
							.getCedificio();
				}
				edifEl.appendChild(doc.createTextNode(strEdificio));
				fichaEl.appendChild(edifEl);

				Element zonaPlantaEl = doc.createElement("ZONAPLANTA");
				String strZonaPlanta = "";
				if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
					strZonaPlanta = (laFila.getEzona() == null ? "" : laFila
							.getEzona())
							+ "/"
							+ (laFila.getEplanta() == null ? "" : laFila
									.getEplanta());
				} else {
					strZonaPlanta = (laFila.getCzona() == null ? "" : laFila
							.getCzona())
							+ "/"
							+ (laFila.getCplanta() == null ? "" : laFila
									.getCplanta());
				}
				zonaPlantaEl.appendChild(doc.createTextNode(strZonaPlanta));
				fichaEl.appendChild(zonaPlantaEl);

				Element equipoEl = doc.createElement("EQUIPO");
				String strEquipo = "";
				if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
					strEquipo = laFila.getEmaquina() == null ? "" : laFila
							.getEmaquina();
				} else {
					strEquipo = laFila.getCmaquina() == null ? "" : laFila
							.getCmaquina();
				}
				equipoEl.appendChild(doc.createTextNode(strEquipo));
				fichaEl.appendChild(equipoEl);

				Element gamaEl = doc.createElement("GAMA");
				String strGama = "";
				if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
					strGama = laFila.getEgama() == null ? "" : laFila
							.getEgama();
				} else {
					strGama = laFila.getCgama() == null ? "" : laFila
							.getCgama();
				}
				gamaEl.appendChild(doc.createTextNode(strGama));
				fichaEl.appendChild(gamaEl);

				Element claseEl = doc.createElement("CLASE");
				String strClase = "";
				if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
					strClase = laFila.getEclase() == null ? "" : laFila
							.getEclase();
				} else {
					strClase = laFila.getCclase() == null ? "" : laFila
							.getCclase();
				}
				claseEl.appendChild(doc.createTextNode(strClase));
				fichaEl.appendChild(claseEl);

				Element mCodigoEl = doc.createElement("MCODIGO");
				mCodigoEl
						.appendChild(doc
								.createTextNode(laFila.getCcodigo() == null ? ""
										: laFila.getCcodigo()));
				fichaEl.appendChild(mCodigoEl);

				Element fechaEjEl = doc.createElement("FECHAEJEC");
				String fechaEjString = "";
				if (laFila.getFeejec() != null) {
					fechaString = Aa20bFecha.getFecha(laFila.getFeejec());
					diaSemana = laFila.getFeejec().getDay() + 1;
					if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
						fechaEjString = Aa20bFecha.convertirFechaCompletaEu(
								fechaString, diaSemana);
					} else {
						fechaEjString = Aa20bFecha.convertirFechaCompleta(
								fechaString, diaSemana);
					}
				}
				fechaEjEl.appendChild(doc
						.createTextNode(fechaEjString == null ? " "
								: fechaEjString));
				fichaEl.appendChild(fechaEjEl);

				Element mTiempoRealEl = doc.createElement("TIEMPOREAL");
				mTiempoRealEl.appendChild(doc.createTextNode(laFila
						.getTiemporeal() == null ? "" : laFila.getTiemporeal()
						.toString()));
				fichaEl.appendChild(mTiempoRealEl);

				Element ejecutadoEl = doc.createElement("EJECUTADO");
				String strEjecutado = "";
				if (laFila.getEjecutado() != null) {
					if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
						if (laFila.getEjecutado().equals("1")) {
							strEjecutado = "BAI";
						} else {
							strEjecutado = "EZ";
						}
					} else {
						if (laFila.getEjecutado().equals("1")) {
							strEjecutado = "SI";
						} else {
							strEjecutado = "NO";
						}
					}
				}
				ejecutadoEl.appendChild(doc.createTextNode(strEjecutado));
				fichaEl.appendChild(ejecutadoEl);

				Element observEl = doc.createElement("OBSERVACIONES");
				observEl.appendChild(doc.createTextNode(laFila
						.getObservaciones() == null ? "" : laFila
						.getObservaciones()));
				fichaEl.appendChild(observEl);

				// Cerrar el TECNICO
				tecnicoEl.appendChild(fichaEl);

				tecnico = laFila.getTecnico() != null ? laFila.getTecnico()
						.toString() : "";
				esPrimero = false;
				// Preventivos.logger.info("1xml DiarioFichas: "
				// + nodeToString(tecnicoEl));

			}
			tecnicoEl.appendChild(fichaEl);
			listadoEl.appendChild(tecnicoEl);
			rootElement.appendChild(listadoEl);

			// return doc;
			// del for de listaGrupos

		} catch (Exception e) {
			Preventivos.logger.info("error xml DiarioFichas: ");

			for (StackTraceElement b : e.getStackTrace()) {
				Preventivos.logger.info(b.toString());
			}

		}
		// Preventivos.logger.info("xml DiarioFichas: "
		// + nodeToString(rootElement));

		return doc;

	}

	/* Imprimir Fichas Ejecutadas */
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public Document getFoFichasEjecutadasXml(HttpServletRequest request,
			Locale locale, ArrayList listaFichas, Ficha filtro) {
		Preventivos.logger.info("getFoPreventivosXml");

		String idioma = locale.getLanguage();
		Integer numeroDeFilas = 0;

		Document doc = null;
		Element rootElement = null;
		try {
			DocumentBuilderFactory docFactory = DocumentBuilderFactory
					.newInstance();

			DocumentBuilder docBuilder = docFactory.newDocumentBuilder();

			// root elements

			doc = docBuilder.newDocument();
			rootElement = doc.createElement("report");
			doc.appendChild(rootElement);

			/* INSERTAMOS EL FILTRO Num ficha */
			Element fNFicha = doc.createElement("filtroNFicha");
			rootElement.appendChild(fNFicha);
			if (filtro.getIdficha() != null) {
				fNFicha.appendChild(doc.createTextNode(filtro.getIdficha()
						.equals("") ? " " : filtro.getIdficha().toString()));
			} else {
				fNFicha.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO Num Ficha */

			/* INSERTAMOS EL FILTRO FECHA DESDE */
			Element fFdesde = doc.createElement("filtroFDesde");
			String fechaDesdeString = " ";
			rootElement.appendChild(fFdesde);
			if (filtro.getFechaD() != null) {
				fechaDesdeString = Aa20bFormatoFecha.date2String(
						filtro.getFechaD(), locale);
				fFdesde.appendChild(doc.createTextNode(fechaDesdeString));
			} else {
				fFdesde.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO FECHA DESDE */

			/* INSERTAMOS EL FILTRO FECHA HASTA */
			Element fFhasta = doc.createElement("filtroFHasta");
			String fechaHastaString = " ";
			rootElement.appendChild(fFhasta);
			if (filtro.getFechaH() != null) {
				fechaHastaString = Aa20bFormatoFecha.date2String(
						filtro.getFechaH(), locale);
				fFhasta.appendChild(doc.createTextNode(fechaHastaString));
			} else {
				fFhasta.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO FECHA HASTA */

			/* INSERTAMOS EL FILTRO FECHA PLANIF DESDE */
			Element fFplanifdesde = doc.createElement("filtroFplanifDesde");
			String fechaplanifDesdeString = " ";
			rootElement.appendChild(fFplanifdesde);
			if (filtro.getFechaplanifD() != null) {
				fechaplanifDesdeString = Aa20bFormatoFecha.date2String(
						filtro.getFechaplanifD(), locale);
				fFplanifdesde.appendChild(doc
						.createTextNode(fechaplanifDesdeString));
			} else {
				fFplanifdesde.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO FECHA PLANIF DESDE */

			/* INSERTAMOS EL FILTRO FECHA PLANIF HASTA */
			Element fFplanifhasta = doc.createElement("filtroFplanifHasta");
			String fechaplanifHastaString = " ";
			rootElement.appendChild(fFplanifhasta);
			if (filtro.getFechaplanifH() != null) {
				fechaplanifHastaString = Aa20bFormatoFecha.date2String(
						filtro.getFechaplanifH(), locale);
				fFplanifhasta.appendChild(doc
						.createTextNode(fechaplanifHastaString));
			} else {
				fFplanifhasta.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO FECHA PLANIF HASTA */

			/* INSERTAMOS EL FILTRO DE EDIFICIO */
			Element fEdificio = doc.createElement("filtroEdificio");
			String strFEdificio = "";
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				if (filtro.getMaquina() != null
						&& filtro.getMaquina().getEdificio() != null) {
					strFEdificio = filtro.getMaquina().getEdificio()
							.getEedificio() == null ? "" : filtro.getMaquina()
							.getEdificio().getEedificio();
				}
			} else {
				if (filtro.getMaquina() != null
						&& filtro.getMaquina().getEdificio() != null) {
					strFEdificio = filtro.getMaquina().getEdificio()
							.getCedificio() == null ? "" : filtro.getMaquina()
							.getEdificio().getCedificio();
				}
			}
			rootElement.appendChild(fEdificio);
			fEdificio.appendChild(doc.createTextNode(strFEdificio));
			/* FIN EL FILTRO DE EDIFICIO */

			/* INSERTAMOS EL FILTRO ZONA */
			Element fZona = doc.createElement("filtroZona");
			rootElement.appendChild(fZona);
			if (filtro.getMaquina() != null
					&& filtro.getMaquina().getZona() != null
					&& filtro.getMaquina().getZona().getCzona() != null) {
				fZona.appendChild(doc.createTextNode(filtro.getMaquina()
						.getZona().getCzona().equals("") ? " " : filtro
						.getMaquina().getZona().getCzona()));
			} else {
				fZona.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO ZONA */

			/* INSERTAMOS EL FILTRO PLANTA */
			Element fPlanta = doc.createElement("filtroPlanta");
			rootElement.appendChild(fPlanta);
			if (filtro.getMaquina() != null
					&& filtro.getMaquina().getPlanta() != null
					&& filtro.getMaquina().getPlanta().getCplanta() != null) {
				fPlanta.appendChild(doc.createTextNode(filtro.getMaquina()
						.getPlanta().getCplanta().equals("") ? " " : filtro
						.getMaquina().getPlanta().getCplanta()));
			} else {
				fPlanta.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO PLANTA */

			/* INSERTAMOS EL FILTRO MCODIGO */
			Element fMCodigo = doc.createElement("filtroMCodigo");
			rootElement.appendChild(fMCodigo);
			if (filtro.getMaquina() != null && filtro.getMaquina() != null
					&& filtro.getMaquina().getMcodigo() != null) {
				fMCodigo.appendChild(doc.createTextNode(filtro.getMaquina()
						.getMcodigo().equals("") ? " " : filtro.getMaquina()
						.getMcodigo()));
			} else {
				fMCodigo.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO MCODIGO */

			/* INSERTAMOS EL FILTRO EQUIPO */
			Element fEquipo = doc.createElement("filtroEquipo");
			rootElement.appendChild(fEquipo);
			if (filtro.getMaquina() != null && filtro.getMaquina() != null
					&& filtro.getMaquina().getCmaquina() != null) {
				fEquipo.appendChild(doc.createTextNode(filtro.getMaquina()
						.getCmaquina().equals("") ? " " : filtro.getMaquina()
						.getCmaquina()));
			} else {
				fEquipo.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO EQUIPO */

			/* INSERTAMOS EL FILTRO TECNICOS */
			Element fTecnico = doc.createElement("filtroTecnico");
			rootElement.appendChild(fTecnico);
			if (filtro.getTecnicos() != null) {
				fTecnico.appendChild(doc.createTextNode(filtro.getTecnicos()
						.equals("") ? " " : filtro.getTecnicos()));
			} else {
				fTecnico.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO EQUIPO */

			/* INSERTAMOS EL FILTRO GAMA */
			Element fgama = doc.createElement("filtroGama");
			rootElement.appendChild(fgama);
			if (filtro.getMaquina() != null
					&& filtro.getMaquina().getGama() != null
					&& filtro.getMaquina().getGama().getCgama() != null) {
				fgama.appendChild(doc.createTextNode(filtro.getMaquina()
						.getGama().getCgama().equals("") ? " " : filtro
						.getMaquina().getGama().getCgama()));
			} else {
				fgama.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO GAMA */

			/* INSERTAMOS EL FILTRO EJECUTADOS */
			Element fEjecutado = doc.createElement("filtroEjecutados");
			rootElement.appendChild(fEjecutado);
			if (filtro.getEjecutado() != null) {
				fEjecutado.appendChild(doc.createTextNode(filtro.getEjecutado()
						.equals("1") ? "Si" : " "));
			} else {
				fEjecutado.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO EJECUTADOS */

			/* INSERTAMOS EL FILTRO PARADOS */
			Element fParado = doc.createElement("filtroParados");
			rootElement.appendChild(fParado);
			if (filtro.getParado() != null) {
				fParado.appendChild(doc.createTextNode(filtro.getParado()
						.equals("1") ? "Si" : " "));
			} else {
				fParado.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO PARADOS */

			/* INSERTAMOS EL FILTRO PENDIENTES DE EJECUTAR */
			Element fPendEjec = doc.createElement("filtroPendEjecutar");
			rootElement.appendChild(fPendEjec);
			if (filtro.getPendEjec() != null) {
				fPendEjec.appendChild(doc.createTextNode(filtro.getPendEjec()
						.equals("1") ? "Si" : " "));
			} else {
				fPendEjec.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO PENDIENTES DE EJECUTAR */

			/* INSERTAMOS EL FILTRO con/sin TECNICOS */
			Element fTecAsig = doc.createElement("filtroConSinTecnicos");
			rootElement.appendChild(fTecAsig);
			if (filtro.getConTecnicos() != null
					&& !filtro.getConTecnicos().equals("")) {
				fTecAsig.appendChild(doc.createTextNode(filtro.getConTecnicos()
						.equals("1") ? "Si" : "No"));
			} else {
				fTecAsig.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO con/sin TECNICOS */

			/* INSERTAMOS LA FECHA DE HOY A LA RAIZ */
			Element fechaHoyEl = doc.createElement("fechaHoy");

			java.util.Date fechaHoy = new Date();

			String fechaString = Aa20bFecha.getFecha(fechaHoy);
			Integer diaSemana = fechaHoy.getDay() + 1;
			String fechaHoyString = "";
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				fechaHoyString = Aa20bFecha.convertirFechaCompletaEu(
						fechaString, diaSemana);

			} else {
				fechaHoyString = Aa20bFecha.convertirFechaCompleta(fechaString,
						diaSemana);
			}

			rootElement.appendChild(fechaHoyEl);
			fechaHoyEl.appendChild(doc
					.createTextNode(fechaHoyString == null ? " "
							: fechaHoyString));
			/* FIN INSERTAR FECHA DE HOY */

			// Element listadoEl = doc.createElement("listado");
			// Rellenamos una registro a vacios en caso de que no haya
			// resultados para poder montar el xml y así no nos dé error el pdf
			if (listaFichas.size() == 0) {
				TablaInformes tablaVacia = new TablaInformes();
				tablaVacia.setIdficha(0);
				tablaVacia.setIdmaquina((long) 0);
				listaFichas.add(tablaVacia);
			} else {
				numeroDeFilas = listaFichas.size();
			}

			/*
			 * NUMFILAS - INSERTAMOS contador de filas para que no se pinte la
			 * tabla si no hay datos
			 */
			Element numFilasEl = doc.createElement("numFilas");
			rootElement.appendChild(numFilasEl);
			numFilasEl.appendChild(doc.createTextNode(Integer
					.toString(numeroDeFilas)));
			/* FIN NUMFILAS */

			if (listaFichas.size() > 0) {

			} else {

				return null;
			}

			Element listadoEl = doc.createElement("listado");
			Boolean esPrimero = true;
			Element fichaEl = null;
			Element tecnicosEl = null;
			Element ejecutadoEl = null;
			Integer nContFichas = 0;
			Long nTotalMinutos = (long) 0;
			String sTotalMinutos = "";
			String tecnico = "";

			for (int i = 0; i < listaFichas.size(); i++) {
				// Añadimos los de Operaciones

				TablaInformes laFila = new TablaInformes();
				laFila = (TablaInformes) listaFichas.get(i);

				if (esPrimero) {
					tecnicosEl = doc.createElement("TECNICOS");
					tecnicosEl.setAttribute(
							"NOMBRE",
							laFila.getTecnico() == null ? "" : laFila
									.getTecnico());
				}

				// Si es un nuevo tecnico
				if (!tecnico.equals(laFila.getTecnico() == null ? "" : laFila
						.getTecnico().toString()) && !esPrimero) {
					tecnicosEl.setAttribute("CONTFICHAS",
							nContFichas.toString());

					sTotalMinutos = nTotalMinutos == 0 ? "0" : nTotalMinutos
							/ 60
							+ ":"
							+ StringUtils.lpad("" + (nTotalMinutos % 60), '0',
									2);

					tecnicosEl.setAttribute("TIEMPOTECNICO", sTotalMinutos);
					listadoEl.appendChild(tecnicosEl);

					tecnicosEl = doc.createElement("TECNICOS");
					tecnicosEl.setAttribute(
							"NOMBRE",
							laFila.getTecnico() == null ? "" : laFila
									.getTecnico());

					// Iniciar el contador de partes Y subtotal tiempo tecnico
					nContFichas = 0;
					nTotalMinutos = (long) 0;
				}
				nContFichas++;

				fichaEl = doc.createElement("FICHA");
				fichaEl.setAttribute("NUMERO", laFila.getIdficha() == null ? ""
						: laFila.getIdficha().toString());

				// Fecha máxima de ejecución de la ficha
				Element fechaReEl = doc.createElement("FEEJEC");
				String fechaEjec = " ";
				if (laFila.getFecre() != null) {
					fechaEjec = Aa20bFecha.getFechaFormateada(
							laFila.getFecre(), locale);
				}
				fechaReEl.appendChild(doc.createTextNode(fechaEjec));
				fichaEl.appendChild(fechaReEl);

				// Fecha máxima de ejecución de la ficha para el técnico
				Element fechaEjecTecEl = doc.createElement("FEEJECTECNICO");
				String fechaEjecTec = " ";
				if (laFila.getFeejec() != null) {
					fechaEjecTec = Aa20bFecha.getFechaFormateada(
							laFila.getFeejec(), locale);
				}
				fechaEjecTecEl.appendChild(doc.createTextNode(fechaEjecTec));
				fichaEl.appendChild(fechaEjecTecEl);

				// EQUIPO
				Element equipoEl = doc.createElement("EQUIPO");
				String strEquipo = "";
				if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
					strEquipo = laFila.getEmaquina() == null ? "" : laFila
							.getEmaquina();
				} else {
					strEquipo = laFila.getCmaquina() == null ? "" : laFila
							.getCmaquina();
				}
				equipoEl.appendChild(doc.createTextNode(strEquipo));
				fichaEl.appendChild(equipoEl);

				Element mCodigoEl = doc.createElement("MCODIGO");
				mCodigoEl
						.appendChild(doc
								.createTextNode(laFila.getCcodigo() == null ? ""
										: laFila.getCcodigo()));
				fichaEl.appendChild(mCodigoEl);

				Element tiempoTecFichaEl = doc.createElement("TIEMPOTECFICHA");
				tiempoTecFichaEl.appendChild(doc.createTextNode(laFila
						.getTiempo() == null ? "" : laFila.getTiempo()
						/ 60
						+ ":"
						+ StringUtils.lpad("" + (laFila.getTiempo() % 60), '0',
								2)));

				nTotalMinutos += laFila.getTiempo() == null ? 0 : laFila
						.getTiempo();
				fichaEl.appendChild(tiempoTecFichaEl);

				Element tiempoFichaEl = doc.createElement("TIEMPOFICHA");
				tiempoFichaEl.appendChild(doc.createTextNode(laFila
						.getTiemporeal() == null ? "" : laFila.getTiemporeal()
						/ 60
						+ ":"
						+ StringUtils.lpad("" + (laFila.getTiemporeal() % 60),
								'0', 2)));
				fichaEl.appendChild(tiempoFichaEl);

				// Ejecutado
				ejecutadoEl = doc.createElement("EJECUTADO");
				ejecutadoEl.appendChild(doc.createTextNode(laFila
						.getEjecutado() != null
						&& laFila.getEjecutado().equals("1") ? "Si" : "No"));
				fichaEl.appendChild(ejecutadoEl);

				tecnicosEl.appendChild(fichaEl);

				// Si es el último registro
				if ((i + 1) == listaFichas.size()) {
					tecnicosEl.setAttribute("CONTFICHAS",
							nContFichas.toString());
					sTotalMinutos = nTotalMinutos == 0 ? "0" : nTotalMinutos
							/ 60
							+ ":"
							+ StringUtils.lpad("" + (nTotalMinutos % 60), '0',
									2);

					tecnicosEl.setAttribute("TIEMPOTECNICO", sTotalMinutos);
					listadoEl.appendChild(tecnicosEl);
				}

				tecnico = laFila.getTecnico() == null ? "" : laFila
						.getTecnico().toString();
				esPrimero = false;

				// Preventivos.logger.info("1xml Preventivos: "
				// + nodeToString(listadoEl));

			}
			listadoEl.appendChild(tecnicosEl);
			rootElement.appendChild(listadoEl);

			// return doc;
			// del for de listaGrupos

		} catch (Exception e) {
			Preventivos.logger.info("eror xml getFoFichasEjecutadasXml: ");
		}
		// Preventivos.logger.info("xml getFoFichasEjecutadasXml: "
		// + nodeToString(rootElement));

		return doc;

	}

	/* Imprimir Fichas Ejecutadas */
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public Document getFoFichasEjecutadasDetalleXml(HttpServletRequest request,
			Locale locale, ArrayList listaFichas, Ficha filtro) {
		Preventivos.logger.info("getFoFichasEjecutadasDetalleXml");

		String idioma = locale.getLanguage();
		Integer numeroDeFilas = 0;

		Document doc = null;
		Element rootElement = null;
		try {
			DocumentBuilderFactory docFactory = DocumentBuilderFactory
					.newInstance();

			DocumentBuilder docBuilder = docFactory.newDocumentBuilder();

			// root elements

			doc = docBuilder.newDocument();
			rootElement = doc.createElement("report");
			doc.appendChild(rootElement);

			/* INSERTAMOS EL FILTRO Num ficha */
			Element fNFicha = doc.createElement("filtroNFicha");
			rootElement.appendChild(fNFicha);
			if (filtro.getIdficha() != null) {
				fNFicha.appendChild(doc.createTextNode(filtro.getIdficha()
						.equals("") ? " " : filtro.getIdficha().toString()));
			} else {
				fNFicha.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO Num Ficha */

			/* INSERTAMOS EL FILTRO FECHA DESDE */
			Element fFdesde = doc.createElement("filtroFDesde");
			String fechaDesdeString = " ";
			rootElement.appendChild(fFdesde);
			if (filtro.getFechaD() != null) {
				fechaDesdeString = Aa20bFormatoFecha.date2String(
						filtro.getFechaD(), locale);
				fFdesde.appendChild(doc.createTextNode(fechaDesdeString));
			} else {
				fFdesde.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO FECHA DESDE */

			/* INSERTAMOS EL FILTRO FECHA HASTA */
			Element fFhasta = doc.createElement("filtroFHasta");
			String fechaHastaString = " ";
			rootElement.appendChild(fFhasta);
			if (filtro.getFechaH() != null) {
				fechaHastaString = Aa20bFormatoFecha.date2String(
						filtro.getFechaH(), locale);
				fFhasta.appendChild(doc.createTextNode(fechaHastaString));
			} else {
				fFhasta.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO FECHA HASTA */

			/* INSERTAMOS EL FILTRO FECHA PLANIF DESDE */
			Element fFplanifdesde = doc.createElement("filtroFplanifDesde");
			String fechaplanifDesdeString = " ";
			rootElement.appendChild(fFplanifdesde);
			if (filtro.getFechaplanifD() != null) {
				fechaplanifDesdeString = Aa20bFormatoFecha.date2String(
						filtro.getFechaplanifD(), locale);
				fFplanifdesde.appendChild(doc
						.createTextNode(fechaplanifDesdeString));
			} else {
				fFplanifdesde.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO FECHA PLANIF DESDE */

			/* INSERTAMOS EL FILTRO FECHA PLANIF HASTA */
			Element fFplanifhasta = doc.createElement("filtroFplanifHasta");
			String fechaplanifHastaString = " ";
			rootElement.appendChild(fFplanifhasta);
			if (filtro.getFechaplanifH() != null) {
				fechaplanifHastaString = Aa20bFormatoFecha.date2String(
						filtro.getFechaplanifH(), locale);
				fFplanifhasta.appendChild(doc
						.createTextNode(fechaplanifHastaString));
			} else {
				fFplanifhasta.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO FECHA PLANIF HASTA */

			/* INSERTAMOS EL FILTRO DE EDIFICIO */
			Element fEdificio = doc.createElement("filtroEdificio");
			String strFEdificio = "";
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				if (filtro.getMaquina() != null
						&& filtro.getMaquina().getEdificio() != null) {
					strFEdificio = filtro.getMaquina().getEdificio()
							.getEedificio() == null ? "" : filtro.getMaquina()
							.getEdificio().getEedificio();
				}
			} else {
				if (filtro.getMaquina() != null
						&& filtro.getMaquina().getEdificio() != null) {
					strFEdificio = filtro.getMaquina().getEdificio()
							.getCedificio() == null ? "" : filtro.getMaquina()
							.getEdificio().getCedificio();
				}
			}
			rootElement.appendChild(fEdificio);
			fEdificio.appendChild(doc.createTextNode(strFEdificio));
			/* FIN EL FILTRO DE EDIFICIO */

			/* INSERTAMOS EL FILTRO ZONA */
			Element fZona = doc.createElement("filtroZona");
			rootElement.appendChild(fZona);
			if (filtro.getMaquina() != null
					&& filtro.getMaquina().getZona() != null
					&& filtro.getMaquina().getZona().getCzona() != null) {
				fZona.appendChild(doc.createTextNode(filtro.getMaquina()
						.getZona().getCzona().equals("") ? " " : filtro
						.getMaquina().getZona().getCzona()));
			} else {
				fZona.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO ZONA */

			/* INSERTAMOS EL FILTRO PLANTA */
			Element fPlanta = doc.createElement("filtroPlanta");
			rootElement.appendChild(fPlanta);
			if (filtro.getMaquina() != null
					&& filtro.getMaquina().getPlanta() != null
					&& filtro.getMaquina().getPlanta().getCplanta() != null) {
				fPlanta.appendChild(doc.createTextNode(filtro.getMaquina()
						.getPlanta().getCplanta().equals("") ? " " : filtro
						.getMaquina().getPlanta().getCplanta()));
			} else {
				fPlanta.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO PLANTA */

			/* INSERTAMOS EL FILTRO MCODIGO */
			Element fMCodigo = doc.createElement("filtroMCodigo");
			rootElement.appendChild(fMCodigo);
			if (filtro.getMaquina() != null && filtro.getMaquina() != null
					&& filtro.getMaquina().getMcodigo() != null) {
				fMCodigo.appendChild(doc.createTextNode(filtro.getMaquina()
						.getMcodigo().equals("") ? " " : filtro.getMaquina()
						.getMcodigo()));
			} else {
				fMCodigo.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO MCODIGO */

			/* INSERTAMOS EL FILTRO EQUIPO */
			Element fEquipo = doc.createElement("filtroEquipo");
			rootElement.appendChild(fEquipo);
			if (filtro.getMaquina() != null && filtro.getMaquina() != null
					&& filtro.getMaquina().getCmaquina() != null) {
				fEquipo.appendChild(doc.createTextNode(filtro.getMaquina()
						.getCmaquina().equals("") ? " " : filtro.getMaquina()
						.getCmaquina()));
			} else {
				fEquipo.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO EQUIPO */

			/* INSERTAMOS EL FILTRO TECNICOS */
			Element fTecnico = doc.createElement("filtroTecnico");
			rootElement.appendChild(fTecnico);
			if (filtro.getTecnicos() != null) {
				fTecnico.appendChild(doc.createTextNode(filtro.getTecnicos()
						.equals("") ? " " : filtro.getTecnicos()));
			} else {
				fTecnico.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO EQUIPO */

			/* INSERTAMOS EL FILTRO GAMA */
			Element fgama = doc.createElement("filtroGama");
			rootElement.appendChild(fgama);
			if (filtro.getMaquina() != null
					&& filtro.getMaquina().getGama() != null
					&& filtro.getMaquina().getGama().getCgama() != null) {
				fgama.appendChild(doc.createTextNode(filtro.getMaquina()
						.getGama().getCgama().equals("") ? " " : filtro
						.getMaquina().getGama().getCgama()));
			} else {
				fgama.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO GAMA */

			/* INSERTAMOS EL FILTRO EJECUTADOS */
			Element fEjecutado = doc.createElement("filtroEjecutados");
			rootElement.appendChild(fEjecutado);
			if (filtro.getEjecutado() != null) {
				fEjecutado.appendChild(doc.createTextNode(filtro.getEjecutado()
						.equals("1") ? "Si" : " "));
			} else {
				fEjecutado.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO EJECUTADOS */

			/* INSERTAMOS EL FILTRO PARADOS */
			Element fParado = doc.createElement("filtroParados");
			rootElement.appendChild(fParado);
			if (filtro.getParado() != null) {
				fParado.appendChild(doc.createTextNode(filtro.getParado()
						.equals("1") ? "Si" : " "));
			} else {
				fParado.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO PARADOS */

			/* INSERTAMOS EL FILTRO PENDIENTES DE EJECUTAR */
			Element fPendEjec = doc.createElement("filtroPendEjecutar");
			rootElement.appendChild(fPendEjec);
			if (filtro.getPendEjec() != null) {
				fPendEjec.appendChild(doc.createTextNode(filtro.getPendEjec()
						.equals("1") ? "Si" : " "));
			} else {
				fPendEjec.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO PENDIENTES DE EJECUTAR */

			/* INSERTAMOS EL FILTRO con/sin TECNICOS */
			Element fTecAsig = doc.createElement("filtroConSinTecnicos");
			rootElement.appendChild(fTecAsig);
			if (filtro.getConTecnicos() != null
					&& !filtro.getConTecnicos().equals("")) {
				fTecAsig.appendChild(doc.createTextNode(filtro.getConTecnicos()
						.equals("1") ? "Si" : "No"));
			} else {
				fTecAsig.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO con/sin TECNICOS */

			/* INSERTAMOS LA FECHA DE HOY A LA RAIZ */
			Element fechaHoyEl = doc.createElement("fechaHoy");

			java.util.Date fechaHoy = new Date();

			String fechaString = Aa20bFecha.getFecha(fechaHoy);
			Integer diaSemana = fechaHoy.getDay() + 1;
			String fechaHoyString = "";
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				fechaHoyString = Aa20bFecha.convertirFechaCompletaEu(
						fechaString, diaSemana);

			} else {
				fechaHoyString = Aa20bFecha.convertirFechaCompleta(fechaString,
						diaSemana);
			}

			rootElement.appendChild(fechaHoyEl);
			fechaHoyEl.appendChild(doc
					.createTextNode(fechaHoyString == null ? " "
							: fechaHoyString));
			/* FIN INSERTAR FECHA DE HOY */

			// Element listadoEl = doc.createElement("listado");
			// Rellenamos una registro a vacios en caso de que no haya
			// resultados para poder montar el xml y así no nos dé error el pdf
			if (listaFichas.size() == 0) {
				TablaInformes tablaVacia = new TablaInformes();
				tablaVacia.setIdficha(0);
				tablaVacia.setIdmaquina((long) 0);
				listaFichas.add(tablaVacia);
			} else {
				numeroDeFilas = listaFichas.size();
			}

			/*
			 * NUMFILAS - INSERTAMOS contador de filas para que no se pinte la
			 * tabla si no hay datos
			 */
			Element numFilasEl = doc.createElement("numFilas");
			rootElement.appendChild(numFilasEl);
			numFilasEl.appendChild(doc.createTextNode(Integer
					.toString(numeroDeFilas)));
			/* FIN NUMFILAS */

			if (listaFichas.size() > 0) {

			} else {

				return null;
			}

			Element listadoEl = doc.createElement("listado");
			Boolean esPrimero = true;
			Element fichaEl = null;
			Element fechaEjecucionEl = null;
			Element ejecutadoEl = null;
			Integer nContFichas = 0;
			Long nTotalMinutos = (long) 0;
			String sTotalMinutos = "";
			String fechaEjecMaxTecnico = "";

			for (int i = 0; i < listaFichas.size(); i++) {
				// Añadimos los de Operaciones

				TablaInformes laFila = new TablaInformes();
				laFila = (TablaInformes) listaFichas.get(i);

				if (esPrimero) {
					fechaEjecucionEl = doc.createElement("FECHASEJECUCION");
					String fechaEjecTec = " ";
					if (laFila.getFeejec() != null) {
						fechaEjecTec = Aa20bFecha.getFechaFormateada(
								laFila.getFeejec(), locale);
					}
					fechaEjecucionEl
							.setAttribute("FEEJECTECNICO", fechaEjecTec);
				}

				// Si es un nueva fecha de ejecucion de tecnico y ficha
				if (!fechaEjecMaxTecnico.equals(laFila.getFeejec() == null ? ""
						: laFila.getFeejec().toString()) && !esPrimero) {
					fechaEjecucionEl.setAttribute("CONTFICHAS",
							nContFichas.toString());

					sTotalMinutos = nTotalMinutos == 0 ? "0" : nTotalMinutos
							/ 60
							+ ":"
							+ StringUtils.lpad("" + (nTotalMinutos % 60), '0',
									2);

					fechaEjecucionEl.setAttribute("TIEMPOTECNICO",
							sTotalMinutos);
					listadoEl.appendChild(fechaEjecucionEl);

					fechaEjecucionEl = doc.createElement("FECHASEJECUCION");
					String fechaEjecTec = " ";
					if (laFila.getFeejec() != null) {
						fechaEjecTec = Aa20bFecha.getFechaFormateada(
								laFila.getFeejec(), locale);
					}
					fechaEjecucionEl
							.setAttribute("FEEJECTECNICO", fechaEjecTec);

					// Iniciar el contador de partes Y subtotal tiempo tecnico
					nContFichas = 0;
					nTotalMinutos = (long) 0;
				}
				nContFichas++;

				fichaEl = doc.createElement("FICHA");
				fichaEl.setAttribute("NUMERO", laFila.getIdficha() == null ? ""
						: laFila.getIdficha().toString());

				// EQUIPO
				Element equipoEl = doc.createElement("EQUIPO");
				String strEquipo = "";
				if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
					strEquipo = laFila.getEmaquina() == null ? "" : laFila
							.getEmaquina();
				} else {
					strEquipo = laFila.getCmaquina() == null ? "" : laFila
							.getCmaquina();
				}
				equipoEl.appendChild(doc.createTextNode(strEquipo));
				fichaEl.appendChild(equipoEl);

				// CODIGO DE EQUIPO
				Element mCodigoEl = doc.createElement("MCODIGO");
				mCodigoEl
						.appendChild(doc
								.createTextNode(laFila.getCcodigo() == null ? ""
										: laFila.getCcodigo()));
				fichaEl.appendChild(mCodigoEl);

				// TECNICO
				Element mTecnicoEl = doc.createElement("TECNICO");
				mTecnicoEl
						.appendChild(doc
								.createTextNode(laFila.getTecnico() == null ? ""
										: laFila.getTecnico()));
				fichaEl.appendChild(mTecnicoEl);

				// TIEMPO EJECUCION FICHA TECNICO
				Element tiempoTecFichaEl = doc.createElement("TIEMPOTECFICHA");
				tiempoTecFichaEl.appendChild(doc.createTextNode(laFila
						.getTiempo() == null ? "" : laFila.getTiempo()
						/ 60
						+ ":"
						+ StringUtils.lpad("" + (laFila.getTiempo() % 60), '0',
								2)));

				nTotalMinutos += laFila.getTiempo() == null ? 0 : laFila
						.getTiempo();
				fichaEl.appendChild(tiempoTecFichaEl);

				Element tiempoFichaEl = doc.createElement("TIEMPOFICHA");
				tiempoFichaEl.appendChild(doc.createTextNode(laFila
						.getTiemporeal() == null ? "" : laFila.getTiemporeal()
						/ 60
						+ ":"
						+ StringUtils.lpad("" + (laFila.getTiemporeal() % 60),
								'0', 2)));
				fichaEl.appendChild(tiempoFichaEl);

				// Ejecutado
				ejecutadoEl = doc.createElement("EJECUTADO");
				ejecutadoEl.appendChild(doc.createTextNode(laFila
						.getEjecutado() != null
						&& laFila.getEjecutado().equals("1") ? "Si" : "No"));
				fichaEl.appendChild(ejecutadoEl);

				fechaEjecucionEl.appendChild(fichaEl);

				// Si es el último registro
				if ((i + 1) == listaFichas.size()) {
					fechaEjecucionEl.setAttribute("CONTFICHAS",
							nContFichas.toString());
					sTotalMinutos = nTotalMinutos == 0 ? "0" : nTotalMinutos
							/ 60
							+ ":"
							+ StringUtils.lpad("" + (nTotalMinutos % 60), '0',
									2);

					fechaEjecucionEl.setAttribute("TIEMPOTECNICO",
							sTotalMinutos);
					listadoEl.appendChild(fechaEjecucionEl);
				}

				fechaEjecMaxTecnico = laFila.getFeejec() == null ? "" : laFila
						.getFeejec().toString();
				esPrimero = false;

				// Preventivos.logger.info("1xml Preventivos: "
				// + nodeToString(listadoEl));

			}
			listadoEl.appendChild(fechaEjecucionEl);
			rootElement.appendChild(listadoEl);

			// return doc;
			// del for de listaGrupos

		} catch (Exception e) {
			Preventivos.logger
					.info("eror xml getFoFichasEjecutadasDetalleXml: ");
		}
		// Preventivos.logger.info("xml getFoFichasEjecutadasDetalleXml: "
		// + nodeToString(rootElement));

		return doc;

	}

	@SuppressWarnings("unused")
	private String nodeToString(Node node) {// element

		StringWriter sw = new StringWriter();

		try {

			Transformer t = TransformerFactory.newInstance().newTransformer();

			t.setOutputProperty(OutputKeys.ENCODING, "ISO-8859-1");

			t.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION, "no");

			t.setOutputProperty(OutputKeys.INDENT, "yes");

			t.transform(new DOMSource(node), new StreamResult(sw));

		} catch (TransformerException te) {

		}

		return sw.toString();

	}

}
