package com.ejie.aa20b.informes.listados;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import com.ejie.aa20b.classes.Aa20bFecha;
import com.ejie.aa20b.classes.Aa20bFormatoFecha;
import com.ejie.aa20b.model.Ficha;
import com.ejie.aa20b.model.TablaInformes;
import com.ejie.aa20b.util.Aa20bConstantes;

public class PrevPendAsignar {
	private static final Logger logger = LoggerFactory
			.getLogger(PrevPendAsignar.class);

	/* Imprimir */
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public Document getFoPrevPendAsignarXml(HttpServletRequest request,
			Locale locale, ArrayList listaFichas, Ficha filtro) {
		PrevPendAsignar.logger.info("getFoPrevPendAsignarXml");

		String idioma = locale.getLanguage();

		Document doc = null;
		Element rootElement = null;
		try {
			DocumentBuilderFactory docFactory = DocumentBuilderFactory
					.newInstance();

			DocumentBuilder docBuilder = docFactory.newDocumentBuilder();

			// root elements

			doc = docBuilder.newDocument();
			rootElement = doc.createElement("report");
			doc.appendChild(rootElement);

			/* INSERTAMOS EL FILTRO Num ficha */
			Element fNFicha = doc.createElement("filtroNFicha");
			rootElement.appendChild(fNFicha);
			if (filtro.getIdficha() != null) {
				fNFicha.appendChild(doc.createTextNode(filtro.getIdficha()
						.equals("") ? " " : filtro.getIdficha().toString()));
			} else {
				fNFicha.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO Num Ficha */

			/* INSERTAMOS EL FILTRO FECHA DESDE */
			Element fFdesde = doc.createElement("filtroFDesde");
			String fechaDesdeString = " ";
			rootElement.appendChild(fFdesde);
			if (filtro.getFechaD() != null) {
				fechaDesdeString = Aa20bFormatoFecha.date2String(
						filtro.getFechaD(), locale);
				fFdesde.appendChild(doc.createTextNode(fechaDesdeString));
			} else {
				fFdesde.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO FECHA DESDE */

			/* INSERTAMOS EL FILTRO FECHA HASTA */
			Element fFhasta = doc.createElement("filtroFHasta");
			String fechaHastaString = " ";
			rootElement.appendChild(fFhasta);
			if (filtro.getFechaH() != null) {
				fechaHastaString = Aa20bFormatoFecha.date2String(
						filtro.getFechaH(), locale);
				fFhasta.appendChild(doc.createTextNode(fechaHastaString));
			} else {
				fFhasta.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO FECHA HASTA */

			/* INSERTAMOS EL FILTRO FECHA DESDE PLANIF */
			Element fFplanifdesde = doc.createElement("filtroFplanifDesde");
			String fechaPlanifDesdeString = " ";
			rootElement.appendChild(fFplanifdesde);
			if (filtro.getFechaplanifD() != null) {
				fechaPlanifDesdeString = Aa20bFecha.getFechaFormateada(
						filtro.getFechaplanifD(), locale);
				fFplanifdesde.appendChild(doc
						.createTextNode(fechaPlanifDesdeString));
			} else {
				fFplanifdesde.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO FECHA DESDE PLANIF */

			/* INSERTAMOS EL FILTRO FECHA HASTA PLANIF */
			Element fFplanifhasta = doc.createElement("filtroFplanifHasta");
			String fechaPlanifHastaString = " ";
			rootElement.appendChild(fFplanifhasta);
			if (filtro.getFechaplanifH() != null) {
				fechaPlanifHastaString = Aa20bFecha.getFechaFormateada(
						filtro.getFechaplanifH(), locale);
				fFplanifhasta.appendChild(doc
						.createTextNode(fechaPlanifHastaString));
			} else {
				fFplanifhasta.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO FECHA HASTA PLANIF */

			/* INSERTAMOS EL FILTRO DE EDIFICIO */
			Element fEdificio = doc.createElement("filtroEdificio");
			String strFEdificio = "";
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				if (filtro.getMaquina() != null
						&& filtro.getMaquina().getEdificio() != null) {
					strFEdificio = filtro.getMaquina().getEdificio()
							.getEedificio() == null ? "" : filtro.getMaquina()
							.getEdificio().getEedificio();
				}
			} else {
				if (filtro.getMaquina() != null
						&& filtro.getMaquina().getEdificio() != null) {
					strFEdificio = filtro.getMaquina().getEdificio()
							.getCedificio() == null ? "" : filtro.getMaquina()
							.getEdificio().getCedificio();
				}
			}
			rootElement.appendChild(fEdificio);
			fEdificio.appendChild(doc.createTextNode(strFEdificio));
			/* FIN EL FILTRO DE EDIFICIO */

			/* INSERTAMOS EL FILTRO ZONA */
			Element fZona = doc.createElement("filtroZona");
			rootElement.appendChild(fZona);
			if (filtro.getMaquina() != null
					&& filtro.getMaquina().getZona() != null
					&& filtro.getMaquina().getZona().getCzona() != null) {
				fZona.appendChild(doc.createTextNode(filtro.getMaquina()
						.getZona().getCzona().equals("") ? " " : filtro
						.getMaquina().getZona().getCzona()));
			} else {
				fZona.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO ZONA */

			/* INSERTAMOS EL FILTRO PLANTA */
			Element fPlanta = doc.createElement("filtroPlanta");
			rootElement.appendChild(fPlanta);
			if (filtro.getMaquina() != null
					&& filtro.getMaquina().getPlanta() != null
					&& filtro.getMaquina().getPlanta().getCplanta() != null) {
				fPlanta.appendChild(doc.createTextNode(filtro.getMaquina()
						.getPlanta().getCplanta().equals("") ? " " : filtro
						.getMaquina().getPlanta().getCplanta()));
			} else {
				fPlanta.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO PLANTA */

			/* INSERTAMOS EL FILTRO MCODIGO */
			Element fMCodigo = doc.createElement("filtroMCodigo");
			rootElement.appendChild(fMCodigo);
			if (filtro.getMaquina() != null && filtro.getMaquina() != null
					&& filtro.getMaquina().getMcodigo() != null) {
				fMCodigo.appendChild(doc.createTextNode(filtro.getMaquina()
						.getMcodigo().equals("") ? " " : filtro.getMaquina()
						.getMcodigo()));
			} else {
				fMCodigo.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO MCODIGO */

			/* INSERTAMOS EL FILTRO EQUIPO */
			Element fEquipo = doc.createElement("filtroEquipo");
			rootElement.appendChild(fEquipo);
			if (filtro.getMaquina() != null && filtro.getMaquina() != null
					&& filtro.getMaquina().getCmaquina() != null) {
				fEquipo.appendChild(doc.createTextNode(filtro.getMaquina()
						.getCmaquina().equals("") ? " " : filtro.getMaquina()
						.getCmaquina()));
			} else {
				fEquipo.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO EQUIPO */

			/* INSERTAMOS EL FILTRO GAMA */
			Element fgama = doc.createElement("filtroGama");
			rootElement.appendChild(fgama);
			if (filtro.getMaquina() != null
					&& filtro.getMaquina().getGama() != null
					&& filtro.getMaquina().getGama().getCgama() != null) {
				fgama.appendChild(doc.createTextNode(filtro.getMaquina()
						.getGama().getCgama().equals("") ? " " : filtro
						.getMaquina().getGama().getCgama()));
			} else {
				fgama.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO GAMA */

			/* INSERTAMOS LA FECHA DE HOY A LA RAIZ */
			Element fechaHoyEl = doc.createElement("fechaHoy");

			java.util.Date fechaHoy = new Date();

			String fechaString = Aa20bFecha.getFecha(fechaHoy);
			Integer diaSemana = fechaHoy.getDay() + 1;
			String fechaHoyString = "";
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				fechaHoyString = Aa20bFecha.convertirFechaCompletaEu(
						fechaString, diaSemana);

			} else {
				fechaHoyString = Aa20bFecha.convertirFechaCompleta(fechaString,
						diaSemana);
			}

			rootElement.appendChild(fechaHoyEl);
			fechaHoyEl.appendChild(doc
					.createTextNode(fechaHoyString == null ? " "
							: fechaHoyString));
			/* FIN INSERTAR FECHA DE HOY */

			// Element listadoEl = doc.createElement("listado");
			// Rellenamos una registro a vacios en caso de que no haya
			// resultados para poder montar el xml y así no nos dé error el pdf
			if (listaFichas.size() == 0) {
				TablaInformes tablaVacia = new TablaInformes();
				tablaVacia.setIdficha(0);
				tablaVacia.setIdmaquina((long) 0);
				listaFichas.add(tablaVacia);
			}

			/*
			 * NUMFILAS - INSERTAMOS contador de filas para que no se pinte la
			 * tabla si no hay datos
			 */
			Element numFilasEl = doc.createElement("numFilas");
			rootElement.appendChild(numFilasEl);
			numFilasEl.appendChild(doc.createTextNode(Integer
					.toString(listaFichas.size())));
			/* FIN NUMFILAS */

			if (listaFichas.size() > 0) {

			} else {

				return null;
			}

			Element listadoEl = doc.createElement("listado");

			for (int i = 0; i < listaFichas.size(); i++) {
				// Añadimos los de Operaciones

				TablaInformes laFila = new TablaInformes();
				Element filaEl = doc.createElement("row");

				laFila = (TablaInformes) listaFichas.get(i);
				Element operacionEl = doc.createElement("FICHA");
				operacionEl
						.appendChild(doc
								.createTextNode(laFila.getIdficha() == null ? ""
										: laFila.getIdficha().toString()));
				filaEl.appendChild(operacionEl);

				Element fechaReEl = doc.createElement("FECHAPREVISTA");
				String fechaReString = "";
				if (laFila.getFecha() != null) {
					fechaString = Aa20bFecha.getFecha(laFila.getFecha());
					diaSemana = laFila.getFecha().getDay() + 1;
					if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
						fechaReString = Aa20bFecha.convertirFechaCompletaEu(
								fechaString, diaSemana);
					} else {
						fechaReString = Aa20bFecha.convertirFechaCompleta(
								fechaString, diaSemana);
					}
				}
				fechaReEl.appendChild(doc
						.createTextNode(fechaReString == null ? " "
								: fechaReString));
				filaEl.appendChild(fechaReEl);

				Element edifEl = doc.createElement("EDIFICIO");
				String strEdificio = "";
				if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
					strEdificio = laFila.getEedificio() == null ? "" : laFila
							.getEedificio();
				} else {
					strEdificio = laFila.getCedificio() == null ? "" : laFila
							.getCedificio();
				}
				edifEl.appendChild(doc.createTextNode(strEdificio));
				filaEl.appendChild(edifEl);

				Element zonaPlantaEl = doc.createElement("ZONAPLANTA");
				String strZonaPlanta = "";
				if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
					strZonaPlanta = (laFila.getEzona() == null ? "" : laFila
							.getEzona())
							+ "/"
							+ (laFila.getEplanta() == null ? "" : laFila
									.getEplanta());
				} else {
					strZonaPlanta = (laFila.getCzona() == null ? "" : laFila
							.getCzona())
							+ "/"
							+ (laFila.getCplanta() == null ? "" : laFila
									.getCplanta());
				}
				zonaPlantaEl.appendChild(doc.createTextNode(strZonaPlanta));
				filaEl.appendChild(zonaPlantaEl);

				Element equipoEl = doc.createElement("EQUIPO");
				String strEquipo = "";
				if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
					strEquipo = laFila.getEmaquina() == null ? "" : laFila
							.getEmaquina();
				} else {
					strEquipo = laFila.getCmaquina() == null ? "" : laFila
							.getCmaquina();
				}
				equipoEl.appendChild(doc.createTextNode(strEquipo));
				filaEl.appendChild(equipoEl);

				Element gamaEl = doc.createElement("GAMA");
				String strGama = "";
				if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
					strGama = laFila.getEgama() == null ? "" : laFila
							.getEgama();
				} else {
					strGama = laFila.getCgama() == null ? "" : laFila
							.getCgama();
				}
				gamaEl.appendChild(doc.createTextNode(strGama));
				filaEl.appendChild(gamaEl);

				listadoEl.appendChild(filaEl);
				// PrevPendAsignar.logger.info("1xml PrevPendAsignar: "
				// + nodeToString(listadoEl));

			}
			rootElement.appendChild(listadoEl);

			// return doc;
			// del for de listaGrupos

		} catch (Exception e) {
			PrevPendAsignar.logger.info("eror xml PrevPendAsignar: ");
		}
		// PrevPendAsignar.logger.info("xml PrevPendAsignar: "
		// + nodeToString(rootElement));

		return doc;

	}

	@SuppressWarnings("unused")
	private String nodeToString(Node node) {// element

		StringWriter sw = new StringWriter();

		try {

			Transformer t = TransformerFactory.newInstance().newTransformer();

			t.setOutputProperty(OutputKeys.ENCODING, "ISO-8859-1");

			t.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION, "no");

			t.setOutputProperty(OutputKeys.INDENT, "yes");

			t.transform(new DOMSource(node), new StreamResult(sw));

		} catch (TransformerException te) {

		}

		return sw.toString();

	}

}
