package com.ejie.aa20b.informes.listados;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import com.ejie.aa20b.classes.Aa20bFecha;
import com.ejie.aa20b.model.PlanGeneral;
import com.ejie.aa20b.model.TablaPlanificacion;
import com.ejie.aa20b.util.Aa20bConstantes;

public class PlanGeneralA {
	private static final Logger logger = LoggerFactory
			.getLogger(PlanGeneralA.class);

	/* Imprimir */
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public Document getFoPlanGeneralAXml(HttpServletRequest request,
			Locale locale, ArrayList listaPartes, PlanGeneral filtro) {
		PlanGeneralA.logger.info("getFoPlanGeneralAXml");

		String idioma = locale.getLanguage();

		Document doc = null;
		Element rootElement = null;
		try {
			DocumentBuilderFactory docFactory = DocumentBuilderFactory
					.newInstance();

			DocumentBuilder docBuilder = docFactory.newDocumentBuilder();

			// root elements

			doc = docBuilder.newDocument();
			rootElement = doc.createElement("report");
			doc.appendChild(rootElement);

			/* INSERTAMOS EL AÑO A LA RAIZ */
			Element anioEl = doc.createElement("Anio");
			rootElement.appendChild(anioEl);
			anioEl.appendChild(doc.createTextNode(filtro.getAnio() != null ? filtro
					.getAnio().toString() : " - "));
			/* FIN INSERTAR AÑO */

			/* INSERTAMOS EL FILTRO TERRITORIO */
			Element fTerri = doc.createElement("filtroTerritorio");
			rootElement.appendChild(fTerri);
			if (filtro.getTerritorio() != null) {
				fTerri.appendChild(doc.createTextNode(filtro.getTerritorio()
						.equals("") ? " " : filtro.getTerritorio()));
			} else {
				fTerri.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO TERRITORIO */

			/* INSERTAMOS EL FILTRO ZONA */
			Element fZona = doc.createElement("filtroZona");
			rootElement.appendChild(fZona);
			if (filtro.getZona() != null) {
				fZona.appendChild(doc.createTextNode(filtro.getZona()
						.equals("") ? " " : filtro.getZona()));
			} else {
				fZona.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO ZONA */

			/* INSERTAMOS EL FILTRO PLANTA */
			Element fPlanta = doc.createElement("filtroPlanta");
			rootElement.appendChild(fPlanta);
			if (filtro.getPlanta() != null) {
				fPlanta.appendChild(doc.createTextNode(filtro.getPlanta()
						.equals("") ? " " : filtro.getPlanta()));
			} else {
				fPlanta.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO PLANTA */

			/* INSERTAMOS EL FILTRO SITUACION */
			Element fSituacion = doc.createElement("filtroSituacion");
			rootElement.appendChild(fSituacion);
			if (filtro.getSituacion() != null) {
				fSituacion.appendChild(doc.createTextNode(filtro.getSituacion()
						.equals("") ? " " : filtro.getSituacion()));
			} else {
				fSituacion.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO SITUACION */

			/* INSERTAMOS EL FILTRO MANTENIMIENTO */
			Element fMant = doc.createElement("filtroMant");
			rootElement.appendChild(fMant);
			if (filtro.getTipoMantenimiento() != null) {
				fMant.appendChild(doc.createTextNode(filtro
						.getTipoMantenimiento().equals("") ? " " : filtro
						.getTipoMantenimiento()));
			} else {
				fMant.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO MANTENIMIENTO */

			/* INSERTAMOS EL FILTRO GAMA */
			Element fGama = doc.createElement("filtroGama");
			rootElement.appendChild(fGama);
			if (filtro.getGama() != null) {
				fGama.appendChild(doc.createTextNode(filtro.getGama()
						.equals("") ? " " : filtro.getGama()));
			} else {
				fGama.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO GAMA */

			/* INSERTAMOS EL FILTRO CONTRATA */
			Element fContrata = doc.createElement("filtroContrata");
			rootElement.appendChild(fContrata);
			if (filtro.getParaContrata() != null) {
				fContrata.appendChild(doc.createTextNode(filtro
						.getParaContrata().equals("") ? " " : filtro
						.getParaContrata()));
			} else {
				fContrata.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO CONTRATA */

			/* INSERTAMOS EL FILTRO MAQUINA */
			Element fMaquina = doc.createElement("filtroMaquina");
			rootElement.appendChild(fMaquina);
			if (filtro.getMaquina() != null) {
				fMaquina.appendChild(doc.createTextNode(filtro.getMaquina()
						.equals("") ? " " : filtro.getMaquina()));
			} else {
				fMaquina.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO MAQUINA */

			/* INSERTAMOS EL FILTRO INCLUIR BAJAS */
			Element fIncBaja = doc.createElement("filtroInclBaja");
			rootElement.appendChild(fIncBaja);
			if (filtro.getIncluirBaja() != null && filtro.getIncluirBaja() == 1) {
				if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
					fIncBaja.appendChild(doc.createTextNode("BAI"));
				} else {
					fIncBaja.appendChild(doc.createTextNode("SI"));
				}
			} else {
				if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
					fIncBaja.appendChild(doc.createTextNode("EZ"));
				} else {
					fIncBaja.appendChild(doc.createTextNode("NO"));
				}
			}
			/* FIN INSERTAMOS EL FILTRO INCLUIR BAJAS */

			/* INSERTAMOS LA FECHA DE HOY A LA RAIZ */
			Element fechaHoyEl = doc.createElement("fechaHoy");

			java.util.Date fechaHoy = new Date();

			String fechaString = Aa20bFecha.getFecha(fechaHoy);
			Integer diaSemana = fechaHoy.getDay() + 1;
			String fechaHoyString = "";
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				fechaHoyString = Aa20bFecha.convertirFechaCompletaEu(
						fechaString, diaSemana);

			} else {
				fechaHoyString = Aa20bFecha.convertirFechaCompleta(fechaString,
						diaSemana);
			}

			rootElement.appendChild(fechaHoyEl);
			fechaHoyEl.appendChild(doc
					.createTextNode(fechaHoyString == null ? " "
							: fechaHoyString));
			/* FIN INSERTAR FECHA DE HOY */

			// Element listadoEl = doc.createElement("listado");
			// Rellenamos una registro a vacios en caso de que no haya
			// resultados para poder montar el xml y así no nos dé error el pdf
			if (listaPartes.size() == 0) {
				TablaPlanificacion tablaVacia = new TablaPlanificacion();
				tablaVacia.setIdmaquina((long) 0);
				listaPartes.add(tablaVacia);
			}

			// Añadimos los meses del año
			String[] letrasMeses;
			try {
				letrasMeses = Aa20bFecha.letraMesSemana(filtro.getAnio());
			} catch (Exception e) {
				letrasMeses = null;
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			for (int a = 0; a < 54; a++) {
				Element mesesEl = doc.createElement("MES");
				rootElement.appendChild(mesesEl);
				mesesEl.appendChild(doc.createTextNode(letrasMeses[a] + ""));
			}

			// Añadimos las SEMANAS del año
			for (int a = 0; a < 54; a++) {
				Element semEl = doc.createElement("SEM");
				rootElement.appendChild(semEl);
				semEl.appendChild(doc.createTextNode(a + ""));
			}

			/*
			 * NUMFILAS - INSERTAMOS contador de filas para que no se pinte la
			 * tabla si no hay datos
			 */
			Element numFilasEl = doc.createElement("numFilas");
			rootElement.appendChild(numFilasEl);
			numFilasEl.appendChild(doc.createTextNode(Integer
					.toString(listaPartes.size())));
			/* FIN NUMFILAS */

			Element listadoEl = doc.createElement("listado");
			Element operacionEl = null;
			Element filaEl = null;

			for (int i = 0; i < listaPartes.size(); i++) {
				TablaPlanificacion laFila = new TablaPlanificacion();
				laFila = (TablaPlanificacion) listaPartes.get(i);

				filaEl = doc.createElement("MAQUINA");

				operacionEl = doc.createElement("ID");
				operacionEl.appendChild(doc.createTextNode(laFila
						.getIdmaquina() == null ? "" : laFila.getIdmaquina()
						.toString()));
				filaEl.appendChild(operacionEl);

				operacionEl = doc.createElement("NOMBRE");
				operacionEl.appendChild(doc.createTextNode(laFila
						.getDescripcion() == null ? "" : laFila
						.getDescripcion()));
				filaEl.appendChild(operacionEl);

				operacionEl = doc.createElement("CODIGO");
				operacionEl.appendChild(doc.createTextNode(laFila
						.getCodigoMaq() == null ? "-" : laFila.getCodigoMaq()));
				filaEl.appendChild(operacionEl);

				// Añadir valores por semana
				// Añadimos los valores por semana
				Element semanasEl = null;
				Element semanasColorEl = null;
				for (int a = 0; a < 54; a++) {
					if ((laFila.getArraySemana()[a].length() > 0)) {
						Element semanaEl = doc.createElement("SEMANA");
						semanaEl.setAttribute("numero", "" + a);

						semanasEl = doc.createElement("valor");
						semanasEl.appendChild(doc.createTextNode(laFila
								.getArraySemana()[a].length() == 0 ? ""
								: laFila.getArraySemana()[a].toString()));

						semanasColorEl = doc.createElement("valorColor");
						semanasColorEl.appendChild(doc.createTextNode(laFila
								.getArraySemanaColor()[a].length() == 0 ? ""
								: laFila.getArraySemanaColor()[a].toString()));

						semanaEl.appendChild(semanasEl);
						semanaEl.appendChild(semanasColorEl);
						filaEl.appendChild(semanaEl);
						listadoEl.appendChild(filaEl);
					}
				}

				// PlanGeneralA.logger.info("1xml PlanGeneralA: "
				// + nodeToString(listadoEl));
			}
			// Para el último registro

			rootElement.appendChild(listadoEl);

			// return doc;
			// del for de listaGrupos

		} catch (Exception e) {
			PlanGeneralA.logger.info("eror xml PlanGeneralA: ");
		}
		// PlanGeneralA.logger.info("xml PlanGeneralA: "
		// + nodeToString(rootElement));

		return doc;

	}

	@SuppressWarnings("unused")
	private String nodeToString(Node node) {// element

		StringWriter sw = new StringWriter();

		try {

			Transformer t = TransformerFactory.newInstance().newTransformer();

			t.setOutputProperty(OutputKeys.ENCODING, "ISO-8859-1");

			t.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION, "no");

			t.setOutputProperty(OutputKeys.INDENT, "yes");

			t.transform(new DOMSource(node), new StreamResult(sw));

		} catch (TransformerException te) {

		}

		return sw.toString();

	}

}
