package com.ejie.aa20b.informes.listados;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import com.ejie.aa20b.classes.Aa20bFecha;
import com.ejie.aa20b.classes.Aa20bFormatoFecha;
import com.ejie.aa20b.model.Partes;
import com.ejie.aa20b.model.TablaInformes;
import com.ejie.aa20b.util.Aa20bConstantes;

public class PendEjecAuto {
	private static final Logger logger = LoggerFactory
			.getLogger(PendEjecAuto.class);

	/* Imprimir */
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public Document getFoPendEjecAutoXml(HttpServletRequest request,
			Locale locale, ArrayList listaPartes, Partes filtro) {
		PendEjecAuto.logger.info("getFoPendEjecAutoXml");

		String idioma = locale.getLanguage();

		Document doc = null;
		Element rootElement = null;
		try {
			DocumentBuilderFactory docFactory = DocumentBuilderFactory
					.newInstance();

			DocumentBuilder docBuilder = docFactory.newDocumentBuilder();

			// root elements

			doc = docBuilder.newDocument();
			rootElement = doc.createElement("report");
			doc.appendChild(rootElement);

			/* INSERTAMOS EL FILTRO Num Parte */
			Element fNParte = doc.createElement("filtroNParte");
			rootElement.appendChild(fNParte);
			if (filtro.getIdparte() != null) {
				fNParte.appendChild(doc.createTextNode(filtro.getIdparte()
						.equals("") ? " " : filtro.getIdparte().toString()));
			} else {
				fNParte.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO Num Parte */

			/* INSERTAMOS EL FILTRO FECHA DESDE */
			Element fFdesde = doc.createElement("filtroFDesde");
			String fechaDesdeString = " ";
			rootElement.appendChild(fFdesde);
			if (filtro.getFechareD() != null) {
				fechaDesdeString = Aa20bFormatoFecha.date2String(
						filtro.getFechareD(), locale);
				fFdesde.appendChild(doc.createTextNode(fechaDesdeString));
			} else {
				fFdesde.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO FECHA DESDE */

			/* INSERTAMOS EL FILTRO FECHA HASTA */
			Element fFhasta = doc.createElement("filtroFHasta");
			String fechaHastaString = " ";
			rootElement.appendChild(fFhasta);
			if (filtro.getFechareH() != null) {
				fechaHastaString = Aa20bFormatoFecha.date2String(
						filtro.getFechareH(), locale);
				fFhasta.appendChild(doc.createTextNode(fechaHastaString));
			} else {
				fFhasta.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO FECHA HASTA */

			/* INSERTAMOS EL FILTRO FECHA DESDE PLANIF */
			Element fFplanifdesde = doc.createElement("filtroFplanifDesde");
			String fechaPlanifDesdeString = " ";
			rootElement.appendChild(fFplanifdesde);
			if (filtro.getFechaplanifD() != null) {
				fechaPlanifDesdeString = Aa20bFecha.getFechaFormateada(
						filtro.getFechaplanifD(), locale);
				fFplanifdesde.appendChild(doc
						.createTextNode(fechaPlanifDesdeString));
			} else {
				fFplanifdesde.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO FECHA DESDE PLANIF */

			/* INSERTAMOS EL FILTRO FECHA HASTA PLANIF */
			Element fFplanifhasta = doc.createElement("filtroFplanifHasta");
			String fechaPlanifHastaString = " ";
			rootElement.appendChild(fFplanifhasta);
			if (filtro.getFechaplanifH() != null) {
				fechaPlanifHastaString = Aa20bFecha.getFechaFormateada(
						filtro.getFechaplanifH(), locale);
				fFplanifhasta.appendChild(doc
						.createTextNode(fechaPlanifHastaString));
			} else {
				fFplanifhasta.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO FECHA HASTA PLANIF */

			/* INSERTAMOS EL FILTRO NOMBRE */
			Element fNombre = doc.createElement("filtroNombre");
			rootElement.appendChild(fNombre);
			if (filtro.getNombre() != null) {
				fNombre.appendChild(doc.createTextNode(filtro.getNombre()
						.equals("") ? " " : filtro.getNombre()));
			} else {
				fNombre.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO NOMBRE */

			/* INSERTAMOS EL FILTRO DEPARTAMENTO */
			Element fDpto = doc.createElement("filtroDpto");
			rootElement.appendChild(fDpto);
			if (filtro.getDepartamento().getCdepar() != null) {
				fDpto.appendChild(doc.createTextNode(filtro.getDepartamento()
						.getCdepar().equals("") ? " " : filtro
						.getDepartamento().getCdepar()));
			} else {
				fDpto.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO DEPARTAMENTO */

			/* INSERTAMOS EL FILTRO DIRECCION */
			Element fDir = doc.createElement("filtroDir");
			rootElement.appendChild(fDir);
			if (filtro.getDireccion().getCdir() != null) {
				fDir.appendChild(doc.createTextNode(filtro.getDireccion()
						.getCdir().equals("") ? " " : filtro.getDireccion()
						.getCdir()));
			} else {
				fDir.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO DIRECCION */

			/* INSERTAMOS EL FILTRO EDIFICIO */
			Element fEdificio = doc.createElement("filtroEdificio");
			rootElement.appendChild(fEdificio);
			if (filtro.getEdificio().getCedificio() != null) {
				fEdificio.appendChild(doc.createTextNode(filtro.getEdificio()
						.getCedificio().equals("") ? " " : filtro.getEdificio()
						.getCedificio()));
			} else {
				fEdificio.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO EDIFICIO */

			/* INSERTAMOS EL FILTRO ZONA */
			Element fZona = doc.createElement("filtroZona");
			rootElement.appendChild(fZona);
			if (filtro.getZona().getCzona() != null) {
				fZona.appendChild(doc.createTextNode(filtro.getZona()
						.getCzona().equals("") ? " " : filtro.getZona()
						.getCzona()));
			} else {
				fZona.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO ZONA */

			/* INSERTAMOS EL FILTRO PLANTA */
			Element fPlanta = doc.createElement("filtroPlanta");
			rootElement.appendChild(fPlanta);
			if (filtro.getPlanta().getCplanta() != null) {
				fPlanta.appendChild(doc.createTextNode(filtro.getPlanta()
						.getCplanta().equals("") ? " " : filtro.getPlanta()
						.getCplanta()));
			} else {
				fPlanta.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO PLANTA */

			/* INSERTAMOS EL FILTRO CLASE */
			Element fClase = doc.createElement("filtroClase");
			rootElement.appendChild(fClase);
			if (filtro.getClase().getCclase() != null) {
				fClase.appendChild(doc.createTextNode(filtro.getClase()
						.getCclase().equals("") ? " " : filtro.getClase()
						.getCclase()));
			} else {
				fClase.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO CLASE */

			/* INSERTAMOS EL FILTRO CODIGO */
			Element fCodigo = doc.createElement("filtroCodigo");
			rootElement.appendChild(fCodigo);
			if (filtro.getCodigo().getCcodigo() != null) {
				fCodigo.appendChild(doc.createTextNode(filtro.getCodigo()
						.getCcodigo().equals("") ? " " : filtro.getCodigo()
						.getCcodigo()));
			} else {
				fCodigo.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO CODIGO */

			/* INSERTAMOS EL FILTRO URGENTE */
			Element fUrgente = doc.createElement("filtroUrgente");
			rootElement.appendChild(fUrgente);
			if (filtro.getUrgente() != null) {
				fUrgente.appendChild(doc.createTextNode(filtro.getUrgente()
						.equals("1") ? "SI" : " "));
			} else {
				fUrgente.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO getUrgente */

			/* INSERTAMOS LA FECHA DE HOY A LA RAIZ */
			Element fechaHoyEl = doc.createElement("fechaHoy");

			java.util.Date fechaHoy = new Date();

			String fechaString = Aa20bFecha.getFecha(fechaHoy);
			Integer diaSemana = fechaHoy.getDay() + 1;
			String fechaHoyString = "";
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				fechaHoyString = Aa20bFecha.convertirFechaCompletaEu(
						fechaString, diaSemana);

			} else {
				fechaHoyString = Aa20bFecha.convertirFechaCompleta(fechaString,
						diaSemana);
			}

			rootElement.appendChild(fechaHoyEl);
			fechaHoyEl.appendChild(doc
					.createTextNode(fechaHoyString == null ? " "
							: fechaHoyString));
			/* FIN INSERTAR FECHA DE HOY */

			// Element listadoEl = doc.createElement("listado");
			// Rellenamos una registro a vacios en caso de que no haya
			// resultados para poder montar el xml y así no nos dé error el pdf
			if (listaPartes.size() == 0) {
				TablaInformes tablaVacia = new TablaInformes();
				tablaVacia.setIdficha(0);
				tablaVacia.setIdmaquina((long) 0);
				listaPartes.add(tablaVacia);
			}

			/*
			 * NUMFILAS - INSERTAMOS contador de filas para que no se pinte la
			 * tabla si no hay datos
			 */
			Element numFilasEl = doc.createElement("numFilas");
			rootElement.appendChild(numFilasEl);
			numFilasEl.appendChild(doc.createTextNode(Integer
					.toString(listaPartes.size())));
			/* FIN NUMFILAS */

			if (listaPartes.size() > 0) {

			} else {

				return null;
			}

			Element listadoEl = doc.createElement("listado");

			for (int i = 0; i < listaPartes.size(); i++) {
				// Añadimos los de Operaciones

				TablaInformes laFila = new TablaInformes();
				Element filaEl = doc.createElement("row");

				laFila = (TablaInformes) listaPartes.get(i);
				Element tecnicosEl = doc.createElement("NOMBRE");
				tecnicosEl
						.appendChild(doc
								.createTextNode(laFila.getNombre() == null ? ""
										: laFila.getNombre()));
				filaEl.appendChild(tecnicosEl);

				laFila = (TablaInformes) listaPartes.get(i);
				Element operacionEl = doc.createElement("PARTE");
				operacionEl
						.appendChild(doc
								.createTextNode(laFila.getIdparte() == null ? ""
										: laFila.getIdparte().toString()));
				filaEl.appendChild(operacionEl);

				Element fechaReEl = doc.createElement("FECHARE");
				String fechaReString = "";
				if (laFila.getFecre() != null) {
					fechaString = Aa20bFecha.getFecha(laFila.getFecre());
					diaSemana = laFila.getFecre().getDay() + 1;
					if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
						fechaReString = Aa20bFecha.convertirFechaCompletaEu(
								fechaString, diaSemana);
					} else {
						fechaReString = Aa20bFecha.convertirFechaCompleta(
								fechaString, diaSemana);
					}
				}
				fechaReEl.appendChild(doc
						.createTextNode(fechaReString == null ? " "
								: fechaReString));
				filaEl.appendChild(fechaReEl);

				Element fechaEjEl = doc.createElement("FECHAEJ");
				String fechaEjString = "";
				if (laFila.getFeejec() != null) {
					fechaString = Aa20bFecha.getFecha(laFila.getFeejec());
					diaSemana = laFila.getFeejec().getDay() + 1;
					if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
						fechaEjString = Aa20bFecha.convertirFechaCompletaEu(
								fechaString, diaSemana);
					} else {
						fechaEjString = Aa20bFecha.convertirFechaCompleta(
								fechaString, diaSemana);
					}
				}
				fechaEjEl.appendChild(doc
						.createTextNode(fechaEjString == null ? " "
								: fechaEjString));
				filaEl.appendChild(fechaEjEl);

				Element incidenciasEl = doc.createElement("TIEMPO");
				incidenciasEl.appendChild(doc.createTextNode(laFila
						.getTiemporeal() == null ? "" : laFila.getTiemporeal()
						.toString()));
				filaEl.appendChild(incidenciasEl);

				Element claseCodigoEl = doc.createElement("CLASECODIGO");
				StringBuilder claseCodigo = new StringBuilder("");
				if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
					claseCodigo.append(laFila.getEclase() == null ? "" : laFila
							.getEclase());
					claseCodigo.append(" / ");
					claseCodigo.append(laFila.getEcodigo() == null ? ""
							: laFila.getEcodigo());
				} else {
					claseCodigo.append(laFila.getCclase() == null ? "" : laFila
							.getCclase());
					claseCodigo.append(" / ");
					claseCodigo.append(laFila.getCcodigo() == null ? ""
							: laFila.getCcodigo());
				}
				claseCodigoEl.appendChild(doc.createTextNode(claseCodigo
						.toString()));
				filaEl.appendChild(claseCodigoEl);

				Element observEl = doc.createElement("OBSERV");
				observEl.appendChild(doc.createTextNode(laFila
						.getObservaciones() == null ? "" : laFila
						.getObservaciones()));
				filaEl.appendChild(observEl);

				listadoEl.appendChild(filaEl);
				// PendAsignar.logger.info("1xml PendAsignar: "
				// + nodeToString(listadoEl));

			}
			rootElement.appendChild(listadoEl);

			// return doc;
			// del for de listaGrupos

		} catch (Exception e) {
			PendEjecAuto.logger.info("eror xml PendEjecAuto: ");
		}
		// PendEjecAuto.logger.info("xml PendEjecAuto: "
		// + nodeToString(rootElement));

		return doc;

	}

	@SuppressWarnings("unused")
	private String nodeToString(Node node) {// element

		StringWriter sw = new StringWriter();

		try {

			Transformer t = TransformerFactory.newInstance().newTransformer();

			t.setOutputProperty(OutputKeys.ENCODING, "ISO-8859-1");

			t.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION, "no");

			t.setOutputProperty(OutputKeys.INDENT, "yes");

			t.transform(new DOMSource(node), new StreamResult(sw));

		} catch (TransformerException te) {

		}

		return sw.toString();

	}

}
