package com.ejie.aa20b.informes.listados;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import com.ejie.aa20b.classes.Aa20bFecha;
import com.ejie.aa20b.model.Ficha;
import com.ejie.aa20b.model.TablaInformes;
import com.ejie.aa20b.util.Aa20bConstantes;

public class FichaInforme {
	private static final Logger logger = LoggerFactory
			.getLogger(FichaInforme.class);

	/* Imprimir */
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public Document getFoImpresoFichaXml(HttpServletRequest request,
			Locale locale, ArrayList listaInformes, ArrayList listaTecnicos,
			Ficha filtro) {
		FichaInforme.logger.info("getFoImpresoFichaXml");

		String idioma = locale.getLanguage();

		Document doc = null;
		Element rootElement = null;
		try {
			DocumentBuilderFactory docFactory = DocumentBuilderFactory
					.newInstance();

			DocumentBuilder docBuilder = docFactory.newDocumentBuilder();

			// root elements

			doc = docBuilder.newDocument();
			rootElement = doc.createElement("report");
			doc.appendChild(rootElement);

			/* INSERTAMOS LA FECHA DE HOY A LA RAIZ */
			Element fechaHoyEl = doc.createElement("fechaHoy");

			java.util.Date fechaHoy = new Date();

			String fechaString = Aa20bFecha.getFecha(fechaHoy);
			Integer diaSemana = fechaHoy.getDay() + 1;
			String fechaHoyString = "";
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				fechaHoyString = Aa20bFecha.convertirFechaCompletaEu(
						fechaString, diaSemana);

			} else {
				fechaHoyString = Aa20bFecha.convertirFechaCompleta(fechaString,
						diaSemana);
			}

			rootElement.appendChild(fechaHoyEl);
			fechaHoyEl.appendChild(doc
					.createTextNode(fechaHoyString == null ? " "
							: fechaHoyString));
			/* FIN INSERTAR FECHA DE HOY */

			// Element listadoEl = doc.createElement("listado");
			// Rellenamos una registro a vacios en caso de que no haya
			// resultados para poder montar el xml y así no nos dé error el pdf
			if (listaInformes.size() == 0) {
				TablaInformes tablaVacia = new TablaInformes();
				tablaVacia.setIdficha(0);
				tablaVacia.setIdmaquina((long) 0);
				listaInformes.add(tablaVacia);
			}

			/*
			 * NUMFILAS - INSERTAMOS contador de filas para que no se pinte la
			 * tabla y los graficos si no hay datos
			 */
			Element numFilasEl = doc.createElement("numFilas");
			rootElement.appendChild(numFilasEl);
			numFilasEl.appendChild(doc.createTextNode(Integer
					.toString(listaInformes.size())));
			/* FIN NUMFILAS */

			if (listaInformes.size() > 0) {
				// Añadimos los datos de cabecera
				TablaInformes laFila = new TablaInformes();

				laFila = (TablaInformes) listaInformes.get(0);

				Element nombreMaquinaEl = doc.createElement("PARTE");
				nombreMaquinaEl.appendChild(doc.createTextNode(laFila
						.getIdficha() == null ? " " : laFila.getIdficha()
						.toString()));
				rootElement.appendChild(nombreMaquinaEl);

				Element fechaEjecEl = doc.createElement("FEJEC");
				String fechaEjec = " ";
				if (laFila.getFeejec() != null) {
					fechaString = Aa20bFecha.getFecha(laFila.getFeejec());
					diaSemana = laFila.getFeejec().getDay() + 1;
					if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
						fechaEjec = Aa20bFecha.convertirFechaCompletaEu(
								fechaString, diaSemana);

					} else {
						fechaEjec = Aa20bFecha.convertirFechaCompleta(
								fechaString, diaSemana);
					}
				}
				fechaEjecEl.appendChild(doc.createTextNode(fechaEjec));
				rootElement.appendChild(fechaEjecEl);

				Element zonaEl = doc.createElement("ZONA");
				String sZona = laFila.getRzona() == null ? " " : laFila
						.getRzona();
				String sPlanta = laFila.getRplanta() == null ? " " : laFila
						.getRplanta();
				String zona = laFila.getRedificio() == null ? " " : laFila
						.getRedificio() + "/" + sZona + "/" + sPlanta;
				zonaEl.appendChild(doc.createTextNode(zona));
				rootElement.appendChild(zonaEl);

				StringBuffer equipo = new StringBuffer();
				String gama = "";
				String mCodigo = "";
				mCodigo = laFila.getCcodigo() == null ? " " : laFila
						.getCcodigo();
				if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
					equipo.append(mCodigo);
					equipo.append(" - ");
					equipo.append(laFila.getEmaquina() == null ? " " : laFila
							.getEmaquina());

					gama = laFila.getEgama() == null ? " " : laFila.getEgama();
				} else {
					equipo.append(mCodigo);
					equipo.append(" - ");
					equipo.append(laFila.getCmaquina() == null ? " " : laFila
							.getCmaquina());
					gama = laFila.getCgama() == null ? " " : laFila.getCgama();
				}

				Element equipoEl = doc.createElement("EQUIPO");
				equipoEl.appendChild(doc.createTextNode(equipo.toString()));
				rootElement.appendChild(equipoEl);

				Element gamaEl = doc.createElement("GAMA");
				gamaEl.appendChild(doc.createTextNode(gama));
				rootElement.appendChild(gamaEl);

				Element tiempoEl = doc.createElement("TIEMPOREAL");
				tiempoEl.appendChild(doc
						.createTextNode(laFila.getTiemporeal() == null ? " "
								: laFila.getTiemporeal().toString()));
				rootElement.appendChild(tiempoEl);

				Element realizadoEl = doc.createElement("REALIZADO");
				realizadoEl.appendChild(doc.createTextNode(laFila
						.getEjecutado() == null ? " " : laFila.getEjecutado()));
				rootElement.appendChild(realizadoEl);

				// Los nombres de los tecnicos se pintarán en una sola linea
				Element nombreEl = doc.createElement("NOMBRE");
				StringBuffer strTecnicos = new StringBuffer();
				strTecnicos.append(" ");
				for (int i = 0; i < listaTecnicos.size(); i++) {
					TablaInformes laFilaTec = new TablaInformes();
					laFilaTec = (TablaInformes) listaTecnicos.get(i);
					strTecnicos.append(laFilaTec.getNombre() == null ? " "
							: laFilaTec.getNombre() + " - ");
				}
				nombreEl.appendChild(doc.createTextNode(strTecnicos.toString()));
				rootElement.appendChild(nombreEl);

			} else {

				return null;
			}

			Element listadoEl = doc.createElement("listado");

			for (int i = 0; i < listaInformes.size(); i++) {
				// Añadimos los de Operaciones

				TablaInformes laFila = new TablaInformes();
				Element filaEl = doc.createElement("row");

				laFila = (TablaInformes) listaInformes.get(i);
				Element operacionEl = doc.createElement("OPERACION");
				operacionEl.appendChild(doc.createTextNode(laFila
						.getOperacion() == null ? "" : laFila.getOperacion()));
				filaEl.appendChild(operacionEl);

				Element periodoEl = doc.createElement("PERIODO");
				periodoEl
						.appendChild(doc
								.createTextNode(laFila.getSemanas() == null ? ""
										: laFila.getSemanas().toString()));
				filaEl.appendChild(periodoEl);

				Element incidenciasEl = doc.createElement("INCIDENCIAS");
				incidenciasEl.appendChild(doc.createTextNode(laFila
						.getDescripcion() == null ? "" : laFila
						.getDescripcion()));
				filaEl.appendChild(incidenciasEl);

				Element correctivoEl = doc.createElement("CORRECTIVO");
				correctivoEl
						.appendChild(doc
								.createTextNode(laFila.getIdparte() == null ? ""
										: laFila.getIdparte().toString()));
				filaEl.appendChild(correctivoEl);

				listadoEl.appendChild(filaEl);
				// FichaInforme.logger.info("1xml FichaInforme: "
				// + nodeToString(listadoEl));

			}
			rootElement.appendChild(listadoEl);

			// return doc;
			// del for de listaGrupos

		} catch (Exception e) {
			FichaInforme.logger.info("eror xml FichaInforme: ");
		}
		// FichaInforme.logger.info("xml FichaInforme: "
		// + nodeToString(rootElement));

		return doc;

	}

	@SuppressWarnings("unused")
	private String nodeToString(Node node) {// element

		StringWriter sw = new StringWriter();

		try {

			Transformer t = TransformerFactory.newInstance().newTransformer();

			t.setOutputProperty(OutputKeys.ENCODING, "ISO-8859-1");

			t.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION, "no");

			t.setOutputProperty(OutputKeys.INDENT, "yes");

			t.transform(new DOMSource(node), new StreamResult(sw));

		} catch (TransformerException te) {

		}

		return sw.toString();

	}

}
