package com.ejie.aa20b.informes.listados;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import com.ejie.aa20b.classes.Aa20bFecha;
import com.ejie.aa20b.model.Partes;
import com.ejie.aa20b.model.TablaInformes;
import com.ejie.aa20b.util.Aa20bConstantes;

public class Correctivos {
	private static final Logger logger = LoggerFactory
			.getLogger(Correctivos.class);

	/* Imprimir */
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public Document getFoCorrectivosXml(HttpServletRequest request,
			Locale locale, ArrayList listaInformes, Partes filtro) {
		Correctivos.logger.info("getFoCorrectivosXml");

		String idioma = locale.getLanguage();

		Document doc = null;
		Element rootElement = null;
		try {
			DocumentBuilderFactory docFactory = DocumentBuilderFactory
					.newInstance();

			DocumentBuilder docBuilder = docFactory.newDocumentBuilder();

			// root elements

			doc = docBuilder.newDocument();
			rootElement = doc.createElement("report");
			doc.appendChild(rootElement);

			/* INSERTAMOS EL FILTRO IDPARTE */
			Element fIdparte = doc.createElement("filtroIdparte");
			rootElement.appendChild(fIdparte);
			if (filtro.getIdparte() != null) {
				fIdparte.appendChild(doc.createTextNode(filtro.getIdparte()
						.equals("") ? " " : filtro.getIdparte().toString()));
			} else {
				fIdparte.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO NOMBRE */

			/* INSERTAMOS EL FILTRO FECHA DESDE */
			Element fFdesde = doc.createElement("filtroFDesde");
			String fechaDesdeString = " ";
			rootElement.appendChild(fFdesde);
			if (filtro.getFechareD() != null) {
				fechaDesdeString = Aa20bFecha.getFechaFormateada(
						filtro.getFechareD(), locale);
				fFdesde.appendChild(doc.createTextNode(fechaDesdeString));
			} else {
				fFdesde.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO FECHA DESDE */

			/* INSERTAMOS EL FILTRO FECHA HASTA */
			Element fFhasta = doc.createElement("filtroFHasta");
			String fechaHastaString = " ";
			rootElement.appendChild(fFhasta);
			if (filtro.getFechareH() != null) {
				fechaHastaString = Aa20bFecha.getFechaFormateada(
						filtro.getFechareH(), locale);
				fFhasta.appendChild(doc.createTextNode(fechaHastaString));
			} else {
				fFhasta.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO FECHA HASTA */

			/* INSERTAMOS EL FILTRO FECHA DESDE PLANIF */
			Element fFplanifdesde = doc.createElement("filtroFplanifDesde");
			String fechaPlanifDesdeString = " ";
			rootElement.appendChild(fFplanifdesde);
			if (filtro.getFechaplanifD() != null) {
				fechaPlanifDesdeString = Aa20bFecha.getFechaFormateada(
						filtro.getFechaplanifD(), locale);
				fFplanifdesde.appendChild(doc
						.createTextNode(fechaPlanifDesdeString));
			} else {
				fFplanifdesde.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO FECHA DESDE PLANIF */

			/* INSERTAMOS EL FILTRO FECHA HASTA PLANIF */
			Element fFplanifhasta = doc.createElement("filtroFplanifHasta");
			String fechaPlanifHastaString = " ";
			rootElement.appendChild(fFplanifhasta);
			if (filtro.getFechaplanifH() != null) {
				fechaPlanifHastaString = Aa20bFecha.getFechaFormateada(
						filtro.getFechaplanifH(), locale);
				fFplanifhasta.appendChild(doc
						.createTextNode(fechaPlanifHastaString));
			} else {
				fFplanifhasta.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO FECHA HASTA PLANIF */

			/* INSERTAMOS EL FILTRO NOMBRE */
			Element fNombre = doc.createElement("filtroNombre");
			rootElement.appendChild(fNombre);
			if (filtro.getNombre() != null) {
				fNombre.appendChild(doc.createTextNode(filtro.getNombre()
						.equals("") ? " " : filtro.getNombre()));
			} else {
				fNombre.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO NOMBRE */

			/* INSERTAMOS EL FILTRO DEPARTAMENTO */
			Element fDpto = doc.createElement("filtroDpto");
			rootElement.appendChild(fDpto);
			if (filtro.getDepartamento() != null
					&& filtro.getDepartamento().getCdepar() != null) {
				fDpto.appendChild(doc.createTextNode(filtro.getDepartamento()
						.getCdepar().equals("") ? " " : filtro
						.getDepartamento().getCdepar()));
			} else {
				fDpto.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO DEPARTAMENTO */

			/* INSERTAMOS EL FILTRO DIRECCION */
			Element fDir = doc.createElement("filtroDir");
			rootElement.appendChild(fDir);
			if (filtro.getDireccion() != null
					&& filtro.getDireccion().getCdir() != null) {
				fDir.appendChild(doc.createTextNode(filtro.getDireccion()
						.getCdir().equals("") ? " " : filtro.getDireccion()
						.getCdir()));
			} else {
				fDir.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO DIRECCION */

			/* INSERTAMOS EL FILTRO EDIFICIO */
			Element fEdificio = doc.createElement("filtroEdificio");
			rootElement.appendChild(fEdificio);
			if (filtro.getEdificio() != null
					&& filtro.getEdificio().getCedificio() != null) {
				fEdificio.appendChild(doc.createTextNode(filtro.getEdificio()
						.getCedificio().equals("") ? " " : filtro.getEdificio()
						.getCedificio()));
			} else {
				fEdificio.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO EDIFICIO */

			/* INSERTAMOS EL FILTRO ZONA */
			Element fZona = doc.createElement("filtroZona");
			rootElement.appendChild(fZona);
			if (filtro.getZona() != null && filtro.getZona().getCzona() != null) {
				fZona.appendChild(doc.createTextNode(filtro.getZona()
						.getCzona().equals("") ? " " : filtro.getZona()
						.getCzona()));
			} else {
				fZona.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO ZONA */

			/* INSERTAMOS EL FILTRO PLANTA */
			Element fPlanta = doc.createElement("filtroPlanta");
			rootElement.appendChild(fPlanta);
			if (filtro.getPlanta() != null
					&& filtro.getPlanta().getCplanta() != null) {
				fPlanta.appendChild(doc.createTextNode(filtro.getPlanta()
						.getCplanta().equals("") ? " " : filtro.getPlanta()
						.getCplanta()));
			} else {
				fPlanta.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO PLANTA */

			/* INSERTAMOS EL FILTRO CLASE */
			Element fClase = doc.createElement("filtroClase");
			rootElement.appendChild(fClase);
			if (filtro.getClase() != null
					&& filtro.getClase().getCclase() != null) {
				fClase.appendChild(doc.createTextNode(filtro.getClase()
						.getCclase().equals("") ? " " : filtro.getClase()
						.getCclase()));
			} else {
				fClase.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO CLASE */

			/* INSERTAMOS EL FILTRO CODIGO */
			Element fCodigo = doc.createElement("filtroCodigo");
			rootElement.appendChild(fCodigo);
			if (filtro.getCodigo() != null
					&& filtro.getCodigo().getCcodigo() != null) {
				fCodigo.appendChild(doc.createTextNode(filtro.getCodigo()
						.getCcodigo().equals("") ? " " : filtro.getCodigo()
						.getCcodigo()));
			} else {
				fCodigo.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO CODIGO */

			/* INSERTAMOS EL FILTRO SERVICIO */
			Element fServicio = doc.createElement("filtroServicio");
			rootElement.appendChild(fServicio);
			if (filtro.getCodigo() != null
					&& filtro.getCodigo().getIdservicio() != null
					&& filtro.getCodigo().getIdservicio() != 0) {

				if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
					if (filtro.getCodigo().getServicio() != null) {
						if (filtro.getCodigo().getServicio().getEservicio() != null) {
							fServicio.appendChild(doc.createTextNode(filtro
									.getCodigo().getServicio().getEservicio()
									.equals("") ? " " : filtro.getCodigo()
									.getServicio().getEservicio()));
						} else {
							fServicio.appendChild(doc.createTextNode(" "));
						}
					} else {
						fServicio.appendChild(doc.createTextNode(" "));
					}

				} else {
					if (filtro.getCodigo().getServicio() != null) {
						if (filtro.getCodigo().getServicio().getCservicio() != null) {
							fServicio.appendChild(doc.createTextNode(filtro
									.getCodigo().getServicio().getCservicio()
									.equals("") ? " " : filtro.getCodigo()
									.getServicio().getCservicio()));
						} else {
							fServicio.appendChild(doc.createTextNode(" "));
						}
					} else {
						fServicio.appendChild(doc.createTextNode(" "));
					}
				}
			} else {
				fServicio.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO SERVICIO */

			/* INSERTAMOS EL FILTRO PENDIENTES SIN TECNICO */
			Element fPendSinTec = doc.createElement("filtroPendSinT");
			rootElement.appendChild(fPendSinTec);
			if (filtro.getPendSinTec() != null) {
				fPendSinTec.appendChild(doc.createTextNode(filtro
						.getPendSinTec().equals("1") ? "Si" : " "));
			} else {
				fPendSinTec.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO PENDIENTES SIN TECNICO */

			/* INSERTAMOS EL FILTRO PENDIENTES CON TECNICO */
			Element fPendConTec = doc.createElement("filtroPendConT");
			rootElement.appendChild(fPendConTec);
			if (filtro.getPendConTec() != null) {
				fPendConTec.appendChild(doc.createTextNode(filtro
						.getPendConTec().equals("1") ? "Si" : " "));
			} else {
				fPendConTec.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO PENDIENTES CON TECNICO */

			/* INSERTAMOS EL FILTRO EJECUTADOS */
			Element fEjecutado = doc.createElement("filtroEjecutados");
			rootElement.appendChild(fEjecutado);
			if (filtro.getEjecutado() != null) {
				fEjecutado.appendChild(doc.createTextNode(filtro.getEjecutado()
						.equals("1") ? "Si" : " "));
			} else {
				fEjecutado.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO EJECUTADOS */

			/* INSERTAMOS EL FILTRO TECNICOS */
			Element fTecnico = doc.createElement("filtroTecnicos");
			rootElement.appendChild(fTecnico);
			if (filtro.getTecnicos() != null) {
				fTecnico.appendChild(doc.createTextNode(filtro.getTecnicos()
						.equals("") ? " " : filtro.getTecnicos()));
			} else {
				fTecnico.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO TECNICOS */

			/* INSERTAMOS EL FILTRO URGENTE */
			Element fUrgente = doc.createElement("filtroUrgente");
			rootElement.appendChild(fUrgente);
			if (filtro.getUrgente() != null) {
				fUrgente.appendChild(doc.createTextNode(filtro.getUrgente()
						.equals("1") ? "SI" : " "));
			} else {
				fUrgente.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO getUrgente */

			/* INSERTAMOS EL FILTRO ENVIOMAIL */
			Element fEnviomail = doc.createElement("filtroEnviomail");
			rootElement.appendChild(fEnviomail);
			if (filtro.getEnviomail() != null) {
				if (filtro.getEnviomail().equals("1")) {
					fEnviomail.appendChild(doc.createTextNode("Enviado"));
				} else if (filtro.getEnviomail().equals("0")) {
					fEnviomail.appendChild(doc.createTextNode("Sin enviar"));
				} else {
					fEnviomail.appendChild(doc.createTextNode(" "));
				}
			} else {
				fEnviomail.appendChild(doc.createTextNode(" "));
			}
			/* FIN INSERTAMOS EL FILTRO ENVIOMAIL */

			/* INSERTAMOS LA FECHA DE HOY A LA RAIZ */
			Element fechaHoyEl = doc.createElement("fechaHoy");

			java.util.Date fechaHoy = new Date();

			String fechaString = Aa20bFecha.getFecha(fechaHoy);
			Integer diaSemana = fechaHoy.getDay() + 1;
			String fechaHoyString = "";
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				fechaHoyString = Aa20bFecha.convertirFechaCompletaEu(
						fechaString, diaSemana);

			} else {
				fechaHoyString = Aa20bFecha.convertirFechaCompleta(fechaString,
						diaSemana);
			}

			rootElement.appendChild(fechaHoyEl);
			fechaHoyEl.appendChild(doc
					.createTextNode(fechaHoyString == null ? " "
							: fechaHoyString));
			/* FIN INSERTAR FECHA DE HOY */

			// Element listadoEl = doc.createElement("listado");
			// Rellenamos una registro a vacios en caso de que no haya
			// resultados para poder montar el xml y así no nos dé error el pdf
			if (listaInformes.size() == 0) {
				TablaInformes tablaVacia = new TablaInformes();
				tablaVacia.setIdficha(0);
				tablaVacia.setIdmaquina((long) 0);
				listaInformes.add(tablaVacia);
			}

			/*
			 * NUMFILAS - INSERTAMOS contador de filas para que no se pinte la
			 * tabla y los graficos si no hay datos
			 */
			Element numFilasEl = doc.createElement("numFilas");
			rootElement.appendChild(numFilasEl);
			numFilasEl.appendChild(doc.createTextNode(Integer
					.toString(listaInformes.size())));
			/* FIN NUMFILAS */

			if (listaInformes.size() > 0) {

			} else {

				return null;
			}

			Element listadoEl = doc.createElement("listado");

			for (int i = 0; i < listaInformes.size(); i++) {
				// Añadimos los de Operaciones

				TablaInformes laFila = new TablaInformes();
				Element filaEl = doc.createElement("row");

				laFila = (TablaInformes) listaInformes.get(i);
				Element tecnicosEl = doc.createElement("TECNICOS");
				tecnicosEl
						.appendChild(doc
								.createTextNode(laFila.getTecnico() == null ? ""
										: laFila.getTecnico()));
				filaEl.appendChild(tecnicosEl);

				Element parteEl = doc.createElement("PARTE");
				parteEl.appendChild(doc
						.createTextNode(laFila.getIdparte() == null ? ""
								: laFila.getIdparte().toString()));
				filaEl.appendChild(parteEl);

				Element fechaReEl = doc.createElement("FECHARE");
				String fechaRe = " ";
				if (laFila.getFecre() != null) {
					fechaRe = Aa20bFecha.getFechaFormateada(laFila.getFecre(),
							locale);
				}
				fechaReEl.appendChild(doc.createTextNode(fechaRe));
				filaEl.appendChild(fechaReEl);

				Element nombreEl = doc.createElement("SOLICIT");
				nombreEl.appendChild(doc
						.createTextNode(laFila.getNombre() == null ? ""
								: laFila.getNombre()));
				filaEl.appendChild(nombreEl);

				Element telefoEl = doc.createElement("TELEFO");
				telefoEl.appendChild(doc
						.createTextNode(laFila.getTelefono() == null ? ""
								: laFila.getTelefono()));
				filaEl.appendChild(telefoEl);

				Element claseEl = doc.createElement("CLASE");
				String clase = "";
				if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
					clase = laFila.getEclase() == null ? " " : laFila
							.getEclase();
				} else {
					clase = laFila.getCclase() == null ? " " : laFila
							.getCclase();
				}
				claseEl.appendChild(doc.createTextNode(clase));
				filaEl.appendChild(claseEl);

				Element edifEl = doc.createElement("EDIF");
				String edificio = "";
				if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
					edificio = laFila.getEedificio() == null ? " " : laFila
							.getEedificio();
				} else {
					edificio = laFila.getCedificio() == null ? " " : laFila
							.getCedificio();
				}
				edifEl.appendChild(doc.createTextNode(edificio));
				filaEl.appendChild(edifEl);

				Element codigoEl = doc.createElement("CODIGO");
				String codigo = "";
				if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
					codigo = laFila.getEcodigo() == null ? " " : laFila
							.getEcodigo();
				} else {
					codigo = laFila.getCcodigo() == null ? " " : laFila
							.getCcodigo();
				}
				codigoEl.appendChild(doc.createTextNode(codigo));
				filaEl.appendChild(codigoEl);

				Element zonaEl = doc.createElement("ZONA");
				String zona = "";
				if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
					zona = laFila.getEzona() == null ? " " : laFila.getEzona();
				} else {
					zona = laFila.getCzona() == null ? " " : laFila.getCzona();
				}
				zonaEl.appendChild(doc.createTextNode(zona));
				filaEl.appendChild(zonaEl);

				Element deparEl = doc.createElement("DEPAR");
				String depar = "";
				if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
					depar = laFila.getEdepar() == null ? " " : laFila
							.getEdepar();
				} else {
					depar = laFila.getCdepar() == null ? " " : laFila
							.getCdepar();
				}
				deparEl.appendChild(doc.createTextNode(depar));
				filaEl.appendChild(deparEl);

				Element plantaEl = doc.createElement("PLANTA");
				String planta = "";
				if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
					planta = laFila.getEplanta() == null ? " " : laFila
							.getEplanta();
				} else {
					planta = laFila.getCplanta() == null ? " " : laFila
							.getCplanta();
				}
				plantaEl.appendChild(doc.createTextNode(planta));
				filaEl.appendChild(plantaEl);

				Element direccionEl = doc.createElement("DIRECCION");
				String direccion = "";
				if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
					direccion = laFila.getEdir() == null ? " " : laFila
							.getEdir();
				} else {
					direccion = laFila.getCdir() == null ? " " : laFila
							.getCdir();
				}
				direccionEl.appendChild(doc.createTextNode(direccion));
				filaEl.appendChild(direccionEl);

				Element observEl = doc.createElement("OBSERV");
				observEl.appendChild(doc.createTextNode(laFila
						.getObservaciones() == null ? "" : laFila
						.getObservaciones()));
				filaEl.appendChild(observEl);

				Element fechaEjEl = doc.createElement("FECHAEJ");
				String fechaEjec = " ";
				if (laFila.getFeejec() != null) {
					fechaEjec = Aa20bFecha.getFechaFormateada(
							laFila.getFeejec(), locale);
				}
				fechaEjEl.appendChild(doc.createTextNode(fechaEjec));
				filaEl.appendChild(fechaEjEl);

				Element tiempoRealEl = doc.createElement("TIEMPOREAL");
				tiempoRealEl.appendChild(doc.createTextNode(laFila
						.getTiemporeal() == null ? "" : laFila.getTiemporeal()
						/ 60 + ":" + laFila.getTiemporeal() % 60));
				filaEl.appendChild(tiempoRealEl);

				listadoEl.appendChild(filaEl);
				// Correctivos.logger.info("1xml Correctivos: "
				// + nodeToString(listadoEl));

			}
			rootElement.appendChild(listadoEl);

			// return doc;
			// del for de listaGrupos

		} catch (Exception e) {
			Correctivos.logger.info("eror xml Correctivos: ");
		}
		Correctivos.logger
				.info("xml Correctivos: " + nodeToString(rootElement));

		return doc;

	}

	@SuppressWarnings("unused")
	private String nodeToString(Node node) {// element

		StringWriter sw = new StringWriter();

		try {

			Transformer t = TransformerFactory.newInstance().newTransformer();

			t.setOutputProperty(OutputKeys.ENCODING, "ISO-8859-1");

			t.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION, "no");

			t.setOutputProperty(OutputKeys.INDENT, "yes");

			t.transform(new DOMSource(node), new StreamResult(sw));

		} catch (TransformerException te) {

		}

		return sw.toString();

	}

}
