package com.ejie.aa20b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.Tecnicos;
import com.ejie.aa20b.model.Usutecnicos;

/**
 * UsutecnicosDaoImpl generated by UDA, 11-mar-2015 9:14:58.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class UsutecnicosDaoImpl implements UsutecnicosDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Usutecnicos> rwMap = new RowMapper<Usutecnicos>() {
		public Usutecnicos mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Usutecnicos(resultSet.getString("UIDPER"),
					resultSet.getLong("IDTECNICO"), null);
		}
	};

	private RowMapper<Usutecnicos> rwMapUsutecnicos = new RowMapper<Usutecnicos>() {
		public Usutecnicos mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Usutecnicos usutecnico = new Usutecnicos();

			usutecnico.setUidPer(resultSet.getString("UIDPER"));
			usutecnico.setIdtecnico(resultSet.getLong("IDTECNICO"));

			Tecnicos tecnico = new Tecnicos();
			tecnico.setNombre(resultSet.getString("NOMBRE"));
			usutecnico.setTecnico(tecnico);

			return usutecnico;

		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Usutecnicos table.
	 * 
	 * @param usutecnicos
	 *            Pagination
	 * @return Usutecnicos
	 */
	public Usutecnicos add(Usutecnicos usutecnicos) {
		String query = "INSERT INTO USUTECNICOS (UID_PER, IDTECNICO) VALUES (?,?)";
		this.jdbcTemplate.update(query, usutecnicos.getUidPer(),
				usutecnicos.getIdtecnico());
		return usutecnicos;
	}

	/**
	 * Updates a single row in the Usutecnicos table.
	 * 
	 * @param usutecnicos
	 *            Pagination
	 * @return Usutecnicos
	 */
	public Usutecnicos update(Usutecnicos usutecnicos) {
		String query = "UPDATE USUTECNICOS SET  WHERE UID_PER=? AND IDTECNICO=?";
		this.jdbcTemplate.update(query, usutecnicos.getUidPer(),
				usutecnicos.getIdtecnico());
		return usutecnicos;
	}

	/**
	 * Elimina todos los tecnicos asociados a un usuario in the Usutecnicos
	 * table.
	 * 
	 * @param usutecnicos
	 *            String
	 * @return Usutecnicos
	 */
	public Usutecnicos restaTodosTecnicosUsu(Usutecnicos usutecnicos) {
		String query = "DELETE FROM USUTECNICOS WHERE UID_PER=? ";
		this.jdbcTemplate.update(query, usutecnicos.getUidPer());
		return usutecnicos;
	}

	/**
	 * Finds a single row in the Usutecnicos table.
	 * 
	 * @param usutecnicos
	 *            Pagination
	 * @return Usutecnicos
	 */
	@Transactional(readOnly = true)
	public Usutecnicos find(Usutecnicos usutecnicos) {
		String query = "SELECT t1.UID_PER UIDPER, t1.IDTECNICO IDTECNICO FROM USUTECNICOS t1  WHERE t1.UID_PER = ?   AND t1.IDTECNICO = ?  ";

		List<Usutecnicos> usutecnicosList = this.jdbcTemplate
				.query(query, this.rwMap, usutecnicos.getUidPer(),
						usutecnicos.getIdtecnico());
		return (Usutecnicos) DataAccessUtils.uniqueResult(usutecnicosList);
	}

	@Transactional(readOnly = true)
	public Usutecnicos findTecnicoUsuario(Usutecnicos usutecnicos) {
		String query = "SELECT t1.UID_PER UIDPER, t1.IDTECNICO IDTECNICO, t2.NOMBRE NOMBRE FROM USUTECNICOS t1, TECNICOS t2  WHERE t1.IDTECNICO=t2.IDTECNICO(+) AND t1.UID_PER = ? AND t1.IDTECNICO = ?  ";

		List<Usutecnicos> usutecnicosList = this.jdbcTemplate.query(query,
				this.rwMapUsutecnicos, usutecnicos.getUidPer(),
				usutecnicos.getIdtecnico());
		return (Usutecnicos) DataAccessUtils.uniqueResult(usutecnicosList);
	}

	/**
	 * Removes a single row in the Usutecnicos table.
	 * 
	 * @param usutecnicos
	 *            Pagination
	 * @return
	 */
	public void remove(Usutecnicos usutecnicos) {
		String query = "DELETE FROM USUTECNICOS WHERE UID_PER=? AND IDTECNICO=?";
		this.jdbcTemplate.update(query, usutecnicos.getUidPer(),
				usutecnicos.getIdtecnico());
	}

	/**
	 * Elimina todos los tecnicos asociados a un usuario.
	 * 
	 * @param usutecnicos
	 *            Pagination
	 * @return
	 */
	public void eliminarTecnicosUsuario(Usutecnicos usutecnicos) {
		String query = "DELETE FROM USUTECNICOS WHERE UID_PER=? ";
		this.jdbcTemplate.update(query, usutecnicos.getUidPer());
	}

	/**
	 * Finds a List of rows in the Usutecnicos table.
	 * 
	 * @param usutecnicos
	 *            Usutecnicos
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Usutecnicos> findAll(Usutecnicos usutecnicos,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.UID_PER UIDPER,t1.IDTECNICO IDTECNICO ");
		query.append("FROM USUTECNICOS t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(usutecnicos);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Usutecnicos>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds a List of rows in the Usutecnicos table.
	 * 
	 * @param idUsuario
	 *            Integer
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Usutecnicos> obtenerTecnicosUsuarioAsignados(String idUsuario) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.UID_PER UIDPER,t1.IDTECNICO IDTECNICO, t2.NOMBRE NOMBRE ");
		query.append("FROM USUTECNICOS t1, TECNICOS t2 ");

		StringBuilder where = new StringBuilder(
				" WHERE  t1.IDTECNICO=t2.IDTECNICO(+) AND t1.UID_PER=? ");
		query.append(where);
		query.append(" ORDER BY t2.NOMBRE ");

		return (List<Usutecnicos>) this.jdbcTemplate.query(query.toString(),
				this.rwMapUsutecnicos, idUsuario);
	}

	/**
	 * Finds a List of rows in the Usutecnicos table.
	 * 
	 * @param idUsuario
	 *            String
	 * @param idServicio
	 *            Integer
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Usutecnicos> obtenerTecnicosUsuarioLibres(String idUsuario,
			Integer idServicio) {

		// Obtiene los tecnicos libres que pertenezcan a los edificios que tiene
		// asociado el usuario

		StringBuilder query = new StringBuilder(
				"SELECT DISTINCT t1.UID_PER UIDPER,  t2.IDTECNICO IDTECNICO,  t3.NOMBRE NOMBRE FROM ( ");

		query.append(" (EDIFICIOSVER t1 INNER JOIN TECNICO_EDIF t2 ON t1.IDEDIFICIO=t2.IDEDIFICIO) ");
		query.append(" INNER JOIN TECNICOS t3 ON t2.IDTECNICO = t3.IDTECNICO) ");
		StringBuilder where = new StringBuilder("  WHERE t1.UID_PER =? ");
		if (idServicio != null && idServicio != 0) {
			where.append(" AND t3.idservicio=? ");
		}
		where.append(" AND (t3.BAJA='0' OR t3.BAJA IS NULL) AND t2.idtecnico NOT IN (SELECT t5.IDTECNICO FROM USUTECNICOS t5 where t5.UID_PER = ?) ORDER BY t3.NOMBRE ");
		query.append(where);

		if (idServicio != null && idServicio != 0) {
			return (List<Usutecnicos>) this.jdbcTemplate.query(
					query.toString(), this.rwMapUsutecnicos, idUsuario,
					idServicio, idUsuario);
		} else {
			return (List<Usutecnicos>) this.jdbcTemplate.query(
					query.toString(), this.rwMapUsutecnicos, idUsuario,
					idUsuario);
		}
	}

	/**
	 * Obtiene tecnicos asociados al usuario que pertenecen al edificio que se
	 * va a desasociar Y que no están en los edificios que todavía mantiene
	 * asociados.
	 * 
	 * @param idUsuario
	 *            String
	 * @param edificiosSeleccionados
	 *            ArrayList<String>
	 * @param edificiosNOSeleccionados
	 *            ArrayList<String>
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Usutecnicos> comprobarTecnicosEdificio(String idUsuario,
			ArrayList<String> edificiosSeleccionados,
			ArrayList<String> edificiosNOSeleccionados) {

		StringBuilder query = new StringBuilder("");
		String edificiosSel = edificiosSeleccionados.toString();
		edificiosSel = edificiosSel.substring(1, edificiosSel.length() - 1);
		String edificiosNOSel = edificiosNOSeleccionados.toString();
		edificiosNOSel = edificiosNOSel.substring(1,
				edificiosNOSel.length() - 1);

		query = new StringBuilder(
				" SELECT DISTINCT t4.UID_PER UIDPER,t2.IDTECNICO IDTECNICO, t3.NOMBRE NOMBRE ");
		query.append(" FROM ( TECNICO_EDIF t2 INNER JOIN TECNICOS t3 ON t2.IDTECNICO=t3.IDTECNICO) INNER JOIN USUTECNICOS t4 ON t2.IDTECNICO  =t4.IDTECNICO ");
		query.append(" WHERE t4.UID_PER = ? AND t2.IDEDIFICIO IN ( "
				+ edificiosSel + "  )");
		if (edificiosNOSel != null && !edificiosNOSel.equals("")) {
			query.append(" AND t2.IDEDIFICIO NOT IN ( " + edificiosNOSel
					+ "  )");
		}

		query.append(" ORDER BY t3.NOMBRE");

		List<Usutecnicos> listaTec = this.jdbcTemplate.query(query.toString(),
				this.rwMapUsutecnicos, idUsuario);

		if (listaTec.size() > 0) {
			// Si ha encontrado alguno los devolvemos para comprobar si
			return listaTec;
		}
		// si no ha encontrado ninguno perfecto. se puede desasociar el
		// edificio.
		return null;

	}

	/**
	 * Counts rows in the Usutecnicos table.
	 * 
	 * @param usutecnicos
	 *            Usutecnicos
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Usutecnicos usutecnicos) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM USUTECNICOS t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(usutecnicos);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Usutecnicos table using like.
	 * 
	 * @param usutecnicos
	 *            Usutecnicos
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Usutecnicos> findAllLike(Usutecnicos usutecnicos,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.UID_PER UIDPER,t1.IDTECNICO IDTECNICO, t2.NOMBRE ");
		query.append("FROM USUTECNICOS t1, TECNICOS t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(usutecnicos, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE t1.IDTECNICO=t2.IDTECNICO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Usutecnicos>) this.jdbcTemplate.query(query.toString(),
				this.rwMapUsutecnicos, params.toArray());
	}

	/**
	 * Counts rows in the Usutecnicos table using like.
	 * 
	 * @param usutecnicos
	 *            Usutecnicos
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Usutecnicos usutecnicos, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM USUTECNICOS t1, TECNICOS t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(usutecnicos, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE t1.IDTECNICO=t2.IDTECNICO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Obtener tecnicos de asociados a un edificio/Zona y al mismo servicio que
	 * el código de Parte
	 * 
	 * @param idCodigo
	 *            Integer
	 * @param idEdificio
	 *            String
	 * @param idZona
	 *            Integer
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Usutecnicos> obtenerTecnicosUsuServEdificio(Integer idCodigo,
			String idEdificio, Integer idZona, boolean soloMovilGmao) {
		// Tienen que ser tecnicos que no tengan la marca de contrata
		/*
		 * StringBuilder query = new StringBuilder(
		 * "SELECT t1.IDTECNICO IDTECNICO, t1.NOMBRE, t2.UID_PER UIDPER FROM TECNICOS t1, USUTECNICOS t2, USUARIOS t3, CODIGO t4, EDIFICIOSVER t5 "
		 * );
		 * 
		 * StringBuilder where = new StringBuilder(
		 * " WHERE t1.IDTECNICO=t2.IDTECNICO AND t2.UID_PER=t3.UID_PER AND t3.RESPONSABLE=1 AND t1.TECNICO_CONTRATA=0 AND t3.IDSERVICIO=t4.IDSERVICIO AND t3.UID_PER=t5.UID_PER "
		 * ); where.append(" AND t4.IDCODIGO=? AND t5.IDEDIFICIO=?");
		 * query.append(where);
		 */

		// Tienen que ser tecnicos que no estén de baja, que no tengan la marca
		// de contrata, asociados al servicio al que pertenece el codigo de
		// parte, y asignados al edificicio/zona
		StringBuilder query = new StringBuilder(
				"SELECT t1.IDTECNICO IDTECNICO, t1.NOMBRE NOMBRE, '' UIDPER ");
		query.append(" FROM TECNICOS t1, CODIGO t2, TECNICO_EDIF t3 ");

		StringBuilder where = new StringBuilder(
				" WHERE t2.IDSERVICIO = t1.IDSERVICIO AND t1.IDTECNICO = t3.IDTECNICO ");
		// Tecnicos que esten de alta y no sean de contrata
		where.append(" AND t1.TECNICO_CONTRATA = 0 AND t1.BAJA = 0 ");
		// Si esta activada solo búsqueda técnicos con aplicación móvil
		if (soloMovilGmao) {
			where.append(" AND t1.MOVILGMAO = 1 ");
		}
		// Asociados al mismo servicio que el códido del parte y al mismo
		// edificio
		where.append(" AND t2.IDCODIGO=? AND t3.IDEDIFICIO=? ");
		// Asociados a la misma zona (si la zona es cero quiere decir que el
		// tecnico está asociado a todo el edificio)
		where.append(" AND (t3.IDZONA = ? OR t3.IDZONA = '0') ");

		query.append(where);

		return (List<Usutecnicos>) this.jdbcTemplate.query(query.toString(),
				this.rwMapUsutecnicos, idCodigo, idEdificio, idZona);
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Usutecnicos entity
	 * 
	 * @param usutecnicos
	 *            Usutecnicos Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Usutecnicos usutecnicos) {

		StringBuilder where = new StringBuilder(
				UsutecnicosDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (usutecnicos != null && usutecnicos.getUidPer() != null) {
			where.append(" AND t1.UID_PER = ?");
			params.add(usutecnicos.getUidPer());
		}
		if (usutecnicos != null && usutecnicos.getIdtecnico() != null) {
			where.append(" AND t1.IDTECNICO = ?");
			params.add(usutecnicos.getIdtecnico());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Usutecnicos entity
	 * 
	 * @param usutecnicos
	 *            Usutecnicos Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Usutecnicos usutecnicos,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				UsutecnicosDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (usutecnicos != null && usutecnicos.getUidPer() != null) {
			where.append(" AND UPPER(t1.UID_PER) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(usutecnicos.getUidPer().toUpperCase() + "%");
			} else {
				params.add("%" + usutecnicos.getUidPer().toUpperCase() + "%");
			}
			where.append(" AND t1.UID_PER IS NOT NULL");
		}
		if (usutecnicos != null && usutecnicos.getTecnico() != null
				&& usutecnicos.getTecnico().getNombre() != null) {
			where.append(" AND UPPER(t2.NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(usutecnicos.getTecnico().getNombre().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ usutecnicos.getTecnico().getNombre().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.NOMBRE IS NOT NULL");
		}
		if (usutecnicos != null && usutecnicos.getIdtecnico() != null) {
			where.append(" AND t1.IDTECNICO = ?");
			params.add(usutecnicos.getIdtecnico());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
