package com.ejie.aa20b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.RolesMovil;
import com.ejie.aa20b.model.Tecnicos;
import com.ejie.aa20b.model.UsuariosMovil;

/**
 * UsuariosDaoImpl generated by UDA, 10-mar-2015 14:56:20.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class UsuariosMovilDaoImpl implements UsuariosMovilDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<UsuariosMovil> rwMap = new RowMapper<UsuariosMovil>() {
		public UsuariosMovil mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			UsuariosMovil usuarioMovil = new UsuariosMovil();
			usuarioMovil.setIdUsuarioMovil(resultSet.getInt("IDUSUARIO"));
			usuarioMovil.setLogin(resultSet.getString("LOGIN"));
			usuarioMovil.setRol(resultSet.getString("ROL"));
			usuarioMovil.setNombreBD(resultSet.getString("NOMBREBD"));
			usuarioMovil.setPasswordHash("PASSWORDHASH");
			usuarioMovil.setImei(resultSet.getString("IMEI"));
			usuarioMovil.setIdTecnico(resultSet.getString("IDTECNICO"));
			usuarioMovil.setFechaUltimaSinc(resultSet
					.getTimestamp("FECHAULTIMASINC"));
			usuarioMovil.setIdIdioma(resultSet.getString("IDIDIOMA"));
			usuarioMovil.setEmail(resultSet.getString("EMAIL"));
			usuarioMovil.setVersionApp(resultSet.getString("VERSIONAPP"));
			usuarioMovil.setDeviceName(resultSet.getString("DEVICENAME"));
			usuarioMovil.setDeviceVersion(resultSet.getString("DEVICEVERSION"));
			usuarioMovil.setDevicePlatform(resultSet
					.getString("DEVICEPLATFORM"));

			RolesMovil rolMovil = new RolesMovil();
			rolMovil.setIdRol(resultSet.getInt("IDROL"));
			rolMovil.setIdRolGmao(resultSet.getString("ROL"));
			rolMovil.setDescRol(resultSet.getString("DESCROL"));
			rolMovil.setSistema(resultSet.getString("SISTEMA"));

			usuarioMovil.setRolMovil(rolMovil);

			Tecnicos tecnico = new Tecnicos();
			tecnico.setIdtecnico(resultSet.getLong("IDTECNICOAA20"));
			tecnico.setNombre(resultSet.getString("NOMBRE"));
			tecnico.setBaja(resultSet.getString("BAJA"));
			tecnico.setTecnicoContrata(resultSet.getString("TECNICO_CONTRATA"));

			usuarioMovil.setTecnico(tecnico);
			return usuarioMovil;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Usuarios table.
	 * 
	 * @param usuariosMovil
	 *            Pagination
	 * @return UsuariosMovil
	 */
	public UsuariosMovil add(UsuariosMovil usuariosMovil) {

		final Integer nextId = this.jdbcTemplate
				.queryForInt("SELECT USUARIOSMOVIL_SEQ.NEXTVAL FROM DUAL");

		usuariosMovil.setIdUsuarioMovil(nextId);

		String query = "INSERT INTO USUARIOSMOVIL (IDUSUARIO,LOGIN, ROL, NOMBREBD, PASSWORDHASH, IMEI, IDTECNICO, FECHAULTIMASINC, IDIDIOMA, EMAIL, VERSIONAPP, DEVICENAME, DEVICEVERSION, DEVICEPLATFORM) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, usuariosMovil.getIdUsuarioMovil(),
				usuariosMovil.getLogin(), usuariosMovil.getRol(),
				usuariosMovil.getNombreBD(), usuariosMovil.getPasswordHash(),
				usuariosMovil.getImei(), usuariosMovil.getIdTecnico(),
				usuariosMovil.getFechaUltimaSinc(),
				usuariosMovil.getIdIdioma(), usuariosMovil.getEmail(),
				usuariosMovil.getVersionApp(), usuariosMovil.getDeviceName(),
				usuariosMovil.getDeviceVersion(),
				usuariosMovil.getDevicePlatform());
		return usuariosMovil;
	}

	/**
	 * Updates a single row in the UsuariosMovil table.
	 * 
	 * @param usuariosMovil
	 *            Pagination
	 * @return UsuariosMovil
	 */
	public UsuariosMovil update(UsuariosMovil usuariosMovil) {
		String query = "UPDATE USUARIOSMOVIL SET IDIDIOMA=?, PASSWORDHASH=?, EMAIL=?, IMEI=?, FECHAULTIMASINC=?,VERSIONAPP=?,DEVICENAME=?,DEVICEVERSION=?,DEVICEPLATFORM=?,IDTECNICO=? WHERE IDUSUARIO=?";
		this.jdbcTemplate
				.update(query, usuariosMovil.getIdIdioma(),
						usuariosMovil.getPasswordHash(),
						usuariosMovil.getEmail(), usuariosMovil.getImei(),
						usuariosMovil.getFechaUltimaSinc(),
						usuariosMovil.getVersionApp(),
						usuariosMovil.getDeviceName(),
						usuariosMovil.getDeviceVersion(),
						usuariosMovil.getDevicePlatform(),
						usuariosMovil.getIdTecnico(),
						usuariosMovil.getIdUsuarioMovil());
		return usuariosMovil;
	}

	/**
	 * Finds a single row in the UsuariosMovil table.
	 * 
	 * @param usuariosMovil
	 *            Pagination
	 * @return UsuariosMovil
	 */
	@Transactional(readOnly = true)
	public UsuariosMovil find(UsuariosMovil usuariosMovil) {
		String query = "SELECT t1.IDUSUARIO IDUSUARIO, t1.LOGIN LOGIN, t1.ROL ROL, t1.NOMBREBD NOMBREBD, t1.PASSWORDHASH PASSWORDHASH, t1.IMEI IMEI, t1.IDTECNICO IDTECNICO, t1.FECHAULTIMASINC FECHAULTIMASINC, t1.IDIDIOMA IDIDIOMA, t1.EMAIL EMAIL, t1.VERSIONAPP VERSIONAPP, t1.DEVICENAME DEVICENAME, t1.DEVICEVERSION DEVICEVERSION, t1.DEVICEPLATFORM DEVICEPLATFORM, t2.IDROL IDROL, t2.DESCROL DESCROL, t2.SISTEMA SISTEMA,t3.IDTECNICO IDTECNICOAA20, t3.NOMBRE NOMBRE, t3.BAJA BAJA, t3.TECNICO_CONTRATA TECNICO_CONTRATA FROM USUARIOSMOVIL t1, ROLESMOVIL t2, TECNICOS t3 WHERE t1.ROL = t2.IDROLGMAO(+) AND t1.IDTECNICO = t3.IDTECNICO(+) AND IDUSUARIO = ? ";

		List<UsuariosMovil> usuariosMovilList = this.jdbcTemplate.query(query,
				this.rwMap, usuariosMovil.getIdUsuarioMovil());
		return (UsuariosMovil) DataAccessUtils.uniqueResult(usuariosMovilList);
	}

	@Transactional(readOnly = true)
	public UsuariosMovil findByLogin(UsuariosMovil usuariosMovil) {
		String query = "SELECT t1.IDUSUARIO IDUSUARIO, t1.LOGIN LOGIN, t1.ROL ROL, t1.NOMBREBD NOMBREBD, t1.PASSWORDHASH PASSWORDHASH, t1.IMEI IMEI, t1.IDTECNICO IDTECNICO, t1.FECHAULTIMASINC FECHAULTIMASINC, t1.IDIDIOMA IDIDIOMA, t1.EMAIL EMAIL, t1.VERSIONAPP VERSIONAPP, t1.DEVICENAME DEVICENAME, t1.DEVICEVERSION DEVICEVERSION, t1.DEVICEPLATFORM DEVICEPLATFORM, t2.IDROL IDROL, t2.DESCROL DESCROL, t2.SISTEMA SISTEMA,t3.IDTECNICO IDTECNICOAA20, t3.NOMBRE NOMBRE, t3.BAJA BAJA, t3.TECNICO_CONTRATA TECNICO_CONTRATA FROM USUARIOSMOVIL t1, ROLESMOVIL t2, TECNICOS t3 WHERE t1.ROL = t2.IDROLGMAO(+) AND t1.IDTECNICO = t3.IDTECNICO(+) AND UPPER(LOGIN) = ? ";

		List<UsuariosMovil> usuariosMovilList = this.jdbcTemplate.query(query,
				this.rwMap, usuariosMovil.getLogin().toUpperCase().trim());
		return (UsuariosMovil) DataAccessUtils.uniqueResult(usuariosMovilList);
	}

	/**
	 * Removes a single row in the UsuariosMovil table.
	 * 
	 * @param usuariosMovil
	 *            Pagination
	 * @return
	 */
	public void remove(UsuariosMovil usuariosMovil) {
		String query = "DELETE FROM USUARIOSMOVIL WHERE IDUSUARIO=?";
		this.jdbcTemplate.update(query, usuariosMovil.getIdUsuarioMovil());
	}

	/**
	 * Finds a List of rows in the UsuariosMovil table.
	 * 
	 * @param usuariosMoviñl
	 *            UsuariosMovil
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<UsuariosMovil> findAll(UsuariosMovil usuariosMovil,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.IDUSUARIO IDUSUARIO, t1.LOGIN LOGIN, t1.ROL ROL, t1.NOMBREBD NOMBREBD, t1.PASSWORDHASH PASSWORDHASH, t1.IMEI IMEI, t1.IDTECNICO IDTECNICO, t1.FECHAULTIMASINC FECHAULTIMASINC, t1.IDIDIOMA IDIDIOMA, t1.EMAIL EMAIL, t1.VERSIONAPP VERSIONAPP, t1.DEVICENAME DEVICENAME, t1.DEVICEVERSION DEVICEVERSION, t1.DEVICEPLATFORM DEVICEPLATFORM, t2.IDROL IDROL,t2.DESCROL DESCROL,t2.SISTEMA SISTEMA,t3.IDTECNICO IDTECNICOAA20, t3.NOMBRE NOMBRE, t3.BAJA BAJA, t3.TECNICO_CONTRATA TECNICO_CONTRATA ");
		query.append("FROM USUARIOSMOVIL t1, ROLESMOVIL t2, TECNICOS t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(usuariosMovil);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ROL = t2.IDROLGMAO(+) AND t1.IDTECNICO = t3.IDTECNICO(+) AND t1.LOGIN != 'TradEus' and t1.LOGIN != 'TradGV' ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<UsuariosMovil>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the UsuariosMovil table.
	 * 
	 * @param usuariosMovil
	 *            UsuariosMovil
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(UsuariosMovil usuariosMovil) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM USUARIOSMOVIL t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(usuariosMovil);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the UsuariosMovil table using like.
	 * 
	 * @param usuariosMovil
	 *            UsuariosMovil
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<UsuariosMovil> findAllLike(UsuariosMovil usuariosMovil,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.IDUSUARIO IDUSUARIO, t1.LOGIN LOGIN, t1.ROL ROL, t1.NOMBREBD NOMBREBD, t1.PASSWORDHASH PASSWORDHASH, t1.IMEI IMEI, t1.IDTECNICO IDTECNICO, t1.FECHAULTIMASINC FECHAULTIMASINC, t1.IDIDIOMA IDIDIOMA, t1.EMAIL EMAIL, t1.VERSIONAPP VERSIONAPP, t1.DEVICENAME DEVICENAME, t1.DEVICEVERSION DEVICEVERSION, t1.DEVICEPLATFORM DEVICEPLATFORM, t2.IDROL IDROL,t2.DESCROL DESCROL, t2.SISTEMA SISTEMA, t3.NOMBRE NOMBRE,t3.IDTECNICO IDTECNICOAA20, t3.BAJA BAJA, t3.TECNICO_CONTRATA TECNICO_CONTRATA ");
		query.append("FROM USUARIOSMOVIL t1, ROLESMOVIL t2, TECNICOS t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(usuariosMovil,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ROL = t2.IDROLGMAO(+) AND t1.IDTECNICO = t3.IDTECNICO(+) AND t1.LOGIN != 'TradEus' and t1.LOGIN != 'TradGV' ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<UsuariosMovil>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the UsuariosMovil table using like.
	 * 
	 * @param usuariosMovil
	 *            UsuariosMovil
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(UsuariosMovil usuariosMovil, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM USUARIOSMOVIL t1, ROLESMOVIL t2, TECNICOS t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(usuariosMovil,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ROL = t2.IDROLGMAO(+) AND t1.IDTECNICO = t3.IDTECNICO(+) AND t1.LOGIN != 'TradEus' and t1.LOGIN != 'TradGV' ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the UsuariosMovil entity
	 * 
	 * @param usuariosMovil
	 *            UsuariosMovil Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(UsuariosMovil usuariosMovil) {

		StringBuilder where = new StringBuilder(
				UsuariosMovilDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (usuariosMovil != null && usuariosMovil.getIdUsuarioMovil() != null) {
			where.append(" AND t1.IDUSUARIO = ?");
			params.add(usuariosMovil.getIdUsuarioMovil());
		}
		if (usuariosMovil != null && usuariosMovil.getLogin() != null) {
			where.append(" AND t1.LOGIN = ?");
			params.add(usuariosMovil.getLogin());
		}
		if (usuariosMovil != null && usuariosMovil.getRol() != null) {
			where.append(" AND t1.ROL = ?");
			params.add(usuariosMovil.getRol());
		}
		if (usuariosMovil != null && usuariosMovil.getNombreBD() != null) {
			where.append(" AND t1.NOMBREBD = ?");
			params.add(usuariosMovil.getNombreBD());
		}
		if (usuariosMovil != null && usuariosMovil.getIdTecnico() != null) {
			where.append(" AND t1.IDTECNICO = ?");
			params.add(usuariosMovil.getIdTecnico());
		}
		if (usuariosMovil != null && usuariosMovil.getIdIdioma() != null) {
			where.append(" AND t1.IDIDIOMA = ?");
			params.add(usuariosMovil.getIdIdioma());
		}
		if (usuariosMovil != null && usuariosMovil.getEmail() != null) {
			where.append(" AND t1.EMAIL = ?");
			params.add(usuariosMovil.getEmail());
		}
		if (usuariosMovil != null && usuariosMovil.getVersionApp() != null) {
			where.append(" AND t1.VERSIONAPP = ?");
			params.add(usuariosMovil.getVersionApp());
		}
		if (usuariosMovil != null && usuariosMovil.getDeviceName() != null) {
			where.append(" AND t1.DEVICENAME = ? ");
			params.add(usuariosMovil.getDeviceName());
		}

		if (usuariosMovil != null
				&& usuariosMovil.getFechaUltimaSincD() != null
				&& !usuariosMovil.getFechaUltimaSincD().equals("")) {
			where.append(" AND t1.FECHAULTIMASINC >= ?");
			params.add(usuariosMovil.getFechaUltimaSincD());
		}
		if (usuariosMovil != null
				&& usuariosMovil.getFechaUltimaSincH() != null
				&& !usuariosMovil.getFechaUltimaSincH().equals("")) {
			where.append(" AND t1.FECHAULTIMASINC < ? + 1");
			params.add(usuariosMovil.getFechaUltimaSincH());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the UsuariosMovil entity
	 * 
	 * @param usuariosMovil
	 *            UsuariosMovil Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(UsuariosMovil usuariosMovil,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				UsuariosMovilDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (usuariosMovil != null && usuariosMovil.getLogin() != null) {
			where.append(" AND UPPER(t1.LOGIN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(usuariosMovil.getLogin().toUpperCase() + "%");
			} else {
				params.add("%" + usuariosMovil.getLogin().toUpperCase() + "%");
			}
			where.append(" AND t1.LOGIN IS NOT NULL");
		}
		if (usuariosMovil != null && usuariosMovil.getRol() != null) {
			where.append(" AND UPPER(t1.ROL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(usuariosMovil.getRol().toUpperCase() + "%");
			} else {
				params.add("%" + usuariosMovil.getRol().toUpperCase() + "%");
			}
			where.append(" AND t1.ROL IS NOT NULL");
		}

		if (usuariosMovil != null && usuariosMovil.getEmail() != null) {
			where.append(" AND UPPER(t1.EMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(usuariosMovil.getEmail().toUpperCase() + "%");
			} else {
				params.add("%" + usuariosMovil.getEmail().toUpperCase() + "%");
			}
			where.append(" AND t1.EMAIL IS NOT NULL");
		}
		if (usuariosMovil != null && usuariosMovil.getDeviceName() != null) {
			where.append(" AND UPPER(t2.DEVICENAME) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(usuariosMovil.getDeviceName().toUpperCase() + "%");
			} else {
				params.add("%" + usuariosMovil.getDeviceName().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.DEVICENAME IS NOT NULL");
		}

		if (usuariosMovil != null
				&& usuariosMovil.getFechaUltimaSincD() != null
				&& !usuariosMovil.getFechaUltimaSincD().equals("")) {
			where.append(" AND t1.FECHAULTIMASINC >= ?");
			params.add(usuariosMovil.getFechaUltimaSincD());
		}
		if (usuariosMovil != null
				&& usuariosMovil.getFechaUltimaSincH() != null
				&& !usuariosMovil.getFechaUltimaSincH().equals("")) {
			where.append(" AND t1.FECHAULTIMASINC < ? + 1");
			params.add(usuariosMovil.getFechaUltimaSincH());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
