package com.ejie.aa20b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.aa20b.model.UsuariosMovil;

public interface UsuariosMovilDao {

	/**
	 * Inserts a single row in the UsuariosMovil table.
	 * 
	 * @param usuariosMovil
	 *            UsuariosMovil
	 * @return UsuariosMovil
	 */
	UsuariosMovil add(UsuariosMovil usuariosMovil);

	/**
	 * Updates a single row in the UsuariosMovil table.
	 * 
	 * @param usuariosMovil
	 *            UsuariosMovil
	 * @return UsuariosMovil
	 */
	UsuariosMovil update(UsuariosMovil usuariosMovil);

	/**
	 * Finds a single row in the UsuariosMovil table.
	 * 
	 * @param usuariosMovil
	 *            UsuariosMovil
	 * @return UsuariosMovil
	 */
	UsuariosMovil find(UsuariosMovil usuariosMovil);

	UsuariosMovil findByLogin(UsuariosMovil usuariosMovil);

	/**
	 * Deletes a single row in the UsuariosMovil table.
	 * 
	 * @param usuariosMovil
	 *            UsuariosMovil
	 * @return
	 */
	void remove(UsuariosMovil usuariosMovil);

	/**
	 * Finds a List of rows in the UsuariosMovil table.
	 * 
	 * @param usuariosMovil
	 *            UsuariosMovil
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<UsuariosMovil> findAll(UsuariosMovil usuariosMovil,
			Pagination pagination);

	/**
	 * Counts rows in the UsuariosMovil table.
	 * 
	 * @param usuariosMovil
	 *            UsuariosMovil
	 * @return Long
	 */
	Long findAllCount(UsuariosMovil usuariosMovil);

	/**
	 * Finds rows in the UsuariosMovil table using like.
	 * 
	 * @param usuariosMovil
	 *            UsuariosMovil
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<UsuariosMovil> findAllLike(UsuariosMovil usuariosMovil,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the UsuariosMovil table using like.
	 * 
	 * @param usuariosMovil
	 *            UsuariosMovil
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(UsuariosMovil usuariosMovil, Boolean startsWith);
}
