package com.ejie.aa20b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.Clase;
import com.ejie.aa20b.model.Servicios;
import com.ejie.aa20b.model.Usuarios;

/**
 * UsuariosDaoImpl generated by UDA, 10-mar-2015 14:56:20.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class UsuariosDaoImpl implements UsuariosDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Usuarios> rwMap = new RowMapper<Usuarios>() {
		public Usuarios mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Usuarios usuario = new Usuarios();
			usuario.setUidPer(resultSet.getString("UIDPER"));
			usuario.setNombre(resultSet.getString("NOMBRE"));
			usuario.setResponsable(resultSet.getInt("RESPONSABLE"));
			usuario.setFeini(resultSet.getDate("FEINI"));
			usuario.setBaja(resultSet.getString("BAJA"));
			usuario.setIdservicio(resultSet.getInt("IDSERVICIO"));

			Servicios servicio = new Servicios();
			servicio.setIdservicio(resultSet.getLong("IDSERVICIO"));
			servicio.setCservicio(resultSet.getString("CSERVICIO") == null ? ""
					: resultSet.getString("CSERVICIO"));
			servicio.setEservicio(resultSet.getString("ESERVICIO") == null ? ""
					: resultSet.getString("ESERVICIO"));

			usuario.setServicio(servicio);
			usuario.setEmail(resultSet.getString("EMAIL"));
			usuario.setEmailurgente(resultSet.getString("EMAILURGENTE"));
			usuario.setIdterritorio(resultSet.getString("IDTERRI"));

			Integer idClase = null;
			// Para que si es nulo no coja el 0
			Object claseAux = resultSet.getObject("IDCLASE");
			if (claseAux != null) {
				idClase = resultSet.getInt("IDCLASE");
			}

			usuario.setIdClase(idClase);

			Clase clase = new Clase();
			clase.setCclase(resultSet.getString("CCLASE"));
			clase.setEclase(resultSet.getString("ECLASE"));
			clase.setBaja(resultSet.getString("BAJACLASE"));
			// clase.setIdclase((Integer) resultSet.getObject("IDCLASE"));
			clase.setIdclase(idClase);

			usuario.setClase(clase);

			return usuario;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Usuarios table.
	 * 
	 * @param usuarios
	 *            Pagination
	 * @return Usuarios
	 */
	public Usuarios add(Usuarios usuarios) {
		String query = "INSERT INTO USUARIOS (UID_PER, NOMBRE, RESPONSABLE, FEINI, BAJA, IDSERVICIO, EMAIL, EMAILURGENTE,IDTERRI,IDCLASE) VALUES (?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, usuarios.getUidPer(), usuarios
				.getNombre(), usuarios.getResponsable() == null ? "0"
				: usuarios.getResponsable(), usuarios.getFeini(), usuarios
				.getBaja() == null ? "0" : usuarios.getBaja(), usuarios
				.getIdservicio(), usuarios.getEmail(), usuarios
				.getEmailurgente(), usuarios.getIdterritorio(), usuarios
				.getIdClase());
		return usuarios;
	}

	/**
	 * Updates a single row in the Usuarios table.
	 * 
	 * @param usuarios
	 *            Pagination
	 * @return Usuarios
	 */
	public Usuarios update(Usuarios usuarios) {
		String query = "UPDATE USUARIOS SET NOMBRE=?, RESPONSABLE=?, FEINI=?, BAJA=?, IDSERVICIO=?, EMAIL=?, EMAILURGENTE=?,IDTERRI=?,IDCLASE=? WHERE UID_PER=?";
		this.jdbcTemplate.update(query, usuarios.getNombre(), usuarios
				.getResponsable() == null ? "0" : usuarios.getResponsable(),
				usuarios.getFeini(), usuarios.getBaja() == null ? "0"
						: usuarios.getBaja(), usuarios.getIdservicio(),
				usuarios.getEmail(), usuarios.getEmailurgente(), usuarios
						.getIdterritorio(), usuarios.getIdClase(), usuarios
						.getUidPer());
		return usuarios;
	}

	/**
	 * Finds a single row in the Usuarios table.
	 * 
	 * @param usuarios
	 *            Pagination
	 * @return Usuarios
	 */
	@Transactional(readOnly = true)
	public Usuarios find(Usuarios usuarios) {
		String query = "SELECT t1.UID_PER UIDPER, t1.NOMBRE NOMBRE, t1.RESPONSABLE RESPONSABLE, t1.FEINI FEINI, t1.BAJA BAJA, t1.IDSERVICIO IDSERVICIO, "
				+ "t1.EMAIL EMAIL, t1.EMAILURGENTE EMAILURGENTE, t1.IDTERRI IDTERRI, t2.CSERVICIO CSERVICIO, t2.ESERVICIO ESERVICIO,"
				+ "t1.IDCLASE IDCLASE,t3.CCLASE CCLASE,nvl(t3.ECLASE,t3.CCLASE) ECLASE, t3.BAJA BAJACLASE  "
				+ "FROM USUARIOS t1, SERVICIOS t2,CLASE t3  "
				+ "WHERE t1.IDSERVICIO = t2.IDSERVICIO(+) "
				+ "AND t1.IDCLASE = t3.IDCLASE(+) " + "AND t1.UID_PER = ?  ";

		List<Usuarios> usuariosList = this.jdbcTemplate.query(query,
				this.rwMap, usuarios.getUidPer());
		return (Usuarios) DataAccessUtils.uniqueResult(usuariosList);
	}

	/**
	 * Removes a single row in the Usuarios table.
	 * 
	 * @param usuarios
	 *            Pagination
	 * @return
	 */
	public void remove(Usuarios usuarios) {
		String query = "DELETE FROM USUARIOS WHERE UID_PER=?";
		this.jdbcTemplate.update(query, usuarios.getUidPer());
	}

	/**
	 * Finds a List of rows in the Usuarios table.
	 * 
	 * @param usuarios
	 *            Usuarios
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Usuarios> findAll(Usuarios usuarios, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.UID_PER UIDPER,t1.NOMBRE NOMBRE,t1.RESPONSABLE RESPONSABLE,t1.FEINI FEINI,t1.BAJA BAJA, t1.IDSERVICIO IDSERVICIO, t1.EMAIL EMAIL, "
						+ "t1.EMAILURGENTE EMAILURGENTE, t1.IDTERRI IDTERRI, t2.CSERVICIO CSERVICIO, t2.ESERVICIO ESERVICIO,t1.IDCLASE IDCLASE,t3.CCLASE CCLASE,nvl(t3.ECLASE,t3.CCLASE) ECLASE,t3.BAJA BAJACLASE  ");
		query.append("FROM USUARIOS t1, SERVICIOS t2,CLASE t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(usuarios);
		StringBuilder where = new StringBuilder(
				" WHERE t1.IDSERVICIO = t2.IDSERVICIO(+) AND t1.IDCLASE = t3.IDCLASE(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Usuarios>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Usuarios table.
	 * 
	 * @param usuarios
	 *            Usuarios
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Usuarios usuarios) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM USUARIOS t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(usuarios);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Usuarios table using like.
	 * 
	 * @param usuarios
	 *            Usuarios
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Usuarios> findAllLike(Usuarios usuarios, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.UID_PER UIDPER,t1.NOMBRE NOMBRE,t1.RESPONSABLE RESPONSABLE,t1.FEINI FEINI,t1.BAJA BAJA,t1.IDSERVICIO IDSERVICIO, t1.EMAIL EMAIL, "
						+ "t1.EMAILURGENTE EMAILURGENTE, t1.IDTERRI IDTERRI, t2.CSERVICIO CSERVICIO, t2.ESERVICIO ESERVICIO,t1.IDCLASE IDCLASE,t3.CCLASE CCLASE,nvl(t3.ECLASE,t3.CCLASE) ECLASE,t3.BAJA BAJACLASE  ");
		query.append("FROM USUARIOS t1, SERVICIOS t2,CLASE t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(usuarios, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE t1.IDSERVICIO = t2.IDSERVICIO(+) AND t1.IDCLASE = t3.IDCLASE(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Usuarios>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Usuarios table using like.
	 * 
	 * @param usuarios
	 *            Usuarios
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Usuarios usuarios, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM USUARIOS t1, SERVICIOS t2,CLASE t3  ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(usuarios, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE t1.IDSERVICIO = t2.IDSERVICIO(+) AND t1.IDCLASE = t3.IDCLASE(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Usuarios entity
	 * 
	 * @param usuarios
	 *            Usuarios Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Usuarios usuarios) {

		StringBuilder where = new StringBuilder(
				UsuariosDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (usuarios != null && usuarios.getUidPer() != null) {
			where.append(" AND t1.UID_PER = ?");
			params.add(usuarios.getUidPer());
		}
		if (usuarios != null && usuarios.getNombre() != null) {
			where.append(" AND t1.NOMBRE = ?");
			params.add(usuarios.getNombre());
		}
		if (usuarios != null && usuarios.getResponsable() != null) {
			where.append(" AND t1.RESPONSABLE = ?");
			params.add(usuarios.getResponsable());
		}
		if (usuarios != null && usuarios.getFeini() != null) {
			where.append(" AND t1.FEINI = ?");
			params.add(usuarios.getFeini());
		}
		if (usuarios != null && usuarios.getBaja() != null) {
			where.append(" AND t1.BAJA = ?");
			params.add(usuarios.getBaja());
		}
		if (usuarios != null && usuarios.getIdservicio() != null
				&& usuarios.getIdservicio() != 0) {
			where.append(" AND t1.IDSERVICIO = ?");
			params.add(usuarios.getIdservicio());
		}
		if (usuarios != null && usuarios.getEmail() != null) {
			where.append(" AND t1.EMAIL = ?");
			params.add(usuarios.getEmail());
		}
		if (usuarios != null && usuarios.getEmailurgente() != null) {
			where.append(" AND t1.EMAILURGENTE = ?");
			params.add(usuarios.getEmailurgente());
		}

		if (usuarios != null && usuarios.getIdterritorio() != null) {
			where.append(" AND t1.IDTERRI = ? ");
			params.add(usuarios.getIdterritorio());
		}

		if (usuarios != null && usuarios.getIdClase() != null) {
			where.append(" AND t1.IDCLASE = ? ");
			params.add(usuarios.getIdClase());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Usuarios entity
	 * 
	 * @param usuarios
	 *            Usuarios Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Usuarios usuarios, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				UsuariosDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (usuarios != null && usuarios.getUidPer() != null) {
			where.append(" AND UPPER(t1.UID_PER) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(usuarios.getUidPer().toUpperCase() + "%");
			} else {
				params.add("%" + usuarios.getUidPer().toUpperCase() + "%");
			}
			where.append(" AND t1.UID_PER IS NOT NULL");
		}
		if (usuarios != null && usuarios.getNombre() != null) {
			where.append(" AND UPPER(t1.NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(usuarios.getNombre().toUpperCase() + "%");
			} else {
				params.add("%" + usuarios.getNombre().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE IS NOT NULL");
		}
		if (usuarios != null && usuarios.getResponsable() != null) {
			where.append(" AND t1.RESPONSABLE = ?");
			params.add(usuarios.getResponsable());
		}
		if (usuarios != null && usuarios.getFeini() != null) {
			where.append(" AND t1.FEINI = ?");
			params.add(usuarios.getFeini());
		}
		if (usuarios != null && usuarios.getBaja() != null) {
			where.append(" AND UPPER(t1.BAJA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(usuarios.getBaja().toUpperCase() + "%");
			} else {
				params.add("%" + usuarios.getBaja().toUpperCase() + "%");
			}
			where.append(" AND t1.BAJA IS NOT NULL");
		}
		if (usuarios != null && usuarios.getIdservicio() != null
				&& usuarios.getIdservicio() != 0) {
			where.append(" AND t1.IDSERVICIO = ?");
			params.add(usuarios.getIdservicio());
		}
		if (usuarios != null && usuarios.getServicio() != null
				&& usuarios.getServicio().getCservicio() != null) {
			where.append(" AND UPPER(t2.CSERVICIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(usuarios.getServicio().getCservicio().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ usuarios.getServicio().getCservicio().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.CSERVICIO IS NOT NULL");
		}
		if (usuarios != null && usuarios.getServicio() != null
				&& usuarios.getServicio().getEservicio() != null) {
			where.append(" AND UPPER(t2.ESERVICIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(usuarios.getServicio().getEservicio().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ usuarios.getServicio().getEservicio().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ESERVICIO IS NOT NULL");
		}

		if (usuarios != null && usuarios.getIdClase() != null) {
			where.append(" AND t1.IDCLASE = ? ");
			params.add(usuarios.getIdClase());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
