package com.ejie.aa20b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.Tipopresencia;

/**
 * TipopresenciaDaoImpl generated by UDA, 05-may-2015 13:24:41.
 * @author UDA
 */
 
@Repository
@Transactional
public class TipopresenciaDaoImpl implements TipopresenciaDao {
    private JdbcTemplate jdbcTemplate;
	private RowMapper<Tipopresencia> rwMap = new RowMapper<Tipopresencia>() {
		public Tipopresencia mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new Tipopresencia(
               resultSet.getString("TIPOPRE"), resultSet.getString("CTIPOPRE"), resultSet.getString("ETIPOPRE")
           ); } } ;

	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    /**
     * Inserts a single row in the Tipopresencia table.
     *
     * @param tipopresencia Pagination
     * @return Tipopresencia
     */
	public Tipopresencia add(Tipopresencia tipopresencia) {
    	String query = "INSERT INTO TIPOPRESENCIA (TIPOPRE, CTIPOPRE, ETIPOPRE) VALUES (?,?,?)";
		this.jdbcTemplate.update(query, tipopresencia.getTipopre(), tipopresencia.getCtipopre(), tipopresencia.getEtipopre());
		return tipopresencia;
	}

    /**
     * Updates a single row in the Tipopresencia table.
     *
     * @param tipopresencia Pagination
     * @return Tipopresencia
     */
    public Tipopresencia update(Tipopresencia tipopresencia) {
		String query = "UPDATE TIPOPRESENCIA SET  WHERE TIPOPRE=? AND CTIPOPRE=? AND ETIPOPRE=?";
		this.jdbcTemplate.update(query, tipopresencia.getTipopre(), tipopresencia.getCtipopre(), tipopresencia.getEtipopre());
		return tipopresencia;
	}

    /**
     * Finds a single row in the Tipopresencia table.
     *
     * @param tipopresencia Pagination
     * @return Tipopresencia
     */
    @Transactional (readOnly = true)
    public Tipopresencia find(Tipopresencia tipopresencia) {
		String query = "SELECT t1.TIPOPRE TIPOPRE, t1.CTIPOPRE CTIPOPRE, t1.ETIPOPRE ETIPOPRE FROM TIPOPRESENCIA t1  WHERE t1.TIPOPRE = ?   AND t1.CTIPOPRE = ?   AND t1.ETIPOPRE = ?  ";
		
		List<Tipopresencia> tipopresenciaList = this.jdbcTemplate.query(query, this.rwMap, tipopresencia.getTipopre() , tipopresencia.getCtipopre() , tipopresencia.getEtipopre());
		return (Tipopresencia) DataAccessUtils.uniqueResult(tipopresenciaList);
    }

    /**
     * Removes a single row in the Tipopresencia table.
     *
     * @param tipopresencia Pagination
     * @return
     */
    public void remove(Tipopresencia tipopresencia) {
		String query = "DELETE FROM TIPOPRESENCIA WHERE TIPOPRE=? AND CTIPOPRE=? AND ETIPOPRE=?";
		this.jdbcTemplate.update(query, tipopresencia.getTipopre() , tipopresencia.getCtipopre() , tipopresencia.getEtipopre());
    }
    
   /**
    * Finds a List of rows in the Tipopresencia table.
    * 
    * @param tipopresencia Tipopresencia
    * @param pagination Pagination
    * @return List 
    */
	@Transactional (readOnly = true)
    public List<Tipopresencia> findAll(Tipopresencia tipopresencia, Pagination pagination) {
		StringBuilder query = new StringBuilder("SELECT  t1.TIPOPRE TIPOPRE,t1.CTIPOPRE CTIPOPRE,t1.ETIPOPRE ETIPOPRE "); 
		query.append("FROM TIPOPRESENCIA t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tipopresencia); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		
		return (List<Tipopresencia>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
    /**
     * Counts rows in the Tipopresencia table.
     * 
     * @param tipopresencia Tipopresencia
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(Tipopresencia tipopresencia) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM TIPOPRESENCIA t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tipopresencia); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);		
		
		List<?> params = (List<?>) mapaWhere.get("params");
		
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Finds rows in the Tipopresencia table using like.
     * 
     * @param tipopresencia Tipopresencia
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List 
     */
	@Transactional (readOnly = true)
    public List<Tipopresencia> findAllLike(Tipopresencia tipopresencia, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT  t1.TIPOPRE TIPOPRE,t1.CTIPOPRE CTIPOPRE,t1.ETIPOPRE ETIPOPRE "); 
        query.append("FROM TIPOPRESENCIA t1 ");
      	
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tipopresencia,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		
		return (List<Tipopresencia>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
	/**
	 * Counts rows in the Tipopresencia table using like.
     * 
     * @param tipopresencia Tipopresencia
     * @param startsWith Boolean
     * @return Long 
     */
	@Transactional (readOnly = true)
    public Long findAllLikeCount(Tipopresencia tipopresencia, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM TIPOPRESENCIA t1 ");

		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tipopresencia,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by 
	 * the Tipopresencia entity 
	 * 
	 * @param tipopresencia Tipopresencia
	 *            Bean with the criteria values to filter by.
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap (Tipopresencia tipopresencia){
		
		StringBuilder where = new StringBuilder(TipopresenciaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tipopresencia  != null  && tipopresencia.getTipopre() != null ) {
			where.append(" AND t1.TIPOPRE = ?");
			params.add(tipopresencia.getTipopre());
		}
		if (tipopresencia  != null  && tipopresencia.getCtipopre() != null ) {
			where.append(" AND t1.CTIPOPRE = ?");
			params.add(tipopresencia.getCtipopre());
		}
		if (tipopresencia  != null  && tipopresencia.getEtipopre() != null ) {
			where.append(" AND t1.ETIPOPRE = ?");
			params.add(tipopresencia.getEtipopre());
		}

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by  
	 * the Tipopresencia entity 
	 * 
	 * @param tipopresencia Tipopresencia
	 *            Bean with the criteria values to filter by.
     * @param startsWith Boolean	 
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap (Tipopresencia tipopresencia, Boolean startsWith){
		
		StringBuilder where = new StringBuilder(TipopresenciaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tipopresencia  != null  && tipopresencia.getTipopre() != null ) {
			where.append(" AND UPPER(t1.TIPOPRE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tipopresencia.getTipopre().toUpperCase() +"%");
			}else{
				params.add("%"+tipopresencia.getTipopre().toUpperCase() +"%");
			}
			where.append(" AND t1.TIPOPRE IS NOT NULL");
	     }			
		if (tipopresencia  != null  && tipopresencia.getCtipopre() != null ) {
			where.append(" AND UPPER(t1.CTIPOPRE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tipopresencia.getCtipopre().toUpperCase() +"%");
			}else{
				params.add("%"+tipopresencia.getCtipopre().toUpperCase() +"%");
			}
			where.append(" AND t1.CTIPOPRE IS NOT NULL");
	     }			
		if (tipopresencia  != null  && tipopresencia.getEtipopre() != null ) {
			where.append(" AND UPPER(t1.ETIPOPRE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tipopresencia.getEtipopre().toUpperCase() +"%");
			}else{
				params.add("%"+tipopresencia.getEtipopre().toUpperCase() +"%");
			}
			where.append(" AND t1.ETIPOPRE IS NOT NULL");
	     }			

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * StringBuilder initilization value
	 */
	 public static final int STRING_BUILDER_INIT = 4096;}

