package com.ejie.aa20b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.Servicios;
import com.ejie.aa20b.model.Tecnicos;

/**
 * TecnicosDaoImpl generated by UDA, 22-dic-2014 10:11:52.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class TecnicosDaoImpl implements TecnicosDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Tecnicos> rwMap = new RowMapper<Tecnicos>() {
		public Tecnicos mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Tecnicos tecnico = new Tecnicos();
			tecnico.setIdtecnico(resultSet.getLong("IDTECNICO"));
			tecnico.setNombre(resultSet.getString("NOMBRE"));
			tecnico.setTelefo(resultSet.getString("TELEFO"));
			tecnico.setMail(resultSet.getString("MAIL"));
			tecnico.setBaja(resultSet.getString("BAJA"));
			tecnico.setEquipo(resultSet.getString("EQUIPO"));
			tecnico.setTecnicoContrata(resultSet.getString("TECNICOCONTRATA"));
			tecnico.setUidPer(resultSet.getString("UIDPER"));

			tecnico.setIdservicio(resultSet.getInt("IDSERVICIO"));
			tecnico.setGuidtecnico(resultSet.getString("GUIDTECNICO"));

			Servicios servicio = new Servicios();
			servicio.setIdservicio(resultSet.getLong("IDSERVICIO"));
			servicio.setCservicio(resultSet.getString("CSERVICIO") == null ? ""
					: resultSet.getString("CSERVICIO"));
			servicio.setEservicio(resultSet.getString("ESERVICIO") == null ? ""
					: resultSet.getString("ESERVICIO"));
			tecnico.setServicio(servicio);

			tecnico.setMovilgmao(resultSet.getString("MOVILGMAO"));
			return tecnico;
		}
	};
	private RowMapper<Tecnicos> rwMapTecnicos = new RowMapper<Tecnicos>() {
		public Tecnicos mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Tecnicos(resultSet.getLong("IDTECNICO"),
					resultSet.getString("NOMBRE"), null, null, null, null,
					null, null, null, null);
		}
	};

	private RowMapper<Tecnicos> rwMapTecnicosMail = new RowMapper<Tecnicos>() {
		public Tecnicos mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Tecnicos(resultSet.getLong("IDTECNICO"),
					resultSet.getString("NOMBRE"), null,
					resultSet.getString("MAIL"), null, null, null, null, null,
					null);
		}
	};

	private RowMapper<Tecnicos> rwMapTecnicosUsu = new RowMapper<Tecnicos>() {
		public Tecnicos mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Tecnicos tecnico = new Tecnicos();
			tecnico.setIdtecnico(resultSet.getLong("IDTECNICO"));
			tecnico.setNombre(resultSet.getString("NOMBRE"));
			return tecnico;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Tecnicos table.
	 * 
	 * @param tecnicos
	 *            Pagination
	 * @return Tecnicos
	 */
	public Tecnicos add(Tecnicos tecnicos) {

		// Obtener el id correlativo
		Long idCorrelativo = this.jdbcTemplate
				.queryForLong("SELECT TECNICO_SEQ.NEXTVAL FROM DUAL");

		tecnicos.setIdtecnico(idCorrelativo);
		String query = "INSERT INTO TECNICOS (IDTECNICO, NOMBRE, TELEFO, MAIL, BAJA, EQUIPO, TECNICO_CONTRATA, UID_PER, IDSERVICIO, GUIDTECNICO, MOVILGMAO) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(
				query,
				tecnicos.getIdtecnico(),
				tecnicos.getNombre(),
				tecnicos.getTelefo(),
				tecnicos.getMail(),
				tecnicos.getBaja() == null ? "0" : tecnicos.getBaja(),
				tecnicos.getEquipo(),
				tecnicos.getTecnicoContrata() == null ? "0" : tecnicos
						.getTecnicoContrata(), tecnicos.getUidPer(), tecnicos
						.getIdservicio(), tecnicos.getGuidtecnico(), tecnicos
						.getMovilgmao());
		return tecnicos;
	}

	/**
	 * Updates a single row in the Tecnicos table.
	 * 
	 * @param tecnicos
	 *            Pagination
	 * @return Tecnicos
	 */
	public Tecnicos update(Tecnicos tecnicos) {
		String query = "UPDATE TECNICOS SET NOMBRE=?, TELEFO=?, MAIL=?, BAJA=?, EQUIPO=?, TECNICO_CONTRATA=?, UID_PER=?, IDSERVICIO=?, MOVILGMAO=? WHERE IDTECNICO=?";
		this.jdbcTemplate.update(
				query,
				tecnicos.getNombre(),
				tecnicos.getTelefo(),
				tecnicos.getMail(),
				tecnicos.getBaja() == null ? "0" : tecnicos.getBaja(),
				tecnicos.getEquipo(),
				tecnicos.getTecnicoContrata() == null ? "0" : tecnicos
						.getTecnicoContrata(), tecnicos.getUidPer(), tecnicos
						.getIdservicio(), tecnicos.getMovilgmao(), tecnicos
						.getIdtecnico());
		return tecnicos;
	}

	/**
	 * Updates a single row in the Tecnicos table.
	 * 
	 * @param tecnicos
	 *            Pagination
	 * @return Tecnicos
	 */
	public Tecnicos modificarTecnico(Tecnicos tecnicos) {
		String query = "UPDATE TECNICOS SET NOMBRE=?, TELEFO=?, MAIL=?, BAJA=?, TECNICO_CONTRATA=?, UID_PER=?, IDSERVICIO=?, MOVILGMAO=? WHERE IDTECNICO=?";
		this.jdbcTemplate.update(
				query,
				tecnicos.getNombre(),
				tecnicos.getTelefo(),
				tecnicos.getMail(),
				tecnicos.getBaja() == null ? "0" : tecnicos.getBaja(),
				tecnicos.getTecnicoContrata() == null ? "0" : tecnicos
						.getTecnicoContrata(), tecnicos.getUidPer()
						.toUpperCase(), tecnicos.getIdservicio(), tecnicos
						.getMovilgmao(), tecnicos.getIdtecnico());
		return tecnicos;
	}

	/**
	 * Finds a single row in the Tecnicos table.
	 * 
	 * @param tecnicos
	 *            Pagination
	 * @return Tecnicos
	 */
	@Transactional(readOnly = true)
	public Tecnicos find(Tecnicos tecnicos) {
		String query = "SELECT t1.IDTECNICO IDTECNICO, t1.NOMBRE NOMBRE, t1.TELEFO TELEFO, t1.MAIL MAIL, t1.BAJA BAJA, t1.EQUIPO EQUIPO, t1.TECNICO_CONTRATA TECNICOCONTRATA, t1.UID_PER UIDPER, t1.IDSERVICIO IDSERVICIO, t2.CSERVICIO CSERVICIO, t2.ESERVICIO ESERVICIO, t1.GUIDTECNICO GUIDTECNICO, t1.MOVILGMAO MOVILGMAO FROM TECNICOS t1, SERVICIOS t2  WHERE t1.IDSERVICIO = t2.IDSERVICIO(+) AND t1.IDTECNICO = ?  ";

		List<Tecnicos> tecnicosList = this.jdbcTemplate.query(query,
				this.rwMap, tecnicos.getIdtecnico());
		return (Tecnicos) DataAccessUtils.uniqueResult(tecnicosList);
	}

	/**
	 * Removes a single row in the Tecnicos table.
	 * 
	 * @param tecnicos
	 *            Pagination
	 * @return
	 */
	public void remove(Tecnicos tecnicos) {
		String query = "DELETE FROM TECNICOS WHERE IDTECNICO=?";
		this.jdbcTemplate.update(query, tecnicos.getIdtecnico());
	}

	/**
	 * Finds a List of rows in the Tecnicos table.
	 * 
	 * @param tecnicos
	 *            Tecnicos
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Tecnicos> findAll(Tecnicos tecnicos, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDTECNICO IDTECNICO,t1.NOMBRE NOMBRE,t1.TELEFO TELEFO,t1.MAIL MAIL,t1.BAJA BAJA,t1.EQUIPO EQUIPO,t1.TECNICO_CONTRATA TECNICOCONTRATA,t1.UID_PER UIDPER, t1.IDSERVICIO IDSERVICIO, t2.CSERVICIO CSERVICIO, t2.ESERVICIO ESERVICIO, t1.GUIDTECNICO GUIDTECNICO, t1.MOVILGMAO MOVILGMAO ");
		query.append("FROM TECNICOS t1, SERVICIOS t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tecnicos);
		StringBuilder where = new StringBuilder(
				" WHERE t1.IDSERVICIO = t2.IDSERVICIO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Tecnicos>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Obtener tecnicos NO asociados a un edificio.
	 * 
	 * @param idedificio
	 *            String
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Tecnicos> obtenerTecnicosNOAsociados(String idedificio) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDTECNICO IDTECNICO, t1.NOMBRE  FROM TECNICOS t1, TECNICO_EDIF t2 WHERE t1.BAJA='0' OR t1.BAJA IS NULL");
		query.append(" MINUS ");
		query.append(" SELECT  t2.IDTECNICO IDTECNICO, t1.NOMBRE  FROM TECNICOS t1, TECNICO_EDIF t2 ");

		StringBuilder where = new StringBuilder(
				" WHERE t1.IDTECNICO=t2.IDTECNICO AND t2.IDEDIFICIO=?");
		query.append(where);

		return (List<Tecnicos>) this.jdbcTemplate.query(query.toString(),
				this.rwMapTecnicos, idedificio);
	}

	/**
	 * Obtener tecnicos asociados a un edificio que NO están asociados a un
	 * parte.
	 * 
	 * @param idEdificio
	 *            String
	 * @param idParte
	 *            Integer
	 * @param UIDUsuario
	 *            String
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Tecnicos> obtenerTecnicosParteLibres(String idEdificio,
			String UIDUsuario, Integer idParte) {

		StringBuilder query = new StringBuilder(
				"SELECT DISTINCT t1.IDTECNICO IDTECNICO, t1.NOMBRE NOMBRE");
		query.append(" FROM TECNICOS t1, TECNICO_EDIF t2, USUTECNICOS t4 ");

		/**
		 * 2 de noviembre se quita el idedificio de la where para que aparezcan
		 * todos los asignados al usuario
		 */
		StringBuilder where = new StringBuilder(
				" WHERE t1.IDTECNICO=t2.IDTECNICO AND t1.IDTECNICO =t4.IDTECNICO AND t1.BAJA = 0 AND t4.UID_PER=? and t1.IDTECNICO NOT IN (SELECT DISTINCT t3.IDTECNICO FROM PARTETECNICOS t3 WHERE t3.IDPARTE=?)");
		query.append(where);

		query.append(" ORDER BY t1.NOMBRE ");

		return (List<Tecnicos>) this.jdbcTemplate.query(query.toString(),
				this.rwMapTecnicos, UIDUsuario, idParte);
	}

	/**
	 * Obtener tecnicos asociados a un edificio que NO están asociados a una
	 * ficha .
	 * 
	 * @param idEdificio
	 *            String
	 * @param idFicha
	 *            Integer
	 * @param UIDUsuario
	 *            String
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Tecnicos> obtenerTecnicosFichaLibres(String idEdificio,
			String UIDUsuario, Integer idFicha) {

		StringBuilder query = new StringBuilder(
				"SELECT DISTINCT t1.IDTECNICO IDTECNICO, t1.NOMBRE NOMBRE");
		query.append(" FROM TECNICOS t1, TECNICO_EDIF t2, USUTECNICOS t4 ");

		/**
		 * 2 de noviembre se quita el idedificio de la where para que aparezcan
		 * todos los asignados al usuario
		 */
		StringBuilder where = new StringBuilder(
				" WHERE t1.IDTECNICO=t2.IDTECNICO AND t1.IDTECNICO =t4.IDTECNICO AND t1.BAJA = 0 AND t4.UID_PER=? and t1.IDTECNICO NOT IN (SELECT DISTINCT t3.IDTECNICO FROM FICHATECNICO t3 WHERE t3.IDFICHA=?)");
		query.append(where);

		query.append(" ORDER BY t1.NOMBRE ");

		return (List<Tecnicos>) this.jdbcTemplate.query(query.toString(),
				this.rwMapTecnicos, UIDUsuario, idFicha);
	}

	/**
	 * Obtener tecnicos asociados a un edificio.
	 * 
	 * @param idedificio
	 *            String
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Tecnicos> obtenerTecnicosAsociados(String idedificio) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDTECNICO IDTECNICO,t1.NOMBRE NOMBRE ");
		query.append("FROM TECNICOS t1, TECNICO_EDIF t2 ");

		StringBuilder where = new StringBuilder(
				" WHERE t1.IDTECNICO=t2.IDTECNICO AND t2.IDEDIFICIO=?");
		query.append(where);

		return (List<Tecnicos>) this.jdbcTemplate.query(query.toString(),
				this.rwMapTecnicos, idedificio);
	}

	/**
	 * Counts rows in the Tecnicos table.
	 * 
	 * @param tecnicos
	 *            Tecnicos
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Tecnicos tecnicos) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM TECNICOS t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tecnicos);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Tecnicos table using like.
	 * 
	 * @param tecnicos
	 *            Tecnicos
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Tecnicos> findAllLike(Tecnicos tecnicos, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDTECNICO IDTECNICO,t1.NOMBRE NOMBRE,t1.TELEFO TELEFO,t1.MAIL MAIL,t1.BAJA BAJA,t1.EQUIPO EQUIPO,t1.TECNICO_CONTRATA TECNICOCONTRATA,t1.UID_PER UIDPER,t1.IDSERVICIO IDSERVICIO, t2.CSERVICIO CSERVICIO, t2.ESERVICIO ESERVICIO, t1.GUIDTECNICO GUIDTECNICO, t1.MOVILGMAO MOVILGMAO ");
		query.append("FROM TECNICOS t1, SERVICIOS t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tecnicos, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE t1.IDSERVICIO = t2.IDSERVICIO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Tecnicos>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Tecnicos asociados al usuario.
	 * 
	 * @param tecnicos
	 *            Tecnicos
	 * @param sUIDUsuario
	 *            String
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Tecnicos> obtenerTecnicosDelUsuario(Tecnicos tecnicos,
			String sUIDUsuario, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDTECNICO IDTECNICO,t1.NOMBRE NOMBRE,t1.TELEFO TELEFO,t1.MAIL MAIL,t1.BAJA BAJA,t1.EQUIPO EQUIPO,t1.TECNICO_CONTRATA TECNICOCONTRATA,t1.UID_PER UIDPER ");
		query.append("FROM TECNICOS t1, USUTECNICOS t2 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(
				" WHERE t1.IDTECNICO=t2.IDTECNICO AND t2.UID_PER=? AND UPPER(t1.NOMBRE) like ? ESCAPE  '\\' ");

		query.append(where);

		return (List<Tecnicos>) this.jdbcTemplate.query(query.toString(),
				this.rwMapTecnicosUsu, sUIDUsuario, '%' + tecnicos.getNombre()
						.toUpperCase() + '%');
	}

	/**
	 * Counts rows in the Tecnicos table using like.
	 * 
	 * @param tecnicos
	 *            Tecnicos
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Tecnicos tecnicos, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM TECNICOS t1, SERVICIOS t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tecnicos, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE t1.IDSERVICIO = t2.IDSERVICIO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Obtener tecnicos asociados a un USUARIO que NO están asociados en la
	 * tabla tecnicoPlan
	 * 
	 * @param sUIDUsuario
	 *            String
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Tecnicos> obtenerTecnicosUsuarioLibres(String sUIDUsuario) {

		StringBuilder query = new StringBuilder(
				"SELECT t1.IDTECNICO IDTECNICO, t1.NOMBRE NOMBRE");
		query.append(" FROM TECNICOS t1, USUTECNICOS t2 ");

		StringBuilder where = new StringBuilder(
				" WHERE t1.IDTECNICO=t2.IDTECNICO AND t1.BAJA = 0 AND t2.UID_PER=? and t1.IDTECNICO NOT IN (SELECT DISTINCT t3.IDTECNICO FROM TECNICOPLANIF t3 WHERE t3.UID_PER=?)");
		query.append(where);
		query.append(" ORDER BY t1.NOMBRE ");

		return (List<Tecnicos>) this.jdbcTemplate.query(query.toString(),
				this.rwMapTecnicos, sUIDUsuario, sUIDUsuario);
	}

	/**
	 * Obtener tecnicos asociados a un USUARIO que NO están asociados en la
	 * tabla tecnicoPlan
	 * 
	 * @param sUIDUsuario
	 *            String
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Tecnicos> obtenerTecnicosUsuarioAsignados(String sUIDUsuario) {

		StringBuilder query = new StringBuilder(
				"SELECT t1.IDTECNICO IDTECNICO, t1.NOMBRE NOMBRE");
		query.append(" FROM TECNICOS t1, TECNICOPLANIF t2 ");

		StringBuilder where = new StringBuilder(
				" WHERE t1.IDTECNICO=t2.IDTECNICO AND t2.UID_PER=? ");
		query.append(where);
		query.append(" ORDER BY t1.NOMBRE ");

		return (List<Tecnicos>) this.jdbcTemplate.query(query.toString(),
				this.rwMapTecnicos, sUIDUsuario);
	}

	/**
	 * Obtener tecnicos de contrata NO asociados a una clase
	 * 
	 * @param idClase
	 *            Integer
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Tecnicos> obtenerTecnicosClaseContrataLibres(Integer idClase) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDTECNICO IDTECNICO, t1.NOMBRE  FROM TECNICOS t1 WHERE t1.TECNICO_CONTRATA=1 AND (t1.BAJA='0' OR t1.BAJA IS NULL) ");
		query.append(" MINUS ");
		query.append(" SELECT  t2.IDTECNICO IDTECNICO, t1.NOMBRE  FROM TECNICOS t1, CLASECONTRATA t2 ");

		StringBuilder where = new StringBuilder(
				" WHERE t1.IDTECNICO=t2.IDTECNICO AND t1.TECNICO_CONTRATA=1 AND t2.IDCLASE=?");
		query.append(where);
		query.append(" ORDER BY NOMBRE");
		return (List<Tecnicos>) this.jdbcTemplate.query(query.toString(),
				this.rwMapTecnicos, idClase);
	}

	/**
	 * Obtener tecnicos de contrata NO asociados a una clase y codigo
	 * 
	 * @param idClase
	 *            Integer
	 * @param idCodigo
	 *            Integer
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Tecnicos> obtenerTecnicosClaseCodigoContrataLibres(
			Integer idClase, Integer idCodigo) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDTECNICO IDTECNICO, t1.NOMBRE  FROM TECNICOS t1, CLASECONTRATA t2 WHERE t1.IDTECNICO=t2.IDTECNICO AND (t2.BAJA='0' OR t2.BAJA IS NULL) AND t2.IDCLASE=? ");
		query.append(" MINUS ");
		query.append(" SELECT  t2.IDTECNICO IDTECNICO, t1.NOMBRE  FROM TECNICOS t1, CLASECONTRATA t2 ");

		StringBuilder where = new StringBuilder(
				" WHERE t1.IDTECNICO=t2.IDTECNICO AND t1.TECNICO_CONTRATA=1 AND t2.IDCLASE=? AND t2.IDCODIGO=? AND t2.BAJA=0 ");
		query.append(where);
		query.append(" ORDER BY NOMBRE");
		return (List<Tecnicos>) this.jdbcTemplate.query(query.toString(),
				this.rwMapTecnicos, idClase, idClase, idCodigo);
	}

	/**
	 * Obtener tecnicos de contrata asociados a una clase
	 * 
	 * @param idClase
	 *            Integer
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Tecnicos> obtenerTecnicosClaseContrataAsignados(Integer idClase) {
		StringBuilder query = new StringBuilder(
				"SELECT DISTINCT t1.IDTECNICO IDTECNICO, t1.NOMBRE  FROM TECNICOS t1, CLASECONTRATA t2");

		StringBuilder where = new StringBuilder(
				" WHERE t1.IDTECNICO=t2.IDTECNICO AND t1.TECNICO_CONTRATA=1 AND t2.IDCLASE=?");
		query.append(where);

		query.append(" ORDER BY t1.NOMBRE");

		return (List<Tecnicos>) this.jdbcTemplate.query(query.toString(),
				this.rwMapTecnicos, idClase);
	}

	/**
	 * Obtener tecnicos de contrata asociados a una clase y codigo
	 * 
	 * @param idClase
	 *            Integer
	 * @param idCodigo
	 *            Integer
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Tecnicos> obtenerTecnicosClaseCodigoContrataAsignados(
			Integer idClase, Integer idCodigo) {
		StringBuilder query = new StringBuilder(
				"SELECT DISTINCT t1.IDTECNICO IDTECNICO, t1.NOMBRE  FROM TECNICOS t1, CLASECONTRATA t2");

		StringBuilder where = new StringBuilder(
				" WHERE t1.IDTECNICO=t2.IDTECNICO AND t1.TECNICO_CONTRATA=1 AND t2.IDCLASE=? AND t2.IDCODIGO=? AND t2.BAJA=0 ");
		query.append(where);

		query.append(" ORDER BY t1.NOMBRE");

		return (List<Tecnicos>) this.jdbcTemplate.query(query.toString(),
				this.rwMapTecnicos, idClase, idCodigo);
	}

	/**
	 * Obtener tecnicos de contrata para una clase, código y edificio Zona
	 * 
	 * @param idClase
	 *            Integer
	 * @param idServicio
	 *            Integer
	 * @param idCodigo
	 *            Integer
	 * @param idEdificio
	 *            String
	 * @param idZona
	 *            Integer
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Tecnicos> obtenerTecnicosClaseContrataEdificio(Integer idClase,
			Integer idServicio, Integer idCodigo, String idEdificio,
			Integer idZona) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDTECNICO IDTECNICO, t1.NOMBRE, t1.MAIL MAIL  FROM TECNICOS t1, CLASECONTRATA t2, TECNICO_EDIF t3 ");

		StringBuilder where = new StringBuilder(
				" WHERE t1.IDTECNICO=t2.IDTECNICO AND t2.IDTECNICO=t3.IDTECNICO AND t1.BAJA=0 AND t2.IDCLASE=? AND (t2.IDCODIGO=? OR t2.IDCODIGO=0) AND t2.BAJA=0 AND t3.IDEDIFICIO=? AND (t3.IDZONA=? OR t3.IDZONA=0) AND t3.BAJA=0 AND t1.IDSERVICIO=? ");
		query.append(where);

		return (List<Tecnicos>) this.jdbcTemplate.query(query.toString(),
				this.rwMapTecnicosMail, idClase, idCodigo, idEdificio, idZona,
				idServicio);
	}

	/**
	 * Obtener tecnicos Presencia
	 * 
	 * @param sUIDUsuario
	 *            String
	 * @param esResponsable
	 *            Boolean
	 * @return List
	 */
	public List<Tecnicos> obtenerTecnicosPresencia(String sUIDUsuario,
			Boolean esResponsable) {
		StringBuilder query = new StringBuilder("");
		StringBuilder where = new StringBuilder("");

		if (esResponsable) {
			query.append("SELECT  t1.IDTECNICO IDTECNICO, t1.NOMBRE FROM TECNICOS t1, USUTECNICOS t2 ");
			where.append(" WHERE t1.IDTECNICO= t2.IDTECNICO AND (t1.TECNICO_CONTRATA=0 OR t1.TECNICO_CONTRATA IS NULL) AND (t1.BAJA!='1' OR t1.BAJA is null) AND t2.UID_PER=? ORDER BY t1.nombre");

			query.append(where);
		} else {
			query.append("SELECT distinct t1.IDTECNICO,t1.NOMBRE FROM TECNICOS t1, TECNICO_EDIF t2, EDIFICIOSVER t3 ");
			where.append(" WHERE t1.IDTECNICO= t2.IDTECNICO AND (t1.TECNICO_CONTRATA=0 OR t1.TECNICO_CONTRATA IS NULL) AND t2.IDEDIFICIO = t3.IDEDIFICIO AND (t1.BAJA!='1' OR t1.BAJA IS NULL) AND t3.UID_PER =? ORDER BY t1.nombre");

			query.append(where);
		}

		return (List<Tecnicos>) this.jdbcTemplate.query(query.toString(),
				this.rwMapTecnicos, sUIDUsuario);
	}

	/**
	 * Comprobar si ya existe otro técnico con el mismo UIDPuesto.
	 * 
	 * @param usuarioIntroducido
	 *            String
	 * @return Boolean
	 */
	@Transactional(readOnly = true)
	public Boolean UIDPUESTOduplicado(String usuarioIntroducido, int idTecnico) {
		StringBuilder query = new StringBuilder();
		query.append("SELECT  t1.IDTECNICO IDTECNICO, t1.NOMBRE NOMBRE FROM TECNICOS t1 WHERE (t1.BAJA =0 OR t1.BAJA IS NULL)  AND UPPER(t1.UID_PER) = ?  ");
		query.append(" AND t1.IDTECNICO != ?  ");

		List<Tecnicos> tecnicosList = this.jdbcTemplate
				.query(query.toString(), this.rwMapTecnicos,
						usuarioIntroducido.toUpperCase(), idTecnico);
		if (tecnicosList.size() > 0) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Tecnicos entity
	 * 
	 * @param tecnicos
	 *            Tecnicos Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Tecnicos tecnicos) {

		StringBuilder where = new StringBuilder(
				TecnicosDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tecnicos != null && tecnicos.getIdtecnico() != null) {
			where.append(" AND t1.IDTECNICO = ?");
			params.add(tecnicos.getIdtecnico());
		}
		if (tecnicos != null && tecnicos.getNombre() != null) {
			where.append(" AND t1.NOMBRE = ?");
			params.add(tecnicos.getNombre());
		}
		if (tecnicos != null && tecnicos.getTelefo() != null) {
			where.append(" AND t1.TELEFO = ?");
			params.add(tecnicos.getTelefo());
		}
		if (tecnicos != null && tecnicos.getMail() != null) {
			where.append(" AND t1.MAIL = ?");
			params.add(tecnicos.getMail());
		}
		if (tecnicos != null && tecnicos.getBaja() != null) {
			where.append(" AND t1.BAJA = ?");
			params.add(tecnicos.getBaja());
		}
		if (tecnicos != null && tecnicos.getEquipo() != null) {
			where.append(" AND t1.EQUIPO = ?");
			params.add(tecnicos.getEquipo());
		}
		if (tecnicos != null && tecnicos.getTecnicoContrata() != null) {
			where.append(" AND t1.TECNICO_CONTRATA = ?");
			params.add(tecnicos.getTecnicoContrata());
		}
		if (tecnicos != null && tecnicos.getUidPer() != null) {
			where.append(" AND t1.UID_PER = ?");
			params.add(tecnicos.getUidPer());
		}
		if (tecnicos != null && tecnicos.getIdservicio() != null
				&& tecnicos.getIdservicio() != 0) {
			where.append(" AND t1.IDSERVICIO = ?");
			params.add(tecnicos.getIdservicio());
		}
		if (tecnicos != null && tecnicos.getMovilgmao() != null) {
			where.append(" AND t1.MOVILGMAO = ?");
			params.add(tecnicos.getMovilgmao());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Tecnicos entity
	 * 
	 * @param tecnicos
	 *            Tecnicos Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Tecnicos tecnicos, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				TecnicosDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tecnicos != null && tecnicos.getIdtecnico() != null) {
			where.append(" AND t1.IDTECNICO = ?");
			params.add(tecnicos.getIdtecnico());
		}
		if (tecnicos != null && tecnicos.getNombre() != null) {
			where.append(" AND UPPER(t1.NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tecnicos.getNombre().toUpperCase() + "%");
			} else {
				params.add("%" + tecnicos.getNombre().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE IS NOT NULL");
		}
		if (tecnicos != null && tecnicos.getTelefo() != null) {
			where.append(" AND UPPER(t1.TELEFO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tecnicos.getTelefo().toUpperCase() + "%");
			} else {
				params.add("%" + tecnicos.getTelefo().toUpperCase() + "%");
			}
			where.append(" AND t1.TELEFO IS NOT NULL");
		}
		if (tecnicos != null && tecnicos.getMail() != null) {
			where.append(" AND UPPER(t1.MAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tecnicos.getMail().toUpperCase() + "%");
			} else {
				params.add("%" + tecnicos.getMail().toUpperCase() + "%");
			}
			where.append(" AND t1.MAIL IS NOT NULL");
		}
		if (tecnicos != null && tecnicos.getBaja() != null) {
			where.append(" AND UPPER(t1.BAJA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tecnicos.getBaja().toUpperCase() + "%");
			} else {
				params.add("%" + tecnicos.getBaja().toUpperCase() + "%");
			}
			where.append(" AND t1.BAJA IS NOT NULL");
		}
		if (tecnicos != null && tecnicos.getEquipo() != null) {
			where.append(" AND UPPER(t1.EQUIPO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tecnicos.getEquipo().toUpperCase() + "%");
			} else {
				params.add("%" + tecnicos.getEquipo().toUpperCase() + "%");
			}
			where.append(" AND t1.EQUIPO IS NOT NULL");
		}
		if (tecnicos != null && tecnicos.getTecnicoContrata() != null) {
			where.append(" AND UPPER(t1.TECNICO_CONTRATA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tecnicos.getTecnicoContrata().toUpperCase() + "%");
			} else {
				params.add("%" + tecnicos.getTecnicoContrata().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TECNICO_CONTRATA IS NOT NULL");
		}
		if (tecnicos != null && tecnicos.getUidPer() != null) {
			where.append(" AND UPPER(t1.UID_PER) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tecnicos.getUidPer().toUpperCase() + "%");
			} else {
				params.add("%" + tecnicos.getUidPer().toUpperCase() + "%");
			}
			where.append(" AND t1.UID_PER IS NOT NULL");
		}

		if (tecnicos != null && tecnicos.getIdservicio() != null
				&& tecnicos.getIdservicio() != 0) {
			where.append(" AND t1.IDSERVICIO = ?");
			params.add(tecnicos.getIdservicio());
		}
		if (tecnicos != null && tecnicos.getServicio() != null
				&& tecnicos.getServicio().getCservicio() != null) {
			where.append(" AND UPPER(t2.CSERVICIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tecnicos.getServicio().getCservicio().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tecnicos.getServicio().getCservicio().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.CSERVICIO IS NOT NULL");
		}
		if (tecnicos != null && tecnicos.getServicio() != null
				&& tecnicos.getServicio().getEservicio() != null) {
			where.append(" AND UPPER(t2.ESERVICIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tecnicos.getServicio().getEservicio().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tecnicos.getServicio().getEservicio().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ESERVICIO IS NOT NULL");
		}

		if (tecnicos != null && tecnicos.getMovilgmao() != null) {
			where.append(" AND t1.MOVILGMAO = ?");
			params.add(tecnicos.getMovilgmao());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	@Override
	public Tecnicos actualizarUUIDtecnico(Tecnicos tecnico) {
		// TODO Auto-generated method stub
		String query = "UPDATE TECNICOS SET GUIDTECNICO=? WHERE IDTECNICO=? ";
		this.jdbcTemplate.update(query, tecnico.getGuidtecnico(),
				tecnico.getIdtecnico());
		return tecnico;

	}
}
