package com.ejie.aa20b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.aa20b.model.Tecnicos;

/**
 * TecnicosDao generated by UDA, 22-dic-2014 10:11:52.
 * 
 * @author UDA
 */

public interface TecnicosDao {

	/**
	 * Inserts a single row in the Tecnicos table.
	 * 
	 * @param tecnicos
	 *            Tecnicos
	 * @return Tecnicos
	 */
	Tecnicos add(Tecnicos tecnicos);

	/**
	 * Updates a single row in the Tecnicos table.
	 * 
	 * @param tecnicos
	 *            Tecnicos
	 * @return Tecnicos
	 */
	Tecnicos update(Tecnicos tecnicos);

	/**
	 * Finds a single row in the Tecnicos table.
	 * 
	 * @param tecnicos
	 *            Tecnicos
	 * @return Tecnicos
	 */
	Tecnicos find(Tecnicos tecnicos);

	/**
	 * Deletes a single row in the Tecnicos table.
	 * 
	 * @param tecnicos
	 *            Tecnicos
	 * @return
	 */
	void remove(Tecnicos tecnicos);

	/**
	 * Finds a List of rows in the Tecnicos table.
	 * 
	 * @param tecnicos
	 *            Tecnicos
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Tecnicos> findAll(Tecnicos tecnicos, Pagination pagination);

	/**
	 * Obtener tecnicos asociados a un edificio.
	 * 
	 * @param idedificio
	 *            String
	 * @return List
	 */
	List<Tecnicos> obtenerTecnicosAsociados(String idedificio);

	/**
	 * Obtener tecnicos NO asociados a un edificio.
	 * 
	 * @param idedificio
	 *            String
	 * @return List
	 */
	List<Tecnicos> obtenerTecnicosNOAsociados(String idedificio);

	/**
	 * Obtener tecnicos asociados a un edificio que NO están asociados a un
	 * parte.
	 * 
	 * @param idEdificio
	 *            String
	 * @param idparte
	 *            Integer
	 * @param UIDUsuario
	 *            String
	 * @return List
	 */
	List<Tecnicos> obtenerTecnicosParteLibres(String idEdificio,
			String UIDUsuario, Integer idParte);

	/**
	 * Counts rows in the Tecnicos table.
	 * 
	 * @param tecnicos
	 *            Tecnicos
	 * @return Long
	 */
	Long findAllCount(Tecnicos tecnicos);

	/**
	 * Finds rows in the Tecnicos table using like.
	 * 
	 * @param tecnicos
	 *            Tecnicos
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Tecnicos> findAllLike(Tecnicos tecnicos, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Tecnicos table using like.
	 * 
	 * @param tecnicos
	 *            Tecnicos
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Tecnicos tecnicos, Boolean startsWith);

	/**
	 * Obtener tecnicos asociados a un USUARIO que NO están asociados en la
	 * tabla tecnicoPlan
	 * 
	 * @param sUIDUsuario
	 *            String
	 * @return List
	 */
	public List<Tecnicos> obtenerTecnicosUsuarioLibres(String sUIDUsuario);

	/**
	 * Obtener tecnicos asociados a un USUARIO que NO están asociados en la
	 * tabla tecnicoPlan
	 * 
	 * @param sUIDUsuario
	 *            String
	 * @return List
	 */
	public List<Tecnicos> obtenerTecnicosUsuarioAsignados(String sUIDUsuario);

	/**
	 * Obtener tecnicos de contrata NO asociados a una clase
	 * 
	 * @param idClase
	 *            Integer
	 * @return List
	 */
	public List<Tecnicos> obtenerTecnicosClaseContrataLibres(Integer idClase);

	/**
	 * Obtener tecnicos de contrata NO asociados a una clase y codigo
	 * 
	 * @param idClase
	 *            Integer
	 * @param idCodigo
	 *            Integer
	 * @return List
	 */
	public List<Tecnicos> obtenerTecnicosClaseCodigoContrataLibres(
			Integer idClase, Integer idCodigo);

	/**
	 * Obtener tecnicos de contrata asociados a una clase
	 * 
	 * @param idClase
	 *            Integer
	 * @return List
	 */
	public List<Tecnicos> obtenerTecnicosClaseContrataAsignados(Integer idClase);

	/**
	 * Obtener tecnicos de contrata asociados a una clase y codigo
	 * 
	 * @param idClase
	 *            Integer
	 * @param idCodigo
	 *            Integer
	 * @return List
	 */
	public List<Tecnicos> obtenerTecnicosClaseCodigoContrataAsignados(
			Integer idClase, Integer idCodigo);

	/**
	 * Updates a single row in the Tecnicos table.
	 * 
	 * @param tecnicos
	 *            Tecnicos
	 * @return Tecnicos
	 */
	Tecnicos modificarTecnico(Tecnicos tecnicos);

	/**
	 * Obtener tecnicos de contrata para una clase, código y edificio Zona
	 * 
	 * @param idClase
	 *            Integer
	 * @param idServicio
	 *            Integer
	 * @param idCodigo
	 *            Integer
	 * @param idEdificio
	 *            String
	 * @param idZona
	 *            Integer
	 * @return List
	 */
	List<Tecnicos> obtenerTecnicosClaseContrataEdificio(Integer idClase,
			Integer idServicio, Integer idCodigo, String idEdificio,
			Integer idZona);

	/**
	 * Obtener tecnicos Presencia
	 * 
	 * @param sUIDUsuario
	 *            String
	 * @param esResponsable
	 *            Boolean
	 * 
	 * @return List
	 */
	List<Tecnicos> obtenerTecnicosPresencia(String sUIDUsuario,
			Boolean esResponsable);

	/**
	 * Obtener tecnicos asociados a un edificio que NO están asociados a una
	 * ficha .
	 * 
	 * @param idEdificio
	 *            String
	 * @param idFicha
	 *            Integer
	 * @param UIDUsuario
	 *            String
	 * @return List
	 */
	List<Tecnicos> obtenerTecnicosFichaLibres(String idEdificio,
			String UIDUsuario, Integer idFicha);

	/**
	 * Tecnicos asociados al usuario.
	 * 
	 * @param tecnicos
	 *            Tecnicos
	 * @param sUIDUsuario
	 *            String
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Tecnicos> obtenerTecnicosDelUsuario(Tecnicos tecnicos,
			String sUIDUsuario, Boolean startsWith);

	/**
	 * Comprobar si ya existe otro técnico con el mismo UIDPuesto.
	 * 
	 * @param usuarioIntroducido
	 *            String
	 * @return Boolean
	 */
	Boolean UIDPUESTOduplicado(String usuarioIntroducido, int idTecnico);

	Tecnicos actualizarUUIDtecnico(Tecnicos tecnico);
}
