package com.ejie.aa20b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.Tecnicoplanif;

/**
 * TecnicoplanifDaoImpl generated by UDA, 01-abr-2015 12:44:35.
 * @author UDA
 */
 
@Repository
@Transactional
public class TecnicoplanifDaoImpl implements TecnicoplanifDao {
    private JdbcTemplate jdbcTemplate;
	private RowMapper<Tecnicoplanif> rwMap = new RowMapper<Tecnicoplanif>() {
		public Tecnicoplanif mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new Tecnicoplanif(
               resultSet.getString("UIDPER"), resultSet.getLong("IDTECNICO")
           ); } } ;

	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    /**
     * Inserts a single row in the Tecnicoplanif table.
     *
     * @param tecnicoplanif Pagination
     * @return Tecnicoplanif
     */
	public Tecnicoplanif add(Tecnicoplanif tecnicoplanif) {
    	String query = "INSERT INTO TECNICOPLANIF (UID_PER, IDTECNICO) VALUES (?,?)";
		this.jdbcTemplate.update(query, tecnicoplanif.getUidPer(), tecnicoplanif.getIdtecnico());
		return tecnicoplanif;
	}

    /**
     * Updates a single row in the Tecnicoplanif table.
     *
     * @param tecnicoplanif Pagination
     * @return Tecnicoplanif
     */
    public Tecnicoplanif update(Tecnicoplanif tecnicoplanif) {
		String query = "UPDATE TECNICOPLANIF SET  WHERE UID_PER=? AND IDTECNICO=?";
		this.jdbcTemplate.update(query, tecnicoplanif.getUidPer(), tecnicoplanif.getIdtecnico());
		return tecnicoplanif;
	}

    /**
     * Finds a single row in the Tecnicoplanif table.
     *
     * @param tecnicoplanif Pagination
     * @return Tecnicoplanif
     */
    @Transactional (readOnly = true)
    public Tecnicoplanif find(Tecnicoplanif tecnicoplanif) {
		String query = "SELECT t1.UID_PER UIDPER, t1.IDTECNICO IDTECNICO FROM TECNICOPLANIF t1  WHERE t1.UID_PER = ?   AND t1.IDTECNICO = ?  ";
		
		List<Tecnicoplanif> tecnicoplanifList = this.jdbcTemplate.query(query, this.rwMap, tecnicoplanif.getUidPer() , tecnicoplanif.getIdtecnico());
		return (Tecnicoplanif) DataAccessUtils.uniqueResult(tecnicoplanifList);
    }

    /**
     * Removes a single row in the Tecnicoplanif table.
     *
     * @param tecnicoplanif Pagination
     * @return
     */
    public void remove(Tecnicoplanif tecnicoplanif) {
		String query = "DELETE FROM TECNICOPLANIF WHERE UID_PER=? AND IDTECNICO=?";
		this.jdbcTemplate.update(query, tecnicoplanif.getUidPer() , tecnicoplanif.getIdtecnico());
    }
    
   /**
    * Finds a List of rows in the Tecnicoplanif table.
    * 
    * @param tecnicoplanif Tecnicoplanif
    * @param pagination Pagination
    * @return List 
    */
	@Transactional (readOnly = true)
    public List<Tecnicoplanif> findAll(Tecnicoplanif tecnicoplanif, Pagination pagination) {
		StringBuilder query = new StringBuilder("SELECT  t1.UID_PER UIDPER,t1.IDTECNICO IDTECNICO "); 
		query.append("FROM TECNICOPLANIF t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tecnicoplanif); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		
		return (List<Tecnicoplanif>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
    /**
     * Counts rows in the Tecnicoplanif table.
     * 
     * @param tecnicoplanif Tecnicoplanif
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(Tecnicoplanif tecnicoplanif) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM TECNICOPLANIF t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tecnicoplanif); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);		
		
		List<?> params = (List<?>) mapaWhere.get("params");
		
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Finds rows in the Tecnicoplanif table using like.
     * 
     * @param tecnicoplanif Tecnicoplanif
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List 
     */
	@Transactional (readOnly = true)
    public List<Tecnicoplanif> findAllLike(Tecnicoplanif tecnicoplanif, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT  t1.UID_PER UIDPER,t1.IDTECNICO IDTECNICO "); 
        query.append("FROM TECNICOPLANIF t1 ");
      	
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tecnicoplanif,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		
		return (List<Tecnicoplanif>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
	/**
	 * Counts rows in the Tecnicoplanif table using like.
     * 
     * @param tecnicoplanif Tecnicoplanif
     * @param startsWith Boolean
     * @return Long 
     */
	@Transactional (readOnly = true)
    public Long findAllLikeCount(Tecnicoplanif tecnicoplanif, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM TECNICOPLANIF t1 ");

		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tecnicoplanif,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by 
	 * the Tecnicoplanif entity 
	 * 
	 * @param tecnicoplanif Tecnicoplanif
	 *            Bean with the criteria values to filter by.
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap (Tecnicoplanif tecnicoplanif){
		
		StringBuilder where = new StringBuilder(TecnicoplanifDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tecnicoplanif  != null  && tecnicoplanif.getUidPer() != null ) {
			where.append(" AND t1.UID_PER = ?");
			params.add(tecnicoplanif.getUidPer());
		}
		if (tecnicoplanif  != null  && tecnicoplanif.getIdtecnico() != null ) {
			where.append(" AND t1.IDTECNICO = ?");
			params.add(tecnicoplanif.getIdtecnico());
		}

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by  
	 * the Tecnicoplanif entity 
	 * 
	 * @param tecnicoplanif Tecnicoplanif
	 *            Bean with the criteria values to filter by.
     * @param startsWith Boolean	 
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap (Tecnicoplanif tecnicoplanif, Boolean startsWith){
		
		StringBuilder where = new StringBuilder(TecnicoplanifDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tecnicoplanif  != null  && tecnicoplanif.getUidPer() != null ) {
			where.append(" AND UPPER(t1.UID_PER) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tecnicoplanif.getUidPer().toUpperCase() +"%");
			}else{
				params.add("%"+tecnicoplanif.getUidPer().toUpperCase() +"%");
			}
			where.append(" AND t1.UID_PER IS NOT NULL");
	     }			
		if (tecnicoplanif  != null  && tecnicoplanif.getIdtecnico() != null ) {
			where.append(" AND t1.IDTECNICO = ?");
			params.add(tecnicoplanif.getIdtecnico());
	     }			

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * StringBuilder initilization value
	 */
	 public static final int STRING_BUILDER_INIT = 4096;}

