package com.ejie.aa20b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.aa20b.model.TecnicoEdif;

/**
 * TecnicoEdifDao generated by UDA, 22-dic-2014 10:11:52.
 * 
 * @author UDA
 */

public interface TecnicoEdifDao {

	/**
	 * Inserts a single row in the TecnicoEdif table.
	 * 
	 * @param tecnicoedif
	 *            TecnicoEdif
	 * @return TecnicoEdif
	 */
	TecnicoEdif add(TecnicoEdif tecnicoedif);

	/**
	 * Updates a single row in the TecnicoEdif table.
	 * 
	 * @param tecnicoedif
	 *            TecnicoEdif
	 * @return TecnicoEdif
	 */
	TecnicoEdif update(TecnicoEdif tecnicoedif);

	/**
	 * Finds a single row in the TecnicoEdif table.
	 * 
	 * @param tecnicoedif
	 *            TecnicoEdif
	 * @return TecnicoEdif
	 */
	TecnicoEdif find(TecnicoEdif tecnicoedif);

	/**
	 * Deletes a single row in the TecnicoEdif table.
	 * 
	 * @param tecnicoedif
	 *            TecnicoEdif
	 * @return
	 */
	void remove(TecnicoEdif tecnicoedif);

	/**
	 * Deletes a single row in the TecnicoEdif table.
	 * 
	 * @param tecnicoedif
	 *            TecnicoEdif
	 * @return
	 */
	void quitarEdificioATecnico(TecnicoEdif tecnicoedif);

	/**
	 * Eliminar los tecnicos asociados a un edificio.
	 * 
	 * @param tecnicoedif
	 *            TecnicoEdif
	 * @return
	 */
	void eliminarTecEdif(String idEdificio);

	/**
	 * Finds a List of rows in the TecnicoEdif table.
	 * 
	 * @param tecnicoedif
	 *            TecnicoEdif
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<TecnicoEdif> findAll(TecnicoEdif tecnicoedif, Pagination pagination);

	/**
	 * Counts rows in the TecnicoEdif table.
	 * 
	 * @param tecnicoedif
	 *            TecnicoEdif
	 * @return Long
	 */
	Long findAllCount(TecnicoEdif tecnicoedif);

	/**
	 * Finds rows in the TecnicoEdif table using like.
	 * 
	 * @param tecnicoedif
	 *            TecnicoEdif
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<TecnicoEdif> findAllLike(TecnicoEdif tecnicoedif,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the TecnicoEdif table using like.
	 * 
	 * @param tecnicoedif
	 *            TecnicoEdif
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(TecnicoEdif tecnicoedif, Boolean startsWith);

	/**
	 * Finds a List of rows in the TecnicoEdif table.
	 * 
	 * @param idTecnico
	 *            Long
	 * @param idEdificio
	 *            String
	 * @return List
	 */
	List<TecnicoEdif> comprobarTecnicoZonasEdificio(Long idTecnico,
			String idEdificio);
}
