package com.ejie.aa20b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import com.ejie.aa20b.model.RolesMovil;

/**
 * RolesDaoImpl
 * 
 * @author VDIAZSAN
 */

@Repository
@Transactional
public class RolesMovilDaoImpl implements RolesMovilDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<RolesMovil> rwMap = new RowMapper<RolesMovil>() {
		public RolesMovil mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			RolesMovil rolMovil = new RolesMovil();

			rolMovil.setIdRol(resultSet.getInt("IDROL"));
			rolMovil.setIdRolGmao(resultSet.getString("IDROLGMAO"));
			rolMovil.setDescRol(resultSet.getString("DESCROL"));
			rolMovil.setSistema(resultSet.getString("SISTEMA"));

			return rolMovil;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Roles table.
	 * 
	 * @param rolesMovil
	 *            Pagination
	 * @return RolesMovil
	 */
	public RolesMovil add(RolesMovil rolesMovil) {

		final Integer nextId = this.jdbcTemplate
				.queryForInt("SELECT ROLESMOVIL_SEQ.NEXTVAL FROM DUAL");

		rolesMovil.setIdRol(nextId);

		String query = "INSERT INTO ROLESMOVIL (IDROL,IDROLGMAO, DESCROL, SISTEMA) VALUES (?,?,?,?)";
		this.jdbcTemplate.update(query, rolesMovil.getIdRol(),
				rolesMovil.getIdRolGmao(), rolesMovil.getDescRol(),
				rolesMovil.getSistema());
		return rolesMovil;
	}

	/**
	 * Finds a single row in the RolesMovil table.
	 * 
	 * @param rolesMovil
	 *            Pagination
	 * @return RolesMovil
	 */
	@Transactional(readOnly = true)
	public RolesMovil find(RolesMovil rolesMovil) {
		String query = "SELECT t1.IDROL IDROL, t1.IDROLGMAO IDROLGMAO, t1.DESCROL DESCROL, t1.SISTEMA SISTEMA FROM ROLESMOVIL t1 WHERE IDROL = ? ";

		List<RolesMovil> rolesMovilList = this.jdbcTemplate.query(query,
				this.rwMap, rolesMovil.getIdRol());
		return (RolesMovil) DataAccessUtils.uniqueResult(rolesMovilList);
	}

	@Transactional(readOnly = true)
	public RolesMovil findByRolGmao(RolesMovil rolesMovil) {
		String query = "SELECT t1.IDROL IDROL, t1.IDROLGMAO IDROLGMAO, t1.DESCROL DESCROL, t1.SISTEMA SISTEMA FROM ROLESMOVIL t1 WHERE IDROLGMAO = ? ";

		List<RolesMovil> rolesMovilList = this.jdbcTemplate.query(query,
				this.rwMap, rolesMovil.getIdRolGmao());
		return (RolesMovil) DataAccessUtils.uniqueResult(rolesMovilList);
	}

	/**
	 * Removes a single row in the RolesMovil table.
	 * 
	 * @param rolesMovil
	 *            Pagination
	 * @return
	 */
	public void remove(RolesMovil rolesMovil) {
		String query = "DELETE FROM ROLESMOVIL WHERE IDROL=?";
		this.jdbcTemplate.update(query, rolesMovil.getIdRol());
	}

	/**
	 * Finds a List of rows in the RolesMovil table.
	 * 
	 * @param rolesMoviñl
	 *            RolesMovil
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<RolesMovil> findAll(RolesMovil rolesMovil, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.IDROL IDROL, t1.IDROLGMAO IDROLGMAO, t1.DESCROL DESCROL, t1.SISTEMA SISTEMA ");
		query.append("FROM ROLESMOVIL t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(rolesMovil);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<RolesMovil>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the RolesMovil table.
	 * 
	 * @param rolesMovil
	 *            RolesMovil
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(RolesMovil rolesMovil) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ROLESMOVIL t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(rolesMovil);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the RolesMovil table using like.
	 * 
	 * @param rolesMovil
	 *            RolesMovil
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<RolesMovil> findAllLike(RolesMovil rolesMovil,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.IDROL IDROL, t1.IDROLGMAO IDROLGMAO, t1.DESCROL DESCROL, t1.SISTEMA SISTEMA ");
		query.append("FROM ROLESMOVIL t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(rolesMovil, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<RolesMovil>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the RolesMovil table using like.
	 * 
	 * @param rolesMovil
	 *            RolesMovil
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(RolesMovil rolesMovil, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ROLESMOVIL t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(rolesMovil, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the RolesMovil entity
	 * 
	 * @param rolesMovil
	 *            RolesMovil Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(RolesMovil rolesMovil) {

		StringBuilder where = new StringBuilder(
				RolesMovilDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (rolesMovil != null && rolesMovil.getIdRol() != null) {
			where.append(" AND t1.IDROL = ?");
			params.add(rolesMovil.getIdRol());
		}
		if (rolesMovil != null && rolesMovil.getIdRolGmao() != null) {
			where.append(" AND t1.IDROLGMAO = ?");
			params.add(rolesMovil.getIdRolGmao());
		}
		if (rolesMovil != null && rolesMovil.getDescRol() != null) {
			where.append(" AND t1.DESCROL = ?");
			params.add(rolesMovil.getDescRol());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the RolesMovil entity
	 * 
	 * @param rolesMovil
	 *            RolesMovil Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(RolesMovil rolesMovil,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				RolesMovilDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (rolesMovil != null && rolesMovil.getIdRolGmao() != null) {
			where.append(" AND UPPER(t1.IDROLGMAO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(rolesMovil.getIdRolGmao().toUpperCase() + "%");
			} else {
				params.add("%" + rolesMovil.getIdRolGmao().toUpperCase() + "%");
			}
			where.append(" AND t1.IDROLGMAO IS NOT NULL");
		}
		if (rolesMovil != null && rolesMovil.getDescRol() != null) {
			where.append(" AND UPPER(t1.DESCROL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(rolesMovil.getDescRol().toUpperCase() + "%");
			} else {
				params.add("%" + rolesMovil.getDescRol().toUpperCase() + "%");
			}
			where.append(" AND t1.DESCROL IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	@Override
	public RolesMovil update(RolesMovil rolesMovil) {
		// TODO Auto-generated method stub
		String query = "UPDATE ROLESMOVIL SET DESCROL=?, SISTEMA=? WHERE IDROL=?";
		this.jdbcTemplate.update(query, rolesMovil.getDescRol(),
				rolesMovil.getSistema(), rolesMovil.getIdRol());
		return rolesMovil;
	}

}
