package com.ejie.aa20b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.classes.Aa20bFormatoFecha;
import com.ejie.aa20b.model.Presencia;
import com.ejie.aa20b.model.Tipopresencia;
import com.ejie.aa20b.util.Aa20bConstantes;

/**
 * PresenciaDaoImpl generated by UDA, 30-abr-2015 12:52:59.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class PresenciaDaoImpl implements PresenciaDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Presencia> rwMap = new RowMapper<Presencia>() {
		public Presencia mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Presencia presencia = new Presencia();

			presencia.setIdpresencia(resultSet.getInt("IDPRESENCIA"));
			presencia.setIdtecnico(resultSet.getLong("IDTECNICO"));
			presencia.setFhlogin(resultSet.getTimestamp("FHLOGIN"));
			presencia.setFhdesde(resultSet.getTimestamp("FHDESDE"));
			presencia.setTdesde(resultSet.getString("TDESDE") == null ? ""
					: resultSet.getString("TDESDE"));
			presencia.setFhhasta(resultSet.getTimestamp("FHHASTA"));
			presencia.setThasta(resultSet.getString("THASTA") == null ? ""
					: resultSet.getString("THASTA"));
			presencia.setNombre(resultSet.getString("NOMBRE") == null ? ""
					: resultSet.getString("NOMBRE"));

			return presencia;
		}
	};
	private RowMapper<Presencia> rwMapTipos = new RowMapper<Presencia>() {
		public Presencia mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Presencia presencia = new Presencia();

			presencia.setIdpresencia(resultSet.getInt("IDPRESENCIA"));
			presencia.setIdtecnico(resultSet.getLong("IDTECNICO"));
			presencia.setFhlogin(resultSet.getTimestamp("FHLOGIN"));
			presencia.setFhdesde(resultSet.getTimestamp("FHDESDE"));
			presencia.setTdesde(resultSet.getString("TDESDE") == null ? ""
					: resultSet.getString("TDESDE"));

			Tipopresencia tipoPreDesde = new Tipopresencia();
			tipoPreDesde.setTipopre(resultSet.getString("TDESDE") == null ? ""
					: resultSet.getString("TDESDE"));
			tipoPreDesde
					.setCtipopre(resultSet.getString("CTIPODESDEPRE") == null ? ""
							: resultSet.getString("CTIPODESDEPRE"));
			tipoPreDesde
					.setEtipopre(resultSet.getString("ETIPODESDEPRE") == null ? ""
							: resultSet.getString("ETIPODESDEPRE"));
			presencia.setTipoPreDesde(tipoPreDesde);

			presencia.setFhhasta(resultSet.getTimestamp("FHHASTA"));
			presencia.setThasta(resultSet.getString("THASTA") == null ? ""
					: resultSet.getString("THASTA"));

			Tipopresencia tipoPreHasta = new Tipopresencia();
			tipoPreHasta.setTipopre(resultSet.getString("THASTA") == null ? ""
					: resultSet.getString("THASTA"));
			tipoPreHasta
					.setCtipopre(resultSet.getString("CTIPOHASTAPRE") == null ? ""
							: resultSet.getString("CTIPOHASTAPRE"));
			tipoPreHasta
					.setEtipopre(resultSet.getString("ETIPOHASTAPRE") == null ? ""
							: resultSet.getString("ETIPOHASTAPRE"));
			presencia.setTipoPreHasta(tipoPreHasta);

			presencia.setNombre(resultSet.getString("NOMBRE") == null ? ""
					: resultSet.getString("NOMBRE"));

			return presencia;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Presencia table.
	 * 
	 * @param presencia
	 *            Pagination
	 * @return Presencia
	 */
	public Presencia add(Presencia presencia) {
		// Obtener el id correlativo
		Integer idCorrelativo = this.jdbcTemplate
				.queryForInt("SELECT PRESENCIA_SEQ.NEXTVAL FROM DUAL");

		presencia.setIdpresencia(idCorrelativo);
		String query = "INSERT INTO PRESENCIA (IDPRESENCIA, IDTECNICO, FHLOGIN, FHDESDE, TDESDE, FHHASTA, THASTA) VALUES (?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, presencia.getIdpresencia(),
				presencia.getIdtecnico(), presencia.getFhlogin(),
				presencia.getFhdesde(), presencia.getTdesde(),
				presencia.getFhhasta(), presencia.getThasta());
		return presencia;
	}

	/**
	 * Cerrar presencia.
	 * 
	 * @param presencia
	 *            Pagination
	 * @return Presencia
	 */
	public Presencia cerrarAnterior(Presencia presencia) {
		String query = "UPDATE PRESENCIA SET THASTA=1 WHERE IDPRESENCIA=?";
		this.jdbcTemplate.update(query, presencia.getIdpresencia());
		return presencia;
	}

	/**
	 * Cerrar presencia.
	 * 
	 * @param presencia
	 *            Pagination
	 * @return Presencia
	 */
	public Presencia cerrarAnteriorMovil(Presencia presencia) {
		String query = "UPDATE PRESENCIA SET THASTA=5 WHERE IDPRESENCIA=?";
		this.jdbcTemplate.update(query, presencia.getIdpresencia());
		return presencia;
	}

	/**
	 * Updates a single row in the Presencia table.
	 * 
	 * @param presencia
	 *            Pagination
	 * @return Presencia
	 */
	public Presencia update(Presencia presencia) {
		String query = "UPDATE PRESENCIA SET IDTECNICO=?, FHLOGIN=?, FHDESDE=?, TDESDE=?, FHHASTA=?, THASTA=? WHERE IDPRESENCIA=?";
		this.jdbcTemplate.update(query, presencia.getIdtecnico(),
				presencia.getFhlogin(), presencia.getFhdesde(),
				presencia.getTdesde(), presencia.getFhhasta(),
				presencia.getThasta(), presencia.getIdpresencia());
		return presencia;
	}

	/**
	 * Finds a single row in the Presencia table.
	 * 
	 * @param presencia
	 *            Pagination
	 * @return Presencia
	 */
	@Transactional(readOnly = true)
	public Presencia find(Presencia presencia) {
		StringBuilder query = new StringBuilder(
				"SELECT DISTINCT t1.IDPRESENCIA IDPRESENCIA, t1.IDTECNICO IDTECNICO, t2.NOMBRE NOMBRE, t1.FHLOGIN FHLOGIN, t1.FHDESDE FHDESDE, t1.TDESDE TDESDE, t3.ctipopre CTIPODESDEPRE, t3.etipopre ETIPODESDEPRE, t1.FHHASTA FHHASTA, t1.THASTA THASTA, t4.ctipopre CTIPOHASTAPRE, t4.etipopre ETIPOHASTAPRE ");
		query.append(" FROM PRESENCIA t1, TECNICOS t2,TIPOPRESENCIA t3, TIPOPRESENCIA t4");
		query.append(" WHERE t1.IDTECNICO = t2.IDTECNICO AND t1.TDESDE = t3.TIPOPRE(+) AND t1.THASTA = t4.TIPOPRE(+) AND  t1.IDPRESENCIA = ? ");

		List<Presencia> presenciaList = this.jdbcTemplate.query(
				query.toString(), this.rwMapTipos, presencia.getIdpresencia());
		return (Presencia) DataAccessUtils.uniqueResult(presenciaList);
	}

	/**
	 * Finds a single row in the Presencia table.
	 * 
	 * @param presencia
	 *            Pagination
	 * @return Presencia
	 */
	@Transactional(readOnly = true)
	public Presencia obtenerPresenciaAnterior(Presencia presencia) {
		StringBuilder query = new StringBuilder(
				"SELECT IDPRESENCIA, null IDTECNICO, null NOMBRE, null FHLOGIN, null FHDESDE, null TDESDE, null FHHASTA, null THASTA FROM (SELECT t1.IDPRESENCIA IDPRESENCIA, t1.IDTECNICO IDTECNICO,t2.NOMBRE NOMBRE, t1.FHLOGIN FHLOGIN, t1.FHDESDE FHDESDE, t1.TDESDE TDESDE, t1.FHHASTA FHHASTA, t1.THASTA THASTA FROM PRESENCIA t1, TECNICOS t2 ");
		query.append(" WHERE t1.IDTECNICO = t2.IDTECNICO AND t1.IDPRESENCIA<? AND t1.IDTECNICO = ? ORDER BY t1.FHDESDE DESC)  where rownum = 1 ");

		List<Presencia> presenciaList = this.jdbcTemplate.query(
				query.toString(), this.rwMap, presencia.getIdpresencia(),
				presencia.getIdtecnico());
		return (Presencia) DataAccessUtils.uniqueResult(presenciaList);
	}

	/**
	 * tecnico está presente.
	 * 
	 * @param presencia
	 *            Pagination
	 * @return Boolean
	 */
	@Transactional(readOnly = true)
	public Presencia tecnicoEstaPresente(Presencia presencia) {
		// String query =
		// "SELECT t1.IDPRESENCIA IDPRESENCIA, t1.IDTECNICO IDTECNICO, t2.NOMBRE NOMBRE, t1.FHLOGIN FHLOGIN, t1.FHDESDE FHDESDE, t1.TDESDE TDESDE, t1.FHHASTA FHHASTA, t1.THASTA THASTA FROM PRESENCIA t1, TECNICOS t2  WHERE t1.IDTECNICO = t2.IDTECNICO AND t1.THASTA=0 AND t1.IDTECNICO = ?  ";
		String query = "SELECT  0 as IDPRESENCIA, t1.IDTECNICO IDTECNICO,t2.NOMBRE NOMBRE, t1.FHLOGIN FHLOGIN, Max(t1.FHDESDE ) As FHDESDE, t1.TDESDE TDESDE, t1.FHHASTA FHHASTA, t1.THASTA THASTA "
				+ " FROM PRESENCIA t1, TECNICOS t2 "
				+ " WHERE t1.IDTECNICO = t2.IDTECNICO AND t1.THASTA =0 AND t1.IDTECNICO  = ?"
				+ " Group By t1.IDTECNICO,t2.NOMBRE, t1.FHLOGIN, t1.TDESDE, t1.FHHASTA, t1.THASTA ";

		List<Presencia> presenciaList = this.jdbcTemplate.query(query,
				this.rwMap, presencia.getIdtecnico());
		return (Presencia) DataAccessUtils.uniqueResult(presenciaList);
	}

	/**
	 * Comprobar si el tecnico esta presente
	 * 
	 * @param codEdificio
	 *            String
	 * @return Boolean
	 */
	@Transactional(readOnly = true)
	public Boolean comprobarTecnicoEstaPresente(Presencia presencia) {

		Presencia presenciaTec = this.tecnicoEstaPresente(presencia);

		if (presenciaTec != null) {
			// El técnico está presente
			return true;
		} else {
			return false;
		}
	}

	/**
	 * Removes a single row in the Presencia table.
	 * 
	 * @param presencia
	 *            Pagination
	 * @return
	 */
	public void remove(Presencia presencia) {
		String query = "DELETE FROM PRESENCIA WHERE IDPRESENCIA=?";
		this.jdbcTemplate.update(query, presencia.getIdpresencia());
	}

	/**
	 * Finds a List of rows in the Presencia table.
	 * 
	 * @param presencia
	 *            Presencia
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Presencia> findAll(Presencia presencia, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDPRESENCIA IDPRESENCIA,t1.IDTECNICO IDTECNICO, t2.NOMBRE NOMBRE,t1.FHLOGIN FHLOGIN,t1.FHDESDE FHDESDE,t1.TDESDE TDESDE, t3.ctipopre CTIPODESDEPRE, t3.etipopre ETIPODESDEPRE,t1.FHHASTA FHHASTA,t1.THASTA THASTA, t4.ctipopre CTIPOHASTAPRE, t4.etipopre ETIPOHASTAPRE ");
		query.append("FROM PRESENCIA t1, TECNICOS t2, TIPOPRESENCIA t3, TIPOPRESENCIA t4 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(presencia);
		StringBuilder where = new StringBuilder(
				" WHERE t1.IDTECNICO = t2.IDTECNICO AND t1.TDESDE = t3.TIPOPRE(+) AND t1.THASTA = t4.TIPOPRE(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Presencia>) this.jdbcTemplate.query(query.toString(),
				this.rwMapTipos, params.toArray());
	}

	/**
	 * Counts rows in the Presencia table.
	 * 
	 * @param presencia
	 *            Presencia
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Presencia presencia) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM PRESENCIA t1, TECNICOS t2, TIPOPRESENCIA t3, TIPOPRESENCIA t4 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(presencia);
		StringBuilder where = new StringBuilder(
				" WHERE t1.IDTECNICO = t2.IDTECNICO AND t1.TDESDE = t3.TIPOPRE(+) AND t1.THASTA = t4.TIPOPRE(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Presencia table using like.
	 * 
	 * @param presencia
	 *            Presencia
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Presencia> findAllLike(Presencia presencia,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDPRESENCIA IDPRESENCIA,t1.IDTECNICO IDTECNICO, t2.NOMBRE NOMBRE,t1.FHLOGIN FHLOGIN,t1.FHDESDE FHDESDE,t1.TDESDE TDESDE, t3.ctipopre CTIPODESDEPRE, t3.etipopre ETIPODESDEPRE,t1.FHHASTA FHHASTA,t1.THASTA THASTA, t4.ctipopre CTIPOHASTAPRE, t4.etipopre ETIPOHASTAPRE ");
		query.append("FROM PRESENCIA t1, TECNICOS t2, TIPOPRESENCIA t3, TIPOPRESENCIA t4 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(presencia, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE t1.IDTECNICO = t2.IDTECNICO AND t1.TDESDE = t3.TIPOPRE(+) AND t1.THASTA = t4.TIPOPRE(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Presencia>) this.jdbcTemplate.query(query.toString(),
				this.rwMapTipos, params.toArray());
	}

	/**
	 * Counts rows in the Presencia table using like.
	 * 
	 * @param presencia
	 *            Presencia
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Presencia presencia, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM PRESENCIA t1, TECNICOS t2, TIPOPRESENCIA t3, TIPOPRESENCIA t4  ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(presencia, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE t1.IDTECNICO = t2.IDTECNICO AND t1.TDESDE = t3.TIPOPRE(+) AND t1.THASTA = t4.TIPOPRE(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Presencia table using like.
	 * 
	 * @param presencia
	 *            Presencia
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Presencia> obtenerPresencias(Presencia presencia,
			Pagination pagination, Boolean startsWith) {

		// Obtiene la última presencia de cada técnico.
		StringBuilder query = new StringBuilder("SELECT  DISTINCT ");
		query.append(" min(t1.IDPRESENCIA) keep (dense_rank first order by t1.FHDESDE desc nulls last) IDPRESENCIA, ");
		query.append(" min(t1.IDTECNICO) keep (dense_rank first order by t1.FHDESDE desc nulls last) IDTECNICO, ");
		query.append(" min(t2.NOMBRE) keep (dense_rank first order by t1.FHDESDE desc nulls last) NOMBRE, ");
		query.append(" min(t1.FHLOGIN) keep (dense_rank first order by t1.FHDESDE desc nulls last) FHLOGIN, ");
		query.append(" min(t1.FHDESDE) keep (dense_rank first order by t1.FHDESDE desc nulls last) FHDESDE, ");
		query.append(" min(t1.TDESDE) keep (dense_rank first order by t1.FHDESDE desc nulls last) TDESDE, ");
		query.append(" min(t1.FHHASTA) keep (dense_rank first order by t1.FHDESDE desc nulls last) FHHASTA, ");
		query.append(" min(t1.THASTA) keep (dense_rank first order by t1.FHDESDE desc nulls last) THASTA ");
		query.append("FROM PRESENCIA t1, TECNICOS t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapGrid(presencia,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE t1.IDTECNICO = t2.IDTECNICO AND (t2.TECNICO_CONTRATA=0 or t2.TECNICO_CONTRATA IS NULL) ");

		where.append(mapaWhere.get("query"));

		if (presencia != null && presencia.getEdificio() != null) {
			where.append(" AND t1.IDTECNICO in (SELECT t3.IDTECNICO FROM TECNICO_EDIF t3, EDIFICIOS t4 WHERE t3.IDEDIFICIO=t4.IDEDIFICIO ");
			String idioma = LocaleContextHolder.getLocale().getLanguage();
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				where.append(" AND UPPER(t4.EEDIFICIO) like ? ESCAPE  '\\'");
				where.append(" AND t4.EEDIFICIO IS NOT NULL");
			} else {
				where.append(" AND UPPER(t4.CEDIFICIO) like ? ESCAPE  '\\'");
				where.append(" AND t4.CEDIFICIO IS NOT NULL");
			}
			where.append(" )");
		}
		query.append(where);

		query.append(" GROUP BY t1.IDTECNICO");

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Presencia>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Presencia table using like.
	 * 
	 * @param presencia
	 *            Presencia
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long obtenerPresenciasCount(Presencia presencia, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(DISTINCT t1.IDTECNICO) FROM PRESENCIA t1, TECNICOS t2  ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapGrid(presencia,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE t1.IDTECNICO = t2.IDTECNICO ");

		where.append(mapaWhere.get("query"));
		if (presencia != null && presencia.getEdificio() != null) {
			where.append(" AND t1.IDTECNICO in (SELECT t3.IDTECNICO FROM TECNICO_EDIF t3, EDIFICIOS t4 WHERE t3.IDEDIFICIO=t4.IDEDIFICIO ");
			String idioma = LocaleContextHolder.getLocale().getLanguage();
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				where.append(" AND UPPER(t4.EEDIFICIO) like ? ESCAPE  '\\'");
				where.append(" AND t4.EEDIFICIO IS NOT NULL");
			} else {
				where.append(" AND UPPER(t4.CEDIFICIO) like ? ESCAPE  '\\'");
				where.append(" AND t4.CEDIFICIO IS NOT NULL");
			}
			where.append(" )");
		}

		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Presencia entity
	 * 
	 * @param presencia
	 *            Presencia Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Presencia presencia) {

		StringBuilder where = new StringBuilder(
				PresenciaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (presencia != null && presencia.getIdpresencia() != null) {
			where.append(" AND t1.IDPRESENCIA = ?");
			params.add(presencia.getIdpresencia());
		}
		if (presencia != null && presencia.getIdtecnico() != null) {
			where.append(" AND t1.IDTECNICO = ?");
			params.add(presencia.getIdtecnico());
		}
		if (presencia != null && presencia.getFhlogin() != null) {
			where.append(" AND t1.FHLOGIN = ?");
			params.add(presencia.getFhlogin());
		}
		if (presencia != null && presencia.getFhdesde() != null) {
			where.append(" AND t1.FHDESDE = ?");
			params.add(presencia.getFhdesde());
		}
		if (presencia != null && presencia.getTdesde() != null) {
			where.append(" AND t1.TDESDE = ?");
			params.add(presencia.getTdesde());
		}
		if (presencia != null && presencia.getFhhasta() != null) {
			where.append(" AND t1.FHHASTA = ?");
			params.add(presencia.getFhhasta());
		}
		if (presencia != null && presencia.getThasta() != null) {
			where.append(" AND t1.THASTA = ?");
			params.add(presencia.getThasta());
		}
		if (presencia != null && presencia.getNombre() != null) {
			where.append(" AND t2.NOMBRE = ?");
			params.add(presencia.getNombre());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Presencia entity
	 * 
	 * @param presencia
	 *            Presencia Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Presencia presencia,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				PresenciaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (presencia != null && presencia.getIdpresencia() != null) {
			where.append(" AND t1.IDPRESENCIA = ?");
			params.add(presencia.getIdpresencia());
		}
		if (presencia != null && presencia.getIdtecnico() != null) {
			where.append(" AND t1.IDTECNICO = ?");
			params.add(presencia.getIdtecnico());
		}
		if (presencia != null && presencia.getFhlogin() != null) {
			where.append(" AND t1.FHLOGIN = ?");
			params.add(presencia.getFhlogin());
		}
		if (presencia != null && presencia.getFhdesde() != null) {
			where.append(" AND t1.FHDESDE = ?");
			params.add(presencia.getFhdesde());
		}
		if (presencia != null && presencia.getTdesde() != null) {
			where.append(" AND UPPER(t1.TDESDE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(presencia.getTdesde().toUpperCase() + "%");
			} else {
				params.add("%" + presencia.getTdesde().toUpperCase() + "%");
			}
			where.append(" AND t1.TDESDE IS NOT NULL");
		}
		if (presencia != null && presencia.getFhhasta() != null) {
			where.append(" AND t1.FHHASTA = ?");
			params.add(presencia.getFhhasta());
		}
		if (presencia != null && presencia.getThasta() != null) {
			where.append(" AND UPPER(t1.THASTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(presencia.getThasta().toUpperCase() + "%");
			} else {
				params.add("%" + presencia.getThasta().toUpperCase() + "%");
			}
			where.append(" AND t1.THASTA IS NOT NULL");
		}
		if (presencia != null && presencia.getNombre() != null) {
			where.append(" AND UPPER(t2.NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(presencia.getNombre().toUpperCase() + "%");
			} else {
				params.add("%" + presencia.getNombre().toUpperCase() + "%");
			}
			where.append(" AND t2.NOMBRE IS NOT NULL");
		}

		if (presencia != null && presencia.getFechaPreD() != null) {
			String idioma = LocaleContextHolder.getLocale().getLanguage();
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				where.append(" AND (FHDESDE>=to_date(?, 'YY/MM/DD HH24:MI') AND FHDESDE<=to_date(?, 'YY/MM/DD HH24:MI') OR  NVL(FHHASTA,SYSDATE)>=to_date(?, 'YY/MM/DD HH24:MI') AND  NVL(FHHASTA,SYSDATE)<=to_date(?, 'YY/MM/DD HH24:MI'))");
				params.add(Aa20bFormatoFecha.date2String(
						presencia.getFechaPreD(),
						LocaleContextHolder.getLocale(), 8));
				params.add(Aa20bFormatoFecha.date2String(
						presencia.getFechaPreH(),
						LocaleContextHolder.getLocale(), 8));
				params.add(Aa20bFormatoFecha.date2String(
						presencia.getFechaPreD(),
						LocaleContextHolder.getLocale(), 8));
				params.add(Aa20bFormatoFecha.date2String(
						presencia.getFechaPreH(),
						LocaleContextHolder.getLocale(), 8));
			} else {
				where.append(" AND (FHDESDE>=to_date(?, 'DD/MM/YY HH24:MI') AND FHDESDE<=to_date(?, 'DD/MM/YY HH24:MI') OR  NVL(FHHASTA,SYSDATE)>=to_date(?, 'DD/MM/YY HH24:MI') AND  NVL(FHHASTA,SYSDATE)<=to_date(?, 'DD/MM/YY HH24:MI'))");
				params.add(Aa20bFormatoFecha.date2String(
						presencia.getFechaPreD(),
						LocaleContextHolder.getLocale(), 9));
				params.add(Aa20bFormatoFecha.date2String(
						presencia.getFechaPreH(),
						LocaleContextHolder.getLocale(), 9));
				params.add(Aa20bFormatoFecha.date2String(
						presencia.getFechaPreD(),
						LocaleContextHolder.getLocale(), 9));
				params.add(Aa20bFormatoFecha.date2String(
						presencia.getFechaPreH(),
						LocaleContextHolder.getLocale(), 9));
			}
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Presencia entity
	 * 
	 * @param presencia
	 *            Presencia Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMapGrid(Presencia presencia,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				PresenciaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (presencia != null && presencia.getIdpresencia() != null) {
			where.append(" AND t1.IDPRESENCIA = ?");
			params.add(presencia.getIdpresencia());
		}
		if (presencia != null && presencia.getIdtecnico() != null) {
			where.append(" AND t1.IDTECNICO = ?");
			params.add(presencia.getIdtecnico());
		}
		if (presencia != null && presencia.getFhlogin() != null) {
			where.append(" AND t1.FHLOGIN = ?");
			params.add(presencia.getFhlogin());
		}
		if (presencia != null && presencia.getFhdesde() != null) {
			where.append(" AND t1.FHDESDE = ?");
			params.add(presencia.getFhdesde());
		}
		if (presencia != null && presencia.getTdesde() != null) {
			where.append(" AND UPPER(t1.TDESDE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(presencia.getTdesde().toUpperCase() + "%");
			} else {
				params.add("%" + presencia.getTdesde().toUpperCase() + "%");
			}
			where.append(" AND t1.TDESDE IS NOT NULL");
		}
		if (presencia != null && presencia.getFhhasta() != null) {
			where.append(" AND t1.FHHASTA = ?");
			params.add(presencia.getFhhasta());
		}
		if (presencia != null && presencia.getThasta() != null) {
			where.append(" AND UPPER(t1.THASTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(presencia.getThasta().toUpperCase() + "%");
			} else {
				params.add("%" + presencia.getThasta().toUpperCase() + "%");
			}
			where.append(" AND t1.THASTA IS NOT NULL");
		}
		if (presencia != null && presencia.getNombre() != null) {
			where.append(" AND UPPER(t2.NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(presencia.getNombre().toUpperCase() + "%");
			} else {
				params.add("%" + presencia.getNombre().toUpperCase() + "%");
			}
			where.append(" AND t2.NOMBRE IS NOT NULL");
		}

		if (presencia != null && presencia.getEdificio() != null) {
			if (startsWith) {
				params.add(presencia.getEdificio().toUpperCase() + "%");
			} else {
				params.add("%" + presencia.getEdificio().toUpperCase() + "%");
			}
		}
		if (presencia != null && presencia.getPresenteAhora() != null
				&& presencia.getPresenteAhora().equals("1")) {
			where.append(" AND t1.FHHASTA is null AND t1.FHDESDE< SYSDATE ");
		}
		if (presencia != null && presencia.getUidUsuario() != null) {
			// Solo los tecnicos que estan asociados al usuario de XLNET
			where.append(" AND t1.IDTECNICO in (SELECT t5.IDTECNICO FROM USUTECNICOS t5 WHERE UPPER(t5.UID_PER) = ? )");
			params.add(presencia.getUidUsuario().toUpperCase());
		}

		if (presencia != null && presencia.getFechaPreD() != null) {
			String idioma = LocaleContextHolder.getLocale().getLanguage();
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				where.append(" AND (FHDESDE>=to_date(?, 'YY/MM/DD HH24:MI') AND FHDESDE<=to_date(?, 'YY/MM/DD HH24:MI') OR  NVL(FHHASTA,SYSDATE)>=to_date(?, 'YY/MM/DD HH24:MI') AND  NVL(FHHASTA,SYSDATE)<=to_date(?, 'YY/MM/DD HH24:MI'))");
				params.add(Aa20bFormatoFecha.date2String(
						presencia.getFechaPreD(),
						LocaleContextHolder.getLocale(), 8));
				params.add(Aa20bFormatoFecha.date2String(
						presencia.getFechaPreH(),
						LocaleContextHolder.getLocale(), 8));
				params.add(Aa20bFormatoFecha.date2String(
						presencia.getFechaPreD(),
						LocaleContextHolder.getLocale(), 8));
				params.add(Aa20bFormatoFecha.date2String(
						presencia.getFechaPreH(),
						LocaleContextHolder.getLocale(), 8));
			} else {
				where.append(" AND (FHDESDE>=to_date(?, 'DD/MM/YY HH24:MI') AND FHDESDE<=to_date(?, 'DD/MM/YY HH24:MI') OR  NVL(FHHASTA,SYSDATE)>=to_date(?, 'DD/MM/YY HH24:MI') AND  NVL(FHHASTA,SYSDATE)<=to_date(?, 'DD/MM/YY HH24:MI'))");
				params.add(Aa20bFormatoFecha.date2String(
						presencia.getFechaPreD(),
						LocaleContextHolder.getLocale(), 9));
				params.add(Aa20bFormatoFecha.date2String(
						presencia.getFechaPreH(),
						LocaleContextHolder.getLocale(), 9));
				params.add(Aa20bFormatoFecha.date2String(
						presencia.getFechaPreD(),
						LocaleContextHolder.getLocale(), 9));
				params.add(Aa20bFormatoFecha.date2String(
						presencia.getFechaPreH(),
						LocaleContextHolder.getLocale(), 9));
			}
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
