package com.ejie.aa20b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.aa20b.model.Presencia;

/**
 * PresenciaDao generated by UDA, 30-abr-2015 12:52:59.
 * 
 * @author UDA
 */

public interface PresenciaDao {

	/**
	 * Inserts a single row in the Presencia table.
	 * 
	 * @param presencia
	 *            Presencia
	 * @return Presencia
	 */
	Presencia add(Presencia presencia);

	/**
	 * Updates a single row in the Presencia table.
	 * 
	 * @param presencia
	 *            Presencia
	 * @return Presencia
	 */
	Presencia update(Presencia presencia);

	/**
	 * Finds a single row in the Presencia table.
	 * 
	 * @param presencia
	 *            Presencia
	 * @return Presencia
	 */
	Presencia find(Presencia presencia);

	/**
	 * Deletes a single row in the Presencia table.
	 * 
	 * @param presencia
	 *            Presencia
	 * @return
	 */
	void remove(Presencia presencia);

	/**
	 * Finds a List of rows in the Presencia table.
	 * 
	 * @param presencia
	 *            Presencia
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Presencia> findAll(Presencia presencia, Pagination pagination);

	/**
	 * Counts rows in the Presencia table.
	 * 
	 * @param presencia
	 *            Presencia
	 * @return Long
	 */
	Long findAllCount(Presencia presencia);

	/**
	 * Finds rows in the Presencia table using like.
	 * 
	 * @param presencia
	 *            Presencia
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Presencia> findAllLike(Presencia presencia, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Presencia table using like.
	 * 
	 * @param presencia
	 *            Presencia
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Presencia presencia, Boolean startsWith);

	/**
	 * Comprobar si el tecnico esta presente
	 * 
	 * @param presencia
	 *            Presencia
	 * @return Boolean
	 */

	public Boolean comprobarTecnicoEstaPresente(Presencia presencia);

	/**
	 * tecnico está presente.
	 * 
	 * @param presencia
	 *            Pagination
	 * @return Boolean
	 */

	public Presencia tecnicoEstaPresente(Presencia presencia);

	/**
	 * Finds rows in the Presencia table using like.
	 * 
	 * @param presencia
	 *            Presencia
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Presencia> obtenerPresencias(Presencia presencia,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Presencia table using like.
	 * 
	 * @param presencia
	 *            Presencia
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long obtenerPresenciasCount(Presencia presencia, Boolean startsWith);

	/**
	 * Updates a single row in the Presencia table.
	 * 
	 * @param presencia
	 *            Presencia
	 * @return Presencia
	 */
	Presencia cerrarAnterior(Presencia presencia);

	/**
	 * Finds a single row in the Presencia table.
	 * 
	 * @param presencia
	 *            Pagination
	 * @return Presencia
	 */
	public Presencia obtenerPresenciaAnterior(Presencia presencia);

	Presencia cerrarAnteriorMovil(Presencia presenciaAnterior);

}
