package com.ejie.aa20b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.aa20b.model.Plantas;

/**
 * PlantasDao generated by UDA, 28-nov-2014 11:32:16.
 * 
 * @author UDA
 */

public interface PlantasDao {

	/**
	 * Inserts a single row in the Plantas table.
	 * 
	 * @param plantas
	 *            Plantas
	 * @return Plantas
	 */
	Plantas add(Plantas plantas);

	/**
	 * Updates a single row in the Plantas table.
	 * 
	 * @param plantas
	 *            Plantas
	 * @return Plantas
	 */
	Plantas update(Plantas plantas);

	/**
	 * Finds a single row in the Plantas table.
	 * 
	 * @param plantas
	 *            Plantas
	 * @return Plantas
	 */
	Plantas find(Plantas plantas);

	/**
	 * Finds a single row in the Plantas table.
	 * 
	 * @param plantas
	 *            Plantas
	 * @return Plantas
	 */
	Plantas obtenerPlanta(Plantas plantas);

	/**
	 * Deletes a single row in the Plantas table.
	 * 
	 * @param plantas
	 *            Plantas
	 * @return
	 */
	void remove(Plantas plantas);

	/**
	 * Finds a List of rows in the Plantas table.
	 * 
	 * @param plantas
	 *            Plantas
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Plantas> findAll(Plantas plantas, Pagination pagination);

	/**
	 * Obtener Plantas para el edificio y zona especificado.
	 * 
	 * @param codEdif
	 *            String
	 * @param codZona
	 *            Integer
	 * @return List
	 */
	public List<Plantas> obtenerPlantasEdifZona(String codEdif, Integer codZona);

	List<Plantas> obtenerPlantasEdifZonaAlta(String codEdif, Integer codZona);

	/**
	 * Obtener Plantas para el edificio y zona especificado.
	 * 
	 * @param codEdif
	 *            String
	 * @param codZona
	 *            Integer
	 * @return List
	 */
	public List<Plantas> obtenerPlantasEdifZonaConPlanos(String codEdif,
			Integer codZona);

	/**
	 * Counts rows in the Plantas table.
	 * 
	 * @param plantas
	 *            Plantas
	 * @return Long
	 */
	Long findAllCount(Plantas plantas);

	/**
	 * Finds rows in the Plantas table using like.
	 * 
	 * @param plantas
	 *            Plantas
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Plantas> findAllLike(Plantas plantas, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Plantas table using like.
	 * 
	 * @param plantas
	 *            Plantas
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Plantas plantas, Boolean startsWith);

	List<Plantas> obtenerPlantasZonaLibres(String codEdificio, String codZona,
			String language);

	List<Plantas> obtenerPlantasZonaOcupadas(String codEdificio,
			String codZona, String language);

	Plantas obtenerPlantaDesdeXlnets(Plantas plantas);
}
