package com.ejie.aa20b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.Partes;
import com.ejie.aa20b.model.Partetecgmaorechazo;
import com.ejie.aa20b.model.Partetecnicosgmao;
import com.ejie.x38.dto.Pagination;

@Repository
@Transactional
public class PartetecnicosgmaoDaoImpl implements PartetecnicosgmaoDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Partetecnicosgmao> rwMap = new RowMapper<Partetecnicosgmao>() {
		public Partetecnicosgmao mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Partetecnicosgmao(resultSet.getInt("IDPARTEC"),
					resultSet.getInt("IDPARTE"),
					resultSet.getLong("IDTECNICO"),
					resultSet.getString("GUIDGMAO"),
					resultSet.getString("GUIDPLANO"),
					resultSet.getString("ESTADOGMAO"),
					resultSet.getTimestamp("FECHAESTADO"),
					resultSet.getInt("TIEMPOPAUSA"),
					resultSet.getString("PAUSAAUTO"),
					resultSet.getString("GUIDPADRE"),
					resultSet.getString("GUIDSEGUIDO"),
					resultSet.getString("GUIDPDF"),
					resultSet.getString("URGENTEAVISO"));
		}
	};

	private RowMapper<Partetecgmaorechazo> rwMapRechazo = new RowMapper<Partetecgmaorechazo>() {
		public Partetecgmaorechazo mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Partetecgmaorechazo(resultSet.getInt("IDPARTE"),
					resultSet.getLong("IDTECNICO"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Partetecnicos table.
	 * 
	 * @param partetecnicos
	 *            Pagination
	 * @return Partetecnicos
	 */
	public Partetecnicosgmao add(Partetecnicosgmao partetecnicosgmao) {

		String query = "INSERT INTO PARTETECNICOSGMAO (IDPARTEC, IDPARTE, IDTECNICO, GUIDGMAO, GUIDPLANO, ESTADOGMAO, FECHAESTADO, TIEMPOPAUSA,PAUSAAUTO,GUIDPADRE,GUIDSEGUIDO, GUIDPDF, URGENTEAVISO) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, partetecnicosgmao.getIdpartec(),
				partetecnicosgmao.getIdparte(),
				partetecnicosgmao.getIdtecnico(),
				partetecnicosgmao.getGuidpartetecgmao(),
				partetecnicosgmao.getGuidplanopartegmao(),
				partetecnicosgmao.getEstadoGmao(),
				partetecnicosgmao.getFechaEstadoGmao(),
				partetecnicosgmao.getTiempopausaGmao(),
				partetecnicosgmao.getPausaAutoGmao(),
				partetecnicosgmao.getGuidpartepadreayuda(),
				partetecnicosgmao.getGuidparteseguido(),
				partetecnicosgmao.getGuidpdfpartegmao(),
				partetecnicosgmao.getUrgenteaviso());
		return partetecnicosgmao;
	}

	public Partetecgmaorechazo addRechazoTec(
			Partetecgmaorechazo partetecnicosgmaorechazo) {

		String query = "INSERT INTO RECHAZOSGMAO (IDPARTE, IDTECNICO) VALUES (?,?)";
		this.jdbcTemplate.update(query, partetecnicosgmaorechazo.getIdparte(),
				partetecnicosgmaorechazo.getIdtecnico());
		return partetecnicosgmaorechazo;
	}

	@Transactional(readOnly = true)
	public Partetecgmaorechazo findRechazoTec(
			Partetecgmaorechazo partetecnicosgmaorechazo) {
		String query = "SELECT t1.IDPARTE IDPARTE, t1.IDTECNICO IDTECNICO FROM RECHAZOSGMAO t1 WHERE t1.IDPARTE = ? AND IDTECNICO = ?  ";

		List<Partetecgmaorechazo> partetecnicosgmaorechazoList = this.jdbcTemplate
				.query(query, this.rwMapRechazo,
						partetecnicosgmaorechazo.getIdparte(),
						partetecnicosgmaorechazo.getIdtecnico());
		return (Partetecgmaorechazo) DataAccessUtils
				.uniqueResult(partetecnicosgmaorechazoList);
	}

	/**
	 * Updates a single row in the Partetecnicos table.
	 * 
	 * @param partetecnicos
	 *            Pagination
	 * @return Partetecnicos
	 */
	public Partetecnicosgmao update(Partetecnicosgmao partetecnicosgmao) {
		String query = "UPDATE PARTETECNICOSGMAO SET IDPARTEC=?, IDTECNICO=?, GUIDPLANO=?, ESTADOGMAO=?, FECHAESTADO=?, GUIDPADRE=?, GUIDSEGUIDO=?, GUIDPDF=?, URGENTEAVISO=? WHERE IDPARTE=? AND GUIDGMAO=?";
		this.jdbcTemplate.update(query, partetecnicosgmao.getIdpartec(),
				partetecnicosgmao.getIdtecnico(),
				partetecnicosgmao.getGuidplanopartegmao(),
				partetecnicosgmao.getEstadoGmao(),
				partetecnicosgmao.getFechaEstadoGmao(),
				partetecnicosgmao.getGuidpartepadreayuda(),
				partetecnicosgmao.getGuidparteseguido(),
				partetecnicosgmao.getGuidpdfpartegmao(),
				partetecnicosgmao.getUrgenteaviso(),
				partetecnicosgmao.getIdparte(),
				partetecnicosgmao.getGuidpartetecgmao());
		return partetecnicosgmao;
	}

	public void actualizarTiempoPausaParte(Partetecnicosgmao partetecnicosgmao) {
		String query = "UPDATE PARTETECNICOSGMAO SET TIEMPOPAUSA=? WHERE IDPARTE=? AND GUIDGMAO=?";
		this.jdbcTemplate.update(query, partetecnicosgmao.getTiempopausaGmao(),
				partetecnicosgmao.getIdparte(),
				partetecnicosgmao.getGuidpartetecgmao());
	}

	public Partetecnicosgmao marcarPausaAutoParte(
			Partetecnicosgmao partetecnicosgmao) {
		String query = "UPDATE PARTETECNICOSGMAO SET PAUSAAUTO=?,ESTADOGMAO=?,FECHAESTADO=? WHERE IDPARTE=? AND GUIDGMAO=?";
		this.jdbcTemplate.update(query, partetecnicosgmao.getPausaAutoGmao(),
				partetecnicosgmao.getEstadoGmao(),
				partetecnicosgmao.getFechaEstadoGmao(),
				partetecnicosgmao.getIdparte(),
				partetecnicosgmao.getGuidpartetecgmao());
		return partetecnicosgmao;
	}

	/**
	 * Finds a single row in the Partetecnicos table.
	 * 
	 * @param partetecnicos
	 *            Pagination
	 * @return Partetecnicos
	 */
	@Transactional(readOnly = true)
	public Partetecnicosgmao find(Partetecnicosgmao partetecnicosgmao) {
		String query = "SELECT t1.IDPARTEC IDPARTEC, t1.IDPARTE IDPARTE, t1.IDTECNICO IDTECNICO, t1.GUIDGMAO GUIDGMAO, t1.GUIDPLANO GUIDPLANO, t1.ESTADOGMAO ESTADOGMAO, t1.FECHAESTADO FECHAESTADO, t1.TIEMPOPAUSA TIEMPOPAUSA, t1.PAUSAAUTO PAUSAAUTO, t1.GUIDPADRE GUIDPADRE, t1.GUIDSEGUIDO GUIDSEGUIDO, t1.GUIDPDF GUIDPDF, t1.URGENTEAVISO URGENTEAVISO FROM PARTETECNICOSGMAO t1 WHERE t1.IDPARTE = ? AND IDTECNICO = ?  ";

		List<Partetecnicosgmao> partetecnicosgmaoList = this.jdbcTemplate
				.query(query, this.rwMap, partetecnicosgmao.getIdparte(),
						partetecnicosgmao.getIdtecnico());
		return (Partetecnicosgmao) DataAccessUtils
				.uniqueResult(partetecnicosgmaoList);
	}

	/**
	 * Finds a single row in the Partetecnicos table.
	 * 
	 * @param partetecnicos
	 *            Pagination
	 * @return Partetecnicos
	 */
	@Transactional(readOnly = true)
	public Partetecnicosgmao findParteSinTecnico(
			Partetecnicosgmao partetecnicosgmao) {
		String query = "SELECT t1.IDPARTEC IDPARTEC, t1.IDPARTE IDPARTE, t1.IDTECNICO IDTECNICO, t1.GUIDGMAO GUIDGMAO, t1.GUIDPLANO GUIDPLANO, t1.ESTADOGMAO ESTADOGMAO, t1.FECHAESTADO FECHAESTADO, t1.TIEMPOPAUSA TIEMPOPAUSA, t1.PAUSAAUTO PAUSAAUTO,t1.GUIDPADRE GUIDPADRE, t1.GUIDSEGUIDO GUIDSEGUIDO, t1.GUIDPDF GUIDPDF, t1.URGENTEAVISO URGENTEAVISO FROM PARTETECNICOSGMAO t1 WHERE t1.IDPARTE = ? AND (t1.IDTECNICO is null OR t1.IDTECNICO = 0) AND (t1.IDPARTEC is null OR t1.IDPARTEC = 0)  ";

		List<Partetecnicosgmao> partetecnicosgmaoList = this.jdbcTemplate
				.query(query, this.rwMap, partetecnicosgmao.getIdparte());
		return (Partetecnicosgmao) DataAccessUtils
				.uniqueResult(partetecnicosgmaoList);
	}

	/**
	 * Finds a single row in the Partetecnicos table.
	 * 
	 * @param partetecnicos
	 *            Pagination
	 * @return Partetecnicos
	 */
	@Transactional(readOnly = true)
	public Partetecnicosgmao findByGUID(Partetecnicosgmao partetecnicosgmao) {
		String query = "SELECT t1.IDPARTEC IDPARTEC, t1.IDPARTE IDPARTE, t1.IDTECNICO IDTECNICO, t1.GUIDGMAO GUIDGMAO, t1.GUIDPLANO GUIDPLANO, t1.ESTADOGMAO ESTADOGMAO, t1.FECHAESTADO FECHAESTADO, t1.TIEMPOPAUSA TIEMPOPAUSA, t1.PAUSAAUTO PAUSAAUTO,t1.GUIDPADRE GUIDPADRE, t1.GUIDSEGUIDO GUIDSEGUIDO,t1.GUIDPDF GUIDPDF, t1.URGENTEAVISO URGENTEAVISO FROM PARTETECNICOSGMAO t1 WHERE t1.GUIDGMAO = ? ";

		List<Partetecnicosgmao> partetecnicosgmaoList = this.jdbcTemplate
				.query(query, this.rwMap,
						partetecnicosgmao.getGuidpartetecgmao());
		return (Partetecnicosgmao) DataAccessUtils
				.uniqueResult(partetecnicosgmaoList);
	}

	/**
	 * Finds a single row in the Partetecnicos table.
	 * 
	 * @param partetecnicos
	 *            Pagination
	 * @return Partetecnicos
	 */
	@Transactional(readOnly = true)
	public Partetecnicosgmao findByIdParte(Partetecnicosgmao partetecnicosgmao) {
		String query = "SELECT t1.IDPARTEC IDPARTEC, t1.IDPARTE IDPARTE, t1.IDTECNICO IDTECNICO, t1.GUIDGMAO GUIDGMAO, t1.GUIDPLANO GUIDPLANO, t1.ESTADOGMAO ESTADOGMAO, t1.FECHAESTADO FECHAESTADO, t1.TIEMPOPAUSA TIEMPOPAUSA, t1.PAUSAAUTO PAUSAAUTO,t1.GUIDPADRE GUIDPADRE, t1.GUIDSEGUIDO GUIDSEGUIDO,t1.GUIDPDF GUIDPDF, t1.URGENTEAVISO URGENTEAVISO FROM PARTETECNICOSGMAO t1 WHERE t1.IDPARTE = ?";
		// Si la búsqueda es sin técnico
		if (partetecnicosgmao != null
				&& partetecnicosgmao.getIdtecnico() != null) {
			query += " AND t1.IDTECNICO = ? ";

			List<Partetecnicosgmao> partetecnicosgmaoList = this.jdbcTemplate
					.query(query, this.rwMap, partetecnicosgmao.getIdparte(),
							partetecnicosgmao.getIdtecnico());
			return (Partetecnicosgmao) DataAccessUtils
					.uniqueResult(partetecnicosgmaoList);
		} else {
			query += " AND t1.IDTECNICO is null ";

			List<Partetecnicosgmao> partetecnicosgmaoList = this.jdbcTemplate
					.query(query, this.rwMap, partetecnicosgmao.getIdparte());

			return (Partetecnicosgmao) DataAccessUtils
					.uniqueResult(partetecnicosgmaoList);
		}

	}

	/**
	 * Finds a List of rows in the Partetecnicos table.
	 * 
	 * @param partetecnicos
	 *            Partetecnicos
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Partetecnicosgmao> findAll(Partetecnicosgmao partetecnicosgmao,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDPARTEC IDPARTEC,t1.IDPARTE IDPARTE,t1.IDTECNICO IDTECNICO,t1.GUIDGMAO GUIDGMAO, t1.GUIDPLANO GUIDPLANO, t1.ESTADOGMAO ESTADOGMAO, t1.FECHAESTADO FECHAESTADO, t1.TIEMPOPAUSA TIEMPOPAUSA, t1.PAUSAAUTO PAUSAAUTO,t1.GUIDPADRE GUIDPADRE, t1.GUIDSEGUIDO GUIDSEGUIDO,t1.GUIDPDF GUIDPDF, t1.URGENTEAVISO URGENTEAVISO ");
		query.append("FROM PARTETECNICOSGMAO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(partetecnicosgmao);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Partetecnicosgmao>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	@Transactional(readOnly = true)
	public List<Partetecnicosgmao> findAllnoAsignadosMovilGmao(
			Partetecnicosgmao partetecnicosgmao, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDPARTEC IDPARTEC,t1.IDPARTE IDPARTE,t1.IDTECNICO IDTECNICO,t1.GUIDGMAO GUIDGMAO, t1.GUIDPLANO GUIDPLANO, t1.ESTADOGMAO ESTADOGMAO, t1.FECHAESTADO FECHAESTADO, t1.TIEMPOPAUSA TIEMPOPAUSA, t1.PAUSAAUTO PAUSAAUTO,t1.GUIDPADRE GUIDPADRE, t1.GUIDSEGUIDO GUIDSEGUIDO,t1.GUIDPDF GUIDPDF, t1.URGENTEAVISO URGENTEAVISO ");
		query.append("FROM PARTETECNICOSGMAO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(partetecnicosgmao);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ESTADOGMAO is null ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Partetecnicosgmao>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	@Transactional(readOnly = true)
	public List<Partetecnicosgmao> obtenerPartesUrgentesPendientes() {

		String urgente = "1";
		String estadogmao = "ASIG";
		String aceptada = "0";
		String urgenteAviso = "1";
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDPARTEC IDPARTEC,t1.IDPARTE IDPARTE,t1.IDTECNICO IDTECNICO,t1.GUIDGMAO GUIDGMAO, t1.GUIDPLANO GUIDPLANO, t1.ESTADOGMAO ESTADOGMAO, t1.FECHAESTADO FECHAESTADO, t1.TIEMPOPAUSA TIEMPOPAUSA, t1.PAUSAAUTO PAUSAAUTO,t1.GUIDPADRE GUIDPADRE, t1.GUIDSEGUIDO GUIDSEGUIDO,t1.GUIDPDF GUIDPDF, t1.URGENTEAVISO URGENTEAVISO ");
		query.append("FROM PARTETECNICOSGMAO t1, PARTES t2, PARTETECNICOS t3 ");
		query.append(" WHERE 1=1 AND t1.IDPARTE = t2.IDPARTE AND t1.IDPARTE = t3.IDPARTE AND t2.URGENTE = ? AND (t1.ESTADOGMAO is null OR t1.ESTADOGMAO = ?) AND (t3.ACEPTADA is null OR t3.ACEPTADA = ?) AND (t1.URGENTEAVISO is null OR t1.URGENTEAVISO !=?) ");

		return (List<Partetecnicosgmao>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, urgente, estadogmao, aceptada,
				urgenteAviso);

	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Partetecnicos entity
	 * 
	 * @param partetecnicos
	 *            Partetecnicos Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Partetecnicosgmao partetecnicosgmao) {

		StringBuilder where = new StringBuilder(
				PartetecnicosgmaoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (partetecnicosgmao != null
				&& partetecnicosgmao.getIdpartec() != null) {
			where.append(" AND t1.IDPARTEC = ?");
			params.add(partetecnicosgmao.getIdpartec());
		}
		if (partetecnicosgmao != null && partetecnicosgmao.getIdparte() != null) {
			where.append(" AND t1.IDPARTE = ?");
			params.add(partetecnicosgmao.getIdparte());
		}
		if (partetecnicosgmao != null
				&& partetecnicosgmao.getIdtecnico() != null) {
			where.append(" AND t1.IDTECNICO = ?");
			params.add(partetecnicosgmao.getIdtecnico());
		}
		if (partetecnicosgmao != null
				&& partetecnicosgmao.getGuidpartetecgmao() != null) {
			where.append(" AND t1.GUIDGMAO = ?");
			params.add(partetecnicosgmao.getGuidpartetecgmao());
		}

		if (partetecnicosgmao != null
				&& partetecnicosgmao.getGuidplanopartegmao() != null) {
			where.append(" AND t1.GUIDPLANO = ?");
			params.add(partetecnicosgmao.getGuidplanopartegmao());
		}

		if (partetecnicosgmao != null
				&& partetecnicosgmao.getFechaEstadoGmao() != null) {
			where.append(" AND t1.FECHAESTADO = ?");
			params.add(partetecnicosgmao.getFechaEstadoGmao());
		}

		if (partetecnicosgmao != null
				&& partetecnicosgmao.getEstadoGmao() != null) {
			where.append(" AND t1.ESTADOGMAO = ?");
			params.add(partetecnicosgmao.getEstadoGmao());
		}

		if (partetecnicosgmao != null
				&& partetecnicosgmao.getPausaAutoGmao() != null) {
			where.append(" AND t1.PAUSAAUTO = ?");
			params.add(partetecnicosgmao.getPausaAutoGmao());
		}

		if (partetecnicosgmao != null
				&& partetecnicosgmao.getGuidpartepadreayuda() != null) {
			where.append(" AND t1.GUIDPADRE = ?");
			params.add(partetecnicosgmao.getGuidpartepadreayuda());
		}

		if (partetecnicosgmao != null
				&& partetecnicosgmao.getGuidparteseguido() != null) {
			where.append(" AND t1.GUIDSEGUIDO = ?");
			params.add(partetecnicosgmao.getGuidparteseguido());
		}

		if (partetecnicosgmao != null
				&& partetecnicosgmao.getGuidpdfpartegmao() != null) {
			where.append(" AND t1.GUIDPDF = ?");
			params.add(partetecnicosgmao.getGuidpdfpartegmao());
		}

		if (partetecnicosgmao != null
				&& partetecnicosgmao.getUrgenteaviso() != null) {
			where.append(" AND t1.URGENTEAVISO = ?");
			params.add(partetecnicosgmao.getUrgenteaviso());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Removes a single row in the Partetecnicosgmao table.
	 * 
	 * @param partetecnicosgmao
	 *            Pagination
	 * @return
	 */
	public void remove(Partetecnicosgmao partetecnicosgmao) {
		String query = "DELETE FROM PARTETECNICOSGMAO WHERE IDPARTE=? AND GUIDGMAO=?";
		this.jdbcTemplate.update(query, partetecnicosgmao.getIdparte(),
				partetecnicosgmao.getGuidpartetecgmao());
	}

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

}