package com.ejie.aa20b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.Partetecnicos;
import com.ejie.aa20b.util.Aa20bConstantes;

/**
 * PartetecnicosDaoImpl generated by UDA, 22-dic-2014 10:11:52.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class PartetecnicosDaoImpl implements PartetecnicosDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Partetecnicos> rwMap = new RowMapper<Partetecnicos>() {
		public Partetecnicos mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Partetecnicos(resultSet.getInt("IDPARTEC"),
					resultSet.getInt("IDPARTE"),
					resultSet.getLong("IDTECNICO"), null,
					resultSet.getInt("TIEMPOREAL"),
					resultSet.getString("FINALIZADO"),
					resultSet.getString("OBSERVACIONES"),
					resultSet.getString("NOTAS_TEC"),
					resultSet.getString("ENVIOMAIL"),
					resultSet.getString("ACEPTADA"), null, null);
		}
	};
	private RowMapper<Partetecnicos> rwMap2 = new RowMapper<Partetecnicos>() {
		public Partetecnicos mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Partetecnicos(resultSet.getInt("IDPARTEC"),
					resultSet.getInt("IDPARTE"),
					resultSet.getLong("IDTECNICO"),
					resultSet.getString("NOMBRE"),
					resultSet.getInt("TIEMPOREAL"),
					resultSet.getString("FINALIZADO"),
					resultSet.getString("OBSERVACIONES"),
					resultSet.getString("NOTAS_TEC"),
					resultSet.getString("ENVIOMAIL"),
					resultSet.getString("ACEPTADA"),
					resultSet.getString("MOVILGMAO"),
					resultSet.getString("ESTADOGMAO"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Partetecnicos table.
	 * 
	 * @param partetecnicos
	 *            Pagination
	 * @return Partetecnicos
	 */
	public Partetecnicos add(Partetecnicos partetecnicos) {
		final Integer nextId = this.jdbcTemplate
				.queryForInt("SELECT TECPARTES_SEQ.NEXTVAL FROM DUAL");

		partetecnicos.setIdpartec(nextId);

		/* Si las notas técnicas ocupan más de 400 caracteres las recortamos */
		String notasTecnicas = "";
		if (partetecnicos.getNotasTec() != null
				&& partetecnicos.getNotasTec().length() > Aa20bConstantes.tamano_NOTAS_TECNICAS) {
			notasTecnicas = partetecnicos.getNotasTec().substring(0,
					(Aa20bConstantes.tamano_NOTAS_TECNICAS - 1));
		} else {
			notasTecnicas = partetecnicos.getNotasTec();
		}
		partetecnicos.setNotasTec(notasTecnicas);

		String query = "INSERT INTO PARTETECNICOS (IDPARTEC, IDPARTE, IDTECNICO, TIEMPOREAL, FINAL, OBSERVACIONES, NOTAS_TEC, ENVIO_MAIL, ACEPTADA) VALUES (?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(
				query,
				partetecnicos.getIdpartec(),
				partetecnicos.getIdparte(),
				partetecnicos.getIdtecnico(),
				partetecnicos.getTiemporeal(),
				partetecnicos.getFinalizado(),
				partetecnicos.getObservaciones(),
				partetecnicos.getNotasTec(),
				partetecnicos.getEnviomail() == null ? "0" : partetecnicos
						.getEnviomail(), partetecnicos.getAceptada());
		return partetecnicos;
	}

	/**
	 * Updates a single row in the Partetecnicos table.
	 * 
	 * @param partetecnicos
	 *            Pagination
	 * @return Partetecnicos
	 */
	public Partetecnicos update(Partetecnicos partetecnicos) {
		/* Si las notas técnicas ocupan más de 400 caracteres las recortamos */
		String notasTecnicas = "";
		if (partetecnicos.getNotasTec() != null
				&& partetecnicos.getNotasTec().length() > Aa20bConstantes.tamano_NOTAS_TECNICAS) {
			notasTecnicas = partetecnicos.getNotasTec().substring(0,
					(Aa20bConstantes.tamano_NOTAS_TECNICAS - 1));
		} else {
			notasTecnicas = partetecnicos.getNotasTec();
		}
		partetecnicos.setNotasTec(notasTecnicas);

		String query = "UPDATE PARTETECNICOS SET IDPARTE=?, IDTECNICO=?, TIEMPOREAL=?, FINAL=?, OBSERVACIONES=?, NOTAS_TEC=?, ENVIO_MAIL=?, ACEPTADA=?  WHERE IDPARTEC=?";
		this.jdbcTemplate.update(
				query,
				partetecnicos.getIdparte(),
				partetecnicos.getIdtecnico(),
				partetecnicos.getTiemporeal(),
				partetecnicos.getFinalizado(),
				partetecnicos.getObservaciones(),
				partetecnicos.getNotasTec(),
				partetecnicos.getEnviomail() == null ? "0" : partetecnicos
						.getEnviomail(), partetecnicos.getAceptada(),
				partetecnicos.getIdpartec());
		return partetecnicos;
	}

	/**
	 * Finalizar/Abrir parte tecnico.
	 * 
	 * @param partetecnicos
	 *            Pagination
	 * @return Partetecnicos
	 */
	public Partetecnicos finalizarParteTec(Partetecnicos partetecnicos) {
		String query = "UPDATE PARTETECNICOS SET FINAL=? WHERE IDPARTEC=?";

		// Si esta finalizado se abre. Si está abierto se finaliza.
		if (partetecnicos.getFinalizado().equals("1")) {
			partetecnicos.setFinalizado("0");
		} else {
			partetecnicos.setFinalizado("1");
		}

		this.jdbcTemplate.update(query, partetecnicos.getFinalizado(),
				partetecnicos.getIdpartec());
		return partetecnicos;
	}

	/**
	 * Updates a single row in the Partetecnicos table.
	 * 
	 * @param partetecnicos
	 *            Pagination
	 * @return Partetecnicos
	 */
	public Partetecnicos guardarNotas(Partetecnicos partetecnicos) {
		String query = "UPDATE PARTETECNICOS SET OBSERVACIONES=? WHERE IDPARTEC=?";
		this.jdbcTemplate.update(query, partetecnicos.getObservaciones(),
				partetecnicos.getIdpartec());
		return partetecnicos;
	}

	/**
	 * Updates a single row in the Partetecnicos table.
	 * 
	 * @param partetecnicos
	 *            Pagination
	 * @return Partetecnicos
	 */
	public Partetecnicos guardarNotasTecnico(Partetecnicos partetecnicos) {
		/* Si las notas técnicas ocupan más de 400 caracteres las recortamos */
		String notasTecnicas = "";
		if (partetecnicos.getNotasTec() != null
				&& partetecnicos.getNotasTec().length() > Aa20bConstantes.tamano_NOTAS_TECNICAS) {
			notasTecnicas = partetecnicos.getNotasTec().substring(0,
					(Aa20bConstantes.tamano_NOTAS_TECNICAS - 1));
		} else {
			notasTecnicas = partetecnicos.getNotasTec();
		}
		partetecnicos.setNotasTec(notasTecnicas);

		String query = "UPDATE PARTETECNICOS SET NOTAS_TEC=? WHERE IDPARTEC=?";
		this.jdbcTemplate.update(query, partetecnicos.getNotasTec(),
				partetecnicos.getIdpartec());
		return partetecnicos;
	}

	/**
	 * Finds a single row in the Partetecnicos table.
	 * 
	 * @param partetecnicos
	 *            Pagination
	 * @return Partetecnicos
	 */
	@Transactional(readOnly = true)
	public Partetecnicos find(Partetecnicos partetecnicos) {
		String query = "SELECT t1.IDPARTEC IDPARTEC, t1.IDPARTE IDPARTE, t1.IDTECNICO IDTECNICO, t1.TIEMPOREAL TIEMPOREAL, t1.FINAL FINALIZADO, t1.OBSERVACIONES OBSERVACIONES, t1.NOTAS_TEC NOTAS_TEC, t1.ENVIO_MAIL ENVIOMAIL, t1.ACEPTADA ACEPTADA  FROM PARTETECNICOS t1  WHERE t1.IDPARTEC = ?  ";

		List<Partetecnicos> partetecnicosList = this.jdbcTemplate.query(query,
				this.rwMap, partetecnicos.getIdpartec());
		return (Partetecnicos) DataAccessUtils.uniqueResult(partetecnicosList);
	}

	/**
	 * Removes a single row in the Partetecnicos table.
	 * 
	 * @param partetecnicos
	 *            Pagination
	 * @return
	 */
	public void remove(Partetecnicos partetecnicos) {
		String query = "DELETE FROM PARTETECNICOS WHERE IDPARTEC=?";
		this.jdbcTemplate.update(query, partetecnicos.getIdpartec());
	}

	/**
	 * Removes un tecnico asociado a un parte.
	 * 
	 * @param partetecnicos
	 *            Pagination
	 * @return
	 */
	public void eliminaTecnicoParte(Partetecnicos partetecnicos) {
		String query = "DELETE FROM PARTETECNICOS WHERE IDPARTE=? AND IDTECNICO=?";
		this.jdbcTemplate.update(query, partetecnicos.getIdparte(),
				partetecnicos.getIdtecnico());
	}

	/**
	 * Finds a List of rows in the Partetecnicos table.
	 * 
	 * @param partetecnicos
	 *            Partetecnicos
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Partetecnicos> findAll(Partetecnicos partetecnicos,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDPARTEC IDPARTEC,t1.IDPARTE IDPARTE,t1.IDTECNICO IDTECNICO,t1.TIEMPOREAL TIEMPOREAL,t1.FINAL FINALIZADO,t1.OBSERVACIONES OBSERVACIONES,t1.NOTAS_TEC NOTAS_TEC, t1.ENVIO_MAIL ENVIOMAIL, t1.ACEPTADA ACEPTADA ");
		query.append("FROM PARTETECNICOS t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(partetecnicos);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Partetecnicos>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Partetecnicos table.
	 * 
	 * @param partetecnicos
	 *            Partetecnicos
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Partetecnicos partetecnicos) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM PARTETECNICOS t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(partetecnicos);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds a List of rows in the Tecnicos table.
	 * 
	 * @param pagination
	 *            Pagination
	 * @param idParte
	 *            Integer
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Partetecnicos> tecnicosParteGrid(Pagination pagination,
			Integer idParte) {

		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDPARTEC IDPARTEC, t1.IDPARTE IDPARTE, t1.IDTECNICO IDTECNICO, t1.TIEMPOREAL TIEMPOREAL, t1.FINAL FINALIZADO, t1.OBSERVACIONES OBSERVACIONES, t1.NOTAS_TEC NOTAS_TEC, t1.ENVIO_MAIL ENVIOMAIL, t1.ACEPTADA ACEPTADA, t2.NOMBRE NOMBRE, t2.MOVILGMAO MOVILGMAO, t3.ESTADOGMAO ESTADOGMAO FROM PARTETECNICOS t1, TECNICOS t2, PARTETECNICOSGMAO t3 ");

		StringBuilder where = new StringBuilder(
				" WHERE t1.IDTECNICO=t2.IDTECNICO AND t1.IDPARTE = t3.IDPARTE(+) AND t1.IDTECNICO = t3.IDTECNICO(+) AND t1.IDPARTE=?");
		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Partetecnicos>) this.jdbcTemplate.query(query.toString(),
				this.rwMap2, idParte);
	}

	/**
	 * Counts rows in the Tecnicos table.
	 * 
	 * @param idParte
	 *            Integer
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long tecnicosParteGridCount(Integer idParte) {

		StringBuilder query = new StringBuilder(
				"SELECT  COUNT(1) FROM PARTETECNICOS t1, TECNICOS t2");

		StringBuilder where = new StringBuilder(
				" WHERE t1.IDTECNICO=t2.IDTECNICO AND t1.IDPARTE=?");
		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(), idParte);
	}

	/**
	 * Obtener tecnicos asociados a un parte.
	 * 
	 * @param idParte
	 *            Integer
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Partetecnicos> obtenerTecnicosParteAsociados(Integer idParte) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDPARTEC IDPARTEC, t1.IDPARTE IDPARTE, t1.IDTECNICO IDTECNICO, t1.TIEMPOREAL TIEMPOREAL, t1.FINAL FINALIZADO, t1.OBSERVACIONES OBSERVACIONES, t1.NOTAS_TEC NOTAS_TEC, t1.ENVIO_MAIL ENVIOMAIL,t1.ACEPTADA ACEPTADA, t2.NOMBRE NOMBRE, t2.MOVILGMAO MOVILGMAO, t3.ESTADOGMAO ESTADOGMAO FROM PARTETECNICOS t1, TECNICOS t2, PARTETECNICOSGMAO t3 ");

		StringBuilder where = new StringBuilder(
				" WHERE t1.IDTECNICO=t2.IDTECNICO AND t1.IDPARTE = t3.IDPARTE(+) AND t1.IDTECNICO = t3.IDTECNICO(+) AND t1.IDPARTE=?");
		query.append(where);
		query.append(" ORDER BY t2.NOMBRE ");

		return (List<Partetecnicos>) this.jdbcTemplate.query(query.toString(),
				this.rwMap2, idParte);
	}

	/**
	 * Sumar el tiempo real de ejecucion de un parte
	 * 
	 * @param idParte
	 *            Integer
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Integer obtenerTiempoEjecucion(Integer idParte) {
		StringBuilder query = new StringBuilder(
				"SELECT  SUM(t1.TIEMPOREAL) TIEMPOREAL FROM PARTETECNICOS t1");

		StringBuilder where = new StringBuilder(" WHERE t1.IDPARTE=?");
		query.append(where);

		return this.jdbcTemplate.queryForInt(query.toString(), idParte);
	}

	/**
	 * Finds rows in the Partetecnicos table using like.
	 * 
	 * @param partetecnicos
	 *            Partetecnicos
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Partetecnicos> findAllLike(Partetecnicos partetecnicos,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDPARTEC IDPARTEC,t1.IDPARTE IDPARTE,t1.IDTECNICO IDTECNICO,t1.TIEMPOREAL TIEMPOREAL,t1.FINAL FINALIZADO,t1.OBSERVACIONES OBSERVACIONES,t1.NOTAS_TEC NOTAS_TEC, t1.ENVIO_MAIL ENVIOMAIL,t1.ACEPTADA ACEPTADA ");
		query.append("FROM PARTETECNICOS t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(partetecnicos,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Partetecnicos>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Partetecnicos table using like.
	 * 
	 * @param partetecnicos
	 *            Partetecnicos
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Partetecnicos partetecnicos, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM PARTETECNICOS t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(partetecnicos,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Updates a single row in the Partes table.
	 * 
	 * @param idParte
	 *            Integer
	 * @param idTecnico
	 *            Long
	 * @return
	 */
	public void marcarEnvioMail(Integer idParte, Long idTecnico) {
		String query = "UPDATE PARTETECNICOS SET ENVIO_MAIL='1' WHERE IDPARTE=? AND IDTECNICO=?";
		this.jdbcTemplate.update(query, idParte, idTecnico);
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Partetecnicos entity
	 * 
	 * @param partetecnicos
	 *            Partetecnicos Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Partetecnicos partetecnicos) {

		StringBuilder where = new StringBuilder(
				PartetecnicosDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (partetecnicos != null && partetecnicos.getIdpartec() != null) {
			where.append(" AND t1.IDPARTEC = ?");
			params.add(partetecnicos.getIdpartec());
		}
		if (partetecnicos != null && partetecnicos.getIdparte() != null) {
			where.append(" AND t1.IDPARTE = ?");
			params.add(partetecnicos.getIdparte());
		}
		if (partetecnicos != null && partetecnicos.getIdtecnico() != null) {
			where.append(" AND t1.IDTECNICO = ?");
			params.add(partetecnicos.getIdtecnico());
		}
		if (partetecnicos != null && partetecnicos.getTiemporeal() != null) {
			where.append(" AND t1.TIEMPOREAL = ?");
			params.add(partetecnicos.getTiemporeal());
		}
		if (partetecnicos != null && partetecnicos.getFinalizado() != null) {
			where.append(" AND t1.FINAL = ?");
			params.add(partetecnicos.getFinalizado());
		}
		if (partetecnicos != null && partetecnicos.getObservaciones() != null) {
			where.append(" AND t1.OBSERVACIONES = ?");
			params.add(partetecnicos.getObservaciones());
		}
		if (partetecnicos != null && partetecnicos.getNotasTec() != null) {
			where.append(" AND t1.NOTAS_TEC = ?");
			params.add(partetecnicos.getNotasTec());
		}
		if (partetecnicos != null && partetecnicos.getEnviomail() != null) {
			where.append(" AND t1.ENVIO_MAIL = ?");
			params.add(partetecnicos.getEnviomail());
		}
		if (partetecnicos != null && partetecnicos.getAceptada() != null) {
			where.append(" AND t1.ACEPTADA = ?");
			params.add(partetecnicos.getAceptada());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Partetecnicos entity
	 * 
	 * @param partetecnicos
	 *            Partetecnicos Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Partetecnicos partetecnicos,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				PartetecnicosDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (partetecnicos != null && partetecnicos.getIdpartec() != null) {
			where.append(" AND t1.IDPARTEC = ?");
			params.add(partetecnicos.getIdpartec());
		}
		if (partetecnicos != null && partetecnicos.getIdparte() != null) {
			where.append(" AND t1.IDPARTE = ?");
			params.add(partetecnicos.getIdparte());
		}
		if (partetecnicos != null && partetecnicos.getIdtecnico() != null) {
			where.append(" AND t1.IDTECNICO = ?");
			params.add(partetecnicos.getIdtecnico());
		}
		if (partetecnicos != null && partetecnicos.getTiemporeal() != null) {
			where.append(" AND t1.TIEMPOREAL = ?");
			params.add(partetecnicos.getTiemporeal());
		}
		if (partetecnicos != null && partetecnicos.getFinalizado() != null) {
			where.append(" AND UPPER(t1.FINAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(partetecnicos.getFinalizado().toUpperCase() + "%");
			} else {
				params.add("%" + partetecnicos.getFinalizado().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.FINAL IS NOT NULL");
		}
		if (partetecnicos != null && partetecnicos.getObservaciones() != null) {
			where.append(" AND UPPER(t1.OBSERVACIONES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(partetecnicos.getObservaciones().toUpperCase() + "%");
			} else {
				params.add("%" + partetecnicos.getObservaciones().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.OBSERVACIONES IS NOT NULL");
		}
		if (partetecnicos != null && partetecnicos.getNotasTec() != null) {
			where.append(" AND UPPER(t1.NOTAS_TEC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(partetecnicos.getNotasTec().toUpperCase() + "%");
			} else {
				params.add("%" + partetecnicos.getNotasTec().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NOTAS_TEC IS NOT NULL");
		}
		if (partetecnicos != null && partetecnicos.getEnviomail() != null) {
			where.append(" AND UPPER(t1.ENVIO_MAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(partetecnicos.getEnviomail().toUpperCase() + "%");
			} else {
				params.add("%" + partetecnicos.getEnviomail().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ENVIO_MAIL IS NOT NULL");
		}

		if (partetecnicos != null && partetecnicos.getAceptada() != null) {
			where.append(" AND UPPER(t1.ACEPTADA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(partetecnicos.getAceptada().toUpperCase() + "%");
			} else {
				params.add("%" + partetecnicos.getAceptada().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ACEPTADA IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
