package com.ejie.aa20b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.aa20b.model.Partetecnicos;

/**
 * PartetecnicosDao generated by UDA, 22-dic-2014 10:11:52.
 * 
 * @author UDA
 */

public interface PartetecnicosDao {

	/**
	 * Inserts a single row in the Partetecnicos table.
	 * 
	 * @param partetecnicos
	 *            Partetecnicos
	 * @return Partetecnicos
	 */
	Partetecnicos add(Partetecnicos partetecnicos);

	/**
	 * Updates a single row in the Partetecnicos table.
	 * 
	 * @param partetecnicos
	 *            Partetecnicos
	 * @return Partetecnicos
	 */
	Partetecnicos update(Partetecnicos partetecnicos);

	/**
	 * Finalizar/Abrir parte tecnico.
	 * 
	 * @param partetecnicos
	 *            Partetecnicos
	 * @return Partetecnicos
	 */
	Partetecnicos finalizarParteTec(Partetecnicos partetecnicos);

	/**
	 * Updates a single row in the Partetecnicos table.
	 * 
	 * @param partetecnicos
	 *            Partetecnicos
	 * @return Partetecnicos
	 */
	Partetecnicos guardarNotas(Partetecnicos partetecnicos);

	/**
	 * Updates a single row in the Partetecnicos table.
	 * 
	 * @param partetecnicos
	 *            Partetecnicos
	 * @return Partetecnicos
	 */
	Partetecnicos guardarNotasTecnico(Partetecnicos partetecnicos);

	/**
	 * Finds a single row in the Partetecnicos table.
	 * 
	 * @param partetecnicos
	 *            Partetecnicos
	 * @return Partetecnicos
	 */
	Partetecnicos find(Partetecnicos partetecnicos);

	/**
	 * Deletes a single row in the Partetecnicos table.
	 * 
	 * @param partetecnicos
	 *            Partetecnicos
	 * @return
	 */
	void remove(Partetecnicos partetecnicos);

	/**
	 * Removes un tecnico asociado a un parte.
	 * 
	 * @param partetecnicos
	 *            Pagination
	 * @return
	 */
	void eliminaTecnicoParte(Partetecnicos partetecnicos);

	/**
	 * Finds a List of rows in the Partetecnicos table.
	 * 
	 * @param partetecnicos
	 *            Partetecnicos
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Partetecnicos> findAll(Partetecnicos partetecnicos,
			Pagination pagination);

	/**
	 * Counts rows in the Partetecnicos table.
	 * 
	 * @param partetecnicos
	 *            Partetecnicos
	 * @return Long
	 */
	Long findAllCount(Partetecnicos partetecnicos);

	/**
	 * Counts rows in the Tecnicos table.
	 * 
	 * @param idParte
	 *            Integer
	 * @return Long
	 */
	Long tecnicosParteGridCount(Integer idParte);

	/**
	 * Finds a List of rows in the Tecnicos table.
	 * 
	 * @param pagination
	 *            Pagination
	 * @param idParte
	 *            Integer
	 * @return List
	 */

	/**
	 * Obtener tecnicos asociados a un parte.
	 * 
	 * @param idParte
	 *            Integer
	 * @return List
	 */
	List<Partetecnicos> obtenerTecnicosParteAsociados(Integer idParte);

	List<Partetecnicos> tecnicosParteGrid(Pagination pagination, Integer idParte);

	/**
	 * Finds rows in the Partetecnicos table using like.
	 * 
	 * @param partetecnicos
	 *            Partetecnicos
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Partetecnicos> findAllLike(Partetecnicos partetecnicos,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Partetecnicos table using like.
	 * 
	 * @param partetecnicos
	 *            Partetecnicos
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Partetecnicos partetecnicos, Boolean startsWith);

	/**
	 * Sumar el tiempo real de ejecucion de un parte
	 * 
	 * @param idParte
	 *            Integer
	 * @return Long
	 */
	Integer obtenerTiempoEjecucion(Integer idParte);

	/**
	 * Updates a single row in the Partetecnicos table.
	 * 
	 * @param idParte
	 *            integer
	 * @param idTecnico
	 *            Long
	 * @return
	 */
	void marcarEnvioMail(Integer idParte, Long idTecnico);
}
