package com.ejie.aa20b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.Agenda;
import com.ejie.aa20b.model.Clase;
import com.ejie.aa20b.model.Codigo;
import com.ejie.aa20b.model.Departamentos;
import com.ejie.aa20b.model.Direcciones;
import com.ejie.aa20b.model.Edificios;
import com.ejie.aa20b.model.Espacio;
import com.ejie.aa20b.model.Maquinas;
import com.ejie.aa20b.model.Partes;
import com.ejie.aa20b.model.Plantas;
import com.ejie.aa20b.model.TablaInformes;
import com.ejie.aa20b.model.Tecnicos;
import com.ejie.aa20b.model.Zonas;

/**
 * PartesDaoImpl generated by UDA, 28-nov-2014 11:59:04.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class PartesDaoImpl implements PartesDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Partes> rwMap = new RowMapper<Partes>() {
		public Partes mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Partes parte = new Partes();

			parte.setIdparte(resultSet.getInt("IDPARTE"));
			parte.setFechare(resultSet.getTimestamp("FECHARE"));
			parte.setNombre(resultSet.getString("NOMBRE"));
			parte.setTelefo(resultSet.getString("TELEFO"));
			parte.setMail(resultSet.getString("MAIL"));
			parte.setIddepar(resultSet.getLong("IDDEPAR"));

			parte.setIddir(resultSet.getInt("IDDIR"));

			parte.setIdedificio(resultSet.getString("IDEDIFICIO"));

			parte.setIdzona(resultSet.getInt("IDZONA"));
			parte.setIdplanta(resultSet.getInt("IDPLANTA"));
			parte.setIntExt(resultSet.getString("INTEXT"));
			parte.setIdespacio(resultSet.getLong("IDESPACIO"));
			parte.setIdclase(resultSet.getInt("IDCLASE"));
			parte.setIdcodigo(resultSet.getInt("IDCODIGO"));
			parte.setObserv(resultSet.getString("OBSERV"));
			parte.setIdactuac(resultSet.getInt("IDACTUAC"));
			parte.setIdmaquina(resultSet.getLong("IDMAQUINA"));
			parte.setEjecutado(resultSet.getString("EJECUTADO"));
			parte.setFechaej(resultSet.getDate("FECHAEJ"));
			parte.setTiempoReal(resultSet.getInt("TIEMPOREAL"));
			parte.setUidPersona(resultSet.getString("UIDPER"));
			parte.setAveriaRepe(resultSet.getInt("AVERIAREPE"));
			parte.setVip(resultSet.getString("VIP"));
			parte.setUrgente(resultSet.getString("URGENTE"));
			parte.setEnviomail(resultSet.getString("ENVIOMAIL"));
			parte.setGuidparte(resultSet.getString("GUIDPARTE"));
			parte.setAutomatica(resultSet.getString("AUTOMATICA"));
			parte.setFechaplanif(resultSet.getTimestamp("FECHAPLANIF"));
			parte.setNoProcede(resultSet.getString("NOPROCEDE"));
			parte.setObservNoProcede(resultSet.getString("NOPROCEDE_OBSERV"));
			return parte;
		}
	};

	private RowMapper<TablaInformes> rwMapTablaInformes = new RowMapper<TablaInformes>() {
		public TablaInformes mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			TablaInformes tablaInformes = new TablaInformes();

			tablaInformes.setIdparte(resultSet.getInt("IDPARTE"));
			tablaInformes.setNombre(resultSet.getString("TECNICOS"));
			tablaInformes.setFecre(resultSet.getDate("FECHARE"));
			tablaInformes.setFeejec(resultSet.getDate("FECHAEJ"));

			tablaInformes.setCclase(resultSet.getString("CCLASE"));
			tablaInformes.setEclase(resultSet.getString("ECLASE"));
			tablaInformes.setCcodigo(resultSet.getString("CCODIGO"));
			tablaInformes.setEcodigo(resultSet.getString("ECODIGO"));
			tablaInformes.setObservaciones(resultSet.getString("OBSERV"));

			return tablaInformes;
		}
	};

	private RowMapper<Partes> rwMapParteZonaTecnico = new RowMapper<Partes>() {
		public Partes mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Partes parte = new Partes();

			parte.setIdparte(resultSet.getInt("IDPARTE"));
			Zonas zona = new Zonas();
			zona.setCzona(resultSet.getString("CZONA") == null ? "" : resultSet
					.getString("CZONA"));
			zona.setEzona(resultSet.getString("EZONA") == null ? "" : resultSet
					.getString("EZONA"));
			parte.setZona(zona);

			return parte;
		}
	};

	private RowMapper<TablaInformes> rwMapListadoCorrectivos = new RowMapper<TablaInformes>() {
		public TablaInformes mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			TablaInformes tablaInformes = new TablaInformes();

			tablaInformes.setIdparte(resultSet.getInt("IDPARTE"));
			tablaInformes.setTecnico(resultSet.getString("TECNICOS"));
			tablaInformes.setFecre(resultSet.getDate("FECHARE"));
			tablaInformes.setFeejec(resultSet.getTimestamp("FECHAEJMAX"));
			tablaInformes.setNombre(resultSet.getString("NOMBRE"));
			tablaInformes.setTelefono(resultSet.getString("TELEFO"));

			tablaInformes.setCclase(resultSet.getString("CCLASE"));
			tablaInformes.setEclase(resultSet.getString("ECLASE"));
			tablaInformes.setCcodigo(resultSet.getString("CCODIGO"));
			tablaInformes.setEcodigo(resultSet.getString("ECODIGO"));
			tablaInformes.setCedificio(resultSet.getString("CEDIFICIO"));
			tablaInformes.setEedificio(resultSet.getString("EEDIFICIO"));
			tablaInformes.setCzona(resultSet.getString("CZONA"));
			tablaInformes.setEzona(resultSet.getString("EZONA"));
			tablaInformes.setCplanta(resultSet.getString("CPLANTA"));
			tablaInformes.setEplanta(resultSet.getString("EPLANTA"));
			tablaInformes.setCdepar(resultSet.getString("CDEPAR"));
			tablaInformes.setEdepar(resultSet.getString("EDEPAR"));
			tablaInformes.setCdir(resultSet.getString("CDIR"));
			tablaInformes.setEdir(resultSet.getString("EDIR"));
			tablaInformes.setObservaciones(resultSet.getString("OBSERV"));
			tablaInformes.setTiemporeal(resultSet.getLong("TIEMPOREAL"));

			return tablaInformes;
		}
	};

	private RowMapper<TablaInformes> rwMapListadoEjecTecnico = new RowMapper<TablaInformes>() {
		public TablaInformes mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			TablaInformes tablaInformes = new TablaInformes();

			tablaInformes.setIdparte(resultSet.getInt("IDPARTE"));
			tablaInformes.setTecnico(resultSet.getString("TECNICOS"));
			tablaInformes.setFecre(resultSet.getDate("FECHARE"));
			tablaInformes.setFeejec(resultSet.getTimestamp("FECHAEJMAX"));
			tablaInformes.setCcodigo(resultSet.getString("CCODIGO"));
			tablaInformes.setEcodigo(resultSet.getString("ECODIGO"));
			tablaInformes.setTiemporeal(resultSet.getLong("TIEMPOREAL"));
			tablaInformes.setEjecutado(resultSet.getString("FINALIZADO"));

			return tablaInformes;
		}
	};
	private RowMapper<Partes> rwMapFechaEjec = new RowMapper<Partes>() {
		public Partes mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Partes parte = new Partes();

			parte.setFechaej(resultSet.getTimestamp("FEFINMAX"));

			parte.setIdparte(null);
			parte.setFechare(null);
			parte.setNombre(null);
			parte.setTelefo(null);
			parte.setMail(null);
			parte.setIddepar(null);

			parte.setIddir(null);

			parte.setIdedificio(null);

			parte.setIdzona(null);
			parte.setIdplanta(null);
			parte.setIntExt(null);
			parte.setIdespacio(null);
			parte.setIdclase(null);
			parte.setIdcodigo(null);
			parte.setObserv(null);
			parte.setIdactuac(null);
			parte.setIdmaquina(null);
			parte.setEjecutado(null);
			parte.setTiempoReal(null);
			parte.setUidPersona(null);
			parte.setAveriaRepe(null);
			return parte;

		}
	};

	private RowMapper<Partes> rwMapObtenerParteEditar = new RowMapper<Partes>() {
		public Partes mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Partes parte = new Partes();

			parte.setIdparte(resultSet.getInt("IDPARTE"));
			parte.setFechare(resultSet.getTimestamp("FECHARE"));
			parte.setNombre(resultSet.getString("NOMBRE"));
			parte.setTelefo(resultSet.getString("TELEFO"));
			parte.setMail(resultSet.getString("MAIL"));
			parte.setIddepar(resultSet.getLong("IDDEPAR"));
			Departamentos departamento = new Departamentos();
			departamento.setCidepar(resultSet.getString("IDDEPAR"));
			departamento.setCdepar(resultSet.getString("CDEPAR"));
			departamento.setEdepar(resultSet.getString("EDEPAR"));
			parte.setDepartamento(departamento);

			parte.setIddir(resultSet.getInt("IDDIR"));
			Direcciones direccion = new Direcciones();
			direccion.setCidir(resultSet.getString("IDDIR"));
			direccion.setCdir(resultSet.getString("CDIR"));
			direccion.setEdir(resultSet.getString("EDIR"));
			direccion.setIddepar(resultSet.getLong("IDDEPAR"));
			direccion.setCodestrUs(resultSet.getString("CODESTR_US"));
			parte.setDireccion(direccion);

			parte.setIdedificio(resultSet.getString("IDEDIFICIO"));
			Edificios edificio = new Edificios();
			edificio.setIdedificio(resultSet.getString("IDEDIFICIO"));
			edificio.setCedificio(resultSet.getString("CEDIFICIO") == null ? ""
					: resultSet.getString("CEDIFICIO"));
			edificio.setEedificio(resultSet.getString("EEDIFICIO") == null ? ""
					: resultSet.getString("EEDIFICIO"));
			parte.setEdificio(edificio);

			parte.setIdzona(resultSet.getInt("IDZONA"));
			Zonas zona = new Zonas();
			zona.setIdzona(resultSet.getInt("IDZONA"));
			zona.setCzona(resultSet.getString("CZONA") == null ? "" : resultSet
					.getString("CZONA"));
			zona.setEzona(resultSet.getString("EZONA") == null ? "" : resultSet
					.getString("EZONA"));
			parte.setZona(zona);

			parte.setIdplanta(resultSet.getInt("IDPLANTA"));
			Plantas planta = new Plantas();
			planta.setIdplanta(resultSet.getInt("IDPLANTA"));
			planta.setCplanta(resultSet.getString("CPLANTA") == null ? ""
					: resultSet.getString("CPLANTA"));
			planta.setEplanta(resultSet.getString("EPLANTA") == null ? ""
					: resultSet.getString("EPLANTA"));
			parte.setPlanta(planta);

			parte.setIntExt(resultSet.getString("INTEXT"));
			parte.setIdespacio(resultSet.getLong("IDESPACIO"));
			Espacio espacio = new Espacio();
			espacio.setIdespacio(resultSet.getLong("IDESPACIO"));
			espacio.setCespacio(resultSet.getString("CESPACIO") == null ? ""
					: resultSet.getString("CESPACIO"));
			espacio.setEespacio(resultSet.getString("EESPACIO") == null ? ""
					: resultSet.getString("EESPACIO"));
			parte.setEspacio(espacio);

			parte.setIdclase(resultSet.getInt("IDCLASE"));
			Clase clase = new Clase();
			clase.setIdclase(resultSet.getInt("IDCLASE"));
			clase.setCclase(resultSet.getString("CCLASE") == null ? ""
					: resultSet.getString("CCLASE"));
			clase.setEclase(resultSet.getString("ECLASE") == null ? ""
					: resultSet.getString("ECLASE"));
			parte.setClase(clase);

			parte.setIdcodigo(resultSet.getInt("IDCODIGO"));
			Codigo codigo = new Codigo();
			codigo.setIdcodigo(resultSet.getInt("IDCODIGO"));
			codigo.setCcodigo(resultSet.getString("CCODIGO") == null ? ""
					: resultSet.getString("CCODIGO"));
			codigo.setEcodigo(resultSet.getString("ECODIGO") == null ? ""
					: resultSet.getString("ECODIGO"));
			parte.setCodigo(codigo);

			parte.setObserv(resultSet.getString("OBSERV"));
			parte.setIdactuac(resultSet.getInt("IDACTUAC"));
			parte.setOperacion(resultSet.getString("OPERACION"));
			parte.setIdmaquina(resultSet.getLong("IDMAQUINA"));
			Maquinas maquina = new Maquinas();
			maquina.setCmaquina(resultSet.getString("CMAQUINA"));
			maquina.setEmaquina(resultSet.getString("EMAQUINA"));
			parte.setMaquina(maquina);

			parte.setEjecutado(resultSet.getString("EJECUTADO"));
			parte.setFechaej(resultSet.getTimestamp("FECHAEJ"));
			parte.setTiempoReal(resultSet.getInt("TIEMPOREAL"));
			parte.setUidPersona(resultSet.getString("UIDPER"));
			parte.setAveriaRepe(resultSet.getInt("AVERIAREPE"));
			if (resultSet.wasNull())
				parte.setAveriaRepe(null);
			parte.setVip(resultSet.getString("VIP"));
			parte.setUrgente(resultSet.getString("URGENTE"));
			parte.setEnviomail(resultSet.getString("ENVIOMAIL"));

			parte.setFechaplanif(resultSet.getTimestamp("FECHAPLANIF"));
			parte.setNoProcede(resultSet.getString("NOPROCEDE"));
			parte.setObservNoProcede(resultSet.getString("NOPROCEDE_OBSERV"));

			return parte;
		}
	};

	private RowMapper<Partes> rwMapObtenerParte = new RowMapper<Partes>() {
		public Partes mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Partes parte = new Partes();

			parte.setIdparte(resultSet.getInt("IDPARTE"));
			parte.setFechare(resultSet.getTimestamp("FECHARE"));
			parte.setNombre(resultSet.getString("NOMBRE"));
			parte.setTelefo(resultSet.getString("TELEFO"));
			parte.setMail(resultSet.getString("MAIL"));
			parte.setIddepar(resultSet.getLong("IDDEPAR"));
			Departamentos departamento = new Departamentos();
			departamento.setCidepar(resultSet.getString("IDDEPAR"));
			departamento.setCdepar(resultSet.getString("CDEPAR"));
			departamento.setEdepar(resultSet.getString("EDEPAR"));
			parte.setDepartamento(departamento);

			parte.setIddir(resultSet.getInt("IDDIR"));
			Direcciones direccion = new Direcciones();
			direccion.setCidir(resultSet.getString("IDDIR"));
			direccion.setCdir(resultSet.getString("CDIR"));
			direccion.setEdir(resultSet.getString("EDIR"));
			direccion.setIddepar(resultSet.getLong("IDDEPAR"));
			direccion.setCodestrUs(resultSet.getString("CODESTR_US"));
			parte.setDireccion(direccion);

			parte.setIdedificio(resultSet.getString("IDEDIFICIO"));
			Edificios edificio = new Edificios();
			edificio.setIdedificio(resultSet.getString("IDEDIFICIO"));
			edificio.setCedificio(resultSet.getString("CEDIFICIO") == null ? ""
					: resultSet.getString("CEDIFICIO"));
			edificio.setEedificio(resultSet.getString("EEDIFICIO") == null ? ""
					: resultSet.getString("EEDIFICIO"));
			parte.setEdificio(edificio);

			parte.setIdzona(resultSet.getInt("IDZONA"));
			Zonas zona = new Zonas();
			zona.setIdzona(resultSet.getInt("IDZONA"));
			zona.setCzona(resultSet.getString("CZONA") == null ? "" : resultSet
					.getString("CZONA"));
			zona.setEzona(resultSet.getString("EZONA") == null ? "" : resultSet
					.getString("EZONA"));
			parte.setZona(zona);

			parte.setIdplanta(resultSet.getInt("IDPLANTA"));
			Plantas planta = new Plantas();
			planta.setIdplanta(resultSet.getInt("IDPLANTA"));
			planta.setCplanta(resultSet.getString("CPLANTA") == null ? ""
					: resultSet.getString("CPLANTA"));
			planta.setEplanta(resultSet.getString("EPLANTA") == null ? ""
					: resultSet.getString("EPLANTA"));
			parte.setPlanta(planta);

			parte.setIntExt(resultSet.getString("INTEXT"));
			parte.setIdespacio(resultSet.getLong("IDESPACIO"));
			Espacio espacio = new Espacio();
			espacio.setIdespacio(resultSet.getLong("IDESPACIO"));
			espacio.setCespacio(resultSet.getString("CESPACIO") == null ? ""
					: resultSet.getString("CESPACIO"));
			espacio.setEespacio(resultSet.getString("EESPACIO") == null ? ""
					: resultSet.getString("EESPACIO"));
			parte.setEspacio(espacio);

			parte.setIdclase(resultSet.getInt("IDCLASE"));
			Clase clase = new Clase();
			clase.setIdclase(resultSet.getInt("IDCLASE"));
			clase.setCclase(resultSet.getString("CCLASE") == null ? ""
					: resultSet.getString("CCLASE"));
			clase.setEclase(resultSet.getString("ECLASE") == null ? ""
					: resultSet.getString("ECLASE"));
			parte.setClase(clase);

			parte.setIdcodigo(resultSet.getInt("IDCODIGO"));
			Codigo codigo = new Codigo();
			codigo.setIdcodigo(resultSet.getInt("IDCODIGO"));
			codigo.setCcodigo(resultSet.getString("CCODIGO") == null ? ""
					: resultSet.getString("CCODIGO"));
			codigo.setEcodigo(resultSet.getString("ECODIGO") == null ? ""
					: resultSet.getString("ECODIGO"));
			parte.setCodigo(codigo);

			parte.setObserv(resultSet.getString("OBSERV"));
			parte.setIdactuac(resultSet.getInt("IDACTUAC"));
			parte.setIdmaquina(resultSet.getLong("IDMAQUINA"));
			parte.setEjecutado(resultSet.getString("EJECUTADO"));
			parte.setFechaej(resultSet.getDate("FECHAEJ"));
			parte.setTiempoReal(resultSet.getInt("TIEMPOREAL"));
			parte.setUidPersona(resultSet.getString("UIDPER"));
			if (resultSet.wasNull())
				parte.setAveriaRepe(null);
			parte.setVip(resultSet.getString("VIP"));
			parte.setUrgente(resultSet.getString("URGENTE"));
			parte.setEnviomail(resultSet.getString("ENVIOMAIL"));
			parte.setFechaplanif(resultSet.getTimestamp("FECHAPLANIF"));
			parte.setNoProcede(resultSet.getString("NOPROCEDE"));
			parte.setObservNoProcede(resultSet.getString("NOPROCEDE_OBSERV"));
			return parte;
		}
	};

	private RowMapper<Partes> rwMapObtenerParteGrid = new RowMapper<Partes>() {
		public Partes mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Partes parte = new Partes();

			parte.setIdparte(resultSet.getInt("IDPARTE"));
			parte.setFechare(resultSet.getTimestamp("FECHARE"));
			parte.setNombre(resultSet.getString("NOMBRE"));
			parte.setIddepar(resultSet.getLong("IDDEPAR"));
			Departamentos departamento = new Departamentos();
			departamento.setCidepar(resultSet.getString("IDDEPAR"));
			departamento.setCdepar(resultSet.getString("CDEPAR"));
			departamento.setEdepar(resultSet.getString("EDEPAR"));
			parte.setDepartamento(departamento);

			parte.setIddir(resultSet.getInt("IDDIR"));
			Direcciones direccion = new Direcciones();
			direccion.setCidir(resultSet.getString("IDDIR"));
			direccion.setCdir(resultSet.getString("CDIR"));
			direccion.setEdir(resultSet.getString("EDIR"));
			direccion.setIddepar(resultSet.getLong("IDDEPAR"));
			direccion.setCodestrUs(resultSet.getString("CODESTR_US"));
			parte.setDireccion(direccion);

			parte.setIdedificio(resultSet.getString("IDEDIFICIO"));
			Edificios edificio = new Edificios();
			edificio.setIdedificio(resultSet.getString("IDEDIFICIO"));
			edificio.setCedificio(resultSet.getString("CEDIFICIO") == null ? ""
					: resultSet.getString("CEDIFICIO"));
			edificio.setEedificio(resultSet.getString("EEDIFICIO") == null ? ""
					: resultSet.getString("EEDIFICIO"));
			parte.setEdificio(edificio);

			parte.setIdzona(resultSet.getInt("IDZONA"));
			Zonas zona = new Zonas();
			zona.setIdzona(resultSet.getInt("IDZONA"));
			zona.setCzona(resultSet.getString("CZONA") == null ? "" : resultSet
					.getString("CZONA"));
			zona.setEzona(resultSet.getString("EZONA") == null ? "" : resultSet
					.getString("EZONA"));
			parte.setZona(zona);

			parte.setIdplanta(resultSet.getInt("IDPLANTA"));
			Plantas planta = new Plantas();
			planta.setIdplanta(resultSet.getInt("IDPLANTA"));
			planta.setCplanta(resultSet.getString("CPLANTA") == null ? ""
					: resultSet.getString("CPLANTA"));
			planta.setEplanta(resultSet.getString("EPLANTA") == null ? ""
					: resultSet.getString("EPLANTA"));
			parte.setPlanta(planta);

			parte.setIntExt(resultSet.getString("INTEXT"));
			parte.setIdespacio(resultSet.getLong("IDESPACIO"));
			Espacio espacio = new Espacio();
			espacio.setIdespacio(resultSet.getLong("IDESPACIO"));
			espacio.setCespacio(resultSet.getString("CESPACIO") == null ? ""
					: resultSet.getString("CESPACIO"));
			espacio.setEespacio(resultSet.getString("EESPACIO") == null ? ""
					: resultSet.getString("EESPACIO"));
			parte.setEspacio(espacio);

			parte.setIdclase(resultSet.getInt("IDCLASE"));
			Clase clase = new Clase();
			clase.setIdclase(resultSet.getInt("IDCLASE"));
			clase.setCclase(resultSet.getString("CCLASE") == null ? ""
					: resultSet.getString("CCLASE"));
			clase.setEclase(resultSet.getString("ECLASE") == null ? ""
					: resultSet.getString("ECLASE"));
			parte.setClase(clase);

			parte.setIdcodigo(resultSet.getInt("IDCODIGO"));
			Codigo codigo = new Codigo();
			codigo.setIdcodigo(resultSet.getInt("IDCODIGO"));
			codigo.setCcodigo(resultSet.getString("CCODIGO") == null ? ""
					: resultSet.getString("CCODIGO"));
			codigo.setEcodigo(resultSet.getString("ECODIGO") == null ? ""
					: resultSet.getString("ECODIGO"));
			parte.setCodigo(codigo);

			parte.setObserv(resultSet.getString("OBSERV"));
			parte.setIdactuac(resultSet.getInt("IDACTUAC"));
			parte.setAveriaRepe(resultSet.getInt("AVERIAREPE"));
			parte.setVip(resultSet.getString("VIP"));
			parte.setUrgente(resultSet.getString("URGENTE"));
			parte.setEnviomail(resultSet.getString("ENVIOMAIL"));
			parte.setFechaplanif(resultSet.getTimestamp("FECHAPLANIF"));

			return parte;
		}
	};

	private RowMapper<Partes> rwMapObtenerListCorrGrid = new RowMapper<Partes>() {
		public Partes mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Partes parte = new Partes();

			parte.setIdparte(resultSet.getInt("IDPARTE"));
			parte.setFechare(resultSet.getTimestamp("FECHARE"));
			parte.setNombre(resultSet.getString("NOMBRE"));
			parte.setTecnicos(resultSet.getString("TECNICOS"));
			parte.setIddepar(resultSet.getLong("IDDEPAR"));
			Departamentos departamento = new Departamentos();
			departamento.setCidepar(resultSet.getString("IDDEPAR"));
			departamento.setCdepar(resultSet.getString("CDEPAR"));
			departamento.setEdepar(resultSet.getString("EDEPAR"));
			parte.setDepartamento(departamento);

			parte.setIddir(resultSet.getInt("IDDIR"));
			Direcciones direccion = new Direcciones();
			direccion.setCidir(resultSet.getString("IDDIR"));
			direccion.setCdir(resultSet.getString("CDIR"));
			direccion.setEdir(resultSet.getString("EDIR"));
			direccion.setIddepar(resultSet.getLong("IDDEPAR"));
			direccion.setCodestrUs(resultSet.getString("CODESTR_US"));
			parte.setDireccion(direccion);

			parte.setIdedificio(resultSet.getString("IDEDIFICIO"));
			Edificios edificio = new Edificios();
			edificio.setIdedificio(resultSet.getString("IDEDIFICIO"));
			edificio.setCedificio(resultSet.getString("CEDIFICIO") == null ? ""
					: resultSet.getString("CEDIFICIO"));
			edificio.setEedificio(resultSet.getString("EEDIFICIO") == null ? ""
					: resultSet.getString("EEDIFICIO"));
			parte.setEdificio(edificio);

			parte.setIdzona(resultSet.getInt("IDZONA"));
			Zonas zona = new Zonas();
			zona.setIdzona(resultSet.getInt("IDZONA"));
			zona.setCzona(resultSet.getString("CZONA") == null ? "" : resultSet
					.getString("CZONA"));
			zona.setEzona(resultSet.getString("EZONA") == null ? "" : resultSet
					.getString("EZONA"));
			parte.setZona(zona);

			parte.setIdplanta(resultSet.getInt("IDPLANTA"));
			Plantas planta = new Plantas();
			planta.setIdplanta(resultSet.getInt("IDPLANTA"));
			planta.setCplanta(resultSet.getString("CPLANTA") == null ? ""
					: resultSet.getString("CPLANTA"));
			planta.setEplanta(resultSet.getString("EPLANTA") == null ? ""
					: resultSet.getString("EPLANTA"));
			parte.setPlanta(planta);

			parte.setLocalizacion(resultSet.getString("LOCAL") == null ? ""
					: resultSet.getString("LOCAL"));
			parte.setIntExt(resultSet.getString("INTEXT"));
			parte.setIdespacio(resultSet.getLong("IDESPACIO"));
			Espacio espacio = new Espacio();
			espacio.setIdespacio(resultSet.getLong("IDESPACIO"));
			espacio.setCespacio(resultSet.getString("CESPACIO") == null ? ""
					: resultSet.getString("CESPACIO"));
			espacio.setEespacio(resultSet.getString("EESPACIO") == null ? ""
					: resultSet.getString("EESPACIO"));
			parte.setEspacio(espacio);

			parte.setIdclase(resultSet.getInt("IDCLASE"));
			Clase clase = new Clase();
			clase.setIdclase(resultSet.getInt("IDCLASE"));
			clase.setCclase(resultSet.getString("CCLASE") == null ? ""
					: resultSet.getString("CCLASE"));
			clase.setEclase(resultSet.getString("ECLASE") == null ? ""
					: resultSet.getString("ECLASE"));
			parte.setClase(clase);

			parte.setIdcodigo(resultSet.getInt("IDCODIGO"));
			Codigo codigo = new Codigo();
			codigo.setIdcodigo(resultSet.getInt("IDCODIGO"));
			codigo.setCcodigo(resultSet.getString("CCODIGO") == null ? ""
					: resultSet.getString("CCODIGO"));
			codigo.setEcodigo(resultSet.getString("ECODIGO") == null ? ""
					: resultSet.getString("ECODIGO"));
			parte.setCodigo(codigo);

			parte.setObserv(resultSet.getString("OBSERV"));
			parte.setIdactuac(resultSet.getInt("IDACTUAC"));
			parte.setAveriaRepe(resultSet.getInt("AVERIAREPE"));
			parte.setVip(resultSet.getString("VIP"));
			parte.setUrgente(resultSet.getString("URGENTE"));
			parte.setEnviomail(resultSet.getString("ENVIOMAIL"));
			parte.setEjecutado(resultSet.getString("EJECUTADO"));
			parte.setTiempoReal(resultSet.getInt("TIEMPO_REAL"));

			parte.setFechaplanif(resultSet.getTimestamp("FECHAPLANIF"));
			return parte;
		}
	};

	private RowMapper<Partes> rwMapObtenerDatosAgendaGrid = new RowMapper<Partes>() {
		public Partes mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Partes parte = new Partes();

			parte.setIdparte(resultSet.getInt("IDPARTE"));
			parte.setNombre(resultSet.getString("NOMBRE"));
			parte.setFechare(resultSet.getTimestamp("FECHARE"));
			parte.setFechaplanif(resultSet.getTimestamp("FECHAPLANIF"));
			parte.setIddepar(resultSet.getLong("IDDEPAR"));
			Departamentos departamento = new Departamentos();
			departamento.setCidepar(resultSet.getString("IDDEPAR"));
			departamento.setCdepar(resultSet.getString("CDEPAR"));
			departamento.setEdepar(resultSet.getString("EDEPAR"));
			parte.setDepartamento(departamento);

			parte.setIddir(resultSet.getInt("IDDIR"));
			Direcciones direccion = new Direcciones();
			direccion.setCidir(resultSet.getString("IDDIR"));
			direccion.setCdir(resultSet.getString("CDIR"));
			direccion.setEdir(resultSet.getString("EDIR"));
			direccion.setIddepar(resultSet.getLong("IDDEPAR"));
			direccion.setCodestrUs(resultSet.getString("CODESTR_US"));
			parte.setDireccion(direccion);

			parte.setIdedificio(resultSet.getString("IDEDIFICIO"));
			Edificios edificio = new Edificios();
			edificio.setIdedificio(resultSet.getString("IDEDIFICIO"));
			edificio.setCedificio(resultSet.getString("CEDIFICIO") == null ? ""
					: resultSet.getString("CEDIFICIO"));
			edificio.setEedificio(resultSet.getString("EEDIFICIO") == null ? ""
					: resultSet.getString("EEDIFICIO"));
			parte.setEdificio(edificio);

			parte.setIdzona(resultSet.getInt("IDZONA"));
			Zonas zona = new Zonas();
			zona.setIdzona(resultSet.getInt("IDZONA"));
			zona.setCzona(resultSet.getString("CZONA") == null ? "" : resultSet
					.getString("CZONA"));
			zona.setEzona(resultSet.getString("EZONA") == null ? "" : resultSet
					.getString("EZONA"));
			parte.setZona(zona);

			parte.setIdplanta(resultSet.getInt("IDPLANTA"));
			Plantas planta = new Plantas();
			planta.setIdplanta(resultSet.getInt("IDPLANTA"));
			planta.setCplanta(resultSet.getString("CPLANTA") == null ? ""
					: resultSet.getString("CPLANTA"));
			planta.setEplanta(resultSet.getString("EPLANTA") == null ? ""
					: resultSet.getString("EPLANTA"));
			parte.setPlanta(planta);

			parte.setIdespacio(resultSet.getLong("IDESPACIO"));
			Espacio espacio = new Espacio();
			espacio.setIdespacio(resultSet.getLong("IDESPACIO"));
			espacio.setCespacio(resultSet.getString("CESPACIO") == null ? ""
					: resultSet.getString("CESPACIO"));
			espacio.setEespacio(resultSet.getString("EESPACIO") == null ? ""
					: resultSet.getString("EESPACIO"));
			parte.setEspacio(espacio);

			parte.setIdclase(resultSet.getInt("IDCLASE"));
			Clase clase = new Clase();
			clase.setIdclase(resultSet.getInt("IDCLASE"));
			clase.setCclase(resultSet.getString("CCLASE") == null ? ""
					: resultSet.getString("CCLASE"));
			clase.setEclase(resultSet.getString("ECLASE") == null ? ""
					: resultSet.getString("ECLASE"));
			parte.setClase(clase);

			parte.setIdcodigo(resultSet.getInt("IDCODIGO"));
			Codigo codigo = new Codigo();
			codigo.setIdcodigo(resultSet.getInt("IDCODIGO"));
			codigo.setCcodigo(resultSet.getString("CCODIGO") == null ? ""
					: resultSet.getString("CCODIGO"));
			codigo.setEcodigo(resultSet.getString("ECODIGO") == null ? ""
					: resultSet.getString("ECODIGO"));
			parte.setCodigo(codigo);

			parte.setObserv(resultSet.getString("OBSERV"));
			parte.setIdactuac(resultSet.getInt("IDACTUAC"));
			parte.setVip(resultSet.getString("VIP"));
			parte.setUrgente(resultSet.getString("URGENTE"));
			parte.setEnviomail(resultSet.getString("ENVIOMAIL"));
			parte.setEjecutado(resultSet.getString("EJECUTADO"));
			parte.setTiempoReal(resultSet.getInt("TIEMPO_REAL"));
			if (resultSet.getInt("COMPARTIDO") > 1) {
				parte.setCompartido(true);
			} else {
				parte.setCompartido(false);
			}
			Agenda agenda = new Agenda();
			agenda.setIdparte(resultSet.getInt("IDPARTE"));
			agenda.setIdtecnico(resultSet.getLong("IDTECNICO"));
			agenda.setIdpartec(resultSet.getInt("IDPARTEC"));
			agenda.setFinalizado(resultSet.getString("FINAL"));
			agenda.setMovilgmao(resultSet.getString("MOVILGMAO"));
			agenda.setTecnicocontrata(resultSet.getString("TECNICO_CONTRATA"));
			agenda.setNombretecnico(resultSet.getString("NOMBRETEC"));
			agenda.setIdpartegmao(resultSet.getInt("IDPARTEGMAO"));
			agenda.setEstadogmao(resultSet.getString("ESTADOGMAO"));
			agenda.setFechaestadogmao(resultSet.getString("FECHAESTADO"));
			parte.setAgenda(agenda);

			return parte;
		}
	};

	private RowMapper<Partes> rwMapObtenerDatosAgendaSinAsignarGrid = new RowMapper<Partes>() {
		public Partes mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Partes parte = new Partes();

			parte.setIdparte(resultSet.getInt("IDPARTE"));
			parte.setNombre(resultSet.getString("NOMBRE"));
			parte.setFechare(resultSet.getTimestamp("FECHARE"));
			parte.setFechaplanif(resultSet.getTimestamp("FECHAPLANIF"));
			parte.setIddepar(resultSet.getLong("IDDEPAR"));
			Departamentos departamento = new Departamentos();
			departamento.setCidepar(resultSet.getString("IDDEPAR"));
			departamento.setCdepar(resultSet.getString("CDEPAR"));
			departamento.setEdepar(resultSet.getString("EDEPAR"));
			parte.setDepartamento(departamento);

			parte.setIddir(resultSet.getInt("IDDIR"));
			Direcciones direccion = new Direcciones();
			direccion.setCidir(resultSet.getString("IDDIR"));
			direccion.setCdir(resultSet.getString("CDIR"));
			direccion.setEdir(resultSet.getString("EDIR"));
			direccion.setIddepar(resultSet.getLong("IDDEPAR"));
			direccion.setCodestrUs(resultSet.getString("CODESTR_US"));
			parte.setDireccion(direccion);

			parte.setIdedificio(resultSet.getString("IDEDIFICIO"));
			Edificios edificio = new Edificios();
			edificio.setIdedificio(resultSet.getString("IDEDIFICIO"));
			edificio.setCedificio(resultSet.getString("CEDIFICIO") == null ? ""
					: resultSet.getString("CEDIFICIO"));
			edificio.setEedificio(resultSet.getString("EEDIFICIO") == null ? ""
					: resultSet.getString("EEDIFICIO"));
			parte.setEdificio(edificio);

			parte.setIdzona(resultSet.getInt("IDZONA"));
			Zonas zona = new Zonas();
			zona.setIdzona(resultSet.getInt("IDZONA"));
			zona.setCzona(resultSet.getString("CZONA") == null ? "" : resultSet
					.getString("CZONA"));
			zona.setEzona(resultSet.getString("EZONA") == null ? "" : resultSet
					.getString("EZONA"));
			parte.setZona(zona);

			parte.setIdplanta(resultSet.getInt("IDPLANTA"));
			Plantas planta = new Plantas();
			planta.setIdplanta(resultSet.getInt("IDPLANTA"));
			planta.setCplanta(resultSet.getString("CPLANTA") == null ? ""
					: resultSet.getString("CPLANTA"));
			planta.setEplanta(resultSet.getString("EPLANTA") == null ? ""
					: resultSet.getString("EPLANTA"));
			parte.setPlanta(planta);

			parte.setIdespacio(resultSet.getLong("IDESPACIO"));
			Espacio espacio = new Espacio();
			espacio.setIdespacio(resultSet.getLong("IDESPACIO"));
			espacio.setCespacio(resultSet.getString("CESPACIO") == null ? ""
					: resultSet.getString("CESPACIO"));
			espacio.setEespacio(resultSet.getString("EESPACIO") == null ? ""
					: resultSet.getString("EESPACIO"));
			parte.setEspacio(espacio);

			parte.setIdclase(resultSet.getInt("IDCLASE"));
			Clase clase = new Clase();
			clase.setIdclase(resultSet.getInt("IDCLASE"));
			clase.setCclase(resultSet.getString("CCLASE") == null ? ""
					: resultSet.getString("CCLASE"));
			clase.setEclase(resultSet.getString("ECLASE") == null ? ""
					: resultSet.getString("ECLASE"));
			parte.setClase(clase);

			parte.setIdcodigo(resultSet.getInt("IDCODIGO"));
			Codigo codigo = new Codigo();
			codigo.setIdcodigo(resultSet.getInt("IDCODIGO"));
			codigo.setCcodigo(resultSet.getString("CCODIGO") == null ? ""
					: resultSet.getString("CCODIGO"));
			codigo.setEcodigo(resultSet.getString("ECODIGO") == null ? ""
					: resultSet.getString("ECODIGO"));
			parte.setCodigo(codigo);

			parte.setObserv(resultSet.getString("OBSERV"));
			parte.setIdactuac(resultSet.getInt("IDACTUAC"));
			parte.setVip(resultSet.getString("VIP"));
			parte.setUrgente(resultSet.getString("URGENTE"));
			parte.setEnviomail(resultSet.getString("ENVIOMAIL"));
			parte.setEjecutado(resultSet.getString("EJECUTADO"));
			parte.setTiempoReal(resultSet.getInt("TIEMPO_REAL"));

			return parte;
		}
	};

	private RowMapper<Partes> rwMapObtenerListEjecTecnicoGrid = new RowMapper<Partes>() {
		public Partes mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Partes parte = new Partes();

			parte.setIdparte(resultSet.getInt("IDPARTE"));
			parte.setFechare(resultSet.getTimestamp("FECHARE"));
			parte.setNombre(resultSet.getString("NOMBRE"));
			parte.setTecnicos(resultSet.getString("TECNICOS"));
			parte.setIddepar(resultSet.getLong("IDDEPAR"));
			Departamentos departamento = new Departamentos();
			departamento.setCidepar(resultSet.getString("IDDEPAR"));
			departamento.setCdepar(resultSet.getString("CDEPAR"));
			departamento.setEdepar(resultSet.getString("EDEPAR"));
			parte.setDepartamento(departamento);

			parte.setIddir(resultSet.getInt("IDDIR"));
			Direcciones direccion = new Direcciones();
			direccion.setCidir(resultSet.getString("IDDIR"));
			direccion.setCdir(resultSet.getString("CDIR"));
			direccion.setEdir(resultSet.getString("EDIR"));
			parte.setDireccion(direccion);

			parte.setIdedificio(resultSet.getString("IDEDIFICIO"));
			Edificios edificio = new Edificios();
			edificio.setIdedificio(resultSet.getString("IDEDIFICIO"));
			edificio.setCedificio(resultSet.getString("CEDIFICIO") == null ? ""
					: resultSet.getString("CEDIFICIO"));
			edificio.setEedificio(resultSet.getString("EEDIFICIO") == null ? ""
					: resultSet.getString("EEDIFICIO"));
			parte.setEdificio(edificio);

			parte.setIdzona(resultSet.getInt("IDZONA"));
			Zonas zona = new Zonas();
			zona.setIdzona(resultSet.getInt("IDZONA"));
			zona.setCzona(resultSet.getString("CZONA") == null ? "" : resultSet
					.getString("CZONA"));
			zona.setEzona(resultSet.getString("EZONA") == null ? "" : resultSet
					.getString("EZONA"));
			parte.setZona(zona);

			parte.setIdplanta(resultSet.getInt("IDPLANTA"));
			Plantas planta = new Plantas();
			planta.setIdplanta(resultSet.getInt("IDPLANTA"));
			planta.setCplanta(resultSet.getString("CPLANTA") == null ? ""
					: resultSet.getString("CPLANTA"));
			planta.setEplanta(resultSet.getString("EPLANTA") == null ? ""
					: resultSet.getString("EPLANTA"));
			parte.setPlanta(planta);

			parte.setLocalizacion(resultSet.getString("LOCAL") == null ? ""
					: resultSet.getString("LOCAL"));

			parte.setIdclase(resultSet.getInt("IDCLASE"));
			Clase clase = new Clase();
			clase.setIdclase(resultSet.getInt("IDCLASE"));
			clase.setCclase(resultSet.getString("CCLASE") == null ? ""
					: resultSet.getString("CCLASE"));
			clase.setEclase(resultSet.getString("ECLASE") == null ? ""
					: resultSet.getString("ECLASE"));
			parte.setClase(clase);

			parte.setIdcodigo(resultSet.getInt("IDCODIGO"));
			Codigo codigo = new Codigo();
			codigo.setIdcodigo(resultSet.getInt("IDCODIGO"));
			codigo.setCcodigo(resultSet.getString("CCODIGO") == null ? ""
					: resultSet.getString("CCODIGO"));
			codigo.setEcodigo(resultSet.getString("ECODIGO") == null ? ""
					: resultSet.getString("ECODIGO"));
			parte.setCodigo(codigo);

			parte.setObserv(resultSet.getString("OBSERV"));
			parte.setEjecutado(resultSet.getString("FINALIZADO"));
			parte.setTiempoReal(resultSet.getInt("TIEMPOREAL"));

			parte.setFechaej(resultSet.getTimestamp("FECHAEJMAX"));

			parte.setFechaplanif(resultSet.getTimestamp("FECHAPLANIF"));
			return parte;
		}
	};

	private RowMapper<Partes> rwMapObtenerParteGridPend = new RowMapper<Partes>() {
		public Partes mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Partes parte = new Partes();

			parte.setIdparte(resultSet.getInt("IDPARTE"));
			parte.setTecnicos(resultSet.getString("TECNICOS"));
			parte.setFechare(resultSet.getTimestamp("FECHARE"));
			parte.setNombre(resultSet.getString("NOMBRE"));
			parte.setIddepar(resultSet.getLong("IDDEPAR"));
			Departamentos departamento = new Departamentos();
			departamento.setCidepar(resultSet.getString("IDDEPAR"));
			departamento.setCdepar(resultSet.getString("CDEPAR"));
			departamento.setEdepar(resultSet.getString("EDEPAR"));
			parte.setDepartamento(departamento);

			parte.setIddir(resultSet.getInt("IDDIR"));
			Direcciones direccion = new Direcciones();
			direccion.setCidir(resultSet.getString("IDDIR"));
			direccion.setCdir(resultSet.getString("CDIR"));
			direccion.setEdir(resultSet.getString("EDIR"));
			direccion.setIddepar(resultSet.getLong("IDDEPAR"));
			direccion.setCodestrUs(resultSet.getString("CODESTR_US"));
			parte.setDireccion(direccion);

			parte.setIdedificio(resultSet.getString("IDEDIFICIO"));
			Edificios edificio = new Edificios();
			edificio.setIdedificio(resultSet.getString("IDEDIFICIO"));
			edificio.setCedificio(resultSet.getString("CEDIFICIO") == null ? ""
					: resultSet.getString("CEDIFICIO"));
			edificio.setEedificio(resultSet.getString("EEDIFICIO") == null ? ""
					: resultSet.getString("EEDIFICIO"));
			parte.setEdificio(edificio);

			parte.setIdzona(resultSet.getInt("IDZONA"));
			Zonas zona = new Zonas();
			zona.setIdzona(resultSet.getInt("IDZONA"));
			zona.setCzona(resultSet.getString("CZONA") == null ? "" : resultSet
					.getString("CZONA"));
			zona.setEzona(resultSet.getString("EZONA") == null ? "" : resultSet
					.getString("EZONA"));
			parte.setZona(zona);

			parte.setIdplanta(resultSet.getInt("IDPLANTA"));
			Plantas planta = new Plantas();
			planta.setIdplanta(resultSet.getInt("IDPLANTA"));
			planta.setCplanta(resultSet.getString("CPLANTA") == null ? ""
					: resultSet.getString("CPLANTA"));
			planta.setEplanta(resultSet.getString("EPLANTA") == null ? ""
					: resultSet.getString("EPLANTA"));
			parte.setPlanta(planta);

			parte.setIntExt(resultSet.getString("INTEXT"));
			parte.setIdespacio(resultSet.getLong("IDESPACIO"));
			Espacio espacio = new Espacio();
			espacio.setIdespacio(resultSet.getLong("IDESPACIO"));
			espacio.setCespacio(resultSet.getString("CESPACIO") == null ? ""
					: resultSet.getString("CESPACIO"));
			espacio.setEespacio(resultSet.getString("EESPACIO") == null ? ""
					: resultSet.getString("EESPACIO"));
			parte.setEspacio(espacio);

			parte.setIdclase(resultSet.getInt("IDCLASE"));
			Clase clase = new Clase();
			clase.setIdclase(resultSet.getInt("IDCLASE"));
			clase.setCclase(resultSet.getString("CCLASE") == null ? ""
					: resultSet.getString("CCLASE"));
			clase.setEclase(resultSet.getString("ECLASE") == null ? ""
					: resultSet.getString("ECLASE"));
			parte.setClase(clase);

			parte.setIdcodigo(resultSet.getInt("IDCODIGO"));
			Codigo codigo = new Codigo();
			codigo.setIdcodigo(resultSet.getInt("IDCODIGO"));
			codigo.setCcodigo(resultSet.getString("CCODIGO") == null ? ""
					: resultSet.getString("CCODIGO"));
			codigo.setEcodigo(resultSet.getString("ECODIGO") == null ? ""
					: resultSet.getString("ECODIGO"));
			parte.setCodigo(codigo);

			parte.setObserv(resultSet.getString("OBSERV"));
			parte.setIdactuac(resultSet.getInt("IDACTUAC"));
			parte.setAveriaRepe(resultSet.getInt("AVERIAREPE"));
			parte.setVip(resultSet.getString("VIP"));
			parte.setUrgente(resultSet.getString("URGENTE"));
			parte.setEnviomail(resultSet.getString("ENVIOMAIL"));
			parte.setFechaplanif(resultSet.getTimestamp("FECHAPLANIF"));

			return parte;
		}
	};

	/**
	 * obtener la fecha de la Ãºltima de ejecucion de un parte
	 * 
	 * @param parte
	 *            Partes
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Partes obtenerFechaEjecucion(Partes parte) {

		// String query =
		// "SELECT  t1.FECHAEJ FECHAEJ FROM PARTES t1 WHERE t1.IDPARTE=?";

		// String query =
		// "SELECT DISTINCT (select to_char(max(t1.fefin) ,'yyyy-mm-dd hh24:mi:ss') from PARTEEJECUCION t1 WHERE t1.IDPARTEC = t1.IDPARTEC) as FEFINMAX from PARTETECNICOS t2 where t2.idparte =?";
		// String query =
		// "SELECT DISTINCT (select max(TRUNC(t1.fefin)) from PARTEEJECUCION t1 WHERE t1.IDPARTEC = t2.IDPARTEC) as FEFINMAX from PARTETECNICOS t2 where t2.idparte =?";
		String query = "SELECT DISTINCT MAX(T2.fefin) AS FEFINMAX from PARTETECNICOS T1, PARTEEJECUCION T2 WHERE T1.IDPARTEC=T2.IDPARTEC AND T1.IDPARTE=?";

		List<Partes> partesList = this.jdbcTemplate.query(query,
				this.rwMapFechaEjec, parte.getIdparte());
		return (Partes) DataAccessUtils.uniqueResult(partesList);
	}

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Partes table.
	 * 
	 * @param partes
	 *            Pagination
	 * @return Partes
	 */
	public Partes add(Partes partes) {

		final Integer nextId = this.jdbcTemplate
				.queryForInt("SELECT PARTE_SEQ.NEXTVAL FROM DUAL");

		partes.setIdparte(nextId);

		String query = "";
		query = "INSERT INTO PARTES (IDPARTE, FECHARE, NOMBRE, TELEFO, MAIL, IDDEPAR, IDDIR, IDEDIFICIO, IDZONA, IDPLANTA, INT_EXT, IDESPACIO, IDCLASE, IDCODIGO, OBSERV, IDACTUAC, IDMAQUINA, EJECUTADO, FECHAEJ, TIEMPO_REAL, UID_PER, AVERIA_REPE, VIP, URGENTE, ENVIO_MAIL, GUIDPARTE, FECHAPLANIF, NOPROCEDE, NOPROCEDE_OBSERV) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, partes.getIdparte(), partes
				.getFechare(), partes.getNombre(), partes.getTelefo(), partes
				.getMail(), partes.getIddepar(), partes.getIddir(), partes
				.getIdedificio(), partes.getIdzona(), partes.getIdplanta(),
				partes.getIntExt(), partes.getIdespacio(), partes.getIdclase(),
				partes.getIdcodigo(), partes.getObserv(), partes.getIdactuac(),
				partes.getIdmaquina(), partes.getEjecutado() == null ? "0"
						: partes.getEjecutado(), partes.getFechaej(), partes
						.getTiempoReal(), partes.getUidPersona(),
				partes.getAveriaRepe() == null ? "0" : partes.getAveriaRepe(),
				partes.getVip() == null ? "0" : partes.getVip(), partes
						.getUrgente() == null ? "0" : partes.getUrgente(),
				partes.getEnviomail() == null ? "0" : partes.getEnviomail(),
				partes.getGuidparte(), partes.getFechaplanif(), partes
						.getNoProcede(), partes.getObservNoProcede());

		// Si hay plano se guarda en la tabla de PartePlano
		if (partes.getPlanoMarca() != null) {

			if (partes.getPlanoMarca().length > 0) { // hay marca en el plano
				query = "INSERT INTO PARTEPLANO (IDPARTE, DIBUJO) VALUES (?,?)";
				this.jdbcTemplate.update(query, partes.getIdparte(),
						partes.getPlanoMarca());
			}
		}

		// Si hay pdf, se guarda en la tabla de adjuntos
		if (partes.getPdfAdjunto() != null) {
			if (partes.getPdfAdjunto().length > 0) {
				query = "INSERT INTO PARTEPDF (IDPARTE, PDF) VALUES (?,?)";
				this.jdbcTemplate.update(query, partes.getIdparte(),
						partes.getPdfAdjunto());
			}
		}

		return partes;
	}

	/**
	 * Crea un parte partiendo de una actuaciÃ³n preventiva.
	 * 
	 * @param partes
	 *            Pagination
	 * @return Partes
	 */
	public Partes nuevoParteCorrDesdePreventivo(Partes partes) {

		final Integer nextId = this.jdbcTemplate
				.queryForInt("SELECT PARTE_SEQ.NEXTVAL FROM DUAL");

		partes.setIdparte(nextId);

		String query = "";
		query = "INSERT INTO PARTES (IDPARTE, FECHARE, NOMBRE, TELEFO, IDEDIFICIO, IDZONA, IDPLANTA, IDCLASE, IDCODIGO, IDACTUAC, IDMAQUINA, UID_PER, OBSERV, FECHAPLANIF,NOPROCEDE,NOPROCEDE_OBSERV) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, partes.getIdparte(),
				partes.getFechare(), partes.getNombre(), partes.getTelefo(),
				partes.getIdedificio(), partes.getIdzona(),
				partes.getIdplanta(), partes.getIdclase(),
				partes.getIdcodigo(), partes.getIdactuac(),
				partes.getIdmaquina(), partes.getUidPersona(),
				partes.getObserv() == null ? "" : partes.getObserv(),
				partes.getFechare(), partes.getNoProcede(),
				partes.getObservNoProcede());

		return partes;
	}

	/**
	 * Updates a single row in the Partes table.
	 * 
	 * @param partes
	 *            Pagination
	 * @return Partes
	 */
	public Partes update(Partes partes) {
		String query = "UPDATE PARTES SET FECHARE=?, NOMBRE=?, TELEFO=?, MAIL=?, IDDEPAR=?, IDDIR=?, IDEDIFICIO=?, IDZONA=?, IDPLANTA=?, INT_EXT=?, IDESPACIO=?, IDCLASE=?, IDCODIGO=?, OBSERV=?, IDACTUAC=?, IDMAQUINA=?, EJECUTADO=?, FECHAEJ=?, TIEMPO_REAL=?, AVERIA_REPE=?, UID_PER=?, VIP=?, URGENTE=?, ENVIO_MAIL=?, FECHAPLANIF=?, NOPROCEDE=?, NOPROCEDE_OBSERV=? WHERE IDPARTE=?";
		this.jdbcTemplate.update(query, partes.getFechare(),
				partes.getNombre(), partes.getTelefo(), partes.getMail(),
				partes.getIddepar(), partes.getIddir(), partes.getIdedificio(),
				partes.getIdzona(), partes.getIdplanta(), partes.getIntExt(),
				partes.getIdespacio(), partes.getIdclase(), partes
						.getIdcodigo(), partes.getObserv(), partes
						.getIdactuac(), partes.getIdmaquina(), partes
						.getEjecutado() == null ? "0" : partes.getEjecutado(),
				partes.getFechaej(), partes.getTiempoReal(),
				partes.getAveriaRepe() == null ? "0" : partes.getAveriaRepe(),
				partes.getUidPersona(),
				partes.getVip() == null ? "0" : partes.getVip(), partes
						.getUrgente() == null ? "0" : partes.getUrgente(),
				partes.getEnviomail() == null ? "0" : partes.getEnviomail(),
				partes.getFechaplanif(), partes.getNoProcede(), partes
						.getObservNoProcede(), partes.getIdparte());
		return partes;
	}

	public Partes actualizarUUIDparte(Partes partes) {
		String query = "UPDATE PARTES SET GUIDPARTE=? WHERE IDPARTE=? ";
		this.jdbcTemplate.update(query, partes.getGuidparte(),
				partes.getIdparte());

		return partes;
	}

	public Partes actualizarFechaPlanificacion(Partes partes) {
		String query = "UPDATE PARTES SET FECHAPLANIF=? WHERE IDPARTE=?";
		this.jdbcTemplate.update(query, partes.getFechaplanif(),
				partes.getIdparte());
		return partes;
	}

	public Partes actualizarInfoNoProcede(Partes partes) {
		String query = "UPDATE PARTES SET NOPROCEDE=?, NOPROCEDE_OBSERV=? WHERE IDPARTE=?";
		this.jdbcTemplate.update(query, partes.getNoProcede(),
				partes.getObservNoProcede(), partes.getIdparte());
		return partes;
	}

	/**
	 * finalizar el parte Padre y los hijos.
	 * 
	 * @param partes
	 *            Pagination
	 * @return Partes
	 */
	public Partes finalizarParte(Partes partes) {
		// Actualizar lo hijos
		String query = "UPDATE PARTES SET EJECUTADO=1, FECHAEJ=?, TIEMPO_REAL=0 WHERE AVERIA_REPE=?";
		this.jdbcTemplate.update(query, partes.getFechaej(),
				partes.getIdparte());

		// Actualizar el parte padre
		query = "UPDATE PARTES SET EJECUTADO=1, FECHAEJ=?, TIEMPO_REAL=? WHERE IDPARTE=?";

		this.jdbcTemplate.update(query, partes.getFechaej(),
				partes.getTiempoReal(), partes.getIdparte());
		return partes;

	}

	/**
	 * abre el parte Padre y los hijos.
	 * 
	 * @param partes
	 *            Pagination
	 * @return Partes
	 */
	public Partes abrirParte(Partes partes) {
		// abre lo hijos
		String query = "UPDATE PARTES SET EJECUTADO=0 WHERE AVERIA_REPE=?";
		this.jdbcTemplate.update(query, partes.getIdparte());

		// abre el parte padre
		query = "UPDATE PARTES SET EJECUTADO=0 WHERE IDPARTE=?";

		this.jdbcTemplate.update(query, partes.getIdparte());
		return partes;

	}

	/**
	 * Updates a single row in the Partes table.
	 * 
	 * @param partes
	 *            Pagination
	 * @return Partes
	 */
	public Partes modificarParte(Partes partes) {
		String query = "UPDATE PARTES SET TELEFO=?, MAIL=?, IDZONA=?, IDPLANTA=?, IDESPACIO=?, IDCLASE=?, IDCODIGO=?, OBSERV=?, AVERIA_REPE=?, VIP=?, URGENTE=?, ENVIO_MAIL=?, FECHAPLANIF=?, NOPROCEDE=?, NOPROCEDE_OBSERV=? WHERE IDPARTE=?";
		this.jdbcTemplate.update(query, partes.getTelefo(), partes.getMail(),
				partes.getIdzona(), partes.getIdplanta(),
				partes.getIdespacio(), partes.getIdclase(),
				partes.getIdcodigo(), partes.getObserv(),
				partes.getAveriaRepe() == null ? "0" : partes.getAveriaRepe(),
				partes.getVip() == null ? "0" : partes.getVip(),
				partes.getUrgente() == null ? "0" : partes.getUrgente(),
				partes.getEnviomail() == null ? "0" : partes.getEnviomail(),
				partes.getFechaplanif(), partes.getNoProcede(),
				partes.getObservNoProcede(), partes.getIdparte());
		return partes;
	}

	/**
	 * Updates a single row in the Partes table.
	 * 
	 * @param partes
	 *            Pagination
	 * @return
	 */
	public void marcarAutomatica(Partes partes) {
		String query = "UPDATE PARTES SET AUTOMATICA='1' WHERE IDPARTE=?";
		this.jdbcTemplate.update(query, partes.getIdparte());
	}

	/**
	 * Updates a single row in the Partes table.
	 * 
	 * @param partes
	 *            Pagination
	 * @return
	 */
	public void marcarEnvioMail(Partes partes) {
		String query = "UPDATE PARTES SET ENVIO_MAIL='1' WHERE IDPARTE=?";
		this.jdbcTemplate.update(query, partes.getIdparte());
	}

	/**
	 * Finds a single row in the Partes table.
	 * 
	 * @param partes
	 *            Pagination
	 * @return Partes
	 */
	@Transactional(readOnly = true)
	public Partes find(Partes partes) {
		String query = "SELECT t1.IDPARTE IDPARTE, t1.FECHARE FECHARE, t1.NOMBRE NOMBRE, t1.TELEFO TELEFO, t1.MAIL MAIL, t1.IDDEPAR IDDEPAR, t1.IDDIR IDDIR, t1.IDEDIFICIO IDEDIFICIO, t1.IDZONA IDZONA, t1.IDPLANTA IDPLANTA, t1.INT_EXT INTEXT, t1.IDESPACIO IDESPACIO, t1.IDCLASE IDCLASE, t1.IDCODIGO IDCODIGO, t1.OBSERV OBSERV, t1.IDACTUAC IDACTUAC, t1.IDMAQUINA IDMAQUINA, t1.EJECUTADO EJECUTADO, t1.FECHAEJ FECHAEJ, t1.TIEMPO_REAL TIEMPOREAL, t1.UID_PER UIDPER, t1.AVERIA_REPE AVERIAREPE, t1.VIP VIP, t1.URGENTE URGENTE, t1.ENVIO_MAIL ENVIOMAIL, t1.GUIDPARTE GUIDPARTE, t1.FECHAPLANIF FECHAPLANIF, t1.NOPROCEDE NOPROCEDE, t1.NOPROCEDE_OBSERV NOPROCEDE_OBSERV, t1.AUTOMATICA AUTOMATICA, t2.CIDEPAR CIDEPAR, t2.CDEPAR CDEPAR, t2.EDEPAR EDEPAR FROM PARTES t1, DEPARTAMENTOS t2, DIRECCIONES t3  WHERE t1.IDDEPAR=t2.IDDEPAR(+) AND t1.IDDIR=t3.IDDIR(+) AND t1.IDPARTE = ?  ";

		List<Partes> partesList = this.jdbcTemplate.query(query, this.rwMap,
				partes.getIdparte());
		return (Partes) DataAccessUtils.uniqueResult(partesList);
	}

	/**
	 * Finds a single row in the Partes table.
	 * 
	 * @param partes
	 *            Pagination
	 * @return Partes
	 */
	@Transactional(readOnly = true)
	public Partes findParte(Partes partes) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDPARTE IDPARTE,t1.FECHARE FECHARE,t1.NOMBRE NOMBRE,t1.TELEFO TELEFO,t1.MAIL MAIL,t1.IDDEPAR IDDEPAR,t1.IDDIR IDDIR,t1.IDEDIFICIO IDEDIFICIO,t1.IDZONA IDZONA,t1.IDPLANTA IDPLANTA,t1.INT_EXT INTEXT,t1.IDESPACIO IDESPACIO,t1.IDCLASE IDCLASE,t1.IDCODIGO IDCODIGO,t1.OBSERV OBSERV,t1.IDACTUAC IDACTUAC,t1.IDMAQUINA IDMAQUINA,t1.EJECUTADO EJECUTADO,t1.FECHAEJ FECHAEJ,t1.TIEMPO_REAL TIEMPOREAL,t1.UID_PER UIDPER,t1.AVERIA_REPE AVERIAREPE,t1.VIP VIP,t1.URGENTE URGENTE, t1.ENVIO_MAIL ENVIOMAIL, t1.FECHAPLANIF FECHAPLANIF, t1.NOPROCEDE NOPROCEDE, t1.NOPROCEDE_OBSERV NOPROCEDE_OBSERV ");
		query.append(", t2.CIDEPAR CIDEPAR, t2.CDEPAR CDEPAR, t2.EDEPAR EDEPAR, t3.CIDIR CIDIR, t3.CDIR CDIR, t3.EDIR EDIR, t3.CODESTR_US CODESTR_US, t4.CEDIFICIO CEDIFICIO, t4.EEDIFICIO EEDIFICIO, t5.CZONA CZONA, t5.EZONA EZONA, t6.CPLANTA CPLANTA, t6.EPLANTA EPLANTA, t7.CESPACIO CESPACIO, t7.EESPACIO EESPACIO, t8.CCLASE CCLASE, t8.ECLASE ECLASE, t9.CCODIGO CCODIGO, t9.ECODIGO ECODIGO, t10.CMAQUINA, t10.EMAQUINA, t12.OPERACION OPERACION ");
		query.append("FROM PARTES t1, DEPARTAMENTOS t2, DIRECCIONES t3, EDIFICIOS t4, ZONAS t5, PLANTAS t6, ESPACIO t7, CLASE t8, CODIGO t9, MAQUINAS t10, ACTUACION t11, CUESTIONARIO t12 ");

		StringBuilder where = new StringBuilder(
				" WHERE t1.IDDEPAR=t2.IDDEPAR(+) AND t1.IDDIR=t3.IDDIR(+) AND t1.IDEDIFICIO=t4.IDEDIFICIO(+) AND t1.IDZONA=t5.IDZONA(+) AND t1.IDPLANTA=t6.IDPLANTA(+) AND t1.IDESPACIO=t7.IDESPACIO(+) AND t1.IDCLASE=t8.IDCLASE(+) AND t1.IDCODIGO=t9.IDCODIGO(+) AND t1.IDMAQUINA=t10.IDMAQUINA(+) AND t1.IDACTUAC = t11.IDACTUACION(+) AND t11.IDCUESTIONARIO = t12.IDCUESTIONARIO(+) AND t1.IDPARTE = ?  ");
		query.append(where);

		List<Partes> partesList = this.jdbcTemplate.query(query.toString(),
				this.rwMapObtenerParteEditar, partes.getIdparte());
		return (Partes) DataAccessUtils.uniqueResult(partesList);
	}

	/**
	 * Removes a single row in the Partes table.
	 * 
	 * @param partes
	 *            Pagination
	 * @return
	 */
	public void remove(Partes partes) {
		String query = "DELETE FROM PARTES WHERE IDPARTE=?";
		this.jdbcTemplate.update(query, partes.getIdparte());
	}

	/**
	 * Finds a List of rows in the Partes table.
	 * 
	 * @param partes
	 *            Partes
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Partes> findAll(Partes partes, Pagination pagination) {

		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDPARTE IDPARTE,t1.FECHARE FECHARE,t1.NOMBRE NOMBRE,t1.TELEFO TELEFO,t1.MAIL MAIL,t1.IDDEPAR IDDEPAR,t1.IDDIR IDDIR,t1.IDEDIFICIO IDEDIFICIO,t1.IDZONA IDZONA,t1.IDPLANTA IDPLANTA,t1.INT_EXT INTEXT,t1.IDESPACIO IDESPACIO,t1.IDCLASE IDCLASE,t1.IDCODIGO IDCODIGO,t1.OBSERV OBSERV,t1.IDACTUAC IDACTUAC,t1.IDMAQUINA IDMAQUINA,t1.EJECUTADO EJECUTADO,t1.FECHAEJ FECHAEJ,t1.TIEMPO_REAL TIEMPOREAL,t1.UID_PER UIDPER,t1.AVERIA_REPE AVERIAREPE,t1.VIP VIP,t1.URGENTE URGENTE, t1.ENVIO_MAIL ENVIOMAIL, t1.FECHAPLANIF FECHAPLANIF, t1.NOPROCEDE NOPROCEDE, t1.NOPROCEDE_OBSERV NOPROCEDE_OBSERV ");
		query.append(", t2.CIDEPAR CIDEPAR, t2.CDEPAR CDEPAR, t2.EDEPAR EDEPAR, t3.CIDIR CIDIR, t3.CDIR CDIR, t3.EDIR EDIR, t3.CODESTR_US CODESTR_US, t4.CEDIFICIO CEDIFICIO, t4.EEDIFICIO EEDIFICIO, t5.CZONA CZONA, t5.EZONA EZONA, t6.CPLANTA CPLANTA, t6.EPLANTA EPLANTA, t7.CESPACIO CESPACIO, t7.EESPACIO EESPACIO, t8.CCLASE CCLASE, t8.ECLASE ECLASE, t9.CCODIGO CCODIGO, t9.ECODIGO ECODIGO ");
		query.append("FROM PARTES t1, DEPARTAMENTOS t2, DIRECCIONES t3, EDIFICIOS t4, ZONAS t5, PLANTAS t6, ESPACIO t7, CLASE t8, CODIGO t9  ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(partes);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.IDDEPAR=t2.IDDEPAR(+) AND t1.IDDIR=t3.IDDIR(+) AND t1.IDEDIFICIO=t4.IDEDIFICIO(+) AND t1.IDZONA=t5.IDZONA(+) AND t1.IDPLANTA=t6.IDPLANTA(+) AND t1.IDESPACIO=t7.IDESPACIO(+) AND t1.IDCLASE=t8.IDCLASE(+) AND t1.IDCODIGO=t9.IDCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Partes>) this.jdbcTemplate.query(query.toString(),
				this.rwMapObtenerParte, params.toArray());
	}

	@Transactional(readOnly = true)
	public List<Partes> findAllpendientes(Partes partes, Pagination pagination) {

		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDPARTE IDPARTE,t1.FECHARE FECHARE,t1.NOMBRE NOMBRE,t1.TELEFO TELEFO,t1.MAIL MAIL,t1.IDDEPAR IDDEPAR,t1.IDDIR IDDIR,t1.IDEDIFICIO IDEDIFICIO,t1.IDZONA IDZONA,t1.IDPLANTA IDPLANTA,t1.INT_EXT INTEXT,t1.IDESPACIO IDESPACIO,t1.IDCLASE IDCLASE,t1.IDCODIGO IDCODIGO,t1.OBSERV OBSERV,t1.IDACTUAC IDACTUAC,t1.IDMAQUINA IDMAQUINA,t1.EJECUTADO EJECUTADO,t1.FECHAEJ FECHAEJ,t1.TIEMPO_REAL TIEMPOREAL,t1.UID_PER UIDPER,t1.AVERIA_REPE AVERIAREPE,t1.VIP VIP,t1.URGENTE URGENTE, t1.ENVIO_MAIL ENVIOMAIL, t1.FECHAPLANIF FECHAPLANIF, t1.NOPROCEDE NOPROCEDE, t1.NOPROCEDE_OBSERV NOPROCEDE_OBSERV ");
		query.append(", t2.CIDEPAR CIDEPAR, t2.CDEPAR CDEPAR, t2.EDEPAR EDEPAR, t3.CIDIR CIDIR, t3.CDIR CDIR, t3.EDIR EDIR, t3.CODESTR_US CODESTR_US, t4.CEDIFICIO CEDIFICIO, t4.EEDIFICIO EEDIFICIO, t5.CZONA CZONA, t5.EZONA EZONA, t6.CPLANTA CPLANTA, t6.EPLANTA EPLANTA, t7.CESPACIO CESPACIO, t7.EESPACIO EESPACIO, t8.CCLASE CCLASE, t8.ECLASE ECLASE, t9.CCODIGO CCODIGO, t9.ECODIGO ECODIGO ");
		query.append("FROM PARTES t1, DEPARTAMENTOS t2, DIRECCIONES t3, EDIFICIOS t4, ZONAS t5, PLANTAS t6, ESPACIO t7, CLASE t8, CODIGO t9  ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(partes);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.IDDEPAR=t2.IDDEPAR(+) AND t1.IDDIR=t3.IDDIR(+) AND t1.IDEDIFICIO=t4.IDEDIFICIO(+) AND t1.IDZONA=t5.IDZONA(+) AND t1.IDPLANTA=t6.IDPLANTA(+) AND t1.IDESPACIO=t7.IDESPACIO(+) AND t1.IDCLASE=t8.IDCLASE(+) AND t1.IDCODIGO=t9.IDCODIGO(+) AND t1.IDEDIFICIO in ('001800','005402','005423','001911','001016') AND t1.FECHARE < '14/10/2016'");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Partes>) this.jdbcTemplate.query(query.toString(),
				this.rwMapObtenerParte, params.toArray());
	}

	/**
	 * Finds a List of rows in the Partes table.
	 * 
	 * @param partes
	 *            Partes
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Partes> obtenerParte(Partes partes) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDPARTE IDPARTE,t1.FECHARE FECHARE,t1.NOMBRE NOMBRE,t1.TELEFO TELEFO,t1.MAIL MAIL,t1.IDDEPAR IDDEPAR,t1.IDDIR IDDIR,t1.IDEDIFICIO IDEDIFICIO,t1.IDZONA IDZONA,t1.IDPLANTA IDPLANTA,t1.INT_EXT INTEXT,t1.IDESPACIO IDESPACIO,t1.IDCLASE IDCLASE,t1.IDCODIGO IDCODIGO,t1.OBSERV OBSERV,t1.IDACTUAC IDACTUAC,t1.IDMAQUINA IDMAQUINA,t1.EJECUTADO EJECUTADO,t1.FECHAEJ FECHAEJ,t1.TIEMPO_REAL TIEMPOREAL,t1.UID_PER UIDPER,t1.AVERIA_REPE AVERIAREPE,t1.VIP VIP,t1.URGENTE URGENTE, t1.ENVIO_MAIL ENVIOMAIL, t1.FECHAPLANIF FECHAPLANIF, t1.NOPROCEDE NOPROCEDE, t1.NOPROCEDE_OBSERV NOPROCEDE_OBSERV ");
		query.append(", t2.CIDEPAR CIDEPAR, t2.CDEPAR CDEPAR, t2.EDEPAR EDEPAR, t3.CIDIR CIDIR, t3.CDIR CDIR, t3.EDIR EDIR, t3.CODESTR_US CODESTR_US, t4.CEDIFICIO CEDIFICIO, t4.EEDIFICIO EEDIFICIO, t5.CZONA CZONA, t5.EZONA EZONA, t6.CPLANTA CPLANTA, t6.EPLANTA EPLANTA, t7.CESPACIO CESPACIO, t7.EESPACIO EESPACIO, t8.CCLASE CCLASE, t8.ECLASE ECLASE, t9.CCODIGO CCODIGO, t9.ECODIGO ECODIGO ");
		query.append("FROM PARTES t1, DEPARTAMENTOS t2, DIRECCIONES t3, EDIFICIOS t4, ZONAS t5, PLANTAS t6, ESPACIO t7, CLASE t8, CODIGO t9  ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(partes);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.IDDEPAR=t2.IDDEPAR(+) AND t1.IDDIR=t3.IDDIR(+) AND t1.IDEDIFICIO=t4.IDEDIFICIO(+) AND t1.IDZONA=t5.IDZONA(+) AND t1.IDPLANTA=t6.IDPLANTA(+) AND t1.IDESPACIO=t7.IDESPACIO(+) AND t1.IDCLASE=t8.IDCLASE(+) AND t1.IDCODIGO=t9.IDCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return (List<Partes>) this.jdbcTemplate.query(query.toString(),
				this.rwMapObtenerParte, params.toArray());
	}

	/**
	 * Counts rows in the Partes table.
	 * 
	 * @param partes
	 *            Partes
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Partes partes) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM PARTES t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(partes);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Partes table using like.
	 * 
	 * @param partes
	 *            Partes
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Partes> findAllLike(Partes partes, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDPARTE IDPARTE,t1.FECHARE FECHARE,t1.NOMBRE NOMBRE,t1.TELEFO TELEFO,t1.MAIL MAIL,t1.IDDEPAR IDDEPAR,t1.IDDIR IDDIR,t1.IDEDIFICIO IDEDIFICIO,t1.IDZONA IDZONA,t1.IDPLANTA IDPLANTA,t1.INT_EXT INTEXT,t1.IDESPACIO IDESPACIO,t1.IDCLASE IDCLASE,t1.IDCODIGO IDCODIGO,t1.OBSERV OBSERV,t1.IDACTUAC IDACTUAC,t1.IDMAQUINA IDMAQUINA,t1.EJECUTADO EJECUTADO,t1.FECHAEJ FECHAEJ,t1.TIEMPO_REAL TIEMPOREAL,t1.UID_PER UIDPER,t1.AVERIA_REPE AVERIAREPE,t1.VIP VIP,t1.URGENTE URGENTE, t1.ENVIO_MAIL ENVIOMAIL, t1.FECHAPLANIF FECHAPLANIF, t1.NOPROCEDE NOPROCEDE, t1.NOPROCEDE_OBSERV NOPROCEDE_OBSERV ");
		query.append(", t2.CIDEPAR CIDEPAR, t2.CDEPAR CDEPAR, t2.EDEPAR EDEPAR, t3.CIDIR CIDIR, t3.CDIR CDIR, t3.EDIR EDIR, t3.CODESTR_US CODESTR_US, t4.CEDIFICIO CEDIFICIO, t4.EEDIFICIO EEDIFICIO, t5.CZONA CZONA, t5.EZONA EZONA, t6.CPLANTA CPLANTA, t6.EPLANTA EPLANTA, t7.CESPACIO CESPACIO, t7.EESPACIO EESPACIO, t8.CCLASE CCLASE, t8.ECLASE ECLASE, t9.CCODIGO CCODIGO, t9.ECODIGO ECODIGO ");
		query.append("FROM PARTES t1, DEPARTAMENTOS t2, DIRECCIONES t3, EDIFICIOS t4, ZONAS t5, PLANTAS t6, ESPACIO t7, CLASE t8, CODIGO t9  ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(partes, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.IDDEPAR=t2.IDDEPAR(+) AND t1.IDDIR=t3.IDDIR(+) AND t1.IDEDIFICIO=t4.IDEDIFICIO(+) AND t1.IDZONA=t5.IDZONA(+) AND t1.IDPLANTA=t6.IDPLANTA(+) AND t1.IDESPACIO=t7.IDESPACIO(+) AND t1.IDCLASE=t8.IDCLASE(+) AND t1.IDCODIGO=t9.IDCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Partes>) this.jdbcTemplate.query(query.toString(),
				this.rwMapObtenerParte, params.toArray());
	}

	/**
	 * Obtener parte pendiente de ejecución asociado a un tecnico y
	 * Edificio/Zona.
	 * 
	 * @param idEdificio
	 *            String
	 * @param idZona
	 *            Integer
	 * @param idTecnico
	 *            Long
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Partes> comprobarParteZonaTecnico(String idEdificio,
			Integer idZona, Long idTecnico) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.IDPARTE IDPARTE, t3.CZONA CZONA, t3.EZONA EZONA ");
		query.append(" FROM PARTES t1, PARTETECNICOS t2, ZONAS t3 ");
		query.append(" WHERE t1.IDPARTE=t2.IDPARTE AND t1.IDZONA=t3.IDZONA AND t1.EJECUTADO=0 AND t1.IDEDIFICIO=? AND t1.IDZONA=? AND t2.IDTECNICO=? ");

		return (List<Partes>) this.jdbcTemplate.query(query.toString(),
				this.rwMapParteZonaTecnico, idEdificio, idZona, idTecnico);
	}

	/**
	 * Finds rows in the Partes table using like.
	 * 
	 * @param partes
	 *            Partes
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param sUIDUsuario
	 *            String
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Partes> obtenerPartesGrid(Partes partes, Pagination pagination,
			Boolean startsWith, String sUIDUsuario) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDPARTE IDPARTE,t1.FECHARE FECHARE,t1.NOMBRE NOMBRE,t1.IDDEPAR IDDEPAR,t1.IDDIR IDDIR,t1.IDEDIFICIO IDEDIFICIO,t1.IDZONA IDZONA,t1.IDPLANTA IDPLANTA,t1.INT_EXT INTEXT,t1.IDESPACIO IDESPACIO,t1.IDCLASE IDCLASE,t1.IDCODIGO IDCODIGO,t1.OBSERV OBSERV,t1.IDACTUAC IDACTUAC, CASE WHEN t1.AVERIA_REPE=0 THEN t1.IDPARTE ELSE t1.AVERIA_REPE END as REPE, t1.AVERIA_REPE AVERIAREPE, t1.VIP VIP,t1.URGENTE URGENTE, t1.ENVIO_MAIL ENVIOMAIL, t1.FECHAPLANIF FECHAPLANIF ");
		query.append(", t2.CIDEPAR CIDEPAR, t2.CDEPAR CDEPAR, t2.EDEPAR EDEPAR, t3.CIDIR CIDIR, t3.CDIR CDIR, t3.EDIR EDIR, t3.CODESTR_US CODESTR_US, t4.CEDIFICIO CEDIFICIO, t4.EEDIFICIO EEDIFICIO, t5.CZONA CZONA, t5.EZONA EZONA, t6.CPLANTA CPLANTA, t6.EPLANTA EPLANTA, t7.CESPACIO CESPACIO, t7.EESPACIO EESPACIO, t8.CCLASE CCLASE, t8.ECLASE ECLASE, t9.CCODIGO CCODIGO, t9.ECODIGO ECODIGO ");
		query.append(" FROM PARTES t1, DEPARTAMENTOS t2, DIRECCIONES t3, EDIFICIOS t4, ZONAS t5, PLANTAS t6, ESPACIO t7, CLASE t8, CODIGO t9, EDIFICIOSVER t12  ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapPartes(partes,
				startsWith, sUIDUsuario);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.IDDEPAR=t2.IDDEPAR(+) AND t1.IDDIR=t3.IDDIR(+) AND t1.IDEDIFICIO=t4.IDEDIFICIO(+) AND t1.IDZONA=t5.IDZONA(+) AND t1.IDPLANTA=t6.IDPLANTA(+) AND t1.IDESPACIO=t7.IDESPACIO(+) AND t1.IDCLASE=t8.IDCLASE(+) AND t1.IDCODIGO=t9.IDCODIGO(+) AND t1.IDEDIFICIO=t12.IDEDIFICIO ");
		if (partes != null && partes.getTecnicos() != null
				&& partes.getTecnicos().trim().length() > 0) {
			query.append(", PARTETECNICOS t10, TECNICOS t11 ");
			where.append(" AND t1.IDPARTE=t10.IDPARTE(+) AND t10.IDTECNICO=t11.IDTECNICO(+) ");
		}

		// Si viene la marca conTecnicos aÃ±adir la tabla PARTETECNICOS
		if (partes != null && partes.getConTecnicos() != null
				&& partes.getConTecnicos().equals("1")) {
			// partes que tienen tecnicos asignados
			where.append(" AND t1.IDPARTE in (Select t13.IDPARTE FROM PARTETECNICOS t13) ");
		} else if (partes != null && partes.getConTecnicos() != null
				&& partes.getConTecnicos().equals("0")) {
			// partes que no tienen tecnicos asignados
			where.append(" AND t1.IDPARTE not in (Select t13.IDPARTE FROM PARTETECNICOS t13) ");
		}

		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Partes>) this.jdbcTemplate.query(query.toString(),
				this.rwMapObtenerParteGrid, params.toArray());
	}

	/**
	 * Finds rows in the Partes table using like.
	 * 
	 * @param partes
	 *            Partes
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Partes> obtenerListCorrGrid(Partes partes,
			Pagination pagination, Boolean startsWith, String sUIDUsuario) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDPARTE IDPARTE, (RTRIM(XMLAGG(xmlelement(X, t11.NOMBRE || ',') ORDER BY t11.NOMBRE).extract('//text()'), ',')) AS TECNICOS, t1.FECHARE FECHARE,t1.NOMBRE NOMBRE,t1.IDDEPAR IDDEPAR,t1.IDDIR IDDIR,t1.IDEDIFICIO IDEDIFICIO,t1.IDZONA IDZONA,t1.IDPLANTA IDPLANTA, t1.FECHAPLANIF FECHAPLANIF ");
		query.append(", t4.REDIFICIO || '/' ||  CASE WHEN t5.RZONA='0' THEN '' ELSE t5.RZONA END || '/' || CASE WHEN t6.RPLANTA='0' THEN '' ELSE t6.RPLANTA END as LOCAL ");
		query.append(", t1.INT_EXT INTEXT,t1.IDESPACIO IDESPACIO,t1.IDCLASE IDCLASE,t1.IDCODIGO IDCODIGO,t1.OBSERV OBSERV,t1.IDACTUAC IDACTUAC, CASE WHEN t1.AVERIA_REPE=0 THEN t1.IDPARTE ELSE t1.AVERIA_REPE END as REPE, t1.AVERIA_REPE AVERIAREPE, t1.VIP VIP, t1.URGENTE URGENTE, t1.ENVIO_MAIL ENVIOMAIL ");
		query.append(", t2.CIDEPAR CIDEPAR, t2.CDEPAR CDEPAR, t2.EDEPAR EDEPAR, t3.CIDIR CIDIR, t3.CDIR CDIR, t3.EDIR EDIR, t3.CODESTR_US CODESTR_US, t4.CEDIFICIO CEDIFICIO, t4.EEDIFICIO EEDIFICIO, t5.CZONA CZONA, t5.EZONA EZONA, t6.CPLANTA CPLANTA, t6.EPLANTA EPLANTA, t7.CESPACIO CESPACIO, t7.EESPACIO EESPACIO, t8.CCLASE CCLASE, t8.ECLASE ECLASE, t9.CCODIGO CCODIGO, t9.ECODIGO ECODIGO ");
		query.append(", t1.EJECUTADO, t1.TIEMPO_REAL ");
		query.append(" FROM PARTES t1, DEPARTAMENTOS t2, DIRECCIONES t3, EDIFICIOS t4, ZONAS t5, PLANTAS t6, ESPACIO t7, CLASE t8, CODIGO t9, PARTETECNICOS t10, TECNICOS t11, EDIFICIOSVER t12 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapListCorr(partes,
				startsWith, sUIDUsuario);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.IDDEPAR=t2.IDDEPAR(+) AND t1.IDDIR=t3.IDDIR(+) and t3.baja=0 AND t1.IDEDIFICIO=t4.IDEDIFICIO(+) AND t1.IDZONA=t5.IDZONA(+) AND t1.IDPLANTA=t6.IDPLANTA(+) AND t1.IDESPACIO=t7.IDESPACIO(+) AND t1.IDCLASE=t8.IDCLASE(+) AND t1.IDCODIGO=t9.IDCODIGO(+) AND t1.IDPARTE=t10.IDPARTE(+) AND t10.IDTECNICO=t11.IDTECNICO(+) AND t1.IDEDIFICIO=t12.IDEDIFICIO ");

		// Filtros de los checks marcados
		Boolean bEjecutado = false;
		Boolean bPendConTec = false;
		Boolean bPendSinTec = false;
		if (partes != null && partes.getEjecutado() != null
				&& partes.getEjecutado().equals("1")) {
			bEjecutado = true;
		}
		if (partes != null && partes.getPendConTec() != null
				&& partes.getPendConTec().equals("1")) {
			bPendConTec = true;
		}
		if (partes != null && partes.getPendSinTec() != null
				&& partes.getPendSinTec().equals("1")) {
			bPendSinTec = true;
		}

		if (bEjecutado) {
			if (bPendConTec) {
				if (bPendSinTec) {
					// Todos los partes
				} else {
					// partes ejecutados y con técnicos asignados
					where.append(" AND (t1.EJECUTADO='1' AND t1.IDPARTE=t10.IDPARTE) ");
				}
			} else {
				if (bPendSinTec) {
					// partes ejecutados y sin técnicos asignados
					where.append(" AND (t1.EJECUTADO='1' AND t1.IDPARTE not in (Select t10.IDPARTE FROM PARTETECNICOS t10)) ");
				} else {
					// partes ejecutados
					where.append(" AND (t1.EJECUTADO='1') ");
				}
			}
		} else {
			if (bPendConTec) {
				if (bPendSinTec) {
					// todos los partes que estén pendientes
					where.append(" AND (t1.EJECUTADO<>'1') ");
				} else {
					// partes con técnicos asignados
					where.append(" AND t1.EJECUTADO<>'1' AND t1.IDPARTE=t10.IDPARTE ");
				}
			} else {
				if (bPendSinTec) {
					// partes sin técnicos asignados
					where.append(" AND t1.EJECUTADO<>'1' AND t1.IDPARTE not in (Select t10.IDPARTE FROM PARTETECNICOS t10) ");
				} else {
					// todos los partes
				}
			}
		}

		where.append(mapaWhere.get("query"));
		query.append(where);
		query.append(" GROUP BY t1.IDPARTE, t1.FECHARE ,t1.NOMBRE ,t1.IDDEPAR ,t1.IDDIR ,t1.IDEDIFICIO ,t1.IDZONA , t1.IDPLANTA , t1.FECHAPLANIF, t4.REDIFICIO || '/' ||  CASE WHEN t5.RZONA='0' THEN '' ELSE t5.RZONA END || '/' || CASE WHEN t6.RPLANTA='0' THEN '' ELSE t6.RPLANTA END, t1.INT_EXT , t1.IDESPACIO , t1.IDCLASE , t1.IDCODIGO , t1.OBSERV , t1.IDACTUAC , t1.AVERIA_REPE, t1.IDPARTE, t1.AVERIA_REPE , t1.VIP, t1.URGENTE, t1.ENVIO_MAIL , t2.CIDEPAR , t2.CDEPAR , t2.EDEPAR , t3.CIDIR , t3.CDIR , t3.EDIR , t3.CODESTR_US , t4.CEDIFICIO , t4.EEDIFICIO , t5.CZONA , t5.EZONA , t6.CPLANTA , t6.EPLANTA , t7.CESPACIO , t7.EESPACIO , t8.CCLASE , t8.ECLASE , t9.CCODIGO , t9.ECODIGO, t1.EJECUTADO, t1.TIEMPO_REAL ");
		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Partes>) this.jdbcTemplate.query(query.toString(),
				this.rwMapObtenerListCorrGrid, params.toArray());
	}

	@Transactional(readOnly = true)
	public List<Partes> obtenerDatosAgendaGrid(Partes partes,
			Pagination pagination, Boolean startsWith, String sUIDUsuario,
			boolean conTecnicos, List<Tecnicos> listaTecnicosBusq) {

		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDPARTE IDPARTE, t1.NOMBRE NOMBRE, t1.FECHARE FECHARE, t1.FECHAPLANIF FECHAPLANIF, t1.IDDEPAR IDDEPAR,t1.IDDIR IDDIR,t1.IDEDIFICIO IDEDIFICIO,t1.IDZONA IDZONA,t1.IDPLANTA IDPLANTA ");
		query.append(", t1.IDESPACIO IDESPACIO,t1.IDCLASE IDCLASE,t1.IDCODIGO IDCODIGO,t1.OBSERV OBSERV,t1.IDACTUAC IDACTUAC, t1.VIP VIP, t1.URGENTE URGENTE, t1.ENVIO_MAIL ENVIOMAIL ");
		query.append(", t2.CIDEPAR CIDEPAR, t2.CDEPAR CDEPAR, t2.EDEPAR EDEPAR, t3.CIDIR CIDIR, t3.CDIR CDIR, t3.EDIR EDIR, t3.CODESTR_US CODESTR_US, t4.CEDIFICIO CEDIFICIO, t4.EEDIFICIO EEDIFICIO, t5.CZONA CZONA, t5.EZONA EZONA, t6.CPLANTA CPLANTA, t6.EPLANTA EPLANTA, t7.CESPACIO CESPACIO, t7.EESPACIO EESPACIO, t8.CCLASE CCLASE, t8.ECLASE ECLASE, t9.CCODIGO CCODIGO, t9.ECODIGO ECODIGO ");
		if (conTecnicos) {
			query.append(", t10.FINAL FINAL,t10.IDTECNICO IDTECNICO, t10.IDPARTEC IDPARTEC, t11.MOVILGMAO MOVILGMAO, t11.TECNICO_CONTRATA TECNICO_CONTRATA, t11.NOMBRE NOMBRETEC ");
			query.append(", t13.IDPARTE IDPARTEGMAO, t13.ESTADOGMAO ESTADOGMAO, t13.FECHAESTADO FECHAESTADO ");
			query.append(", (select count(*) from partetecnicos where idparte = t1.idparte) as COMPARTIDO ");
		}
		query.append(", t1.EJECUTADO, t1.TIEMPO_REAL ");
		if (conTecnicos) {
			query.append(" FROM PARTES t1, DEPARTAMENTOS t2, DIRECCIONES t3, EDIFICIOS t4, ZONAS t5, PLANTAS t6, ESPACIO t7, CLASE t8, CODIGO t9, PARTETECNICOS t10, TECNICOS t11, EDIFICIOSVER t12, PARTETECNICOSGMAO t13 ");
		} else {
			query.append(" FROM PARTES t1, DEPARTAMENTOS t2, DIRECCIONES t3, EDIFICIOS t4, ZONAS t5, PLANTAS t6, ESPACIO t7, CLASE t8, CODIGO t9, EDIFICIOSVER t12 ");
		}

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapListAgenda(partes,
				startsWith, sUIDUsuario, conTecnicos);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.IDDEPAR=t2.IDDEPAR(+) AND t1.IDDIR=t3.IDDIR(+) AND t1.IDEDIFICIO=t4.IDEDIFICIO(+) AND t1.IDZONA=t5.IDZONA(+) AND t1.IDPLANTA=t6.IDPLANTA(+) AND t1.IDESPACIO=t7.IDESPACIO(+) AND t1.IDCLASE=t8.IDCLASE(+) AND t1.IDCODIGO=t9.IDCODIGO(+) AND t1.IDEDIFICIO=t12.IDEDIFICIO ");
		if (conTecnicos) {
			where.append(" AND t1.IDPARTE=t10.IDPARTE(+) AND t10.IDTECNICO=t11.IDTECNICO(+) AND t10.IDPARTEC=t13.IDPARTEC(+) AND t11.BAJA = 0 AND t10.IDTECNICO IN ");
			where.append(" (");
			for (int i = 0; i < listaTecnicosBusq.size(); i++) {
				Tecnicos tecnicoAux = new Tecnicos();
				tecnicoAux = listaTecnicosBusq.get(i);
				if (tecnicoAux != null && tecnicoAux.getIdtecnico() != null) {
					if (i != 0) {
						where.append(",");
					}
					where.append(tecnicoAux.getIdtecnico());
				}
			}
			where.append(")");
		} else {
			where.append(" AND t1.IDPARTE not in (Select t16.IDPARTE FROM PARTETECNICOS t16) ");
		}

		where.append("   ");

		where.append(mapaWhere.get("query"));
		query.append(where);
		if (conTecnicos) {
			query.append(" ORDER BY t10.IDTECNICO asc ");
		} else {
			query.append(" ORDER BY t1.IDPARTE asc ");
		}

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		if (conTecnicos) {
			return (List<Partes>) this.jdbcTemplate.query(query.toString(),
					this.rwMapObtenerDatosAgendaGrid, params.toArray());
		} else {
			return (List<Partes>) this.jdbcTemplate.query(query.toString(),
					this.rwMapObtenerDatosAgendaSinAsignarGrid,
					params.toArray());
		}

	}

	@Transactional(readOnly = true)
	public List<Partes> obtenerPartesConsultaUsuNormalGrid(Partes partes,
			Pagination pagination, Boolean startsWith, String sUIDUsuario) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDPARTE IDPARTE,t1.FECHARE FECHARE,t1.NOMBRE NOMBRE,t1.IDDEPAR IDDEPAR,t1.IDDIR IDDIR,t1.IDEDIFICIO IDEDIFICIO,t1.IDZONA IDZONA,t1.IDPLANTA IDPLANTA,t1.INT_EXT INTEXT,t1.IDESPACIO IDESPACIO,t1.IDCLASE IDCLASE,t1.IDCODIGO IDCODIGO,t1.OBSERV OBSERV,t1.IDACTUAC IDACTUAC, CASE WHEN t1.AVERIA_REPE=0 THEN t1.IDPARTE ELSE t1.AVERIA_REPE END as REPE, t1.AVERIA_REPE AVERIAREPE, t1.VIP VIP,t1.URGENTE URGENTE, t1.ENVIO_MAIL ENVIOMAIL, t1.FECHAPLANIF FECHAPLANIF ");
		query.append(", t2.CIDEPAR CIDEPAR, t2.CDEPAR CDEPAR, t2.EDEPAR EDEPAR, t3.CIDIR CIDIR, t3.CDIR CDIR, t3.EDIR EDIR, t3.CODESTR_US CODESTR_US, t4.CEDIFICIO CEDIFICIO, t4.EEDIFICIO EEDIFICIO, t5.CZONA CZONA, t5.EZONA EZONA, t6.CPLANTA CPLANTA, t6.EPLANTA EPLANTA, t7.CESPACIO CESPACIO, t7.EESPACIO EESPACIO, t8.CCLASE CCLASE, t8.ECLASE ECLASE, t9.CCODIGO CCODIGO, t9.ECODIGO ECODIGO ");
		query.append(" FROM PARTES t1, DEPARTAMENTOS t2, DIRECCIONES t3, EDIFICIOS t4, ZONAS t5, PLANTAS t6, ESPACIO t7, CLASE t8, CODIGO t9  ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapConsultaPartesUsuNormal(
				partes, startsWith, sUIDUsuario);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.IDDEPAR=t2.IDDEPAR(+) AND t1.IDDIR=t3.IDDIR(+) AND t1.IDEDIFICIO=t4.IDEDIFICIO(+) AND t1.IDZONA=t5.IDZONA(+) AND t1.IDPLANTA=t6.IDPLANTA(+) AND t1.IDESPACIO=t7.IDESPACIO(+) AND t1.IDCLASE=t8.IDCLASE(+) AND t1.IDCODIGO=t9.IDCODIGO(+) ");

		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Partes>) this.jdbcTemplate.query(query.toString(),
				this.rwMapObtenerParteGrid, params.toArray());
	}

	/**
	 * Finds rows in the Partes table using like.
	 * 
	 * @param partes
	 *            Partes
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Partes> obtenerListEjecTecnicoGrid(Partes partes,
			Pagination pagination, Boolean startsWith, String sUIDUsuario) {

		StringBuilder query = new StringBuilder(
				"SELECT t1.IDPARTE IDPARTE, t11.NOMBRE AS TECNICOS, t1.NOMBRE  AS NOMBRE, t1.FECHARE FECHARE, t1.FECHAEJ FECHAEJ,t1.IDDEPAR IDDEPAR,t1.IDDIR IDDIR,t1.IDEDIFICIO IDEDIFICIO,t1.IDZONA IDZONA,t1.IDPLANTA IDPLANTA,t1.IDCLASE IDCLASE, t1.FECHAPLANIF FECHAPLANIF,t1.IDCODIGO IDCODIGO, t8.CCLASE CCLASE, t8.ECLASE ECLASE, t4.CEDIFICIO CEDIFICIO, t4.EEDIFICIO EEDIFICIO, t5.EZONA EZONA, t5.CZONA CZONA, t9.CCODIGO CCODIGO, t9.ECODIGO ECODIGO, t2.CDEPAR CDEPAR, t2.EDEPAR EDEPAR, t6.CPLANTA || '/' || t7.CESPACIO AS CPLANTA, t6.EPLANTA || '/' || t7.EESPACIO AS EPLANTA, t4.REDIFICIO || '/' ||  CASE WHEN t5.RZONA='0' THEN '' ELSE t5.RZONA END || '/' || CASE WHEN t6.RPLANTA='0' THEN '' ELSE t6.RPLANTA END as LOCAL, t3.CDIR CDIR, t3.EDIR EDIR, t1.OBSERV OBSERV, t10.TIEMPOREAL TIEMPOREAL, nvl(t10.FINAL,0) FINALIZADO, MAX(t13.FEFIN) AS FECHAEJMAX ");
		query.append(" FROM PARTES t1, DEPARTAMENTOS t2, DIRECCIONES t3, EDIFICIOS t4, ZONAS t5, PLANTAS t6, ESPACIO t7, CLASE t8, CODIGO t9, PARTETECNICOS t10, TECNICOS t11, EDIFICIOSVER t12, PARTEEJECUCION t13 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapListEjecTecnico(partes,
				startsWith, sUIDUsuario);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.IDDEPAR=t2.IDDEPAR(+) AND t1.IDDIR=t3.IDDIR(+) AND t1.IDEDIFICIO=t4.IDEDIFICIO(+) AND t1.IDZONA=t5.IDZONA(+) AND t1.IDPLANTA=t6.IDPLANTA(+) AND t1.IDESPACIO=t7.IDESPACIO(+) AND t1.IDCLASE=t8.IDCLASE(+) AND t1.IDCODIGO=t9.IDCODIGO(+) AND t1.IDPARTE=t10.IDPARTE AND t10.IDPARTEC=t13.IDPARTEC(+) AND t10.IDTECNICO=t11.IDTECNICO(+) AND t1.IDEDIFICIO=t12.IDEDIFICIO ");
		where.append(" AND t10.TIEMPOREAL>0 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		query.append(" GROUP BY t1.IDPARTE, t11.NOMBRE , t1.NOMBRE, t1.TELEFO, t1.FECHARE, t1.FECHAEJ,t1.IDDEPAR, t1.IDDIR, t1.IDEDIFICIO, t1.IDZONA, t1.IDPLANTA, t1.IDCLASE, t1.FECHAPLANIF,t1.IDCODIGO, t8.CCLASE, t8.ECLASE, t4.CEDIFICIO, t4.EEDIFICIO, t5.EZONA, t5.CZONA, t9.CCODIGO, t9.ECODIGO, t2.CDEPAR, t2.EDEPAR, t6.CPLANTA || '/' || t7.CESPACIO, t6.EPLANTA || '/' || t7.EESPACIO, t4.REDIFICIO || '/' ||  CASE WHEN t5.RZONA='0' THEN '' ELSE t5.RZONA END || '/' || CASE WHEN t6.RPLANTA='0' THEN '' ELSE t6.RPLANTA END, t3.CDIR, t3.EDIR, t1.OBSERV, t10.TIEMPOREAL, t10.FINAL ");

		if (partes != null
				&& (partes.getFechareD() != null
						&& !partes.getFechareD().equals("") || partes
						.getFechareH() != null
						&& !partes.getFechareH().equals(""))) {
			query.append(" having 1=1 ");
		}

		if (partes != null && partes.getFechareD() != null
				&& !partes.getFechareD().equals("")) {
			query.append(" AND MAX(t13.FEFIN) >= ? ");
		}
		if (partes != null && partes.getFechareH() != null
				&& !partes.getFechareH().equals("")) {
			query.append(" AND MAX(t13.FEFIN) < ? + 1");
		}

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Partes>) this.jdbcTemplate.query(query.toString(),
				this.rwMapObtenerListEjecTecnicoGrid, params.toArray());
	}

	/**
	 * Finds rows in the Partes table using like.
	 * 
	 * @param partes
	 *            Partes
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Partes> obtenerListEjecFechaEjGrid(Partes partes,
			Pagination pagination, Boolean startsWith, String sUIDUsuario) {

		StringBuilder query = new StringBuilder(
				"SELECT MAX(t13.FEFIN) AS FECHAEJMAX, t1.IDPARTE IDPARTE, t11.NOMBRE AS TECNICOS, t1.NOMBRE  AS NOMBRE, t1.FECHARE FECHARE, t1.FECHAEJ FECHAEJ,t1.IDDEPAR IDDEPAR,t1.IDDIR IDDIR,t1.IDEDIFICIO IDEDIFICIO,t1.IDZONA IDZONA,t1.IDPLANTA IDPLANTA,t1.IDCLASE IDCLASE,t1.IDCODIGO IDCODIGO, t1.FECHAPLANIF FECHAPLANIF, t8.CCLASE CCLASE, t8.ECLASE ECLASE, t4.CEDIFICIO CEDIFICIO, t4.EEDIFICIO EEDIFICIO, t5.EZONA EZONA, t5.CZONA CZONA, t9.CCODIGO CCODIGO, t9.ECODIGO ECODIGO, t2.CDEPAR CDEPAR, t2.EDEPAR EDEPAR, t6.CPLANTA || '/' || t7.CESPACIO AS CPLANTA, t6.EPLANTA || '/' || t7.EESPACIO AS EPLANTA, t4.REDIFICIO || '/' ||  CASE WHEN t5.RZONA='0' THEN '' ELSE t5.RZONA END || '/' || CASE WHEN t6.RPLANTA='0' THEN '' ELSE t6.RPLANTA END as LOCAL, t3.CDIR CDIR, t3.EDIR EDIR, t1.OBSERV OBSERV, t10.TIEMPOREAL TIEMPOREAL, nvl(t10.FINAL,0) FINALIZADO");
		query.append(" FROM PARTES t1, DEPARTAMENTOS t2, DIRECCIONES t3, EDIFICIOS t4, ZONAS t5, PLANTAS t6, ESPACIO t7, CLASE t8, CODIGO t9, PARTETECNICOS t10, TECNICOS t11, EDIFICIOSVER t12, PARTEEJECUCION t13 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapListEjecTecnico(partes,
				startsWith, sUIDUsuario);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.IDDEPAR=t2.IDDEPAR(+) AND t1.IDDIR=t3.IDDIR(+) AND t1.IDEDIFICIO=t4.IDEDIFICIO(+) AND t1.IDZONA=t5.IDZONA(+) AND t1.IDPLANTA=t6.IDPLANTA(+) AND t1.IDESPACIO=t7.IDESPACIO(+) AND t1.IDCLASE=t8.IDCLASE(+) AND t1.IDCODIGO=t9.IDCODIGO(+) AND t1.IDPARTE=t10.IDPARTE AND t10.IDPARTEC=t13.IDPARTEC(+) AND t10.IDTECNICO=t11.IDTECNICO(+) AND t1.IDEDIFICIO=t12.IDEDIFICIO ");

		where.append(mapaWhere.get("query"));
		query.append(where);
		query.append(" GROUP BY t1.IDPARTE, t11.NOMBRE , t1.NOMBRE, t1.TELEFO, t1.FECHARE, t1.FECHAEJ,t1.IDDEPAR, t1.IDDIR, t1.IDEDIFICIO, t1.IDZONA, t1.IDPLANTA, t1.IDCLASE, t1.IDCODIGO, t1.FECHAPLANIF, t8.CCLASE, t8.ECLASE, t4.CEDIFICIO, t4.EEDIFICIO, t5.EZONA, t5.CZONA, t9.CCODIGO, t9.ECODIGO, t2.CDEPAR, t2.EDEPAR, t6.CPLANTA || '/' || t7.CESPACIO, t6.EPLANTA || '/' || t7.EESPACIO, t4.REDIFICIO || '/' ||  CASE WHEN t5.RZONA='0' THEN '' ELSE t5.RZONA END || '/' || CASE WHEN t6.RPLANTA='0' THEN '' ELSE t6.RPLANTA END, t3.CDIR, t3.EDIR, t1.OBSERV, t10.TIEMPOREAL, t10.FINAL ");
		query.append(" having MAX(t13.FEFIN) is not null ");

		if (partes != null && partes.getFechareD() != null
				&& !partes.getFechareD().equals("")) {
			query.append(" AND MAX(t13.FEFIN) >= ? ");
		}
		if (partes != null && partes.getFechareH() != null
				&& !partes.getFechareH().equals("")) {
			query.append(" AND MAX(t13.FEFIN) < ? + 1");
		}

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Partes>) this.jdbcTemplate.query(query.toString(),
				this.rwMapObtenerListEjecTecnicoGrid, params.toArray());
	}

	/**
	 * Finds rows in the Partes table using like.
	 * 
	 * @param partes
	 *            Partes
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param UIDUsuario
	 *            String
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Partes> obtenerCorrPendAsignar(Partes partes,
			Pagination pagination, Boolean startsWith, String UIDUsuario) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDPARTE IDPARTE, '' as TECNICOS, t1.FECHARE FECHARE,t1.NOMBRE NOMBRE,t1.IDDEPAR IDDEPAR,t1.IDDIR IDDIR,t1.IDEDIFICIO IDEDIFICIO,t1.IDZONA IDZONA,t1.IDPLANTA IDPLANTA,t1.INT_EXT INTEXT,t1.IDESPACIO IDESPACIO,t1.IDCLASE IDCLASE,t1.IDCODIGO IDCODIGO,t1.OBSERV OBSERV,t1.IDACTUAC IDACTUAC, CASE WHEN t1.AVERIA_REPE=0  THEN t1.IDPARTE ELSE t1.AVERIA_REPE END as REPE, t1.AVERIA_REPE AVERIAREPE, t1.VIP VIP, t1.URGENTE URGENTE, t1.ENVIO_MAIL ENVIOMAIL, t1.FECHAPLANIF FECHAPLANIF ");
		query.append(", t2.CIDEPAR CIDEPAR, t2.CDEPAR CDEPAR, t2.EDEPAR EDEPAR, t3.CIDIR CIDIR, t3.CDIR CDIR, t3.EDIR EDIR, t3.CODESTR_US CODESTR_US, t4.CEDIFICIO CEDIFICIO, t4.EEDIFICIO EEDIFICIO, t5.CZONA CZONA, t5.EZONA EZONA, t6.CPLANTA CPLANTA, t6.EPLANTA EPLANTA, t7.CESPACIO CESPACIO, t7.EESPACIO EESPACIO, t8.CCLASE CCLASE, t8.ECLASE ECLASE, t9.CCODIGO CCODIGO, t9.ECODIGO ECODIGO ");
		query.append(" FROM PARTES t1,  EDIFICIOSVER t10 , DEPARTAMENTOS t2, DIRECCIONES t3, EDIFICIOS t4, ZONAS t5, PLANTAS t6, ESPACIO t7, CLASE t8, CODIGO t9 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapPartesPend(partes,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE  t1.IDEDIFICIO=t10.IDEDIFICIO AND t10.UID_PER='"
						+ UIDUsuario
						+ "' AND (t1.AVERIA_REPE IS NULL "
						+ " OR t1.AVERIA_REPE=0) "
						+ " AND t1.IDPARTE NOT  IN (SELECT DISTINCT t3.IDPARTE FROM PARTETECNICOS t3) "
						+ "AND t1.IDDEPAR=t2.IDDEPAR(+) AND t1.IDDIR=t3.IDDIR(+) AND t1.IDEDIFICIO=t4.IDEDIFICIO(+) AND t1.IDZONA=t5.IDZONA(+) AND t1.IDPLANTA=t6.IDPLANTA(+) AND t1.IDESPACIO=t7.IDESPACIO(+) AND t1.IDCLASE=t8.IDCLASE(+) AND t1.IDCODIGO=t9.IDCODIGO(+)  ");

		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Partes>) this.jdbcTemplate.query(query.toString(),
				this.rwMapObtenerParteGridPend, params.toArray());
	}

	/**
	 * Finds rows in the Partes table using like.
	 * 
	 * @param partes
	 *            Partes
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param UIDUsuario
	 *            String
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Partes> obtenerCorrAut(Partes partes, Pagination pagination,
			Boolean startsWith, String UIDUsuario) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDPARTE IDPARTE,  (RTRIM(XMLAGG(xmlelement(X, t12.NOMBRE  || ',') ORDER BY t12.NOMBRE).extract('//text()'), ',')) AS TECNICOS ,t1.FECHARE FECHARE,t1.NOMBRE NOMBRE,t1.IDDEPAR IDDEPAR,t1.IDDIR IDDIR,t1.IDEDIFICIO IDEDIFICIO,t1.IDZONA IDZONA,t1.IDPLANTA IDPLANTA,t1.INT_EXT INTEXT,t1.IDESPACIO IDESPACIO,t1.IDCLASE IDCLASE,t1.IDCODIGO IDCODIGO,t1.OBSERV OBSERV,t1.IDACTUAC IDACTUAC, CASE WHEN t1.AVERIA_REPE=0  THEN t1.IDPARTE ELSE t1.AVERIA_REPE END as REPE, t1.AVERIA_REPE AVERIAREPE, t1.VIP VIP, t1.URGENTE URGENTE, t1.ENVIO_MAIL ENVIOMAIL, t1.FECHAPLANIF FECHAPLANIF ");
		query.append(", t2.CIDEPAR CIDEPAR, t2.CDEPAR CDEPAR, t2.EDEPAR EDEPAR, t3.CIDIR CIDIR, t3.CDIR CDIR, t3.EDIR EDIR, t3.CODESTR_US CODESTR_US, t4.CEDIFICIO CEDIFICIO, t4.EEDIFICIO EEDIFICIO, t5.CZONA CZONA, t5.EZONA EZONA, t6.CPLANTA CPLANTA, t6.EPLANTA EPLANTA, t7.CESPACIO CESPACIO, t7.EESPACIO EESPACIO, t8.CCLASE CCLASE, t8.ECLASE ECLASE, t9.CCODIGO CCODIGO, t9.ECODIGO ECODIGO ");
		query.append(" FROM PARTES t1,  EDIFICIOSVER t10 , DEPARTAMENTOS t2, DIRECCIONES t3, EDIFICIOS t4, ZONAS t5, PLANTAS t6, ESPACIO t7, CLASE t8, CODIGO t9, PARTETECNICOS t11, TECNICOS t12  ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapPartesPend(partes,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE  t1.IDEDIFICIO=t10.IDEDIFICIO AND t10.UID_PER='"
						+ UIDUsuario
						+ "' AND (t1.AVERIA_REPE IS NULL "
						+ " OR t1.AVERIA_REPE=0) "
						+ " AND t1.AUTOMATICA=1 "
						+ " AND (t1.EJECUTADO=0 or t1.EJECUTADO is null) "
						+ " AND t1.IDDEPAR=t2.IDDEPAR(+) AND t1.IDDIR=t3.IDDIR(+) AND t1.IDEDIFICIO=t4.IDEDIFICIO(+) AND t1.IDZONA=t5.IDZONA(+) AND t1.IDPLANTA=t6.IDPLANTA(+) AND t1.IDESPACIO=t7.IDESPACIO(+) AND t1.IDCLASE=t8.IDCLASE(+) AND t1.IDCODIGO=t9.IDCODIGO(+)  ");
		where.append(" AND t1.IDPARTE=t11.IDPARTE AND t11.IDTECNICO =t12.IDTECNICO(+) ");

		where.append(mapaWhere.get("query"));
		query.append(where);
		query.append(" GROUP BY t1.IDPARTE,t1.FECHARE ,t1.NOMBRE ,t1.IDDEPAR ,t1.IDDIR ,t1.IDEDIFICIO ,t1.IDZONA ,t1.IDPLANTA ,t1.INT_EXT ,t1.IDESPACIO ,t1.IDCLASE ,t1.IDCODIGO ,t1.OBSERV ,t1.IDACTUAC , t1.AVERIA_REPE,t1.IDPARTE, t1.AVERIA_REPE , t1.VIP, t1.URGENTE, t1.ENVIO_MAIL , t1.FECHAPLANIF, t2.CIDEPAR , t2.CDEPAR , t2.EDEPAR , t3.CIDIR , t3.CDIR , t3.EDIR , t3.CODESTR_US , t4.CEDIFICIO , t4.EEDIFICIO , t5.CZONA , t5.EZONA , t6.CPLANTA , t6.EPLANTA , t7.CESPACIO , t7.EESPACIO , t8.CCLASE , t8.ECLASE , t9.CCODIGO , t9.ECODIGO ");

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Partes>) this.jdbcTemplate.query(query.toString(),
				this.rwMapObtenerParteGridPend, params.toArray());
	}

	/**
	 * Finds rows in the Partes table using like.
	 * 
	 * @param partes
	 *            Partes
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param UIDUsuario
	 *            String
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Partes> obtenerCorrMan(Partes partes, Pagination pagination,
			Boolean startsWith, String UIDUsuario) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDPARTE IDPARTE, (RTRIM(XMLAGG(xmlelement(X, t12.NOMBRE  || ',') ORDER BY t12.NOMBRE).extract('//text()'), ',')) AS TECNICOS ,t1.FECHARE FECHARE,t1.NOMBRE NOMBRE,t1.IDDEPAR IDDEPAR,t1.IDDIR IDDIR,t1.IDEDIFICIO IDEDIFICIO,t1.IDZONA IDZONA,t1.IDPLANTA IDPLANTA,t1.INT_EXT INTEXT,t1.IDESPACIO IDESPACIO,t1.IDCLASE IDCLASE,t1.IDCODIGO IDCODIGO,t1.OBSERV OBSERV,t1.IDACTUAC IDACTUAC, CASE WHEN t1.AVERIA_REPE=0  THEN t1.IDPARTE ELSE t1.AVERIA_REPE END as REPE, t1.AVERIA_REPE AVERIAREPE, t1.VIP VIP, t1.URGENTE URGENTE, t1.ENVIO_MAIL ENVIOMAIL, t1.FECHAPLANIF FECHAPLANIF ");
		query.append(", t2.CIDEPAR CIDEPAR, t2.CDEPAR CDEPAR, t2.EDEPAR EDEPAR, t3.CIDIR CIDIR, t3.CDIR CDIR, t3.EDIR EDIR, t3.CODESTR_US CODESTR_US, t4.CEDIFICIO CEDIFICIO, t4.EEDIFICIO EEDIFICIO, t5.CZONA CZONA, t5.EZONA EZONA, t6.CPLANTA CPLANTA, t6.EPLANTA EPLANTA, t7.CESPACIO CESPACIO, t7.EESPACIO EESPACIO, t8.CCLASE CCLASE, t8.ECLASE ECLASE, t9.CCODIGO CCODIGO, t9.ECODIGO ECODIGO ");
		query.append(" FROM PARTES t1,  EDIFICIOSVER t10 , DEPARTAMENTOS t2, DIRECCIONES t3, EDIFICIOS t4, ZONAS t5, PLANTAS t6, ESPACIO t7, CLASE t8, CODIGO t9, PARTETECNICOS t11, TECNICOS t12  ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapPartesPend(partes,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE  t1.IDEDIFICIO=t10.IDEDIFICIO AND t10.UID_PER='"
						+ UIDUsuario
						+ "' AND (t1.AVERIA_REPE IS NULL "
						+ " OR t1.AVERIA_REPE=0) "
						+ " AND (t1.AUTOMATICA=0 or t1.AUTOMATICA is null) "
						+ " AND (t1.EJECUTADO=0 or t1.EJECUTADO is null) "
						+ " AND t1.IDDEPAR=t2.IDDEPAR(+) AND t1.IDDIR=t3.IDDIR(+) AND t1.IDEDIFICIO=t4.IDEDIFICIO(+) AND t1.IDZONA=t5.IDZONA(+) AND t1.IDPLANTA=t6.IDPLANTA(+) AND t1.IDESPACIO=t7.IDESPACIO(+) AND t1.IDCLASE=t8.IDCLASE(+) AND t1.IDCODIGO=t9.IDCODIGO(+)  ");
		where.append(" AND t1.IDPARTE=t11.IDPARTE AND t11.IDTECNICO =t12.IDTECNICO(+) ");

		where.append(mapaWhere.get("query"));
		query.append(where);

		query.append(" GROUP BY t1.IDPARTE,t1.FECHARE ,t1.NOMBRE ,t1.IDDEPAR ,t1.IDDIR ,t1.IDEDIFICIO ,t1.IDZONA ,t1.IDPLANTA ,t1.INT_EXT ,t1.IDESPACIO ,t1.IDCLASE ,t1.IDCODIGO ,t1.OBSERV ,t1.IDACTUAC , t1.AVERIA_REPE,t1.IDPARTE, t1.AVERIA_REPE , t1.VIP, t1.URGENTE, t1.ENVIO_MAIL , t1.FECHAPLANIF, t2.CIDEPAR , t2.CDEPAR , t2.EDEPAR , t3.CIDIR , t3.CDIR , t3.EDIR , t3.CODESTR_US , t4.CEDIFICIO , t4.EEDIFICIO , t5.CZONA , t5.EZONA , t6.CPLANTA , t6.EPLANTA , t7.CESPACIO , t7.EESPACIO , t8.CCLASE , t8.ECLASE , t9.CCODIGO , t9.ECODIGO ");
		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Partes>) this.jdbcTemplate.query(query.toString(),
				this.rwMapObtenerParteGridPend, params.toArray());
	}

	/**
	 * Counts rows in the Partes table using like.
	 * 
	 * @param partes
	 *            Partes
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Partes partes, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM PARTES t1, DEPARTAMENTOS t2, DIRECCIONES t3, EDIFICIOS t4, ZONAS t5, PLANTAS t6, ESPACIO t7, CLASE t8, CODIGO t9  ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(partes, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.IDDEPAR=t2.IDDEPAR(+) AND t1.IDDIR=t3.IDDIR(+) AND t1.IDEDIFICIO=t4.IDEDIFICIO(+) AND t1.IDZONA=t5.IDZONA(+) AND t1.IDPLANTA=t6.IDPLANTA(+) AND t1.IDESPACIO=t7.IDESPACIO(+) AND t1.IDCLASE=t8.IDCLASE(+) AND t1.IDCODIGO=t9.IDCODIGO(+)  ");

		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Calcula el numero de partes correctivos pendientes de asignar tecnico.
	 * 
	 * @param UIDUsuario
	 *            String
	 * @param idServicio
	 *            Integer
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long calculaCorrPendAPT(String UIDUsuario, Integer idServicio,
			Integer idClase) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(DISTINCT t1.IDPARTE) FROM PARTES t1, EDIFICIOSVER t2, CODIGO t3 ");

		StringBuilder where = new StringBuilder(
				" WHERE t1.IDEDIFICIO=t2.IDEDIFICIO AND t1.IDCODIGO=t3.IDCODIGO  AND t2.UID_PER=? ");
		if (idServicio != null && idServicio != 0) {
			where.append(" AND t3.IDSERVICIO=? ");
		}

		if (idClase != null && idClase.intValue() > 0) {
			where.append(" AND t1.IDCLASE = " + idClase.intValue());
		}
		where.append(" AND (t1.AVERIA_REPE IS NULL OR t1.AVERIA_REPE=0)  ");
		where.append(" AND ((t1.EJECUTADO = '0' OR t1.EJECUTADO is null) OR (t1.EJECUTADO = '1' AND t1.NOPROCEDE is null)) ");
		where.append(" AND t1.IDPARTE NOT  IN   (SELECT DISTINCT t4.IDPARTE FROM PARTETECNICOS t4 ) ");
		query.append(where);
		Long total = (long) 0;

		if (idServicio != null && idServicio != 0) {
			total = this.jdbcTemplate.queryForLong(query.toString(),
					UIDUsuario, idServicio);
		} else {
			total = this.jdbcTemplate
					.queryForLong(query.toString(), UIDUsuario);
		}

		return total;
	}

	/**
	 * Calcula el numero de partes correctivos asignados automaticamente y
	 * pendientes de ejecutar.
	 * 
	 * @param UIDUsuario
	 *            String
	 * @param idServicio
	 *            Integer
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long calculaCorrAsigAut(String UIDUsuario, Integer idServicio,
			Integer idClase) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(DISTINCT t1.IDPARTE) FROM PARTES t1, EDIFICIOSVER t2, PARTETECNICOS t3, CODIGO t4  ");

		StringBuilder where = new StringBuilder(
				" WHERE t1.IDEDIFICIO=t2.IDEDIFICIO AND t1.IDCODIGO=t4.IDCODIGO AND t1.IDPARTE=t3.IDPARTE AND t2.UID_PER=? ");
		if (idServicio != null && idServicio != 0) {
			where.append(" AND t4.IDSERVICIO=? ");
		}
		if (idClase != null && idClase.intValue() > 0) {
			where.append(" AND t1.IDCLASE = " + idClase.intValue());
		}
		where.append(" AND (t1.AVERIA_REPE IS NULL OR t1.AVERIA_REPE=0)  ");
		where.append(" AND (t1.EJECUTADO=0 or t1.EJECUTADO is null)  AND t1.AUTOMATICA=1 ");
		query.append(where);

		Long total = (long) 0;

		if (idServicio != null && idServicio != 0) {
			total = this.jdbcTemplate.queryForLong(query.toString(),
					UIDUsuario, idServicio);
		} else {
			total = this.jdbcTemplate
					.queryForLong(query.toString(), UIDUsuario);
		}
		return total;
	}

	/**
	 * Calcula el numero de partes correctivos asignados manualmente y
	 * pendientes de ejecutar.
	 * 
	 * @param UIDUsuario
	 *            String
	 * @param idServicio
	 *            Integer
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long calculaCorrAsigMan(String UIDUsuario, Integer idServicio,
			Integer idClase) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(DISTINCT T1.IDPARTE) FROM PARTES t1, EDIFICIOSVER t2, PARTETECNICOS t3, CODIGO t4 ");

		StringBuilder where = new StringBuilder(
				" WHERE t1.IDEDIFICIO=t2.IDEDIFICIO AND t1.IDCODIGO=t4.IDCODIGO AND t1.IDPARTE=t3.IDPARTE AND t2.UID_PER=? ");
		if (idServicio != null && idServicio != 0) {
			where.append(" AND t4.IDSERVICIO=? ");
		}
		if (idClase != null && idClase.intValue() > 0) {
			where.append(" AND t1.IDCLASE = " + idClase.intValue());
		}
		where.append(" AND (t1.AVERIA_REPE IS NULL OR t1.AVERIA_REPE=0)  ");
		where.append(" AND (t1.EJECUTADO=0 or t1.EJECUTADO is null) AND (t1.AUTOMATICA=0 or t1.AUTOMATICA is null) ");
		query.append(where);

		Long total = (long) 0;

		if (idServicio != null && idServicio != 0) {
			total = this.jdbcTemplate.queryForLong(query.toString(),
					UIDUsuario, idServicio);
		} else {
			total = this.jdbcTemplate
					.queryForLong(query.toString(), UIDUsuario);
		}
		return total;
	}

	/**
	 * Obtiene el valor de una variable de la tabla VARIABLES_CORREO(AA2036T00)
	 * 
	 * @param variableCorreo
	 *            String
	 * @return String
	 */
	@Transactional(readOnly = true)
	public String obtenerVariableCorreo(String variableCorreo) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.VALOR VALOR FROM VARIABLES_CORREO t1 WHERE t1.VARIABLE=? ");

		return this.jdbcTemplate.queryForObject(query.toString(),
				new Object[] { variableCorreo }, String.class);

	}

	/**
	 * Counts rows in the Partes table using like.
	 * 
	 * @param partes
	 *            Partes
	 * @param startsWith
	 *            Boolean
	 * @param sUIDUsuario
	 *            String
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long obtenerPartesGridCount(Partes partes, Boolean startsWith,
			String sUIDUsuario) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM PARTES t1, DEPARTAMENTOS t2, DIRECCIONES t3, EDIFICIOS t4, ZONAS t5, PLANTAS t6, ESPACIO t7, CLASE t8, CODIGO t9, EDIFICIOSVER t12  ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapPartes(partes,
				startsWith, sUIDUsuario);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.IDDEPAR=t2.IDDEPAR(+) AND t1.IDDIR=t3.IDDIR(+) AND t1.IDEDIFICIO=t4.IDEDIFICIO(+) AND t1.IDZONA=t5.IDZONA(+) AND t1.IDPLANTA=t6.IDPLANTA(+) AND t1.IDESPACIO=t7.IDESPACIO(+) AND t1.IDCLASE=t8.IDCLASE(+) AND t1.IDCODIGO=t9.IDCODIGO(+) AND t1.IDEDIFICIO=t12.IDEDIFICIO ");

		if (partes != null && partes.getTecnicos() != null
				&& partes.getTecnicos().trim().length() > 0) {
			query.append(", PARTETECNICOS t10, TECNICOS t11 ");
			where.append(" AND t1.IDPARTE=t10.IDPARTE(+) AND t10.IDTECNICO=t11.IDTECNICO(+) ");
		}

		// Si viene la marca conTecnicos aÃ±adir la tabla PARTETECNICOS
		if (partes != null && partes.getConTecnicos() != null
				&& partes.getConTecnicos().equals("1")) {
			where.append(" AND t1.IDPARTE in (Select t13.IDPARTE FROM PARTETECNICOS t13) ");
		} else if (partes != null && partes.getConTecnicos() != null
				&& partes.getConTecnicos().equals("0")) {
			where.append(" AND t1.IDPARTE not in (Select t13.IDPARTE FROM PARTETECNICOS t13) ");
		}

		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	@Transactional(readOnly = true)
	public Long obtenerPartesConsultaUsuNormalGridCount(Partes partes,
			Boolean startsWith, String sUIDUsuario) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM PARTES t1, DEPARTAMENTOS t2, DIRECCIONES t3, EDIFICIOS t4, ZONAS t5, PLANTAS t6, ESPACIO t7, CLASE t8, CODIGO t9  ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapConsultaPartesUsuNormal(
				partes, startsWith, sUIDUsuario);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.IDDEPAR=t2.IDDEPAR(+) AND t1.IDDIR=t3.IDDIR(+) AND t1.IDEDIFICIO=t4.IDEDIFICIO(+) AND t1.IDZONA=t5.IDZONA(+) AND t1.IDPLANTA=t6.IDPLANTA(+) AND t1.IDESPACIO=t7.IDESPACIO(+) AND t1.IDCLASE=t8.IDCLASE(+) AND t1.IDCODIGO=t9.IDCODIGO(+) ");

		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Partes table using like.
	 * 
	 * @param partes
	 *            Partes
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long obtenerListCorrGridCount(Partes partes, Boolean startsWith,
			String sUIDUsuario) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM (SELECT  t1.IDPARTE IDPARTE, (RTRIM(XMLAGG(xmlelement(X, t11.NOMBRE || ',') ORDER BY t11.NOMBRE).extract('//text()'), ',')) AS TECNICOS, t1.FECHARE FECHARE,t1.NOMBRE NOMBRE,t1.IDDEPAR IDDEPAR,t1.IDDIR IDDIR,t1.IDEDIFICIO IDEDIFICIO,t1.IDZONA IDZONA,t1.IDPLANTA IDPLANTA ");
		query.append(", t4.REDIFICIO || '/' ||  CASE WHEN t5.RZONA='0' THEN '' ELSE t5.RZONA END || '/' || CASE WHEN t6.RPLANTA='0' THEN '' ELSE t6.RPLANTA END as LOCAL ");
		query.append(", t1.INT_EXT INTEXT,t1.IDESPACIO IDESPACIO,t1.IDCLASE IDCLASE,t1.IDCODIGO IDCODIGO,t1.OBSERV OBSERV,t1.IDACTUAC IDACTUAC, CASE WHEN t1.AVERIA_REPE=0  THEN t1.IDPARTE ELSE t1.AVERIA_REPE END as REPE, t1.AVERIA_REPE AVERIAREPE, t1.VIP VIP, t1.URGENTE URGENTE, t1.ENVIO_MAIL ENVIOMAIL ");
		query.append(", t2.CIDEPAR CIDEPAR, t2.CDEPAR CDEPAR, t2.EDEPAR EDEPAR, t3.CIDIR CIDIR, t3.CDIR CDIR, t3.EDIR EDIR, t3.CODESTR_US CODESTR_US, t4.CEDIFICIO CEDIFICIO, t4.EEDIFICIO EEDIFICIO, t5.CZONA CZONA, t5.EZONA EZONA, t6.CPLANTA CPLANTA, t6.EPLANTA EPLANTA, t7.CESPACIO CESPACIO, t7.EESPACIO EESPACIO, t8.CCLASE CCLASE, t8.ECLASE ECLASE, t9.CCODIGO CCODIGO, t9.ECODIGO ECODIGO ");
		query.append(", t1.EJECUTADO, t1.TIEMPO_REAL ");
		query.append(" FROM PARTES t1, DEPARTAMENTOS t2, DIRECCIONES t3, EDIFICIOS t4, ZONAS t5, PLANTAS t6, ESPACIO t7, CLASE t8, CODIGO t9, PARTETECNICOS t10, TECNICOS t11, EDIFICIOSVER t12 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapListCorr(partes,
				startsWith, sUIDUsuario);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.IDDEPAR=t2.IDDEPAR(+) AND t1.IDDIR=t3.IDDIR(+) AND t1.IDEDIFICIO=t4.IDEDIFICIO(+) AND t1.IDZONA=t5.IDZONA(+) AND t1.IDPLANTA=t6.IDPLANTA(+) AND t1.IDESPACIO=t7.IDESPACIO(+) AND t1.IDCLASE=t8.IDCLASE(+) AND t1.IDCODIGO=t9.IDCODIGO(+) AND t1.IDPARTE=t10.IDPARTE(+) AND t10.IDTECNICO=t11.IDTECNICO(+) AND t1.IDEDIFICIO=t12.IDEDIFICIO ");

		// Filtros de los checks marcados
		Boolean bEjecutado = false;
		Boolean bPendConTec = false;
		Boolean bPendSinTec = false;
		if (partes != null && partes.getEjecutado() != null
				&& partes.getEjecutado().equals("1")) {
			bEjecutado = true;
		}
		if (partes != null && partes.getPendConTec() != null
				&& partes.getPendConTec().equals("1")) {
			bPendConTec = true;
		}
		if (partes != null && partes.getPendSinTec() != null
				&& partes.getPendSinTec().equals("1")) {
			bPendSinTec = true;
		}

		if (bEjecutado) {
			if (bPendConTec) {
				if (bPendSinTec) {
					// Todos los partes
				} else {
					// partes ejecutados y con técnicos asignados
					where.append(" AND (t1.EJECUTADO='1' AND t1.IDPARTE=t10.IDPARTE) ");
				}
			} else {
				if (bPendSinTec) {
					// partes ejecutados y sin técnicos asignados
					where.append(" AND (t1.EJECUTADO='1' AND t1.IDPARTE not in (Select t10.IDPARTE FROM PARTETECNICOS t10)) ");
				} else {
					// partes ejecutados
					where.append(" AND (t1.EJECUTADO='1') ");
				}
			}
		} else {
			if (bPendConTec) {
				if (bPendSinTec) {
					// todos los partes que estén pendientes
					where.append(" AND (t1.EJECUTADO<>'1') ");
				} else {
					// partes con técnicos asignados
					where.append(" AND t1.EJECUTADO<>'1' AND t1.IDPARTE=t10.IDPARTE ");
				}
			} else {
				if (bPendSinTec) {
					// partes sin técnicos asignados
					where.append(" AND t1.EJECUTADO<>'1' AND t1.IDPARTE not in (Select t10.IDPARTE FROM PARTETECNICOS t10) ");
				} else {
					// todos los partes
				}
			}
		}

		where.append(mapaWhere.get("query"));
		query.append(where);
		query.append(" GROUP BY t1.IDPARTE, t1.FECHARE ,t1.NOMBRE ,t1.IDDEPAR ,t1.IDDIR ,t1.IDEDIFICIO ,t1.IDZONA , t1.IDPLANTA , t4.REDIFICIO || '/' ||  CASE WHEN t5.RZONA='0' THEN '' ELSE t5.RZONA END || '/' || CASE WHEN t6.RPLANTA='0' THEN '' ELSE t6.RPLANTA END, t1.INT_EXT , t1.IDESPACIO , t1.IDCLASE , t1.IDCODIGO , t1.OBSERV , t1.IDACTUAC , t1.AVERIA_REPE, t1.IDPARTE, t1.AVERIA_REPE , t1.VIP , t1.URGENTE, t1.ENVIO_MAIL , t2.CIDEPAR , t2.CDEPAR , t2.EDEPAR , t3.CIDIR , t3.CDIR , t3.EDIR , t3.CODESTR_US , t4.CEDIFICIO , t4.EEDIFICIO , t5.CZONA , t5.EZONA , t6.CPLANTA , t6.EPLANTA , t7.CESPACIO , t7.EESPACIO , t8.CCLASE , t8.ECLASE , t9.CCODIGO , t9.ECODIGO, t1.EJECUTADO, t1.TIEMPO_REAL) ");

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Partes table using like.
	 * 
	 * @param partes
	 *            Partes
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long obtenerListEjecTecnicoGridCount(Partes partes,
			Boolean startsWith, String sUIDUsuario) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.IDPARTE IDPARTE, t11.NOMBRE AS TECNICOS, t1.NOMBRE  AS NOMBRE, t1.FECHARE FECHARE, t1.FECHAEJ FECHAEJ, t8.CCLASE CCLASE, t8.ECLASE ECLASE, t4.CEDIFICIO CEDIFICIO, t4.EEDIFICIO EEDIFICIO, t5.EZONA EZONA, t5.CZONA CZONA, t9.CCODIGO CCODIGO, t9.ECODIGO ECODIGO, t2.CDEPAR CDEPAR, t2.EDEPAR EDEPAR, t6.CPLANTA || '/' || t7.CESPACIO AS CPLANTA, t6.EPLANTA || '/' || t7.EESPACIO AS EPLANTA, t3.CDIR CDIR, t3.EDIR EDIR, t1.OBSERV OBSERV, t10.TIEMPOREAL TIEMPOREAL, t10.FINAL FINALIZADO, MAX(t13.FEFIN) AS FECHAEJMAX ");
		query.append(" FROM PARTES t1, DEPARTAMENTOS t2, DIRECCIONES t3, EDIFICIOS t4, ZONAS t5, PLANTAS t6, ESPACIO t7, CLASE t8, CODIGO t9, PARTETECNICOS t10, TECNICOS t11, EDIFICIOSVER t12, PARTEEJECUCION t13 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapListEjecTecnico(partes,
				startsWith, sUIDUsuario);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.IDDEPAR=t2.IDDEPAR(+) AND t1.IDDIR=t3.IDDIR(+) AND t1.IDEDIFICIO=t4.IDEDIFICIO(+) AND t1.IDZONA=t5.IDZONA(+) AND t1.IDPLANTA=t6.IDPLANTA(+) AND t1.IDESPACIO=t7.IDESPACIO(+) AND t1.IDCLASE=t8.IDCLASE(+) AND t1.IDCODIGO=t9.IDCODIGO(+) AND t1.IDPARTE=t10.IDPARTE AND t10.IDPARTEC=t13.IDPARTEC(+) AND t10.IDTECNICO=t11.IDTECNICO(+) AND t1.IDEDIFICIO=t12.IDEDIFICIO ");
		where.append(" AND t10.TIEMPOREAL>0 ");

		where.append(mapaWhere.get("query"));
		query.append(where);
		query.append(" GROUP BY t1.IDPARTE, t11.NOMBRE , t1.NOMBRE, t1.TELEFO, t1.FECHARE, t1.FECHAEJ, t8.CCLASE, t8.ECLASE, t4.CEDIFICIO, t4.EEDIFICIO, t5.EZONA, t5.CZONA, t9.CCODIGO, t9.ECODIGO, t2.CDEPAR, t2.EDEPAR, t6.CPLANTA || '/' || t7.CESPACIO, t6.EPLANTA || '/' || t7.EESPACIO, t3.CDIR, t3.EDIR, t1.OBSERV, t10.TIEMPOREAL, t10.FINAL ");

		if (partes != null
				&& (partes.getFechareD() != null
						&& !partes.getFechareD().equals("") || partes
						.getFechareH() != null
						&& !partes.getFechareH().equals(""))) {
			query.append(" having 1=1 ");
		}

		if (partes != null && partes.getFechareD() != null
				&& !partes.getFechareD().equals("")) {
			query.append(" AND MAX(t13.FEFIN) >= ? ");
		}
		if (partes != null && partes.getFechareH() != null
				&& !partes.getFechareH().equals("")) {
			query.append(" AND MAX(t13.FEFIN) < ? + 1");
		}

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(
				"SELECT COUNT(1) from (" + query.toString() + ")",
				params.toArray());
	}

	/**
	 * Counts rows in the Partes table using like.
	 * 
	 * @param partes
	 *            Partes
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long obtenerListEjecFechaEjGridCount(Partes partes,
			Boolean startsWith, String sUIDUsuario) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.IDPARTE IDPARTE, t11.NOMBRE AS TECNICOS, t1.NOMBRE  AS NOMBRE, t1.FECHARE FECHARE, t1.FECHAEJ FECHAEJ, t8.CCLASE CCLASE, t8.ECLASE ECLASE, t4.CEDIFICIO CEDIFICIO, t4.EEDIFICIO EEDIFICIO, t5.EZONA EZONA, t5.CZONA CZONA, t9.CCODIGO CCODIGO, t9.ECODIGO ECODIGO, t2.CDEPAR CDEPAR, t2.EDEPAR EDEPAR, t6.CPLANTA || '/' || t7.CESPACIO AS CPLANTA, t6.EPLANTA || '/' || t7.EESPACIO AS EPLANTA, t3.CDIR CDIR, t3.EDIR EDIR, t1.OBSERV OBSERV, t10.TIEMPOREAL TIEMPOREAL, t10.FINAL FINALIZADO, MAX(TRUNC(t13.FEFIN)) AS FECHAEJMAX ");
		query.append(" FROM PARTES t1, DEPARTAMENTOS t2, DIRECCIONES t3, EDIFICIOS t4, ZONAS t5, PLANTAS t6, ESPACIO t7, CLASE t8, CODIGO t9, PARTETECNICOS t10, TECNICOS t11, EDIFICIOSVER t12, PARTEEJECUCION t13 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapListEjecTecnico(partes,
				startsWith, sUIDUsuario);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.IDDEPAR=t2.IDDEPAR(+) AND t1.IDDIR=t3.IDDIR(+) AND t1.IDEDIFICIO=t4.IDEDIFICIO(+) AND t1.IDZONA=t5.IDZONA(+) AND t1.IDPLANTA=t6.IDPLANTA(+) AND t1.IDESPACIO=t7.IDESPACIO(+) AND t1.IDCLASE=t8.IDCLASE(+) AND t1.IDCODIGO=t9.IDCODIGO(+) AND t1.IDPARTE=t10.IDPARTE AND t10.IDPARTEC=t13.IDPARTEC(+) AND t10.IDTECNICO=t11.IDTECNICO(+) AND t1.IDEDIFICIO=t12.IDEDIFICIO ");

		where.append(mapaWhere.get("query"));
		query.append(where);
		query.append(" GROUP BY t1.IDPARTE, t11.NOMBRE , t1.NOMBRE, t1.TELEFO, t1.FECHARE, t1.FECHAEJ, t8.CCLASE, t8.ECLASE, t4.CEDIFICIO, t4.EEDIFICIO, t5.EZONA, t5.CZONA, t9.CCODIGO, t9.ECODIGO, t2.CDEPAR, t2.EDEPAR, t6.CPLANTA || '/' || t7.CESPACIO, t6.EPLANTA || '/' || t7.EESPACIO, t3.CDIR, t3.EDIR, t1.OBSERV, t10.TIEMPOREAL, t10.FINAL ");
		query.append(" having MAX(t13.FEFIN) is not null ");

		if (partes != null && partes.getFechareD() != null
				&& !partes.getFechareD().equals("")) {
			query.append(" AND MAX(t13.FEFIN) >= ? ");
		}
		if (partes != null && partes.getFechareH() != null
				&& !partes.getFechareH().equals("")) {
			query.append(" AND MAX(t13.FEFIN) < ? + 1");
		}

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(
				"SELECT COUNT(1) from (" + query.toString() + ")",
				params.toArray());
	}

	/**
	 * Counts rows in the Partes table using like.
	 * 
	 * @param partes
	 *            Partes
	 * @param startsWith
	 *            Boolean
	 * @param UIDUsuario
	 *            String
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long obtenerCorrPendAsignarCount(Partes partes, Boolean startsWith,
			String UIDUsuario) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM PARTES t1,  EDIFICIOSVER t10, DEPARTAMENTOS t2, DIRECCIONES t3, EDIFICIOS t4, ZONAS t5, PLANTAS t6, ESPACIO t7, CLASE t8, CODIGO t9  ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapPartesPend(partes,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE  t1.IDEDIFICIO=t10.IDEDIFICIO AND t10.UID_PER='"
						+ UIDUsuario
						+ "' AND (t1.AVERIA_REPE IS NULL "
						+ " OR t1.AVERIA_REPE=0) "
						+ " AND t1.IDPARTE NOT  IN (SELECT DISTINCT tt.IDPARTE FROM PARTETECNICOS tt) "
						+ "AND t1.IDDEPAR=t2.IDDEPAR(+) AND t1.IDDIR=t3.IDDIR(+) AND t1.IDEDIFICIO=t4.IDEDIFICIO(+) AND t1.IDZONA=t5.IDZONA(+) AND t1.IDPLANTA=t6.IDPLANTA(+) AND t1.IDESPACIO=t7.IDESPACIO(+) AND t1.IDCLASE=t8.IDCLASE(+) AND t1.IDCODIGO=t9.IDCODIGO(+)  ");

		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Partes table using like.
	 * 
	 * @param partes
	 *            Partes
	 * @param startsWith
	 *            Boolean
	 * @param UIDUsuario
	 *            String
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long obtenerCorrAutCount(Partes partes, Boolean startsWith,
			String UIDUsuario) {

		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM (SELECT  t1.IDPARTE IDPARTE,  (RTRIM(XMLAGG(xmlelement(X, t12.NOMBRE  || ',') ORDER BY t12.NOMBRE).extract('//text()'), ',')) AS TECNICOS ,t1.FECHARE FECHARE,t1.NOMBRE NOMBRE,t1.IDDEPAR IDDEPAR,t1.IDDIR IDDIR,t1.IDEDIFICIO IDEDIFICIO,t1.IDZONA IDZONA,t1.IDPLANTA IDPLANTA,t1.INT_EXT INTEXT,t1.IDESPACIO IDESPACIO,t1.IDCLASE IDCLASE,t1.IDCODIGO IDCODIGO,t1.OBSERV OBSERV,t1.IDACTUAC IDACTUAC, CASE WHEN t1.AVERIA_REPE=0  THEN t1.IDPARTE ELSE t1.AVERIA_REPE END as REPE, t1.AVERIA_REPE AVERIAREPE, t1.VIP VIP, t1.URGENTE URGENTE, t1.ENVIO_MAIL ENVIOMAIL ");
		query.append(", t2.CIDEPAR CIDEPAR, t2.CDEPAR CDEPAR, t2.EDEPAR EDEPAR, t3.CIDIR CIDIR, t3.CDIR CDIR, t3.EDIR EDIR, t3.CODESTR_US CODESTR_US, t4.CEDIFICIO CEDIFICIO, t4.EEDIFICIO EEDIFICIO, t5.CZONA CZONA, t5.EZONA EZONA, t6.CPLANTA CPLANTA, t6.EPLANTA EPLANTA, t7.CESPACIO CESPACIO, t7.EESPACIO EESPACIO, t8.CCLASE CCLASE, t8.ECLASE ECLASE, t9.CCODIGO CCODIGO, t9.ECODIGO ECODIGO ");
		query.append(" FROM PARTES t1,  EDIFICIOSVER t10 , DEPARTAMENTOS t2, DIRECCIONES t3, EDIFICIOS t4, ZONAS t5, PLANTAS t6, ESPACIO t7, CLASE t8, CODIGO t9, PARTETECNICOS t11, TECNICOS t12  ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapPartesPend(partes,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE  t1.IDEDIFICIO=t10.IDEDIFICIO AND t10.UID_PER='"
						+ UIDUsuario
						+ "' AND (t1.AVERIA_REPE IS NULL "
						+ " OR t1.AVERIA_REPE=0) "
						+ " AND t1.AUTOMATICA=1 "
						+ " AND (t1.EJECUTADO=0 or t1.EJECUTADO is null) "
						+ " AND t1.IDDEPAR=t2.IDDEPAR(+) AND t1.IDDIR=t3.IDDIR(+) AND t1.IDEDIFICIO=t4.IDEDIFICIO(+) AND t1.IDZONA=t5.IDZONA(+) AND t1.IDPLANTA=t6.IDPLANTA(+) AND t1.IDESPACIO=t7.IDESPACIO(+) AND t1.IDCLASE=t8.IDCLASE(+) AND t1.IDCODIGO=t9.IDCODIGO(+)  ");
		where.append(" AND t1.IDPARTE=t11.IDPARTE AND t11.IDTECNICO =t12.IDTECNICO(+) ");

		where.append(mapaWhere.get("query"));
		query.append(where);
		query.append(" GROUP BY t1.IDPARTE,t1.FECHARE ,t1.NOMBRE ,t1.IDDEPAR ,t1.IDDIR ,t1.IDEDIFICIO ,t1.IDZONA ,t1.IDPLANTA ,t1.INT_EXT ,t1.IDESPACIO ,t1.IDCLASE ,t1.IDCODIGO ,t1.OBSERV ,t1.IDACTUAC , t1.AVERIA_REPE,t1.IDPARTE, t1.AVERIA_REPE , t1.VIP, t1.URGENTE, t1.ENVIO_MAIL , t2.CIDEPAR , t2.CDEPAR , t2.EDEPAR , t3.CIDIR , t3.CDIR , t3.EDIR , t3.CODESTR_US , t4.CEDIFICIO , t4.EEDIFICIO , t5.CZONA , t5.EZONA , t6.CPLANTA , t6.EPLANTA , t7.CESPACIO , t7.EESPACIO , t8.CCLASE , t8.ECLASE , t9.CCODIGO , t9.ECODIGO) ");

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Partes table using like.
	 * 
	 * @param partes
	 *            Partes
	 * @param startsWith
	 *            Boolean
	 * @param UIDUsuario
	 *            String
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long obtenerCorrManCount(Partes partes, Boolean startsWith,
			String UIDUsuario) {

		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM (SELECT  t1.IDPARTE IDPARTE, (RTRIM(XMLAGG(xmlelement(X, t12.NOMBRE  || ',') ORDER BY t12.NOMBRE).extract('//text()'), ',')) AS TECNICOS ,t1.FECHARE FECHARE,t1.NOMBRE NOMBRE,t1.IDDEPAR IDDEPAR,t1.IDDIR IDDIR,t1.IDEDIFICIO IDEDIFICIO,t1.IDZONA IDZONA,t1.IDPLANTA IDPLANTA,t1.INT_EXT INTEXT,t1.IDESPACIO IDESPACIO,t1.IDCLASE IDCLASE,t1.IDCODIGO IDCODIGO,t1.OBSERV OBSERV,t1.IDACTUAC IDACTUAC, CASE WHEN t1.AVERIA_REPE=0  THEN t1.IDPARTE ELSE t1.AVERIA_REPE END as REPE, t1.AVERIA_REPE AVERIAREPE, t1.VIP VIP, t1.URGENTE URGENTE, t1.ENVIO_MAIL ENVIOMAIL ");
		query.append(", t2.CIDEPAR CIDEPAR, t2.CDEPAR CDEPAR, t2.EDEPAR EDEPAR, t3.CIDIR CIDIR, t3.CDIR CDIR, t3.EDIR EDIR, t3.CODESTR_US CODESTR_US, t4.CEDIFICIO CEDIFICIO, t4.EEDIFICIO EEDIFICIO, t5.CZONA CZONA, t5.EZONA EZONA, t6.CPLANTA CPLANTA, t6.EPLANTA EPLANTA, t7.CESPACIO CESPACIO, t7.EESPACIO EESPACIO, t8.CCLASE CCLASE, t8.ECLASE ECLASE, t9.CCODIGO CCODIGO, t9.ECODIGO ECODIGO ");
		query.append(" FROM PARTES t1,  EDIFICIOSVER t10 , DEPARTAMENTOS t2, DIRECCIONES t3, EDIFICIOS t4, ZONAS t5, PLANTAS t6, ESPACIO t7, CLASE t8, CODIGO t9, PARTETECNICOS t11, TECNICOS t12  ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapPartesPend(partes,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE  t1.IDEDIFICIO=t10.IDEDIFICIO AND t10.UID_PER='"
						+ UIDUsuario
						+ "' AND (t1.AVERIA_REPE IS NULL "
						+ " OR t1.AVERIA_REPE=0) "
						+ " AND (t1.AUTOMATICA=0 or t1.AUTOMATICA is null) "
						+ " AND (t1.EJECUTADO=0 or t1.EJECUTADO is null) "
						+ " AND t1.IDDEPAR=t2.IDDEPAR(+) AND t1.IDDIR=t3.IDDIR(+) AND t1.IDEDIFICIO=t4.IDEDIFICIO(+) AND t1.IDZONA=t5.IDZONA(+) AND t1.IDPLANTA=t6.IDPLANTA(+) AND t1.IDESPACIO=t7.IDESPACIO(+) AND t1.IDCLASE=t8.IDCLASE(+) AND t1.IDCODIGO=t9.IDCODIGO(+)  ");
		where.append(" AND t1.IDPARTE=t11.IDPARTE AND t11.IDTECNICO =t12.IDTECNICO(+) ");

		where.append(mapaWhere.get("query"));
		query.append(where);

		query.append(" GROUP BY t1.IDPARTE,t1.FECHARE ,t1.NOMBRE ,t1.IDDEPAR ,t1.IDDIR ,t1.IDEDIFICIO ,t1.IDZONA ,t1.IDPLANTA ,t1.INT_EXT ,t1.IDESPACIO ,t1.IDCLASE ,t1.IDCODIGO ,t1.OBSERV ,t1.IDACTUAC , t1.AVERIA_REPE,t1.IDPARTE, t1.AVERIA_REPE , t1.VIP, t1.URGENTE, t1.ENVIO_MAIL , t2.CIDEPAR , t2.CDEPAR , t2.EDEPAR , t3.CIDIR , t3.CDIR , t3.EDIR , t3.CODESTR_US , t4.CEDIFICIO , t4.EEDIFICIO , t5.CZONA , t5.EZONA , t6.CPLANTA , t6.EPLANTA , t7.CESPACIO , t7.EESPACIO , t8.CCLASE , t8.ECLASE , t9.CCODIGO , t9.ECODIGO )");

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds a List of rows in the Ficha table.
	 * 
	 * @param filtro
	 *            Partes
	 * @param idioma
	 *            String
	 * @param UIDUsuario
	 *            String
	 * @return ArrayList
	 */
	@Transactional(readOnly = true)
	public ArrayList<TablaInformes> montarSelectTablaCorrPendAsignar(
			String idioma, Partes filtro, String UIDUsuario) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDPARTE IDPARTE, '' as TECNICOS, t1.FECHARE FECHARE, t1.FECHAEJ FECHAEJ ");
		query.append(", t8.CCLASE CCLASE, t8.ECLASE ECLASE, t9.CCODIGO CCODIGO, t9.ECODIGO ECODIGO, t1.OBSERV OBSERV  ");
		query.append(" FROM PARTES t1,  EDIFICIOSVER t10 , ZONAS t5, PLANTAS t6, CLASE t8, CODIGO t9 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereLikeMapPartesPend(filtro, false);
		StringBuilder where = new StringBuilder(
				" WHERE  t1.IDEDIFICIO=t10.IDEDIFICIO AND t10.UID_PER='"
						+ UIDUsuario
						+ "' AND (t1.AVERIA_REPE IS NULL "
						+ " OR t1.AVERIA_REPE=0) "
						+ " AND t1.IDPARTE NOT  IN (SELECT DISTINCT t3.IDPARTE FROM PARTETECNICOS t3) "
						+ " AND t1.IDCLASE=t8.IDCLASE(+) AND t1.IDCODIGO=t9.IDCODIGO(+) AND t1.IDZONA=t5.IDZONA(+) AND t1.IDPLANTA=t6.IDPLANTA(+) ");

		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return (ArrayList<TablaInformes>) this.jdbcTemplate.query(
				query.toString(), this.rwMapTablaInformes, params.toArray());
	}

	/**
	 * Finds a List of rows in the Ficha table.
	 * 
	 * @param filtro
	 *            Partes
	 * @param idioma
	 *            String
	 * @param UIDUsuario
	 *            String
	 * @return ArrayList
	 */
	@Transactional(readOnly = true)
	public ArrayList<TablaInformes> montarSelectTablaCorrPendEjecManual(
			String idioma, Partes filtro, String UIDUsuario) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDPARTE IDPARTE, (RTRIM(XMLAGG(xmlelement(X, t12.NOMBRE  || ', ') ORDER BY t12.NOMBRE).extract('//text()'), ',')) as TECNICOS, t1.FECHARE FECHARE, t1.FECHAEJ FECHAEJ ");
		query.append(", t8.CCLASE CCLASE, t8.ECLASE ECLASE, t9.CCODIGO CCODIGO, t9.ECODIGO ECODIGO, t1.OBSERV OBSERV  ");
		query.append(" FROM PARTES t1,  EDIFICIOSVER t10 , ZONAS t5, PLANTAS t6 , CLASE t8, CODIGO t9, PARTETECNICOS t11, TECNICOS t12 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereLikeMapPartesPend(filtro, false);
		StringBuilder where = new StringBuilder(
				" WHERE  t1.IDEDIFICIO=t10.IDEDIFICIO AND t10.UID_PER='"
						+ UIDUsuario
						+ "' AND (t1.AVERIA_REPE IS NULL OR t1.AVERIA_REPE=0) "
						+ " AND (t1.EJECUTADO=0 or t1.EJECUTADO is null) AND (t1.AUTOMATICA=0 or t1.AUTOMATICA is null)  "
						+ " AND t1.IDCLASE=t8.IDCLASE(+) AND t1.IDCODIGO=t9.IDCODIGO(+)  ");
		where.append(" AND t1.IDPARTE=t11.IDPARTE(+) AND t11.IDTECNICO =t12.IDTECNICO(+) AND t1.IDZONA=t5.IDZONA(+) AND t1.IDPLANTA=t6.IDPLANTA(+) ");

		where.append(mapaWhere.get("query"));
		query.append(where);

		query.append(" GROUP BY t1.IDPARTE, t1.FECHARE , t1.FECHAEJ ,t8.CCLASE , t8.ECLASE , t9.CCODIGO , t9.ECODIGO , t1.OBSERV ");
		List<?> params = (List<?>) mapaWhere.get("params");

		return (ArrayList<TablaInformes>) this.jdbcTemplate.query(
				query.toString(), this.rwMapTablaInformes, params.toArray());
	}

	/**
	 * Finds a List of rows in the Ficha table.
	 * 
	 * @param filtro
	 *            Partes
	 * @param idioma
	 *            String
	 * @param UIDUsuario
	 *            String
	 * @return ArrayList
	 */
	@Transactional(readOnly = true)
	public ArrayList<TablaInformes> montarSelectTablaCorrPendEjecAuto(
			String idioma, Partes filtro, String UIDUsuario) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDPARTE IDPARTE, (RTRIM(XMLAGG(xmlelement(X, t12.NOMBRE  || ', ') ORDER BY t12.NOMBRE).extract('//text()'), ',')) as TECNICOS, t1.FECHARE FECHARE, t1.FECHAEJ FECHAEJ ");
		query.append(", t8.CCLASE CCLASE, t8.ECLASE ECLASE, t9.CCODIGO CCODIGO, t9.ECODIGO ECODIGO, t1.OBSERV OBSERV  ");
		query.append(" FROM PARTES t1,  EDIFICIOSVER t10 , ZONAS t5, PLANTAS t6 , CLASE t8, CODIGO t9, PARTETECNICOS t11, TECNICOS t12 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereLikeMapPartesPend(filtro, false);
		StringBuilder where = new StringBuilder(
				" WHERE  t1.IDEDIFICIO=t10.IDEDIFICIO AND t10.UID_PER='"
						+ UIDUsuario
						+ "' AND (t1.AVERIA_REPE IS NULL OR t1.AVERIA_REPE=0) "
						+ " AND t1.AUTOMATICA=1 "
						+ " AND (t1.EJECUTADO=0 or t1.EJECUTADO is null) "
						+ " AND t1.IDCLASE=t8.IDCLASE(+) AND t1.IDCODIGO=t9.IDCODIGO(+)  ");
		where.append(" AND t1.IDPARTE=t11.IDPARTE(+) AND t11.IDTECNICO =t12.IDTECNICO(+) AND t1.IDZONA=t5.IDZONA(+) AND t1.IDPLANTA=t6.IDPLANTA(+) ");

		where.append(mapaWhere.get("query"));
		query.append(where);

		query.append(" GROUP BY t1.IDPARTE, t1.FECHARE , t1.FECHAEJ ,t8.CCLASE , t8.ECLASE , t9.CCODIGO , t9.ECODIGO , t1.OBSERV ");
		List<?> params = (List<?>) mapaWhere.get("params");

		return (ArrayList<TablaInformes>) this.jdbcTemplate.query(
				query.toString(), this.rwMapTablaInformes, params.toArray());
	}

	/**
	 * Finds a List of rows in the Ficha table.
	 * 
	 * @param idioma
	 *            String
	 * @param partes
	 *            Partes
	 * @param UIDUsuario
	 *            String
	 * @return ArrayList
	 */
	@Transactional(readOnly = true)
	public ArrayList<TablaInformes> montarSelectTablaCorrectivos(String idioma,
			Partes partes, String UIDUsuario) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDPARTE IDPARTE, t11.NOMBRE AS TECNICOS, t1.NOMBRE AS NOMBRE, t1.TELEFO AS TELEFO, t1.FECHARE FECHARE,t1.FECHAEJ FECHAEJ,t8.CCLASE CCLASE, t8.ECLASE ECLASE,t4.CEDIFICIO CEDIFICIO, t4.EEDIFICIO EEDIFICIO, t5.EZONA EZONA,t5.CZONA CZONA, t9.CCODIGO CCODIGO, t9.ECODIGO ECODIGO, t2.CDEPAR CDEPAR, t2.EDEPAR EDEPAR, t6.CPLANTA || '/' || t7.CESPACIO as CPLANTA, t6.EPLANTA || '/' || t7.EESPACIO as EPLANTA, t3.CDIR CDIR, t3.EDIR EDIR, t1.OBSERV OBSERV, t10.TIEMPOREAL TIEMPOREAL, max(t13.FEFIN) AS FECHAEJMAX");
		query.append(" FROM PARTES t1, DEPARTAMENTOS t2, DIRECCIONES t3, EDIFICIOS t4, ZONAS t5, PLANTAS t6, ESPACIO t7, CLASE t8, CODIGO t9, PARTETECNICOS t10, TECNICOS t11, EDIFICIOSVER t12, PARTEEJECUCION t13 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapListCorr(partes, false,
				UIDUsuario);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.IDDEPAR=t2.IDDEPAR(+) AND t1.IDDIR=t3.IDDIR(+) AND t1.IDEDIFICIO=t4.IDEDIFICIO(+) AND t1.IDZONA=t5.IDZONA(+) AND t1.IDPLANTA=t6.IDPLANTA(+) AND t1.IDESPACIO=t7.IDESPACIO(+) AND t1.IDCLASE=t8.IDCLASE(+) AND t1.IDCODIGO=t9.IDCODIGO(+) AND t1.IDPARTE=t10.IDPARTE(+) AND t10.IDPARTEC=t13.IDPARTEC(+) AND t10.IDTECNICO=t11.IDTECNICO(+) AND t1.IDEDIFICIO=t12.IDEDIFICIO ");

		// Filtros de los checks marcados
		Boolean bEjecutado = false;
		Boolean bPendConTec = false;
		Boolean bPendSinTec = false;
		if (partes != null && partes.getEjecutado() != null
				&& partes.getEjecutado().equals("1")) {
			bEjecutado = true;
		}
		if (partes != null && partes.getPendConTec() != null
				&& partes.getPendConTec().equals("1")) {
			bPendConTec = true;
		}
		if (partes != null && partes.getPendSinTec() != null
				&& partes.getPendSinTec().equals("1")) {
			bPendSinTec = true;
		}

		if (bEjecutado) {
			if (bPendConTec) {
				if (bPendSinTec) {
					// Todos los partes
				} else {
					// partes ejecutados y con técnicos asignados
					where.append(" AND (t1.EJECUTADO='1' AND t1.IDPARTE=t10.IDPARTE) ");
				}
			} else {
				if (bPendSinTec) {
					// partes ejecutados y sin técnicos asignados
					where.append(" AND (t1.EJECUTADO='1' AND t1.IDPARTE not in (Select t10.IDPARTE FROM PARTETECNICOS t10)) ");
				} else {
					// partes ejecutados
					where.append(" AND (t1.EJECUTADO='1') ");
				}
			}
		} else {
			if (bPendConTec) {
				if (bPendSinTec) {
					// todos los partes que estén pendientes
					where.append(" AND (t1.EJECUTADO<>'1') ");
				} else {
					// partes con técnicos asignados
					where.append(" AND t1.EJECUTADO<>'1' AND t1.IDPARTE=t10.IDPARTE ");
				}
			} else {
				if (bPendSinTec) {
					// partes sin técnicos asignados
					where.append(" AND t1.EJECUTADO<>'1' AND t1.IDPARTE not in (Select t10.IDPARTE FROM PARTETECNICOS t10) ");
				} else {
					// todos los partes
				}
			}
		}

		where.append(mapaWhere.get("query"));
		where.append(" GROUP BY t1.IDPARTE,t11.NOMBRE , t1.NOMBRE, t1.TELEFO, t1.FECHARE, t1.FECHAEJ, t8.CCLASE, t8.ECLASE, t4.CEDIFICIO, t4.EEDIFICIO, t5.EZONA, t5.CZONA, t9.CCODIGO, t9.ECODIGO, t2.CDEPAR, t2.EDEPAR, t6.CPLANTA || '/' || t7.CESPACIO, t6.EPLANTA || '/' || t7.EESPACIO, t3.CDIR, t3.EDIR, t1.OBSERV, t10.TIEMPOREAL ");
		where.append(" order by t11.NOMBRE, t1.IDPARTE");
		query.append(where);
		List<?> params = (List<?>) mapaWhere.get("params");

		return (ArrayList<TablaInformes>) this.jdbcTemplate.query(
				query.toString(), this.rwMapListadoCorrectivos,
				params.toArray());
	}

	/**
	 * Finds a List of rows in the Ficha table.
	 * 
	 * @param idioma
	 *            String
	 * @param partes
	 *            Partes
	 * @param UIDUsuario
	 *            String
	 * @return ArrayList
	 */
	@Transactional(readOnly = true)
	public ArrayList<TablaInformes> montarSelectTablaEjecTecnico(String idioma,
			Partes partes, String UIDUsuario) {
		StringBuilder query = new StringBuilder(
				"SELECT  t11.NOMBRE AS TECNICOS, t1.IDPARTE IDPARTE, t9.CCODIGO CCODIGO, t9.ECODIGO ECODIGO, t1.FECHARE FECHARE, t10.TIEMPOREAL TIEMPOREAL, nvl(t10.FINAL,0) FINALIZADO, max(t13.FEFIN) AS FECHAEJMAX");
		query.append(" FROM PARTES t1, DEPARTAMENTOS t2, DIRECCIONES t3, EDIFICIOS t4, ZONAS t5, PLANTAS t6, ESPACIO t7, CLASE t8, CODIGO t9, PARTETECNICOS t10, TECNICOS t11, EDIFICIOSVER t12, PARTEEJECUCION t13 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapListEjecTecnico(partes,
				false, UIDUsuario);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.IDDEPAR=t2.IDDEPAR(+) AND t1.IDDIR=t3.IDDIR(+) AND t1.IDEDIFICIO=t4.IDEDIFICIO(+) AND t1.IDZONA=t5.IDZONA(+) AND t1.IDPLANTA=t6.IDPLANTA(+) AND t1.IDESPACIO=t7.IDESPACIO(+) AND t1.IDCLASE=t8.IDCLASE(+) AND t1.IDCODIGO=t9.IDCODIGO(+) AND t1.IDPARTE=t10.IDPARTE AND t10.IDPARTEC=t13.IDPARTEC(+) AND t10.IDTECNICO=t11.IDTECNICO(+) AND t1.IDEDIFICIO=t12.IDEDIFICIO ");
		where.append(" AND t10.TIEMPOREAL>0 ");
		where.append(mapaWhere.get("query"));
		where.append(" GROUP BY t11.NOMBRE ,t1.IDPARTE, t9.CCODIGO, t9.ECODIGO, t1.FECHARE, t10.TIEMPOREAL , nvl(t10.FINAL,0) ");
		query.append(where);

		if (partes != null
				&& (partes.getFechareD() != null
						&& !partes.getFechareD().equals("") || partes
						.getFechareH() != null
						&& !partes.getFechareH().equals(""))) {
			query.append(" having 1=1 ");
		}

		if (partes != null && partes.getFechareD() != null
				&& !partes.getFechareD().equals("")) {
			query.append(" AND MAX(TRUNC(t13.FEFIN)) >= ? ");
		}
		if (partes != null && partes.getFechareH() != null
				&& !partes.getFechareH().equals("")) {
			query.append(" AND MAX(TRUNC(t13.FEFIN)) < ? + 1 ");
		}
		query.append(" order by t11.NOMBRE, t1.IDPARTE");

		List<?> params = (List<?>) mapaWhere.get("params");

		return (ArrayList<TablaInformes>) this.jdbcTemplate.query(
				query.toString(), this.rwMapListadoEjecTecnico,
				params.toArray());
	}

	/**
	 * Finds a List of rows in the Ficha table.
	 * 
	 * @param idioma
	 *            String
	 * @param partes
	 *            Partes
	 * @param UIDUsuario
	 *            String
	 * @return ArrayList
	 */
	@Transactional(readOnly = true)
	public ArrayList<TablaInformes> montarSelectTablaEjecFechaEj(String idioma,
			Partes partes, String UIDUsuario) {
		StringBuilder query = new StringBuilder(
				"SELECT max(TRUNC(t13.FEFIN)) AS FECHAEJMAX, t11.NOMBRE AS TECNICOS, t1.IDPARTE IDPARTE, t9.CCODIGO CCODIGO, t9.ECODIGO ECODIGO, t1.FECHARE FECHARE, t10.TIEMPOREAL TIEMPOREAL, nvl(t10.FINAL,0) FINALIZADO");
		query.append(" FROM PARTES t1, DEPARTAMENTOS t2, DIRECCIONES t3, EDIFICIOS t4, ZONAS t5, PLANTAS t6, ESPACIO t7, CLASE t8, CODIGO t9, PARTETECNICOS t10, TECNICOS t11, EDIFICIOSVER t12, PARTEEJECUCION t13 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapListEjecTecnico(partes,
				false, UIDUsuario);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.IDDEPAR=t2.IDDEPAR(+) AND t1.IDDIR=t3.IDDIR(+) AND t1.IDEDIFICIO=t4.IDEDIFICIO(+) AND t1.IDZONA=t5.IDZONA(+) AND t1.IDPLANTA=t6.IDPLANTA(+) AND t1.IDESPACIO=t7.IDESPACIO(+) AND t1.IDCLASE=t8.IDCLASE(+) AND t1.IDCODIGO=t9.IDCODIGO(+) AND t1.IDPARTE=t10.IDPARTE AND t10.IDPARTEC=t13.IDPARTEC(+) AND t10.IDTECNICO=t11.IDTECNICO(+) AND t1.IDEDIFICIO=t12.IDEDIFICIO ");

		where.append(mapaWhere.get("query"));
		where.append(" GROUP BY t11.NOMBRE ,t1.IDPARTE, t9.CCODIGO, t9.ECODIGO, t1.FECHARE, t10.TIEMPOREAL , nvl(t10.FINAL,0) ");
		where.append(" having MAX(t13.FEFIN) is not null ");

		if (partes != null && partes.getFechareD() != null
				&& !partes.getFechareD().equals("")) {
			where.append(" AND MAX(TRUNC(t13.FEFIN)) >= ? ");
		}
		if (partes != null && partes.getFechareH() != null
				&& !partes.getFechareH().equals("")) {
			where.append(" AND MAX(TRUNC(t13.FEFIN)) < ? + 1 ");
		}

		where.append(" order by max(t13.FEFIN), t1.IDPARTE, t9.CCODIGO, t11.NOMBRE ");
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return (ArrayList<TablaInformes>) this.jdbcTemplate.query(
				query.toString(), this.rwMapListadoEjecTecnico,
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Partes entity
	 * 
	 * @param partes
	 *            Partes Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - GeneraciÃ³n de cÃ³digo de UDA
	private Map<String, ?> getWhereMap(Partes partes) {

		StringBuilder where = new StringBuilder(
				PartesDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (partes != null && partes.getIdparte() != null) {
			where.append(" AND t1.IDPARTE = ?");
			params.add(partes.getIdparte());
		}
		if (partes != null && partes.getFechare() != null) {
			where.append(" AND t1.FECHARE = ?");
			params.add(partes.getFechare());
		}
		if (partes != null && partes.getNombre() != null) {
			where.append(" AND t1.NOMBRE = ?");
			params.add(partes.getNombre());
		}
		if (partes != null && partes.getTelefo() != null) {
			where.append(" AND t1.TELEFO = ?");
			params.add(partes.getTelefo());
		}
		if (partes != null && partes.getMail() != null) {
			where.append(" AND t1.MAIL = ?");
			params.add(partes.getMail());
		}
		if (partes != null && partes.getIddepar() != null) {
			where.append(" AND t1.IDDEPAR = ?");
			params.add(partes.getIddepar());
		}
		if (partes != null && partes.getIddir() != null) {
			where.append(" AND t1.IDDIR = ?");
			params.add(partes.getIddir());
		}
		if (partes != null && partes.getIdedificio() != null) {
			where.append(" AND t1.IDEDIFICIO = ?");
			params.add(partes.getIdedificio());
		}
		if (partes != null && partes.getIdzona() != null) {
			where.append(" AND t1.IDZONA = ?");
			params.add(partes.getIdzona());
		}
		if (partes != null && partes.getIdplanta() != null) {
			where.append(" AND t1.IDPLANTA = ?");
			params.add(partes.getIdplanta());
		}
		if (partes != null && partes.getIntExt() != null) {
			where.append(" AND t1.INT_EXT = ?");
			params.add(partes.getIntExt());
		}
		if (partes != null && partes.getIdespacio() != null) {
			where.append(" AND t1.IDESPACIO = ?");
			params.add(partes.getIdespacio());
		}
		if (partes != null && partes.getIdclase() != null) {
			where.append(" AND t1.IDCLASE = ?");
			params.add(partes.getIdclase());
		}
		if (partes != null && partes.getIdcodigo() != null) {
			where.append(" AND t1.IDCODIGO = ?");
			params.add(partes.getIdcodigo());
		}
		if (partes != null && partes.getObserv() != null) {
			where.append(" AND t1.OBSERV = ?");
			params.add(partes.getObserv());
		}
		if (partes != null && partes.getIdactuac() != null) {
			where.append(" AND t1.IDACTUAC = ?");
			params.add(partes.getIdactuac());
		}
		if (partes != null && partes.getIdmaquina() != null) {
			where.append(" AND t1.IDMAQUINA = ?");
			params.add(partes.getIdmaquina());
		}
		if (partes != null && partes.getEjecutado() != null) {
			where.append(" AND t1.EJECUTADO = ?");
			params.add(partes.getEjecutado());
		}
		if (partes != null && partes.getFechaej() != null) {
			where.append(" AND t1.FECHAEJ = ?");
			params.add(partes.getFechaej());
		}
		if (partes != null && partes.getTiempoReal() != null) {
			where.append(" AND t1.TIEMPO_REAL = ?");
			params.add(partes.getTiempoReal());
		}
		if (partes != null && partes.getUidPersona() != null) {
			where.append(" AND t1.UID_PER = ?");
			params.add(partes.getUidPersona());
		}
		if (partes != null && partes.getAveriaRepe() != null) {
			where.append(" AND t1.AVERIA_REPE = ?");
			params.add(partes.getAveriaRepe());
		}
		if (partes != null && partes.getUrgente() != null
				&& partes.getUrgente().equals("1")) {
			where.append(" AND t1.URGENTE = ?");
			params.add(partes.getUrgente());
		}
		if (partes != null && partes.getEnviomail() != null) {
			if (partes.getEnviomail().equals("1")) {
				where.append(" AND t1.ENVIO_MAIL = ?");
				params.add(partes.getEnviomail());
			} else if (partes.getEnviomail().equals("0")) {
				where.append(" AND t1.ENVIO_MAIL != 1");
			}
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - GeneraciÃ³n de cÃ³digo de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Partes entity
	 * 
	 * @param partes
	 *            Partes Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - GeneraciÃ³n de cÃ³digo de UDA
	private Map<String, ?> getWhereLikeMap(Partes partes, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				PartesDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (partes != null && partes.getIdparte() != null) {
			where.append(" AND t1.IDPARTE = ?");
			params.add(partes.getIdparte());
		}
		if (partes != null && partes.getFechare() != null) {
			where.append(" AND t1.FECHARE = ?");
			params.add(partes.getFechare());
		}
		if (partes != null && partes.getNombre() != null) {
			where.append(" AND UPPER(t1.NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(partes.getNombre().toUpperCase() + "%");
			} else {
				params.add("%" + partes.getNombre().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE IS NOT NULL");
		}
		if (partes != null && partes.getTelefo() != null) {
			where.append(" AND UPPER(t1.TELEFO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(partes.getTelefo().toUpperCase() + "%");
			} else {
				params.add("%" + partes.getTelefo().toUpperCase() + "%");
			}
			where.append(" AND t1.TELEFO IS NOT NULL");
		}
		if (partes != null && partes.getMail() != null) {
			where.append(" AND UPPER(t1.MAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(partes.getMail().toUpperCase() + "%");
			} else {
				params.add("%" + partes.getMail().toUpperCase() + "%");
			}
			where.append(" AND t1.MAIL IS NOT NULL");
		}
		if (partes != null && partes.getIddepar() != null) {
			where.append(" AND t1.IDDEPAR = ?");
			params.add(partes.getIddepar());
		}
		if (partes != null && partes.getDepartamento() != null
				&& partes.getDepartamento().getCdepar() != null) {
			where.append(" AND UPPER(t2.CDEPAR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(partes.getDepartamento().getCdepar().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ partes.getDepartamento().getCdepar().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.CDEPAR IS NOT NULL");
		}

		if (partes != null && partes.getIddir() != null) {
			where.append(" AND t1.IDDIR = ?");
			params.add(partes.getIddir());
		}
		if (partes != null && partes.getDireccion() != null
				&& partes.getDireccion().getCdir() != null) {
			where.append(" AND UPPER(t3.CDIR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(partes.getDireccion().getCdir().toUpperCase() + "%");
			} else {
				params.add("%" + partes.getDireccion().getCdir().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.CDIR IS NOT NULL");
		}
		if (partes != null && partes.getIdedificio() != null) {
			where.append(" AND UPPER(t1.IDEDIFICIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(partes.getIdedificio().toUpperCase() + "%");
			} else {
				params.add("%" + partes.getIdedificio().toUpperCase() + "%");
			}
			where.append(" AND t1.IDEDIFICIO IS NOT NULL");
		}
		if (partes != null && partes.getEdificio() != null
				&& partes.getEdificio().getCedificio() != null) {
			where.append(" AND UPPER(t4.CEDIFICIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(partes.getEdificio().getCedificio().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ partes.getEdificio().getCedificio().toUpperCase()
						+ "%");
			}
			where.append(" AND t4.CEDIFICIO IS NOT NULL");
		}

		if (partes != null && partes.getIdzona() != null) {
			where.append(" AND t1.IDZONA = ?");
			params.add(partes.getIdzona());
		}
		if (partes != null && partes.getZona() != null
				&& partes.getZona().getCzona() != null) {
			where.append(" AND UPPER(t5.CZONA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(partes.getZona().getCzona().toUpperCase() + "%");
			} else {
				params.add("%" + partes.getZona().getCzona().toUpperCase()
						+ "%");
			}
			where.append(" AND t5.CZONA IS NOT NULL");
		}

		if (partes != null && partes.getIdplanta() != null) {
			where.append(" AND t1.IDPLANTA = ?");
			params.add(partes.getIdplanta());
		}
		if (partes != null && partes.getIdespacio() != null) {
			where.append(" AND t1.IDESPACIO = ?");
			params.add(partes.getIdespacio());
		}
		if (partes != null && partes.getIdclase() != null) {
			where.append(" AND t1.IDCLASE = ?");
			params.add(partes.getIdclase());
		}
		if (partes != null && partes.getClase() != null
				&& partes.getClase().getCclase() != null) {
			where.append(" AND UPPER(t8.CCLASE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(partes.getClase().getCclase().toUpperCase() + "%");
			} else {
				params.add("%" + partes.getClase().getCclase().toUpperCase()
						+ "%");
			}
			where.append(" AND t8.CCLASE IS NOT NULL");
		}

		if (partes != null && partes.getIdcodigo() != null) {
			where.append(" AND t1.IDCODIGO = ?");
			params.add(partes.getIdcodigo());
		}
		if (partes != null && partes.getObserv() != null) {
			where.append(" AND UPPER(t1.OBSERV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(partes.getObserv().toUpperCase() + "%");
			} else {
				params.add("%" + partes.getObserv().toUpperCase() + "%");
			}
			where.append(" AND t1.OBSERV IS NOT NULL");
		}
		if (partes != null && partes.getEjecutado() != null) {
			where.append(" AND UPPER(t1.EJECUTADO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(partes.getEjecutado().toUpperCase() + "%");
			} else {
				params.add("%" + partes.getEjecutado().toUpperCase() + "%");
			}
			where.append(" AND t1.EJECUTADO IS NOT NULL");
		}
		if (partes != null && partes.getFechaej() != null) {
			where.append(" AND t1.FECHAEJ = ?");
			params.add(partes.getFechaej());
		}
		if (partes != null && partes.getAveriaRepe() != null) {
			where.append(" AND t1.AVERIA_REPE = ?");
			params.add(partes.getAveriaRepe());
		}
		if (partes != null && partes.getUrgente() != null
				&& partes.getUrgente().equals("1")) {
			where.append(" AND t1.URGENTE = ?");
			params.add(partes.getUrgente());
		}
		if (partes != null && partes.getEnviomail() != null) {
			if (partes.getEnviomail().equals("1")) {
				where.append(" AND t1.ENVIO_MAIL = ?");
				params.add(partes.getEnviomail());
			} else if (partes.getEnviomail().equals("0")) {
				where.append(" AND t1.ENVIO_MAIL != 1");
			}
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Partes entity
	 * 
	 * @param partes
	 *            Partes Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - GeneraciÃ³n de cÃ³digo de UDA
	private Map<String, ?> getWhereLikeMapPartes(Partes partes,
			Boolean startsWith, String sUIDUsuario) {

		StringBuilder where = new StringBuilder(
				PartesDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		where.append(" AND t12.UID_PER = ?");
		params.add(sUIDUsuario);

		if (partes != null && partes.getIdparte() != null) {
			where.append(" AND t1.IDPARTE = ?");
			params.add(partes.getIdparte());
		}
		if (partes != null && partes.getFechareD() != null
				&& !partes.getFechareD().equals("")) {
			where.append(" AND t1.FECHARE >= ?");
			params.add(partes.getFechareD());
		}
		if (partes != null && partes.getFechareH() != null
				&& !partes.getFechareH().equals("")) {
			where.append(" AND t1.FECHARE < ? + 1");
			params.add(partes.getFechareH());
		}
		if (partes != null && partes.getFechaplanifD() != null
				&& !partes.getFechaplanifD().equals("")) {
			where.append(" AND t1.FECHAPLANIF >= ?");
			params.add(partes.getFechaplanifD());
		}
		if (partes != null && partes.getFechaplanifH() != null
				&& !partes.getFechaplanifH().equals("")) {
			where.append(" AND t1.FECHAPLANIF < ? + 1");
			params.add(partes.getFechaplanifH());
		}
		if (partes != null && partes.getNombre() != null) {
			where.append(" AND UPPER(t1.NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(partes.getNombre().toUpperCase() + "%");
			} else {
				params.add("%" + partes.getNombre().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE IS NOT NULL");
		}
		if (partes != null && partes.getIddepar() != null) {
			where.append(" AND t1.IDDEPAR = ?");
			params.add(partes.getIddepar());
		}
		if (partes != null && partes.getDepartamento() != null
				&& partes.getDepartamento().getCdepar() != null) {
			where.append(" AND UPPER(t2.CDEPAR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(partes.getDepartamento().getCdepar().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ partes.getDepartamento().getCdepar().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.CDEPAR IS NOT NULL");
		}

		if (partes != null && partes.getIddir() != null) {
			where.append(" AND t1.IDDIR = ?");
			params.add(partes.getIddir());
		}
		if (partes != null && partes.getDireccion() != null
				&& partes.getDireccion().getCdir() != null) {
			where.append(" AND UPPER(t3.CDIR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(partes.getDireccion().getCdir().toUpperCase() + "%");
			} else {
				params.add("%" + partes.getDireccion().getCdir().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.CDIR IS NOT NULL");
		}
		if (partes != null && partes.getIdedificio() != null) {
			where.append(" AND UPPER(t1.IDEDIFICIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(partes.getIdedificio().toUpperCase() + "%");
			} else {
				params.add("%" + partes.getIdedificio().toUpperCase() + "%");
			}
			where.append(" AND t1.IDEDIFICIO IS NOT NULL");
		}
		if (partes != null && partes.getEdificio() != null
				&& partes.getEdificio().getCedificio() != null) {
			where.append(" AND UPPER(t4.CEDIFICIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(partes.getEdificio().getCedificio().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ partes.getEdificio().getCedificio().toUpperCase()
						+ "%");
			}
			where.append(" AND t4.CEDIFICIO IS NOT NULL");
		}

		if (partes != null && partes.getIdzona() != null) {
			where.append(" AND t1.IDZONA = ?");
			params.add(partes.getIdzona());
		}
		if (partes != null && partes.getZona() != null
				&& partes.getZona().getCzona() != null) {
			where.append(" AND UPPER(t5.CZONA) like ? ESCAPE  '\\' AND t1.IDZONA<>0");
			if (startsWith) {
				params.add(partes.getZona().getCzona().toUpperCase() + "%");
			} else {
				params.add("%" + partes.getZona().getCzona().toUpperCase()
						+ "%");
			}
			where.append(" AND t5.CZONA IS NOT NULL");
		}

		if (partes != null && partes.getIdplanta() != null) {
			where.append(" AND t1.IDPLANTA = ?");
			params.add(partes.getIdplanta());
		}
		if (partes != null && partes.getPlanta() != null
				&& partes.getPlanta().getCplanta() != null) {
			where.append(" AND UPPER(t6.CPLANTA) like ? ESCAPE  '\\' AND t1.IDPLANTA<>0");
			if (startsWith) {
				params.add(partes.getPlanta().getCplanta().toUpperCase() + "%");
			} else {
				params.add("%" + partes.getPlanta().getCplanta().toUpperCase()
						+ "%");
			}
			where.append(" AND t6.CPLANTA IS NOT NULL");
		}
		if (partes != null && partes.getIdespacio() != null) {
			where.append(" AND t1.IDESPACIO = ?");
			params.add(partes.getIdespacio());
		}
		/*
		 * if (partes != null && partes.getIdclase() != null) {
		 * where.append(" AND t1.IDCLASE = ?"); params.add(partes.getIdclase());
		 * } if (partes != null && partes.getClase() != null &&
		 * partes.getClase().getCclase() != null) {
		 * where.append(" AND UPPER(t8.CCLASE) like ? ESCAPE  '\\'"); if
		 * (startsWith) { params.add(partes.getClase().getCclase().toUpperCase()
		 * + "%"); } else { params.add("%" +
		 * partes.getClase().getCclase().toUpperCase() + "%"); }
		 * where.append(" AND t8.CCLASE IS NOT NULL"); }
		 */
		if (partes != null && partes.getClase() != null
				&& partes.getClase().getIdclase() != null
				&& partes.getClase().getIdclase().intValue() != 0) {
			where.append(" AND t1.IDCLASE = ? ");
			params.add(partes.getClase().getIdclase());

		}

		if (partes != null && partes.getIdcodigo() != null) {
			where.append(" AND t1.IDCODIGO = ?");
			params.add(partes.getIdcodigo());
		}
		if (partes != null && partes.getCodigo() != null
				&& partes.getCodigo().getCcodigo() != null) {
			where.append(" AND UPPER(t9.CCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(partes.getCodigo().getCcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + partes.getCodigo().getCcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t9.CCODIGO IS NOT NULL");
		}
		if (partes != null && partes.getCodigo() != null
				&& partes.getCodigo().getIdservicio() != null
				&& partes.getCodigo().getIdservicio() != 0) {
			where.append(" AND t9.IDSERVICIO = ?");
			params.add(partes.getCodigo().getIdservicio());
		}

		if (partes != null && partes.getPlanta() != null
				&& partes.getPlanta().getCplanta() != null) {
			where.append(" AND UPPER(t6.CPLANTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(partes.getPlanta().getCplanta().toUpperCase() + "%");
			} else {
				params.add("%" + partes.getPlanta().getCplanta().toUpperCase()
						+ "%");
			}
			where.append(" AND t6.CPLANTA IS NOT NULL");
		}

		if (partes != null && partes.getObserv() != null) {
			where.append(" AND UPPER(t1.OBSERV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(partes.getObserv().toUpperCase() + "%");
			} else {
				params.add("%" + partes.getObserv().toUpperCase() + "%");
			}
			where.append(" AND t1.OBSERV IS NOT NULL");
		}
		if (partes != null) {
			if (partes.getEjecutado() != null
					&& partes.getEjecutado().equals("1")) {
				if (partes.getParado() != null
						&& partes.getParado().equals("1")) {
					where.append(" AND (t1.EJECUTADO='1' OR (t1.EJECUTADO='0' AND (t1.TIEMPO_REAL<>0 AND t1.TIEMPO_REAL is not null))) ");
				} else {
					where.append(" AND (t1.EJECUTADO='1') ");
				}
			} else {
				if (partes.getParado() != null
						&& partes.getParado().equals("1")) {
					where.append(" AND t1.EJECUTADO='0' AND (t1.TIEMPO_REAL<>0 AND t1.TIEMPO_REAL is not null) ");
				}
			}
		}
		if (partes != null && partes.getTecnicos() != null
				&& partes.getTecnicos().trim().length() > 0) {
			where.append(" AND UPPER(t11.NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(partes.getTecnicos().toUpperCase() + "%");
			} else {
				params.add("%" + partes.getTecnicos().toUpperCase() + "%");
			}
			where.append(" AND t11.NOMBRE IS NOT NULL");
		}

		if (partes != null && partes.getFechaej() != null) {
			where.append(" AND t1.FECHAEJ = ?");
			params.add(partes.getFechaej());
		}

		// He utilizado el campo idactuac para recoger el check de Con
		// Duplicados
		if (partes != null && partes.getIdactuac() != null) {
			if (partes.getIdactuac().intValue() == 1) {
				// where.append(" AND t1.AVERIA_REPE is null");
			} else {
				where.append(" AND (t1.AVERIA_REPE is null or t1.AVERIA_REPE=0)");
			}
		}
		if (partes != null && partes.getIdactuac() == null) {
			where.append(" AND (t1.AVERIA_REPE is null or t1.AVERIA_REPE=0) ");
		}
		if (partes != null && partes.getUrgente() != null
				&& partes.getUrgente().equals("1")) {
			where.append(" AND t1.URGENTE = ?");
			params.add(partes.getUrgente());
		}
		if (partes != null && partes.getNoProcede() != null
				&& partes.getNoProcede().equals("1")) {
			where.append(" AND t1.NOPROCEDE = ?");
			params.add(partes.getNoProcede());
		}

		if (partes != null && partes.getEnviomail() != null) {
			if (partes.getEnviomail().equals("1")) {
				where.append(" AND t1.ENVIO_MAIL = ?");
				params.add(partes.getEnviomail());
			} else if (partes.getEnviomail().equals("0")) {
				where.append(" AND t1.ENVIO_MAIL != 1");
			}
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	private Map<String, ?> getWhereLikeMapConsultaPartesUsuNormal(
			Partes partes, Boolean startsWith, String sUIDUsuario) {

		StringBuilder where = new StringBuilder(
				PartesDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		where.append(" AND t1.UID_PER = ?");
		params.add(sUIDUsuario);

		if (partes != null && partes.getIdparte() != null) {
			where.append(" AND t1.IDPARTE = ?");
			params.add(partes.getIdparte());
		}
		if (partes != null && partes.getFechareD() != null
				&& !partes.getFechareD().equals("")) {
			where.append(" AND t1.FECHARE >= ?");
			params.add(partes.getFechareD());
		}
		if (partes != null && partes.getFechareH() != null
				&& !partes.getFechareH().equals("")) {
			where.append(" AND t1.FECHARE < ? + 1");
			params.add(partes.getFechareH());
		}

		if (partes != null && partes.getIdzona() != null) {
			where.append(" AND t1.IDZONA = ?");
			params.add(partes.getIdzona());
		}
		if (partes != null && partes.getZona() != null
				&& partes.getZona().getCzona() != null) {
			where.append(" AND UPPER(t5.CZONA) like ? ESCAPE  '\\' AND t1.IDZONA<>0");
			if (startsWith) {
				params.add(partes.getZona().getCzona().toUpperCase() + "%");
			} else {
				params.add("%" + partes.getZona().getCzona().toUpperCase()
						+ "%");
			}
			where.append(" AND t5.CZONA IS NOT NULL");
		}

		if (partes != null && partes.getIdplanta() != null) {
			where.append(" AND t1.IDPLANTA = ?");
			params.add(partes.getIdplanta());
		}
		if (partes != null && partes.getPlanta() != null
				&& partes.getPlanta().getCplanta() != null) {
			where.append(" AND UPPER(t6.CPLANTA) like ? ESCAPE  '\\' AND t1.IDPLANTA<>0");
			if (startsWith) {
				params.add(partes.getPlanta().getCplanta().toUpperCase() + "%");
			} else {
				params.add("%" + partes.getPlanta().getCplanta().toUpperCase()
						+ "%");
			}
			where.append(" AND t6.CPLANTA IS NOT NULL");
		}

		if (partes != null && partes.getIdespacio() != null) {
			where.append(" AND t1.IDESPACIO = ?");
			params.add(partes.getIdespacio());
		}
		if (partes != null && partes.getIdclase() != null) {
			where.append(" AND t1.IDCLASE = ?");
			params.add(partes.getIdclase());
		}
		if (partes != null && partes.getClase() != null
				&& partes.getClase().getCclase() != null) {
			where.append(" AND UPPER(t8.CCLASE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(partes.getClase().getCclase().toUpperCase() + "%");
			} else {
				params.add("%" + partes.getClase().getCclase().toUpperCase()
						+ "%");
			}
			where.append(" AND t8.CCLASE IS NOT NULL");
		}

		if (partes != null && partes.getIdcodigo() != null) {
			where.append(" AND t1.IDCODIGO = ?");
			params.add(partes.getIdcodigo());
		}
		if (partes != null && partes.getCodigo() != null
				&& partes.getCodigo().getCcodigo() != null) {
			where.append(" AND UPPER(t9.CCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(partes.getCodigo().getCcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + partes.getCodigo().getCcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t9.CCODIGO IS NOT NULL");
		}

		if (partes != null && partes.getObserv() != null) {
			where.append(" AND UPPER(t1.OBSERV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(partes.getObserv().toUpperCase() + "%");
			} else {
				params.add("%" + partes.getObserv().toUpperCase() + "%");
			}
			where.append(" AND t1.OBSERV IS NOT NULL");
		}
		if (partes != null) {
			if (partes.getEjecutado() != null
					&& partes.getEjecutado().equals("1")) {
				if (partes.getParado() != null
						&& partes.getParado().equals("1")) {
					where.append(" AND (t1.EJECUTADO='1' OR (t1.EJECUTADO='0' AND (t1.TIEMPO_REAL<>0 AND t1.TIEMPO_REAL is not null))) ");
				} else {
					where.append(" AND (t1.EJECUTADO='1') ");
				}
			} else {
				if (partes.getParado() != null
						&& partes.getParado().equals("1")) {
					where.append(" AND t1.EJECUTADO='0' AND (t1.TIEMPO_REAL<>0 AND t1.TIEMPO_REAL is not null) ");
				}
			}
		}

		// He utilizado el campo idactuac para recoger el check de Con
		// Duplicados
		/*
		 * if (partes != null && partes.getIdactuac() != null) { if
		 * (partes.getIdactuac().equals(1)) { //
		 * where.append(" AND t1.AVERIA_REPE is null"); } else {
		 * where.append(" AND (t1.AVERIA_REPE is null or t1.AVERIA_REPE=0)"); }
		 * } if (partes != null && partes.getIdactuac() == null) {
		 * where.append(" AND (t1.AVERIA_REPE is null or t1.AVERIA_REPE=0) "); }
		 */
		if (partes != null && partes.getUrgente() != null
				&& partes.getUrgente().equals("1")) {
			where.append(" AND t1.URGENTE = ?");
			params.add(partes.getUrgente());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Partes entity
	 * 
	 * @param partes
	 *            Partes Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - GeneraciÃ³n de cÃ³digo de UDA
	private Map<String, ?> getWhereLikeMapListCorr(Partes partes,
			Boolean startsWith, String sUIDUsuario) {

		StringBuilder where = new StringBuilder(
				PartesDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		// where.append(" AND (t1.IDMAQUINA IS NULL OR t1.IDMAQUINA=0) ");
		// where.append(" AND (t1.AVERIA_REPE IS NULL OR t1.AVERIA_REPE=0) ");

		where.append(" AND t12.UID_PER = ?");
		params.add(sUIDUsuario);

		if (partes != null && partes.getIdparte() != null) {
			where.append(" AND t1.IDPARTE = ?");
			params.add(partes.getIdparte());
		}
		if (partes != null && partes.getFechareD() != null
				&& !partes.getFechareD().equals("")) {
			where.append(" AND t1.FECHARE >= ?");
			params.add(partes.getFechareD());
		}
		if (partes != null && partes.getFechareH() != null
				&& !partes.getFechareH().equals("")) {
			where.append(" AND t1.FECHARE < ? + 1");
			params.add(partes.getFechareH());
		}
		if (partes != null && partes.getFechaplanifD() != null
				&& !partes.getFechaplanifD().equals("")) {
			where.append(" AND t1.FECHAPLANIF >= ?");
			params.add(partes.getFechaplanifD());
		}
		if (partes != null && partes.getFechaplanifH() != null
				&& !partes.getFechaplanifH().equals("")) {
			where.append(" AND t1.FECHAPLANIF < ? + 1");
			params.add(partes.getFechaplanifH());
		}

		if (partes != null && partes.getNombre() != null
				&& partes.getNombre().trim().length() > 0) {
			where.append(" AND UPPER(t1.NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(partes.getNombre().toUpperCase() + "%");
			} else {
				params.add("%" + partes.getNombre().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE IS NOT NULL");
		}
		if (partes != null && partes.getIddepar() != null) {
			where.append(" AND t1.IDDEPAR = ?");
			params.add(partes.getIddepar());
		}

		if (partes != null && partes.getIddir() != null) {
			where.append(" AND t1.IDDIR = ?");
			params.add(partes.getIddir());
		}
		if (partes != null && partes.getIdedificio() != null
				&& partes.getIdedificio().trim().length() > 0) {
			where.append(" AND UPPER(t1.IDEDIFICIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(partes.getIdedificio().toUpperCase() + "%");
			} else {
				params.add("%" + partes.getIdedificio().toUpperCase() + "%");
			}
			where.append(" AND t1.IDEDIFICIO IS NOT NULL");
		}

		if (partes != null && partes.getZona() != null
				&& partes.getZona().getCzona() != null
				&& partes.getZona().getCzona().trim().length() > 0) {
			where.append(" AND UPPER(t5.CZONA) like ? ESCAPE  '\\' AND t1.IDZONA<>0");
			if (startsWith) {
				params.add(partes.getZona().getCzona().toUpperCase() + "%");
			} else {
				params.add("%" + partes.getZona().getCzona().toUpperCase()
						+ "%");
			}
			where.append(" AND t5.CZONA IS NOT NULL");
		}

		if (partes != null && partes.getPlanta() != null
				&& partes.getPlanta().getCplanta() != null
				&& partes.getPlanta().getCplanta().trim().length() > 0) {
			where.append(" AND UPPER(t6.CPLANTA) like ? ESCAPE  '\\' AND t1.IDPLANTA<>0");
			if (startsWith) {
				params.add(partes.getPlanta().getCplanta().toUpperCase() + "%");
			} else {
				params.add("%" + partes.getPlanta().getCplanta().toUpperCase()
						+ "%");
			}
			where.append(" AND t6.CPLANTA IS NOT NULL");
		}
		/*
		 * if (partes != null && partes.getClase() != null &&
		 * partes.getClase().getCclase() != null &&
		 * partes.getClase().getCclase().trim().length() > 0) {
		 * where.append(" AND UPPER(t8.CCLASE) like ? ESCAPE  '\\'"); if
		 * (startsWith) { params.add(partes.getClase().getCclase().toUpperCase()
		 * + "%"); } else { params.add("%" +
		 * partes.getClase().getCclase().toUpperCase() + "%"); }
		 * where.append(" AND t8.CCLASE IS NOT NULL"); }
		 */
		if (partes != null && partes.getClase() != null
				&& partes.getClase().getIdclase() != null
				&& partes.getClase().getIdclase() != 0) {
			where.append(" AND t8.IDCLASE =?");
			params.add(partes.getClase().getIdclase());
		}

		if (partes != null && partes.getCodigo() != null
				&& partes.getCodigo().getCcodigo() != null
				&& partes.getCodigo().getCcodigo().trim().length() > 0) {
			where.append(" AND UPPER(t9.CCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(partes.getCodigo().getCcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + partes.getCodigo().getCcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t9.CCODIGO IS NOT NULL");
		}
		if (partes != null && partes.getCodigo() != null
				&& partes.getCodigo().getIdservicio() != null
				&& partes.getCodigo().getIdservicio() != 0) {
			where.append(" AND t9.IDSERVICIO = ?");
			params.add(partes.getCodigo().getIdservicio());
		}

		if (partes != null && partes.getTecnicos() != null
				&& partes.getTecnicos().trim().length() > 0) {

			String[] listaTecn = partes.getTecnicos().split(",");
			int indice = 0;
			for (String idTecnicoStr : listaTecn) {
				if (idTecnicoStr != null && !idTecnicoStr.equals("")) {
					if (indice == 0) {
						where.append(" AND (t11.IDTECNICO = ? ");
						params.add(idTecnicoStr);
					} else {
						where.append(" OR t11.IDTECNICO = ?");
						params.add(idTecnicoStr);
					}
					indice++;
					if (indice == listaTecn.length) {
						where.append(" )");
					}
				}
			}

			/*
			 * where.append(" AND UPPER(t11.NOMBRE) like ? ESCAPE  '\\'"); if
			 * (startsWith) { params.add(partes.getTecnicos().toUpperCase() +
			 * "%"); } else { params.add("%" +
			 * partes.getTecnicos().toUpperCase() + "%"); }
			 * where.append(" AND t11.NOMBRE IS NOT NULL");
			 */
		}

		if (partes != null && partes.getUrgente() != null
				&& partes.getUrgente().equals("1")) {
			where.append(" AND t1.URGENTE = ?");
			params.add(partes.getUrgente());
		}
		if (partes != null && partes.getVip() != null
				&& partes.getVip().equals("1")) {
			where.append(" AND t1.VIP = ?");
			params.add(partes.getVip());
		}
		if (partes != null && partes.getEnviomail() != null) {
			if (partes.getEnviomail().equals("1")) {
				where.append(" AND t1.ENVIO_MAIL = ?");
				params.add(partes.getEnviomail());
			} else if (partes.getEnviomail().equals("0")) {
				where.append(" AND t1.ENVIO_MAIL != 1");
			}
		}

		if (partes != null && partes.getNoProcede() != null
				&& partes.getNoProcede().equals("1")) {
			where.append(" AND T1.NOPROCEDE = '1' ");
		}

		if (partes != null) {
			if (partes.getEjecutado() != null
					&& partes.getEjecutado().equals("1")) {
				if (partes.getParado() != null
						&& partes.getParado().equals("1")) {
					where.append(" AND (t1.EJECUTADO='1' OR (t1.EJECUTADO='0' AND (t1.TIEMPO_REAL<>0 AND t1.TIEMPO_REAL is not null))) ");
				} else {
					where.append(" AND (t1.EJECUTADO='1') ");
				}
			} else {
				if (partes.getParado() != null
						&& partes.getParado().equals("1")) {
					where.append(" AND t1.EJECUTADO='0' AND (t1.TIEMPO_REAL<>0 AND t1.TIEMPO_REAL is not null) ");
				}
			}
		}

		// He utilizado el campo idactuac para recoger el check de Con
		// Duplicados
		if (partes != null && partes.getIdactuac() != null) {
			if (partes.getIdactuac().intValue() == 1) {
				// where.append(" AND t1.AVERIA_REPE is null");
				/*
				 * 20/03/2017 - Inma - Para cuando marca el check en el listado
				 * de correctivos
				 */
				// where.append(" AND t1.AVERIA_REPE > 0 ");
			} else {
				where.append(" AND (t1.AVERIA_REPE is null or t1.AVERIA_REPE=0)");
			}
		} else {
			where.append(" AND (t1.AVERIA_REPE IS NULL OR t1.AVERIA_REPE=0) ");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	private Map<String, ?> getWhereLikeMapListAgenda(Partes partes,
			Boolean startsWith, String sUIDUsuario, boolean conTecnicos) {

		StringBuilder where = new StringBuilder(
				PartesDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		// where.append(" AND (t1.IDMAQUINA IS NULL OR t1.IDMAQUINA=0) ");
		where.append(" AND (t1.AVERIA_REPE IS NULL OR t1.AVERIA_REPE=0) ");

		where.append(" AND t12.UID_PER = ?");
		params.add(sUIDUsuario);

		if (partes != null && partes.getIdparte() != null) {
			where.append(" AND t1.IDPARTE = ?");
			params.add(partes.getIdparte());
		}
		if (partes != null && partes.getFechareD() != null
				&& !partes.getFechareD().equals("")) {
			where.append(" AND t1.FECHARE >= ?");
			params.add(partes.getFechareD());
		}
		if (partes != null && partes.getFechareH() != null
				&& !partes.getFechareH().equals("")) {
			where.append(" AND t1.FECHARE < ? + 1");
			params.add(partes.getFechareH());
		}
		if (partes != null && partes.getFechaplanifD() != null
				&& !partes.getFechaplanifD().equals("")) {
			where.append(" AND t1.FECHAPLANIF >= ?");
			params.add(partes.getFechaplanifD());
		}
		if (partes != null && partes.getFechaplanifH() != null
				&& !partes.getFechaplanifH().equals("")) {
			where.append(" AND t1.FECHAPLANIF < ? + 1");
			params.add(partes.getFechaplanifH());
		}
		if (partes != null && partes.getNombre() != null
				&& partes.getNombre().trim().length() > 0) {
			where.append(" AND UPPER(t1.NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(partes.getNombre().toUpperCase() + "%");
			} else {
				params.add("%" + partes.getNombre().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE IS NOT NULL");
		}
		if (partes != null && partes.getIddepar() != null) {
			where.append(" AND t1.IDDEPAR = ?");
			params.add(partes.getIddepar());
		}

		if (partes != null && partes.getIddir() != null) {
			where.append(" AND t1.IDDIR = ?");
			params.add(partes.getIddir());
		}
		if (partes != null && partes.getIdedificio() != null
				&& partes.getIdedificio().trim().length() > 0) {
			where.append(" AND UPPER(t1.IDEDIFICIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(partes.getIdedificio().toUpperCase() + "%");
			} else {
				params.add("%" + partes.getIdedificio().toUpperCase() + "%");
			}
			where.append(" AND t1.IDEDIFICIO IS NOT NULL");
		}

		if (partes != null && partes.getZona() != null
				&& partes.getZona().getCzona() != null
				&& partes.getZona().getCzona().trim().length() > 0) {
			where.append(" AND UPPER(t5.CZONA) like ? ESCAPE  '\\' AND t1.IDZONA<>0");
			if (startsWith) {
				params.add(partes.getZona().getCzona().toUpperCase() + "%");
			} else {
				params.add("%" + partes.getZona().getCzona().toUpperCase()
						+ "%");
			}
			where.append(" AND t5.CZONA IS NOT NULL");
		}

		if (partes != null && partes.getPlanta() != null
				&& partes.getPlanta().getCplanta() != null
				&& partes.getPlanta().getCplanta().trim().length() > 0) {
			where.append(" AND UPPER(t6.CPLANTA) like ? ESCAPE  '\\' AND t1.IDPLANTA<>0");
			if (startsWith) {
				params.add(partes.getPlanta().getCplanta().toUpperCase() + "%");
			} else {
				params.add("%" + partes.getPlanta().getCplanta().toUpperCase()
						+ "%");
			}
			where.append(" AND t6.CPLANTA IS NOT NULL");
		}
		if (partes != null && partes.getClase() != null
				&& partes.getClase().getCclase() != null
				&& partes.getClase().getCclase().trim().length() > 0) {
			where.append(" AND UPPER(t8.CCLASE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(partes.getClase().getCclase().toUpperCase() + "%");
			} else {
				params.add("%" + partes.getClase().getCclase().toUpperCase()
						+ "%");
			}
			where.append(" AND t8.CCLASE IS NOT NULL");
		}
		if (partes != null && partes.getIdclase() != null
				&& partes.getIdclase() > 0) {
			where.append(" AND t8.IDCLASE=?");
			params.add(partes.getIdclase());

		}

		if (partes != null && partes.getCodigo() != null
				&& partes.getCodigo().getCcodigo() != null
				&& partes.getCodigo().getCcodigo().trim().length() > 0) {
			where.append(" AND UPPER(t9.CCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(partes.getCodigo().getCcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + partes.getCodigo().getCcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t9.CCODIGO IS NOT NULL");
		}
		if (partes != null && partes.getCodigo() != null
				&& partes.getCodigo().getIdservicio() != null
				&& partes.getCodigo().getIdservicio() != 0) {
			where.append(" AND t9.IDSERVICIO = ?");
			params.add(partes.getCodigo().getIdservicio());
		}

		if (partes != null && partes.getTecnicos() != null
				&& partes.getTecnicos().trim().length() > 0) {
			where.append(" AND UPPER(t11.NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(partes.getTecnicos().toUpperCase() + "%");
			} else {
				params.add("%" + partes.getTecnicos().toUpperCase() + "%");
			}
			where.append(" AND t11.NOMBRE IS NOT NULL");
		}

		if (partes != null && partes.getUrgente() != null
				&& partes.getUrgente().equals("1")) {
			where.append(" AND t1.URGENTE = ?");
			params.add(partes.getUrgente());
		}
		if (partes != null && partes.getVip() != null
				&& partes.getVip().equals("1")) {
			where.append(" AND t1.VIP = ?");
			params.add(partes.getVip());
		}

		if (partes != null && partes.getEnviomail() != null) {
			if (partes.getEnviomail().equals("1")) {
				where.append(" AND t1.ENVIO_MAIL = ?");
				params.add(partes.getEnviomail());
			} else if (partes.getEnviomail().equals("0")) {
				where.append(" AND t1.ENVIO_MAIL != 1");
			}
		}

		if (partes != null && partes.getNoProcede() != null
				&& partes.getNoProcede().equals("1")) {
			where.append(" AND T1.NOPROCEDE = '1' ");
		}

		if (partes != null) {
			if (partes.getEjecutado() != null
					&& partes.getEjecutado().equals("1")) {
				if (partes.getParado() != null
						&& partes.getParado().equals("1")) {
					where.append(" AND (t1.EJECUTADO='1' OR (t1.EJECUTADO='0' AND (t1.TIEMPO_REAL<>0 AND t1.TIEMPO_REAL is not null))) ");
				} else {
					where.append(" AND (t1.EJECUTADO='1') ");
				}
			} else {
				if (partes.getParado() != null
						&& partes.getParado().equals("1")) {
					where.append(" AND t1.EJECUTADO='0' AND (t1.TIEMPO_REAL<>0 AND t1.TIEMPO_REAL is not null) ");
				}
			}
		}
		// Solo se buscará en los partes enviados a móvil que son los que
		// manejan
		// los estados
		if (partes != null && partes.getAgenda() != null && conTecnicos) {
			if (partes.getAgenda().getMovilgmao() != null
					&& !partes.getAgenda().getMovilgmao().equals("")) {
				where.append(" AND T11.MOVILGMAO = ?");
				params.add(partes.getAgenda().getMovilgmao());
			}
			if (partes.getAgenda().getEstadogmao() != null
					&& !partes.getAgenda().getEstadogmao().equals("")) {
				if (partes.getAgenda().getEstadogmao().equals("ASIG")) {
					where.append(" AND (T13.ESTADOGMAO = ? OR T13.ESTADOGMAO is null) ");
				} else {
					where.append(" AND T13.ESTADOGMAO = ? ");
				}
				params.add(partes.getAgenda().getEstadogmao());
			}
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Partes entity
	 * 
	 * @param partes
	 *            Partes Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - GeneraciÃ³n de cÃ³digo de UDA
	private Map<String, ?> getWhereLikeMapListEjecTecnico(Partes partes,
			Boolean startsWith, String sUIDUsuario) {

		StringBuilder where = new StringBuilder(
				PartesDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		// where.append(" AND (t1.IDMAQUINA IS NULL OR t1.IDMAQUINA=0) ");
		where.append(" AND (t1.AVERIA_REPE IS NULL OR t1.AVERIA_REPE=0) ");

		where.append(" AND t12.UID_PER = ?");
		params.add(sUIDUsuario);

		if (partes != null && partes.getIdparte() != null) {
			where.append(" AND t1.IDPARTE = ?");
			params.add(partes.getIdparte());
		}
		if (partes != null && partes.getNombre() != null
				&& partes.getNombre().trim().length() > 0) {
			where.append(" AND UPPER(t1.NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(partes.getNombre().toUpperCase() + "%");
			} else {
				params.add("%" + partes.getNombre().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE IS NOT NULL");
		}
		if (partes != null && partes.getIddepar() != null) {
			where.append(" AND t1.IDDEPAR = ?");
			params.add(partes.getIddepar());
		}

		if (partes != null && partes.getIddir() != null) {
			where.append(" AND t1.IDDIR = ?");
			params.add(partes.getIddir());
		}
		if (partes != null && partes.getIdedificio() != null
				&& partes.getIdedificio().trim().length() > 0) {
			where.append(" AND UPPER(t1.IDEDIFICIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(partes.getIdedificio().toUpperCase() + "%");
			} else {
				params.add("%" + partes.getIdedificio().toUpperCase() + "%");
			}
			where.append(" AND t1.IDEDIFICIO IS NOT NULL");
		}

		if (partes != null && partes.getZona() != null
				&& partes.getZona().getCzona() != null
				&& partes.getZona().getCzona().trim().length() > 0) {
			where.append(" AND UPPER(t5.CZONA) like ? ESCAPE  '\\' AND t1.IDZONA<>0");
			if (startsWith) {
				params.add(partes.getZona().getCzona().toUpperCase() + "%");
			} else {
				params.add("%" + partes.getZona().getCzona().toUpperCase()
						+ "%");
			}
			where.append(" AND t5.CZONA IS NOT NULL");
		}

		if (partes != null && partes.getPlanta() != null
				&& partes.getPlanta().getCplanta() != null
				&& partes.getPlanta().getCplanta().trim().length() > 0) {
			where.append(" AND UPPER(t6.CPLANTA) like ? ESCAPE  '\\' AND t1.IDPLANTA<>0");
			if (startsWith) {
				params.add(partes.getPlanta().getCplanta().toUpperCase() + "%");
			} else {
				params.add("%" + partes.getPlanta().getCplanta().toUpperCase()
						+ "%");
			}
			where.append(" AND t6.CPLANTA IS NOT NULL");
		}
		/*
		 * if (partes != null && partes.getClase() != null &&
		 * partes.getClase().getCclase() != null &&
		 * partes.getClase().getCclase().trim().length() > 0) {
		 * where.append(" AND UPPER(t8.CCLASE) like ? ESCAPE  '\\'"); if
		 * (startsWith) { params.add(partes.getClase().getCclase().toUpperCase()
		 * + "%"); } else { params.add("%" +
		 * partes.getClase().getCclase().toUpperCase() + "%"); }
		 * where.append(" AND t8.CCLASE IS NOT NULL"); }
		 */
		if (partes != null && partes.getClase() != null
				&& partes.getClase().getIdclase() != null
				&& partes.getClase().getIdclase().intValue() != 0) {
			where.append(" AND t1.IDCLASE = ? ");
			params.add(partes.getClase().getIdclase());

		}

		if (partes != null && partes.getCodigo() != null
				&& partes.getCodigo().getCcodigo() != null
				&& partes.getCodigo().getCcodigo().trim().length() > 0) {
			where.append(" AND UPPER(t9.CCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(partes.getCodigo().getCcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + partes.getCodigo().getCcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t9.CCODIGO IS NOT NULL");
		}
		if (partes != null && partes.getCodigo() != null
				&& partes.getCodigo().getIdservicio() != null
				&& partes.getCodigo().getIdservicio() != 0) {
			where.append(" AND t9.IDSERVICIO = ?");
			params.add(partes.getCodigo().getIdservicio());
		}

		if (partes != null && partes.getTecnicos() != null
				&& partes.getTecnicos().trim().length() > 0) {

			String[] listaTecn = partes.getTecnicos().split(",");
			int indice = 0;
			for (String idTecnicoStr : listaTecn) {
				if (idTecnicoStr != null && !idTecnicoStr.equals("")) {
					if (indice == 0) {
						where.append(" AND (t11.IDTECNICO = ? ");
						params.add(idTecnicoStr);
					} else {
						where.append(" OR t11.IDTECNICO = ?");
						params.add(idTecnicoStr);
					}
					indice++;
					if (indice == listaTecn.length) {
						where.append(" )");
					}
				}
			}
		}
		/*
		 * if (partes != null && partes.getTecnicos() != null &&
		 * partes.getTecnicos().trim().length() > 0) {
		 * where.append(" AND UPPER(t11.NOMBRE) like ? ESCAPE  '\\'"); if
		 * (startsWith) { params.add(partes.getTecnicos().toUpperCase() + "%");
		 * } else { params.add("%" + partes.getTecnicos().toUpperCase() + "%");
		 * } where.append(" AND t11.NOMBRE IS NOT NULL"); }
		 */

		if (partes != null && partes.getFechareD() != null
				&& !partes.getFechareD().equals("")) {
			where.append(" AND t1.FECHARE >= ?");
			params.add(partes.getFechareD());
		}
		if (partes != null && partes.getFechareH() != null
				&& !partes.getFechareH().equals("")) {
			where.append(" AND t1.FECHARE < ? + 1");
			params.add(partes.getFechareH());
		}
		if (partes != null && partes.getFechaplanifD() != null
				&& !partes.getFechaplanifD().equals("")) {
			where.append(" AND t1.FECHAPLANIF >= ?");
			params.add(partes.getFechaplanifD());
		}
		if (partes != null && partes.getFechaplanifH() != null
				&& !partes.getFechaplanifH().equals("")) {
			where.append(" AND t1.FECHAPLANIF < ? + 1");
			params.add(partes.getFechaplanifH());
		}
		if (partes != null && partes.getUrgente() != null
				&& partes.getUrgente().equals("1")) {
			where.append(" AND t1.URGENTE = ?");
			params.add(partes.getUrgente());
		}
		if (partes != null && partes.getEnviomail() != null) {
			if (partes.getEnviomail().equals("1")) {
				where.append(" AND t1.ENVIO_MAIL = ?");
				params.add(partes.getEnviomail());
			} else if (partes.getEnviomail().equals("0")) {
				where.append(" AND t1.ENVIO_MAIL != 1");
			}
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Partes entity
	 * 
	 * @param partes
	 *            Partes Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - GeneraciÃ³n de cÃ³digo de UDA
	private Map<String, ?> getWhereLikeMapPartesPend(Partes partes,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				PartesDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (partes != null && partes.getIdparte() != null) {
			where.append(" AND t1.IDPARTE = ?");
			params.add(partes.getIdparte());
		}
		if (partes != null && partes.getFechareD() != null
				&& !partes.getFechareD().equals("")) {
			where.append(" AND t1.FECHARE >= ?");
			params.add(partes.getFechareD());
		}
		if (partes != null && partes.getFechareH() != null
				&& !partes.getFechareH().equals("")) {
			where.append(" AND t1.FECHARE < ? + 1");
			params.add(partes.getFechareH());
		}

		if (partes != null && partes.getFechaplanifD() != null
				&& !partes.getFechaplanifD().equals("")) {
			where.append(" AND t1.FECHAPLANIF >= ?");
			params.add(partes.getFechaplanifD());
		}
		if (partes != null && partes.getFechaplanifH() != null
				&& !partes.getFechaplanifH().equals("")) {
			where.append(" AND t1.FECHAPLANIF < ? + 1");
			params.add(partes.getFechaplanifH());
		}

		if (partes != null && partes.getNombre() != null
				&& !partes.getNombre().equals("")) {
			where.append(" AND UPPER(t1.NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(partes.getNombre().toUpperCase() + "%");
			} else {
				params.add("%" + partes.getNombre().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE IS NOT NULL");
		}
		if (partes != null && partes.getIddepar() != null) {
			where.append(" AND t1.IDDEPAR = ?");
			params.add(partes.getIddepar());
		}
		if (partes != null && partes.getIddir() != null) {
			where.append(" AND t1.IDDIR = ?");
			params.add(partes.getIddir());
		}

		if (partes != null && partes.getIdedificio() != null
				&& !partes.getIdedificio().equals("")) {
			where.append(" AND UPPER(t1.IDEDIFICIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(partes.getIdedificio().toUpperCase() + "%");
			} else {
				params.add("%" + partes.getIdedificio().toUpperCase() + "%");
			}
			where.append(" AND t1.IDEDIFICIO IS NOT NULL ");
		}
		if (partes != null && partes.getIdzona() != null
				&& !partes.getIdzona().equals("")) {
			where.append(" AND t1.IDZONA = ?");
			params.add(partes.getIdzona());
		}
		if (partes != null && partes.getZona() != null
				&& partes.getZona().getCzona() != null
				&& !partes.getZona().getCzona().equals("")) {
			where.append(" AND UPPER(t5.CZONA) like ? ESCAPE  '\\' AND t1.IDZONA<>0");
			if (startsWith) {
				params.add(partes.getZona().getCzona().toUpperCase() + "%");
			} else {
				params.add("%" + partes.getZona().getCzona().toUpperCase()
						+ "%");
			}
			where.append(" AND t5.CZONA IS NOT NULL");
		}

		if (partes != null && partes.getIdplanta() != null
				&& !partes.getIdplanta().equals("")) {
			where.append(" AND t1.IDPLANTA = ?");
			params.add(partes.getIdplanta());
		}
		if (partes != null && partes.getPlanta() != null
				&& partes.getPlanta().getCplanta() != null
				&& !partes.getPlanta().getCplanta().equals("")) {
			where.append(" AND UPPER(t6.CPLANTA) like ? ESCAPE  '\\' AND t1.IDPLANTA<>0");
			if (startsWith) {
				params.add(partes.getPlanta().getCplanta().toUpperCase() + "%");
			} else {
				params.add("%" + partes.getPlanta().getCplanta().toUpperCase()
						+ "%");
			}
			where.append(" AND t6.CPLANTA IS NOT NULL ");
		}
		if (partes != null && partes.getIdespacio() != null
				&& !partes.getIdespacio().equals("")) {
			where.append(" AND t1.IDESPACIO = ?");
			params.add(partes.getIdespacio());
		}

		/* INMA - MIRAR AQUI */
		if (partes != null && partes.getClase() != null
				&& partes.getClase().getIdclase() != null
				&& partes.getClase().getIdclase().intValue() != 0) {
			where.append(" AND t1.IDCLASE = ?");
			params.add(partes.getClase().getIdclase());
		}
		/*
		 * if (partes != null && partes.getClase() != null &&
		 * partes.getClase().getCclase() != null &&
		 * !partes.getClase().getCclase().equals("")) {
		 * where.append(" AND UPPER(t8.CCLASE) like ? ESCAPE  '\\'"); if
		 * (startsWith) { params.add(partes.getClase().getCclase().toUpperCase()
		 * + "%"); } else { params.add("%" +
		 * partes.getClase().getCclase().toUpperCase() + "%"); }
		 * where.append(" AND t8.CCLASE IS NOT NULL "); }
		 */

		if (partes != null && partes.getIdcodigo() != null
				&& !partes.getIdcodigo().equals("")) {
			where.append(" AND t1.IDCODIGO = ?");
			params.add(partes.getIdcodigo());
		}
		if (partes != null && partes.getCodigo() != null
				&& partes.getCodigo().getCcodigo() != null
				&& !partes.getCodigo().getCcodigo().equals("")) {
			where.append(" AND UPPER(t9.CCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(partes.getCodigo().getCcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + partes.getCodigo().getCcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t9.CCODIGO IS NOT NULL");
		}
		if (partes != null && partes.getCodigo() != null
				&& partes.getCodigo().getIdservicio() != null
				&& partes.getCodigo().getIdservicio() != 0) {
			where.append(" AND t9.IDSERVICIO = ?");
			params.add(partes.getCodigo().getIdservicio());
		}

		if (partes != null && partes.getObserv() != null) {
			where.append(" AND UPPER(t1.OBSERV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(partes.getObserv().toUpperCase() + "%");
			} else {
				params.add("%" + partes.getObserv().toUpperCase() + "%");
			}
			where.append(" AND t1.OBSERV IS NOT NULL");
		}
		if (partes != null && partes.getEjecutado() != null
				&& partes.getEjecutado().equals("1")) {
			where.append(" AND t1.EJECUTADO='1'");
		}

		if (partes != null && partes.getNoProcede() != null
				&& partes.getNoProcede().equals("1")) {
			where.append(" AND ((t1.EJECUTADO='0' OR t1.EJECUTADO is null) OR (t1.EJECUTADO='1' AND T1.NOPROCEDE is null)) ");
		}

		if (partes != null && partes.getFechaej() != null) {
			where.append(" AND t1.FECHAEJ = ?");
			params.add(partes.getFechaej());
		}
		if (partes != null && partes.getParado() != null
				&& partes.getParado().equals("1")) {
			where.append(" AND t1.EJECUTADO='0' AND (t1.TIEMPO_REAL<>0 OR t1.TIEMPO_REAL is null) ");
		}

		if (partes != null && partes.getTecnicos() != null
				&& partes.getTecnicos().trim().length() > 0) {
			where.append(" AND UPPER(t12.NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(partes.getTecnicos().toUpperCase() + "%");
			} else {
				params.add("%" + partes.getTecnicos().toUpperCase() + "%");
			}
			where.append(" AND t12.NOMBRE IS NOT NULL");
		}
		if (partes != null && partes.getUrgente() != null
				&& partes.getUrgente().equals("1")) {
			where.append(" AND t1.URGENTE = ?");
			params.add(partes.getUrgente());
		}
		if (partes != null && partes.getEnviomail() != null) {
			if (partes.getEnviomail().equals("1")) {
				where.append(" AND t1.ENVIO_MAIL = ?");
				params.add(partes.getEnviomail());
			} else if (partes.getEnviomail().equals("0")) {
				where.append(" AND t1.ENVIO_MAIL != 1");
			}
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - GeneraciÃ³n de cÃ³digo de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
