package com.ejie.aa20b.dao;

import com.ejie.x38.dto.Pagination;

import java.util.ArrayList;
import java.util.List;

import com.ejie.aa20b.model.Partes;
import com.ejie.aa20b.model.TablaInformes;
import com.ejie.aa20b.model.Tecnicos;

/**
 * PartesDao generated by UDA, 28-nov-2014 11:59:04.
 * 
 * @author UDA
 */

public interface PartesDao {

	/**
	 * Inserts a single row in the Partes table.
	 * 
	 * @param partes
	 *            Partes
	 * @return Partes
	 */
	Partes add(Partes partes);

	/**
	 * Updates a single row in the Partes table.
	 * 
	 * @param partes
	 *            Partes
	 * @return Partes
	 */
	Partes update(Partes partes);

	/**
	 * finalizar el parte Padre y los hijos.
	 * 
	 * @param partes
	 *            Pagination
	 * @return Partes
	 */
	Partes finalizarParte(Partes partes);

	/**
	 * abrir el parte Padre y los hijos.
	 * 
	 * @param partes
	 *            Pagination
	 * @return Partes
	 */
	Partes abrirParte(Partes partes);

	/**
	 * Updates a single row in the Partes table.
	 * 
	 * @param partes
	 *            Partes
	 * @return Partes
	 */
	Partes modificarParte(Partes partes);

	/**
	 * Updates a single row in the Partes table.
	 * 
	 * @param partes
	 *            Partes
	 * @return
	 */
	void marcarAutomatica(Partes partes);

	/**
	 * Updates a single row in the Partes table.
	 * 
	 * @param partes
	 *            Partes
	 * @return
	 */
	void marcarEnvioMail(Partes partes);

	/**
	 * Finds a single row in the Partes table.
	 * 
	 * @param partes
	 *            Partes
	 * @return Partes
	 */
	Partes find(Partes partes);

	/**
	 * Finds a single row in the Partes table.
	 * 
	 * @param partes
	 *            Partes
	 * @return Partes
	 */
	Partes findParte(Partes partes);

	/**
	 * Deletes a single row in the Partes table.
	 * 
	 * @param partes
	 *            Partes
	 * @return
	 */
	void remove(Partes partes);

	/**
	 * Finds a List of rows in the Partes table.
	 * 
	 * @param partes
	 *            Partes
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Partes> findAll(Partes partes, Pagination pagination);

	List<Partes> findAllpendientes(Partes partes, Pagination pagination);

	/**
	 * Counts rows in the Partes table.
	 * 
	 * @param partes
	 *            Partes
	 * @return Long
	 */
	Long findAllCount(Partes partes);

	/**
	 * Finds rows in the Partes table using like.
	 * 
	 * @param partes
	 *            Partes
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Partes> findAllLike(Partes partes, Pagination pagination,
			Boolean startsWith);

	/**
	 * Finds rows in the Partes table using like.
	 * 
	 * @param partes
	 *            Partes
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param sUIDUsuario
	 *            String
	 * @return List
	 */
	List<Partes> obtenerPartesGrid(Partes partes, Pagination pagination,
			Boolean startsWith, String sUIDUsuario);

	List<Partes> obtenerPartesConsultaUsuNormalGrid(Partes partes,
			Pagination pagination, Boolean startsWith, String sUIDUsuario);

	/**
	 * Finds rows in the Partes table using like.
	 * 
	 * @param partes
	 *            Partes
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Partes> obtenerListCorrGrid(Partes partes, Pagination pagination,
			Boolean startsWith, String sUIDUsuario);

	List<Partes> obtenerDatosAgendaGrid(Partes partes, Pagination pagination,
			Boolean startsWith, String sUIDUsuario, boolean conTecnicos,
			List<Tecnicos> listaTecnicosBusq);

	/**
	 * Finds rows in the Partes table using like.
	 * 
	 * @param partes
	 *            Partes
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Partes> obtenerListEjecTecnicoGrid(Partes partes,
			Pagination pagination, Boolean startsWith, String sUIDUsuario);

	/**
	 * Finds rows in the Partes table using like.
	 * 
	 * @param partes
	 *            Partes
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Partes> obtenerListEjecFechaEjGrid(Partes partes,
			Pagination pagination, Boolean startsWith, String sUIDUsuario);

	/**
	 * Counts rows in the Partes table using like.
	 * 
	 * @param partes
	 *            Partes
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Partes partes, Boolean startsWith);

	/**
	 * Counts rows in the Partes table using like.
	 * 
	 * @param partes
	 *            Partes
	 * @param startsWith
	 *            Boolean
	 * @param sUIDUsuario
	 *            String
	 * @return Long
	 */
	Long obtenerPartesGridCount(Partes partes, Boolean startsWith,
			String sUIDUsuario);

	Long obtenerPartesConsultaUsuNormalGridCount(Partes partes,
			Boolean startsWith, String sUIDUsuario);

	/**
	 * Counts rows in the Partes table using like.
	 * 
	 * @param partes
	 *            Partes
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long obtenerListCorrGridCount(Partes partes, Boolean startsWith,
			String sUIDUsuario);

	/**
	 * Counts rows in the Partes table using like.
	 * 
	 * @param partes
	 *            Partes
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long obtenerListEjecTecnicoGridCount(Partes partes, Boolean startsWith,
			String sUIDUsuario);

	/**
	 * Counts rows in the Partes table using like.
	 * 
	 * @param partes
	 *            Partes
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long obtenerListEjecFechaEjGridCount(Partes partes, Boolean startsWith,
			String sUIDUsuario);

	/**
	 * Finds a List of rows in the Partes table.
	 * 
	 * @param partes
	 *            Partes
	 * @return List
	 */
	List<Partes> obtenerParte(Partes partes);

	/**
	 * obtener la fecha de la última ejecución
	 * 
	 * @param parte
	 *            Partes
	 * @return Partes
	 */
	Partes obtenerFechaEjecucion(Partes parte);

	/**
	 * Crea un parte partiendo de una actuación preventiva.
	 * 
	 * @param partes
	 *            Partes
	 * @return Partes
	 */
	Partes nuevoParteCorrDesdePreventivo(Partes partes);

	/**
	 * Calcula el numero de partes correctivos pendientes de asignar tecnico.
	 * 
	 * @param UIDUsuario
	 *            String
	 * @param idServicio
	 *            Integer
	 * @return Partes
	 */
	public Long calculaCorrPendAPT(String UIDUsuario, Integer idServicio,
			Integer idClase);

	/**
	 * Calcula el numero de partes correctivos asignados automaticamente y
	 * pendientes de ejecutar.
	 * 
	 * @param UIDUsuario
	 *            String
	 * @param idServicio
	 *            Integer
	 * @return Long
	 */

	public Long calculaCorrAsigAut(String UIDUsuario, Integer idServicio,
			Integer idClase);

	/**
	 * Calcula el numero de partes correctivos asignados manualmente y
	 * pendientes de ejecutar.
	 * 
	 * @param UIDUsuario
	 *            String
	 * @param idServicio
	 *            Integer
	 * @return Long
	 */

	public Long calculaCorrAsigMan(String UIDUsuario, Integer idServicio,
			Integer idClase);

	/**
	 * Finds rows in the Partes table using like.
	 * 
	 * @param partes
	 *            Partes
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param UIDUsuario
	 *            String
	 * @return List
	 */
	List<Partes> obtenerCorrPendAsignar(Partes partes, Pagination pagination,
			Boolean startsWith, String UIDUsuario);

	/**
	 * Counts rows in the Partes table using like.
	 * 
	 * @param partes
	 *            Partes
	 * @param startsWith
	 *            Boolean
	 * @param UIDUsuario
	 *            String
	 * @return Long
	 */
	Long obtenerCorrPendAsignarCount(Partes partes, Boolean startsWith,
			String UIDUsuario);

	/**
	 * Finds rows in the Partes table using like.
	 * 
	 * @param partes
	 *            Partes
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param UIDUsuario
	 *            String
	 * @return List
	 */
	List<Partes> obtenerCorrAut(Partes partes, Pagination pagination,
			Boolean startsWith, String UIDUsuario);

	/**
	 * Counts rows in the Partes table using like.
	 * 
	 * @param partes
	 *            Partes
	 * @param startsWith
	 *            Boolean
	 * @param UIDUsuario
	 *            String
	 * @return Long
	 */
	Long obtenerCorrAutCount(Partes partes, Boolean startsWith,
			String UIDUsuario);

	/**
	 * Finds rows in the Partes table using like.
	 * 
	 * @param partes
	 *            Partes
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param UIDUsuario
	 *            String
	 * @return List
	 */
	List<Partes> obtenerCorrMan(Partes partes, Pagination pagination,
			Boolean startsWith, String UIDUsuario);

	/**
	 * Counts rows in the Partes table using like.
	 * 
	 * @param partes
	 *            Partes
	 * @param startsWith
	 *            Boolean
	 * @param UIDUsuario
	 *            String
	 * @return Long
	 */
	Long obtenerCorrManCount(Partes partes, Boolean startsWith,
			String UIDUsuario);

	/**
	 * Finds a List of rows in the Ficha table.
	 * 
	 * @param filtro
	 *            Partes
	 * @param idioma
	 *            String
	 * @param UIDUsuario
	 *            String
	 * @return List
	 */
	ArrayList<TablaInformes> montarSelectTablaCorrPendAsignar(String idioma,
			Partes filtro, String UIDUsuario);

	/**
	 * Finds a List of rows in the Ficha table.
	 * 
	 * @param filtro
	 *            Partes
	 * @param idioma
	 *            String
	 * @param UIDUsuario
	 *            String
	 * @return List
	 */
	ArrayList<TablaInformes> montarSelectTablaCorrPendEjecAuto(String idioma,
			Partes filtro, String UIDUsuario);

	/**
	 * Finds a List of rows in the Ficha table.
	 * 
	 * @param filtro
	 *            Partes
	 * @param idioma
	 *            String
	 * @param UIDUsuario
	 *            String
	 * @return List
	 */
	ArrayList<TablaInformes> montarSelectTablaCorrPendEjecManual(String idioma,
			Partes filtro, String UIDUsuario);

	/**
	 * Finds a List of rows in the Ficha table.
	 * 
	 * @param filtro
	 *            Partes
	 * @param idioma
	 *            String
	 * @param UIDUsuario
	 *            String
	 * @return List
	 */
	ArrayList<TablaInformes> montarSelectTablaCorrectivos(String idioma,
			Partes filtro, String UIDUsuario);

	/**
	 * Finds a List of rows in the Ficha table.
	 * 
	 * @param filtro
	 *            Partes
	 * @param idioma
	 *            String
	 * @param UIDUsuario
	 *            String
	 * @return List
	 */
	ArrayList<TablaInformes> montarSelectTablaEjecTecnico(String idioma,
			Partes filtro, String UIDUsuario);

	/**
	 * Finds a List of rows in the Ficha table.
	 * 
	 * @param filtro
	 *            Partes
	 * @param idioma
	 *            String
	 * @param UIDUsuario
	 *            String
	 * @return List
	 */
	ArrayList<TablaInformes> montarSelectTablaEjecFechaEj(String idioma,
			Partes filtro, String UIDUsuario);

	/**
	 * Obtiene el valor de una variable de la tabla VARIABLES_CORREO(AA2036T00)
	 * 
	 * @param variableCorreo
	 *            String
	 * @return String
	 */
	String obtenerVariableCorreo(String variableCorreo);

	/**
	 * Obtener parte pendiente de ejecución asociado a un tecnico y
	 * Edificio/Zona.
	 * 
	 * @param idEdificio
	 *            String
	 * @param idZona
	 *            Integer
	 * @param idTecnico
	 *            Long
	 * @return List
	 */
	List<Partes> comprobarParteZonaTecnico(String idEdificio, Integer idZona,
			Long idTecnico);

	Partes actualizarUUIDparte(Partes partes);

	Partes actualizarFechaPlanificacion(Partes partes);

	Partes actualizarInfoNoProcede(Partes partes);

}
