package com.ejie.aa20b.dao;

import com.ejie.x38.dto.Pagination;

import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.Parteplano;

/**
 * ParteplanoDaoImpl generated by UDA, 13-ene-2015 13:00:39.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class ParteplanoDaoImpl implements ParteplanoDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Parteplano> rwMap = new RowMapper<Parteplano>() {
		public Parteplano mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Parteplano(resultSet.getInt("IDPARTE"),
					resultSet.getBlob("DIBUJO"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Parteplano table.
	 * 
	 * @param parteplano
	 *            Pagination
	 * @return Parteplano
	 */
	public Parteplano add(Parteplano parteplano) {
		String query = "INSERT INTO PARTEPLANO (IDPARTE, DIBUJO) VALUES (?,?)";
		this.jdbcTemplate.update(query, parteplano.getIdparte(),
				parteplano.getDibujo());
		return parteplano;
	}

	/**
	 * Updates a single row in the Parteplano table.
	 * 
	 * @param parteplano
	 *            Pagination
	 * @return Parteplano
	 */
	public Parteplano update(Parteplano parteplano) {
		String query = "UPDATE PARTEPLANO SET DIBUJO=? WHERE IDPARTE=?";
		this.jdbcTemplate.update(query, parteplano.getDibujo(),
				parteplano.getIdparte());
		return parteplano;
	}

	public byte[] buscaDibujo(Parteplano parteplano) {

		StringBuilder query = new StringBuilder(
				"SELECT t1.IDPARTE, t1.DIBUJO DIBUJO ");
		query.append("FROM PARTEPLANO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(parteplano);
		StringBuilder where = new StringBuilder(" WHERE 1=1");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		List<Parteplano> planosList = this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
		Parteplano planoEncontrado = (Parteplano) DataAccessUtils
				.uniqueResult(planosList);

		byte[] dibujo = null;
		Blob blob = planoEncontrado.getDibujo();
		if (blob != null)
			try {
				dibujo = blob.getBytes(1, (int) blob.length());
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}

		return dibujo;
	}

	/**
	 * Finds a single row in the Parteplano table.
	 * 
	 * @param parteplano
	 *            Pagination
	 * @return Parteplano
	 */
	@Transactional(readOnly = true)
	public Parteplano find(Parteplano parteplano) {
		String query = "SELECT t1.IDPARTE IDPARTE, t1.DIBUJO DIBUJO FROM PARTEPLANO t1  WHERE t1.IDPARTE = ?  ";

		List<Parteplano> parteplanoList = this.jdbcTemplate.query(query,
				this.rwMap, parteplano.getIdparte());
		return (Parteplano) DataAccessUtils.uniqueResult(parteplanoList);
	}

	/**
	 * Removes a single row in the Parteplano table.
	 * 
	 * @param parteplano
	 *            Pagination
	 * @return
	 */
	public void remove(Parteplano parteplano) {
		String query = "DELETE FROM PARTEPLANO WHERE IDPARTE=?";
		this.jdbcTemplate.update(query, parteplano.getIdparte());
	}

	/**
	 * Finds a List of rows in the Parteplano table.
	 * 
	 * @param parteplano
	 *            Parteplano
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Parteplano> findAll(Parteplano parteplano, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDPARTE IDPARTE,t1.DIBUJO DIBUJO ");
		query.append("FROM PARTEPLANO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(parteplano);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Parteplano>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Parteplano table.
	 * 
	 * @param parteplano
	 *            Parteplano
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Parteplano parteplano) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM PARTEPLANO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(parteplano);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Parteplano table using like.
	 * 
	 * @param parteplano
	 *            Parteplano
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Parteplano> findAllLike(Parteplano parteplano,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDPARTE IDPARTE,t1.DIBUJO DIBUJO ");
		query.append("FROM PARTEPLANO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(parteplano, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Parteplano>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Parteplano table using like.
	 * 
	 * @param parteplano
	 *            Parteplano
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Parteplano parteplano, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM PARTEPLANO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(parteplano, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Parteplano entity
	 * 
	 * @param parteplano
	 *            Parteplano Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Parteplano parteplano) {

		StringBuilder where = new StringBuilder(
				ParteplanoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (parteplano != null && parteplano.getIdparte() != null) {
			where.append(" AND t1.IDPARTE = ?");
			params.add(parteplano.getIdparte());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Parteplano entity
	 * 
	 * @param parteplano
	 *            Parteplano Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Parteplano parteplano,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				ParteplanoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (parteplano != null && parteplano.getIdparte() != null) {
			where.append(" AND t1.IDPARTE = ?");
			params.add(parteplano.getIdparte());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

}
