package com.ejie.aa20b.dao;

import com.ejie.x38.dto.Pagination;

import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.Partefirma;

/**
 * PartefirmaDaoImpl generated by UDA, 13-ene-2015 13:00:39.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class PartefirmaDaoImpl implements PartefirmaDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Partefirma> rwMap = new RowMapper<Partefirma>() {
		public Partefirma mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Partefirma(resultSet.getInt("IDPARTE"),
					resultSet.getInt("IDTECNICO"),
					resultSet.getInt("IDPARTEC"), resultSet.getBlob("FIRMA"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Partefirma table.
	 * 
	 * @param Partefirma
	 *            Pagination
	 * @return Partefirma
	 */
	public Partefirma add(Partefirma Partefirma) {
		String query = "INSERT INTO PARTESGMAOFIRMA (IDPARTE, IDTECNICO, IDPARTEC, FIRMA) VALUES (?,?,?,?)";
		this.jdbcTemplate.update(query, Partefirma.getIdparte(),
				Partefirma.getIdtecnico(), Partefirma.getIdpartec(),
				Partefirma.getFirmaArray());
		return Partefirma;
	}

	/**
	 * Updates a single row in the Partefirma table.
	 * 
	 * @param Partefirma
	 *            Pagination
	 * @return Partefirma
	 */
	public Partefirma update(Partefirma Partefirma) {
		String query = "UPDATE PARTESGMAOFIRMA SET FIRMA=? WHERE IDPARTE=? AND IDTECNICO=? AND IDPARTEC=?";
		this.jdbcTemplate.update(query, Partefirma.getFirmaArray(),
				Partefirma.getIdparte(), Partefirma.getIdtecnico(),
				Partefirma.getIdpartec());
		return Partefirma;
	}

	public byte[] buscaFirma(Partefirma Partefirma) {

		StringBuilder query = new StringBuilder(
				"SELECT t1.IDPARTE, t1.IDTECNICO, t1.IDPARTEC, t1.FIRMA FIRMA ");
		query.append("FROM PARTESGMAOFIRMA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(Partefirma);
		StringBuilder where = new StringBuilder(" WHERE 1=1");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		List<Partefirma> planosList = this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
		Partefirma firmaEncontrada = (Partefirma) DataAccessUtils
				.uniqueResult(planosList);

		byte[] firma = null;
		Blob blob = firmaEncontrada.getFirma();
		if (blob != null)
			try {
				firma = blob.getBytes(1, (int) blob.length());
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}

		return firma;
	}

	/**
	 * Finds a single row in the Partefirma table.
	 * 
	 * @param Partefirma
	 *            Pagination
	 * @return Partefirma
	 */
	@Transactional(readOnly = true)
	public Partefirma find(Partefirma Partefirma) {
		String query = "SELECT t1.IDPARTE IDPARTE, t1.IDTECNICO IDTECNICO, t1.IDPARTEC IDPARTEC, t1.FIRMA FIRMA FROM PARTESGMAOFIRMA t1  WHERE t1.IDPARTE = ? AND t1.IDTECNICO=? AND t1.IDPARTEC=?  ";

		List<Partefirma> PartefirmaList = this.jdbcTemplate.query(query,
				this.rwMap, Partefirma.getIdparte(), Partefirma.getIdtecnico(),
				Partefirma.getIdpartec());
		return (Partefirma) DataAccessUtils.uniqueResult(PartefirmaList);
	}

	/**
	 * Removes a single row in the Partefirma table.
	 * 
	 * @param Partefirma
	 *            Pagination
	 * @return
	 */
	public void remove(Partefirma Partefirma) {
		String query = "DELETE FROM PARTESGMAOFIRMA WHERE IDPARTE=? AND IDTECNICO=? AND IDPARTEC=?";
		this.jdbcTemplate.update(query, Partefirma.getIdparte(),
				Partefirma.getIdtecnico(), Partefirma.getIdpartec());
	}

	/**
	 * Finds a List of rows in the Partefirma table.
	 * 
	 * @param Partefirma
	 *            Partefirma
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Partefirma> findAll(Partefirma Partefirma, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDPARTE IDPARTE, t1.IDTECNICO IDTECNICO, t1.IDPARTEC IDPARTEC, t1.FIRMA FIRMA ");
		query.append("FROM PARTESGMAOFIRMA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(Partefirma);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Partefirma>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Partefirma table.
	 * 
	 * @param Partefirma
	 *            Partefirma
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Partefirma Partefirma) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM PARTESGMAOFIRMA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(Partefirma);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Partefirma table using like.
	 * 
	 * @param Partefirma
	 *            Partefirma
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Partefirma> findAllLike(Partefirma Partefirma,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDPARTE IDPARTE, t1.IDTECNICO IDTECNICO, t1.IDPARTEC IDPARTEC, t1.FIRMA FIRMA ");
		query.append("FROM PARTESGMAOFIRMA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(Partefirma, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Partefirma>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Partefirma table using like.
	 * 
	 * @param Partefirma
	 *            Partefirma
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Partefirma Partefirma, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM PARTESGMAOFIRMA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(Partefirma, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Partefirma entity
	 * 
	 * @param Partefirma
	 *            Partefirma Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Partefirma Partefirma) {

		StringBuilder where = new StringBuilder(
				PartefirmaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (Partefirma != null && Partefirma.getIdparte() != null) {
			where.append(" AND t1.IDPARTE = ?");
			params.add(Partefirma.getIdparte());
		}

		if (Partefirma != null && Partefirma.getIdtecnico() != null) {
			where.append(" AND t1.IDTECNICO = ?");
			params.add(Partefirma.getIdtecnico());
		}

		if (Partefirma != null && Partefirma.getIdpartec() != null) {
			where.append(" AND t1.IDPARTEC = ?");
			params.add(Partefirma.getIdpartec());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Partefirma entity
	 * 
	 * @param Partefirma
	 *            Partefirma Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Partefirma Partefirma,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				PartefirmaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (Partefirma != null && Partefirma.getIdparte() != null) {
			where.append(" AND t1.IDPARTE = ?");
			params.add(Partefirma.getIdparte());
		}
		if (Partefirma != null && Partefirma.getIdtecnico() != null) {
			where.append(" AND t1.IDTECNICO = ?");
			params.add(Partefirma.getIdtecnico());
		}

		if (Partefirma != null && Partefirma.getIdpartec() != null) {
			where.append(" AND t1.IDPARTEC = ?");
			params.add(Partefirma.getIdpartec());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

}
