package com.ejie.aa20b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.Parteejecucion;

/**
 * ParteejecucionDaoImpl generated by UDA, 22-ene-2015 12:41:36.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class ParteejecucionDaoImpl implements ParteejecucionDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Parteejecucion> rwMap = new RowMapper<Parteejecucion>() {
		public Parteejecucion mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Parteejecucion(resultSet.getInt("IDPAREJE"),
					resultSet.getInt("IDPARTEC"),
					resultSet.getTimestamp("FEINI"),
					resultSet.getTimestamp("FEFIN"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Parteejecucion table.
	 * 
	 * @param parteejecucion
	 *            Pagination
	 * @return Parteejecucion
	 */
	public Parteejecucion add(Parteejecucion parteejecucion) {

		final Integer nextId = this.jdbcTemplate
				.queryForInt("SELECT PAREJEC_SEQ.NEXTVAL FROM DUAL");

		parteejecucion.setIdpareje(nextId);

		String query = "INSERT INTO PARTEEJECUCION (IDPAREJE, IDPARTEC, FEINI, FEFIN) VALUES (?,?,?,?)";
		this.jdbcTemplate.update(query, parteejecucion.getIdpareje(),
				parteejecucion.getIdpartec(), parteejecucion.getFeini(),
				parteejecucion.getFefin());
		return parteejecucion;
	}

	/**
	 * Inserts a single row in the Parteejecucion table.
	 * 
	 * @param parteejecucion
	 *            Pagination
	 * @return Parteejecucion
	 */
	public Parteejecucion fechasEjecCorrectas(Parteejecucion parteejecucion) {
		// Se comprobara que las fechas/horas introducidas no son incongruentes
		// con otras ejecuciones de ese tecnico y parte
		// la fecha de inicio no puede estar entre la fecha inicio y fecha fin
		// de otra ejecucion
		// la fecha de fin no puede estar entre la fecha inicio y fecha fin de
		// otra ejecucion

		// Comprobacion nueva fecha de inicio
		StringBuilder query = new StringBuilder(
				"SELECT t1.IDPAREJE IDPAREJE, t1.IDPARTEC IDPARTEC, t1.FEINI FEINI, t1.FEFIN FEFIN FROM PARTEEJECUCION t1 ");

		StringBuilder where = new StringBuilder(
				" WHERE IDPARTEC=? AND FEINI<? AND FEFIN>? ");
		query.append(where);

		// List<Parteejecucion> partesEncontrado = (List<Parteejecucion>) new
		// Parteejecucion();

		List<Parteejecucion> partesEncontrado = this.jdbcTemplate.query(
				query.toString(), this.rwMap, parteejecucion.getIdpartec(),
				parteejecucion.getFeini(), parteejecucion.getFeini());
		if (partesEncontrado.size() > 0) {
			// Ha encontrado algun registro. No se puede dar de alta la nueva
			// ejecucion
			return partesEncontrado.get(0);
		} else {
			// no ha encontrado ningun registro. Se comprueba la nueva fecha de
			// fin.
			query = new StringBuilder(
					"SELECT t1.IDPAREJE IDPAREJE, t1.IDPARTEC IDPARTEC, t1.FEINI FEINI, t1.FEFIN FEFIN FROM PARTEEJECUCION t1 ");

			where = new StringBuilder(
					" WHERE IDPARTEC=? AND FEINI<? AND FEFIN>? ");
			query.append(where);

			partesEncontrado = this.jdbcTemplate.query(query.toString(),
					this.rwMap, parteejecucion.getIdpartec(),
					parteejecucion.getFefin(), parteejecucion.getFefin());
			if (partesEncontrado.size() > 0) {
				// Ha encontrado algun registro. No se puede dar de alta la
				// nueva ejecucion
				return partesEncontrado.get(0);
			} else {
				// no ha encontrado ningun registro. Se comprueba que no haya
				// otra ejecución en medio de las fechas/horas de inicio y fin
				// de la nueva ejecución
				query = new StringBuilder(
						"SELECT t1.IDPAREJE IDPAREJE, t1.IDPARTEC IDPARTEC, t1.FEINI FEINI, t1.FEFIN FEFIN FROM PARTEEJECUCION t1 ");

				where = new StringBuilder(
						" WHERE IDPARTEC=? AND FEINI>? AND FEFIN<? ");
				query.append(where);

				partesEncontrado = this.jdbcTemplate.query(query.toString(),
						this.rwMap, parteejecucion.getIdpartec(),
						parteejecucion.getFeini(), parteejecucion.getFefin());
				if (partesEncontrado.size() > 0) {
					// Ha encontrado algun registro. No se puede dar de alta la
					// nueva ejecucion
					return partesEncontrado.get(0);
				} else {
					// no ha encontrado ningun registro. Fechas de la nueva
					// ejecución correctas.
					return null;
				}
			}

		}
	}

	/**
	 * Updates a single row in the Parteejecucion table.
	 * 
	 * @param parteejecucion
	 *            Pagination
	 * @return Parteejecucion
	 */
	public Parteejecucion update(Parteejecucion parteejecucion) {
		String query = "UPDATE PARTEEJECUCION SET IDPARTEC=?, FEINI=?, FEFIN=? WHERE IDPAREJE=?";
		this.jdbcTemplate.update(query, parteejecucion.getIdpartec(),
				parteejecucion.getFeini(), parteejecucion.getFefin(),
				parteejecucion.getIdpareje());
		return parteejecucion;
	}

	/**
	 * Updates a single row in the Parteejecucion table.
	 * 
	 * @param parteejecucion
	 *            Pagination
	 * @return Parteejecucion
	 */
	public Parteejecucion modificarFechasEjec(Parteejecucion parteejecucion) {
		String query = "UPDATE PARTEEJECUCION SET FEINI=?, FEFIN=? WHERE IDPAREJE=?";
		this.jdbcTemplate.update(query, parteejecucion.getFeini(),
				parteejecucion.getFefin(), parteejecucion.getIdpareje());
		return parteejecucion;
	}

	/**
	 * Finds a single row in the Parteejecucion table.
	 * 
	 * @param parteejecucion
	 *            Pagination
	 * @return Parteejecucion
	 */
	@Transactional(readOnly = true)
	public Parteejecucion find(Parteejecucion parteejecucion) {
		String query = "SELECT t1.IDPAREJE IDPAREJE, t1.IDPARTEC IDPARTEC, t1.FEINI FEINI, t1.FEFIN FEFIN FROM PARTEEJECUCION t1  WHERE t1.IDPAREJE = ?  ";

		List<Parteejecucion> parteejecucionList = this.jdbcTemplate.query(
				query, this.rwMap, parteejecucion.getIdpareje());
		return (Parteejecucion) DataAccessUtils
				.uniqueResult(parteejecucionList);
	}

	/**
	 * Calcula el tiempo total de ejecucion de un parte tecnico y actualiza el
	 * campo TIEMPOREAL de la tabla PARTETECNICOS.
	 * 
	 * @param idParteTec
	 *            Integer
	 * @return Integer
	 */
	public Boolean recalcularTiempoParteTecnico(Integer idParteTec) {

		String query = "SELECT SUM(ROUND((t1.FEFIN - t1.FEINI)*24*60, 2)) Dif FROM PARTEEJECUCION t1  WHERE t1.IDPARTEC = ?  ";

		Integer totalMinutos = this.jdbcTemplate.queryForInt(query.toString(),
				idParteTec);

		query = "UPDATE PARTETECNICOS SET TIEMPOREAL=? WHERE IDPARTEC=?";
		Integer regAct = this.jdbcTemplate.update(query, totalMinutos,
				idParteTec);

		if (regAct > 0) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * Removes a single row in the Parteejecucion table.
	 * 
	 * @param parteejecucion
	 *            Pagination
	 * @return
	 */
	public void remove(Parteejecucion parteejecucion) {
		String query = "DELETE FROM PARTEEJECUCION WHERE IDPAREJE=?";
		this.jdbcTemplate.update(query, parteejecucion.getIdpareje());
	}

	/**
	 * Finds a List of rows in the Parteejecucion table.
	 * 
	 * @param parteejecucion
	 *            Parteejecucion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Parteejecucion> findAll(Parteejecucion parteejecucion,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDPAREJE IDPAREJE,t1.IDPARTEC IDPARTEC,t1.FEINI FEINI,t1.FEFIN FEFIN ");
		query.append("FROM PARTEEJECUCION t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(parteejecucion);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Parteejecucion>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Parteejecucion table.
	 * 
	 * @param parteejecucion
	 *            Parteejecucion
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Parteejecucion parteejecucion) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM PARTEEJECUCION t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(parteejecucion);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Parteejecucion table using like.
	 * 
	 * @param parteejecucion
	 *            Parteejecucion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Parteejecucion> findAllLike(Parteejecucion parteejecucion,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDPAREJE IDPAREJE,t1.IDPARTEC IDPARTEC,t1.FEINI FEINI,t1.FEFIN FEFIN ");
		query.append("FROM PARTEEJECUCION t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(parteejecucion,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Parteejecucion>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Parteejecucion table using like.
	 * 
	 * @param parteejecucion
	 *            Parteejecucion
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Parteejecucion parteejecucion,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM PARTEEJECUCION t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(parteejecucion,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Parteejecucion entity
	 * 
	 * @param parteejecucion
	 *            Parteejecucion Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Parteejecucion parteejecucion) {

		StringBuilder where = new StringBuilder(
				ParteejecucionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (parteejecucion != null && parteejecucion.getIdpareje() != null) {
			where.append(" AND t1.IDPAREJE = ?");
			params.add(parteejecucion.getIdpareje());
		}
		if (parteejecucion != null && parteejecucion.getIdpartec() != null) {
			where.append(" AND t1.IDPARTEC = ?");
			params.add(parteejecucion.getIdpartec());
		}
		if (parteejecucion != null && parteejecucion.getFeini() != null) {
			where.append(" AND t1.FEINI = ?");
			params.add(parteejecucion.getFeini());
		}
		if (parteejecucion != null && parteejecucion.getFefin() != null) {
			where.append(" AND t1.FEFIN = ?");
			params.add(parteejecucion.getFefin());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Parteejecucion entity
	 * 
	 * @param parteejecucion
	 *            Parteejecucion Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Parteejecucion parteejecucion,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				ParteejecucionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (parteejecucion != null && parteejecucion.getIdpareje() != null) {
			where.append(" AND t1.IDPAREJE = ?");
			params.add(parteejecucion.getIdpareje());
		}
		if (parteejecucion != null && parteejecucion.getIdpartec() != null) {
			where.append(" AND t1.IDPARTEC = ?");
			params.add(parteejecucion.getIdpartec());
		}
		if (parteejecucion != null && parteejecucion.getFeini() != null) {
			where.append(" AND t1.FEINI = ?");
			params.add(parteejecucion.getFeini());
		}
		if (parteejecucion != null && parteejecucion.getFefin() != null) {
			where.append(" AND t1.FEFIN = ?");
			params.add(parteejecucion.getFefin());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
