package com.ejie.aa20b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.aa20b.model.Parteejecucion;

/**
 * ParteejecucionDao generated by UDA, 22-ene-2015 12:41:36.
 * 
 * @author UDA
 */

public interface ParteejecucionDao {

	/**
	 * Inserts a single row in the Parteejecucion table.
	 * 
	 * @param parteejecucion
	 *            Parteejecucion
	 * @return Parteejecucion
	 */
	Parteejecucion add(Parteejecucion parteejecucion);

	/**
	 * Inserts a single row in the Parteejecucion table.
	 * 
	 * @param parteejecucion
	 *            Parteejecucion
	 * @return Parteejecucion
	 */
	Parteejecucion fechasEjecCorrectas(Parteejecucion parteejecucion);

	/**
	 * Updates a single row in the Parteejecucion table.
	 * 
	 * @param parteejecucion
	 *            Parteejecucion
	 * @return Parteejecucion
	 */
	Parteejecucion update(Parteejecucion parteejecucion);

	/**
	 * Updates a single row in the Parteejecucion table.
	 * 
	 * @param parteejecucion
	 *            Parteejecucion
	 * @return Parteejecucion
	 */
	Parteejecucion modificarFechasEjec(Parteejecucion parteejecucion);

	/**
	 * Finds a single row in the Parteejecucion table.
	 * 
	 * @param parteejecucion
	 *            Parteejecucion
	 * @return Parteejecucion
	 */
	Parteejecucion find(Parteejecucion parteejecucion);

	/**
	 * Calcula el tiempo total de ejecucion de un parte tecnico y actualiza el
	 * campo TIEMPOREAL de la tabla PARTETECNICOS.
	 * 
	 * @param idParteTec
	 *            Integer
	 * @return Boolean
	 */
	Boolean recalcularTiempoParteTecnico(Integer idParteTec);

	/**
	 * Deletes a single row in the Parteejecucion table.
	 * 
	 * @param parteejecucion
	 *            Parteejecucion
	 * @return
	 */
	void remove(Parteejecucion parteejecucion);

	/**
	 * Finds a List of rows in the Parteejecucion table.
	 * 
	 * @param parteejecucion
	 *            Parteejecucion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Parteejecucion> findAll(Parteejecucion parteejecucion,
			Pagination pagination);

	/**
	 * Counts rows in the Parteejecucion table.
	 * 
	 * @param parteejecucion
	 *            Parteejecucion
	 * @return Long
	 */
	Long findAllCount(Parteejecucion parteejecucion);

	/**
	 * Finds rows in the Parteejecucion table using like.
	 * 
	 * @param parteejecucion
	 *            Parteejecucion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Parteejecucion> findAllLike(Parteejecucion parteejecucion,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Parteejecucion table using like.
	 * 
	 * @param parteejecucion
	 *            Parteejecucion
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Parteejecucion parteejecucion, Boolean startsWith);
}
