package com.ejie.aa20b.dao;

import com.ejie.x38.dto.Pagination;

import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.Partepdf;

/**
 * PartepdfDaoImpl generated by UDA, 13-ene-2015 13:00:39.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class PartePdfDaoImpl implements PartePdfDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Partepdf> rwMap = new RowMapper<Partepdf>() {
		public Partepdf mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Partepdf(resultSet.getInt("IDPARTE"),
					resultSet.getBlob("PDF"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Partepdf table.
	 * 
	 * @param partepdf
	 *            Pagination
	 * @return Partepdf
	 */
	public Partepdf add(Partepdf partepdf) {
		String query = "INSERT INTO PARTEPDF (IDPARTE, PDF) VALUES (?,?)";
		this.jdbcTemplate.update(query, partepdf.getIdparte(),
				partepdf.getPdf());
		return partepdf;
	}

	/**
	 * Updates a single row in the Partepdf table.
	 * 
	 * @param partepdf
	 *            Pagination
	 * @return Partepdf
	 */
	public Partepdf update(Partepdf partepdf) {
		String query = "UPDATE PARTEPDF SET PDF=? WHERE IDPARTE=?";
		this.jdbcTemplate.update(query, partepdf.getPdf(),
				partepdf.getIdparte());
		return partepdf;
	}

	public byte[] buscaPdf(Partepdf partepdf) {

		StringBuilder query = new StringBuilder(
				"SELECT t1.IDPARTE, t1.PDF PDF ");
		query.append("FROM PARTEPDF t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(partepdf);
		StringBuilder where = new StringBuilder(" WHERE 1=1");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		List<Partepdf> planosList = this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
		Partepdf pdfEncontrado = (Partepdf) DataAccessUtils
				.uniqueResult(planosList);

		byte[] pdf = null;
		if (pdfEncontrado != null) {
			Blob blob = pdfEncontrado.getPdf();
			if (blob != null)
				try {
					pdf = blob.getBytes(1, (int) blob.length());
				} catch (SQLException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
		}
		return pdf;
	}

	/**
	 * Finds a single row in the Partepdf table.
	 * 
	 * @param partepdf
	 *            Pagination
	 * @return Partepdf
	 */
	@Transactional(readOnly = true)
	public Partepdf find(Partepdf partepdf) {
		String query = "SELECT t1.IDPARTE IDPARTE, t1.PDF PDF FROM PARTEPDF t1  WHERE t1.IDPARTE = ?  ";

		List<Partepdf> partepdfList = this.jdbcTemplate.query(query,
				this.rwMap, partepdf.getIdparte());
		return (Partepdf) DataAccessUtils.uniqueResult(partepdfList);
	}

	/**
	 * Removes a single row in the Partepdf table.
	 * 
	 * @param partepdf
	 *            Pagination
	 * @return
	 */
	public void remove(Partepdf partepdf) {
		String query = "DELETE FROM PARTEPDF WHERE IDPARTE=?";
		this.jdbcTemplate.update(query, partepdf.getIdparte());
	}

	/**
	 * Finds a List of rows in the Partepdf table.
	 * 
	 * @param partepdf
	 *            Partepdf
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Partepdf> findAll(Partepdf partepdf, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDPARTE IDPARTE,t1.PDF PDF ");
		query.append("FROM PARTEPDF t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(partepdf);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Partepdf>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Partepdf table.
	 * 
	 * @param partepdf
	 *            Partepdf
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Partepdf partepdf) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM PARTEPDF t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(partepdf);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Partepdf table using like.
	 * 
	 * @param partepdf
	 *            Partepdf
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Partepdf> findAllLike(Partepdf partepdf, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDPARTE IDPARTE,t1.PDF PDF ");
		query.append("FROM PARTEPDF t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(partepdf, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Partepdf>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Partepdf table using like.
	 * 
	 * @param partepdf
	 *            Partepdf
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Partepdf partepdf, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM PARTEPDF t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(partepdf, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Partepdf entity
	 * 
	 * @param partepdf
	 *            Partepdf Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Partepdf partepdf) {

		StringBuilder where = new StringBuilder(
				PartePdfDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (partepdf != null && partepdf.getIdparte() != null) {
			where.append(" AND t1.IDPARTE = ?");
			params.add(partepdf.getIdparte());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Partepdf entity
	 * 
	 * @param partepdf
	 *            Partepdf Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Partepdf partepdf, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				PartePdfDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (partepdf != null && partepdf.getIdparte() != null) {
			where.append(" AND t1.IDPARTE = ?");
			params.add(partepdf.getIdparte());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

}
