package com.ejie.aa20b.dao;

import com.ejie.x38.dto.Pagination;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.classes.Aa20bFecha;
import com.ejie.aa20b.model.ActAnual;
import com.ejie.aa20b.model.Edificios;
import com.ejie.aa20b.model.Gamas;
import com.ejie.aa20b.model.Maquinas;
import com.ejie.aa20b.model.PlanGeneral;
import com.ejie.aa20b.model.Plantas;
import com.ejie.aa20b.model.PrevAnual;
import com.ejie.aa20b.model.Zonas;
import com.ejie.aa20b.util.Aa20bConstantes;

/**
 * MaquinasDaoImpl generated by UDA, 04-mar-2015 15:44:06.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class MaquinasDaoImpl implements MaquinasDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Maquinas> rwMap = new RowMapper<Maquinas>() {
		public Maquinas mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Maquinas(resultSet.getLong("IDMAQUINA"),
					resultSet.getString("MCODIGO"),
					resultSet.getLong("IDGAMA"),
					resultSet.getString("CMAQUINA"),
					resultSet.getString("EMAQUINA"),
					resultSet.getDate("PRIMERMTO"),
					resultSet.getDate("SIGMTO"),
					resultSet.getString("IDEDIFICIO"),
					resultSet.getInt("IDZONA"), resultSet.getInt("IDPLANTA"),
					resultSet.getDate("FEINI"), resultSet.getString("BAJA"),
					null, null, null, null, null);
		}
	};

	@SuppressWarnings("rawtypes")
	private RowMapper<HashMap<String, String>> rwMapPlanGeneralTodos = new RowMapper<HashMap<String, String>>() {
		public HashMap<String, String> mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			// ArrayList<HashMap<String, String>> listaPlan = new
			// ArrayList<HashMap<String, String>>();

			Calendar calendar = Calendar.getInstance(Locale.GERMAN);
			calendar.setFirstDayOfWeek(Calendar.MONDAY);
			calendar.setMinimalDaysInFirstWeek(4);
			int semanaDelAnio = 99; // Pongo 99 para que no salga en la tabla

			calendar.setTime(calendar.getTime());

			String idioma = LocaleContextHolder.getLocale().getLanguage();

			HashMap<String, String> maquinaPlan = new HashMap<String, String>();
			maquinaPlan.put("tabla", resultSet.getString("tabla"));
			maquinaPlan.put("clave", resultSet.getString("clave"));
			maquinaPlan.put("mcodigo", resultSet.getString("mcodigo"));
			maquinaPlan.put("idmaquina", resultSet.getString("idmaquina"));
			maquinaPlan.put("cmaquina", resultSet.getString("cmaquina"));
			maquinaPlan.put("emaquina", resultSet.getString("emaquina"));

			int aniobusqueda = calendar.get(Calendar.YEAR);
			if (resultSet.getString("fechaBusq") != null
					&& !resultSet.getString("fechaBusq").equals("")) {
				aniobusqueda = Integer
						.valueOf(resultSet.getString("fechaBusq")).intValue();
			}

			SimpleDateFormat sdf;
			Calendar fechaInicio = new GregorianCalendar();
			Calendar fechaFin = new GregorianCalendar();
			Calendar c = Calendar.getInstance(Locale.GERMAN);

			int semanaActual = c.get(Calendar.WEEK_OF_YEAR);
			maquinaPlan.put("semanaActual", semanaActual + "");

			Calendar fechaFinAnio = new GregorianCalendar();

			// Calcular la semana actual
			sdf = new SimpleDateFormat("yyyy/MM/dd");
			String sFecFinAnio = aniobusqueda + "/12/31";
			Date treintayunoDeDic = null;
			try {
				treintayunoDeDic = sdf.parse(sFecFinAnio);
			} catch (ParseException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			fechaFinAnio.setTime(treintayunoDeDic);

			String sFecInicio = aniobusqueda + "/01/01";
			Date unoDeEnero = null;
			try {
				unoDeEnero = sdf.parse(sFecInicio);
			} catch (ParseException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			fechaInicio.setTime(unoDeEnero);
			fechaFin.setTime(calendar.getTime());
			c.setTimeInMillis(fechaFin.getTime().getTime()
					- fechaInicio.getTime().getTime());
			// int nDifDias = c.get(Calendar.DAY_OF_YEAR);

			// int semanaActual = nDifDias / 7;
			// maquinaPlan.put("semanaActual", semanaActualAño + "");

			Calendar fechaAccion = Calendar.getInstance(Locale.GERMAN);
			fechaAccion.setFirstDayOfWeek(Calendar.MONDAY);
			fechaAccion.setMinimalDaysInFirstWeek(4);
			boolean valido = true;
			if (resultSet.getString("tabla").equals("M")) {
				if (resultSet.getString("SIGMTO") != null) {
					fechaAccion.setTime(resultSet.getDate("SIGMTO"));
					// Si la fecha de mantenimiento es menor que el uno de enero
					// se pintará una M con un color de fondo para distinguirla
					// de las M del año actual
					if (fechaAccion.before(fechaInicio)) {
						maquinaPlan.put("anioAteriorM", "SI");
					} else {
						maquinaPlan.put("anioAteriorM", "NO");
					}
					// Si la fecha de mantenimiento es mayor que el 31 de
					// Diciembre
					// se pintará una M con un color de fondo para distinguirla
					// de las M del año actual
					if (fechaAccion.after(fechaFinAnio)) {
						maquinaPlan.put("anioSiguienteM", "SI");
					} else {
						maquinaPlan.put("anioSiguienteM", "NO");
					}
					valido = true;
				} else {
					valido = false;
					maquinaPlan.put("anioAteriorM", "NO");
					maquinaPlan.put("anioSiguienteM", "NO");
				}
				maquinaPlan.put("ejecutadoParte", "");
				maquinaPlan.put("ejecutadoFicha", "");
			} else if (resultSet.getString("tabla").equals("F")) {
				fechaAccion.setTime(resultSet.getDate("fichaFeeje"));
				maquinaPlan.put("ejecutadoFicha",
						resultSet.getString("fichaEjec"));
				maquinaPlan.put("ejecutadoParte", "");
				maquinaPlan.put("anioAteriorM", "NO");
				maquinaPlan.put("anioSiguienteM", "NO");
			} else if (resultSet.getString("tabla").equals("C")) {
				fechaAccion.setTime(resultSet.getDate("parteFeeje"));
				maquinaPlan.put("ejecutadoParte",
						resultSet.getString("parteEjec"));
				maquinaPlan.put("ejecutadoFicha", "");
				maquinaPlan.put("anioAteriorM", "NO");
				maquinaPlan.put("anioSiguienteM", "NO");
			} else {

			}

			String fechaEjec = " ";
			String fechaString = "";
			Integer diaSemana;

			// if (resultSet.getString("clave").equals("397")) {
			// semanaDelAnio = fechaAccion.get(Calendar.WEEK_OF_YEAR);
			// }
			if (valido) {
				sdf = new SimpleDateFormat("yyyy/MM/dd");
				sFecInicio = fechaAccion.get(Calendar.YEAR) + "/01/01";
				fechaInicio.setTime(unoDeEnero);
				fechaFin.setTime(fechaAccion.getTime());
				c.setTimeInMillis(fechaFin.getTime().getTime()
						- fechaInicio.getTime().getTime());
				// nDifDias = c.get(Calendar.DAY_OF_YEAR);

				// semanaDelAnio = nDifDias / 7;
				semanaDelAnio = fechaAccion.get(Calendar.WEEK_OF_YEAR);
				// Si la semana del año es la 53 y el mes de la fecha de accion
				// es enero quiere decir que es la semana cero de este año
				if (semanaDelAnio == 53 && fechaAccion.get(Calendar.MONTH) == 0) {
					semanaDelAnio = 0;
				}

				fechaString = Aa20bFecha.getFecha(fechaAccion.getTime());
				fechaAccion.setTime(fechaAccion.getTime());
				diaSemana = fechaAccion.get(Calendar.DAY_OF_WEEK);

				if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
					fechaEjec = Aa20bFecha.convertirFechaCompletaEu(
							fechaString, diaSemana);

				} else {
					fechaEjec = Aa20bFecha.convertirFechaCompleta(fechaString,
							diaSemana);
				}
			} else {
				fechaEjec = "";
			}

			for (int a = 0; a < 54; a++) {
				maquinaPlan.put("S" + a, semanaDelAnio == a ? fechaEjec : "");
			}

			return maquinaPlan;

		}
	};

	@SuppressWarnings("rawtypes")
	private RowMapper<HashMap<String, Object>> rwMapPrevAnualTodos = new RowMapper<HashMap<String, Object>>() {
		public HashMap<String, Object> mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			// ArrayList<HashMap<String, String>> listaPlan = new
			// ArrayList<HashMap<String, String>>();

			Calendar calendar = Calendar.getInstance(Locale.GERMAN);
			calendar.setFirstDayOfWeek(Calendar.MONDAY);
			calendar.setMinimalDaysInFirstWeek(4);
			int semanaDelAnio = 99; // Pongo 99 para que no salga en la tabla

			calendar.setTime(calendar.getTime());

			String idioma = LocaleContextHolder.getLocale().getLanguage();

			HashMap<String, Object> maquinaPrev = new HashMap<String, Object>();
			maquinaPrev.put("tabla", resultSet.getString("tabla"));
			maquinaPrev.put(
					"mcodigo",
					resultSet.getString("mcodigo") == null ? "-" : resultSet
							.getString("mcodigo"));
			maquinaPrev.put("idmaquina", resultSet.getString("idmaquina"));
			maquinaPrev.put("cmaquina", resultSet.getString("cmaquina"));
			maquinaPrev.put("emaquina", resultSet.getString("emaquina"));

			maquinaPrev.put(
					"OPERACION",
					resultSet.getString("OPERACION") == null ? "" : resultSet
							.getString("OPERACION"));
			maquinaPrev.put("SEMANAS", resultSet.getString("SEMANAS"));
			maquinaPrev
					.put("SIGMTO",
							resultSet.getDate("SIGMTO") == null ? resultSet
									.getDate("PRIMERMTO") : resultSet
									.getDate("SIGMTO"));
			maquinaPrev.put(
					"PRIMERMTO",
					resultSet.getDate("SIGMTO") == null ? "" : resultSet
							.getDate("PRIMERMTO"));
			/*
			 * maquinaPrev.put("idficha", resultSet.getString("idficha"));
			 * maquinaPrev.put("fichaFeeje", resultSet.getDate("fichaFeeje") ==
			 * null ? "" : resultSet .getDate("fichaFeeje").toString());
			 * maquinaPrev.put("fichaEjec", resultSet.getString("fichaEjec"));
			 * maquinaPrev.put("idparte", resultSet.getString("idparte"));
			 * maquinaPrev.put("parteFeeje", resultSet.getDate("parteFeeje") ==
			 * null ? "" : resultSet .getDate("parteFeeje").toString());
			 * maquinaPrev.put("parteEjec", resultSet.getString("parteEjec"));
			 */

			SimpleDateFormat sdf;
			Calendar fechaInicio = new GregorianCalendar();
			Calendar fechaFin = new GregorianCalendar();
			Calendar c = Calendar.getInstance(Locale.GERMAN);

			int semanaActual = c.get(Calendar.WEEK_OF_YEAR);
			maquinaPrev.put("semanaActual", semanaActual + "");

			// Calcular la semana actual
			sdf = new SimpleDateFormat("yyyy/MM/dd");
			String sFecInicio = calendar.get(Calendar.YEAR) + "/01/01";
			Date unoDeEnero = null;
			try {
				unoDeEnero = sdf.parse(sFecInicio);
			} catch (ParseException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			fechaInicio.setTime(unoDeEnero);
			fechaFin.setTime(calendar.getTime());
			c.setTimeInMillis(fechaFin.getTime().getTime()
					- fechaInicio.getTime().getTime());
			// int nDifDias = c.get(Calendar.DAY_OF_YEAR);

			// int semanaActual = nDifDias / 7;
			// maquinaPrev.put("semanaActual", semanaActual + "");

			Calendar fechaAccion = Calendar.getInstance(Locale.GERMAN);

			if (resultSet.getString("tabla") != null
					&& resultSet.getString("tabla").equals("F")) {
				// Estamos en Fichas
				if (resultSet.getString("fichaEjec") != null
						&& resultSet.getString("fichaEjec").equals("1")) {
					// La ficha está ejecutada. Ponemos una R
					maquinaPrev.put("fichaSituacion", "R");
				} else {
					// La ficha NO está ejecutada. Ponemos una O
					maquinaPrev.put("fichaSituacion", "O");
				}
			} else {
				// No es una ficha. Ponemos vacio
				maquinaPrev.put("fichaSituacion", "");
			}

			if (resultSet.getDate("fichaFeeje") != null) {
				fechaAccion.setFirstDayOfWeek(Calendar.MONDAY);
				fechaAccion.setMinimalDaysInFirstWeek(4);
				fechaAccion.setTime(resultSet.getDate("fichaFeeje"));
				maquinaPrev.put("ejecutadoFicha",
						resultSet.getString("fichaEjec"));
				maquinaPrev.put("ejecutadoParte", "");

				String fechaEjec = " ";
				String fechaString = "";
				Integer diaSemana;

				sdf = new SimpleDateFormat("yyyy/MM/dd");
				sFecInicio = fechaAccion.get(Calendar.YEAR) + "/01/01";
				fechaInicio.setTime(unoDeEnero);
				fechaFin.setTime(fechaAccion.getTime());
				c.setTimeInMillis(fechaFin.getTime().getTime()
						- fechaInicio.getTime().getTime());
				// nDifDias = c.get(Calendar.DAY_OF_YEAR);

				// semanaDelAnio = nDifDias / 7;
				semanaDelAnio = fechaAccion.get(Calendar.WEEK_OF_YEAR);
				// Si la semana del año es la 53 y el mes de la fecha de accion
				// es enero quiere decir que es la semana cero de este año
				if (semanaDelAnio == 53 && fechaAccion.get(Calendar.MONTH) == 0) {
					semanaDelAnio = 0;
				}

				fechaString = Aa20bFecha.getFecha(fechaAccion.getTime());
				fechaAccion.setTime(fechaAccion.getTime());
				diaSemana = fechaAccion.get(Calendar.DAY_OF_WEEK);

				if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
					fechaEjec = Aa20bFecha.convertirFechaCompletaEu(
							fechaString, diaSemana);

				} else {
					fechaEjec = Aa20bFecha.convertirFechaCompleta(fechaString,
							diaSemana);
				}

				for (int a = 0; a < 54; a++) {
					maquinaPrev.put("S" + a, semanaDelAnio == a ? fechaEjec
							: "");
				}

			} else {
				maquinaPrev.put("ejecutadoFicha", "");
				maquinaPrev.put("ejecutadoParte", "");

				for (int a = 0; a < 54; a++) {
					maquinaPrev.put("S" + a, "");
				}
			}

			return maquinaPrev;

		}
	};

	@SuppressWarnings("rawtypes")
	private RowMapper<HashMap<String, Object>> rwMapActAnualTodos = new RowMapper<HashMap<String, Object>>() {
		public HashMap<String, Object> mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Calendar calendar = Calendar.getInstance(Locale.GERMAN);
			calendar.setFirstDayOfWeek(Calendar.MONDAY);
			calendar.setMinimalDaysInFirstWeek(4);
			int semanaDelAnio = 99; // Pongo 99 para que no salga en la tabla

			calendar.setTime(calendar.getTime());

			String idioma = LocaleContextHolder.getLocale().getLanguage();

			HashMap<String, Object> maquinaAct = new HashMap<String, Object>();
			maquinaAct.put("tabla", resultSet.getString("tabla"));
			maquinaAct.put("mcodigo", resultSet.getString("mcodigo"));
			maquinaAct.put("idmaquina", resultSet.getString("idmaquina"));
			maquinaAct.put("cmaquina", resultSet.getString("cmaquina"));
			maquinaAct.put("emaquina", resultSet.getString("emaquina"));
			maquinaAct.put("idficha", resultSet.getString("idficha"));

			int aniobusqueda = calendar.get(Calendar.YEAR);
			if (resultSet.getString("fechaBusq") != null
					&& !resultSet.getString("fechaBusq").equals("")) {
				aniobusqueda = Integer
						.valueOf(resultSet.getString("fechaBusq")).intValue();
			}

			SimpleDateFormat sdf;
			Calendar fechaInicio = new GregorianCalendar();
			Calendar fechaFin = new GregorianCalendar();
			Calendar c = Calendar.getInstance(Locale.GERMAN);

			int semanaActual = c.get(Calendar.WEEK_OF_YEAR);
			maquinaAct.put("semanaActual", semanaActual + "");

			// Calcular la semana actual
			sdf = new SimpleDateFormat("yyyy/MM/dd");
			String sFecInicio = aniobusqueda + "/01/01";
			Date unoDeEnero = null;
			try {
				unoDeEnero = sdf.parse(sFecInicio);
			} catch (ParseException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			fechaInicio.setTime(unoDeEnero);
			fechaFin.setTime(calendar.getTime());
			c.setTimeInMillis(fechaFin.getTime().getTime()
					- fechaInicio.getTime().getTime());
			// int nDifDias = c.get(Calendar.DAY_OF_YEAR);

			// int semanaActual = nDifDias / 7;
			// maquinaAct.put("semanaActual", semanaActual + "");

			Calendar fechaAccion = Calendar.getInstance(Locale.GERMAN);

			maquinaAct.put("fichaSituacion", "A");

			fechaAccion.setFirstDayOfWeek(Calendar.MONDAY);
			fechaAccion.setMinimalDaysInFirstWeek(4);
			fechaAccion.setTime(resultSet.getDate("FEFINMAX"));
			maquinaAct.put("ejecutadoFicha", resultSet.getString("EJECUTADO"));

			String fechaEjec = " ";
			String fechaString = "";
			Integer diaSemana;

			sdf = new SimpleDateFormat("yyyy/MM/dd");
			sFecInicio = fechaAccion.get(Calendar.YEAR) + "/01/01";
			fechaInicio.setTime(unoDeEnero);
			fechaFin.setTime(fechaAccion.getTime());
			c.setTimeInMillis(fechaFin.getTime().getTime()
					- fechaInicio.getTime().getTime());
			// nDifDias = c.get(Calendar.DAY_OF_YEAR);

			// semanaDelAnio = nDifDias / 7;
			semanaDelAnio = fechaAccion.get(Calendar.WEEK_OF_YEAR);
			// Si la semana del año es la 53 y el mes de la fecha de accion
			// es enero quiere decir que es la semana cero de este año
			if (semanaDelAnio == 53 && fechaAccion.get(Calendar.MONTH) == 0) {
				semanaDelAnio = 0;
			}

			fechaString = Aa20bFecha.getFecha(fechaAccion.getTime());
			fechaAccion.setTime(fechaAccion.getTime());
			diaSemana = fechaAccion.get(Calendar.DAY_OF_WEEK);

			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				fechaEjec = Aa20bFecha.convertirFechaCompletaEu(fechaString,
						diaSemana);

			} else {
				fechaEjec = Aa20bFecha.convertirFechaCompleta(fechaString,
						diaSemana);
			}

			for (int a = 0; a < 54; a++) {
				maquinaAct.put("S" + a, semanaDelAnio == a ? fechaEjec : "");
			}

			return maquinaAct;

		}
	};

	@SuppressWarnings("rawtypes")
	private RowMapper<HashMap<String, Object>> rwMapActAnualTodosImprimir = new RowMapper<HashMap<String, Object>>() {
		public HashMap<String, Object> mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Calendar calendar = Calendar.getInstance(Locale.GERMAN);
			calendar.setFirstDayOfWeek(Calendar.MONDAY);
			calendar.setMinimalDaysInFirstWeek(4);
			int semanaDelAnio = 99; // Pongo 99 para que no salga en la tabla

			calendar.setTime(calendar.getTime());
			String idioma = LocaleContextHolder.getLocale().getLanguage();

			HashMap<String, Object> maquinaAct = new HashMap<String, Object>();
			maquinaAct.put("tabla", resultSet.getString("tabla"));
			maquinaAct.put("mcodigo", resultSet.getString("mcodigo"));
			maquinaAct.put("idmaquina", resultSet.getString("idmaquina"));
			maquinaAct.put("cmaquina", resultSet.getString("cmaquina"));
			maquinaAct.put("emaquina", resultSet.getString("emaquina"));
			maquinaAct.put("idficha", resultSet.getString("idficha"));

			maquinaAct.put("idgama", resultSet.getString("idgama"));
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				maquinaAct.put("gama", resultSet.getString("egama"));
			} else {
				maquinaAct.put("gama", resultSet.getString("cgama"));
			}
			maquinaAct.put("idedificio", resultSet.getString("idedificio"));
			maquinaAct.put("EDIFICIO", resultSet.getString("EDIFICIO"));
			maquinaAct.put("IDZONA", resultSet.getString("IDZONA"));
			maquinaAct.put("ZONA", resultSet.getString("ZONA"));
			maquinaAct.put("IDPLANTA", resultSet.getString("IDPLANTA"));
			maquinaAct.put("PLANTA", resultSet.getString("PLANTA"));
			SimpleDateFormat sdf;
			Calendar fechaInicio = new GregorianCalendar();
			Calendar fechaFin = new GregorianCalendar();
			Calendar c = Calendar.getInstance(Locale.GERMAN);

			int semanaActual = c.get(Calendar.WEEK_OF_YEAR);
			maquinaAct.put("semanaActual", semanaActual + "");

			int aniobusqueda = calendar.get(Calendar.YEAR);
			if (resultSet.getString("fechaBusq") != null
					&& !resultSet.getString("fechaBusq").equals("")) {
				aniobusqueda = Integer
						.valueOf(resultSet.getString("fechaBusq")).intValue();
			}

			// Calcular la semana actual
			sdf = new SimpleDateFormat("yyyy/MM/dd");
			String sFecInicio = aniobusqueda + "/01/01";
			Date unoDeEnero = null;
			try {
				unoDeEnero = sdf.parse(sFecInicio);
			} catch (ParseException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			fechaInicio.setTime(unoDeEnero);
			fechaFin.setTime(calendar.getTime());
			c.setTimeInMillis(fechaFin.getTime().getTime()
					- fechaInicio.getTime().getTime());
			// int nDifDias = c.get(Calendar.DAY_OF_YEAR);

			// int semanaActual = nDifDias / 7;
			// maquinaAct.put("semanaActual", semanaActual + 1 + "");

			// Ponemos una A porque todo son Actuaciones
			maquinaAct.put("fichaSituacion", "A");

			//
			Calendar fechaAccion = Calendar.getInstance(Locale.GERMAN);
			if (resultSet.getDate("FEFINMAX") != null) {
				fechaAccion.setFirstDayOfWeek(Calendar.MONDAY);
				fechaAccion.setMinimalDaysInFirstWeek(4);
				fechaAccion.setTime(resultSet.getDate("FEFINMAX"));
				maquinaAct.put("ejecutadoFicha",
						resultSet.getString("EJECUTADO"));

				sdf = new SimpleDateFormat("yyyy/MM/dd");
				sFecInicio = fechaAccion.get(Calendar.YEAR) + "/01/01";
				fechaInicio.setTime(unoDeEnero);
				fechaFin.setTime(fechaAccion.getTime());
				c.setTimeInMillis(fechaFin.getTime().getTime()
						- fechaInicio.getTime().getTime());
				// nDifDias = c.get(Calendar.DAY_OF_YEAR);

				// semanaDelAnio = nDifDias / 7;
				semanaDelAnio = fechaAccion.get(Calendar.WEEK_OF_YEAR);
				// Si la semana del año es la 53 y el mes de la fecha de accion
				// es enero quiere decir que es la semana cero de este año
				if (semanaDelAnio == 53 && fechaAccion.get(Calendar.MONTH) == 0) {
					semanaDelAnio = 0;
				}

				Integer tiempoEjecucion = resultSet.getString("MINUTOS") == null ? 0
						: resultSet.getInt("MINUTOS");

				for (int a = 0; a < 54; a++) {
					maquinaAct.put("S" + a,
							semanaDelAnio == a ? tiempoEjecucion : "");
				}

			} else {
				maquinaAct.put("ejecutadoFicha", "");

				for (int a = 0; a < 54; a++) {
					maquinaAct.put("S" + a, "");
				}
			}

			maquinaAct.put(
					"FEFINMAX",
					resultSet.getDate("FEFINMAX") == null ? "" : resultSet
							.getDate("FEFINMAX"));

			return maquinaAct;

		}
	};

	@SuppressWarnings("rawtypes")
	private RowMapper<HashMap<String, Object>> rwMapPrevAnualTodosImprimir = new RowMapper<HashMap<String, Object>>() {
		public HashMap<String, Object> mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			// ArrayList<HashMap<String, String>> listaPlan = new
			// ArrayList<HashMap<String, String>>();

			Calendar calendar = Calendar.getInstance(Locale.GERMAN);
			calendar.setFirstDayOfWeek(Calendar.MONDAY);
			calendar.setMinimalDaysInFirstWeek(4);
			int semanaDelAnio = 99; // Pongo 99 para que no salga en la tabla

			calendar.setTime(calendar.getTime());

			String idioma = LocaleContextHolder.getLocale().getLanguage();

			HashMap<String, Object> maquinaPrev = new HashMap<String, Object>();
			maquinaPrev.put("tabla", resultSet.getString("tabla"));
			maquinaPrev.put("mcodigo", resultSet.getString("mcodigo"));
			maquinaPrev.put("idmaquina", resultSet.getString("idmaquina"));
			maquinaPrev.put("cmaquina", resultSet.getString("cmaquina"));
			maquinaPrev.put("emaquina", resultSet.getString("emaquina"));

			maquinaPrev.put("idgama", resultSet.getString("idgama"));
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				maquinaPrev.put("gama", resultSet.getString("egama"));
			} else {
				maquinaPrev.put("gama", resultSet.getString("cgama"));
			}
			maquinaPrev.put("idedificio", resultSet.getString("idedificio"));
			maquinaPrev.put("EDIFICIO", resultSet.getString("EDIFICIO"));
			maquinaPrev.put("IDZONA", resultSet.getString("IDZONA"));
			maquinaPrev.put("ZONA", resultSet.getString("ZONA"));
			maquinaPrev.put("IDPLANTA", resultSet.getString("IDPLANTA"));
			maquinaPrev.put("PLANTA", resultSet.getString("PLANTA"));

			maquinaPrev.put(
					"OPERACION",
					resultSet.getString("OPERACION") == null ? "" : resultSet
							.getString("OPERACION"));
			maquinaPrev.put("SEMANAS", resultSet.getString("SEMANAS"));
			maquinaPrev.put("TIEMPOEJ", resultSet.getString("TIEMPOEJ"));
			maquinaPrev
					.put("SIGMTO",
							resultSet.getDate("SIGMTO") == null ? resultSet
									.getDate("PRIMERMTO") : resultSet
									.getDate("SIGMTO"));
			maquinaPrev.put(
					"PRIMERMTO",
					resultSet.getDate("SIGMTO") == null ? "" : resultSet
							.getDate("PRIMERMTO"));

			SimpleDateFormat sdf;
			Calendar fechaInicio = new GregorianCalendar();
			Calendar fechaFin = new GregorianCalendar();
			Calendar c = Calendar.getInstance(Locale.GERMAN);

			int semanaActual = c.get(Calendar.WEEK_OF_YEAR);
			maquinaPrev.put("semanaActual", semanaActual + "");

			int aniobusqueda = calendar.get(Calendar.YEAR);
			if (resultSet.getString("fechaBusq") != null
					&& !resultSet.getString("fechaBusq").equals("")) {
				aniobusqueda = Integer
						.valueOf(resultSet.getString("fechaBusq")).intValue();
			}

			// Calcular la semana actual
			sdf = new SimpleDateFormat("yyyy/MM/dd");
			String sFecInicio = aniobusqueda + "/01/01";
			Date unoDeEnero = null;
			try {
				unoDeEnero = sdf.parse(sFecInicio);
			} catch (ParseException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			fechaInicio.setTime(unoDeEnero);
			fechaFin.setTime(calendar.getTime());
			c.setTimeInMillis(fechaFin.getTime().getTime()
					- fechaInicio.getTime().getTime());
			// int nDifDias = c.get(Calendar.DAY_OF_YEAR);

			// int semanaActual = nDifDias / 7;

			// maquinaPrev.put("semanaActual", semanaActual + 1 + "");
			Calendar fechaAccion = Calendar.getInstance(Locale.GERMAN);

			if (resultSet.getString("tabla") != null
					&& resultSet.getString("tabla").equals("F")) {
				// Estamos en Fichas
				if (resultSet.getString("fichaEjec") != null
						&& resultSet.getString("fichaEjec").equals("1")) {
					// La ficha está ejecutada. Ponemos una R
					maquinaPrev.put("fichaSituacion", "R");
				} else {
					// La ficha está ejecutada. Ponemos una O
					maquinaPrev.put("fichaSituacion", "O");
				}
			} else {
				// No es una ficha. Ponemos vacio
				maquinaPrev.put("fichaSituacion", "");
			}

			if (resultSet.getDate("fichaFeeje") != null) {
				fechaAccion.setFirstDayOfWeek(Calendar.MONDAY);
				fechaAccion.setMinimalDaysInFirstWeek(4);
				fechaAccion.setTime(resultSet.getDate("fichaFeeje"));
				maquinaPrev.put("ejecutadoFicha",
						resultSet.getString("fichaEjec"));
				maquinaPrev.put("ejecutadoParte", "");

				sdf = new SimpleDateFormat("yyyy/MM/dd");
				sFecInicio = fechaAccion.get(Calendar.YEAR) + "/01/01";
				fechaInicio.setTime(unoDeEnero);
				fechaFin.setTime(fechaAccion.getTime());
				c.setTimeInMillis(fechaFin.getTime().getTime()
						- fechaInicio.getTime().getTime());
				// nDifDias = c.get(Calendar.DAY_OF_YEAR);

				// semanaDelAnio = nDifDias / 7;
				semanaDelAnio = fechaAccion.get(Calendar.WEEK_OF_YEAR);
				// Si la semana del año es la 53 y el mes de la fecha de accion
				// es enero quiere decir que es la semana cero de este año
				if (semanaDelAnio == 53 && fechaAccion.get(Calendar.MONTH) == 0) {
					semanaDelAnio = 0;
				}

				Integer tiempoEjecucion = resultSet.getString("TIEMPOEJ") == null ? 0
						: resultSet.getInt("TIEMPOEJ");

				for (int a = 0; a < 54; a++) {
					maquinaPrev.put("S" + a,
							semanaDelAnio == a ? tiempoEjecucion : "");
				}

			} else {
				maquinaPrev.put("ejecutadoFicha", "");
				maquinaPrev.put("ejecutadoParte", "");

				for (int a = 0; a < 54; a++) {
					maquinaPrev.put("S" + a, "");
				}
			}

			return maquinaPrev;

		}
	};

	private RowMapper<Maquinas> rwMapPACuestionarios = new RowMapper<Maquinas>() {
		public Maquinas mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Maquinas maquina = new Maquinas();
			maquina.setIdmaquina(resultSet.getLong("IDMAQUINA"));
			maquina.setMcodigo(resultSet.getString("MCODIGO"));

			maquina.setCmaquina(resultSet.getString("CMAQUINA"));
			maquina.setEmaquina(resultSet.getString("EMAQUINA"));
			maquina.setPrimerMto(resultSet.getDate("PRIMERMTO"));
			maquina.setSigMto(resultSet.getDate("SIGMTO"));

			maquina.setOperacion(resultSet.getString("OPERACION"));
			maquina.setSemanas(resultSet.getLong("SEMANAS"));
			return maquina;
		}
	};

	@SuppressWarnings("rawtypes")
	private RowMapper<String> rwMapPGTodos = new RowMapper<String>() {
		public String mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			return resultSet.getString("idmaquina");

		}
	};

	private RowMapper<Maquinas> rwMapMaquinas = new RowMapper<Maquinas>() {
		public Maquinas mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Maquinas maquina = new Maquinas();
			maquina.setIdmaquina(resultSet.getLong("IDMAQUINA"));
			maquina.setMcodigo(resultSet.getString("MCODIGO"));

			maquina.setIdgama(resultSet.getLong("IDGAMA"));
			Gamas gama = new Gamas();
			gama.setIdgama(resultSet.getLong("IDGAMA"));
			gama.setCgama(resultSet.getString("CGAMA") == null ? "" : resultSet
					.getString("CGAMA"));
			gama.setEgama(resultSet.getString("EGAMA") == null ? "" : resultSet
					.getString("EGAMA"));
			maquina.setGama(gama);

			maquina.setCmaquina(resultSet.getString("CMAQUINA"));
			maquina.setEmaquina(resultSet.getString("EMAQUINA"));
			maquina.setPrimerMto(resultSet.getDate("PRIMERMTO"));
			maquina.setSigMto(resultSet.getDate("SIGMTO"));
			maquina.setIdedificio(resultSet.getString("IDEDIFICIO"));
			Edificios edificio = new Edificios();
			edificio.setIdedificio(resultSet.getString("IDEDIFICIO"));
			edificio.setCedificio(resultSet.getString("CEDIFICIO") == null ? ""
					: resultSet.getString("CEDIFICIO"));
			edificio.setEedificio(resultSet.getString("EEDIFICIO") == null ? ""
					: resultSet.getString("EEDIFICIO"));
			edificio.setRedificio(resultSet.getString("REDIFICIO") == null ? ""
					: resultSet.getString("REDIFICIO"));
			edificio.setGestCentra(resultSet.getString("GESTCENTRA") == null ? ""
					: resultSet.getString("GESTCENTRA"));
			maquina.setEdificio(edificio);

			maquina.setIdzona(resultSet.getInt("IDZONA"));
			Zonas zona = new Zonas();
			zona.setIdzona(resultSet.getInt("IDZONA"));
			zona.setCzona(resultSet.getString("CZONA") == null ? "" : resultSet
					.getString("CZONA"));
			zona.setEzona(resultSet.getString("EZONA") == null ? "" : resultSet
					.getString("EZONA"));
			zona.setRzona(resultSet.getString("RZONA") == null ? "" : resultSet
					.getString("RZONA"));
			maquina.setZona(zona);

			maquina.setIdplanta(resultSet.getInt("IDPLANTA"));
			Plantas planta = new Plantas();
			planta.setIdplanta(resultSet.getInt("IDPLANTA"));
			planta.setCplanta(resultSet.getString("CPLANTA") == null ? ""
					: resultSet.getString("CPLANTA"));
			planta.setEplanta(resultSet.getString("EPLANTA") == null ? ""
					: resultSet.getString("EPLANTA"));
			planta.setRplanta(resultSet.getString("RPLANTA") == null ? ""
					: resultSet.getString("RPLANTA"));
			maquina.setPlanta(planta);

			maquina.setEdifZonaPlta(resultSet.getString("EDIFZONAPLTA") == null ? ""
					: resultSet.getString("EDIFZONAPLTA"));
			maquina.setFeini(resultSet.getDate("FEINI"));
			maquina.setBaja(resultSet.getString("BAJA"));

			return maquina;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Maquinas table.
	 * 
	 * @param maquinas
	 *            Pagination
	 * @return Maquinas
	 */
	public Maquinas add(Maquinas maquinas) {
		// Obtener el id correlativo
		Long idCorrelativo = this.jdbcTemplate
				.queryForLong("SELECT MAQUINA_SEQ.NEXTVAL FROM DUAL");

		maquinas.setIdmaquina(idCorrelativo);

		String query = "INSERT INTO MAQUINAS (IDMAQUINA, MCODIGO, IDGAMA, CMAQUINA, EMAQUINA, PRIMER_MTO, SIG_MTO, IDEDIFICIO, IDZONA, IDPLANTA, FEINI, BAJA) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, maquinas.getIdmaquina(),
				maquinas.getMcodigo(), maquinas.getIdgama(),
				maquinas.getCmaquina(), maquinas.getEmaquina(),
				maquinas.getPrimerMto(), maquinas.getPrimerMto(),
				maquinas.getIdedificio(), maquinas.getIdzona(),
				maquinas.getIdplanta(), maquinas.getFeini(),
				maquinas.getBaja() == null ? "0" : maquinas.getBaja());
		return maquinas;
	}

	/**
	 * Updates a single row in the Maquinas table.
	 * 
	 * @param maquinas
	 *            Pagination
	 * @return Maquinas
	 */
	public Maquinas update(Maquinas maquinas) {
		String query = "UPDATE MAQUINAS SET MCODIGO=?, IDGAMA=?, CMAQUINA=?, EMAQUINA=?, PRIMER_MTO=?, SIG_MTO=?, IDEDIFICIO=?, IDZONA=?, IDPLANTA=?, FEINI=?, BAJA=? WHERE IDMAQUINA=?";
		this.jdbcTemplate.update(query, maquinas.getMcodigo(), maquinas
				.getIdgama(), maquinas.getCmaquina(), maquinas.getEmaquina(),
				maquinas.getPrimerMto(), maquinas.getSigMto(), maquinas
						.getIdedificio(), maquinas.getIdzona(), maquinas
						.getIdplanta(), maquinas.getFeini(),
				maquinas.getBaja() == null ? "0" : maquinas.getBaja(), maquinas
						.getIdmaquina());
		return maquinas;
	}

	/**
	 * Actualiza la fechas de primer y siguiente mantenimiento para una máquina.
	 * 
	 * @param maquinasAux
	 *            Maquinas
	 * @return Maquinas
	 */
	public Maquinas actualizarFechasMto(Maquinas maquinasAux) {
		String query = "UPDATE MAQUINAS SET PRIMER_MTO=?, SIG_MTO=? WHERE IDMAQUINA=?";
		this.jdbcTemplate.update(query, maquinasAux.getPrimerMto(),
				maquinasAux.getSigMto(), maquinasAux.getIdmaquina());
		return maquinasAux;
	}

	/**
	 * Actualiza la fecha de siguiente mantenimiento para una máquina.
	 * 
	 * @param maquinasAux
	 *            Maquinas
	 * @return Maquinas
	 */
	public Maquinas actualizarFechaSigMto(Maquinas maquinasAux) {
		String query = "UPDATE MAQUINAS SET SIG_MTO=? WHERE IDMAQUINA=?";
		this.jdbcTemplate.update(query, maquinasAux.getSigMto(),
				maquinasAux.getIdmaquina());
		return maquinasAux;
	}

	/**
	 * Finds a single row in the Maquinas table.
	 * 
	 * @param maquinas
	 *            Pagination
	 * @return Maquinas
	 */
	@Transactional(readOnly = true)
	public Maquinas find(Maquinas maquinas) {
		String query = "SELECT t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.IDGAMA IDGAMA, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, t1.PRIMER_MTO PRIMERMTO, t1.SIG_MTO SIGMTO, t1.IDEDIFICIO IDEDIFICIO, t1.IDZONA IDZONA, t1.IDPLANTA IDPLANTA, t1.FEINI FEINI, t1.BAJA BAJA FROM MAQUINAS t1  WHERE t1.IDMAQUINA = ?  ";

		List<Maquinas> maquinasList = this.jdbcTemplate.query(query,
				this.rwMap, maquinas.getIdmaquina());
		return (Maquinas) DataAccessUtils.uniqueResult(maquinasList);
	}

	/**
	 * Finds a single row in the Gamas table.
	 * 
	 * @param idMaquina
	 *            String
	 * @return Maquinas
	 */
	@Transactional(readOnly = true)
	public Maquinas obtenerMaquina(String idMaquina) {
		// String query =
		// "SELECT t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.IDGAMA IDGAMA, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, t1.PRIMER_MTO PRIMERMTO, t1.SIG_MTO SIGMTO, t1.IDEDIFICIO IDEDIFICIO, t1.IDZONA IDZONA, t1.IDPLANTA IDPLANTA, t1.FEINI FEINI, t1.BAJA BAJA FROM MAQUINAS t1  WHERE t1.IDMAQUINA = ?  ";

		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDMAQUINA IDMAQUINA,t1.MCODIGO MCODIGO, t1.IDGAMA IDGAMA, t3.CGAMA CGAMA, t3.EGAMA EGAMA,t1.CMAQUINA CMAQUINA,t1.EMAQUINA EMAQUINA,t1.PRIMER_MTO PRIMERMTO,t1.SIG_MTO SIGMTO,t1.IDEDIFICIO IDEDIFICIO, t4.CEDIFICIO CEDIFICIO, t4.EEDIFICIO EEDIFICIO, t4.REDIFICIO REDIFICIO, t4.GESTCENTRA GESTCENTRA,t1.IDZONA IDZONA, t5.CZONA CZONA, t5.EZONA EZONA, t5.RZONA RZONA,t1.IDPLANTA IDPLANTA, t6.CPLANTA CPLANTA, t6.EPLANTA EPLANTA, t6.RPLANTA RPLANTA,t1.FEINI FEINI,t1.BAJA BAJA, ");
		query.append(" (t4.REDIFICIO || '/' || CASE WHEN t5.RZONA='0' THEN '' ELSE t5.RZONA END || '/' || CASE WHEN t6.RPLANTA='0' THEN '' ELSE t6.RPLANTA END) AS EDIFZONAPLTA ");
		query.append(" FROM MAQUINAS t1, GAMAS t3, EDIFICIOS t4, ZONAS t5, PLANTAS t6 ");
		query.append(" WHERE t1.IDGAMA=t3.IDGAMA(+) AND t1.IDEDIFICIO=t4.IDEDIFICIO(+) AND t1.IDZONA=t5.IDZONA(+) AND t1.IDPLANTA=t6.IDPLANTA(+) AND t1.IDMAQUINA = ? ");

		List<Maquinas> maquinasList = this.jdbcTemplate.query(query.toString(),
				this.rwMapMaquinas, idMaquina);
		return (Maquinas) DataAccessUtils.uniqueResult(maquinasList);
	}

	/******************************************** TABLA INICIAL ***************************************************************************/
	/**
	 * Se obtienen la tabla de planificacion General
	 * 
	 * @param filtroPlanGeneral
	 *            PlanGeneral
	 * @return ArrayList
	 */
	/*
	 * @Transactional(readOnly = true)
	 * 
	 * @SuppressWarnings("rawtypes") public ArrayList
	 * obtenerPlanificiacionGeneral(PlanGeneral filtroPlanGeneral) {
	 * 
	 * StringBuilder miQuery = new StringBuilder(
	 * "SELECT  t1.IDMAQUINA IDMAQUINA,t1.MCODIGO MCODIGO, t1.IDGAMA IDGAMA, t3.CGAMA CGAMA, t3.EGAMA EGAMA,t1.CMAQUINA CMAQUINA,t1.EMAQUINA EMAQUINA,t1.PRIMER_MTO PRIMERMTO,t1.SIG_MTO SIGMTO,t1.IDEDIFICIO IDEDIFICIO, t4.CEDIFICIO CEDIFICIO, t4.EEDIFICIO EEDIFICIO, t4.REDIFICIO REDIFICIO, t4.GESTCENTRA GESTCENTRA,t1.IDZONA IDZONA, t5.CZONA CZONA, t5.EZONA EZONA, t5.RZONA RZONA,t1.IDPLANTA IDPLANTA, t6.CPLANTA CPLANTA, t6.EPLANTA EPLANTA, t6.RPLANTA RPLANTA,t1.FEINI FEINI,t1.BAJA BAJA, "
	 * ); miQuery.append(
	 * " (t4.REDIFICIO || '/' || t5.RZONA || '/' || T6.RPLANTA) AS EDIFZONAPLTA "
	 * ); miQuery.append(
	 * " FROM MAQUINAS t1, GAMAS t3, EDIFICIOS t4, ZONAS t5, PLANTAS t6, EDIFICIOSVER t7 "
	 * );
	 * 
	 * // Where clause & Params Map<String, ?> mapaWhere =
	 * this.getWherePlanGeneral(filtroPlanGeneral, false); StringBuilder where =
	 * new StringBuilder(
	 * " WHERE t1.IDGAMA=t3.IDGAMA(+) AND t1.IDEDIFICIO=t4.IDEDIFICIO(+) AND t1.IDZONA=t5.IDZONA(+) AND t1.IDPLANTA=t6.IDPLANTA(+) AND t1.IDEDIFICIO=t7.IDEDIFICIO "
	 * ); where.append(mapaWhere.get("query")); miQuery.append(where);
	 * 
	 * List<?> params = (List<?>) mapaWhere.get("params");
	 * 
	 * ArrayList miLista = (ArrayList) this.jdbcTemplate.query(
	 * miQuery.toString(), this.rwMapPlanGeneral, params.toArray());
	 * 
	 * return miLista;
	 * 
	 * }
	 */
	/**
	 * Se obtienen la tabla de planificacion General
	 * 
	 * @param filtroPlanGeneral
	 *            PlanGeneral
	 * @return ArrayList
	 */
	@Transactional(readOnly = true)
	@SuppressWarnings("rawtypes")
	public ArrayList obtenerPlanificiacionGeneral(PlanGeneral filtroPlanGeneral) {

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWherePlanGeneralTodos(
				filtroPlanGeneral, false);
		StringBuilder where = new StringBuilder("  ");
		where.append(mapaWhere.get("query"));
		List<?> params = (List<?>) mapaWhere.get("params");

		StringBuilder miQuery = new StringBuilder(
				"select tabla, IDMAQUINA, MCODIGO, CMAQUINA, EMAQUINA, SIGMTO, idficha, fichaFeeje, fichaEjec, idparte, parteFeeje, parteEjec,'"
						+ filtroPlanGeneral.getAnio() + "' as fechaBusq ");
		miQuery.append(" from (SELECT 'M' as tabla, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, t1.SIG_MTO as SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec FROM MAQUINAS t1, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9 ");
		miQuery.append(" WHERE t1.IDEDIFICIO = t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA "); // AND
		// to_char(t1.SIG_MTO,'YYYY')
		// = ? ");
		miQuery.append(where);
		miQuery.append(" UNION ALL SELECT 'F' as tabla, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null as SIGMTO, t2.idficha as idficha, t2.feejec as fichaFeeje, t2.EJECUTADO as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec FROM MAQUINAS t1, FICHA t2, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9  ");
		miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t2.IDMAQUINA AND TO_CHAR(t2.feejec,'YYYY') = ? ");
		miQuery.append(where);
		miQuery.append(" UNION ALL SELECT 'C' as tabla, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, t3.idparte as idparte, NVL(t3.fechaej, t3.fechare) as parteFeeje, t3.EJECUTADO as parteEjec FROM MAQUINAS t1, PARTES t3, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9  ");
		miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t3.IDMAQUINA AND TO_CHAR(NVL(t3.fechaej, t3.fechare),'YYYY') = ? ");
		miQuery.append(where);
		miQuery.append(" )  order by idmaquina ");

		ArrayList miLista = (ArrayList) this.jdbcTemplate.query(
				miQuery.toString(), this.rwMapPlanGeneralTodos,
				params.toArray());

		return miLista;

	}

	/**
	 * Obtener los datos de las máquinas que cumplen con el filtro
	 * 
	 * @param filtroPlanGeneral
	 *            PlanGeneral
	 * @param idMaquinas
	 *            String
	 * @return ArrayList
	 */
	@Transactional(readOnly = true)
	@SuppressWarnings("rawtypes")
	public ArrayList obtenerPG(PlanGeneral filtroPlanGeneral, String idMaquinas) {

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWherePlanGeneralTodos(
				filtroPlanGeneral, false);
		StringBuilder where = new StringBuilder("  ");
		where.append(mapaWhere.get("query"));
		// List<?> params = (List<?>) mapaWhere.get("params");
		List<?> paramsAnio = (List<?>) mapaWhere.get("paramsAnio");
		List<?> paramsWhere = (List<?>) mapaWhere.get("paramsWhere");
		ArrayList<Object> paramsFinal = new ArrayList<Object>();

		StringBuilder miQuery = new StringBuilder(
				"select tabla, clave, IDMAQUINA, MCODIGO, CMAQUINA, EMAQUINA, SIGMTO, idficha, fichaFeeje, fichaEjec, idparte, parteFeeje, parteEjec,'"
						+ filtroPlanGeneral.getAnio() + "' as fechaBusq from (");

		if (filtroPlanGeneral != null
				&& filtroPlanGeneral.getEjecutado() != null) {
			// HAY FILTRO DE SITUACION
			if (filtroPlanGeneral.getEjecutado().equals("1")) {
				// HA FILTRADO POR EJECUTADOS
				if (filtroPlanGeneral != null
						&& filtroPlanGeneral.getTipoMant() != null) {
					if (filtroPlanGeneral.getTipoMant().equals("C")) {
						// ha filtrado POR CORRECTIVOS EJECUTADOS
						miQuery.append(" SELECT 'C' as tabla,t3.idparte as clave, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, t3.idparte as idparte, NVL(t3.fechaej, t3.fechare) as parteFeeje, t3.EJECUTADO as parteEjec FROM MAQUINAS t1, PARTES t3, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9  ");
						miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t3.IDMAQUINA AND t3.EJECUTADO=1 AND TO_CHAR(NVL(t3.fechaej, t3.fechare),'YYYY') = ? AND t1.IDMAQUINA in ("
								+ idMaquinas + ") ");

						miQuery.append(where);
						paramsFinal.addAll(paramsAnio);
						paramsFinal.addAll(paramsWhere);
					}
					if (filtroPlanGeneral.getTipoMant().equals("P")) {
						// ha filtrado POR PREVENTIVOS EJECUTADOS
						miQuery.append(" SELECT 'F' as tabla, t2.idficha as clave, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null as SIGMTO, t2.idficha as idficha, t2.feejec as fichaFeeje, t2.EJECUTADO as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec FROM MAQUINAS t1, FICHA t2, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   ");
						miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t2.IDMAQUINA AND t2.EJECUTADO=1 AND TO_CHAR(t2.feejec,'YYYY') = ? AND t1.IDMAQUINA in ("
								+ idMaquinas + ") ");
						miQuery.append(where);
						paramsFinal.addAll(paramsAnio);
						paramsFinal.addAll(paramsWhere);
					}
				} else {
					// FILTRADO POR EJECUTADOS Y SIN FILTRO DE TIPO
					// MANTENIMIENTO
					miQuery.append(" SELECT 'C' as tabla,t3.idparte as clave, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, t3.idparte as idparte, NVL(t3.fechaej, t3.fechare) as parteFeeje, t3.EJECUTADO as parteEjec FROM MAQUINAS t1, PARTES t3, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9  ");
					miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t3.IDMAQUINA AND t3.EJECUTADO=1 AND TO_CHAR(NVL(t3.fechaej, t3.fechare),'YYYY') = ? AND t1.IDMAQUINA in ("
							+ idMaquinas + ") ");
					miQuery.append(where);
					paramsFinal.addAll(paramsAnio);
					paramsFinal.addAll(paramsWhere);
					miQuery.append(" UNION ALL SELECT 'F' as tabla, t2.idficha as clave, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null as SIGMTO, t2.idficha as idficha, t2.feejec as fichaFeeje, t2.EJECUTADO as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec FROM MAQUINAS t1, FICHA t2, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   ");
					miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t2.IDMAQUINA AND t2.EJECUTADO=1 AND TO_CHAR(t2.feejec,'YYYY') = ? AND t1.IDMAQUINA in ("
							+ idMaquinas + ") ");
					miQuery.append(where);
					paramsFinal.addAll(paramsAnio);
					paramsFinal.addAll(paramsWhere);
				}
			}
			if (filtroPlanGeneral.getEjecutado().equals("0")) {
				// HA FILTRADO POR PENDIENTES
				if (filtroPlanGeneral != null
						&& filtroPlanGeneral.getTipoMant() != null) {
					if (filtroPlanGeneral.getTipoMant().equals("C")) {
						// ha filtrado POR CORRECTIVOS PENDIENTES
						miQuery.append(" SELECT 'C' as tabla,t3.idparte as clave, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, t3.idparte as idparte, NVL(t3.fechaej, t3.fechare) as parteFeeje, t3.EJECUTADO as parteEjec FROM MAQUINAS t1, PARTES t3, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9  ");
						miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t3.IDMAQUINA AND (t3.EJECUTADO<>1 OR t3.EJECUTADO IS NULL) AND TO_CHAR(NVL(t3.fechaej, t3.fechare),'YYYY') = ? AND t1.IDMAQUINA in ("
								+ idMaquinas + ") ");
						miQuery.append(where);
						paramsFinal.addAll(paramsAnio);
						paramsFinal.addAll(paramsWhere);
					}
					if (filtroPlanGeneral.getTipoMant().equals("P")) {
						// ha filtrado POR PREVENTIVOS PENDIENTES
						miQuery.append(" SELECT 'M' as tabla, t1.IDMAQUINA as clave, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, t1.SIG_MTO as SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec FROM MAQUINAS t1, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   ");
						miQuery.append(" WHERE t1.IDEDIFICIO = t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA  AND t1.IDMAQUINA in ("
								+ idMaquinas + ") ");
						miQuery.append(where);
						paramsFinal.addAll(paramsWhere);
						miQuery.append(" UNION ALL SELECT 'F' as tabla, t2.idficha as clave, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null as SIGMTO, t2.idficha as idficha, t2.feejec as fichaFeeje, t2.EJECUTADO as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec FROM MAQUINAS t1, FICHA t2, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   ");
						miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t2.IDMAQUINA AND (t2.EJECUTADO<>1 OR t2.EJECUTADO IS NULL) AND TO_CHAR(t2.feejec,'YYYY') = ? AND t1.IDMAQUINA in ("
								+ idMaquinas + ") ");
						miQuery.append(where);
						paramsFinal.addAll(paramsAnio);
						paramsFinal.addAll(paramsWhere);
					}
				} else {
					// FILTRADO POR PENDIENTES Y SIN FILTRO DE TIPO
					// MANTENIMIENTO
					miQuery.append(" SELECT 'M' as tabla, t1.IDMAQUINA as clave, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, t1.SIG_MTO as SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec FROM MAQUINAS t1, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   ");
					miQuery.append(" WHERE t1.IDEDIFICIO = t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA  AND t1.IDMAQUINA in ("
							+ idMaquinas + ") ");
					miQuery.append(where);
					paramsFinal.addAll(paramsWhere);
					miQuery.append(" UNION ALL SELECT 'C' as tabla,t3.idparte as clave, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, t3.idparte as idparte, NVL(t3.fechaej, t3.fechare) as parteFeeje, t3.EJECUTADO as parteEjec FROM MAQUINAS t1, PARTES t3, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9  ");
					miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t3.IDMAQUINA AND (t3.EJECUTADO<>1 OR t3.EJECUTADO IS NULL) AND TO_CHAR(NVL(t3.fechaej, t3.fechare),'YYYY') = ? AND t1.IDMAQUINA in ("
							+ idMaquinas + ") ");
					miQuery.append(where);
					paramsFinal.addAll(paramsAnio);
					paramsFinal.addAll(paramsWhere);
					miQuery.append(" UNION ALL SELECT 'F' as tabla, t2.idficha as clave, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null as SIGMTO, t2.idficha as idficha, t2.feejec as fichaFeeje, t2.EJECUTADO as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec FROM MAQUINAS t1, FICHA t2, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   ");
					miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t2.IDMAQUINA AND (t2.EJECUTADO<>1 OR t2.EJECUTADO IS NULL) AND TO_CHAR(t2.feejec,'YYYY') = ? AND t1.IDMAQUINA in ("
							+ idMaquinas + ") ");
					miQuery.append(where);
					paramsFinal.addAll(paramsAnio);
					paramsFinal.addAll(paramsWhere);
				}
			}
		} else {
			// NO HAY FILTRO DE SITUACION
			if (filtroPlanGeneral != null
					&& filtroPlanGeneral.getTipoMant() != null) {
				// HAY FILTRO DE TIPO DE MANTENIMIENTO
				if (filtroPlanGeneral.getTipoMant().equals("C")) {
					// ha filtrado POR CORRECTIVOS
					miQuery.append(" SELECT 'C' as tabla,t3.idparte as clave, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, t3.idparte as idparte, NVL(t3.fechaej, t3.fechare) as parteFeeje, t3.EJECUTADO as parteEjec FROM MAQUINAS t1, PARTES t3, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9  ");
					miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t3.IDMAQUINA AND TO_CHAR(NVL(t3.fechaej, t3.fechare),'YYYY') = ? AND t1.IDMAQUINA in ("
							+ idMaquinas + ") ");
					miQuery.append(where);
					paramsFinal.addAll(paramsAnio);
					paramsFinal.addAll(paramsWhere);
				}
				if (filtroPlanGeneral.getTipoMant().equals("P")) {
					// ha filtrado POR PREVENTIVOS
					miQuery.append(" SELECT 'M' as tabla, t1.IDMAQUINA as clave, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, t1.SIG_MTO as SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec FROM MAQUINAS t1, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   ");
					miQuery.append(" WHERE t1.IDEDIFICIO = t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA  AND t1.IDMAQUINA in ("
							+ idMaquinas + ") ");
					miQuery.append(where);
					paramsFinal.addAll(paramsWhere);
					miQuery.append(" UNION ALL SELECT 'F' as tabla, t2.idficha as clave, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null as SIGMTO, t2.idficha as idficha, t2.feejec as fichaFeeje, t2.EJECUTADO as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec FROM MAQUINAS t1, FICHA t2, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   ");
					miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t2.IDMAQUINA AND TO_CHAR(t2.feejec,'YYYY') = ? AND t1.IDMAQUINA in ("
							+ idMaquinas + ") ");
					miQuery.append(where);
					paramsFinal.addAll(paramsAnio);
					paramsFinal.addAll(paramsWhere);
				}
			} else {
				// NO HAY FILTRO DE TIPOS DE MANTENIMIENTO NI SITUACION
				miQuery.append(" SELECT 'M' as tabla, t1.IDMAQUINA as clave, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, t1.SIG_MTO as SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec FROM MAQUINAS t1, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   ");
				miQuery.append(" WHERE t1.IDEDIFICIO = t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA  AND t1.IDMAQUINA in ("
						+ idMaquinas + ") ");
				miQuery.append(where);
				paramsFinal.addAll(paramsWhere);
				miQuery.append(" UNION ALL SELECT 'F' as tabla, t2.idficha as clave, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null as SIGMTO, t2.idficha as idficha, t2.feejec as fichaFeeje, t2.EJECUTADO as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec FROM MAQUINAS t1, FICHA t2, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   ");
				miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t2.IDMAQUINA AND TO_CHAR(t2.feejec,'YYYY') = ? AND t1.IDMAQUINA in ("
						+ idMaquinas + ") ");
				miQuery.append(where);
				paramsFinal.addAll(paramsAnio);
				paramsFinal.addAll(paramsWhere);
				miQuery.append(" UNION ALL SELECT 'C' as tabla,t3.idparte as clave, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, t3.idparte as idparte, NVL(t3.fechaej, t3.fechare) as parteFeeje, t3.EJECUTADO as parteEjec FROM MAQUINAS t1, PARTES t3, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9  ");
				miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t3.IDMAQUINA AND TO_CHAR(NVL(t3.fechaej, t3.fechare),'YYYY') = ? AND t1.IDMAQUINA in ("
						+ idMaquinas + ") ");
				miQuery.append(where);
				paramsFinal.addAll(paramsAnio);
				paramsFinal.addAll(paramsWhere);
			}
		}

		/*
		 * miQuery.append(
		 * " SELECT 'M' as tabla, t1.IDMAQUINA as clave, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, t1.SIG_MTO as SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec FROM MAQUINAS t1, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9  "
		 * ); miQuery.append(
		 * " WHERE t1.IDEDIFICIO = t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA in ("
		 * + idMaquinas + ") ");
		 * 
		 * miQuery.append(where); miQuery.append(
		 * " UNION ALL SELECT 'F' as tabla, t2.idficha as clave, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null as SIGMTO, t2.idficha as idficha, t2.feejec as fichaFeeje, t2.EJECUTADO as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec FROM MAQUINAS t1, FICHA t2, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9  "
		 * ); miQuery.append(
		 * " WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t2.IDMAQUINA AND TO_CHAR(t2.feejec,'YYYY') = ? AND t1.IDMAQUINA in ("
		 * + idMaquinas + ") "); miQuery.append(where); miQuery.append(
		 * " UNION ALL SELECT 'C' as tabla,t3.idparte as clave, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, t3.idparte as idparte, NVL(t3.fechaej, t3.fechare) as parteFeeje, t3.EJECUTADO as parteEjec FROM MAQUINAS t1, PARTES t3, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9  "
		 * ); miQuery.append(
		 * " WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t3.IDMAQUINA AND TO_CHAR(NVL(t3.fechaej, t3.fechare),'YYYY') = ? AND t1.IDMAQUINA in ("
		 * + idMaquinas + " ) "); miQuery.append(where);
		 */

		miQuery.append(" )  order by UPPER(mcodigo), idmaquina ");

		ArrayList miLista = (ArrayList) this.jdbcTemplate.query(
				miQuery.toString(), this.rwMapPlanGeneralTodos,
				paramsFinal.toArray());

		return miLista;

	}

	/**
	 * Obtener los datos de las máquinas que cumplen con el filtro
	 * 
	 * @param filtroPlanGeneral
	 *            PlanGeneral
	 * @return ArrayList
	 */
	@Transactional(readOnly = true)
	@SuppressWarnings("rawtypes")
	public ArrayList obtenerPGImprimir(PlanGeneral filtroPlanGeneral) {

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWherePlanGeneralTodos(
				filtroPlanGeneral, false);
		StringBuilder where = new StringBuilder("  ");
		where.append(mapaWhere.get("query"));
		// List<?> params = (List<?>) mapaWhere.get("params");
		List<?> paramsAnio = (List<?>) mapaWhere.get("paramsAnio");
		List<?> paramsWhere = (List<?>) mapaWhere.get("paramsWhere");
		ArrayList<Object> paramsFinal = new ArrayList<Object>();

		StringBuilder miQuery = new StringBuilder(
				"select tabla, clave, IDMAQUINA, MCODIGO, CMAQUINA, EMAQUINA, SIGMTO, idficha, fichaFeeje, fichaEjec, idparte, parteFeeje, parteEjec,'"
						+ filtroPlanGeneral.getAnio() + "' as fechaBusq from (");

		if (filtroPlanGeneral != null
				&& filtroPlanGeneral.getEjecutado() != null) {
			// HAY FILTRO DE SITUACION
			if (filtroPlanGeneral.getEjecutado().equals("1")) {
				// HA FILTRADO POR EJECUTADOS
				if (filtroPlanGeneral != null
						&& filtroPlanGeneral.getTipoMant() != null) {
					if (filtroPlanGeneral.getTipoMant().equals("C")) {
						// ha filtrado POR CORRECTIVOS EJECUTADOS
						miQuery.append(" SELECT 'C' as tabla,t3.idparte as clave, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, t3.idparte as idparte, NVL(t3.fechaej, t3.fechare) as parteFeeje, t3.EJECUTADO as parteEjec FROM MAQUINAS t1, PARTES t3, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9  ");
						miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t3.IDMAQUINA AND t3.EJECUTADO=1 AND TO_CHAR(NVL(t3.fechaej, t3.fechare),'YYYY') = ? ");

						miQuery.append(where);
						paramsFinal.addAll(paramsAnio);
						paramsFinal.addAll(paramsWhere);
					}
					if (filtroPlanGeneral.getTipoMant().equals("P")) {
						// ha filtrado POR PREVENTIVOS EJECUTADOS
						miQuery.append(" SELECT 'F' as tabla, t2.idficha as clave, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null as SIGMTO, t2.idficha as idficha, t2.feejec as fichaFeeje, t2.EJECUTADO as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec FROM MAQUINAS t1, FICHA t2, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   ");
						miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t2.IDMAQUINA AND t2.EJECUTADO=1 AND TO_CHAR(t2.feejec,'YYYY') = ? ");
						miQuery.append(where);
						paramsFinal.addAll(paramsAnio);
						paramsFinal.addAll(paramsWhere);
					}
				} else {
					// FILTRADO POR EJECUTADOS Y SIN FILTRO DE TIPO
					// MANTENIMIENTO
					miQuery.append(" SELECT 'C' as tabla,t3.idparte as clave, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, t3.idparte as idparte, NVL(t3.fechaej, t3.fechare) as parteFeeje, t3.EJECUTADO as parteEjec FROM MAQUINAS t1, PARTES t3, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9  ");
					miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t3.IDMAQUINA AND t3.EJECUTADO=1 AND TO_CHAR(NVL(t3.fechaej, t3.fechare),'YYYY') = ? ");
					miQuery.append(where);
					paramsFinal.addAll(paramsAnio);
					paramsFinal.addAll(paramsWhere);
					miQuery.append(" UNION ALL SELECT 'F' as tabla, t2.idficha as clave, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null as SIGMTO, t2.idficha as idficha, t2.feejec as fichaFeeje, t2.EJECUTADO as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec FROM MAQUINAS t1, FICHA t2, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   ");
					miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t2.IDMAQUINA AND t2.EJECUTADO=1 AND TO_CHAR(t2.feejec,'YYYY') = ? ");
					miQuery.append(where);
					paramsFinal.addAll(paramsAnio);
					paramsFinal.addAll(paramsWhere);
				}
			}
			if (filtroPlanGeneral.getEjecutado().equals("0")) {
				// HA FILTRADO POR PENDIENTES
				if (filtroPlanGeneral != null
						&& filtroPlanGeneral.getTipoMant() != null) {
					if (filtroPlanGeneral.getTipoMant().equals("C")) {
						// ha filtrado POR CORRECTIVOS PENDIENTES
						miQuery.append(" SELECT 'C' as tabla,t3.idparte as clave, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, t3.idparte as idparte, NVL(t3.fechaej, t3.fechare) as parteFeeje, t3.EJECUTADO as parteEjec FROM MAQUINAS t1, PARTES t3, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9  ");
						miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t3.IDMAQUINA AND (t3.EJECUTADO<>1 OR t3.EJECUTADO IS NULL) AND TO_CHAR(NVL(t3.fechaej, t3.fechare),'YYYY') = ? ");
						miQuery.append(where);
						paramsFinal.addAll(paramsAnio);
						paramsFinal.addAll(paramsWhere);
					}
					if (filtroPlanGeneral.getTipoMant().equals("P")) {
						// ha filtrado POR PREVENTIVOS PENDIENTES
						miQuery.append(" SELECT 'M' as tabla, t1.IDMAQUINA as clave, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, t1.SIG_MTO as SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec FROM MAQUINAS t1, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   ");
						miQuery.append(" WHERE t1.IDEDIFICIO = t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA ");
						miQuery.append(where);
						paramsFinal.addAll(paramsWhere);
						miQuery.append(" UNION ALL SELECT 'F' as tabla, t2.idficha as clave, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null as SIGMTO, t2.idficha as idficha, t2.feejec as fichaFeeje, t2.EJECUTADO as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec FROM MAQUINAS t1, FICHA t2, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   ");
						miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t2.IDMAQUINA AND (t2.EJECUTADO<>1 OR t2.EJECUTADO IS NULL) AND TO_CHAR(t2.feejec,'YYYY') = ? ");
						miQuery.append(where);
						paramsFinal.addAll(paramsAnio);
						paramsFinal.addAll(paramsWhere);
					}
				} else {
					// FILTRADO POR PENDIENTES Y SIN FILTRO DE TIPO
					// MANTENIMIENTO
					miQuery.append(" SELECT 'M' as tabla, t1.IDMAQUINA as clave, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, t1.SIG_MTO as SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec FROM MAQUINAS t1, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   ");
					miQuery.append(" WHERE t1.IDEDIFICIO = t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA ");
					miQuery.append(where);
					paramsFinal.addAll(paramsWhere);
					miQuery.append(" UNION ALL SELECT 'C' as tabla,t3.idparte as clave, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, t3.idparte as idparte, NVL(t3.fechaej, t3.fechare) as parteFeeje, t3.EJECUTADO as parteEjec FROM MAQUINAS t1, PARTES t3, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9  ");
					miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t3.IDMAQUINA AND (t3.EJECUTADO<>1 OR t3.EJECUTADO IS NULL) AND TO_CHAR(NVL(t3.fechaej, t3.fechare),'YYYY') = ? ");
					miQuery.append(where);
					paramsFinal.addAll(paramsAnio);
					paramsFinal.addAll(paramsWhere);
					miQuery.append(" UNION ALL SELECT 'F' as tabla, t2.idficha as clave, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null as SIGMTO, t2.idficha as idficha, t2.feejec as fichaFeeje, t2.EJECUTADO as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec FROM MAQUINAS t1, FICHA t2, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   ");
					miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t2.IDMAQUINA AND (t2.EJECUTADO<>1 OR t2.EJECUTADO IS NULL) AND TO_CHAR(t2.feejec,'YYYY') = ? ");
					miQuery.append(where);
					paramsFinal.addAll(paramsAnio);
					paramsFinal.addAll(paramsWhere);
				}
			}
		} else {
			// NO HAY FILTRO DE SITUACION
			if (filtroPlanGeneral != null
					&& filtroPlanGeneral.getTipoMant() != null) {
				// HAY FILTRO DE TIPO DE MANTENIMIENTO
				if (filtroPlanGeneral.getTipoMant().equals("C")) {
					// ha filtrado POR CORRECTIVOS
					miQuery.append(" SELECT 'C' as tabla,t3.idparte as clave, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, t3.idparte as idparte, NVL(t3.fechaej, t3.fechare) as parteFeeje, t3.EJECUTADO as parteEjec FROM MAQUINAS t1, PARTES t3, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9  ");
					miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t3.IDMAQUINA AND TO_CHAR(NVL(t3.fechaej, t3.fechare),'YYYY') = ? ");
					miQuery.append(where);
					paramsFinal.addAll(paramsAnio);
					paramsFinal.addAll(paramsWhere);
				}
				if (filtroPlanGeneral.getTipoMant().equals("P")) {
					// ha filtrado POR PREVENTIVOS
					miQuery.append(" SELECT 'M' as tabla, t1.IDMAQUINA as clave, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, t1.SIG_MTO as SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec FROM MAQUINAS t1, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   ");
					miQuery.append(" WHERE t1.IDEDIFICIO = t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA  ");
					miQuery.append(where);
					paramsFinal.addAll(paramsWhere);
					miQuery.append(" UNION ALL SELECT 'F' as tabla, t2.idficha as clave, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null as SIGMTO, t2.idficha as idficha, t2.feejec as fichaFeeje, t2.EJECUTADO as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec FROM MAQUINAS t1, FICHA t2, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   ");
					miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t2.IDMAQUINA AND TO_CHAR(t2.feejec,'YYYY') = ? ");
					miQuery.append(where);
					paramsFinal.addAll(paramsAnio);
					paramsFinal.addAll(paramsWhere);
				}
			} else {
				// NO HAY FILTRO DE TIPOS DE MANTENIMIENTO NI SITUACION
				miQuery.append(" SELECT 'M' as tabla, t1.IDMAQUINA as clave, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, t1.SIG_MTO as SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec FROM MAQUINAS t1, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   ");
				miQuery.append(" WHERE t1.IDEDIFICIO = t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA ");
				miQuery.append(where);
				paramsFinal.addAll(paramsWhere);
				miQuery.append(" UNION ALL SELECT 'F' as tabla, t2.idficha as clave, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null as SIGMTO, t2.idficha as idficha, t2.feejec as fichaFeeje, t2.EJECUTADO as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec FROM MAQUINAS t1, FICHA t2, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   ");
				miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t2.IDMAQUINA AND TO_CHAR(t2.feejec,'YYYY') = ? ");
				miQuery.append(where);
				paramsFinal.addAll(paramsAnio);
				paramsFinal.addAll(paramsWhere);
				miQuery.append(" UNION ALL SELECT 'C' as tabla,t3.idparte as clave, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, t3.idparte as idparte, NVL(t3.fechaej, t3.fechare) as parteFeeje, t3.EJECUTADO as parteEjec FROM MAQUINAS t1, PARTES t3, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9  ");
				miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t3.IDMAQUINA AND TO_CHAR(NVL(t3.fechaej, t3.fechare),'YYYY') = ? ");
				miQuery.append(where);
				paramsFinal.addAll(paramsAnio);
				paramsFinal.addAll(paramsWhere);
			}
		}

		/*
		 * miQuery.append(
		 * " SELECT 'M' as tabla, t1.IDMAQUINA as clave, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, t1.SIG_MTO as SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec FROM MAQUINAS t1, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9  "
		 * ); miQuery.append(
		 * " WHERE t1.IDEDIFICIO = t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA in ("
		 * + idMaquinas + ") ");
		 * 
		 * miQuery.append(where); miQuery.append(
		 * " UNION ALL SELECT 'F' as tabla, t2.idficha as clave, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null as SIGMTO, t2.idficha as idficha, t2.feejec as fichaFeeje, t2.EJECUTADO as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec FROM MAQUINAS t1, FICHA t2, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9  "
		 * ); miQuery.append(
		 * " WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t2.IDMAQUINA AND TO_CHAR(t2.feejec,'YYYY') = ? AND t1.IDMAQUINA in ("
		 * + idMaquinas + ") "); miQuery.append(where); miQuery.append(
		 * " UNION ALL SELECT 'C' as tabla,t3.idparte as clave, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, t3.idparte as idparte, NVL(t3.fechaej, t3.fechare) as parteFeeje, t3.EJECUTADO as parteEjec FROM MAQUINAS t1, PARTES t3, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9  "
		 * ); miQuery.append(
		 * " WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t3.IDMAQUINA AND TO_CHAR(NVL(t3.fechaej, t3.fechare),'YYYY') = ? AND t1.IDMAQUINA in ("
		 * + idMaquinas + " ) "); miQuery.append(where);
		 */

		miQuery.append(" )  order by UPPER(mcodigo), idmaquina ");

		ArrayList miLista = (ArrayList) this.jdbcTemplate.query(
				miQuery.toString(), this.rwMapPlanGeneralTodos,
				paramsFinal.toArray());

		return miLista;

	}

	/**
	 * Obtener los datos de las máquinas que cumplen con el filtro
	 * 
	 * @param filtroPrevAnual
	 *            PrevAnual
	 * @param idMaquinas
	 *            String
	 * @return ArrayList
	 */
	@Transactional(readOnly = true)
	@SuppressWarnings("rawtypes")
	public ArrayList obtenerPA(PrevAnual filtroPrevAnual, String idMaquinas) {

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWherePrevAnualTodos(filtroPrevAnual,
				false);
		StringBuilder where = new StringBuilder("  ");
		where.append(mapaWhere.get("query"));
		List<?> params = (List<?>) mapaWhere.get("params");

		StringBuilder miQuery = new StringBuilder(
				"select tabla, IDMAQUINA, MCODIGO, CMAQUINA, EMAQUINA, PRIMERMTO, SIGMTO, idficha, fichaFeeje, fichaEjec, idparte, parteFeeje, parteEjec, operacion, semanas");

		if (filtroPrevAnual != null && filtroPrevAnual.getEjecutado() != null
				&& "1".equals(filtroPrevAnual.getEjecutado())) {
			// Filtro Situacion= Realizados
			miQuery.append(" from (SELECT 'F' as tabla, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null as PRIMERMTO, null as SIGMTO, t2.idficha as idficha, t2.feejec as fichaFeeje, t2.EJECUTADO as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec, null as operacion, null as semanas FROM MAQUINAS t1, FICHA t2, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9  ");
			miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t2.IDMAQUINA AND t2.EJECUTADO=1 AND  TO_CHAR(t2.feejec,'YYYY') = ? AND t1.IDMAQUINA in ("
					+ idMaquinas + ") ");
		} else if (filtroPrevAnual != null
				&& filtroPrevAnual.getEjecutado() != null
				&& "0".equals(filtroPrevAnual.getEjecutado())) {
			// Filtro Situacion= Pendientes
			miQuery.append(" from (SELECT 'F' as tabla, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null as PRIMERMTO, null as SIGMTO, t2.idficha as idficha, t2.feejec as fichaFeeje, t2.EJECUTADO as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec, null as operacion, null as semanas FROM MAQUINAS t1, FICHA t2, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9  ");
			miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t2.IDMAQUINA AND (t2.EJECUTADO<>1 OR t2.EJECUTADO IS NULL) AND TO_CHAR(t2.feejec,'YYYY') = ? AND t1.IDMAQUINA in ("
					+ idMaquinas + ") ");
			miQuery.append(where);
			miQuery.append(" UNION ALL SELECT 'P' as tabla, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, t1.PRIMER_MTO PRIMERMTO, t1.SIG_MTO as SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec, t3.OPERACION AS OPERACION, t3.SEMANAS AS SEMANAS FROM MAQUINAS t1, GAMAS t9, CUESTIONARIO t3 , EDIFICIOSVER t7, EDIFICIOS t8 ");
			miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO AND t1.IDGAMA = t9.IDGAMA AND t9.IDGAMA=t3.IDGAMA AND t1.IDMAQUINA in ("
					+ idMaquinas + ") ");

		} else {
			miQuery.append(" from (SELECT 'F' as tabla, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null as PRIMERMTO, null as SIGMTO, t2.idficha as idficha, t2.feejec as fichaFeeje, t2.EJECUTADO as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec, null as operacion, null as semanas FROM MAQUINAS t1, FICHA t2, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9  ");
			miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t2.IDMAQUINA AND TO_CHAR(t2.feejec,'YYYY') = ? AND t1.IDMAQUINA in ("
					+ idMaquinas + ") ");
			miQuery.append(where);
			miQuery.append(" UNION ALL SELECT 'P' as tabla, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, t1.PRIMER_MTO PRIMERMTO, t1.SIG_MTO as SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec, t3.OPERACION AS OPERACION, t3.SEMANAS AS SEMANAS FROM MAQUINAS t1, GAMAS t9, CUESTIONARIO t3 , EDIFICIOSVER t7, EDIFICIOS t8 ");
			miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO AND t1.IDGAMA = t9.IDGAMA AND t9.IDGAMA=t3.IDGAMA AND t1.IDMAQUINA in ("
					+ idMaquinas + ") ");
		}

		miQuery.append(where);

		miQuery.append(" )  order by UPPER(mcodigo), idmaquina ");

		ArrayList miLista = (ArrayList) this.jdbcTemplate.query(
				miQuery.toString(), this.rwMapPrevAnualTodos, params.toArray());

		return miLista;

	}

	/**
	 * Obtener los datos de las máquinas que cumplen con el filtro
	 * 
	 * @param filtroActAnual
	 *            ActAnual
	 * @param idMaquinas
	 *            String
	 * @return ArrayList
	 */
	@Transactional(readOnly = true)
	@SuppressWarnings("rawtypes")
	public ArrayList obtenerAA(ActAnual filtroActAnual, String idMaquinas) {

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereActAnualTodos(filtroActAnual,
				false);
		StringBuilder where = new StringBuilder("  ");
		where.append(mapaWhere.get("query"));
		List<?> params = (List<?>) mapaWhere.get("params");

		StringBuilder miQuery = new StringBuilder(
				" SELECT distinct 'A' as tabla, t1.idmaquina IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, t2.IDFICHA idficha,  t2.EJECUTADO EJECUTADO, nvl((select max(trunc (t4.fefin)) from FICHAEJECUCION t4 WHERE t4.IDFITEC = t3.IDFITEC),t2.feejec) as FEFINMAX,'"
						+ filtroActAnual.getAnio() + "' as fechaBusq ");
		miQuery.append("  FROM MAQUINAS t1, FICHA t2, FICHATECNICO t3, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9 ");
		miQuery.append(" WHERE t1.IDMAQUINA=t2.IDMAQUINA AND t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t2.IDFICHA = t3.IDFICHA(+) ");
		miQuery.append(" AND TO_CHAR(nvl((select max(trunc (t4.fefin)) from FICHAEJECUCION t4 WHERE t4.IDFITEC = t3.IDFITEC),t2.feejec),'YYYY') = ? ");
		miQuery.append(" AND t1.IDMAQUINA in (" + idMaquinas + ") ");
		miQuery.append(where);
		miQuery.append(" order by UPPER(mcodigo), idmaquina ");

		ArrayList miLista = (ArrayList) this.jdbcTemplate.query(
				miQuery.toString(), this.rwMapActAnualTodos, params.toArray());

		return miLista;

	}

	/**
	 * Obtener los datos de las máquinas que cumplen con el filtro
	 * 
	 * @param filtroActAnual
	 *            ActAnual
	 * @param idMaquinas
	 *            String
	 * @return ArrayList
	 */
	@Transactional(readOnly = true)
	@SuppressWarnings("rawtypes")
	public ArrayList obtenerAARealEdif(ActAnual filtroActAnual,
			String idMaquinas) {

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereActAnualTodos(filtroActAnual,
				false);
		StringBuilder where = new StringBuilder("  ");
		where.append(mapaWhere.get("query"));
		List<?> params = (List<?>) mapaWhere.get("params");

		StringBuilder miQuery = new StringBuilder(
				"select tabla, IDMAQUINA, IDGAMA, CGAMA, EGAMA, IDEDIFICIO, EDIFICIO, IDZONA, ZONA, IDPLANTA, PLANTA, MCODIGO, CMAQUINA, EMAQUINA, idficha, EJECUTADO, fefinmax, MINUTOS, '"
						+ filtroActAnual.getAnio() + "' as fechaBusq ");
		miQuery.append(" from (SELECT distinct 'A' as tabla, t1.idmaquina IDMAQUINA, t1.IDGAMA IDGAMA, t9.CGAMA CGAMA, t9.EGAMA EGAMA, t1.IDEDIFICIO IDEDIFICIO, t8.IDEDIFICIO || ' - ' || t8.REDIFICIO AS EDIFICIO, t1.IDZONA IDZONA, t1.IDZONA || ' - ' || t10.RZONA AS ZONA, t1.IDPLANTA IDPLANTA, t1.IDPLANTA || ' - ' || t11.RPLANTA AS PLANTA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, t2.IDFICHA idficha,  t2.EJECUTADO EJECUTADO,");
		miQuery.append(" nvl((SELECT MAX(TRUNC(t4.FEFIN)) FROM FICHAEJECUCION t4, FICHATECNICO TFITEC WHERE t4.IDFITEC = TFITEC.IDFITEC AND TFITEC.IDFICHA = T2.IDFICHA),t2.feejec) as FEFINMAX, ");

		// " nvl((select max(trunc (t4.fefin)) from FICHAEJECUCION t4 WHERE t4.IDFITEC = t3.IDFITEC),t2.feejec) as FEFINMAX, ");
		miQuery.append(" (SELECT SUM(t5.TIEMPOREAL) FROM FICHATECNICO t5 WHERE t5.IDFICHA = t2.IDFICHA) AS MINUTOS ");
		miQuery.append("  FROM MAQUINAS t1, FICHA t2, FICHATECNICO t3, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9, ZONAS t10, PLANTAS t11 ");
		miQuery.append(" WHERE t1.IDMAQUINA=t2.IDMAQUINA AND t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t2.IDFICHA = t3.IDFICHA(+) AND t1.IDZONA =t10.IDZONA(+) AND t1.IDPLANTA = t11.IDPLANTA(+) ");
		miQuery.append(" AND TO_CHAR(nvl((select max(trunc (t4.fefin)) from FICHAEJECUCION t4 WHERE t4.IDFITEC = t3.IDFITEC),t2.feejec),'YYYY') = ? ");
		if ("".equals(idMaquinas)) {
			miQuery.append(" AND t1.IDMAQUINA in ('') ");
		} else {
			miQuery.append(" AND t1.IDMAQUINA in (" + idMaquinas + ") ");
		}

		miQuery.append(" AND (SELECT SUM(t5.TIEMPOREAL) FROM FICHATECNICO t5 WHERE t5.IDFICHA = t2.IDFICHA)>0 ");
		miQuery.append(where);
		miQuery.append(" )  order by IDGAMA, IDEDIFICIO, IDZONA, IDPLANTA, mcodigo, idmaquina ");

		ArrayList miLista = (ArrayList) this.jdbcTemplate.query(
				miQuery.toString(), this.rwMapActAnualTodosImprimir,
				params.toArray());

		return miLista;

	}

	/**
	 * Obtener los datos de las máquinas que cumplen con el filtro
	 * 
	 * @param filtroPrevAnual
	 *            PrevAnual
	 * @return ArrayList
	 */
	@Transactional(readOnly = true)
	@SuppressWarnings("rawtypes")
	public ArrayList obtenerPAImprimir(PrevAnual filtroPrevAnual) {

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWherePrevAnualTodos(filtroPrevAnual,
				false);
		StringBuilder where = new StringBuilder("  ");
		where.append(mapaWhere.get("query"));
		List<?> params = (List<?>) mapaWhere.get("params");

		StringBuilder miQuery = new StringBuilder(
				"select tabla, IDMAQUINA, IDGAMA, CGAMA, EGAMA, IDEDIFICIO, EDIFICIO, IDZONA, ZONA, IDPLANTA, PLANTA, MCODIGO, CMAQUINA, EMAQUINA, PRIMERMTO, SIGMTO, idficha, fichaFeeje, fichaEjec, idparte, parteFeeje, parteEjec, operacion, semanas, tiempoEj,'"
						+ filtroPrevAnual.getAnio() + "' as fechaBusq ");

		if (filtroPrevAnual != null && filtroPrevAnual.getEjecutado() != null
				&& "1".equals(filtroPrevAnual.getEjecutado())) {
			// Filtro Situacion= Realizados
			miQuery.append(" from (SELECT 'F' as tabla, t1.IDMAQUINA IDMAQUINA, t1.IDGAMA IDGAMA, t9.CGAMA CGAMA, t9.EGAMA EGAMA, t1.IDEDIFICIO IDEDIFICIO, t8.CEDIFICIO AS EDIFICIO, t1.IDZONA IDZONA, t10.CZONA AS ZONA, t1.IDPLANTA IDPLANTA, t11.CPLANTA AS PLANTA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null as PRIMERMTO, null as SIGMTO, t2.idficha as idficha, t2.feejec as fichaFeeje, t2.EJECUTADO as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec, null as operacion, null as semanas, t2.TIEMPOREAL as tiempoEj FROM MAQUINAS t1, FICHA t2, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9, ZONAS t10, PLANTAS t11  ");
			miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA  AND t1.IDMAQUINA =t2.IDMAQUINA AND t1.IDZONA =t10.IDZONA(+) AND t1.IDPLANTA = t11.IDPLANTA(+) AND t2.EJECUTADO=1 AND TO_CHAR(t2.feejec,'YYYY') = ? ");
			miQuery.append(where);
			miQuery.append(" )  order by IDGAMA, IDEDIFICIO, IDZONA, IDPLANTA, mcodigo, idmaquina ");

		} else if (filtroPrevAnual != null
				&& filtroPrevAnual.getEjecutado() != null
				&& "0".equals(filtroPrevAnual.getEjecutado())) {
			// Filtro Situacion= Pendientes
			miQuery.append(" from (SELECT 'F' as tabla, t1.IDMAQUINA IDMAQUINA, t1.IDGAMA IDGAMA, t9.CGAMA CGAMA, t9.EGAMA EGAMA, t1.IDEDIFICIO IDEDIFICIO, t8.CEDIFICIO AS EDIFICIO, t1.IDZONA IDZONA, t10.CZONA AS ZONA, t1.IDPLANTA IDPLANTA, t11.CPLANTA AS PLANTA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null as PRIMERMTO, null as SIGMTO, t2.idficha as idficha, t2.feejec as fichaFeeje, t2.EJECUTADO as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec, null as operacion, null as semanas, t2.TIEMPOREAL as tiempoEj FROM MAQUINAS t1, FICHA t2, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9, ZONAS t10, PLANTAS t11 ");
			miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA  AND t1.IDMAQUINA =t2.IDMAQUINA AND t1.IDZONA =t10.IDZONA(+) AND t1.IDPLANTA = t11.IDPLANTA(+) AND (t2.EJECUTADO<>1 OR t2.EJECUTADO IS NULL) AND TO_CHAR(t2.feejec,'YYYY') = ? ");
			miQuery.append(where);
			miQuery.append(" UNION ALL SELECT 'P' as tabla, t1.IDMAQUINA IDMAQUINA, t1.IDGAMA IDGAMA, t9.CGAMA CGAMA, t9.EGAMA EGAMA, t1.IDEDIFICIO IDEDIFICIO, t8.CEDIFICIO AS EDIFICIO, t1.IDZONA IDZONA, t10.CZONA AS ZONA, t1.IDPLANTA IDPLANTA, t11.CPLANTA AS PLANTA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, t1.PRIMER_MTO PRIMERMTO, t1.SIG_MTO as SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec, t3.OPERACION AS OPERACION, t3.SEMANAS AS SEMANAS, t3.TIEMPO AS tiempoEj FROM MAQUINAS t1, GAMAS t9, CUESTIONARIO t3 , EDIFICIOSVER t7, EDIFICIOS t8, ZONAS t10, PLANTAS t11 ");
			miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO AND t1.IDGAMA = t9.IDGAMA AND t9.IDGAMA=t3.IDGAMA AND t1.IDZONA =t10.IDZONA(+) AND t1.IDPLANTA =t11.IDPLANTA(+) ");
			miQuery.append(where);
			miQuery.append(" )  order by IDGAMA, IDEDIFICIO, IDZONA, IDPLANTA, mcodigo, idmaquina ");
		} else {
			miQuery.append(" from (SELECT 'F' as tabla, t1.IDMAQUINA IDMAQUINA, t1.IDGAMA IDGAMA, t9.CGAMA CGAMA, t9.EGAMA EGAMA, t1.IDEDIFICIO IDEDIFICIO, t8.CEDIFICIO AS EDIFICIO, t1.IDZONA IDZONA, t10.CZONA AS ZONA, t1.IDPLANTA IDPLANTA, t11.CPLANTA AS PLANTA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null as PRIMERMTO, null as SIGMTO, t2.idficha as idficha, t2.feejec as fichaFeeje, t2.EJECUTADO as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec, null as operacion, null as semanas, t2.TIEMPOREAL as tiempoEj FROM MAQUINAS t1, FICHA t2, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9, ZONAS t10, PLANTAS t11 ");
			miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA  AND t1.IDMAQUINA =t2.IDMAQUINA AND t1.IDZONA =t10.IDZONA(+) AND t1.IDPLANTA = t11.IDPLANTA(+) AND TO_CHAR(t2.feejec,'YYYY') = ? ");
			miQuery.append(where);
			miQuery.append(" UNION ALL SELECT 'P' as tabla, t1.IDMAQUINA IDMAQUINA, t1.IDGAMA IDGAMA, t9.CGAMA CGAMA, t9.EGAMA EGAMA, t1.IDEDIFICIO IDEDIFICIO, t8.CEDIFICIO AS EDIFICIO, t1.IDZONA IDZONA, t10.CZONA AS ZONA, t1.IDPLANTA IDPLANTA, t11.CPLANTA AS PLANTA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, t1.PRIMER_MTO PRIMERMTO, t1.SIG_MTO as SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec, t3.OPERACION AS OPERACION, t3.SEMANAS AS SEMANAS, t3.TIEMPO AS tiempoEj FROM MAQUINAS t1, GAMAS t9, CUESTIONARIO t3 , EDIFICIOSVER t7, EDIFICIOS t8, ZONAS t10, PLANTAS t11 ");
			miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO AND t1.IDGAMA = t9.IDGAMA AND t9.IDGAMA=t3.IDGAMA AND t1.IDZONA =t10.IDZONA(+) AND t1.IDPLANTA =t11.IDPLANTA(+) ");
			miQuery.append(where);
			miQuery.append(" )  order by IDGAMA, IDEDIFICIO, IDZONA, IDPLANTA, mcodigo, idmaquina ");
		}

		ArrayList miLista = (ArrayList) this.jdbcTemplate.query(
				miQuery.toString(), this.rwMapPrevAnualTodosImprimir,
				params.toArray());

		return miLista;

	}

	/**
	 * Obtener los cuestionarios de las máquinas que cumplen con el filtro
	 * 
	 * @param filtroPrevAnual
	 *            PrevAnual
	 * @param idMaquinas
	 *            String
	 * @return ArrayList
	 */
	@Transactional(readOnly = true)
	public List<Maquinas> obtenerCuestionariosMaquinas(
			PrevAnual filtroPrevAnual, String idMaquinas) {

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWherePACuesionarios(filtroPrevAnual,
				false);
		StringBuilder where = new StringBuilder("  ");
		where.append(mapaWhere.get("query"));
		List<?> params = (List<?>) mapaWhere.get("params");

		StringBuilder miQuery = new StringBuilder(
				" SELECT t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, t1.SIG_MTO AS SIGMTO, t1.PRIMER_MTO AS PRIMERMTO, "
						+ "t3.OPERACION AS OPERACION, t3.SEMANAS AS SEMANAS ");
		miQuery.append(" FROM MAQUINAS t1, GAMAS t9, CUESTIONARIO t3 , EDIFICIOSVER t7, EDIFICIOS t8 ");
		miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO AND t1.IDGAMA = t9.IDGAMA AND t9.IDGAMA=t3.IDGAMA AND t1.IDMAQUINA in ("
				+ idMaquinas + ") ");
		miQuery.append(where);
		miQuery.append(" order by t1.IDMAQUINA ");

		return (List<Maquinas>) this.jdbcTemplate.query(miQuery.toString(),
				this.rwMapPACuestionarios, params.toArray());

	}

	/**
	 * Se obtienen la tabla de planificacion General
	 * 
	 * @param filtroPlanGeneral
	 *            PlanGeneral
	 * @return ArrayList
	 */
	@Transactional(readOnly = true)
	@SuppressWarnings("rawtypes")
	public ArrayList obtenerPlanificiacionGeneral(
			PlanGeneral filtroPlanGeneral, Pagination pagination) {

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWherePlanGeneralTodos(
				filtroPlanGeneral, false);
		StringBuilder where = new StringBuilder("  ");
		where.append(mapaWhere.get("query"));
		List<?> params = (List<?>) mapaWhere.get("params");

		StringBuilder miQuery = new StringBuilder(
				"select tabla, IDMAQUINA, MCODIGO, CMAQUINA, EMAQUINA, SIGMTO, idficha, fichaFeeje, fichaEjec, idparte, parteFeeje, parteEjec,'"
						+ filtroPlanGeneral.getAnio() + "' as fechaBusq ");
		miQuery.append(" from (SELECT 'M' as tabla, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, t1.SIG_MTO as SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec FROM MAQUINAS t1, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   ");
		miQuery.append(" WHERE t1.IDEDIFICIO = t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA "); // AND
		// to_char(t1.SIG_MTO,'YYYY')
		// = ? ");
		miQuery.append(where);
		miQuery.append(" UNION ALL SELECT 'F' as tabla, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null as SIGMTO, t2.idficha as idficha, t2.feejec as fichaFeeje, t2.EJECUTADO as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec FROM MAQUINAS t1, FICHA t2, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   ");
		miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t2.IDMAQUINA AND TO_CHAR(t2.feejec,'YYYY') = ? ");
		miQuery.append(where);
		miQuery.append(" UNION ALL SELECT 'C' as tabla, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, t3.idparte as idparte, NVL(t3.fechaej, t3.fechare) as parteFeeje, t3.EJECUTADO as parteEjec FROM MAQUINAS t1, PARTES t3, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   ");
		miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t3.IDMAQUINA AND TO_CHAR(NVL(t3.fechaej, t3.fechare),'YYYY') = ? ");
		miQuery.append(where);
		miQuery.append(" )  order by idmaquina ");

		if (pagination != null) {
			miQuery = pagination.getPaginationQuery(miQuery);
		}

		ArrayList miLista = (ArrayList) this.jdbcTemplate.query(
				miQuery.toString(), this.rwMapPlanGeneralTodos,
				params.toArray());

		return miLista;

	}

	/**
	 * Counts rows la tabla de planificacion General
	 * 
	 * @param filtroPlanGeneral
	 *            PlanGeneral
	 * @return Long
	 */
	@Transactional(readOnly = true)
	@SuppressWarnings("rawtypes")
	public Long obtenerPlanificiacionGeneralCount(PlanGeneral filtroPlanGeneral) {

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWherePlanGeneralTodos(
				filtroPlanGeneral, false);
		StringBuilder where = new StringBuilder("  ");
		where.append(mapaWhere.get("query"));
		List<?> params = (List<?>) mapaWhere.get("params");

		StringBuilder miQuery = new StringBuilder("select count(1) ");
		miQuery.append(" from (SELECT 'M' as tabla, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, t1.SIG_MTO as SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec FROM MAQUINAS t1, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   ");
		miQuery.append(" WHERE t1.IDEDIFICIO = t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO AND t1.IDGAMA = t9.IDGAMA "); // AND
		// to_char(t1.SIG_MTO,'YYYY')
		// = ? ");
		miQuery.append(where);
		miQuery.append(" UNION ALL SELECT 'F' as tabla, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null as SIGMTO, t2.idficha as idficha, t2.feejec as fichaFeeje, t2.EJECUTADO as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec FROM MAQUINAS t1, FICHA t2, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   ");
		miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t2.IDMAQUINA AND TO_CHAR(t2.feejec,'YYYY') = ? ");
		miQuery.append(where);
		miQuery.append(" UNION ALL SELECT 'C' as tabla, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, t3.idparte as idparte, NVL(t3.fechaej, t3.fechare) as parteFeeje, t3.EJECUTADO as parteEjec FROM MAQUINAS t1, PARTES t3, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   ");
		miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t3.IDMAQUINA AND TO_CHAR(NVL(t3.fechaej, t3.fechare),'YYYY') = ? ");
		miQuery.append(where);
		miQuery.append(" )  order by idmaquina ");

		return this.jdbcTemplate.queryForLong(miQuery.toString(),
				params.toArray());

	}

	/**
	 * obtener los idMaquinas que cumplen con el filtro
	 * 
	 * @param filtroPlanGeneral
	 *            PlanGeneral
	 * @return ArrayList
	 */
	@Transactional(readOnly = true)
	@SuppressWarnings("rawtypes")
	public ArrayList obtenerIdMaquinasPG(PlanGeneral filtroPlanGeneral,
			Pagination pagination) {

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWherePlanGeneralTodos(
				filtroPlanGeneral, false);
		StringBuilder where = new StringBuilder("  ");
		where.append(mapaWhere.get("query"));
		// List<?> params = (List<?>) mapaWhere.get("params");
		List<?> paramsAnio = (List<?>) mapaWhere.get("paramsAnio");
		List<?> paramsWhere = (List<?>) mapaWhere.get("paramsWhere");
		ArrayList<Object> paramsFinal = new ArrayList<Object>();

		StringBuilder miQuery = new StringBuilder(
				"SELECT distinct idmaquina, mcodigo from (");
		// angel JULIO2015
		if (filtroPlanGeneral != null
				&& filtroPlanGeneral.getEjecutado() != null) {
			// HAY FILTRO DE SITUACION
			if (filtroPlanGeneral.getEjecutado().equals("1")) {
				// HA FILTRADO POR EJECUTADOS
				if (filtroPlanGeneral != null
						&& filtroPlanGeneral.getTipoMant() != null) {
					if (filtroPlanGeneral.getTipoMant().equals("C")) {
						// ha filtrado POR CORRECTIVOS EJECUTADOS
						miQuery.append(" SELECT 'C' as tabla, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, t3.idparte as idparte, NVL(t3.fechaej, t3.fechare) as parteFeeje, t3.EJECUTADO as parteEjec FROM MAQUINAS t1, PARTES t3, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9  ");
						miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t3.IDMAQUINA AND t3.EJECUTADO=1 AND TO_CHAR(NVL(t3.fechaej, t3.fechare),'YYYY') = ? ");
						miQuery.append(where);
						paramsFinal.addAll(paramsAnio);
						paramsFinal.addAll(paramsWhere);
					}
					if (filtroPlanGeneral.getTipoMant().equals("P")) {
						// ha filtrado POR PREVENTIVOS EJECUTADOS
						miQuery.append(" SELECT 'F' as tabla, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null as SIGMTO, t2.idficha as idficha, t2.feejec as fichaFeeje, t2.EJECUTADO as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec FROM MAQUINAS t1, FICHA t2, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   ");
						miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t2.IDMAQUINA AND t2.EJECUTADO=1 AND TO_CHAR(t2.feejec,'YYYY') = ? ");
						miQuery.append(where);
						paramsFinal.addAll(paramsAnio);
						paramsFinal.addAll(paramsWhere);
					}
				} else {
					// FILTRADO POR EJECUTADOS Y SIN FILTRO DE TIPO
					// MANTENIMIENTO
					miQuery.append(" SELECT 'C' as tabla, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, t3.idparte as idparte, NVL(t3.fechaej, t3.fechare) as parteFeeje, t3.EJECUTADO as parteEjec FROM MAQUINAS t1, PARTES t3, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9  ");
					miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t3.IDMAQUINA AND t3.EJECUTADO=1 AND TO_CHAR(NVL(t3.fechaej, t3.fechare),'YYYY') = ? ");
					miQuery.append(where);
					paramsFinal.addAll(paramsAnio);
					paramsFinal.addAll(paramsWhere);
					miQuery.append(" UNION ALL SELECT 'F' as tabla, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null as SIGMTO, t2.idficha as idficha, t2.feejec as fichaFeeje, t2.EJECUTADO as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec FROM MAQUINAS t1, FICHA t2, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   ");
					miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t2.IDMAQUINA AND t2.EJECUTADO=1 AND TO_CHAR(t2.feejec,'YYYY') = ? ");
					miQuery.append(where);
					paramsFinal.addAll(paramsAnio);
					paramsFinal.addAll(paramsWhere);
				}
			}
			if (filtroPlanGeneral.getEjecutado().equals("0")) {
				// HA FILTRADO POR PENDIENTES
				if (filtroPlanGeneral != null
						&& filtroPlanGeneral.getTipoMant() != null) {
					if (filtroPlanGeneral.getTipoMant().equals("C")) {
						// ha filtrado POR CORRECTIVOS PENDIENTES
						miQuery.append(" SELECT 'C' as tabla, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, t3.idparte as idparte, NVL(t3.fechaej, t3.fechare) as parteFeeje, t3.EJECUTADO as parteEjec FROM MAQUINAS t1, PARTES t3, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9  ");
						miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t3.IDMAQUINA AND (t3.EJECUTADO<>1 OR t3.EJECUTADO IS NULL) AND TO_CHAR(NVL(t3.fechaej, t3.fechare),'YYYY') = ? ");
						miQuery.append(where);
						paramsFinal.addAll(paramsAnio);
						paramsFinal.addAll(paramsWhere);
					}
					if (filtroPlanGeneral.getTipoMant().equals("P")) {
						// ha filtrado POR PREVENTIVOS PENDIENTES
						miQuery.append(" SELECT 'M' as tabla, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, t1.SIG_MTO as SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec FROM MAQUINAS t1, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   ");
						miQuery.append(" WHERE t1.IDEDIFICIO = t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA  ");
						miQuery.append(where);
						paramsFinal.addAll(paramsWhere);
						miQuery.append(" UNION ALL SELECT 'F' as tabla, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null as SIGMTO, t2.idficha as idficha, t2.feejec as fichaFeeje, t2.EJECUTADO as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec FROM MAQUINAS t1, FICHA t2, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   ");
						miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t2.IDMAQUINA AND (t2.EJECUTADO<>1 OR t2.EJECUTADO IS NULL) AND TO_CHAR(t2.feejec,'YYYY') = ? ");
						miQuery.append(where);
						paramsFinal.addAll(paramsAnio);
						paramsFinal.addAll(paramsWhere);
					}
				} else {
					// FILTRADO POR PENDIENTES Y SIN FILTRO DE TIPO
					// MANTENIMIENTO
					miQuery.append(" SELECT 'M' as tabla, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, t1.SIG_MTO as SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec FROM MAQUINAS t1, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   ");
					miQuery.append(" WHERE t1.IDEDIFICIO = t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA  ");
					miQuery.append(where);
					paramsFinal.addAll(paramsWhere);
					miQuery.append(" UNION ALL SELECT 'C' as tabla, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, t3.idparte as idparte, NVL(t3.fechaej, t3.fechare) as parteFeeje, t3.EJECUTADO as parteEjec FROM MAQUINAS t1, PARTES t3, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9  ");
					miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t3.IDMAQUINA AND (t3.EJECUTADO<>1 OR t3.EJECUTADO IS NULL) AND TO_CHAR(NVL(t3.fechaej, t3.fechare),'YYYY') = ? ");
					miQuery.append(where);
					paramsFinal.addAll(paramsAnio);
					paramsFinal.addAll(paramsWhere);
					miQuery.append(" UNION ALL SELECT 'F' as tabla, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null as SIGMTO, t2.idficha as idficha, t2.feejec as fichaFeeje, t2.EJECUTADO as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec FROM MAQUINAS t1, FICHA t2, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   ");
					miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t2.IDMAQUINA AND (t2.EJECUTADO<>1 OR t2.EJECUTADO IS NULL) AND TO_CHAR(t2.feejec,'YYYY') = ? ");
					miQuery.append(where);
					paramsFinal.addAll(paramsAnio);
					paramsFinal.addAll(paramsWhere);
				}
			}
		} else {
			// NO HAY FILTRO DE SITUACION
			if (filtroPlanGeneral != null
					&& filtroPlanGeneral.getTipoMant() != null) {
				// HAY FILTRO DE TIPO DE MANTENIMIENTO
				if (filtroPlanGeneral.getTipoMant().equals("C")) {
					// ha filtrado POR CORRECTIVOS
					miQuery.append(" SELECT 'C' as tabla, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, t3.idparte as idparte, NVL(t3.fechaej, t3.fechare) as parteFeeje, t3.EJECUTADO as parteEjec FROM MAQUINAS t1, PARTES t3, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9  ");
					miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t3.IDMAQUINA AND TO_CHAR(NVL(t3.fechaej, t3.fechare),'YYYY') = ? ");
					miQuery.append(where);
					paramsFinal.addAll(paramsAnio);
					paramsFinal.addAll(paramsWhere);
				}
				if (filtroPlanGeneral.getTipoMant().equals("P")) {
					// ha filtrado POR PREVENTIVOS
					miQuery.append(" SELECT 'M' as tabla, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, t1.SIG_MTO as SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec FROM MAQUINAS t1, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   ");
					miQuery.append(" WHERE t1.IDEDIFICIO = t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA  ");
					miQuery.append(where);
					paramsFinal.addAll(paramsWhere);
					miQuery.append(" UNION ALL SELECT 'F' as tabla, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null as SIGMTO, t2.idficha as idficha, t2.feejec as fichaFeeje, t2.EJECUTADO as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec FROM MAQUINAS t1, FICHA t2, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   ");
					miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t2.IDMAQUINA AND TO_CHAR(t2.feejec,'YYYY') = ? ");
					miQuery.append(where);
					paramsFinal.addAll(paramsAnio);
					paramsFinal.addAll(paramsWhere);
				}
			} else {
				// NO HAY FILTRO DE TIPOS DE MANTENIMIENTO NI SITUACION
				miQuery.append(" SELECT 'M' as tabla, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, t1.SIG_MTO as SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec FROM MAQUINAS t1, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   ");
				miQuery.append(" WHERE t1.IDEDIFICIO = t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA  ");
				miQuery.append(where);
				paramsFinal.addAll(paramsWhere);
				miQuery.append(" UNION ALL SELECT 'F' as tabla, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null as SIGMTO, t2.idficha as idficha, t2.feejec as fichaFeeje, t2.EJECUTADO as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec FROM MAQUINAS t1, FICHA t2, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   ");
				miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t2.IDMAQUINA AND TO_CHAR(t2.feejec,'YYYY') = ? ");
				miQuery.append(where);
				paramsFinal.addAll(paramsAnio);
				paramsFinal.addAll(paramsWhere);
				miQuery.append(" UNION ALL SELECT 'C' as tabla, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, t3.idparte as idparte, NVL(t3.fechaej, t3.fechare) as parteFeeje, t3.EJECUTADO as parteEjec FROM MAQUINAS t1, PARTES t3, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9  ");
				miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t3.IDMAQUINA AND TO_CHAR(NVL(t3.fechaej, t3.fechare),'YYYY') = ? ");
				miQuery.append(where);
				paramsFinal.addAll(paramsAnio);
				paramsFinal.addAll(paramsWhere);
			}
		}

		miQuery.append(") order by UPPER(mcodigo), idmaquina ");

		if (pagination != null) {
			miQuery = pagination.getPaginationQuery(miQuery);
		}

		ArrayList miLista = (ArrayList) this.jdbcTemplate.query(
				miQuery.toString(), this.rwMapPGTodos, paramsFinal.toArray());

		return miLista;

	}

	/**
	 * obtener los idMaquinas que cumplen con el filtro
	 * 
	 * @param filtroPrevAnual
	 *            PrevAnual
	 * @return ArrayList
	 */
	@Transactional(readOnly = true)
	@SuppressWarnings("rawtypes")
	public ArrayList obtenerIdMaquinasPA(PrevAnual filtroPrevAnual,
			Pagination pagination) {

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWherePrevAnualContar(
				filtroPrevAnual, false);
		StringBuilder where = new StringBuilder("  ");
		where.append(mapaWhere.get("query"));
		List<?> params = (List<?>) mapaWhere.get("params");

		StringBuilder miQuery = new StringBuilder(" SELECT ");
		if (filtroPrevAnual != null && filtroPrevAnual.getEjecutado() != null
				&& "1".equals(filtroPrevAnual.getEjecutado())) {
			miQuery.append(" distinct t1.idmaquina, t1.mcodigo  FROM MAQUINAS t1, FICHA t2, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   ");
			miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA ");
			miQuery.append(" AND t1.IDMAQUINA =t2.IDMAQUINA AND t2.EJECUTADO=1 AND TO_CHAR(t2.feejec,'YYYY') =  ");
			miQuery.append(filtroPrevAnual.getAnio() == null ? "0"
					: filtroPrevAnual.getAnio());
			miQuery.append(where);
			miQuery.append(" order by UPPER(mcodigo), idmaquina ");

		} else if (filtroPrevAnual != null
				&& filtroPrevAnual.getEjecutado() != null
				&& "0".equals(filtroPrevAnual.getEjecutado())) {
			// Filtro Situacion= Pendientes
			miQuery.append(" distinct idmaquina, mcodigo  from (SELECT t1.idmaquina, t1.mcodigo FROM MAQUINAS t1, FICHA t2, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9  ");
			miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t2.IDMAQUINA AND (t2.EJECUTADO<>1 OR t2.EJECUTADO IS NULL) AND TO_CHAR(t2.feejec,'YYYY') = ");
			miQuery.append(filtroPrevAnual.getAnio() == null ? "0"
					: filtroPrevAnual.getAnio());
			miQuery.append(where);
			miQuery.append(" UNION ALL SELECT t1.idmaquina, t1.mcodigo FROM MAQUINAS t1, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9 ");
			miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO AND t1.IDGAMA = t9.IDGAMA ");
			miQuery.append(where);
			miQuery.append(") order by UPPER(mcodigo), idmaquina ");

		} else {
			miQuery.append(" distinct t1.idmaquina, t1.mcodigo  FROM MAQUINAS t1, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   ");
			miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA ");
			miQuery.append(where);
			miQuery.append(" order by UPPER(mcodigo), idmaquina ");
		}

		if (pagination != null) {
			miQuery = pagination.getPaginationQuery(miQuery);
		}

		ArrayList miLista = (ArrayList) this.jdbcTemplate.query(
				miQuery.toString(), this.rwMapPGTodos, params.toArray());

		return miLista;

	}

	/**
	 * obtener los idMaquinas que cumplen con el filtro
	 * 
	 * @param filtroActAnual
	 *            ActAnual
	 * @return ArrayList
	 */
	@Transactional(readOnly = true)
	@SuppressWarnings("rawtypes")
	public ArrayList obtenerIdMaquinasAA(ActAnual filtroActAnual,
			Pagination pagination) {

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereActAnualContar(filtroActAnual,
				false);
		StringBuilder where = new StringBuilder("  ");
		where.append(mapaWhere.get("query"));
		List<?> params = (List<?>) mapaWhere.get("params");

		StringBuilder miQuery = new StringBuilder(
				"SELECT distinct t1.idmaquina, t1.mcodigo FROM MAQUINAS t1, FICHA t2, FICHATECNICO t3, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   ");
		miQuery.append(" WHERE t1.IDMAQUINA=t2.IDMAQUINA AND t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t2.IDFICHA = t3.IDFICHA(+) ");
		miQuery.append(" AND TO_CHAR(nvl((select max(trunc (t4.fefin)) from FICHAEJECUCION t4 WHERE t4.IDFITEC = t3.IDFITEC),t2.feejec),'YYYY') = ? ");
		miQuery.append(where);
		miQuery.append(" order by UPPER(t1.mcodigo), t1.idmaquina ");

		if (pagination != null) {
			miQuery = pagination.getPaginationQuery(miQuery);
		}

		ArrayList miLista = (ArrayList) this.jdbcTemplate.query(
				miQuery.toString(), this.rwMapPGTodos, params.toArray());

		return miLista;

	}

	/**
	 * obtener el número de máquinas que cumplen con el filtro
	 * 
	 * @param filtroPlanGeneral
	 *            PlanGeneral
	 * @return Long
	 */
	@Transactional(readOnly = true)
	@SuppressWarnings("rawtypes")
	public Long obtenerMaquinasPGCount(PlanGeneral filtroPlanGeneral) {

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWherePlanGeneralTodos(
				filtroPlanGeneral, false);
		StringBuilder where = new StringBuilder("  ");
		where.append(mapaWhere.get("query"));
		// List<?> params = (List<?>) mapaWhere.get("params");
		List<?> paramsAnio = (List<?>) mapaWhere.get("paramsAnio");
		List<?> paramsWhere = (List<?>) mapaWhere.get("paramsWhere");
		ArrayList<Object> paramsFinal = new ArrayList<Object>();

		StringBuilder miQuery = new StringBuilder(
				" SELECT count(distinct idmaquina) from (");

		if (filtroPlanGeneral != null
				&& filtroPlanGeneral.getEjecutado() != null) {
			// HAY FILTRO DE SITUACION
			if (filtroPlanGeneral.getEjecutado().equals("1")) {
				// HA FILTRADO POR EJECUTADOS
				if (filtroPlanGeneral != null
						&& filtroPlanGeneral.getTipoMant() != null) {
					if (filtroPlanGeneral.getTipoMant().equals("C")) {
						// ha filtrado POR CORRECTIVOS EJECUTADOS
						miQuery.append(" SELECT 'C' as tabla, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, t3.idparte as idparte, NVL(t3.fechaej, t3.fechare) as parteFeeje, t3.EJECUTADO as parteEjec FROM MAQUINAS t1, PARTES t3, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9  ");
						miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t3.IDMAQUINA AND t3.EJECUTADO=1 AND TO_CHAR(NVL(t3.fechaej, t3.fechare),'YYYY') = ? ");
						miQuery.append(where);
						paramsFinal.addAll(paramsAnio);
						paramsFinal.addAll(paramsWhere);
					}
					if (filtroPlanGeneral.getTipoMant().equals("P")) {
						// ha filtrado POR PREVENTIVOS EJECUTADOS
						miQuery.append(" SELECT 'F' as tabla, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null as SIGMTO, t2.idficha as idficha, t2.feejec as fichaFeeje, t2.EJECUTADO as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec FROM MAQUINAS t1, FICHA t2, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   ");
						miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t2.IDMAQUINA AND t2.EJECUTADO=1 AND TO_CHAR(t2.feejec,'YYYY') = ? ");
						miQuery.append(where);
						paramsFinal.addAll(paramsAnio);
						paramsFinal.addAll(paramsWhere);
					}
				} else {
					// FILTRADO POR EJECUTADOS Y SIN FILTRO DE TIPO
					// MANTENIMIENTO
					miQuery.append(" SELECT 'C' as tabla, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, t3.idparte as idparte, NVL(t3.fechaej, t3.fechare) as parteFeeje, t3.EJECUTADO as parteEjec FROM MAQUINAS t1, PARTES t3, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9  ");
					miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t3.IDMAQUINA AND t3.EJECUTADO=1 AND TO_CHAR(NVL(t3.fechaej, t3.fechare),'YYYY') = ? ");
					miQuery.append(where);
					paramsFinal.addAll(paramsAnio);
					paramsFinal.addAll(paramsWhere);
					miQuery.append(" UNION ALL SELECT 'F' as tabla, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null as SIGMTO, t2.idficha as idficha, t2.feejec as fichaFeeje, t2.EJECUTADO as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec FROM MAQUINAS t1, FICHA t2, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   ");
					miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t2.IDMAQUINA AND t2.EJECUTADO=1 AND TO_CHAR(t2.feejec,'YYYY') = ? ");
					miQuery.append(where);
					paramsFinal.addAll(paramsAnio);
					paramsFinal.addAll(paramsWhere);
				}
			}
			if (filtroPlanGeneral.getEjecutado().equals("0")) {
				// HA FILTRADO POR PENDIENTES
				if (filtroPlanGeneral != null
						&& filtroPlanGeneral.getTipoMant() != null) {
					if (filtroPlanGeneral.getTipoMant().equals("C")) {
						// ha filtrado POR CORRECTIVOS PENDIENTES
						miQuery.append(" SELECT 'C' as tabla, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, t3.idparte as idparte, NVL(t3.fechaej, t3.fechare) as parteFeeje, t3.EJECUTADO as parteEjec FROM MAQUINAS t1, PARTES t3, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9  ");
						miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t3.IDMAQUINA AND (t3.EJECUTADO<>1 OR t3.EJECUTADO IS NULL) AND TO_CHAR(NVL(t3.fechaej, t3.fechare),'YYYY') = ? ");
						miQuery.append(where);
						paramsFinal.addAll(paramsAnio);
						paramsFinal.addAll(paramsWhere);
					}
					if (filtroPlanGeneral.getTipoMant().equals("P")) {
						// ha filtrado POR PREVENTIVOS PENDIENTES
						miQuery.append(" SELECT 'M' as tabla, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, t1.SIG_MTO as SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec FROM MAQUINAS t1, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   ");
						miQuery.append(" WHERE t1.IDEDIFICIO = t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA  ");
						miQuery.append(where);
						paramsFinal.addAll(paramsWhere);
						miQuery.append(" UNION ALL SELECT 'F' as tabla, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null as SIGMTO, t2.idficha as idficha, t2.feejec as fichaFeeje, t2.EJECUTADO as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec FROM MAQUINAS t1, FICHA t2, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   ");
						miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t2.IDMAQUINA AND (t2.EJECUTADO<>1 OR t2.EJECUTADO IS NULL) AND TO_CHAR(t2.feejec,'YYYY') = ? ");
						miQuery.append(where);
						paramsFinal.addAll(paramsAnio);
						paramsFinal.addAll(paramsWhere);
					}
				} else {
					// FILTRADO POR PENDIENTES Y SIN FILTRO DE TIPO
					// MANTENIMIENTO
					miQuery.append(" SELECT 'M' as tabla, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, t1.SIG_MTO as SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec FROM MAQUINAS t1, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   ");
					miQuery.append(" WHERE t1.IDEDIFICIO = t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA  ");
					miQuery.append(where);
					paramsFinal.addAll(paramsWhere);
					miQuery.append(" UNION ALL SELECT 'C' as tabla, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, t3.idparte as idparte, NVL(t3.fechaej, t3.fechare) as parteFeeje, t3.EJECUTADO as parteEjec FROM MAQUINAS t1, PARTES t3, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9  ");
					miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t3.IDMAQUINA AND (t3.EJECUTADO<>1 OR t3.EJECUTADO IS NULL) AND TO_CHAR(NVL(t3.fechaej, t3.fechare),'YYYY') = ? ");
					miQuery.append(where);
					paramsFinal.addAll(paramsAnio);
					paramsFinal.addAll(paramsWhere);
					miQuery.append(" UNION ALL SELECT 'F' as tabla, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null as SIGMTO, t2.idficha as idficha, t2.feejec as fichaFeeje, t2.EJECUTADO as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec FROM MAQUINAS t1, FICHA t2, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   ");
					miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t2.IDMAQUINA AND (t2.EJECUTADO<>1 OR t2.EJECUTADO IS NULL) AND TO_CHAR(t2.feejec,'YYYY') = ? ");
					miQuery.append(where);
					paramsFinal.addAll(paramsAnio);
					paramsFinal.addAll(paramsWhere);
				}
			}
		} else {
			// NO HAY FILTRO DE SITUACION
			if (filtroPlanGeneral != null
					&& filtroPlanGeneral.getTipoMant() != null) {
				// HAY FILTRO DE TIPO DE MANTENIMIENTO
				if (filtroPlanGeneral.getTipoMant().equals("C")) {
					// ha filtrado POR CORRECTIVOS
					miQuery.append(" SELECT 'C' as tabla, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, t3.idparte as idparte, NVL(t3.fechaej, t3.fechare) as parteFeeje, t3.EJECUTADO as parteEjec FROM MAQUINAS t1, PARTES t3, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9  ");
					miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t3.IDMAQUINA AND TO_CHAR(NVL(t3.fechaej, t3.fechare),'YYYY') = ? ");
					miQuery.append(where);
					paramsFinal.addAll(paramsAnio);
					paramsFinal.addAll(paramsWhere);
				}
				if (filtroPlanGeneral.getTipoMant().equals("P")) {
					// ha filtrado POR PREVENTIVOS
					miQuery.append(" SELECT 'M' as tabla, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, t1.SIG_MTO as SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec FROM MAQUINAS t1, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   ");
					miQuery.append(" WHERE t1.IDEDIFICIO = t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA  ");
					miQuery.append(where);
					paramsFinal.addAll(paramsWhere);
					miQuery.append(" UNION ALL SELECT 'F' as tabla, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null as SIGMTO, t2.idficha as idficha, t2.feejec as fichaFeeje, t2.EJECUTADO as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec FROM MAQUINAS t1, FICHA t2, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   ");
					miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t2.IDMAQUINA AND TO_CHAR(t2.feejec,'YYYY') = ? ");
					miQuery.append(where);
					paramsFinal.addAll(paramsAnio);
					paramsFinal.addAll(paramsWhere);
				}
			} else {
				// NO HAY FILTRO DE TIPOS DE MANTENIMIENTO NI SITUACION
				miQuery.append(" SELECT 'M' as tabla, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, t1.SIG_MTO as SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec FROM MAQUINAS t1, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   ");
				miQuery.append(" WHERE t1.IDEDIFICIO = t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA  ");
				miQuery.append(where);
				paramsFinal.addAll(paramsWhere);
				miQuery.append(" UNION ALL SELECT 'F' as tabla, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null as SIGMTO, t2.idficha as idficha, t2.feejec as fichaFeeje, t2.EJECUTADO as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec FROM MAQUINAS t1, FICHA t2, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   ");
				miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t2.IDMAQUINA AND TO_CHAR(t2.feejec,'YYYY') = ? ");
				miQuery.append(where);
				paramsFinal.addAll(paramsAnio);
				paramsFinal.addAll(paramsWhere);
				miQuery.append(" UNION ALL SELECT 'C' as tabla, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, t3.idparte as idparte, NVL(t3.fechaej, t3.fechare) as parteFeeje, t3.EJECUTADO as parteEjec FROM MAQUINAS t1, PARTES t3, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9  ");
				miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t3.IDMAQUINA AND TO_CHAR(NVL(t3.fechaej, t3.fechare),'YYYY') = ? ");
				miQuery.append(where);
				paramsFinal.addAll(paramsAnio);
				paramsFinal.addAll(paramsWhere);
			}
		}
		/*
		 * miQuery.append(
		 * " SELECT 'M' as tabla, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, t1.SIG_MTO as SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec FROM MAQUINAS t1, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   "
		 * ); miQuery.append(
		 * " WHERE t1.IDEDIFICIO = t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA "
		 * );
		 * 
		 * miQuery.append(where); miQuery.append(
		 * " UNION ALL SELECT 'F' as tabla, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null as SIGMTO, t2.idficha as idficha, t2.feejec as fichaFeeje, t2.EJECUTADO as fichaEjec, null as idparte, null as parteFeeje, null as parteEjec FROM MAQUINAS t1, FICHA t2, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   "
		 * ); miQuery.append(
		 * " WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t2.IDMAQUINA AND TO_CHAR(t2.feejec,'YYYY') = ? "
		 * ); miQuery.append(where); miQuery.append(
		 * " UNION ALL SELECT 'C' as tabla, t1.IDMAQUINA IDMAQUINA, t1.MCODIGO MCODIGO, t1.CMAQUINA CMAQUINA, t1.EMAQUINA EMAQUINA, null SIGMTO, null as idficha, null as fichaFeeje, null as fichaEjec, t3.idparte as idparte, NVL(t3.fechaej, t3.fechare) as parteFeeje, t3.EJECUTADO as parteEjec FROM MAQUINAS t1, PARTES t3, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   "
		 * ); miQuery.append(
		 * " WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t3.IDMAQUINA AND TO_CHAR(NVL(t3.fechaej, t3.fechare),'YYYY') = ? "
		 * ); miQuery.append(where);
		 */

		miQuery.append(" )");

		return this.jdbcTemplate.queryForLong(miQuery.toString(),
				paramsFinal.toArray());

	}

	/**
	 * obtener el número de máquinas que cumplen con el filtro
	 * 
	 * @param filtroPrevAnual
	 *            PrevAnual
	 * @return Long
	 */
	@Transactional(readOnly = true)
	@SuppressWarnings("rawtypes")
	public Long obtenerMaquinasPACount(PrevAnual filtroPrevAnual) {

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWherePrevAnualContar(
				filtroPrevAnual, false);
		StringBuilder where = new StringBuilder("  ");
		where.append(mapaWhere.get("query"));
		List<?> params = (List<?>) mapaWhere.get("params");

		StringBuilder miQuery = new StringBuilder(" SELECT ");
		if (filtroPrevAnual != null && filtroPrevAnual.getEjecutado() != null
				&& "1".equals(filtroPrevAnual.getEjecutado())) {
			// Filtro Situacion= Realizados
			miQuery.append(" count(distinct t1.idmaquina) FROM MAQUINAS t1, FICHA t2, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   ");
			miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA ");
			miQuery.append(" AND t1.IDMAQUINA =t2.IDMAQUINA AND t2.EJECUTADO=1 AND TO_CHAR(t2.feejec,'YYYY') =  ");
			miQuery.append(filtroPrevAnual.getAnio() == null ? "0"
					: filtroPrevAnual.getAnio());
			miQuery.append(where);

		} else if (filtroPrevAnual != null
				&& filtroPrevAnual.getEjecutado() != null
				&& "0".equals(filtroPrevAnual.getEjecutado())) {
			// Filtro Situacion= Pendientes
			miQuery.append(" count(distinct idmaquina) from (SELECT t1.IDMAQUINA IDMAQUINA FROM MAQUINAS t1, FICHA t2, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9  ");
			miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t1.IDMAQUINA =t2.IDMAQUINA AND (t2.EJECUTADO<>1 OR t2.EJECUTADO IS NULL) AND TO_CHAR(t2.feejec,'YYYY') = ");
			miQuery.append(filtroPrevAnual.getAnio() == null ? "0"
					: filtroPrevAnual.getAnio());
			miQuery.append(where);
			miQuery.append(" UNION ALL SELECT t1.IDMAQUINA IDMAQUINA FROM MAQUINAS t1, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9 ");
			miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO AND t1.IDGAMA = t9.IDGAMA ");
			miQuery.append(where);
			miQuery.append(")");

		} else {
			miQuery.append(" count(distinct t1.idmaquina) FROM MAQUINAS t1, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   ");
			miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO AND t1.IDGAMA = t9.IDGAMA ");
			miQuery.append(where);

		}

		return this.jdbcTemplate.queryForLong(miQuery.toString(),
				params.toArray());

	}

	/**
	 * obtener el número de máquinas que cumplen con el filtro
	 * 
	 * @param filtroActAnual
	 *            ActAnual
	 * @return Long
	 */
	@Transactional(readOnly = true)
	@SuppressWarnings("rawtypes")
	public Long obtenerMaquinasAACount(ActAnual filtroActAnual) {

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereActAnualContar(filtroActAnual,
				false);
		StringBuilder where = new StringBuilder("  ");
		where.append(mapaWhere.get("query"));
		List<?> params = (List<?>) mapaWhere.get("params");

		// StringBuilder miQuery = new StringBuilder(
		// " SELECT count(distinct idmaquina)  FROM MAQUINAS t1, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9   ");
		// miQuery.append(" WHERE t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA ");

		StringBuilder miQuery = new StringBuilder(
				" SELECT count(distinct t1.idmaquina) FROM MAQUINAS t1, FICHA t2, FICHATECNICO t3, EDIFICIOSVER t7, EDIFICIOS t8, GAMAS t9 ");
		miQuery.append(" WHERE t1.IDMAQUINA=t2.IDMAQUINA AND t1.IDEDIFICIO =t7.IDEDIFICIO AND t1.IDEDIFICIO = t8.IDEDIFICIO  AND t1.IDGAMA = t9.IDGAMA AND t2.IDFICHA = t3.IDFICHA(+) ");
		miQuery.append(" AND TO_CHAR(nvl((select max(trunc (t4.fefin)) from FICHAEJECUCION t4 WHERE t4.IDFITEC = t3.IDFITEC),t2.feejec),'YYYY') = ? ");

		miQuery.append(where);

		return this.jdbcTemplate.queryForLong(miQuery.toString(),
				params.toArray());

	}

	/**
	 * Removes a single row in the Maquinas table.
	 * 
	 * @param maquinas
	 *            Pagination
	 * @return
	 */
	public void remove(Maquinas maquinas) {
		String query = "DELETE FROM MAQUINAS WHERE IDMAQUINA=?";
		this.jdbcTemplate.update(query, maquinas.getIdmaquina());
	}

	/**
	 * Finds a List of rows in the Maquinas table.
	 * 
	 * @param maquinas
	 *            Maquinas
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Maquinas> findAll(Maquinas maquinas, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDMAQUINA IDMAQUINA,t1.MCODIGO MCODIGO,t1.IDGAMA IDGAMA,t1.CMAQUINA CMAQUINA,t1.EMAQUINA EMAQUINA,t1.PRIMER_MTO PRIMERMTO,t1.SIG_MTO SIGMTO,t1.IDEDIFICIO IDEDIFICIO,t1.IDZONA IDZONA,t1.IDPLANTA IDPLANTA,t1.FEINI FEINI,t1.BAJA BAJA ");
		query.append("FROM MAQUINAS t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(maquinas);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Maquinas>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Maquinas table.
	 * 
	 * @param maquinas
	 *            Maquinas
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Maquinas maquinas) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM MAQUINAS t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(maquinas);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Maquinas table using like.
	 * 
	 * @param maquinas
	 *            Maquinas
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Maquinas> findAllLike(Maquinas maquinas, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDMAQUINA IDMAQUINA,t1.MCODIGO MCODIGO, t1.IDGAMA IDGAMA,t1.CMAQUINA CMAQUINA,t1.EMAQUINA EMAQUINA,t1.PRIMER_MTO PRIMERMTO,t1.SIG_MTO SIGMTO,t1.IDEDIFICIO IDEDIFICIO,t1.IDZONA IDZONA,t1.IDPLANTA IDPLANTA,t1.FEINI FEINI,t1.BAJA BAJA ");
		query.append("FROM MAQUINAS t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(maquinas, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Maquinas>) this.jdbcTemplate.query(query.toString(),
				this.rwMapMaquinas, params.toArray());
	}

	/**
	 * Counts rows in the Maquinas table using like.
	 * 
	 * @param maquinas
	 *            Maquinas
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Maquinas maquinas, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM MAQUINAS t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(maquinas, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Maquinas table using like.
	 * 
	 * @param maquinas
	 *            Maquinas
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param sUIDUsuario
	 *            String
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Maquinas> obtenerMaquinasUsuario(Maquinas maquinas,
			Pagination pagination, Boolean startsWith, String sUIDUsuario) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDMAQUINA IDMAQUINA,t1.MCODIGO MCODIGO, t1.IDGAMA IDGAMA, t3.CGAMA CGAMA, t3.EGAMA EGAMA,t1.CMAQUINA CMAQUINA,t1.EMAQUINA EMAQUINA,t1.PRIMER_MTO PRIMERMTO,t1.SIG_MTO SIGMTO,t1.IDEDIFICIO IDEDIFICIO, t4.CEDIFICIO CEDIFICIO, t4.EEDIFICIO EEDIFICIO, t4.REDIFICIO REDIFICIO, t4.GESTCENTRA GESTCENTRA,t1.IDZONA IDZONA, t5.CZONA CZONA, t5.EZONA EZONA, t5.RZONA RZONA,t1.IDPLANTA IDPLANTA, t6.CPLANTA CPLANTA, t6.EPLANTA EPLANTA, t6.RPLANTA RPLANTA,t1.FEINI FEINI,t1.BAJA BAJA, ");
		query.append(" (t4.REDIFICIO || '/' || CASE WHEN t5.RZONA='0' THEN '' ELSE t5.RZONA END || '/' || CASE WHEN t6.RPLANTA='0' THEN '' ELSE t6.RPLANTA END) AS EDIFZONAPLTA ");
		query.append(" FROM MAQUINAS t1, GAMAS t3, EDIFICIOS t4, ZONAS t5, PLANTAS t6 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMaquinas(maquinas, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE t1.IDGAMA=t3.IDGAMA(+) AND t1.IDEDIFICIO=t4.IDEDIFICIO(+) AND t1.IDZONA=t5.IDZONA(+) AND t1.IDPLANTA=t6.IDPLANTA(+)");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Maquinas>) this.jdbcTemplate.query(query.toString(),
				this.rwMapMaquinas, params.toArray());
	}

	/**
	 * Counts rows in the Maquinas table using like.
	 * 
	 * @param maquinas
	 *            Maquinas
	 * @param startsWith
	 *            Boolean
	 * @param sUIDUsuario
	 *            String
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long obtenerMaquinasUsuarioCount(Maquinas maquinas,
			Boolean startsWith, String sUIDUsuario) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM MAQUINAS t1, GAMAs t3, EDIFICIOS t4, ZONAS t5, PLANTAS t6 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMaquinas(maquinas, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE t1.IDGAMA=t3.IDGAMA(+) AND t1.IDEDIFICIO=t4.IDEDIFICIO(+) AND t1.IDZONA=t5.IDZONA(+) AND t1.IDPLANTA=t6.IDPLANTA(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Maquinas entity
	 * 
	 * @param maquinas
	 *            Maquinas Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Maquinas maquinas) {

		StringBuilder where = new StringBuilder(
				MaquinasDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (maquinas != null && maquinas.getIdmaquina() != null) {
			where.append(" AND t1.IDMAQUINA = ?");
			params.add(maquinas.getIdmaquina());
		}
		if (maquinas != null && maquinas.getMcodigo() != null) {
			where.append(" AND t1.MCODIGO = ?");
			params.add(maquinas.getMcodigo());
		}
		if (maquinas != null && maquinas.getIdgama() != null) {
			where.append(" AND t1.IDGAMA = ?");
			params.add(maquinas.getIdgama());
		}
		if (maquinas != null && maquinas.getCmaquina() != null) {
			where.append(" AND t1.CMAQUINA = ?");
			params.add(maquinas.getCmaquina());
		}
		if (maquinas != null && maquinas.getEmaquina() != null) {
			where.append(" AND t1.EMAQUINA = ?");
			params.add(maquinas.getEmaquina());
		}
		if (maquinas != null && maquinas.getPrimerMto() != null) {
			where.append(" AND t1.PRIMER_MTO = ?");
			params.add(maquinas.getPrimerMto());
		}
		if (maquinas != null && maquinas.getSigMto() != null) {
			where.append(" AND t1.SIG_MTO = ?");
			params.add(maquinas.getSigMto());
		}
		if (maquinas != null && maquinas.getIdedificio() != null) {
			where.append(" AND t1.IDEDIFICIO = ?");
			params.add(maquinas.getIdedificio());
		}
		if (maquinas != null && maquinas.getIdzona() != null) {
			where.append(" AND t1.IDZONA = ?");
			params.add(maquinas.getIdzona());
		}
		if (maquinas != null && maquinas.getIdplanta() != null) {
			where.append(" AND t1.IDPLANTA = ?");
			params.add(maquinas.getIdplanta());
		}
		if (maquinas != null && maquinas.getFeini() != null) {
			where.append(" AND t1.FEINI = ?");
			params.add(maquinas.getFeini());
		}
		if (maquinas != null && maquinas.getBaja() != null) {
			where.append(" AND t1.BAJA = ?");
			params.add(maquinas.getBaja());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Maquinas entity
	 * 
	 * @param maquinas
	 *            Maquinas Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Maquinas maquinas, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				MaquinasDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (maquinas != null && maquinas.getIdmaquina() != null) {
			where.append(" AND t1.IDMAQUINA = ?");
			params.add(maquinas.getIdmaquina());
		}
		if (maquinas != null && maquinas.getMcodigo() != null) {
			where.append(" AND UPPER(t1.MCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(maquinas.getMcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + maquinas.getMcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.MCODIGO IS NOT NULL");
		}
		if (maquinas != null && maquinas.getIdgama() != null) {
			where.append(" AND t1.IDGAMA = ?");
			params.add(maquinas.getIdgama());
		}
		if (maquinas != null && maquinas.getCmaquina() != null) {
			where.append(" AND UPPER(t1.CMAQUINA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(maquinas.getCmaquina().toUpperCase() + "%");
			} else {
				params.add("%" + maquinas.getCmaquina().toUpperCase() + "%");
			}
			where.append(" AND t1.CMAQUINA IS NOT NULL");
		}
		if (maquinas != null && maquinas.getEmaquina() != null) {
			where.append(" AND UPPER(t1.EMAQUINA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(maquinas.getEmaquina().toUpperCase() + "%");
			} else {
				params.add("%" + maquinas.getEmaquina().toUpperCase() + "%");
			}
			where.append(" AND t1.EMAQUINA IS NOT NULL");
		}
		if (maquinas != null && maquinas.getPrimerMto() != null) {
			where.append(" AND t1.PRIMER_MTO = ?");
			params.add(maquinas.getPrimerMto());
		}
		if (maquinas != null && maquinas.getSigMto() != null) {
			where.append(" AND t1.SIG_MTO = ?");
			params.add(maquinas.getSigMto());
		}
		if (maquinas != null && maquinas.getIdedificio() != null) {
			where.append(" AND UPPER(t1.IDEDIFICIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(maquinas.getIdedificio().toUpperCase() + "%");
			} else {
				params.add("%" + maquinas.getIdedificio().toUpperCase() + "%");
			}
			where.append(" AND t1.IDEDIFICIO IS NOT NULL");
		}
		if (maquinas != null && maquinas.getIdzona() != null) {
			where.append(" AND t1.IDZONA = ?");
			params.add(maquinas.getIdzona());
		}
		if (maquinas != null && maquinas.getIdplanta() != null) {
			where.append(" AND t1.IDPLANTA = ?");
			params.add(maquinas.getIdplanta());
		}
		if (maquinas != null && maquinas.getFeini() != null) {
			where.append(" AND t1.FEINI = ?");
			params.add(maquinas.getFeini());
		}
		if (maquinas != null && maquinas.getBaja() != null) {
			where.append(" AND UPPER(t1.BAJA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(maquinas.getBaja().toUpperCase() + "%");
			} else {
				params.add("%" + maquinas.getBaja().toUpperCase() + "%");
			}
			where.append(" AND t1.BAJA IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	private Map<String, ?> getWhereMaquinas(Maquinas maquinas,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				MaquinasDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (maquinas != null && maquinas.getIdmaquina() != null) {
			where.append(" AND t1.IDMAQUINA = ?");
			params.add(maquinas.getIdmaquina());
		}
		if (maquinas != null && maquinas.getMcodigo() != null) {
			where.append(" AND UPPER(t1.MCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(maquinas.getMcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + maquinas.getMcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.MCODIGO IS NOT NULL");
		}
		if (maquinas != null && maquinas.getIdgama() != null) {
			where.append(" AND t1.IDGAMA = ?");
			params.add(maquinas.getIdgama());
		}
		if (maquinas != null && maquinas.getGama() != null
				&& maquinas.getGama().getCgama() != null) {
			where.append(" AND UPPER(t3.CGAMA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(maquinas.getGama().getCgama().toUpperCase() + "%");
			} else {
				params.add("%" + maquinas.getGama().getCgama().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.CGAMA IS NOT NULL");
		}
		if (maquinas != null && maquinas.getGama() != null
				&& maquinas.getGama().getEgama() != null) {
			where.append(" AND UPPER(t3.EGAMA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(maquinas.getGama().getEgama().toUpperCase() + "%");
			} else {
				params.add("%" + maquinas.getGama().getEgama().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.EGAMA IS NOT NULL");
		}

		if (maquinas != null && maquinas.getCmaquina() != null) {
			where.append(" AND UPPER(t1.CMAQUINA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(maquinas.getCmaquina().toUpperCase() + "%");
			} else {
				params.add("%" + maquinas.getCmaquina().toUpperCase() + "%");
			}
			where.append(" AND t1.CMAQUINA IS NOT NULL");
		}
		if (maquinas != null && maquinas.getEmaquina() != null) {
			where.append(" AND UPPER(t1.EMAQUINA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(maquinas.getEmaquina().toUpperCase() + "%");
			} else {
				params.add("%" + maquinas.getEmaquina().toUpperCase() + "%");
			}
			where.append(" AND t1.EMAQUINA IS NOT NULL");
		}
		if (maquinas != null && maquinas.getPrimerMto() != null) {
			where.append(" AND t1.PRIMER_MTO = ?");
			params.add(maquinas.getPrimerMto());
		}
		if (maquinas != null && maquinas.getSigMto() != null) {
			where.append(" AND t1.SIG_MTO = ?");
			params.add(maquinas.getSigMto());
		}
		if (maquinas != null && maquinas.getIdedificio() != null) {
			where.append(" AND UPPER(t1.IDEDIFICIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(maquinas.getIdedificio().toUpperCase() + "%");
			} else {
				params.add("%" + maquinas.getIdedificio().toUpperCase() + "%");
			}
			where.append(" AND t1.IDEDIFICIO IS NOT NULL");
		}
		if (maquinas != null && maquinas.getEdificio() != null
				&& maquinas.getEdificio().getCedificio() != null) {
			where.append(" AND UPPER(t4.CEDIFICIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(maquinas.getEdificio().getCedificio().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ maquinas.getEdificio().getCedificio().toUpperCase()
						+ "%");
			}
			where.append(" AND t4.CEDIFICIO IS NOT NULL");
		}
		if (maquinas != null && maquinas.getEdificio() != null
				&& maquinas.getEdificio().getEedificio() != null) {
			where.append(" AND UPPER(t4.EEDIFICIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(maquinas.getEdificio().getEedificio().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ maquinas.getEdificio().getEedificio().toUpperCase()
						+ "%");
			}
			where.append(" AND t4.EEDIFICIO IS NOT NULL");
		}
		if (maquinas != null && maquinas.getEdificio() != null
				&& maquinas.getEdificio().getGestCentra() != null) {
			where.append(" AND UPPER(t4.GESTCENTRA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(maquinas.getEdificio().getGestCentra().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ maquinas.getEdificio().getGestCentra().toUpperCase()
						+ "%");
			}
			where.append(" AND t4.GESTCENTRA IS NOT NULL");
		}

		if (maquinas != null && maquinas.getIdzona() != null) {
			where.append(" AND t1.IDZONA = ?");
			params.add(maquinas.getIdzona());
		}
		if (maquinas != null && maquinas.getZona() != null
				&& maquinas.getZona().getCzona() != null) {
			where.append(" AND UPPER(t5.CZONA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(maquinas.getZona().getCzona().toUpperCase() + "%");
			} else {
				params.add("%" + maquinas.getZona().getCzona().toUpperCase()
						+ "%");
			}
			where.append(" AND t5.CZONA IS NOT NULL");
		}
		if (maquinas != null && maquinas.getZona() != null
				&& maquinas.getZona().getEzona() != null) {
			where.append(" AND UPPER(t5.EZONA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(maquinas.getZona().getEzona().toUpperCase() + "%");
			} else {
				params.add("%" + maquinas.getZona().getEzona().toUpperCase()
						+ "%");
			}
			where.append(" AND t5.EZONA IS NOT NULL");
		}
		if (maquinas != null && maquinas.getIdplanta() != null) {
			where.append(" AND t1.IDPLANTA = ?");
			params.add(maquinas.getIdplanta());
		}
		if (maquinas != null && maquinas.getPlanta() != null
				&& maquinas.getPlanta().getCplanta() != null) {
			where.append(" AND UPPER(t6.CPLANTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(maquinas.getPlanta().getCplanta().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ maquinas.getPlanta().getCplanta().toUpperCase() + "%");
			}
			where.append(" AND t6.CPLANTA IS NOT NULL");
		}
		if (maquinas != null && maquinas.getPlanta() != null
				&& maquinas.getPlanta().getEplanta() != null) {
			where.append(" AND UPPER(t6.EPLANTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(maquinas.getPlanta().getEplanta().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ maquinas.getPlanta().getEplanta().toUpperCase() + "%");
			}
			where.append(" AND t6.EPLANTA IS NOT NULL");
		}
		if (maquinas != null && maquinas.getFeini() != null) {
			where.append(" AND t1.FEINI = ?");
			params.add(maquinas.getFeini());
		}
		if (maquinas != null && maquinas.getBaja() != null) {
			where.append(" AND UPPER(t1.BAJA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(maquinas.getBaja().toUpperCase() + "%");
			} else {
				params.add("%" + maquinas.getBaja().toUpperCase() + "%");
			}
			where.append(" AND t1.BAJA IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	private Map<String, ?> getWherePlanGeneralTodos(
			PlanGeneral filtroPlanGeneral, Boolean startsWith) {

		String idioma = LocaleContextHolder.getLocale().getLanguage();

		StringBuilder where = new StringBuilder(
				MaquinasDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();
		List<Object> paramsAnio = new ArrayList<Object>();
		List<Object> paramsTotal = new ArrayList<Object>();

		if (filtroPlanGeneral != null && filtroPlanGeneral.getAnio() != null) {
			paramsAnio.add(filtroPlanGeneral.getAnio());
		}

		if (filtroPlanGeneral != null && filtroPlanGeneral.getMaquina() != null) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				where.append(" AND UPPER(t1.EMAQUINA) like ? ESCAPE  '\\'");
				where.append(" AND t1.EMAQUINA IS NOT NULL");
			} else {
				where.append(" AND UPPER(t1.CMAQUINA) like ? ESCAPE  '\\'");
				where.append(" AND t1.CMAQUINA IS NOT NULL");
			}
			params.add("%" + filtroPlanGeneral.getMaquina().toUpperCase() + "%");
		}
		if (filtroPlanGeneral != null
				&& filtroPlanGeneral.getIdedificio() != null) {
			where.append(" AND UPPER(t1.IDEDIFICIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(filtroPlanGeneral.getIdedificio().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ filtroPlanGeneral.getIdedificio().toUpperCase() + "%");
			}
			where.append(" AND t1.IDEDIFICIO IS NOT NULL");
		}
		if (filtroPlanGeneral != null && filtroPlanGeneral.getIdzona() != null) {
			where.append(" AND t1.IDZONA = ?");
			params.add(filtroPlanGeneral.getIdzona());
		}
		if (filtroPlanGeneral != null
				&& filtroPlanGeneral.getIdplanta() != null) {
			where.append(" AND t1.IDPLANTA = ?");
			params.add(filtroPlanGeneral.getIdplanta());
		}
		if (filtroPlanGeneral != null && filtroPlanGeneral.getIdgama() != null) {
			where.append(" AND t1.IDGAMA = ?");
			params.add(filtroPlanGeneral.getIdgama());
		}
		if (filtroPlanGeneral != null && filtroPlanGeneral.getIdclase() != null) {
			where.append(" AND t9.IDCLASE = ?");
			params.add(filtroPlanGeneral.getIdclase());
		}
		if (filtroPlanGeneral != null && filtroPlanGeneral.getIdterri() != null) {
			where.append(" AND t8.IDTERRI = ?");
			params.add(filtroPlanGeneral.getIdterri());
		}
		if (filtroPlanGeneral != null
				&& filtroPlanGeneral.getContrata() != null) {
			where.append(" AND t9.CONTRATA = ?");
			params.add(filtroPlanGeneral.getContrata());
		}

		if (filtroPlanGeneral != null
				&& filtroPlanGeneral.getIdservicio() != null
				&& filtroPlanGeneral.getIdservicio() != 0) {
			where.append(" AND t9.IDSERVICIO = ?");
			params.add(filtroPlanGeneral.getIdservicio());
		}

		where.append(" AND t7.UID_PER= ? AND t7.VER=1 ");
		params.add(filtroPlanGeneral.getUidper());

		if (filtroPlanGeneral != null
				&& filtroPlanGeneral.getIncluirBaja() != null
				&& filtroPlanGeneral.getIncluirBaja() == 1) {

		} else {
			where.append(" AND t1.BAJA= 0 ");
		}

		paramsTotal.addAll(params);
		paramsTotal.addAll(paramsAnio);
		paramsTotal.addAll(params);
		paramsTotal.addAll(paramsAnio);
		paramsTotal.addAll(params);

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", paramsTotal);
		mapWhere.put("paramsWhere", params);
		mapWhere.put("paramsAnio", paramsAnio);

		return mapWhere;
	}

	private Map<String, ?> getWherePACuesionarios(PrevAnual filtroPrevAnual,
			Boolean startsWith) {

		String idioma = LocaleContextHolder.getLocale().getLanguage();

		StringBuilder where = new StringBuilder(
				MaquinasDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();
		List<Object> paramsAnio = new ArrayList<Object>();
		List<Object> paramsTotal = new ArrayList<Object>();

		if (filtroPrevAnual != null && filtroPrevAnual.getMaquina() != null) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				where.append(" AND UPPER(t1.EMAQUINA) like ? ESCAPE  '\\'");
				where.append(" AND t1.EMAQUINA IS NOT NULL");
			} else {
				where.append(" AND UPPER(t1.CMAQUINA) like ? ESCAPE  '\\'");
				where.append(" AND t1.CMAQUINA IS NOT NULL");
			}
			params.add("%" + filtroPrevAnual.getMaquina().toUpperCase() + "%");
		}
		if (filtroPrevAnual != null && filtroPrevAnual.getIdedificio() != null) {
			where.append(" AND UPPER(t1.IDEDIFICIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(filtroPrevAnual.getIdedificio().toUpperCase() + "%");
			} else {
				params.add("%" + filtroPrevAnual.getIdedificio().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.IDEDIFICIO IS NOT NULL");
		}
		if (filtroPrevAnual != null && filtroPrevAnual.getIdzona() != null) {
			where.append(" AND t1.IDZONA = ?");
			params.add(filtroPrevAnual.getIdzona());
		}
		if (filtroPrevAnual != null && filtroPrevAnual.getIdplanta() != null) {
			where.append(" AND t1.IDPLANTA = ?");
			params.add(filtroPrevAnual.getIdplanta());
		}
		if (filtroPrevAnual != null && filtroPrevAnual.getIdgama() != null) {
			where.append(" AND t1.IDGAMA = ?");
			params.add(filtroPrevAnual.getIdgama());
		}
		if (filtroPrevAnual != null && filtroPrevAnual.getIdterri() != null) {
			where.append(" AND t8.IDTERRI = ?");
			params.add(filtroPrevAnual.getIdterri());
		}
		if (filtroPrevAnual != null && filtroPrevAnual.getContrata() != null) {
			where.append(" AND t9.CONTRATA = ?");
			params.add(filtroPrevAnual.getContrata());
		}

		where.append(" AND t7.UID_PER= ? AND t7.VER=1 ");
		params.add(filtroPrevAnual.getUidper());

		if (filtroPrevAnual != null && filtroPrevAnual.getIncluirBaja() != null
				&& filtroPrevAnual.getIncluirBaja() == 1) {

		} else {
			where.append(" AND t1.BAJA= 0 ");
		}

		paramsTotal.addAll(paramsAnio);
		paramsTotal.addAll(params);

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", paramsTotal);

		return mapWhere;
	}

	private Map<String, ?> getWherePrevAnualTodos(PrevAnual filtroPrevAnual,
			Boolean startsWith) {

		String idioma = LocaleContextHolder.getLocale().getLanguage();

		StringBuilder where = new StringBuilder(
				MaquinasDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();
		List<Object> paramsAnio = new ArrayList<Object>();
		List<Object> paramsTotal = new ArrayList<Object>();

		if (filtroPrevAnual != null && filtroPrevAnual.getAnio() != null) {
			paramsAnio.add(filtroPrevAnual.getAnio());
		}

		if (filtroPrevAnual != null && filtroPrevAnual.getMaquina() != null
				&& !filtroPrevAnual.getMaquina().equals("")) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				where.append(" AND UPPER(t1.EMAQUINA) like ? ESCAPE  '\\'");
				where.append(" AND t1.EMAQUINA IS NOT NULL");
			} else {
				where.append(" AND UPPER(t1.CMAQUINA) like ? ESCAPE  '\\'");
				where.append(" AND t1.CMAQUINA IS NOT NULL");
			}
			params.add("%" + filtroPrevAnual.getMaquina().toUpperCase() + "%");
		}
		if (filtroPrevAnual != null && filtroPrevAnual.getIdedificio() != null) {
			where.append(" AND UPPER(t1.IDEDIFICIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(filtroPrevAnual.getIdedificio().toUpperCase() + "%");
			} else {
				params.add("%" + filtroPrevAnual.getIdedificio().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.IDEDIFICIO IS NOT NULL");
		}
		if (filtroPrevAnual != null && filtroPrevAnual.getIdzona() != null) {
			where.append(" AND t1.IDZONA = ?");
			params.add(filtroPrevAnual.getIdzona());
		}
		if (filtroPrevAnual != null && filtroPrevAnual.getIdplanta() != null) {
			where.append(" AND t1.IDPLANTA = ?");
			params.add(filtroPrevAnual.getIdplanta());
		}
		if (filtroPrevAnual != null && filtroPrevAnual.getIdgama() != null) {
			where.append(" AND t1.IDGAMA = ?");
			params.add(filtroPrevAnual.getIdgama());
		}
		if (filtroPrevAnual != null && filtroPrevAnual.getIdclase() != null) {
			where.append(" AND t9.IDCLASE = ?");
			params.add(filtroPrevAnual.getIdclase());
		}
		if (filtroPrevAnual != null && filtroPrevAnual.getIdterri() != null) {
			where.append(" AND t8.IDTERRI = ?");
			params.add(filtroPrevAnual.getIdterri());
		}
		if (filtroPrevAnual != null && filtroPrevAnual.getContrata() != null) {
			where.append(" AND t9.CONTRATA = ?");
			params.add(filtroPrevAnual.getContrata());
		}
		if (filtroPrevAnual != null && filtroPrevAnual.getIdservicio() != null
				&& filtroPrevAnual.getIdservicio() != 0) {
			where.append(" AND t9.IDSERVICIO = ?");
			params.add(filtroPrevAnual.getIdservicio());
		}

		where.append(" AND t7.UID_PER= ? AND t7.VER=1 ");
		params.add(filtroPrevAnual.getUidper());

		if (filtroPrevAnual != null && filtroPrevAnual.getIncluirBaja() != null
				&& filtroPrevAnual.getIncluirBaja() == 1) {

		} else {
			where.append(" AND t1.BAJA= 0 ");
		}

		paramsTotal.addAll(paramsAnio);
		paramsTotal.addAll(params);
		if (filtroPrevAnual != null && filtroPrevAnual.getEjecutado() != null
				&& "1".equals(filtroPrevAnual.getEjecutado())) {
			// Si ha seleccionado en el filtro Situacion=Realizados irán solo F
			// y por lo tanto no habrá queñadir dos veces los parametros

		} else if (filtroPrevAnual != null
				&& filtroPrevAnual.getEjecutado() != null
				&& "0".equals(filtroPrevAnual.getEjecutado())) {
			// Si ha seleccionado en el filtro Situacion=Pendientes irán irán F
			// y P por lo que habrá que añadir dos veces los parametros
			paramsTotal.addAll(params);
		} else {
			// Si NO ha seleccionado en el filtro Situacion irán irán F
			// y P por lo que habrá que añadir dos veces los parametros
			paramsTotal.addAll(params);
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", paramsTotal);

		return mapWhere;
	}

	private Map<String, ?> getWhereActAnualTodos(ActAnual filtroActAnual,
			Boolean startsWith) {

		String idioma = LocaleContextHolder.getLocale().getLanguage();

		StringBuilder where = new StringBuilder(
				MaquinasDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();
		List<Object> paramsAnio = new ArrayList<Object>();
		List<Object> paramsTotal = new ArrayList<Object>();

		if (filtroActAnual != null && filtroActAnual.getAnio() != null) {
			paramsAnio.add(filtroActAnual.getAnio());
		}

		if (filtroActAnual != null && filtroActAnual.getMaquina() != null
				&& !filtroActAnual.getMaquina().equals("")) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				where.append(" AND UPPER(t1.EMAQUINA) like ? ESCAPE  '\\'");
				where.append(" AND t1.EMAQUINA IS NOT NULL");
			} else {
				where.append(" AND UPPER(t1.CMAQUINA) like ? ESCAPE  '\\'");
				where.append(" AND t1.CMAQUINA IS NOT NULL");
			}
			params.add("%" + filtroActAnual.getMaquina().toUpperCase() + "%");
		}
		if (filtroActAnual != null && filtroActAnual.getIdedificio() != null) {
			where.append(" AND UPPER(t1.IDEDIFICIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(filtroActAnual.getIdedificio().toUpperCase() + "%");
			} else {
				params.add("%" + filtroActAnual.getIdedificio().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.IDEDIFICIO IS NOT NULL");
		}
		if (filtroActAnual != null && filtroActAnual.getIdzona() != null) {
			where.append(" AND t1.IDZONA = ?");
			params.add(filtroActAnual.getIdzona());
		}
		if (filtroActAnual != null && filtroActAnual.getIdplanta() != null) {
			where.append(" AND t1.IDPLANTA = ?");
			params.add(filtroActAnual.getIdplanta());
		}
		if (filtroActAnual != null && filtroActAnual.getIdgama() != null) {
			where.append(" AND t1.IDGAMA = ?");
			params.add(filtroActAnual.getIdgama());
		}
		if (filtroActAnual != null && filtroActAnual.getIdclase() != null) {
			where.append(" AND t9.IDCLASE = ?");
			params.add(filtroActAnual.getIdclase());
		}
		if (filtroActAnual != null && filtroActAnual.getIdterri() != null) {
			where.append(" AND t8.IDTERRI = ?");
			params.add(filtroActAnual.getIdterri());
		}
		if (filtroActAnual != null && filtroActAnual.getContrata() != null) {
			where.append(" AND t9.CONTRATA = ?");
			params.add(filtroActAnual.getContrata());
		}

		if (filtroActAnual != null && filtroActAnual.getIdservicio() != null
				&& filtroActAnual.getIdservicio() != 0) {
			where.append(" AND t9.IDSERVICIO = ?");
			params.add(filtroActAnual.getIdservicio());
		}
		if (filtroActAnual != null && filtroActAnual.getIdficha() != null) {
			where.append(" AND t2.IDFICHA = ?");
			params.add(filtroActAnual.getIdficha());
		}

		where.append(" AND t7.UID_PER= ? AND t7.VER=1 ");
		params.add(filtroActAnual.getUidper());

		if (filtroActAnual != null && filtroActAnual.getIncluirBaja() != null
				&& filtroActAnual.getIncluirBaja() == 1) {

		} else {
			where.append(" AND t1.BAJA= 0 ");
		}

		paramsTotal.addAll(paramsAnio);
		paramsTotal.addAll(params);

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", paramsTotal);

		return mapWhere;
	}

	private Map<String, ?> getWherePrevAnualContar(PrevAnual filtroPrevAnual,
			Boolean startsWith) {

		String idioma = LocaleContextHolder.getLocale().getLanguage();

		StringBuilder where = new StringBuilder(
				MaquinasDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();
		List<Object> paramsTotal = new ArrayList<Object>();

		if (filtroPrevAnual != null && filtroPrevAnual.getMaquina() != null
				&& !filtroPrevAnual.getMaquina().equals("")) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				where.append(" AND UPPER(t1.EMAQUINA) like ? ESCAPE  '\\'");
				where.append(" AND t1.EMAQUINA IS NOT NULL");
			} else {
				where.append(" AND UPPER(t1.CMAQUINA) like ? ESCAPE  '\\'");
				where.append(" AND t1.CMAQUINA IS NOT NULL");
			}
			params.add("%" + filtroPrevAnual.getMaquina().toUpperCase() + "%");
		}
		if (filtroPrevAnual != null && filtroPrevAnual.getIdedificio() != null) {
			where.append(" AND UPPER(t1.IDEDIFICIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(filtroPrevAnual.getIdedificio().toUpperCase() + "%");
			} else {
				params.add("%" + filtroPrevAnual.getIdedificio().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.IDEDIFICIO IS NOT NULL");
		}
		if (filtroPrevAnual != null && filtroPrevAnual.getIdzona() != null) {
			where.append(" AND t1.IDZONA = ?");
			params.add(filtroPrevAnual.getIdzona());
		}
		if (filtroPrevAnual != null && filtroPrevAnual.getIdplanta() != null) {
			where.append(" AND t1.IDPLANTA = ?");
			params.add(filtroPrevAnual.getIdplanta());
		}
		if (filtroPrevAnual != null && filtroPrevAnual.getIdgama() != null) {
			where.append(" AND t1.IDGAMA = ?");
			params.add(filtroPrevAnual.getIdgama());
		}
		if (filtroPrevAnual != null && filtroPrevAnual.getIdclase() != null) {
			where.append(" AND t9.IDCLASE = ?");
			params.add(filtroPrevAnual.getIdclase());
		}
		if (filtroPrevAnual != null && filtroPrevAnual.getIdterri() != null) {
			where.append(" AND t8.IDTERRI = ?");
			params.add(filtroPrevAnual.getIdterri());
		}
		if (filtroPrevAnual != null && filtroPrevAnual.getContrata() != null) {
			where.append(" AND t9.CONTRATA = ?");
			params.add(filtroPrevAnual.getContrata());
		}

		if (filtroPrevAnual != null && filtroPrevAnual.getIdservicio() != null
				&& filtroPrevAnual.getIdservicio() != 0) {
			where.append(" AND t9.IDSERVICIO = ?");
			params.add(filtroPrevAnual.getIdservicio());
		}

		where.append(" AND t7.UID_PER= ? AND t7.VER=1 ");
		params.add(filtroPrevAnual.getUidper());

		if (filtroPrevAnual != null && filtroPrevAnual.getIncluirBaja() != null
				&& filtroPrevAnual.getIncluirBaja() == 1) {

		} else {
			where.append(" AND t1.BAJA= 0 ");
		}

		paramsTotal.addAll(params);
		if (filtroPrevAnual != null && filtroPrevAnual.getEjecutado() != null
				&& "1".equals(filtroPrevAnual.getEjecutado())) {
			// Si ha seleccionado en el filtro Situacion=Realizados irán solo F
			// y por lo tanto no habrá queñadir dos veces los parametros

		} else if (filtroPrevAnual != null
				&& filtroPrevAnual.getEjecutado() != null
				&& "0".equals(filtroPrevAnual.getEjecutado())) {
			// Si ha seleccionado en el filtro Situacion=Pendientes irán irán F
			// y
			// P por lo que habrá que añadir dos veces los parametros
			paramsTotal.addAll(params);
		} else {
			// Si no ha seleccionado en el filtro Situacion no añadir dos veces
			// los parametros
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", paramsTotal);

		return mapWhere;
	}

	private Map<String, ?> getWhereActAnualContar(ActAnual filtroActAnual,
			Boolean startsWith) {

		String idioma = LocaleContextHolder.getLocale().getLanguage();

		StringBuilder where = new StringBuilder(
				MaquinasDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();
		List<Object> paramsTotal = new ArrayList<Object>();
		List<Object> paramsAnio = new ArrayList<Object>();

		if (filtroActAnual != null && filtroActAnual.getAnio() != null) {
			paramsAnio.add(filtroActAnual.getAnio());
		}

		if (filtroActAnual != null && filtroActAnual.getMaquina() != null
				&& !filtroActAnual.getMaquina().equals("")) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				where.append(" AND UPPER(t1.EMAQUINA) like ? ESCAPE  '\\'");
				where.append(" AND t1.EMAQUINA IS NOT NULL");
			} else {
				where.append(" AND UPPER(t1.CMAQUINA) like ? ESCAPE  '\\'");
				where.append(" AND t1.CMAQUINA IS NOT NULL");
			}
			params.add("%" + filtroActAnual.getMaquina().toUpperCase() + "%");
		}
		if (filtroActAnual != null && filtroActAnual.getIdedificio() != null) {
			where.append(" AND UPPER(t1.IDEDIFICIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(filtroActAnual.getIdedificio().toUpperCase() + "%");
			} else {
				params.add("%" + filtroActAnual.getIdedificio().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.IDEDIFICIO IS NOT NULL");
		}
		if (filtroActAnual != null && filtroActAnual.getIdzona() != null) {
			where.append(" AND t1.IDZONA = ?");
			params.add(filtroActAnual.getIdzona());
		}
		if (filtroActAnual != null && filtroActAnual.getIdplanta() != null) {
			where.append(" AND t1.IDPLANTA = ?");
			params.add(filtroActAnual.getIdplanta());
		}
		if (filtroActAnual != null && filtroActAnual.getIdgama() != null) {
			where.append(" AND t1.IDGAMA = ?");
			params.add(filtroActAnual.getIdgama());
		}
		if (filtroActAnual != null && filtroActAnual.getIdclase() != null) {
			where.append(" AND t9.IDCLASE = ?");
			params.add(filtroActAnual.getIdclase());
		}
		if (filtroActAnual != null && filtroActAnual.getIdterri() != null) {
			where.append(" AND t8.IDTERRI = ?");
			params.add(filtroActAnual.getIdterri());
		}
		if (filtroActAnual != null && filtroActAnual.getContrata() != null) {
			where.append(" AND t9.CONTRATA = ?");
			params.add(filtroActAnual.getContrata());
		}
		if (filtroActAnual != null && filtroActAnual.getIdservicio() != null
				&& filtroActAnual.getIdservicio() != 0) {
			where.append(" AND t9.IDSERVICIO = ?");
			params.add(filtroActAnual.getIdservicio());
		}
		if (filtroActAnual != null && filtroActAnual.getIdficha() != null) {
			where.append(" AND t2.IDFICHA = ?");
			params.add(filtroActAnual.getIdficha());
		}
		if (filtroActAnual != null && filtroActAnual.getEjecutado() != null) {
			if ("1".equals(filtroActAnual.getEjecutado())) {
				where.append(" AND t2.EJECUTADO = 1 ");
			} else {
				where.append(" AND t2.EJECUTADO <>1 ");
			}
		}

		where.append(" AND t7.UID_PER= ? AND t7.VER=1 ");
		params.add(filtroActAnual.getUidper());

		if (filtroActAnual != null && filtroActAnual.getIncluirBaja() != null
				&& filtroActAnual.getIncluirBaja() == 1) {

		} else {
			where.append(" AND t1.BAJA= 0 ");
		}
		paramsTotal.addAll(paramsAnio);
		paramsTotal.addAll(params);

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", paramsTotal);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
