package com.ejie.aa20b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.aa20b.model.Clase;
import com.ejie.aa20b.model.Gamas;

/**
 * GamasDao generated by UDA, 02-mar-2015 11:32:36.
 * 
 * @author UDA
 */

public interface GamasDao {

	/**
	 * Inserts a single row in the Gamas table.
	 * 
	 * @param gamas
	 *            Gamas
	 * @return Gamas
	 */
	Gamas add(Gamas gamas);

	/**
	 * Updates a single row in the Gamas table.
	 * 
	 * @param gamas
	 *            Gamas
	 * @return Gamas
	 */
	Gamas update(Gamas gamas);

	/**
	 * Finds a single row in the Gamas table.
	 * 
	 * @param gamas
	 *            Gamas
	 * @return Gamas
	 */
	Gamas find(Gamas gamas);

	/**
	 * Deletes a single row in the Gamas table.
	 * 
	 * @param gamas
	 *            Gamas
	 * @return
	 */
	void remove(Gamas gamas);

	/**
	 * Finds a List of rows in the Gamas table.
	 * 
	 * @param gamas
	 *            Gamas
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Gamas> findAll(Gamas gamas, Pagination pagination);

	List<Clase> findClasesGamaServicio(Gamas gamas, Pagination pagination);

	/**
	 * Counts rows in the Gamas table.
	 * 
	 * @param gamas
	 *            Gamas
	 * @return Long
	 */
	Long findAllCount(Gamas gamas);

	/**
	 * Finds rows in the Gamas table using like.
	 * 
	 * @param gamas
	 *            Gamas
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Gamas> findAllLike(Gamas gamas, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Gamas table using like.
	 * 
	 * @param gamas
	 *            Gamas
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Gamas gamas, Boolean startsWith);

	/**
	 * Finds a single row in the Gamas table.
	 * 
	 * @param idGama
	 *            String
	 * @return Gamas
	 */
	Gamas obtenerGama(String idGama);

	/**
	 * Marcar o desmarca para contrata todas las gamas de una clase.
	 * 
	 * @param gamas
	 *            Gamas
	 * @return Gamas
	 */
	public Gamas marcarParaContra(Gamas gamas);

}
