package com.ejie.aa20b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.Fichatecnicosgmao;
import com.ejie.aa20b.model.Partetecnicosgmao;
import com.ejie.x38.dto.Pagination;

@Repository
@Transactional
public class FichatecnicosgmaoDaoImpl implements FichatecnicosgmaoDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Fichatecnicosgmao> rwMap = new RowMapper<Fichatecnicosgmao>() {
		public Fichatecnicosgmao mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Fichatecnicosgmao(resultSet.getInt("IDFITEC"),
					resultSet.getInt("IDFICHA"),
					resultSet.getLong("IDTECNICO"),
					resultSet.getString("GUIDGMAO"),
					resultSet.getString("ESTADOGMAO"),
					resultSet.getTimestamp("FECHAESTADO"),
					resultSet.getInt("TIEMPOPAUSA"),
					resultSet.getString("PAUSAAUTO"),
					resultSet.getString("GUIDPADRE"),
					resultSet.getString("GUIDSEGUIDO"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Fichatecnicos table.
	 * 
	 * @param fichatecnicos
	 *            Pagination
	 * @return Fichatecnicos
	 */
	public Fichatecnicosgmao add(Fichatecnicosgmao fichatecnicosgmao) {

		String query = "INSERT INTO FICHATECNICOSGMAO (IDFITEC, IDFICHA, IDTECNICO, GUIDGMAO, ESTADOGMAO, FECHAESTADO, TIEMPOPAUSA, PAUSAAUTO, GUIDPADRE, GUIDSEGUIDO) VALUES (?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, fichatecnicosgmao.getIdfichac(),
				fichatecnicosgmao.getIdficha(),
				fichatecnicosgmao.getIdtecnico(),
				fichatecnicosgmao.getGuidfichatecgmao(),
				fichatecnicosgmao.getEstadoGmao(),
				fichatecnicosgmao.getFechaEstadoGmao(),
				fichatecnicosgmao.getTiempoPausaGmao(),
				fichatecnicosgmao.getPausaAutoGmao(),
				fichatecnicosgmao.getGuidpartepadreayuda(),
				fichatecnicosgmao.getGuidparteseguido());
		return fichatecnicosgmao;
	}

	/**
	 * Updates a single row in the Fichatecnicos table.
	 * 
	 * @param fichatecnicos
	 *            Pagination
	 * @return Fichatecnicos
	 */
	public Fichatecnicosgmao update(Fichatecnicosgmao fichatecnicosgmao) {
		String query = "UPDATE FICHATECNICOSGMAO SET IDFITEC=?, IDTECNICO=?, ESTADOGMAO=?, FECHAESTADO=?, GUIDPADRE=?, GUIDSEGUIDO=? WHERE IDFICHA=? AND GUIDGMAO=?";
		this.jdbcTemplate.update(query, fichatecnicosgmao.getIdfichac(),
				fichatecnicosgmao.getIdtecnico(),
				fichatecnicosgmao.getEstadoGmao(),
				fichatecnicosgmao.getFechaEstadoGmao(),
				fichatecnicosgmao.getGuidpartepadreayuda(),
				fichatecnicosgmao.getGuidparteseguido(),
				fichatecnicosgmao.getIdficha(),
				fichatecnicosgmao.getGuidfichatecgmao());
		return fichatecnicosgmao;
	}

	public void actualizarTiempoPausaFicha(Fichatecnicosgmao fichatecnicosgmao) {
		String query = "UPDATE FICHATECNICOSGMAO SET TIEMPOPAUSA=? WHERE IDFICHA=? AND GUIDGMAO=?";
		this.jdbcTemplate.update(query, fichatecnicosgmao.getTiempoPausaGmao(),
				fichatecnicosgmao.getIdficha(),
				fichatecnicosgmao.getGuidfichatecgmao());
	}

	public Fichatecnicosgmao marcarPausaAutoFicha(
			Fichatecnicosgmao fichatecnicosgmao) {
		String query = "UPDATE FICHATECNICOSGMAO SET PAUSAAUTO=?, ESTADOGMAO=?,FECHAESTADO=? WHERE IDFICHA=? AND GUIDGMAO=?";
		this.jdbcTemplate.update(query, fichatecnicosgmao.getPausaAutoGmao(),
				fichatecnicosgmao.getEstadoGmao(),
				fichatecnicosgmao.getFechaEstadoGmao(),
				fichatecnicosgmao.getIdficha(),
				fichatecnicosgmao.getGuidfichatecgmao());
		return fichatecnicosgmao;
	}

	/**
	 * Finds a single row in the Fichatecnicos table.
	 * 
	 * @param fichatecnicos
	 *            Pagination
	 * @return Fichatecnicos
	 */
	@Transactional(readOnly = true)
	public Fichatecnicosgmao find(Fichatecnicosgmao fichatecnicosgmao) {
		String query = "SELECT t1.IDFITEC IDFITEC, t1.IDFICHA IDFICHA, t1.IDTECNICO IDTECNICO, t1.GUIDGMAO GUIDGMAO, t1.ESTADOGMAO ESTADOGMAO, t1.FECHAESTADO FECHAESTADO, t1.TIEMPOPAUSA TIEMPOPAUSA, t1.PAUSAAUTO PAUSAAUTO, t1.GUIDPADRE GUIDPADRE, t1.GUIDSEGUIDO GUIDSEGUIDO FROM FICHATECNICOSGMAO t1 WHERE t1.IDFICHA = ? AND IDTECNICO = ?  ";

		List<Fichatecnicosgmao> fichatecnicosgmaoList = this.jdbcTemplate
				.query(query, this.rwMap, fichatecnicosgmao.getIdficha(),
						fichatecnicosgmao.getIdtecnico());
		return (Fichatecnicosgmao) DataAccessUtils
				.uniqueResult(fichatecnicosgmaoList);
	}

	/**
	 * Finds a single row in the Fichatecnicos table.
	 * 
	 * @param fichatecnicos
	 *            Pagination
	 * @return Fichatecnicos
	 */
	@Transactional(readOnly = true)
	public Fichatecnicosgmao findFichaSinTecnico(
			Fichatecnicosgmao fichatecnicosgmao) {
		String query = "SELECT t1.IDFITEC IDFITEC, t1.IDFICHA IDFICHA, t1.IDTECNICO IDTECNICO, t1.GUIDGMAO GUIDGMAO, t1.ESTADOGMAO ESTADOGMAO, t1.FECHAESTADO FECHAESTADO, t1.TIEMPOPAUSA TIEMPOPAUSA, t1.PAUSAAUTO PAUSAAUTO,t1.GUIDPADRE GUIDPADRE, t1.GUIDSEGUIDO GUIDSEGUIDO FROM FICHATECNICOSGMAO t1 WHERE t1.IDFICHA = ? AND (t1.IDTECNICO is null OR t1.IDTECNICO = 0) AND (t1.IDFITEC is null OR t1.IDFITEC = 0)  ";

		List<Fichatecnicosgmao> fichatecnicosgmaoList = this.jdbcTemplate
				.query(query, this.rwMap, fichatecnicosgmao.getIdficha());
		return (Fichatecnicosgmao) DataAccessUtils
				.uniqueResult(fichatecnicosgmaoList);
	}

	/**
	 * Finds a single row in the Fichatecnicos table.
	 * 
	 * @param fichatecnicos
	 *            Pagination
	 * @return Fichatecnicos
	 */
	@Transactional(readOnly = true)
	public Fichatecnicosgmao findByGUID(Fichatecnicosgmao fichatecnicosgmao) {
		String query = "SELECT t1.IDFITEC IDFITEC, t1.IDFICHA IDFICHA, t1.IDTECNICO IDTECNICO, t1.GUIDGMAO GUIDGMAO, t1.ESTADOGMAO ESTADOGMAO, t1.FECHAESTADO FECHAESTADO, t1.TIEMPOPAUSA TIEMPOPAUSA, t1.PAUSAAUTO PAUSAAUTO,t1.GUIDPADRE GUIDPADRE, t1.GUIDSEGUIDO GUIDSEGUIDO FROM FICHATECNICOSGMAO t1 WHERE t1.GUIDGMAO = ? ";

		List<Fichatecnicosgmao> fichatecnicosgmaoList = this.jdbcTemplate
				.query(query, this.rwMap,
						fichatecnicosgmao.getGuidfichatecgmao());
		return (Fichatecnicosgmao) DataAccessUtils
				.uniqueResult(fichatecnicosgmaoList);
	}

	/**
	 * Finds a List of rows in the Fichatecnicos table.
	 * 
	 * @param fichatecnicos
	 *            Fichatecnicos
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Fichatecnicosgmao> findAll(Fichatecnicosgmao fichatecnicosgmao,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDFITEC IDFITEC,t1.IDFICHA IDFICHA,t1.IDTECNICO IDTECNICO,t1.GUIDGMAO GUIDGMAO, t1.ESTADOGMAO ESTADOGMAO, t1.FECHAESTADO FECHAESTADO, t1.TIEMPOPAUSA TIEMPOPAUSA, t1.PAUSAAUTO PAUSAAUTO, t1.GUIDPADRE GUIDPADRE, t1.GUIDSEGUIDO GUIDSEGUIDO ");
		query.append("FROM FICHATECNICOSGMAO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(fichatecnicosgmao);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Fichatecnicosgmao>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	@Transactional(readOnly = true)
	public List<Fichatecnicosgmao> findAllnoAsignadosMovilGmao(
			Fichatecnicosgmao fichatecnicosgmao, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDFITEC IDFITEC,t1.IDFICHA IDFICHA,t1.IDTECNICO IDTECNICO,t1.GUIDGMAO GUIDGMAO, t1.ESTADOGMAO ESTADOGMAO, t1.FECHAESTADO FECHAESTADO, t1.TIEMPOPAUSA TIEMPOPAUSA, t1.PAUSAAUTO PAUSAAUTO, t1.GUIDPADRE GUIDPADRE, t1.GUIDSEGUIDO GUIDSEGUIDO ");
		query.append("FROM FICHATECNICOSGMAO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(fichatecnicosgmao);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ESTADOGMAO is null ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Fichatecnicosgmao>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Fichatecnicos entity
	 * 
	 * @param fichatecnicos
	 *            Fichatecnicos Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Fichatecnicosgmao fichatecnicosgmao) {

		StringBuilder where = new StringBuilder(
				FichatecnicosgmaoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (fichatecnicosgmao != null
				&& fichatecnicosgmao.getIdfichac() != null) {
			where.append(" AND t1.IDFITEC = ?");
			params.add(fichatecnicosgmao.getIdfichac());
		}
		if (fichatecnicosgmao != null && fichatecnicosgmao.getIdficha() != null) {
			where.append(" AND t1.IDFICHA = ?");
			params.add(fichatecnicosgmao.getIdficha());
		}
		if (fichatecnicosgmao != null
				&& fichatecnicosgmao.getIdtecnico() != null) {
			where.append(" AND t1.IDTECNICO = ?");
			params.add(fichatecnicosgmao.getIdtecnico());
		}
		if (fichatecnicosgmao != null
				&& fichatecnicosgmao.getGuidfichatecgmao() != null) {
			where.append(" AND t1.GUIDGMAO = ?");
			params.add(fichatecnicosgmao.getGuidfichatecgmao());
		}
		if (fichatecnicosgmao != null
				&& fichatecnicosgmao.getEstadoGmao() != null) {
			where.append(" AND t1.ESTADOGMAO = ?");
			params.add(fichatecnicosgmao.getEstadoGmao());
		}
		if (fichatecnicosgmao != null
				&& fichatecnicosgmao.getFechaEstadoGmao() != null) {
			where.append(" AND t1.FECHAESTADO = ?");
			params.add(fichatecnicosgmao.getFechaEstadoGmao());
		}
		if (fichatecnicosgmao != null
				&& fichatecnicosgmao.getPausaAutoGmao() != null) {
			where.append(" AND t1.PAUSAAUTO = ?");
			params.add(fichatecnicosgmao.getPausaAutoGmao());
		}

		if (fichatecnicosgmao != null
				&& fichatecnicosgmao.getGuidpartepadreayuda() != null) {
			where.append(" AND t1.GUIDPADRE = ?");
			params.add(fichatecnicosgmao.getGuidpartepadreayuda());
		}

		if (fichatecnicosgmao != null
				&& fichatecnicosgmao.getGuidparteseguido() != null) {
			where.append(" AND t1.GUIDSEGUIDO = ?");
			params.add(fichatecnicosgmao.getGuidparteseguido());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	@Transactional(readOnly = true)
	public Fichatecnicosgmao findByIdFicha(Fichatecnicosgmao fichatecnicosgmao) {
		String query = "SELECT t1.IDFITEC IDFITEC, t1.IDFICHA IDFICHA, t1.IDTECNICO IDTECNICO, t1.GUIDGMAO GUIDGMAO, t1.ESTADOGMAO ESTADOGMAO, t1.FECHAESTADO FECHAESTADO, t1.TIEMPOPAUSA TIEMPOPAUSA, t1.PAUSAAUTO PAUSAAUTO,t1.GUIDPADRE GUIDPADRE, t1.GUIDSEGUIDO GUIDSEGUIDO FROM FICHATECNICOSGMAO t1 WHERE t1.IDFICHA = ? ";

		List<Fichatecnicosgmao> fichatecnicosgmaoList = this.jdbcTemplate
				.query(query, this.rwMap, fichatecnicosgmao.getIdficha());
		return (Fichatecnicosgmao) DataAccessUtils
				.uniqueResult(fichatecnicosgmaoList);
	}

	/**
	 * Removes a single row in the Fichatecnicosgmao table.
	 * 
	 * @param fichatecnicosgmao
	 *            Pagination
	 * @return
	 */
	public void remove(Fichatecnicosgmao fichatecnicosgmao) {
		String query = "DELETE FROM FICHATECNICOSGMAO WHERE IDFICHA=? AND GUIDGMAO=?";
		this.jdbcTemplate.update(query, fichatecnicosgmao.getIdficha(),
				fichatecnicosgmao.getGuidfichatecgmao());
	}

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

}