package com.ejie.aa20b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.Fichatecnico;
import com.ejie.aa20b.model.Partetecnicos;

/**
 * FichatecnicoDaoImpl generated by UDA, 07-abr-2015 11:48:09.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class FichatecnicoDaoImpl implements FichatecnicoDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Fichatecnico> rwMap = new RowMapper<Fichatecnico>() {
		public Fichatecnico mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Fichatecnico(resultSet.getInt("IDFITEC"),
					resultSet.getInt("IDFICHA"),
					resultSet.getLong("IDTECNICO"),
					resultSet.getLong("TIEMPOREAL"),
					resultSet.getString("FINAL"),
					resultSet.getString("OBSERVACIONES"),
					resultSet.getString("ENVIOMAIL"),
					resultSet.getString("ACEPTADA"),
					resultSet.getString("NOTAS_TEC"), null, null);
		}
	};
	private RowMapper<Fichatecnico> rwMapTecnicosFicha = new RowMapper<Fichatecnico>() {
		public Fichatecnico mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Fichatecnico fichaTecnico = new Fichatecnico();

			fichaTecnico.setIdfitec(resultSet.getInt("IDFITEC"));
			fichaTecnico.setIdficha(resultSet.getInt("IDFICHA"));
			fichaTecnico.setIdtecnico(resultSet.getLong("IDTECNICO"));
			fichaTecnico.setTiemporeal(resultSet.getLong("TIEMPOREAL"));
			fichaTecnico.setFinalizado(resultSet.getString("FINAL"));
			fichaTecnico.setObservaciones(resultSet.getString("OBSERVACIONES"));
			fichaTecnico.setNombre(resultSet.getString("NOMBRE"));
			fichaTecnico.setEnviomail(resultSet.getString("ENVIOMAIL"));
			fichaTecnico.setAceptada(resultSet.getString("ACEPTADA"));
			fichaTecnico.setMovilgmao(resultSet.getString("MOVILGMAO"));
			fichaTecnico.setEstadogmao(resultSet.getString("ESTADOGMAO"));
			fichaTecnico.setNotasTec(resultSet.getString("NOTAS_TEC"));

			return fichaTecnico;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Fichatecnico table.
	 * 
	 * @param fichatecnico
	 *            Pagination
	 * @return Fichatecnico
	 */
	public Fichatecnico add(Fichatecnico fichatecnico) {

		// Obtener el id correlativo
		Integer idCorrelativo = this.jdbcTemplate
				.queryForInt("SELECT FICHATECNICO_SEQ.NEXTVAL FROM DUAL");

		fichatecnico.setIdfitec(idCorrelativo);

		String query = "INSERT INTO FICHATECNICO (IDFITEC, IDFICHA, IDTECNICO, TIEMPOREAL, FINAL, OBSERVACIONES, ENVIO_MAIL, ACEPTADA,NOTAS_TEC) VALUES (?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, fichatecnico.getIdfitec(), fichatecnico
				.getIdficha(), fichatecnico.getIdtecnico(), fichatecnico
				.getTiemporeal(), fichatecnico.getFinalizado(), fichatecnico
				.getObservaciones(), fichatecnico.getEnviomail() == null ? "0"
				: fichatecnico.getEnviomail(), fichatecnico.getAceptada(),
				fichatecnico.getNotasTec());
		return fichatecnico;
	}

	/**
	 * Updates a single row in the Fichatecnico table.
	 * 
	 * @param fichatecnico
	 *            Pagination
	 * @return Fichatecnico
	 */
	public Fichatecnico update(Fichatecnico fichatecnico) {
		String query = "UPDATE FICHATECNICO SET IDFICHA=?, IDTECNICO=?, TIEMPOREAL=?, FINAL=?, OBSERVACIONES=?, ENVIO_MAIL=?, ACEPTADA=?, NOTAS_TEC=?  WHERE IDFITEC=? ";
		this.jdbcTemplate.update(query, fichatecnico.getIdficha(),
				fichatecnico.getIdtecnico(), fichatecnico.getTiemporeal(),
				fichatecnico.getFinalizado(), fichatecnico.getObservaciones(),
				fichatecnico.getEnviomail(), fichatecnico.getAceptada(),
				fichatecnico.getNotasTec(), fichatecnico.getIdfitec());
		return fichatecnico;
	}

	/**
	 * Updates a single row in the Fichatecnico table.
	 * 
	 * @param fichatecnico
	 *            Pagination
	 * @return Fichatecnico
	 */
	public Fichatecnico guardarNotas(Fichatecnico fichatecnico) {
		String query = "UPDATE FICHATECNICO SET OBSERVACIONES=? WHERE IDFITEC=? ";
		this.jdbcTemplate.update(query, fichatecnico.getObservaciones(),
				fichatecnico.getIdfitec());
		return fichatecnico;
	}

	/**
	 * Updates a single row in the Fichatecnico table.
	 * 
	 * @param fichatecnico
	 *            Pagination
	 * @return Fichatecnico
	 */
	public Fichatecnico guardarNotasTecnico(Fichatecnico fichatecnico) {
		String query = "UPDATE FICHATECNICO SET NOTAS_TEC=? WHERE IDFITEC=?";
		this.jdbcTemplate.update(query, fichatecnico.getNotasTec(),
				fichatecnico.getIdfitec());
		return fichatecnico;
	}

	/**
	 * Sumar el tiempo real de ejecucion de una ficha
	 * 
	 * @param idFicha
	 *            Integer
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long obtenerTiempoEjecucion(Integer idFicha) {
		StringBuilder query = new StringBuilder(
				"SELECT  SUM(t1.TIEMPOREAL) TIEMPOREAL FROM FICHATECNICO t1");

		StringBuilder where = new StringBuilder(" WHERE t1.IDFICHA=?");
		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(), idFicha);
	}

	/**
	 * Finds a single row in the Fichatecnico table.
	 * 
	 * @param fichatecnico
	 *            Pagination
	 * @return Fichatecnico
	 */
	@Transactional(readOnly = true)
	public Fichatecnico find(Fichatecnico fichatecnico) {
		String query = "SELECT t1.IDFITEC IDFITEC, t1.IDFICHA IDFICHA, t1.IDTECNICO IDTECNICO, t1.TIEMPOREAL TIEMPOREAL, t1.FINAL FINAL, t1.OBSERVACIONES OBSERVACIONES, t1.ENVIO_MAIL ENVIOMAIL, t1.ACEPTADA, t1.NOTAS_TEC NOTAS_TEC FROM FICHATECNICO t1  WHERE t1.IDFITEC = ?   AND t1.IDFICHA = ?   AND t1.IDTECNICO = ?   AND t1.TIEMPOREAL = ?   AND t1.FINAL = ?   AND t1.OBSERVACIONES = ?  ";

		List<Fichatecnico> fichatecnicoList = this.jdbcTemplate.query(query,
				this.rwMap, fichatecnico.getIdfitec(),
				fichatecnico.getIdficha(), fichatecnico.getIdtecnico(),
				fichatecnico.getTiemporeal(), fichatecnico.getFinalizado(),
				fichatecnico.getObservaciones());
		return (Fichatecnico) DataAccessUtils.uniqueResult(fichatecnicoList);
	}

	/**
	 * Finds a single row in the Fichatecnico table.
	 * 
	 * @param fichatecnico
	 *            Pagination
	 * @return Fichatecnico
	 */
	@Transactional(readOnly = true)
	public Fichatecnico obtenerFicha(Integer idFitec) {
		String query = "SELECT t1.IDFITEC IDFITEC, t1.IDFICHA IDFICHA, t1.IDTECNICO IDTECNICO, t1.TIEMPOREAL TIEMPOREAL, t1.FINAL FINAL, t1.OBSERVACIONES OBSERVACIONES, t1.ENVIO_MAIL ENVIOMAIL, t1.ACEPTADA, t1.NOTAS_TEC NOTAS_TEC FROM FICHATECNICO t1  WHERE t1.IDFITEC = ? ";

		List<Fichatecnico> fichatecnicoList = this.jdbcTemplate.query(query,
				this.rwMap, idFitec);
		return (Fichatecnico) DataAccessUtils.uniqueResult(fichatecnicoList);
	}

	/**
	 * Removes a single row in the Fichatecnico table.
	 * 
	 * @param fichatecnico
	 *            Pagination
	 * @return
	 */
	public void remove(Fichatecnico fichatecnico) {
		String query = "DELETE FROM FICHATECNICO WHERE IDFITEC=? AND IDFICHA=? AND IDTECNICO=? AND TIEMPOREAL=? AND FINAL=? AND OBSERVACIONES=? AND ENVIO_MAIL=? ";
		this.jdbcTemplate.update(query, fichatecnico.getIdfitec(),
				fichatecnico.getIdficha(), fichatecnico.getIdtecnico(),
				fichatecnico.getTiemporeal(), fichatecnico.getFinalizado(),
				fichatecnico.getObservaciones(), fichatecnico.getEnviomail());
	}

	/**
	 * Removes un tecnico asociado a una ficha.
	 * 
	 * @param fichatecnico
	 *            Fichatecnico
	 * @return
	 */
	public void eliminaTecnicoFicha(Fichatecnico fichatecnicos) {
		String query = "DELETE FROM FICHATECNICO WHERE IDFICHA=? AND IDTECNICO=?";
		this.jdbcTemplate.update(query, fichatecnicos.getIdficha(),
				fichatecnicos.getIdtecnico());
	}

	/**
	 * Finalizar/Abrir ficha tecnico.
	 * 
	 * @param fichatecnico
	 *            Fichatecnico
	 * @return Fichatecnico
	 */
	public Fichatecnico finalizarFichaTec(Fichatecnico fichatecnico) {
		String query = "UPDATE FICHATECNICO SET FINAL=? WHERE IDFITEC=?";

		// Si esta finalizado se abre. Si está abierto se finaliza.
		if (fichatecnico.getFinalizado().equals("1")) {
			fichatecnico.setFinalizado("0");
		} else {
			fichatecnico.setFinalizado("1");
		}

		this.jdbcTemplate.update(query, fichatecnico.getFinalizado(),
				fichatecnico.getIdfitec());
		return fichatecnico;
	}

	/**
	 * Finds a List of rows in the Fichatecnico table.
	 * 
	 * @param fichatecnico
	 *            Fichatecnico
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Fichatecnico> findAll(Fichatecnico fichatecnico,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDFITEC IDFITEC,t1.IDFICHA IDFICHA,t1.IDTECNICO IDTECNICO,t1.TIEMPOREAL TIEMPOREAL,t1.FINAL FINAL,t1.OBSERVACIONES OBSERVACIONES, t1.ENVIO_MAIL ENVIOMAIL, t1.ACEPTADA ACEPTADA, t1.NOTAS_TEC NOTAS_TEC ");
		query.append("FROM FICHATECNICO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(fichatecnico);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Fichatecnico>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Obtener los tecnicos asociados a la última ficha asociada a una máquina.
	 * 
	 * @param idmaquina
	 *            Long
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Fichatecnico> tecnicosUltimaFichaMaquina(Long idmaquina) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDFITEC IDFITEC,t1.IDFICHA IDFICHA,t1.IDTECNICO IDTECNICO,t1.TIEMPOREAL TIEMPOREAL,t1.FINAL FINAL,t1.OBSERVACIONES OBSERVACIONES, t1.ENVIO_MAIL ENVIOMAIL, t1.ACEPTADA ACEPTADA, t1.NOTAS_TEC NOTAS_TEC ");
		query.append(" FROM FICHATECNICO t1, TECNICOS t3 ");

		query.append(" WHERE t1.IDTECNICO=t3.IDTECNICO AND t1.IDFICHA= (select Max(t2.IDFICHA) from FICHA t2 where t2.IDMAQUINA=?) ");

		return (List<Fichatecnico>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, idmaquina);
	}

	/**
	 * Finds a List of rows in the Fichatecnico table.
	 * 
	 * @param fichatecnico
	 *            Fichatecnico
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Fichatecnico> tecnicosFichaGrid(Fichatecnico fichatecnico,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDFITEC IDFITEC,t1.IDFICHA IDFICHA,t1.IDTECNICO IDTECNICO, t2.NOMBRE NOMBRE, t2.MOVILGMAO MOVILGMAO, t1.TIEMPOREAL TIEMPOREAL,t1.FINAL FINAL,t1.OBSERVACIONES OBSERVACIONES, t1.ENVIO_MAIL ENVIOMAIL, t1.ACEPTADA ACEPTADA, t3.ESTADOGMAO ESTADOGMAO, t1.NOTAS_TEC NOTAS_TEC ");
		query.append("FROM FICHATECNICO t1, TECNICOS t2, FICHATECNICOSGMAO t3 ");

		StringBuilder where = new StringBuilder(
				" WHERE t1.IDTECNICO=t2.IDTECNICO AND t1.IDFICHA = t3.IDFICHA(+) AND t1.IDTECNICO = t3.IDTECNICO(+) AND t1.IDFICHA=?");
		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Fichatecnico>) this.jdbcTemplate.query(query.toString(),
				this.rwMapTecnicosFicha, fichatecnico.getIdficha());
	}

	/**
	 * Counts rows in the Fichatecnico table.
	 * 
	 * @param fichatecnico
	 *            Fichatecnico
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long tecnicosFichaGridCount(Fichatecnico fichatecnico) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM FICHATECNICO t1, TECNICOS t2 ");

		StringBuilder where = new StringBuilder(
				" WHERE t1.IDTECNICO=t2.IDTECNICO AND t1.IDFICHA=? ");
		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(),
				fichatecnico.getIdficha());
	}

	/**
	 * Obtener tecnicos asociados a una ficha.
	 * 
	 * @param idFicha
	 *            Integer
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Fichatecnico> obtenerTecnicosFichaAsociados(Integer idFicha) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDFITEC IDFITEC, t1.IDFICHA IDFICHA, t1.IDTECNICO IDTECNICO, t1.TIEMPOREAL TIEMPOREAL, t1.FINAL FINAL, t1.OBSERVACIONES OBSERVACIONES, t1.ENVIO_MAIL ENVIOMAIL, t1.ACEPTADA ACEPTADA, t1.NOTAS_TEC NOTAS_TEC, t2.NOMBRE NOMBRE, t2.MOVILGMAO MOVILGMAO, t3.ESTADOGMAO ESTADOGMAO FROM FICHATECNICO t1, TECNICOS t2, FICHATECNICOSGMAO t3");

		StringBuilder where = new StringBuilder(
				" WHERE t1.IDTECNICO=t2.IDTECNICO AND t1.IDFICHA = t3.IDFICHA(+) AND t1.IDTECNICO = t3.IDTECNICO(+) AND t1.IDFICHA=?");
		query.append(where);

		return (List<Fichatecnico>) this.jdbcTemplate.query(query.toString(),
				this.rwMapTecnicosFicha, idFicha);
	}

	/**
	 * Counts rows in the Fichatecnico table.
	 * 
	 * @param fichatecnico
	 *            Fichatecnico
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Fichatecnico fichatecnico) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM FICHATECNICO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(fichatecnico);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Fichatecnico table using like.
	 * 
	 * @param fichatecnico
	 *            Fichatecnico
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Fichatecnico> findAllLike(Fichatecnico fichatecnico,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDFITEC IDFITEC,t1.IDFICHA IDFICHA,t1.IDTECNICO IDTECNICO,t1.TIEMPOREAL TIEMPOREAL,t1.FINAL FINAL,t1.OBSERVACIONES OBSERVACIONES, t1.ENVIO_MAIL ENVIOMAIL, t1.ACEPTADA ACEPTADA, t1.NOTAS_TEC NOTAS_TEC ");
		query.append("FROM FICHATECNICO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(fichatecnico,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Fichatecnico>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Fichatecnico table using like.
	 * 
	 * @param fichatecnico
	 *            Fichatecnico
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Fichatecnico fichatecnico, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM FICHATECNICO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(fichatecnico,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Updates a single row in the Fichatecnico table.
	 * 
	 * @param idFicha
	 *            Integer
	 * @param idTecnico
	 *            Long
	 * @return
	 */
	public void marcarEnvioMail(Integer idFicha, Long idTecnico) {
		String query = "UPDATE FICHATECNICO SET ENVIO_MAIL='1' WHERE IDFICHA=? AND IDTECNICO=?";
		this.jdbcTemplate.update(query, idFicha, idTecnico);
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Fichatecnico entity
	 * 
	 * @param fichatecnico
	 *            Fichatecnico Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Fichatecnico fichatecnico) {

		StringBuilder where = new StringBuilder(
				FichatecnicoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (fichatecnico != null && fichatecnico.getIdfitec() != null) {
			where.append(" AND t1.IDFITEC = ?");
			params.add(fichatecnico.getIdfitec());
		}
		if (fichatecnico != null && fichatecnico.getIdficha() != null) {
			where.append(" AND t1.IDFICHA = ?");
			params.add(fichatecnico.getIdficha());
		}
		if (fichatecnico != null && fichatecnico.getIdtecnico() != null) {
			where.append(" AND t1.IDTECNICO = ?");
			params.add(fichatecnico.getIdtecnico());
		}
		if (fichatecnico != null && fichatecnico.getTiemporeal() != null) {
			where.append(" AND t1.TIEMPOREAL = ?");
			params.add(fichatecnico.getTiemporeal());
		}
		if (fichatecnico != null && fichatecnico.getFinalizado() != null) {
			where.append(" AND t1.FINAL = ?");
			params.add(fichatecnico.getFinalizado());
		}
		if (fichatecnico != null && fichatecnico.getObservaciones() != null) {
			where.append(" AND t1.OBSERVACIONES = ?");
			params.add(fichatecnico.getObservaciones());
		}
		if (fichatecnico != null && fichatecnico.getEnviomail() != null) {
			if (fichatecnico.getEnviomail().equals("1")) {
				where.append(" AND t1.ENVIO_MAIL = ?");
				params.add(fichatecnico.getEnviomail());
			} else if (fichatecnico.getEnviomail().equals("0")) {
				where.append(" AND t1.ENVIO_MAIL != 1");
			}
		}

		if (fichatecnico != null && fichatecnico.getAceptada() != null) {
			where.append(" AND t1.ACEPTADA = ?");
			params.add(fichatecnico.getAceptada());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Fichatecnico entity
	 * 
	 * @param fichatecnico
	 *            Fichatecnico Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Fichatecnico fichatecnico,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				FichatecnicoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (fichatecnico != null && fichatecnico.getIdfitec() != null) {
			where.append(" AND t1.IDFITEC = ?");
			params.add(fichatecnico.getIdfitec());
		}
		if (fichatecnico != null && fichatecnico.getIdficha() != null) {
			where.append(" AND t1.IDFICHA = ?");
			params.add(fichatecnico.getIdficha());
		}
		if (fichatecnico != null && fichatecnico.getIdtecnico() != null) {
			where.append(" AND t1.IDTECNICO = ?");
			params.add(fichatecnico.getIdtecnico());
		}
		if (fichatecnico != null && fichatecnico.getTiemporeal() != null) {
			where.append(" AND t1.TIEMPOREAL = ?");
			params.add(fichatecnico.getTiemporeal());
		}
		if (fichatecnico != null && fichatecnico.getFinalizado() != null) {
			where.append(" AND UPPER(t1.FINAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(fichatecnico.getFinalizado().toUpperCase() + "%");
			} else {
				params.add("%" + fichatecnico.getFinalizado().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.FINAL IS NOT NULL");
		}
		if (fichatecnico != null && fichatecnico.getObservaciones() != null) {
			where.append(" AND UPPER(t1.OBSERVACIONES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(fichatecnico.getObservaciones().toUpperCase() + "%");
			} else {
				params.add("%" + fichatecnico.getObservaciones().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.OBSERVACIONES IS NOT NULL");
		}
		if (fichatecnico != null && fichatecnico.getEnviomail() != null) {
			if (fichatecnico.getEnviomail().equals("1")) {
				where.append(" AND t1.ENVIO_MAIL = ?");
				params.add(fichatecnico.getEnviomail());
			} else if (fichatecnico.getEnviomail().equals("0")) {
				where.append(" AND t1.ENVIO_MAIL != 1");
			}
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
